

/* qddb/Lib/LibQddb/Init.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

Boolean Qddb_using_TCL = False;

void Qddb_Init _ANSI_ARGS_((void))
{
    uid_t		me;
    char                *datefmt;
#if defined(HAVE_SETRLIMIT) && defined(HAVE_GETRLIMIT)
    struct rlimit	lim;
#endif

    me = getuid();
#if defined(HAVE_SETRLIMIT) && defined(HAVE_GETRLIMIT)
#if defined(RLIMIT_DATA)
    getrlimit(RLIMIT_DATA, &lim);
#if defined(RLIM_INFINITY)
    if (me == 0)
	lim.rlim_cur = lim.rlim_max = RLIM_INFINITY;
    else
#endif
	lim.rlim_cur = lim.rlim_max;
    if (setrlimit(RLIMIT_DATA, &lim) == -1)
	perror("setrlimit RLIMIT_DATA");
#endif
#if defined(RLIMIT_STACK)
    getrlimit(RLIMIT_STACK, &lim);
#if defined(RLIM_INFINITY)
    if (me == 0)
	lim.rlim_cur = lim.rlim_max = RLIM_INFINITY;
    else
#endif
	lim.rlim_cur = lim.rlim_max;
    if (setrlimit(RLIMIT_STACK, &lim) == -1)
	perror("setrlimit RLIMIT_STACK");
#endif
#if defined(RLIMIT_RSS)
    getrlimit(RLIMIT_RSS, &lim);
#if defined(RLIM_INFINITY)
    if (me == 0)
	lim.rlim_cur = lim.rlim_max = RLIM_INFINITY;
    else
#endif
	lim.rlim_cur = lim.rlim_max;
    if (setrlimit(RLIMIT_RSS, &lim) == -1)
	perror("setrlimit RLIMIT_RSS");
#endif
#if defined(RLIMIT_FSIZE)
    getrlimit(RLIMIT_FSIZE, &lim);
#if defined(RLIM_INFINITY)
    if (me == 0)
	lim.rlim_cur = lim.rlim_max = RLIM_INFINITY;
    else
#endif
	lim.rlim_cur = lim.rlim_max;
    if (setrlimit(RLIMIT_FSIZE, &lim) == -1)
	perror("setrlimit RLIMIT_FSIZE");
#endif
#if defined(RLIMIT_CPU)
    getrlimit(RLIMIT_CPU, &lim);
#if defined(RLIM_INFINITY)
    if (me == 0)
	lim.rlim_cur = lim.rlim_max = RLIM_INFINITY;
    else
#endif
	lim.rlim_cur = lim.rlim_max;
    if (setrlimit(RLIMIT_CPU, &lim) == -1)
	perror("setrlimit RLIMIT_CPU");
#endif
#if defined(RLIMIT_NOFILE)
    getrlimit(RLIMIT_NOFILE, &lim);
#if defined(RLIM_INFINITY)
    if (me == 0 && lim.rlim_cur != lim.rlim_max) {
        lim.rlim_cur = lim.rlim_max = RLIM_INFINITY;
	if (setrlimit(RLIMIT_NOFILE, &lim) == -1)
	    perror("setrlimit RLIMIT_NOFILE");
    } else
#endif
    if (lim.rlim_cur != lim.rlim_max) {
        lim.rlim_cur = lim.rlim_max;
	if (setrlimit(RLIMIT_NOFILE, &lim) == -1)
	    perror("setrlimit RLIMIT_NOFILE");
    }
#endif
#endif
    if (strcmp(qddb_default_date_format, "%m/%d/%y") == 0) {
	qddb_datestyle = QDDB_DATE_STYLE_US;
    } else {
	qddb_datestyle = QDDB_DATE_STYLE_EUROPEAN;
    }
    datefmt = getenv("QDDB_DATESTYLE");
    if (datefmt != NULL) {
	if (strcmp(datefmt, "us") == 0) {
	    qddb_datestyle = QDDB_DATE_STYLE_US;
	    qddb_default_date_format = "%m/%d/%y";
	} else if (strcmp(datefmt, "european") == 0) {
	    qddb_datestyle = QDDB_DATE_STYLE_EUROPEAN;
	    qddb_default_date_format = "%d/%m/%y";
	}
    }
}
