#!/bin/sh
# The next line restarts using qwish \
exec QDDB_BIN_DIR/qwish -f QDDB_BIN_DIR/xqddb "$@"

# qddb.tcl
#
# This hack is a fairly complex set of routines that uses qddb_wish
# to generically generate a user interface from only the Qddb Schema

#set gv_debug on

# gv_mode_variable: {"Search Mode", "Add Mode", "Change Mode" or "Read-only Mode"}
# gv_status_variable: messages
# gv_tuple: current tuple in the entry view
# gv_view: the current entry view
# gv_schema: the current schema
# gv_attr: array that holds gv_attr(attribute.name) bound to the current view.
# gv_default_font: font in use.
# gv_attr_pairs: a list of { attribute.name gv_attr(attribute.name) } pairs
# gv_tuple_changed: 1 if the current tuple needs to be saved
# gv_searchbox_variable: holds the general searchbox value
# gv_lastsearch: holds the tuple/row/value triples from the last search
# gv_menupost: array whose names hold whether a pull-down menu is up or not.
#              allows toggling up/down with accelerator key.
# gv_schema_depth: the depth of the schema (ex: a ( b (c d e) ) has depth 3)
# gv_attr_vnames: verbose names of leaves (array)
# gv_expand: list of all expandable attributes

set gv_qddb_version $qddb_version

set gv_qddb_lib_dir ${qddb_library}/xqddb
catch [list source [glob ~]/.qddb_wishrc]
if {![info exists gv_default_font]} {
    set gv_default_font 9x15bold
}
if {[file exists [info library]/init.tcl]} {
    source [info library]/init.tcl
    lappend auto_path $tk_library
}
lappend auto_path $gv_qddb_lib_dir

proc do_display_schema {w name mylist frame_num} {
    global gv_attr gv_default_font gv_entryname gv_debug 
    global gv_qddb_lib_dir gv_attr_pairs gv_schema_depth
    global gv_attr_vnames gv_expand gv_config gv_thack

    foreach i $mylist {
	if {[string compare $name ""] == 0} {
	    set newname [lindex $i 0]
	} else {
	    set newname $name.[lindex $i 0]
	}
	if {[info exists gv_debug]} {
	    puts "newname is '$newname'"
	}
	set vn [lindex [lindex $i 1] 0]
	if {[string compare $vn ""] == 0} {
	    set vn [lindex $i 0]
	}
	if {[llength [lindex $i 2]] > 0} {
	    if {[info exists gv_debug]} {
		puts "doing label frame $newname"
	    }
	    set f $w.f$frame_num
	    incr frame_num
	    frame $f -relief raised -bd 2
	    pack $f -side top -anchor nw -expand on -fill both
            if {[string compare [tk colormodel .] "monochrome"] == 0} {
                label $f.l -text $vn -font $gv_default_font -anchor e
            } else {
                label $f.l -text $vn -font $gv_default_font -fg deeppink -anchor e
            }
	    pack $f.l -expand on -fill x -side left -anchor nw
	    if {[string compare [lindex [lindex $i 1] 1] yes] == 0} {
                lappend gv_expand $newname
		if {[string compare "[info commands pinfo]" ""] == 0} {
		    button $f.new -bitmap @$gv_qddb_lib_dir/pixmaps/into_folder.xbm -command \
			[list gp_newinst $newname]
		    button $f.view -bitmap @$gv_qddb_lib_dir/pixmaps/outof_folder.xbm -command \
			[list gp_selinst $newname]
		    button $f.del -bitmap @$gv_qddb_lib_dir/pixmaps/skull.xbm -command \
			[list gp_delinst $newname]
		} else {
		    button $f.new -bitmap @$gv_qddb_lib_dir/pixmaps/into_folder.xpm -command \
			[list gp_newinst $newname]
		    button $f.view -bitmap @$gv_qddb_lib_dir/pixmaps/outof_folder.xpm -command \
			[list gp_selinst $newname]
		    button $f.del -bitmap @$gv_qddb_lib_dir/pixmaps/skull.xpm -command \
			[list gp_delinst $newname]
		}
		pack $f.new $f.view $f.del -side left -anchor nw
	    }
	    do_display_schema $f $newname [lindex $i 2] 0
	} else {
	    if {[info exists gv_debug]} {
		puts "doing entry frame $newname"
	    }
            if {[string compare $vn ""] != 0} {
                set gv_attr_vnames($newname) $vn
            }
	    set f $w.f$frame_num
	    frame $f -relief raised -bd 2
	    pack $f -side top -anchor ne -expand on -fill both
	    if {[info exists gv_config(disp,$newname)]} {
		switch -exact $gv_config(disp,$newname) {
		    Entry {
			entry $f.e -textvariable gv_attr($newname) -font $gv_default_font \
			    -width $gv_config(conf,entry_width) -relief sunken -bd 2 -exportselection on
			pack $f.e -side right -anchor ne -pady 3
		    }
		    Text {
			if {![info exists gv_config(dispval,$newname)] || \
				[catch "expr int($gv_config(dispval,$newname))"]} {
			    set gv_config(dispval,$newname) 4
			}
			text $f.e -height $gv_config(dispval,$newname) -font $gv_default_font \
			    -width $gv_config(conf,entry_width) -relief sunken -bd 2 -exportselection on \
			    -yscroll [list $f.s set] -wrap word
			pack $f.e -side right -anchor ne
			scrollbar $f.s -orient vertical -command [list $f.e yview]
			pack $f.s -side right -fill y -anchor ne
			set gv_attr($newname) {}
		    }
		}
	    } else {
		entry $f.e -textvariable gv_attr($newname) -font $gv_default_font \
		    -width $gv_config(conf,entry_width) -relief sunken -bd 2 -exportselection on
		pack $f.e -side right -anchor ne -pady 3
	    }
	    if {[string compare [lindex [lindex $i 1] 1] yes] == 0} {
                lappend gv_expand $newname
		if {[string compare "[info commands pinfo]" ""] == 0} {
		    button $f.new -bitmap @$gv_qddb_lib_dir/pixmaps/into_folder.xbm -command \
			[list gp_newinst $newname]
		    button $f.view -bitmap @$gv_qddb_lib_dir/pixmaps/outof_folder.xbm -command \
			[list gp_selinst $newname]
		    button $f.del -bitmap @$gv_qddb_lib_dir/pixmaps/skull.xbm -command \
			[list gp_delinst $newname]
		} else {
		    button $f.new -bitmap @$gv_qddb_lib_dir/pixmaps/into_folder.xpm -command \
			[list gp_newinst $newname]
		    button $f.view -bitmap @$gv_qddb_lib_dir/pixmaps/outof_folder.xpm -command \
			[list gp_selinst $newname]
		    button $f.del -bitmap @$gv_qddb_lib_dir/pixmaps/skull.xpm -command \
			[list gp_delinst $newname]
		}
		pack $f.del $f.view $f.new -anchor ne -side right
	    }
	    label $f.l -text $vn -font $gv_default_font -anchor e
	    pack $f.l -side right -anchor ne -expand on -fill x
	    lappend gv_attr_pairs [list $newname gv_attr($newname)]
	    set gv_entryname($newname) $f.e
	    incr frame_num
	}
    }
}

if {[catch "qddb_schema open [lindex $argv 0]" gv_schema]} {
    puts $gv_schema
    exit 0
}
#set gv_schema [qddb_schema open [lindex $argv 0]]
set gv_schema_name [qddb_schema path $gv_schema]
gp_read_config
if {![info exists gv_config(conf,entry_width)]} {
    set gv_config(conf,entry_width) 40
}

frame .top
pack .top
frame .top.buttons1
pack .top.buttons1 -side top -expand on -fill x
set x .top.buttons1
menubutton $x.dismiss -text "Quit" -relief raised -bd 2 \
	-underline 0 -font "$gv_default_font"
pack $x.dismiss -side left
gp_bind_menubutton $x.dismiss q {Entry Text} {gp_exit}

menubutton $x.save -text Save -relief raised -bd 2 \
    -underline 2 -font "$gv_default_font"
pack $x.save -side left
gp_bind_menubutton $x.save v {Entry Text} {gp_save_current}
set gv_save_button $x.save

menubutton $x.search_mode -text "SearchMode" -relief raised -bd 2 \
    -underline 0 -font "$gv_default_font" 
pack $x.search_mode -side left 
gp_bind_menubutton $x.search_mode s {Entry Text} {gp_search_mode}
set gv_searchmode_button $x.search_mode

menubutton $x.search -text "Search" -relief raised -bd 2 \
    -underline 1 -font "$gv_default_font"
pack $x.search -side left
gp_bind_menubutton $x.search e {Entry Text} {gp_search}
set gv_search_button $x.search

menubutton $x.add_mode -text "AddMode" -relief raised -bd 2 \
    -underline 0 -font "$gv_default_font"
pack $x.add_mode -side left
gp_bind_menubutton $x.add_mode a {Entry Text} {gp_add_mode}
set gv_addmode_button $x.add_mode

menubutton $x.last -text "Results" -relief raised -bd 2  \
    -font "$gv_default_font" -underline 0
pack $x.last -side left
gp_bind_menubutton $x.last r {Entry Text} {gp_lastsearch}
set gv_results_button $x.last
$gv_results_button configure -state disabled

menubutton $x.clear -text "Clear" -relief raised -bd 2  \
    -font "$gv_default_font" -underline 1
pack $x.clear -side left
gp_bind_menubutton $x.clear l {Entry Text} {gp_clearscreen}
set gv_clear_button $x.clear

menubutton $x.undo -text "Undo" -relief raised -bd 2  \
    -font "$gv_default_font" -underline 0
pack $x.undo -side left
gp_bind_menubutton $x.undo u {Entry Text} {gp_undochanges}
set gv_undo_button $x.undo

menubutton $x.delete -text "Delete" -relief raised -bd 2  \
    -font "$gv_default_font" -underline 4
pack $x.delete -side left
gp_bind_menubutton $x.delete t {Entry Text} {gp_deletetuple}
set gv_delete_button $x.delete
$x.delete configure -state disabled

menubutton $x.help -text "Help" -relief raised -bd 2 -font "$gv_default_font" \
    -menu $x.help.menu
pack $x.help -side right
#gp_bind_menubutton $x.help h {Entry Text} {}

menu $x.help.menu -font "$gv_default_font"
$x.help.menu add command -accelerator {<Alt-Ctrl-A>} -label {About Qddb...} \
    -font "$gv_default_font" -command {gp_AboutBox}
bind Entry <Alt-Control-a> {gp_AboutBox}
bind Text <Alt-Control-a> {gp_AboutBox}

$x.help.menu add command -accelerator {<Alt-Ctrl-F>} -label {Frequently Asked Questions} \
    -font "$gv_default_font" -command {gp_faqBox}
bind Entry <Alt-Control-f> {gp_faqBox}
bind Text <Alt-Control-f> {gp_faqBox}

$x.help.menu add command -accelerator {<Alt-Ctrl-M>} -label {Manual Page} \
    -font "$gv_default_font" -command {gp_manPage}
bind Entry <Alt-Control-m> {gp_manPage}
bind Text <Alt-Control-m> {gp_manPage}

menubutton $x.configure -text "Options" -relief raised -bd 2 -font "$gv_default_font" \
    -menu $x.configure.menu
pack $x.configure -side right

menu $x.configure.menu -font "$gv_default_font"

$x.configure.menu add command -accelerator {<Alt-Ctrl-R>} -label {Read template} \
    -underline 0 -font "$gv_default_font" -command {gp_readtemplate}
bind Entry <Alt-Control-r> [list $x.configure.menu invoke 0]
bind Text <Alt-Control-r> [list $x.configure.menu invoke 0]
bind Menu <Alt-Control-r> [list $x.configure.menu invoke 0]

$x.configure.menu add command -accelerator {<Alt-Ctrl-W>} -label {Write template} \
    -underline 0 -font "$gv_default_font" -command {gp_writetemplate}
bind Entry <Alt-Control-w> [list $x.configure.menu invoke 1]
bind Text <Alt-Control-w> [list $x.configure.menu invoke 1]
bind Menu <Alt-Control-w> [list $x.configure.menu invoke 1]

$x.configure.menu add command -accelerator {<Alt-Ctrl-L>} -label {Insert Last template} \
    -underline 7 -font "$gv_default_font" -command {gp_lasttemplate}
bind Entry <Alt-Control-l> [list $x.configure.menu invoke 2]
bind Text <Alt-Control-l> [list $x.configure.menu invoke 2]
bind Menu <Alt-Control-l> [list $x.configure.menu invoke 2]

set gv_template_menu $x.configure.menu
if {![info exists gv_current_template] || ![file readable $gv_current_template]} {
	set gv_current_template ""
}
proc gp_template_state {{rw read} {e disabled}} {
    global gv_template_menu
    switch -exact $rw {
	read {$gv_template_menu entryconfigure 0 -state $e}
	last {$gv_template_menu entryconfigure 2 -state $e}
	write {$gv_template_menu entryconfigure 1 -state $e}
    }
}

$x.configure.menu add cascade -label {Configuration} \
    -font "$gv_default_font" -menu $x.configure.config_menu

menu $x.configure.config_menu -font $gv_default_font

$x.configure.config_menu add command -accelerator {<Ctrl-S>} -label {Save personal configuration} \
    -underline 0 -font "$gv_default_font" -command {gp_save_config}
bind Entry <Control-s> [list $x.configure.config_menu invoke 0]
bind Text <Control-s> [list $x.configure.config_menu invoke 0]
bind Menu <Control-s> [list $x.configure.config_menu invoke 0]

$x.configure.config_menu add check -accelerator {<Ctrl-V>} -label {Auto-save personal configuration} \
    -variable gv_config(conf,auto_save_config) \
    -underline 7 -font "$gv_default_font"
bind Entry <Control-v> [list $x.configure.config_menu invoke 1]
bind Text <Control-v> [list $x.configure.config_menu invoke 1]
bind Menu <Control-v> [list $x.configure.config_menu invoke 1]

$x.configure.config_menu add command -accelerator {<Ctrl-G>} -label {Save global configuration} \
    -underline 5 -font "$gv_default_font" -command {gp_save_config global}
bind Entry <Control-g> [list $x.configure.config_menu invoke 2]
bind Text <Control-g> [list $x.configure.config_menu invoke 2]
bind Menu <Control-g> [list $x.configure.config_menu invoke 2]

$x.configure.config_menu add command -accelerator {<Ctrl-R>} -label {Search Results} \
    -underline 7 -font "$gv_default_font" -command "
    gp_config_box [list \$search\$]
"
bind Entry <Control-r> [list $x.configure.config_menu invoke 3]
bind Text <Control-r> [list $x.configure.config_menu invoke 3]
bind Menu <Control-r> [list $x.configure.config_menu invoke 3]

$x.configure.config_menu add command -accelerator {<Ctrl-C>} -label {Instances} \
    -underline 6 -font "$gv_default_font" -command {gp_instance_config}
bind Entry <Control-c> [list $x.configure.config_menu invoke 4]
bind Text <Control-c> [list $x.configure.config_menu invoke 4]
bind Menu <Control-c> [list $x.configure.config_menu invoke 4]

# SEPARATOR
$x.configure.config_menu add sep

$x.configure.config_menu add command -accelerator {<Ctrl-O>} -label {Fonts} \
    -underline 1 -font "$gv_default_font" -command {gp_sel_fonts}
bind Entry <Control-o> [list $x.configure.config_menu invoke 6]
bind Menu <Control-o> [list $x.configure.config_menu invoke 6]

$x.configure.config_menu add command -accelerator {<Ctrl-T>} -label {Entry Types} \
    -underline 2 -font "$gv_default_font" -command {gp_entry_config}
bind Entry <Control-t> [list $x.configure.config_menu invoke 7]
bind Text <Control-t> [list $x.configure.config_menu invoke 7]
bind Menu <Control-t> [list $x.configure.config_menu invoke 7]


$x.configure.config_menu add cascade -label {Entry box width} \
    -font "$gv_default_font" -menu $x.configure.config_menu.boxmenu

menu $x.configure.config_menu.boxmenu -font $gv_default_font
for {set i 1} {$i < 10} {incr i} {
    $x.configure.config_menu.boxmenu add radio -font $gv_default_font -accelerator "<Ctrl-$i>" \
	-underline 0 -label "[expr $i * 10] characters" -value [expr $i * 10] \
	-variable gv_config(conf,entry_width)
    bind Entry <Control-Key-$i> [list $x.configure.config_menu.boxmenu invoke [expr $i - 1]]
    bind Text <Control-Key-$i> [list $x.configure.config_menu.boxmenu invoke [expr $i - 1]]
    bind Menu <Control-Key-$i> [list $x.configure.config_menu.boxmenu invoke [expr $i - 1]]
}
trace variable gv_config(conf,entry_width) w gp_redo_widths


# SEPARATOR
$x.configure.config_menu add sep

$x.configure.config_menu add check -accelerator {<Ctrl-L>} -label {Auto-clear} \
    -variable gv_config(conf,auto_clear) \
    -underline 6 -font "$gv_default_font"
bind Entry <Control-l> [list $x.configure.config_menu invoke 10]
bind Text <Control-l> [list $x.configure.config_menu invoke 10]
bind Menu <Control-l> [list $x.configure.config_menu invoke 10]

frame .top.mode -relief flat -bd 0
pack .top.mode -side top -anchor nw -expand on -fill x
if {[string compare [tk colormodel .] "monochrome"] == 0} {
    label .top.mode.label -relief raised -bd 2 -textvariable gv_mode_variable \
        -font "$gv_default_font"
} else {
    label .top.mode.label -fg red -relief raised -bd 2 -textvariable gv_mode_variable \
        -font "$gv_default_font"
}
pack .top.mode.label -side top -anchor nw -expand on -fill x

frame .top.status -relief flat -bd 0
pack .top.status -side top -anchor nw -expand on -fill x
if {[string compare [tk colormodel .] "monochrome"] == 0} {
    label .top.status.label -relief raised -bd 2 -textvariable gv_status_variable \
        -font "$gv_default_font"
} else {
    label .top.status.label -fg red -relief raised -bd 2 -textvariable gv_status_variable \
        -font "$gv_default_font"
}
pack .top.status.label -side left -anchor nw -expand on -fill x
set gv_status_variable "Ready to search"
set gv_status_msg ""

proc gp_reset_statusvar {w n1 n2 op} {
    catch "destroy $w"
    catch "destroy .statusmsg"
}
proc gp_display_statusmsg {} {
    global gv_status_msg gv_config gv_default_font

    if {[winfo exists .statusmsg]} {
	catch "destroy .statusmsg"
    }
    toplevel .statusmsg
    wm title .statusmsg "More Status Message"
    set x .statusmsg.f
    frame $x
    pack $x -expand on -fill both
    bind .statusmsg <Configure> {set gv_config(geom,\$statusmsg\$) [wm geometry .statusmsg]}
    message $x.msg -textvariable gv_status_msg -font $gv_default_font -justify center \
	-anchor n -padx 20 -pady 20 -width 2i
    pack $x.msg -side top
    button $x.but -text "Ok" -command {
	set gv_config(geom,\$statusmsg\$) [wm geometry .statusmsg]
	destroy .statusmsg
    }
    pack $x.but -side bottom -expand on -fill x
    if {[info exists gv_config(geom,\$statusmsg\$)]} {
	set a [lrange [split $gv_config(geom,\$statusmsg\$) +] 1 2]
	wm geometry .statusmsg +[lindex $a 0]+[lindex $a 1]
    }
}

proc gp_reset_statusmsg {w w2 n1 n2 op} {
    global gv_default_font

    button $w -text "more..." -font $gv_default_font
    pack $w -after $w2 -side right
    if {[string compare [tk colormodel .] "monochrome"] == 0} {
	$w configure [lindex [. configure -fg] 4] -relief raised
    } else {
	$w configure -fg red -relief raised
    }
    $w configure -activebackground [lindex [$w configure -activebackground] 3]
    $w configure -activeforeground [lindex [$w configure -activeforeground] 3]
    bind $w <ButtonPress-1> "$w configure -relief sunken"
    bind $w <ButtonRelease-1> "
        $w configure -relief raised
        gp_display_statusmsg
    "
}
trace variable gv_status_variable w {gp_reset_statusvar .top.status.b}
trace variable gv_status_msg w {gp_reset_statusmsg .top.status.b .top.status.label}

frame .top.searchbox
pack .top.searchbox -expand on -fill x
if {[string compare [tk colormodel .] "monochrome"] == 0} {
    button .top.searchbox.label -text "Search for" -font $gv_default_font -relief flat
} else {
    button .top.searchbox.label -text "Search for" -fg purple -font $gv_default_font -relief flat
}
set tl .top.searchbox.label
$tl configure -activebackground [lindex [$tl configure -background] 4]
$tl configure -activeforeground [lindex [$tl configure -foreground] 4]
bind .top.searchbox.label <ButtonPress-1> {gp_nullop}
bind .top.searchbox.label <ButtonRelease-1> {gp_nullop}
pack .top.searchbox.label -side left -anchor nw
entry .top.searchbox.entry -relief sunken -bd 2 -font $gv_default_font -textvariable gv_searchbox_variable
pack .top.searchbox.entry -side right -anchor nw -expand on -fill x
focus .top.searchbox.entry
bind .top.searchbox.entry "<Key-Return>" "gp_search"
set gv_searchbox_name .top.searchbox.entry
set gv_searchbox_label .top.searchbox.label
set x_entry $gv_searchbox_name
unset x_entry

wm withdraw .
set can .top.canvas
canvas $can -yscroll {.top.scroll set}
frame $can.schema
pack $can -side left

scrollbar .top.scroll -orient vertical -command [list $can yview]
pack .top.scroll -side right -expand on -fill y -anchor e

wm title . "xqddb ([file tail [qddb_schema path $gv_schema]])"

do_display_schema "$can.schema" "" [qddb_schema print $gv_schema] 0

gp_canv_fit .top $can $can.schema
$can create window 0 0 -anchor nw -window $can.schema

if {[info exists gv_config(maingeom)]} {
    set x [split $gv_config(maingeom) +]
    set y [lindex $x 2]
    set height [lindex [split [lindex $x 0] x] 1]
    set x [lindex $x 1]
    set curwidth [lindex [split [lindex [split [winfo geometry .] +] 0] x] 0]
    update idletasks
    wm geometry . ${curwidth}x${height}+${x}+${y}
}
update idletasks
wm iconbitmap . @$gv_qddb_lib_dir/pixmaps/qddb2.xbm
wm deiconify .
set gv_tuple [qddb_tuple new $gv_schema]
set gv_view [qddb_view define $gv_tuple $gv_attr_pairs]
set gv_lastsearch {}
gp_bindent
gp_enable .
set gv_cutbuffer ""
set gv_mode_variable ""
gp_search_mode
bind . <Configure> [list gp_resize %h %w]
set gv_tuple_changed 0

if {![info exists gv_commands(lpr)]} {
    if {[catch "exec which lpr" ans] == 0} {
	set gv_commands(lpr) "$ans -h"
    } elseif {[catch "exec which lp" ans] == 0} {
	set gv_commands(lpr) "$ans"
    }
}
if {![info exists gv_commands(pr)]} {
    if {[catch "exec which pr" ans] == 0} {
	set gv_commands(pr) $ans
    }
}

