# qddb/TkUtils/scripts/gen-utils.tcl

proc gp_set_global_var {var val} {
    global $var

    return [set $var $val]
}

proc gp_get_global_var {var} {
    global $var
    
    return [set $var]
}

# gp_dump_var -- dump contents of a variable to the stdout
proc gp_dump_var {var} {
    upvar $var x

    if {[info exists x]} {
	puts "$var = '$x'"
    } else {
	puts "$var doesn't exist"
    }
}

proc gp_def_listbox {w labels ws ht} {
    global gv_default_font

    set x 0
    foreach i $labels {
        set t ${w}.f${x}
        frame $t
        pack $t -side left
        if {[string compare [tk colormodel .] "monochrome"] == 0} {
            label $t.a$x -text [lindex $labels $x] -font $gv_default_font \
                -width [lindex $ws $x] -relief raised
        } else {
            label $t.a$x -text [lindex $labels $x] -font $gv_default_font -bg grey80 \
                -width [lindex $ws $x] -relief raised
        }
        pack $t.a$x -side top
        listbox $t.l$x -geometry [lindex $ws $x]x$ht -font $gv_default_font \
		-yscroll [list $w.scrollbar set] -relief raised -setgrid on \
                -exportselection off
        pack $t.l$x -side top
        lappend boxes $t.l$x
	incr x
    }
    scrollbar $w.scrollbar -relief raised -command [list gp_yview_listbox $boxes]
    pack $w.scrollbar -side right -expand on -fill y
    foreach i $boxes {
        bind $i <Button-1> [list gp_select_listbox %y $boxes]
        bind $i <B1-Motion> [list gp_select_listbox %y $boxes]
        bind $i <Key-Up> [list gp_selectkey_listbox $w $w.scrollbar {- 1} $boxes]
        bind $i <Key-Down> [list gp_selectkey_listbox $w $w.scrollbar {+ 1} $boxes]
        bind $i <B2-Motion> [list gp_scan_listbox %x %y $boxes]
    }
    return $boxes
}

proc gp_scan_listbox {x y boxes} {
    return
    foreach i $boxes {
	$i scan dragto $x $y
    }
}

proc gp_yview_listbox {lists line} {
    foreach i $lists {
        $i yview $line
    }
    update idletasks
}

proc gp_select_listbox {y boxes} {
    foreach i $boxes {
        $i select from [$i nearest $y]
        $i select to [$i nearest $y]
    }
    update idletasks
}

proc gp_selectkey_listbox {w s y boxes} {
    set toplevel [winfo parent $w]
    set ht [wm geometry $toplevel]
    set ht [lindex [split [lindex [split $ht "+"] 0] "x"] 1]
    foreach i $boxes {
        set j [expr [$i curselection] $y]
        $i select from $j
        $i select to $j
        set n0 [$i nearest 0]
        set k [expr $n0 + $ht - 1]
        if {$n0 > $j} {
            $i yview $j
        } elseif {$k < $j} {
            $i yview [expr $j - $ht + 1]
        }
    }
    update idletasks
}

proc gp_append_listbox {w items widths} {
    set x 0
    foreach i $items {
        $w.f$x.l$x insert end [string range $i 0 [lindex $widths $x]]
        incr x
    }
}

proc gp_clear_listbox {w items} {
    set x 0
    foreach i $items {
        $w.f$x.l$x insert end [lindex $items $x]
        incr x
    }
}

proc hsd_listbox {w name title list} {
    frame $w.$name
    pack $w.$name -side top -expand on -fill both
    set x $w.$name
    scrollbar $x.scrollbar -command "$x.listbox yview" -relief raised
    pack $x.scrollbar -side right -fill y
    listbox $x.listbox -yscroll "$x.scrollbar set" -relief raised -setgrid on
    pack $x.listbox -side left -expand on -fill both
    set max 0
    foreach i $list {
        set len [string length $i]
        if {$max < $len} {
            set max $len
        }
    $w.$name.listbox insert end $i
    }
    incr max 5
    $w.$name.listbox configure -geometry ${max}x10
    tk_listboxSingleSelect $x.listbox
    hsd_listbox_bind_keys $x
}

proc hsd_listbox_set_scrollbar {listbox totalUnits windowUnits firstUnit lastUnit which_way} {
    set x [$listbox.listbox curselection]
    set oldx $x
    if {"$which_way" == "up"} {
	if {$x > 0} {
	    incr x -1
	}
    } else {
	if {$x < [expr [$listbox.listbox size] - 1]} {
	    incr x
	}
    }
    if {[$listbox.listbox nearest 0] == $oldx && $x < $oldx} {
	$listbox.listbox yview $x
    } elseif {[$listbox.listbox nearest [winfo height $listbox.listbox]] <= $oldx && $x > $oldx} {
	set geom [$listbox.listbox configure -geometry]
        set lines [lindex $geom 4]
        set lines [lindex [split $lines "x"] 1]
	$listbox.listbox yview [expr $x - [expr $lines - 1]]
    }
    $listbox.listbox select from $x
}


proc hsd_listbox_bind_keys {listbox {otherw ""}} {
    foreach w [concat $listbox $otherw] {
	scan "[$listbox.scrollbar get]" "%d %d %d %d" totalUnits windowUnits firstUnit lastUnit
	bind $w <KeyPress-Up> "
            hsd_listbox_set_scrollbar $listbox $totalUnits $windowUnits $firstUnit $lastUnit up
        "
	bind $w <KeyPress-Down> "
            hsd_listbox_set_scrollbar $listbox $totalUnits $windowUnits $firstUnit $lastUnit down
        "
    }
}
