# qddb/TkUtils/scripts/font-util.tcl
# 
# Miscellaneous font utilities.

# gp_change_fonts -- Change all children of the window $w to
# use $font as the font.  Recursively descends the tree of
# windows from $w to the leaves.
proc gp_change_fonts {w font} {
    if {"$font" == ""} {
	return
    }
    if {[string compare [winfo class $w] Menu] == 0} {
	set last [$w index last]
	for {set i 0} {$i <= $last} {incr i} {
	    catch [list $w entryconfigure $i -font $font]
	}
    }
    foreach i [winfo children $w] {
	catch [list $i configure -font $font]
	gp_change_fonts $i "$font"
    }
}

# gp_set_default_font -- Set the global variable gv_default_font.
proc gp_set_default_font {font} {
    global gv_default_font

    if {"$font" == ""} {
	return "$gv_default_font"
    }
    return [set gv_default_font "$font"]
}
    
