
proc gp_font_attrs {w_prefix w_full w_part s_prefix s_full s_part} {
    set flag 0
    foreach i $w_full {
	if {[lsearch -exact $w_part $i] == -1} {
	    $w_prefix$i configure -state disabled
	    $w_prefix$i deselect
	} else {
	    $w_prefix$i configure -state normal
	    if {$flag == 0} {
		set flag 1
		$w_prefix$i select
	    }
	}
    }
    set flag 0
    foreach i $s_full {
	if {[lsearch -exact $s_part $i] == -1} {
	    $s_prefix$i configure -state disabled
	    $s_prefix$i deselect
	} else {
	    $s_prefix$i configure -state normal
	    if {$flag == 0} {
		set flag 1
		$s_prefix$i select
	    }
	}
    }

}

proc gp_set_font {w num_w} {
    global gvfont_fambut gvfont_wtbut gvfont_slantbut gvfont_font gvfont_cur_font

    set gvfont_cur_font \
	[list -[lindex $gvfont_font($gvfont_fambut) 0]-[lindex $gvfont_font($gvfont_fambut) 1]-$gvfont_wtbut-$gvfont_slantbut-*-*-[$num_w get]-*-*-*-*-*-*-*]
    set x .font.dialog.f2.f4.t
    if {[catch "$w configure -font $gvfont_cur_font"] != 0} {
	$x configure -state normal
	$x delete 0.0 end
	$x insert 0.0 "No font at [$num_w get] pixels. Select another."
	$x configure -state disabled -fg red
    } else {
	$x configure -state normal
	$x delete 0.0 end
	$x insert 0.0 "This is $gvfont_fambut at [$num_w get]"
	$x configure -fg blue -state disabled
    }
}

proc gp_set_font_scale {w num} {
    global gvfont_fambut gvfont_wtbut gvfont_slantbut gvfont_font gvfont_cur_font

    set gvfont_cur_font \
	[list -[lindex $gvfont_font($gvfont_fambut) 0]-[lindex $gvfont_font($gvfont_fambut) 1]-$gvfont_wtbut-$gvfont_slantbut-*-*-$num-*-*-*-*-*-*-*]
    set x .font.dialog.f2.f4.t
    if {[catch "$w configure -font $gvfont_cur_font"] != 0} {
	$x configure -state normal
	$x delete 0.0 end
	$x insert 0.0 "No font at $num pixels. Select another."
	$x configure -state disabled -fg red
    } else {
	$x configure -state normal
	$x delete 0.0 end
	$x insert 0.0 "This is $gvfont_fambut at $num"
	$x configure -fg blue -state disabled
    }
}



# gp_font_dialog -- A dialog for selection of fonts.
proc gp_font_dialog {gvfont_cur_font xplace yplace} {
    global gvfont_fambut gvfont_wtbut gvfont_slantbut gvfont_use_button gvfont_font 
    global gv_config gv_default_font

    set cfl [lreplace [split $gvfont_cur_font "-"] 0 0]
    set l_family [lindex $cfl 1]
    set tmp [split $l_family " "]
    if {[llength $tmp] > 1} {
	set tmp1 ""
	for {set i 0} {$i < [llength $tmp]} {incr i} {
	    set tmp1 ${tmp1}[lindex $tmp $i]
	}
	set l_family $tmp1
    }
    set l_weight [lindex $cfl 2]
    set l_slant  [lindex $cfl 3]
    set l_pxlsz  [lindex $cfl 6]

    toplevel .font
    set wn .font.dialog
    set w .font
    frame $wn
    pack $wn -expand on -fill both
    wm geometry .font +${xplace}+${yplace}
    wm title .font "Font Selection"
    wm iconname .font "Fonts"

    set bg_color skyblue
    #   variable                      fndry     family                      weight         slant
    set gvfont_font(charter)               { bitstream charter                  {bold medium}     {i r} }
    set gvfont_font(courier)               { adobe     courier                  {bold medium}     {i o r} }
    set gvfont_font(fixed)                 { misc      fixed                    {bold medium}     {r} }
    set gvfont_font(helvetica)             { adobe     helvetica                {bold medium}     {o r} }
    set gvfont_font(lucida)                { "b&h"     lucida                   {bold medium}     {i r} }
    set gvfont_font(lucidabright)          { "b&h"     lucidabright             {demibold medium} {i r} }
    set gvfont_font(lucidatypewriter)      { "b&h"     lucidatypewriter         {bold medium}     {r} }
    set gvfont_font(newcenturyschoolbook) \
	{ "adobe"   {new century schoolbook} {bold medium}     {i r} }
    set gvfont_font(times)                 { "adobe"   times                    {bold medium}     {i r} }
    set gvfont_font(utopia)                { "adobe"   utopia                   {bold medium}     {i r} }
    set font_label(charter)                     "Charter"
    set font_label(courier)                     "Courier"
    set font_label(fixed)                       "Fixed width"
    set font_label(helvetica)                   "Helvetica"
    set font_label(lucida)                      "Lucida"
    set font_label(lucidabright)                "Lucida Bright"
    set font_label(lucidatypewriter)            "Lucida Typewriter"
    set font_label(newcenturyschoolbook)        "New Century Schoolbook"
    set font_label(times)                       "Times"
    set font_label(utopia)                      "Utopia"
    set pxlsz { 0 2 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 24 25 26 30 33 34 40 50 60 }
    set weights {bold demibold medium}
    set weights_label(bold) "Bold"
    set weights_label(demibold) "Demi-bold"
    set weights_label(medium) "Medium"
    set slants {i o r}
    set slant_label(i) "Italic"
    set slant_label(o) "Oblique"
    set slant_label(r) "Roman"

    frame $wn.f0 
    pack $wn.f0 -anchor nw -side top -expand on -fill x
    button $wn.f0.b_cancel -relief raised -bd 2 -text "Cancel" -font "$gvfont_cur_font" \
	-command "
            gp_set_global_var gvfont_cur_font \[gp_get_global_var gv_default_font\]
            gp_set_global_var gvfont_use_button dismiss
        "
    pack $wn.f0.b_cancel -side left -anchor nw 
    button $wn.f0.b_save -relief raised -bd 2 -text "Save" -font "$gvfont_cur_font" \
	-command "
            gp_set_global_var gvfont_cur_font \[lindex \[$wn.f2.f4.t configure -font\] 4\]
            gp_set_global_var gvfont_use_button dismiss
        "
    pack $wn.f0.b_save -side left -anchor nw 
    button $wn.f0.b_use -relief raised -bd 2 -text "Test" -font "$gvfont_cur_font" \
	-command "gp_set_global_var gvfont_use_button use"
    pack $wn.f0.b_use -side left -anchor nw 
    button $wn.f0.b_help -relief raised -bd 2 -text "Help" -font "$gvfont_cur_font" \
	-command "gp_font_dialog_help"
    pack $wn.f0.b_help -side right -anchor ne
    # family
    frame $wn.f1 
    pack $wn.f1 -anchor nw -side left -expand on -fill x
    label $wn.f1.l -text "Font Family" -font "$gvfont_cur_font" -relief raised -bd 2 -fg blue
    pack $wn.f1.l -anchor nw -side top -expand on -fill x
    frame $wn.f1.family 
    pack $wn.f1.family -side top -anchor nw -expand on -fill both
    foreach i [lsort [array names font_label]] {
	radiobutton $wn.f1.family.r_$i -font "$gvfont_cur_font" -text "$font_label($i)" \
	    -variable gvfont_fambut -anchor nw -value $i \
	    -command "gp_font_attrs $wn.f2.f1.r_ \"$weights\" \"[lindex $gvfont_font($i) 2]\" \
                      $wn.f2.f2.r_ \"$slants\" \"[lindex $gvfont_font($i) 3]\"
                      gp_set_font $wn.f2.f4.t $wn.f2.f3.s
                     "
	if {$l_family == $i} {
	    $wn.f1.family.r_$i select
	}
	pack $wn.f1.family.r_$i -side top -anchor nw -expand on -fill x
    }
    # weights
    frame $wn.f2
    pack $wn.f2 -anchor nw -side right -expand on -fill both
    frame $wn.f2.f1
    pack $wn.f2.f1 -anchor nw -side top -expand on -fill x
    set x $wn.f2.f1
    label $x.l -text "Weight" -font "$gvfont_cur_font" -relief raised -bd 2 -fg blue
    pack $x.l -anchor nw -side top -expand on -fill x
    foreach i [lsort [array names weights_label]] {
	radiobutton $x.r_$i -font "$gvfont_cur_font" -text "$weights_label($i)" \
	    -variable gvfont_wtbut -anchor nw -value $i -command "gp_set_font $wn.f2.f4.t $wn.f2.f3.s"
	if {$l_weight == $i} {
	    $x.r_$i select
	}
	pack $x.r_$i -side left -anchor nw -expand on -fill x
    }
    # slants
    frame $wn.f2.f2
    pack $wn.f2.f2 -anchor nw -side top -expand on -fill x
    set x $wn.f2.f2
    label $x.l -text "Slant" -font "$gvfont_cur_font" -relief raised -bd 2 -fg blue
    pack $x.l -anchor nw -side top -expand on -fill x
    foreach i [lsort [array names slant_label]] {
	radiobutton $x.r_$i -font "$gvfont_cur_font" -text "$slant_label($i)" \
	    -variable gvfont_slantbut -anchor nw -value $i -command "gp_set_font $wn.f2.f4.t $wn.f2.f3.s"
	if {$l_slant == $i} {
	    $x.r_$i select
	}
	pack $x.r_$i -side left -anchor nw -expand on -fill x
    }
    gp_font_attrs $wn.f2.f1.r_ "$weights" "[lindex $gvfont_font($l_family) 2]" \
	$wn.f2.f2.r_ "$slants" "[lindex $gvfont_font($l_family) 3]"
    set gvfont_fambut $l_family
    set gvfont_wtbut $l_weight
    set gvfont_slantbut $l_slant
    # pixel size
    frame $wn.f2.f3 -relief flat -bd 0
    pack $wn.f2.f3 -anchor nw -side top -expand on -fill x
    set x $wn.f2.f3
    label $x.l -text "Pixel Size" -font "$gvfont_cur_font" -relief raised -bd 2 -fg blue
    pack $x.l -anchor nw -side top -expand on -fill x    
    scale $x.s -from 0 -to 60 -orient horizontal -showvalue true -relief raised -bd 2
	
    bind $x.s <Any-ButtonRelease> "
        gp_set_font_scale $wn.f2.f4.t \[$x.s get\]
    "
    pack $x.s -anchor nw -side top -expand on -fill x
    $x.s set $l_pxlsz
    frame $wn.f2.f4 -relief sunken -bd 2
    pack $wn.f2.f4 -anchor nw -side top -expand on -fill both
    set x $wn.f2.f4
    label $x.l -relief flat -text "Currently Selected Font" -fg midnightblue -bg $bg_color -font "$gvfont_cur_font"
    pack $x.l -side top -anchor nw -expand on -fill both
    text $x.t -relief flat -height 4 -state normal -fg midnightblue -bg $bg_color \
	-width 20 -font "$gvfont_cur_font" -wrap word
    pack $x.t -anchor sw -side top -expand on -fill both
    $x.t insert end "This is the font."
    $x.t configure -state disabled

    tkwait variable gvfont_use_button
    while {$gvfont_use_button != "dismiss"} {
	switch -exact $gvfont_use_button {
	    use {
		set gvfont_cur_font \
		    "-[lindex $gvfont_font($gvfont_fambut) 0]-[lindex $gvfont_font($gvfont_fambut) 1]-$gvfont_wtbut-$gvfont_slantbut-*-*-[$wn.f2.f3.s get]-*-*-*-*-*-*-*"
		gp_change_fonts "$w" "$gvfont_cur_font"
	    }
	}
	tkwait variable gvfont_use_button
    }
    return [gp_get_global_var gvfont_cur_font]
}

proc gp_font_dialog_help {} {

}

proc gp_font_select {curfont} {
    global gv_config gv_default_font

    if {[winfo exists .font]} {
	wm withdraw .font
	wm deiconify .font
	return error
    }
    if {![info exists gv_config(geom,\$fontsel\$)]} {
	set x [expr [winfo screenwidth .] / 3]
	set y [expr [winfo screenheight .] / 3]
    } else {
	set x [split $gv_config(geom,\$fontsel\$) +]
	set y [lindex $x 2]
	set x [lindex $x 1]
    }
    if {[string compare [string index $gv_default_font 0] "-"] == 0} {
	set a [gp_font_dialog "$gv_default_font" $x $y]
	set gv_config(geom,\$fontsel\$) [wm geometry .font]
	destroy .font
	if {[string compare $gv_default_font $a] == 0} {
	    return ""
	} else {
	    return $a
	}
    } else {
	set def "-adobe-courier-medium-r-*-*-18-*-*-*-*-*-*-*"
	set a [gp_font_dialog $def $x $y]
	set gv_config(geom,\$fontsel\$) [wm geometry .font]
	destroy .font
	if {[string compare $def $a] == 0} {
	    return ""
	} else {
	    return $a
	}
    }

}
