
proc gp_file_listbox {w name title} {
    global gv_default_font

    frame $w.f$name -bd 2 -relief groove 
    pack $w.f$name -side left -expand yes -fill both
    set x $w.f$name
    label $x.l -text "$title" -font $gv_default_font
    pack $x.l -side top -anchor w -fill x 
    scrollbar $x.vscrollbar -command "$x.listbox yview" -relief raised
    pack $x.vscrollbar -side right -fill y
    listbox $x.listbox -yscroll "$x.vscrollbar set"  \
	    -relief raised -setgrid on
    pack $x.listbox -side left  -expand yes -fill both
    tk_listboxSingleSelect $x.listbox
}

proc gp_file_checkforfile {w l e} {
    set file [$w get [$w curselection]]

    set fbox .filesel.listbox.ffiles.listbox
    set dbox .filesel.listbox.fdirs.listbox
    if [file isdirectory $file] {
	$fbox delete 0 end
	$dbox delete 0 end
	cd $file
	foreach i [exec ls -1a] {
	    if [file isdirectory $i] {
		$dbox insert end $i
	    } else {
		$fbox insert end $i
	    }
	}
	$w select from 0
	$e delete 0 end
	$l configure -text [pwd]
    } else {
	$e delete 0 end
	$e insert 0 $file
    }
}

proc gp_file_select {} {
    global gv_current_template gv_config gv_default_font gv_status_variable gv_config

    if {[winfo exists .filesel]} {
	wm withdraw .filesel
	wm deiconify .filesel
	return
    }
    set f .filesel
    toplevel $f
    wm title $f "File Selection"
    grab set $f
    gp_disable .top
    set dir [pwd]
    set whereami [pwd]

    set oldcur $gv_current_template
    #
    # display where last configured
    #
    if {[info exists gv_config(geom,\$filebox\$)]} {
	set xx [split $gv_config(geom,\$filebox\$) +]
	set xy [lindex $xx 2]
	set xx [lindex $xx 1]
	wm geometry .filesel +${xx}+${xy}
    }

    #
    # Create the menubar: Cancel and Select
    #
    frame $f.but
    pack $f.but -side top -fill x
    set x $f.but
    menubutton $x.cancel -text "Cancel" -relief raised -bd 2 \
	-underline 0 -font "$gv_default_font"
    pack $x.cancel -side left
    menubutton $x.select -text "Select" -relief raised -bd 2 \
	-underline 0 -font "$gv_default_font"
    pack $x.select -side left

    #
    # Create the Pathname and Filename entries
    #
    set v $f.fileboxentries
    frame $v  -bd 2 -relief groove
    pack $v -side top -fill both
    frame $v.path 
    pack $v.path -side top -fill x -expand yes
    label $v.path.l -text "Pathname:" -font "$gv_default_font"
    label $v.path.v -text [pwd] -font "$gv_default_font" -relief sunken -anchor w
    pack $v.path.l -side left -anchor w
    pack $v.path.v -side right  -anchor w -fill x -expand yes
    frame $v.file
    pack $v.file -side top -fill x -expand yes
    label $v.file.l -text "Filename:" -font "$gv_default_font"
    entry $v.file.v -textvariable filename -font "$gv_default_font" -relief sunken
    pack $v.file.l -side left -anchor w
    pack $v.file.v -side right -fill x -expand yes
    set filename $dir

    #
    # Create the Directories and Filename listboxes
    #
    set f2 $f.listbox
    frame $f2
    pack $f2 -side top -fill both -expand yes
    gp_file_listbox $f2 dirs "Directories:"
    bind $f2.fdirs.listbox <ButtonRelease-1> \
	    [list gp_file_checkforfile $f2.fdirs.listbox $v.path.v $v.file.v]
    $f2.fdirs.listbox configure -font $gv_default_font
    focus $f2.fdirs.listbox 
    $f2.fdirs.listbox select from 0
    gp_file_listbox $f2 files "Files:" 
    bind $f2.ffiles.listbox <ButtonRelease-1> \
	    [list gp_file_checkforfile $f2.ffiles.listbox $v.path.v $v.file.v]
    $f2.ffiles.listbox configure -font $gv_default_font
    focus $f2.ffiles.listbox 
    $f2.ffiles.listbox select from 0

    #
    # Populate the Directories and Filename listboxes with the pwd
    # 
    set fbox .filesel.listbox.ffiles.listbox
    set dbox .filesel.listbox.fdirs.listbox
    foreach i [exec ls -1a] {
	if [file isdirectory $i] {
	    $dbox insert end $i
	} else {
	    $fbox insert end $i
	}
    }

    #
    # Bind the world: emacs, mouse click
    #
    gp_bind_menubutton $x.cancel c [list $f $f.but $f2.fdirs.listbox $f2.ffiles.listbox $v.file.v] {
	set gv_current_template ""
    }
    gp_bind_menubutton $x.select s [list $f  $f.but $f2.ffiles.listbox $v.file.v] {
	set gv_current_template "s"
    }
    gp_emacs_bindings $v.file.v
    bind $v.file.v <Return> [list set gv_current_template "s"]
    set oldfoc [focus]
    focus $v.file.v

    #
    # Wait until user clicks a button, then wrap it up
    #
    tkwait variable gv_current_template
    if {[llength $gv_current_template] > 0} {
	set dir [lindex [.filesel.fileboxentries.path.v configure -text] 4]
	set file [lindex [.filesel.fileboxentries.file.v configure -text] 4]
	set file [.filesel.fileboxentries.file.v get]
	set gv_current_template "$dir/$file"
    } else {
	set gv_current_template $oldcur
    }
    gp_enable .top
    grab release $f
    focus $oldfoc
    set gv_config(geom,\$filebox\$) [wm geometry .filesel]
    destroy $f
}

