

proc gp_getconfig {idx1 idx2} {
    global gv_config

    if {[info exists gv_config($idx1,$idx2)]} {
        return $gv_config($idx1,$idx2)
    } else {
        return ""
    }
}

proc gp_setconfig {var idx1 idx2} {
    global $var gv_config gv_schema

    set lv_config($idx1,unsorted,$idx2) [set ${var}(unsorted)]
    set lv_config($idx1,$idx2) {}
    set lv_config($idx1,,$idx2) {}
    set lv_config($idx1,sort,$idx2) {}
    set lv_config($idx1,print,$idx2) {}
    set lv_config($idx1,ascendsort,$idx2) {}
    foreach i [qddb_schema leaves $gv_schema] {
        if {[info exists ${var}(c,$i)] && [set ${var}(c,$i)] == 1} {
	    set tmp [set ${var}(e,$i)]
            if {[string compare [string trim $tmp] ""] == 0} {
                lappend lv_config($idx1,$idx2) $i
            } else {
                lappend lv_config($idx1,$idx2) ${i}:$tmp
            }
            lappend lv_config($idx1,,$idx2) $i
            lappend lv_config($idx1,sort,$idx2) $i,[set ${var}(s,$i)]
            lappend lv_config($idx1,print,$idx2) $i,[set ${var}(p,$i)]
	    if {[string compare [set ${var}(a,$i)] "on"] == 0} {
		lappend lv_config($idx1,ascendsort,$idx2) $i
	    }
        }
    }
    set len [llength $lv_config($idx1,,$idx2)]
    set y [llength $lv_config($idx1,sort,$idx2)]
    foreach i $lv_config($idx1,sort,$idx2) {
        set j [split $i ","]
        set name [lindex $j 0]
        set j [lindex $j 1]
        if {[string compare $j ""] != 0 && [expr $j < 1 || $j > $len]} {
            return 1
        } else {
            if {[string compare $j ""] == 0} {
                set sort([incr y]) $name
            } else {
                set sort($j) $name
            }
        }
    }
    incr len $y
    set y [llength $lv_config($idx1,print,$idx2)]
    foreach i $lv_config($idx1,print,$idx2) {
        set j [split $i ","]
        set name [lindex $j 0]
        set j [lindex $j 1]
        if {[string compare $j ""] != 0 && [expr $j < 1 || $j > $len]} {
            return 1
        } else {
            if {[string compare $j ""] == 0} {
                set print([incr y]) $name
            } else {
                set print($j) $name
            }
        }
    }
    incr len $y
    set gv_config($idx1,$idx2) $lv_config($idx1,$idx2)
    set gv_config($idx1,,$idx2) $lv_config($idx1,,$idx2)
    set gv_config($idx1,sort,$idx2) {}
    set gv_config($idx1,print,$idx2) {}
    set gv_config($idx1,unsorted,$idx2) $lv_config($idx1,unsorted,$idx2) 
    set gv_config($idx1,ascendsort,$idx2) $lv_config($idx1,ascendsort,$idx2) 
    for {set i 1} {$i <= $len} {incr i} {
        if {[info exists sort($i)]} {
            lappend gv_config($idx1,sort,$idx2) $sort($i)
        }
        if {[info exists print($i)]} {
            lappend gv_config($idx1,print,$idx2) $print($i)
        }
    }
    return 0
}

proc gp_searchconfig {list val} {
    foreach i $list {
        set s [split $i ":"]
        if {[string compare [lindex $s 0] $val] == 0} {
            return $s
        }
    }
    return {}
}

proc gp_clearconfig {idx1 idx2} {
    global gv_config

    catch [list unset gv_config($idx1,$idx2)]
}

proc gp_config_clearbox {b e1 e2 e3} {
    global gv_tmp
    set v [lindex [$b configure -variable] 4]
    if {[set $v] == 0} {
	$e1 delete 0 end
	$e2 delete 0 end
	$e3 delete 0 end
    } else {
	focus $e1
    }
}

proc gp_config_box {attr} {
    global gv_attr_vnames gv_config gv_schema gv_default_font
    global gv_tmp gv_config_changed

    toplevel .sc 
    frame .sc.f
    pack .sc.f -side top
    set idx geom,$attr
    while {[catch "grab .sc"] != 0} {}
    set oldfoc [focus]
    focus .sc
    if {![info exists gv_config($idx)]} {
        set gv_config($idx) +[expr [winfo width .] / 2]+[expr [winfo height .] / 8]
    }
    wm geometry .sc $gv_config($idx)
    if {[info exists gv_tmp]} {
        unset gv_tmp
    }
    if {[string compare $attr "\$search\$"] == 0} {
        wm title .sc {Search Results Config}
        set leaves [qddb_schema leaves $gv_schema]
    } else {
        if {[info exists gv_attr_vnames($attr)]} {
            wm title .sc "$gv_attr_vnames($attr) Config"
        } else {
            wm title .sc "$attr Config"
        }
        set leaves [qddb_schema leaves $gv_schema $attr]
    }
    if {![winfo exists .i]} {
        gp_disable .top
    }
    if {![info exists gv_config(conf,$attr)]} {
	set gv_config(conf,$attr) {}
	if {[string compare $attr {$search$}] == 0} {
	    set myattrs [lrange [qddb_schema leaves $gv_schema] 0 4]
	} else {
	    set myattrs [lrange [qddb_schema leaves $gv_schema $attr] 0 4]
	}
	foreach i $myattrs {
	    lappend gv_config(conf,$attr) ${i}:10
	}
    }
    if {![info exists gv_config(conf,,$attr)]} {
	set gv_config(conf,,$attr) {}
	foreach i $gv_config(conf,$attr) {
	    lappend gv_config(conf,,$attr) [lindex [split ${i} ":"] 0]
	}
    }
    if {![info exists gv_config(conf,sort,$attr)]} {
	set gv_config(conf,sort,$attr) $gv_config(conf,,$attr)
    }
    if {![info exists gv_config(conf,print,$attr)]} {
	set gv_config(conf,print,$attr) $gv_config(conf,,$attr)
    }
    set x .sc.f.butt
    frame $x
    pack $x -side top -expand on -fill x
    menubutton $x.cancel -text Cancel -relief raised -bd 2 \
        -underline 0 -font "$gv_default_font"
    pack $x.cancel -side left -anchor nw
    menubutton $x.save -text Save -relief raised -bd 2 \
        -underline 0 -font "$gv_default_font"
    pack $x.save -side left -anchor nw
    if {![info exists gv_config(conf,ascendsort,$attr)]} {
	set gv_config(conf,ascendsort,$attr) $gv_config(conf,sort,$attr)
    }
    if {![info exists gv_config(conf,boxheight,$attr)]} {
	set gv_config(conf,boxheight,$attr) 10
    }
    if {![info exists gv_config(conf,unsorted,$attr)]} {
	set gv_config(conf,unsorted,$attr) off
    }
    set gv_tmp(unsorted) $gv_config(conf,unsorted,$attr)
    checkbutton $x.unsorted -text "Unsorted" -font $gv_default_font \
	-offvalue off -onvalue on -variable gv_tmp(unsorted)
    pack $x.unsorted -side right -anchor e

    set but $x
    frame .sc.f.fb
    pack .sc.f.fb -side top -expand on -fill x
    set x .sc.f.fb
    entry $x.boxht_e -textvariable gv_config(conf,boxheight,$attr) -font $gv_default_font \
	-relief sunken -width 3
    pack $x.boxht_e -side right -anchor e
    gp_emacs_bindings %x.boxht_e
    if {[string compare [tk colormodel .] "monochrome"] == 0} {
	label $x.boxht_l -text "Listbox height" -font $gv_default_font
    } else {
	label $x.boxht_l -text "Listbox height" -font $gv_default_font -fg red
    }    
    pack $x.boxht_l -side right -anchor e
    set conf [gp_getconfig conf $attr]
    set can .sc.f.can
    scrollbar .sc.f.scroll -orient vertical -command [list $can yview]
    pack .sc.f.scroll -side right -expand on -fill y
    frame .sc.f.f0
    pack .sc.f.f0 -expand on -fill x
    set x .sc.f.f0
    label $x.desc -text "Description" -font $gv_default_font
    pack $x.desc -side left -expand on -fill x
    label $x.width -text "Width" -width 5 -font $gv_default_font
    pack $x.width -side left
    label $x.sort -text "Sort" -width 5 -font $gv_default_font
    pack $x.sort -side left
    label $x.print -text "Print" -width 5 -font $gv_default_font
    pack $x.print -side left
    label $x.ascend -text "Sort Type" -width 9 -font $gv_default_font
    pack $x.ascend -side left
    canvas $can -yscroll [list .sc.f.scroll set]
    frame $can.fr
    set x 0
    foreach i $leaves {
        set z $can.fr.f$x
        frame $z
        pack $z -expand on -fill x
        if {[info exists gv_attr_vnames($i)]} {
            checkbutton $z.c -text "$gv_attr_vnames($i) ($i)" -anchor w -var gv_tmp(c,$i) \
                -command [list gp_config_clearbox $z.c $z.e $z.p $z.s] \
		-font $gv_default_font
        } else {
            checkbutton $z.c -text $i -anchor w -var gv_tmp(c,$i) \
                -command [list gp_config_clearbox $z.c $z.e $z.p $z.s] \
                -font $gv_default_font
        }
        set t [gp_searchconfig $conf $i]
        set l [llength $t]
        if {$l != 0} {
            set gv_tmp(c,$i) 1
            if {$l == 2} {
                set gv_tmp(e,$i) [lindex $t 1]
            }
        }
        pack $z.c -side left -expand on -fill x
        entry $z.e -width 5 -relief sunken -textvariable gv_tmp(e,$i) -font $gv_default_font
        pack $z.e -side left
        bind $z.e <Key-Tab> "focus $z.s"
        bind $z.e <Shift-Key-Tab> "focus $z.p"
	gp_emacs_bindings $z.e
        lappend entries $z.e

        if {[info exists gv_config(conf,sort,$attr)]} {
            set midx [lsearch -exact $gv_config(conf,sort,$attr) $i]
            if {$midx != -1} {
                set gv_tmp(s,$i) [expr $midx + 1]
            } else {
                set gv_tmp(s,$i) {}
            }
        } else {
            set gv_tmp(s,$i) {}
        }
        entry $z.s -width 5 -relief sunken -textvariable gv_tmp(s,$i) -font $gv_default_font
        pack $z.s -side left
        bind $z.s <Key-Tab> "focus $z.p"
        bind $z.s <Shift-Key-Tab> "focus $z.e"
	gp_emacs_bindings $z.s
        lappend entries $z.s

        if {[info exists gv_config(conf,print,$attr)]} {
            set midx [lsearch -exact $gv_config(conf,print,$attr) $i]
            if {$midx != -1} {
                set gv_tmp(p,$i) [expr $midx + 1]
            } else {
                set gv_tmp(p,$i) {}
            }
        } else {
            set gv_tmp(p,$i) {}
        }
        entry $z.p -width 5 -relief sunken -textvariable gv_tmp(p,$i) -font $gv_default_font
        pack $z.p -side left
        bind $z.p <Key-Tab> "focus $z.e"
        bind $z.p <Shift-Key-Tab> "focus $z.s"
	gp_emacs_bindings $z.p
        lappend entries $z.p

        if {[info exists gv_config(conf,ascendsort,$attr)]} {
            set midx [lsearch -exact $gv_config(conf,ascendsort,$attr) $i]
            if {$midx != -1} {
                set gv_tmp(a,$i) on
            } else {
                set gv_tmp(a,$i) off
            }
        } else {
            set gv_tmp(a,$i) off
        }
        checkbutton $z.a -variable gv_tmp(a,$i) -text Ascend -font $gv_default_font \
	    -onvalue on -offvalue off
        pack $z.a -side left

        incr x
    }
    gp_bind_menubutton $but.cancel c [concat .sc $entries] "
        set [list gv_config($idx)] \[wm geometry .sc\]
        destroy .sc
        catch {unset gv_tmp}
    "
    gp_bind_menubutton $but.save s [concat .sc $entries] "
        set [list gv_config($idx)] \[wm geometry .sc\]
        if {\[gp_setconfig gv_tmp conf [list $attr]\] == 1} {
            tk_dialog .dialog {Error in configuration} {Invalid sort/print order numbers} \
                error 0 OK
        } else {
            catch {destroy .sc}
            gp_set_global_var gv_config_changed 1
            catch {unset gv_tmp}
        }
    "
    pack $can -side left
    $can create window 0 0 -anchor nw -window $can.fr
    if {[string compare [string index $gv_config($idx) 0] +] == 0} {
	gp_canv_fit .sc.f $can $can.fr
    } else {
	gp_canv_fit .sc.f $can $can.fr \
	    [lindex [split [lindex [split $gv_config($idx) +] 0] x] 1]
    }
    update idletasks
    tkwait window .sc
    grab release .sc
    focus $oldfoc
    update
    if {![winfo exists .i]} {
        gp_enable .top
    }
}

proc gp_ic_sel {p l b} {
    gp_disable .i
    $p [lindex $l [$b curselection]]
    gp_enable .i
    while {[catch "grab .i"] != 0} {}
}

proc gp_instance_config {} {
    global gv_schema gv_default_font gv_expand gv_config gv_status_variable

    if {![info exists gv_expand] || [string compare $gv_expand ""] == 0} {
	set gv_status_variable "No expandable instances to configure."
	update idletasks
	return
    }
    catch [list destroy .i]
    toplevel .i
    gp_disable .top
    while {[catch "grab .i"] != 0} {}
    set idx "geom,\$instance\$"
    if {![info exists gv_config($idx)]} {
        set gv_config($idx) +[expr [winfo width .] / 2]+[expr [winfo height .] / 2]
    }
    wm geometry .i $gv_config($idx)
    wm title .i "Instance Configuration"
    frame .i.f
    pack .i.f -expand on -fill x
    set x .i.f
    menubutton $x.close -text "Close" -relief raised -bd 2  \
        -font "$gv_default_font" -underline 0
    pack $x.close -side left -anchor w

    set oldfocus [focus]

    hsd_listbox .i l "" $gv_expand
    .i.l.listbox configure -font $gv_default_font
    focus .i.l.listbox

    bind .i.l.listbox <ButtonRelease-1> +[list gp_ic_sel gp_config_box $gv_expand .i.l.listbox]
    bind .i.l.listbox <Return> [list gp_ic_sel gp_config_box $gv_expand .i.l.listbox]
    gp_bind_menubutton $x.close c .i.l.listbox "
        set [list gv_config($idx)] \[wm geometry .i\]
        catch {destroy .i}
    "
    .i.l.listbox select from 0
    update idletasks
    tkwait window .i
    grab release .i
    focus $oldfocus
    update idletasks
    gp_enable .top
}

proc gp_entry_config {} {
    global gv_attr_vnames gv_config gv_schema gv_default_font
    global gv_tmp gv_config_changed

    toplevel .ec
    frame .ec.f
    pack .ec.f -side top
    set idx geom,\$entryconfig\$
    set oldfoc [focus]
    while {[catch "grab .ec"] != 0} {}
    focus .ec
    if {![info exists gv_config($idx)]} {
        set gv_config($idx) +[expr [winfo width .] / 2]+[expr [winfo height .] / 8]
    }
    wm geometry .ec $gv_config($idx)
    if {[info exists gv_tmp]} {
        unset gv_tmp
    }
    wm title .ec {Entry Type Configuration}
    set leaves {}
    foreach i [qddb_schema leaves $gv_schema] {
	if {[string compare [qddb_schema option type $gv_schema $i] string] == 0} {
	    lappend leaves $i
	}
    }
    gp_disable .top
    set x .ec.f.butt
    frame $x
    pack $x -side top -expand on -fill x
    menubutton $x.cancel -text Cancel -relief raised -bd 2 \
        -underline 0 -font "$gv_default_font"
    pack $x.cancel -side left -anchor nw
    menubutton $x.save -text Save -relief raised -bd 2 \
        -underline 0 -font "$gv_default_font"
    pack $x.save -side left -anchor nw
    set but $x
    frame .ec.f.fb
    pack .ec.f.fb -side top -expand on -fill x
    set x .ec.f.fb
    set can .ec.f.can
    scrollbar .ec.f.scroll -orient vertical -command [list $can yview]
    pack .ec.f.scroll -side right -expand on -fill y
    frame .ec.f.f0
    pack .ec.f.f0 -expand on -fill x
    set x .ec.f.f0
    label $x.desc -text "Description" -font $gv_default_font
    pack $x.desc -side left -expand on -fill x
    label $x.type -text "Type" -font $gv_default_font -width 5
    pack $x.type -side left
    label $x.width -text "Height" -width 6 -font $gv_default_font
    pack $x.width -side left
    canvas $can -yscroll [list .ec.f.scroll set]
    frame $can.fr
    set x 0
    set entries {}
    foreach i $leaves {
        set z $can.fr.f$x
        frame $z
        pack $z -expand on -fill x
        if {[info exists gv_attr_vnames($i)]} {
            label $z.b -text "$gv_attr_vnames($i) ($i)" -anchor w \
                -font $gv_default_font
        } else {
            label $z.b -text $i -anchor w -font $gv_default_font
        }
        pack $z.b -side left -expand on -fill x
	if {![info exists gv_config(disp,$i)]} {
	    set gv_config(disp,$i) Entry
	}
	set gv_tmp(m,$i) $gv_config(disp,$i)
	if {[string compare [tk colormodel .] "monochrome"] == 0} {
	    menubutton $z.m -textvariable gv_tmp(m,$i) -font $gv_default_font -relief raised \
		-cursor hand1 -menu $z.m.menu -width 6
	} else {
	    menubutton $z.m -textvariable gv_tmp(m,$i) -font $gv_default_font -relief raised \
		-fg blue -cursor hand1 -menu $z.m.menu -width 6
	}
	pack $z.m -side left -expand off
	if {[string compare [tk colormodel .] "monochrome"] == 0} {
	    menu $z.m.menu -font $gv_default_font -cursor hand1 
	} else {
	    menu $z.m.menu -font $gv_default_font -cursor hand1 -fg blue
	}
	$z.m.menu add command -font $gv_default_font -label Entry -command "
            set gv_tmp(m,$i) Entry
            $z.m.menu entryconfigure 0 -state disabled
            $z.m.menu entryconfigure 1 -state normal
            $z.e delete 0 end
            $z.e configure -state disabled
            focus .ec
        "
	$z.m.menu add command -font $gv_default_font -label Text -command "
            set gv_tmp(m,$i) Text
            $z.m.menu entryconfigure 0 -state normal
            $z.m.menu entryconfigure 1 -state disabled
            $z.e configure -state normal
            set gv_tmp(e,$i) 4
            focus $z.e
        "
	if {[string compare $gv_config(disp,$i) "Text"] == 0} {
	    if {[info exists gv_config(dispval,$i)]} {
		set gv_tmp(e,$i) $gv_config(dispval,$i)
	    } else {
		set gv_tmp(e,$i) 4
	    }
	}
        entry $z.e -width 6 -relief sunken -textvariable gv_tmp(e,$i) -font $gv_default_font
        pack $z.e -side left
	switch -exact $gv_config(disp,$i) {
	    Entry {
		$z.m.menu entryconfigure 0 -state disabled
		$z.e configure -state disabled
	    }
	    Text  {
		$z.m.menu entryconfigure 1 -state disabled
	    }
	}
	gp_emacs_bindings $z.e
	lappend entries $z.e
        incr x
    }
    gp_bind_menubutton $but.cancel c [concat .ec $entries] "
        set [list gv_config($idx)] \[wm geometry .ec\]
        destroy .ec
        catch {unset gv_tmp}
    "
    gp_bind_menubutton $but.save s [concat .ec $entries] "
        set [list gv_config($idx)] \[wm geometry .ec\]
        if {\[gp_setentryconfig gv_tmp conf [list $leaves]\] == 0} {
            catch {destroy .ec}
            gp_set_global_var gv_config_changed 1
            catch {unset gv_tmp}
        }
    "
    pack $can -side left
    $can create window 0 0 -anchor nw -window $can.fr
    if {[string compare [string index $gv_config($idx) 0] +] == 0} {
	gp_canv_fit .ec.f $can $can.fr
    } else {
	gp_canv_fit .ec.f $can $can.fr \
	    [lindex [split [lindex [split $gv_config($idx) +] 0] x] 1]
    }
    update idletasks
    tkwait window .ec
    grab release .ec
    focus $oldfoc
    gp_enable .top
}

proc gp_reconfig_entry {i type {ht ""}} {
    global gv_entryname gv_config gv_attr gv_default_font gv_mode_variable gv_searchvars

    destroy $gv_entryname($i)
    set f [string range $gv_entryname($i) 0 [expr [string last "." $gv_entryname($i)] -1]]
    catch "destroy $f.s"
    switch -exact $type {
	Entry {
	    catch "destroy $f.s"
	    entry $gv_entryname($i) -textvariable gv_attr($i) -font $gv_default_font \
		-width $gv_config(conf,entry_width) -relief sunken -bd 2 -exportselection on
	    if {[winfo exists $f.new]} {
		pack $gv_entryname($i) -side right -anchor ne -pady 3 -before $f.del
	    } else {
		pack $gv_entryname($i) -side right -anchor ne -pady 3 -before $f.l
	    }
	    gp_texttrace_delete $gv_entryname($i) $i
	    gp_emacs_bindings $gv_entryname($i)
	}
	Text {
	    if {[catch "expr int($ht)"]} {
		set ht 4
	    }
	    if {![info exists gv_config(dispval,$i)]} {
		set gv_config(dispval,$i) $ht
	    }
	    text $gv_entryname($i) -height $ht -font $gv_default_font \
		-width $gv_config(conf,entry_width) -relief sunken -bd 2 -exportselection on \
		-yscroll [list $f.s set] -wrap word
	    scrollbar $f.s -orient vertical -command [list $f.e yview]
	    if {[winfo exists $f.new]} {
		pack $gv_entryname($i) -side right -anchor ne -pady 3 -before $f.del
		pack $f.s -side right -fill y -anchor ne -before $f.del
	    } else {
		pack $gv_entryname($i) -side right -anchor ne -before $f.l
		pack $f.s -side right -fill y -anchor ne -before $f.l
	    }
	    if {[string compare $gv_mode_variable "Search Mode"] == 0} {
		gp_texttrace_delete $gv_entryname($i) $i
		$gv_entryname($i) insert 0.0 $gv_searchvars($i)
		$gv_entryname($i) mark set insert 0.0
		gp_texttrace_search $gv_entryname($i) $i
	    } else {
		gp_texttrace_delete $gv_entryname($i) $i
		$gv_entryname($i) insert 0.0 $gv_attr($i)
		$gv_entryname($i) mark set insert 0.0
		gp_texttrace_modify $gv_entryname($i) $i

	    }

	}
    }
    if {[info exists gv_config(maingeom)]} {
	set height [lindex [split [lindex [split $gv_config(maingeom) +] 0] x] 1]

    } else {
	set height {}
    }
    gp_canv_fit .top .top.canvas .top.canvas.schema $height
}

proc gp_setentryconfig {v idx leaves} {
    global gv_tmp gv_config

    foreach i $leaves {
	if {[string compare $gv_tmp(m,$i) "Entry"] == 0} {
	    if {[string compare $gv_config(disp,$i) $gv_tmp(m,$i)] != 0} {
		gp_reconfig_entry $i $gv_tmp(m,$i)
	    }
	    set gv_config(disp,$i) $gv_tmp(m,$i)
	    catch "unset gv_config(dispval,$i)"
	    continue
	}
	if {[llength $gv_tmp(e,$i)] == 0} {
	    set gv_tmp(e,$i) 4
	}
	if {[catch "expr int($gv_tmp(e,$i))"] != 0} {
	    tk_dialog .dialog "Input error" "Invalid height: $gv_tmp(e,$i)" error 0 OK
	    return 1
	}
	if {[string compare $gv_config(disp,$i) $gv_tmp(m,$i)] != 0 || \
		$gv_tmp(e,$i) != $gv_config(dispval,$i)} {
	    gp_reconfig_entry $i $gv_tmp(m,$i) [expr int($gv_tmp(e,$i))]
	    set gv_config(disp,$i) $gv_tmp(m,$i)
	}
	set gv_config(dispval,$i) [expr int($gv_tmp(e,$i))]
    }
    return 0
}

proc gp_read_config {} {
    global gv_config gv_schema_name gv_default_font gv_config_changed

    set dir [glob ~]
    set dir $dir/.qddb_conf
    set olddir [pwd]
    cd $gv_schema_name
    set name [pwd]
    cd $olddir
    set name [split $name "/"] 
    set file [join $name "."]
    if {[file isdirectory $dir] && [file readable $dir/$file]} {
        if {[catch "source $dir/$file"] != 0} {
	    puts "Error in personal config file; trying global"
	} else {
	    set gv_config_changed 0
	    return
	}
    }
    if {[file isdirectory $gv_schema_name] && [file exists $gv_schema_name/.qddb_config]} {
        if {[catch "source $gv_schema_name/.qddb_config"] != 0} {
	    puts "Error in global config file"
	} else {
	    set gv_config_changed 0
	    return
	}
    }
}

proc gp_check_config {} {
    global gv_config_changed

    if {[info exists gv_config_changed] && $gv_config_changed == 1} {
        set res [tk_dialog .dialog "Configuration modified" \
            "Your configuration has been modified, would you like to save it?" info 0 Yes No Cancel]
        if {$res == 0} {
            if {[gp_save_config] != 0} {
                return 1
            }
        } elseif {$res == 2} {
            return 1
        }
    }
    return 0
}

proc gp_save_config {{x personal}} {
    global gv_config gv_schema_name gv_default_font gv_config_changed gv_status_variable
    global gv_current_template

    set gv_config(maingeom) [wm geometry .]
    if {[string compare $x global] == 0} {
	set dir $gv_schema_name
	set file ".qddb_config"
    } else {
	set dir [glob ~]
	set dir $dir/.qddb_conf
	set olddir [pwd]
	cd $gv_schema_name
	set name [pwd]
	cd $olddir
	set name [split $name "/"] 
	set file [join $name "."]
	if {![file isdirectory $dir]} {
	    while {[catch "exec mkdir $dir"] != 0} {
		set res [tk_dialog .dialog "ERROR" \
			     "Cannot create directory $dir: correct the problem and continue, or cancel" \
			     error Cancel Continue]
		if {$res == 0} {
		    return 1
		}
	    }
	}
	set gv_config_changed 0
    }
    set fd [open $dir/$file "w"]
    foreach i [array names gv_config] {
        puts $fd [list set gv_config($i) $gv_config($i)]
    }
    puts $fd [list set gv_current_template $gv_current_template]
    puts $fd [list set gv_default_font $gv_default_font]
    close $fd
    set gv_status_variable "The \"$x\" configuration has been saved."
    return 0
}

