proc TableSetCell { W x y } {
    set args [ $W whatcell $x $y ]
    $W setcell [lindex $args 0 ] [lindex $args 1]
}

proc TableMoveCell { W x y} {
    set args [ $W setcell ]
    $W setcell [expr [lindex $args 0] + $x]  [expr [lindex $args 1] + $y ]
}

proc TableSetWidth { W a } {
    set temp [expr [ lindex [ $W setcell ] 1 ] - [ lindex [ $W configure -colorig ] 4 ]]
    $W width [ list $temp [ expr [ $W getwidth $temp ] + $a ] ]
}

bind TkTable <Button-1> { 
    TableSetCell %W %x %y
    focus %W
}

bind TkTable <Right> { TableMoveCell %W  0  1 }
bind TkTable <Left>  { TableMoveCell %W  0 -1 }
bind TkTable <Down> { TableMoveCell %W   1  0 }
bind TkTable <Up> { TableMoveCell %W    -1  0 }

bind TkTable <Any-KeyPress> { 
    if { "%A" != "" } {%W insert insert %A }
}
bind TkTable <BackSpace> 	{ 
    set temp [ %W icursor ]
    if { $temp } {%W delete [ expr $temp - 1 ] }
}

bind TkTable <Delete>	{ %W delete insert }
bind TkTable <Escape>	{ %W reread }
bind TkTable <Return>	{ TableMoveCell %W 1 0 }

bind TkTable <Control-Left>  { %W icursor [ expr [ %W icursor ] - 1 ] }
bind TkTable <Control-Right> { %W icursor [ expr [ %W icursor ] + 1 ] }
bind TkTable <End> { %W icursor end }
bind TkTable <Home> { %W icursor 0 }

bind TkTable <Control-equal> { TableSetWidth %W 1 }
bind TkTable <Control-minus> { TableSetWidth %W -1 }

