/* tkAppInit.c --
 * 
 * Copyright (c) 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * This software is copyrighted by the Regents of the University of
 * California, Sun Microsystems, Inc., and other parties.  The following
 * terms apply to all files associated with the software unless explicitly
 * disclaimed in individual files.
 * 
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 * 
 * IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
 * DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
 * IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
 * NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 * 
 * RESTRICTED RIGHTS: Use, duplication or disclosure by the government
 * is subject to the restrictions as set forth in subparagraph (c) (1) (ii)
 * of the Rights in Technical Data and Computer Software Clause as DFARS
 * 252.227-7013 and FAR 52.227-19.
 */


#include "tcl.h"
#include "tk.h"

#include "Qddb.h"
#include "tclQddb.h"

#if defined(USE_TCLX) && USE_TCLX == 1
#include "tclExtend.h"
#endif

#if defined(USE_ITCL) && USE_ITCL == 1
int Itcl_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_ITCL2) && USE_ITCL2 == 1
int Itcl_Init _ANSI_ARGS_((Tcl_Interp *));
int Itk_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_EXPECT) && USE_EXPECT == 1
int Exp_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_XPM) && USE_XPM == 1 && TK_MAJOR_VERSION == 3
int Pinfo_Init _ANSI_ARGS_((Tcl_Interp *));
int Uxpm_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_BLT) && USE_BLT == 1
int Blt_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_TREE) && USE_TREE == 1
int Tree_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_TCLTCP) && USE_TCLTCP == 1
int TkTcp_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_TK_TABLE) && USE_TK_TABLE == 1
int Table_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_TIX) && USE_TIX == 1
int Tix_Init _ANSI_ARGS_((Tcl_Interp *));
#endif

#if defined(USE_TCL_RAW_TCP) && USE_TCL_RAW_TCP == 1
#include "tclRawTCP.h"
#endif

#if defined(USE_XACCESS) && USE_XACCESS == 1
#include "tkXAccess.h"
#endif

#if defined(USE_MEGAWIDGET) && USE_MEGAWIDGET == 1
#include "tkMegaWidget.h"
#endif

#if defined(USE_DRAGDROP) && USE_DRAGDROP == 1
#include "tkDragDrop.h"
#endif

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

#ifdef NEED_MATHERR
extern int matherr();
int *tclDummyMathPtr = (int *) matherr;
#endif

#if TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION < 4
/* The following variable is a special hack that allows applications
 * to be linked using the procedure "main" from the Tcl library.  The
 * variable generates a reference to "main", which causes main to
 * be brought in from the library (and all of Tcl with it).
 */
extern int main();
int *tclDummyMainPtr = (int *) main;
#else

int Tcl_AppInit _ANSI_ARGS_((Tcl_Interp *interp));

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *  This is the main program for the application.
 *
 * Results:
 *  None: Tcl_Main never returns here, so this procedure never
 *  returns either.
 *
 * Side effects:
 *  Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
main(argc, argv)
    int argc;           /* Number of command-line arguments. */
    char **argv;        /* Values of command-line arguments. */
{
#if !defined(USE_TCLX) || USE_TCLX == 0
    Tk_Main(argc, argv, Tcl_AppInit);
#else
    TkX_Main(argc, argv, Tcl_AppInit);
#endif
    return 0;           /* Needed only to prevent compiler warning. */
}
#endif


/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int Tcl_AppInit(interp)
    Tcl_Interp 			*interp;		/* Interpreter for application. */
{
    Tk_Window 			main;
    
    main = Tk_MainWindow(interp);
  
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#if defined(USE_TCLX) || USE_TCLX == 1
    /* Using the standard TclX stuff causes a problem
     * with itcl.   Just include the various commands.
     */
    if (TclXCmd_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#endif

#if defined(USE_EXPECT) && USE_EXPECT == 1
    if (Exp_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#endif

#if defined(USE_ITCL) && USE_ITCL == 1
    if (Itcl_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

#if defined(USE_ITCL2) && USE_ITCL2 == 1
    if (Itcl_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
    if (Itk_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

#if defined(USE_TCL_RAW_TCP) && USE_TCL_RAW_TCP == 1
    create_tclRawTCP();
#endif
  
#if defined(USE_TCL_TCP) && USE_TCL_TCP == 1
    if (TkTCP_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif

#if defined(USE_NEW_TCL_DP) && USE_NEW_TCL_DP == 1
    if (Tdp_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif
  
#if defined(USE_XACCESS) && USE_XACCESS == 1
    if (TkXAccess_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

#if defined(USE_MEGAWIDGET) && USE_MEGAWIDGET == 1
    if (TkMegaWidget_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

#if defined(USE_XPM) && USE_XPM == 1 && TK_MAJOR_VERSION == 3
    if (Pinfo_Init(interp) == TCL_ERROR)
      return TCL_ERROR;
    if (Uxpm_Init(interp) == TCL_ERROR)
      return TCL_ERROR;
#endif       

#if defined(USE_BLT) && USE_BLT == 1
    if (Blt_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

#if defined(USE_TREE) && USE_TREE == 1
    if (Tree_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

#if defined(USE_DRAGDROP) && USE_DRAGDROP == 1
    if (Tk_AddDragDropCmd(interp, main) == TCL_ERROR)
	return TCL_ERROR;
#endif

#if defined(USE_TIX) && USE_TIX == 1
    if (Tix_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

    if (TclQddb_Init(interp) == TCL_ERROR)
	return TCL_ERROR;

#if defined(USE_TK_TABLE) && USE_TK_TABLE == 1
    if (Table_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

#if TCL_MAJOR_VERSION >= 7 && TCL_MINOR_VERSION >= 5
    Tcl_SetVar(interp, "tcl_rcFileName", "~/.qddb_wishrc", TCL_GLOBAL_ONLY);
#else
    tcl_RcFileName = "~/.qddb_wishrc";
#endif
    return TCL_OK;
}

