#!/bin/sh
# The next line restarts using qwish \
exec QDDB_BIN_DIR/qwish QDDB_BIN_DIR/nxqddb "$@"

# nxqddb.tcl
#
# Generic Qddb interface using the nifty Fx toolkit.
#
# NxqddbSetup --
#     w    - frame
#     s    - schema
#     p    - printed schema
#     n    - current ancestry name
#     fnum - frame number


if {![info exists fx_config(entry_width)]} {
    set fx_config(entry_width) 30
}
lappend auto_path $qddb_library/fx 
if {[info exists blt_library]} {
    lappend auto_path $blt_library
}

set fx_config_dir .nxqddb_config
if {[catch "qddb_schema open [lindex $argv 0]" s] != 0} {
    puts "Cannot open Schema for relation: [lindex $argv 0]\n$s\n"; exit 1
}

Fx:Init $s

proc NxqddbSetup {w s p n fnum} {
    global gv_search_entry gv_init fx_config nxqddb_trans_name

    set first 0
    foreach i $p {
	if {[string compare $n ""] == 0} {
	    set newn [lindex $i 0]
	} else {
	    set newn $n.[lindex $i 0]
	}
	set f $w.f$fnum
	incr fnum
	if {[llength [lindex $i 2]] > 0} { # not a leaf
	    Fx_Frame f_$newn -w $f -attr $newn -side top -setschema $s -relief raised -bd 2 \
		-pady 0 -padx 0 -restrict $nxqddb_trans_name
	    pack $f.f_0 -side left -anchor ne -expand on -fill x
	    $f.f_0.l configure -anchor ne
	    pack $f.f_0.l -expand on -fill x -anchor ne
	    set f $f.f
	    frame $f -relief raised -bd 2 -highlightthickness 0
	    pack $f -side right -anchor ne
	    NxqddbSetup $f $s [lindex $i 2] $newn $fnum
	} else { # leaf
	    if {$gv_init} {
		Fx_Entry f_$newn -w $f -attr $newn -side left -anchor ne \
		    -width $fx_config(entry_width) -type Entry \
		    -setschema $s -padx 0 -pady 0
	    } else {
		set gv_init 1
		Fx_Entry f_$newn -w $f -attr $newn -side left -anchor ne -width $fx_config(entry_width) \
		    -type Entry -setschema $s -padx 0 -pady 0 -searchfor_entry $gv_search_entry
	    }
	    pack $f.f_0 -expand on -fill x -anchor ne
	    $f.f_0.l configure -anchor ne
	    pack $f.f_0.l -anchor ne -expand on -fill x
	    pack $f.e -expand off -fill none
	    if {!$first && [string compare $n ""] != 0} {
		set first 1
		f_$n configure -focus [f_$newn GetEntry]
	    }
	}
    }
}
proc max {a b} {
    if {$a < $b} {
	return $b
    }
    return $a
}
proc min {a b} {
    if {$a < $b} {
	return $a
    }
    return $b
}
proc XqddbReconfigure {{widg ""} {withdraw 1}} {
    global scrwid scrht fx_config

    if {$withdraw} {
	wm withdraw .
    }
    if {[string compare $widg ""] != 0} {
	pack $widg -expand off -fill none
    }
    wm minsize . $scrwid [expr $scrht / 10]; wm maxsize . $scrwid $scrht
    update
    update idletasks
    set wid [winfo reqwidth .c.f]
    set ht [winfo reqheight .c.f]
    .c configure -width $wid -height $ht
    .c configure -scrollregion [list 0 0 $wid $ht]
    update
    update idletasks
    set reqwid [winfo reqwidth .]; set reqht [winfo reqheight .]
    wm minsize . $reqwid [expr int(($reqht - $ht + $ht)/10)]; wm maxsize . $reqwid [min $reqht $scrht]
    if {[info exists fx_config(maingeom)] && [lindex $fx_config(maingeom) 1] < [min $reqht $scrht]} {
	wm geometry . \
	    ${reqwid}x[lindex $fx_config(maingeom) 1]+[lindex $fx_config(maingeom) 2]+[lindex $fx_config(maingeom) 3]
    } else {
	wm geometry . ${reqwid}x[min $reqht $scrht]
	if {[info exists fx_config(maingeom)]} {
	    wm geometry . +[lindex $fx_config(maingeom) 2]+[lindex $fx_config(maingeom) 3]	    
	}
    }
    if {$withdraw} {
	wm deiconify .    
    }
    update
    update idletasks
    set geo [split [wm geom .] +]
    set l2 [lindex $geo 0]
    set l2 [split $l2 x]
    set fx_config(maingeom) [concat $l2 [lrange $geo 1 2]]
}

proc BindConfigure {} {
    bind . <Configure> {
	if {[string compare %W .] == 0} {
	    set geo [split [wm geometry .] +]
	    set x [lindex $geo 1]
	    set y [lindex $geo 2]
	    set fx_config(maingeom) [list %w %h $x $y]
	    .c yview scroll 0 units
	}
    }
}

proc ReconfigureEntryWidths {} {
    global fx_config

    bind . <Configure> { }
    wm withdraw .
    foreach i [Fx_Entry :: GetInstances] {
	$i configure -width $fx_config(entry_width)
    }
    update
    XqddbReconfigure
    BindConfigure
}

proc ManPage {} {
    global qddb_library qddb_version fx_config

    if {[winfo exists .manPage]} {
	wm withdraw .manPage
	wm deiconify .manPage
	focus .manPage
	update idletasks
        return
    }
    toplevel .manPage
    wm title .manPage "nxqddb manual page"
    set x .manPage.buttons
    frame $x -highlightthickness 0
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "
	set [list fx_config(geom,\$manPage\$)] \[wm geometry .manPage\]
        destroy .manPage
    "
    pack $x.ok -fill x

    if {[winfo depth .] < 8} {
	label .manPage.qddb -bitmap @$qddb_library/fx/pixmaps/qddb2.xbm
    } else {
	image create photo qddb_color2 -file $qddb_library/fx/pixmaps/qddb_color2.gif
	label .manPage.qddb -image qddb_color2 -justify c
    }
    pack .manPage.qddb -side top

    message .manPage.label -justify center -aspect 400 \
	-text "nxqddb(1) Manual Page"
    pack .manPage.label -side top

    message .manPage.version -justify center -aspect 400 \
        -text "Quick and Dirty DataBase\nVersion $qddb_version\n"
    pack .manPage.version -side top

    message .manPage.copyright -justify center -aspect 400 \
	-text "Copyright(c) 1993, 1994, 1995\nHerrin Software Development, Inc.\nAll rights reserved.\n" 
    pack .manPage.copyright -side top

    set fd [open $qddb_library/fx/nxqddb.0 "r"]
    set MAN [read $fd]
    close $fd
    set x .manPage.f
    frame $x -highlightthickness 0
    pack $x -side top -expand on -fill both
    scrollbar $x.s -orient vertical -relief sunken -command [list $x.c yview]
    pack $x.s -side right -fill y
    text $x.c -relief sunken -bd 2 -yscrollcommand [list $x.s set] -wrap word -setgrid on
    pack $x.c -side left -expand on -fill both
    $x.c insert 0.0 $MAN
    $x.c configure -state disabled
    if {[info exists fx_config(geom,\$manPage\$)]} {
	wm geometry .manPage $fx_config(geom,\$manPage\$)
    } else {
	wm geometry .manPage +70+0
    }
}

set scrwid [winfo screenwidth .]
set scrht [winfo screenheight .]

toplevel .msg
if {[winfo depth .] < 8} {
    label .msg.l -bitmap @$qddb_library/fx/pixmaps/qddb.xbm
} else {
    image create photo qddb_color -file $qddb_library/fx/pixmaps/qddb_color.gif
    label .msg.l -image qddb_color -justify c
}
pack .msg.l -side top -expand on -fill x

set msgcolor powderblue
if {!$fx_monochrome} {
    .msg.l configure -bg $msgcolor
    .msg configure -bg $msgcolor
}
set path [qddb_schema path $s]
set tail [file tail $path]
if {[string compare $tail ""] == 0} {
    set tail [file tail [file dirname $path]]
}
wm title .msg "nxqddb ($tail)"
label .msg.m1 -text "Reading schema from relation `$tail'"
catch [list .msg.m1 configure -font -adobe-helvetica-bold-r-*-*-*-180-*-*-*-*-*-*]
pack .msg.m1 -side top -expand on -fill both
label .msg.m2 -text "\nplease wait..."
catch [list .msg.m2 configure -font -adobe-helvetica-bold-r-*-*-*-180-*-*-*-*-*-*]
pack .msg.m2 -side top -expand on -fill both
if {!$fx_monochrome} {
    .msg.m1 configure -bg $msgcolor
    .msg.m2 configure -bg $msgcolor
}
wm withdraw .
if {$fx_blt} {
    blt_busy hold .msg
    blt_busy hold .msg.l
    blt_busy hold .msg.m1
    blt_busy hold .msg.m2
}
wm withdraw .msg
update idletasks
update
wm geometry .msg +[expr $scrwid/2 - [winfo reqwidth .msg]/2]+[expr $scrht/2 - [winfo reqheight .msg]/2]
wm deiconify .msg
update idletasks
update
wm title . "nxqddb ($tail)"
set nxqddb_trans_name [split [qddb_schema path $s] /]
set nxqddb_trans_name [glob ~]/.nxqddb_restrict/[join $nxqddb_trans_name .]
Fx_Menubar menubar -w .mb -schema $s -array gv_myattr -config_dir .nxqddb_config \
	-restrict $nxqddb_trans_name
.mb.config.menu add separator
.mb.config.menu add cascade -label "Entry Widths" -menu .mb.config.menu.entrywidth \
	-underline 0
menu .mb.config.menu.entrywidth -tearoff 0
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 10 -label 10 \
    -command ReconfigureEntryWidths
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 20 -label 20 \
    -command ReconfigureEntryWidths
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 30 -label 30 \
    -command ReconfigureEntryWidths
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 40 -label 40 \
    -command ReconfigureEntryWidths
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 50 -label 50 \
    -command ReconfigureEntryWidths
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 60 -label 60 \
    -command ReconfigureEntryWidths
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 70 -label 70 \
    -command ReconfigureEntryWidths
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 80 -label 80 \
    -command ReconfigureEntryWidths
.mb.config.menu.entrywidth add radiobutton -variable fx_config(entry_width) -value 90 -label 90 \
    -command ReconfigureEntryWidths
.mb.help.menu add separator
.mb.help.menu add command -label "nxqddb Manual Page" -command ManPage -underline 0
set gv_search_entry [menubar SearchForEntry]
scrollbar .s -command {.c yview}
pack .s -side right -expand on -fill y
canvas .c -yscrollcommand {.s set} -highlightthickness 0
pack .c -side left -expand on -fill both
frame .c.f -highlightthickness 0
pack .c.f -side top -expand on -fill both
.c create window 0 0 -anchor nw -window .c.f
set gv_init 0
NxqddbSetup .c.f $s [qddb_schema print $s] "" 0

update idletasks
incr scrht -50
XqddbReconfigure "" 0
BindConfigure

menubar configure -instances [Fx_Entry :: GetInstances] -frames [Fx_Frame :: GetInstances]
Fx_Entry :: BeforeReconfigure {wm withdraw .}
Fx_Entry :: AfterReconfigure {XqddbReconfigure [$this GetEntry] 1}
Fx_Menubar :: AfterReconfigure {XqddbReconfigure}
Fx_Entry :: ScrollbarSide left
# SearchModeProc will release the blt_busy window
menubar SearchModeProc
if {$fx_blt} {
    blt_busy forget .msg.l
    blt_busy forget .msg.m1
    blt_busy forget .msg.m2
}
destroy .msg
update idletasks
update
wm deiconify .
.c yview scroll 0 units
eval .s set [.c yview]
