# fx_widgets.tcl
#
# Fx Toolkit for Qddb widgets

itcl_class Fx_Attribute {
    constructor {config} {
	global fx_config

	if {![info exists attr]} {
	    error "Fx_Attribute: you must specify -attr"
	}
	if {![info exists label]} {
	    set verbosename [qddb_schema option verbosename $schema $attr]
	    if {[string compare $verbosename ""] == 0} {
		set label [split $attr .]
		set label [lindex $label [expr [llength $label] - 1]]
	    } else {
		set label $verbosename
	    }
	}
	set isexpandable [qddb_schema option isexpandable $schema $attr]
	foreach i {label labelfg helpmsg padx pady side} {
	    if {[info exists fx_config(entry,$i,$attr)]} {
		set $i $fx_config(entry,$i,$attr)
	    }
	}
	if {![info exists fx_config($attr,ascending)]} {
	    set leaves [qddb_schema leaves $schema $attr]
	    set fx_config($attr,print) [lrange $leaves 0 4]
	    set fx_config($attr,alignment) {}
	    set fx_config($attr,widths) {}
	    set fx_config($attr,separators) {}
	    foreach i $fx_config($attr,print) {
		lappend fx_config($attr,alignment) left
		lappend fx_config($attr,widths) 0
		lappend fx_config($attr,separators) ""
	    }
	    set fx_config($attr,dontprint) [lrange $leaves 5 end]
	    set fx_config($attr,sortby) $leaves
	    set fx_config($attr,ascending) {}
	    foreach i $fx_config($attr,sortby) {
		lappend fx_config($attr,ascending) yes
	    }
	}
    }
    destructor {
	catch "destroy $w"
    }

    method BuildFrame {} {
	global fx_monochrome fx_config

	frame $w -relief $relief -bd $bd
	pack $w -expand on -fill both -padx $padx -pady $pady
	frame $w.f_0
	pack $w.f_0 -side $side -anchor $anchor
	if {$fx_monochrome} {
	    set monomode 1
	} else {
	    set monomode 0
	}
	label $w.f_0.l -text $label -anchor e
	if {$monomode == 0 && [info exists labelfg]} {
	    $w.f_0.l configure -fg $labelfg
	}
	pack $w.f_0.l -side left -anchor ne
	if {[string compare [qddb_schema option isexpandable $schema $attr] yes] == 0} {
	    if {$showbutton_add} {
		if {[string compare [string index $b_add 0] @] == 0} {
		    set what bitmap
		} else {
		    set what text
		}
		button $w.f_0.b_add -$what $b_add -relief raised -bd 2 -padx 0m -pady 0m \
		    -command [list $this AddInstance] -takefocus $fx_config(\$tabbing\$,add)
		if {$monomode == 0 && [info exists labelfg]} {
		    $w.f_0.b_add configure -fg $labelfg
		}
		pack $w.f_0.b_add -side left -anchor ne
		lappend buttons $w.f_0.b_add
		lappend adddeletebuttons $w.f_0.b_add
		lappend addbuttons $w.f_0.b_add
	    }
	    if {$showbutton_view} {
		if {[string compare [string index $b_view 0] @] == 0} {
		    set what bitmap
		} else {
		    set what text
		}
		button $w.f_0.b_view -$what $b_view -relief raised -bd 2 -padx 0m -pady 0m \
		    -command [list $this ViewInstance] -takefocus $fx_config(\$tabbing\$,view)
		if {$monomode == 0 && [info exists labelfg]} {
		    $w.f_0.b_view configure -fg $labelfg
		}
		pack $w.f_0.b_view -side left -anchor ne
		lappend buttons $w.f_0.b_view
		lappend viewbuttons $w.f_0.b_view
	    }
	    if {$showbutton_del} {
		if {[string compare [string index $b_del 0] @] == 0} {
		    set what bitmap
		} else {
		    set what text
		}
		button $w.f_0.b_del -$what $b_del -relief raised -bd 2 -padx 0m -pady 0m \
		    -command [list $this DelInstance] -takefocus $fx_config(\$tabbing\$,del)
		if {$monomode == 0 && [info exists labelfg]} {
		    $w.f_0.b_del configure -fg $labelfg
		}
		pack $w.f_0.b_del -side left -anchor ne
		lappend buttons $w.f_0.b_del
		lappend adddeletebuttons $w.f_0.b_del
		lappend delbuttons $w.f_0.b_del
	    }
	}
    }
    proc DisableButtons {} {
	if {[info exists buttons]} {
	    foreach i $buttons {
		$i configure -state disabled
	    }
	}
    }
    proc DisableAddDeleteButtons {} {
	if {[info exists adddeletebuttons]} {
	    foreach i $adddeletebuttons {
		$i configure -state disabled
	    }
	}
    }
    proc EnableButtons {} {
	if {[info exists buttons]} {
	    foreach i $buttons {
		$i configure -state normal
	    }
	}
    }
    proc ResetTabbing {type takefocus} {
	foreach i $type {
	    if {[string compare $i scrollbars] == 0} {
		foreach j $scrollbars {
		    $j configure -takefocus $takefocus
		}
	    } else {
		foreach j [set ${i}buttons] {
		    $j configure -takefocus $takefocus
		}
	    }
	}
    }
    method AddInstance {{checks 1}} {
	global $array

	if {$checks && [Fx:CheckMandatoryFields $schema $attr $array]} {
	    return
	}
	if {$checks && [Fx:CurrentTypeCheck $schema] || [Fx:CurrentUniqueCheck $schema]} {
	    return
	}
	if {[info exists beforeadd]} {
	    eval $beforeadd
	}
	if {[info exists copy_instances]} {
	    set leaves [qddb_schema leaves $schema $attr]
	    if {[llength $leaves] > 1} {
		set leaves $copy_instances
	    } elseif {$copy_instances == 0} {
		set leaves {}
	    }
	    foreach i $leaves {
		set leaftmp($i) [set ${array}($i)]
	    }
	}
	if {$addtoend} {
	    set newinst [qddb_instance new $view $attr]
	    qddb_instance switch $view $attr $newinst
	} else {
	    set newinst [qddb_instance new $view $attr]
	    qddb_instance move $view $attr $newinst 1
	    qddb_instance switch $view $attr 1
	}
	if {[info exists copy_instances]} {
	    foreach i $leaves {
		uplevel \#0 [list set ${array}($i) $leaftmp($i)]
	    }
	}
	if {$checks} {
	    catch "focus $focus"
	}
	if {[info exists afteradd]} {
	    eval $afteradd
	}
	set transattr [split $attr .]
	set transattr [string tolower [join $transattr _]]
	if {[winfo exists .view_$transattr]} {
	    ViewInstance 1
	}
	ReconfigureViewsBelow
	TupleChanged 1
    }
    method DelInstance {} {
	global $array

	if {[fx_dialog .dialog "Deleting Instance" "Are you sure you want to delete?" \
		 warning 0 Cancel Ok] == 0} {
	    return
	}
	if {[info exists beforedelete]} {
	    eval $beforedelete
	}
	set curnum [qddb_instance current $view $attr]
	if {[qddb_instance isempty $view $attr $curnum] == 0 || [qddb_instance maxnum $view $attr] > 1} {
	    qddb_instance remove $view $attr $curnum
	    if {[info exists afterdelete]} {
		eval $afterdelete
	    }
	    set transattr [split $attr .]
	    set transattr [string tolower [join $transattr _]]
	    if {[winfo exists .view_$transattr]} {
		ViewInstance 1
	    }
	    ReconfigureViewsBelow
	    TupleChanged 1
	}
	catch "focus $focus"
    }
    method BuildInst {} {
	set namelist [split $attr "."]
	set len [llength $namelist]
	incr len -1
	set buildinst ""
	for {set i 0} {$i < $len} {incr i} {
	    if {$i == 0} {
		set attribute [lindex $namelist 0]
	    } else {
		set attribute [join [lrange $namelist 0 $i] "."]
	    }
	    set cur [qddb_instance current $view $attribute]
	    if {[string compare $buildinst ""] != 0} {
		set buildinst [join [list $buildinst $cur] "."]
	    } else {
		set buildinst $cur
	    }
	}
	return [join [list $attr $buildinst] ","]
    }
    method ViewInstance {{reconfig 0}} {
	global fx_config fx_blt

	if {[Fx:CheckMandatoryFields $schema $attr $array]} {
	    return
	}
	if {[Fx:CurrentTypeCheck $schema] || [Fx:CurrentUniqueCheck $schema]} {
	    return
	}
	set transattr [split $attr .]
	set transattr [string tolower [join $transattr _]]
	if {!$reconfig} {
	    if {[winfo exists .view_$transattr]} {
		ReconfigureViewsBelow
		wm withdraw .view_$transattr
		wm deiconify .view_$transattr
		set reconfig 1
	    } else {
		set verbosename [qddb_schema option verbosename $schema $attr]
		if {[string compare $verbosename ""] == 0} {
		    set verbosename [split $attr .]
		    set verbosename [lindex $verbosename [expr [llength $verbosename] - 1]]
		}
	    }
	    if {!$reconfig && $fx_blt} {
		blt_busy hold .
		update; update idletasks
	    }
	} else {
	    if {![winfo exists .view_$transattr]} {
		return
	    }
	}
	set asc {}
	set x 0
	foreach i $fx_config($attr,ascending) {
	    if {[string compare $i yes] == 0} {
		lappend asc [lindex $fx_config($attr,sortby) $x] 
	    }
	    incr x
	}
	if {[info exists rowtbl] && [string length $rowtbl] > 0} {
	    set maxnum [qddb_table row maxnum $rowtbl]
	    for {set i 1} {$i <= $maxnum} {incr i} {
		catch "qddb_rows delete [qddb_table row cget $rowtbl $i -comment]"
	    }
	    catch "qddb_table delete $rowtbl"
	}
	if {[info exists fx_config($attr,unsorted)] && $fx_config($attr,unsorted)} {
	    set rowtbl [qddb_rows all -format table \
		    -instance [BuildInst] \
		    -attrs $fx_config($attr,print) \
		    -print $fx_config($attr,print) \
		    -rowdescs on \
		    $tuple]
	} else {
	    set rowtbl [qddb_rows all -format table \
		    -sortby $fx_config($attr,sortby) \
		    -ascending $asc \
		    -instance [BuildInst] \
		    -attrs $fx_config($attr,print) \
		    -print $fx_config($attr,print) \
		    -rowdescs on \
		    $tuple]
	}
	if {[info exists fx_config($attr,widths)]} {
	    set x [qddb_table col maxnum $rowtbl]
	    for {set i 0} {$i < $x} {incr i} {
		set iplus1 [expr $i + 1]
		set tmp [lindex $fx_config($attr,widths) $i]
		qddb_table col configure $rowtbl $iplus1 -width $tmp
		set tmp [lindex $fx_config($attr,separators) $i]
		if {[string length $tmp] == 0} {
		    set tmp " "
		}
		qddb_table col configure $rowtbl $iplus1 -separator $tmp
		set tmp [lindex $fx_config($attr,alignment) $i]
		qddb_table col configure $rowtbl $iplus1 -justify $tmp
	    }
	}
	if {[info exists fx_config($attr,linenumbers)]} {
	    set rowtitles $fx_config($attr,linenumbers)
	} else {
	    set rowtitles 0
	}
	set mytext [qddb_table getval $rowtbl -format rows -coltitles on -rowtitles $rowtitles]
	if {$reconfig} {
	    set curselect [.view_$transattr.f.l2 curselection]
	    set nearesty  [.view_$transattr.f.l2 nearest 0]
	    view_$transattr ClearRows
	    view_$transattr ClearContents
	    view_$transattr configure -headings [lindex $mytext 0]
	} else {
	    toplevel .view_$transattr
	    wm title .view_$transattr "Viewing: $verbosename"
	    if {[info exists fx_config(geom,view_$transattr)]} {
		wm geometry .view_$transattr $fx_config(geom,view_$transattr)
	    }
	    set f .view_$transattr.f2
	    frame $f
	    pack $f -side bottom -fill x
	    button $f.select -text Select -command [list view_$transattr OnSelect]
	    pack $f.select -side left -padx 6m -pady 2m -ipadx 6m -ipady 2m
	    button $f.cancel -text Dismiss \
		    -command [list catch "destroy .view_$transattr; \
		    view_$transattr delete"]
	    pack $f.cancel -side left -padx 6m -pady 2m -ipadx 6m -ipady 2m
	    set px [$f.select cget -padx]
	    set py [$f.select cget -pady]
	    button $f.print -text Print -command \
		    [list $this PrintCmd $mytext .view_$transattr]
	    set buttfont [$f.print cget -font]
	    checkbutton $f.pin -text "Pin" -variable fx_config(pin,view_$transattr) \
		    -onvalue 1 -offvalue 0 -bd 2 -padx $px -pady $py -font $buttfont
	    pack $f.pin -side right -padx 6m -pady 2m -ipadx 6m -ipady 2m
	    pack $f.print -side right -padx 6m -pady 2m -ipadx 6m -ipady 2m
	    Fx_SingleColumnListBox view_$transattr -w .view_$transattr.f \
		    -headings [lindex $mytext 0] \
		    -width 60 \
		    -single_select on \
		    -exportselection off \
		    -height 10 \
		    -onselect [list $this PinnedViewProc view_$transattr]
	    set current_views(view_$transattr) $this
	}
	view_$transattr AppendRows [lrange $mytext 1 end]
	if {$reconfig} {
	    view_$transattr Display 1
	    .view_$transattr.f.l2 select clear 0 end
	    .view_$transattr.f.l2 select set $curselect $curselect
	    .view_$transattr.f.l2 select anchor $curselect
	    .view_$transattr.f.l2 activate $curselect
	    .view_$transattr.f.l2 yview $nearesty
	} else {
	    bind .view_$transattr <Configure> [list $this ConfigureWindow $transattr]
	    if {[info exists fx_config(geom,view_$transattr)]} {
		wm geometry .view_$transattr $fx_config(geom,view_$transattr)
	    }
	    view_$transattr Display 0
	}
	if {!$reconfig && $fx_blt} {
	    catch "blt_busy forget ."
	}
	update idletasks
	if {!$reconfig} {
	    tkwait window .view_$transattr.f
	    catch "destroy .view_$transattr"
	    catch "unset current_views(view_$transattr)"
	}
    }
    proc KillAllViews {} {
	if {[info exists current_views]} {
	    foreach i [array names current_views] {
		catch "destroy .${i}.f"
		catch "$i delete"
		catch "unset current_views($i)"
		catch "destroy .$i"
	    }
	    catch "unset current_views"
	}
    }
    method ReconfigureViewsBelow {} {
	if {[info exists current_views]} {
	    set transattr [split $attr .]
	    set transattr [string tolower [join $transattr _]]
	    foreach i [array names current_views] {
		if {[string match view_${transattr}_* ${i}] == 1} {
		    set myinst $current_views($i)
		    $myinst ViewInstance 1
		}
	    }
	    update idletasks
	}
    }
    method ConfigureWindow {transattr} {
	global fx_config
	set fx_config(geom,view_$transattr) [wm geometry .view_$transattr]
    }
    method PinnedViewProc {inst i} {
	global fx_config

	if {![info exists fx_config(pin,$inst)] || $fx_config(pin,$inst) == 0} {
	    catch "destroy .$inst"
	    catch "$inst delete"
	    $this SelectRow $i
	    focus -force [focus -lastfor .]
	} else {
	    $this SelectRow $i
	}
    }
    method PrintCmd {contents t} {
	global fx_config fx:status_variable fx_blt

	Fx_PrintDialog ${this}_print_dialog
	if {$fx_config(cancel_print) == 0} {
	    if {$fx_blt} {
		blt_busy hold .
		if {[winfo exists ${t}]} {
		    blt_busy hold $t
		}
	    }
	    update idletasks
	    Fx:Print $contents
	    if {$fx_blt} {
		catch "blt_busy forget ."
		if {[winfo exists $t]} {
		    catch "blt_busy forget $t"
		}
	    }
	    if {[winfo exists $t]} {
		if {[catch "focus -lastfor $t" resultswin] == 0} {
		    catch "focus -force $resultswin"
		}
	    }
	    update idletasks
	} else {
	    ::set fx:status_variable "Printing cancelled."
	}
    }
    method SelectRow {i} {
	set oldchanged [TupleChanged]
	if {[info exists beforechange]} {
	    eval $beforechange
	}
	qddb_view set $view [qddb_table row cget $rowtbl [expr $i + 1] -comment]
	if {[info exists afterchange]} {
	    eval $afterchange
	}
	TupleChanged $oldchanged
	ReconfigureViewsBelow
    }
    proc TupleChanged {{val ""} {n1 ""} {n2 ""} {op ""}} {
	if {[string compare $val ""] == 0} {
	    return $tuple_changed
	} else {
	    set tuple_changed $val
	}
    }
    method configure {config} {
    }

    # Generic Qddb stuff
    common schema
    public setschema {} {set schema $setschema}
    common view
    public setview {} {set view $setview}
    common tuple
    public settuple {} {set tuple $settuple}
    public attr
    public copy_instances
    protected rows {}
    common tuple_changed 0
    protected rowtbl
    protected isexpandable
    protected verbosename
    common current_views
    common restrict_dir {}
    public restrict {} {set restrict_dir $restrict}

    # On-events
    public beforedelete
    public beforeadd
    public beforechange
    public afterdelete
    public afteradd
    public afterchange
    public addtoend 1

    # Label stuff
    public label
    public labelfg
    public helpmsg "No help available for this field"

    public array gv_attr

    # Button stuff
    common b_add Add
    common b_view View
    common b_del Del
    public showbutton_add 1
    public showbutton_del 1
    public showbutton_view 1
    public button_add $b_add {set b_add $button_add}
    public button_view $b_view {set b_view $button_view}
    public button_del $b_del {set b_del $button_del}
    common buttons
    common adddeletebuttons
    common addbuttons {}
    common viewbuttons {}
    common delbuttons {}
    common scrollbars {}

    # Frame stuff
    public w
    public padx 0m
    public pady 0m
    public side left
    public anchor w
    public relief flat
    public bd 2
    public focus .
}

itcl_class Fx_Frame {
    inherit Fx_Attribute

    constructor {config} {
	Fx_Attribute::constructor
	lappend instances $this
	BuildFrame
	bind $w.f_0.l <Control-Button-3> [list $this Reconfigure]
    }
    destructor {
	Fx_Attribute::destructor
    }
    method Reconfigure {} {
	Fx:ConfigureEntry $schema $attr $restrict_dir
    }
    proc GetInstances {} {
	return $instances
    }
    common instances {}
}

itcl_class Fx_Entry {
    inherit Fx_Attribute

    constructor {config} {
	global fx_config

	Fx_Attribute::constructor
	lappend instances $this
	foreach i {entryfg height width default_values type read_only mandatory unique} {
	    if {[info exists fx_config($attr,$i)]} {
		set $i $fx_config($attr,$i)
	    } else {
		if {[info exists $i]} {
		    set fx_config($attr,$i) [set $i]
		}
	    }
	}
	if {[info exists array]} {
	    global $array

	    set textvariable ${array}(${attr})
	    set $textvariable ""
	    uplevel \#0 [list trace variable $textvariable w [list Fx_Entry :: TupleChanged 1]]
	}
	foreach i {regexp_search range_search numeric_search date_search} {
	    if {![info exists fx_config(\$$i\$,$attr)]} {
		if {[set $i] == 1} {
		    set $i 1
		} else {
		    set $i 0
		}
	    } else {
		set $i $fx_config(\$$i\$,$attr)
	    }
	    set fx_config(\$$i\$,$attr) [set $i]
	}
	BuildFrame
	BuildEntry
	bind $w.f_0.l <Control-Button-3> [list $this Reconfigure]
	if {![info exists firstentry]} {
	    set firstentry $this
	}
	if {[qddb_schema option exclude $schema $attr]} {
	    lappend excluded_entries $w.e
	}
    }
    destructor {
	if {[info exists textvariable]} {
	    global $array fx_thack

	    uplevel \#0 [list trace vdelete $textvariable w {Fx_Entry :: TupleChanged 1}]
	    uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
	    uplevel \#0 [list trace vdelete fx_thack($w.e) w [list $this RefreshTextVar]]
	}
	destroy $w
    }

    method FormatField {} {
	global fx:mode_variable fx:change_modeval fx:add_modeval
	global $array fx_config

	if {([string compare ${fx:mode_variable} ${fx:change_modeval}] != 0 && \
		[string compare ${fx:mode_variable} ${fx:add_modeval}] != 0) || \
		$fx_config(force_field_formatting) == 0} {
	    return
	}
	if {[string compare $type Entry] == 0} {
	    switch [qddb_schema option type $schema $attr] {
		real {
		    set oldval [$w.e get]
		    if {[catch [list expr double($oldval)] newval] != 0} {
			return
		    }
		    set newval [format [qddb_schema option format $schema $attr] $newval]
		    if {[string compare $oldval $newval] != 0} {
			uplevel \#0 [list set ${array}($attr) $newval]
		    }
		}
		integer {
		    set oldval [$w.e get]
		    if {[catch [list expr int($oldval)] newval] != 0} {
			return
		    }
		    set newval [format [qddb_schema option format $schema $attr] $newval]
		    if {[string compare $oldval $newval] != 0} {
			uplevel \#0 [list set ${array}($attr) $newval]
		    }
		}
		date {
		    set oldval [$w.e get]
		    set fmt [qddb_schema option format $schema $attr]
		    if {[catch [list qddb_util formatdate $fmt $oldval] newval] == 0} {
			if {[string compare $oldval $newval] != 0} {
			    uplevel \#0 [list set ${array}($attr) $newval]
			}
		    }
		}
	    }
	}
    }
    method BuildEntry {} {
	global $array fx_thack fx_config fx_monochrome fx:mode_variable
	global fx:search_modeval

	if {[info exists beforereconfigure]} {
	    eval $beforereconfigure
	}
	foreach i {height width default_values type read_only mandatory unique} {
	    if {[info exists fx_config($attr,$i)]} {
		set $i $fx_config($attr,$i)
	    }
	}
	if {[winfo exists $w.e]} {
	    destroy $w.e
	    if {[winfo exists $w.s]} {
		destroy $w.s
	    }
	    if {[info exists textvariable]} {
		uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
		uplevel \#0 [list trace vdelete fx_thack($w.e) w [list $this RefreshTextVar]]
	    }
	}
	switch $type {
	    Entry {
		entry $w.e -relief sunken -bd 2 -width $width 
		if {[info exists entryfg]} {
		    $w.e configure -fg $entryfg
		}
		if {[info exists textvariable]} {
		    $w.e configure -textvariable $textvariable 
		}
		pack $w.e -side right -expand on -fill x -anchor nw
		if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
			[info exists read_only] && $read_only == 1} {
		    $w.e configure -state disabled
		}
		if {[info exists mandatory] && $mandatory == 1 && \
			$fx_monochrome == 0} {
		    $w.e configure -bg $fx_config(mandatory_field_bg)
		}
		bind $w.e <FocusIn> "$this ReFocus"
		bind $w.e <FocusOut> [list +$this FormatField]
		bind $w.e <Return> [list $this FormatField]
		set sr [lsearch -exact $scrollbars $w.s]
		if {$sr != -1} {
		    lreplace $scrollbars $sr $sr
		}
		set sr [lsearch -exact $scrollbars $w.e.s]
		if {$sr != -1} {
		    lreplace $scrollbars $sr $sr
		}
	    }
	    Text {
		scrollbar $w.s -relief sunken -command [list $w.e yview] \
			-takefocus $fx_config(\$tabbing\$,scrollbars)
		pack $w.s -side $scrollbarside -fill y
		lappend scrollbars $w.s
		text $w.e -relief sunken -bd 2 -height $height -width $width \
		    -yscroll [list $w.s set]
		if {[info exists entryfg]} {
		    $w.e configure -fg $entryfg
		}
		if {[info exists textvariable]} {
		    $w.e insert 0.0 [set $textvariable]
		    uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
		    uplevel \#0 [list trace variable fx_thack($w.e) w [list $this RefreshTextVar]]
		}
		pack $w.e -side right -expand on -fill both
		if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
			[info exists read_only] && $read_only == 1} {
		    $w.e configure -state disabled
		}
		if {[info exists mandatory] && $mandatory == 1 && \
			$fx_monochrome == 0} {
		    $w.e configure -bg $fx_config(mandatory_field_bg)
		}
		set sr [lsearch -exact $scrollbars $w.e.s]
		if {$sr != -1} {
		    lreplace $scrollbars $sr $sr
		}
	    }
	    Radiobutton {
		if {![info exists default_values]} {
		    entry $w.e -relief sunken -bd 2 -width $width 
		    if {[info exists entryfg]} {
			$w.e configure -fg $entryfg
		    }
		    if {[info exists textvariable]} {
			$w.e configure -textvariable $textvariable 
		    }
		    break
		}
		frame $w.e -relief sunken -bd 0 -highlightthickness 0 -takefocus 0
		if {$height > 1} {
		    scrollbar $w.e.s -relief sunken -command [list $w.e.t yview] \
			    -takefocus $fx_config(\$tabbing\$,scrollbars)
		    pack $w.e.s -side $scrollbarside -fill y
		    lappend scrollbars $w.e.s
		    text $w.e.t -relief sunken -bd 2 -height $height -width $width -state disabled \
			    -yscroll [list $w.e.s set] -highlightthickness 0 -takefocus 0
		} else {
		    frame $w.e.t -relief sunken -bd 2 -highlightthickness 0 -takefocus 0
		}
		set x 0
		set row 0
		foreach i $default_values {
		    radiobutton $w.e.t.r$x -value $i -text $i -relief flat \
			-variable $textvariable -padx 0m -pady 0m
		    if {[info exists entryfg]} {
			$w.e.t.r$x configure -fg $entryfg
		    }
		    pack $w.e.t.r$x -side left -expand on -fill x
		    bind $w.e.t.r$x <Button-3> {%W deselect; break}
		    bind $w.e.t.r$x <Shift-space> {%W deselect; break}
		    bind $w.e.t.r$x <Shift-Return> {%W deselect; break}
		    if {[info exists mandatory] && $mandatory == 1 && \
			    $fx_monochrome == 0} {
			$w.e.t.r$x configure -bg $fx_config(mandatory_field_bg)
		    }
		    if {$height > 1} {
			$w.e.t window create {end - 1 chars} -window $w.e.t.r$x
		    }
		    incr x
		}
		pack $w.e.t -side top -expand on -fill both
		pack $w.e -side right -expand on -fill both
		if {$height == 1} {
		    set sr [lsearch -exact $scrollbars $w.s]
		    if {$sr != -1} {
			lreplace $scrollbars $sr $sr
		    }
		}
	    }
	}
	set focus $w.e
	if {[info exists afterreconfigure]} {
	    eval $afterreconfigure
	}
    }
    method ReFocus {} {
	global fx:current_focus $array

	if {[info exists fx:current_focus]} {
	    if {[string compare [lindex ${fx:current_focus} 1] $w.e] != 0} {
		if {![Fx:CurrentTypeCheck $schema] && ![Fx:CurrentUniqueCheck $schema]} {
		    ::set fx:current_focus [list $attr $w.e]
		} else {
		    focus [lindex [::set fx:current_focus] 1]
		    ::set fx:current_focus [list $attr $w.e]
		}
	    }
	} else {
	    ::set fx:current_focus [list $attr $w.e]
	}
    }
    method RefreshText {{n1 ""} {n2 ""} {op ""}} {
	global $array

	$w.e configure -state normal
	if {[string compare $op u] == 0} {
	    $w.e delete 0.0 end
	} else {
	    set i [$w.e index insert]
	    $w.e delete 0.0 end
	    set var [uplevel \#0 [list set $textvariable]]
	    $w.e insert 0.0 $var
	    $w.e mark set insert $i
	    $w.e yview -pickplace insert
	}
	if {[info exists read_only] && $read_only == 1} {
	    $w.e configure -state disabled
	}
    }
    method RefreshTextVar {{n1 ""} {n2 ""} {op ""}} {
	uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
	set tuple_changed 1
	uplevel \#0 [list set $textvariable [$w.e get 0.0 end]]
	uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
    }
    method Reconfigure {} {
	global fx_config

	if {$userconfig && [Fx:ConfigureEntry $schema $attr $restrict_dir] == 1} {
	    BuildEntry
	}
    }
    method GetAttr {} {
	return $attr
    }
    method GetAttrPair {} {
	return [list $attr $textvariable]
    }
    method GetTextVariable {} {
	return $textvariable
    }
    method configure {config} {
	foreach i $config {
	    switch $i {
		Fx_Attribute::array {
		    if {[string compare $type Entry] == 0} {
			if {[info exists $textvariable]} {
			    uplevel \#0 [list trace vdelete $textvariable w {Fx_Entry :: TupleChanged 1}]
			}
			set textvariable ${array}($attr)
			catch "$w.e configure -textvariable $textvariable"
			uplevel \#0 [list trace variable $textvariable w {Fx_Entry :: TupleChanged 1}]
		    } elseif {[string compare $type Radiobutton] == 0} {
			set x 0
			if {[info exists $textvariable]} {
			    uplevel \#0 [list trace vdelete $textvariable w {Fx_Entry :: TupleChanged 1}]
			}
			set textvariable ${array}($attr)
			while {[catch "$w.e.t.r$x configure -variable $textvariable"] == 0} {
			    incr x
			}
			uplevel \#0 [list trace variable $textvariable w {Fx_Entry :: TupleChanged 1}]
		    } else {
			if {[info exists textvariable]} {
			    uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
			}
			set textvariable ${array}($attr)
			global ${array}
			uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
			set $textvariable {}
			uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
		    }
		}
		Fx_Entry::width {
		    switch $type {
			Entry {
			    global fx_config
			    $w.e configure -width $width
			    set fx_config($attr,width) $width
			}
			Text {
			    global fx_config
			    $w.e configure -width $width
			    set fx_config($attr,width) $width
			}
			Radiobutton {
			    global fx_config
			    $w.e.t configure -width $width
			    set fx_config($attr,width) $width
			}
		    }
		}
	    }
	}
    }

    proc EnableReadOnlyWidgets {{all 0}} {
	foreach i $instances {
	    $i EnableReadOnly $all
	}
    }
    proc DisableReadOnlyWidgets {{all 0}} {
	foreach i $instances {
	    $i DisableReadOnly $all
	}
    }
    method DisableReadOnly {all} {
	if {$all || ([info exists read_only] && $read_only == 1)} {
	    if {[string compare $type Radiobutton] == 0} {
		set x 0
		foreach i $default_values {
		    $w.e.t.r$x configure -state disabled
		    incr x
		}
	    } else {
		$w.e configure -state disabled
	    }
	}
    }
    method EnableReadOnly {all} {
	if {$all || ([info exists read_only] && $read_only == 1)} {
	    if {[string compare $type Radiobutton] == 0} {
		set x 0
		foreach i $default_values {
		    $w.e.t.r$x configure -state normal
		    incr x
		}
	    } else {
		$w.e configure -state normal
	    }
	}
    }
    method GetEntry {} {
	return $w.e
    }
    proc GetInstances {} {
	return $instances
    }
    proc InitFocus {} {
	set foc [$firstentry GetEntry]
	set intfoc($foc) ""
	while {![tkFocusOK $foc]} {
	    set foc [tk_focusNext $foc]
	    if {[info exists intfoc($foc)]} {
		after idle "focus ."
		return
	    } else {
		set intfoc($foc) ""
	    }
	}
	after idle "focus $foc"
    }
    proc BeforeReconfigure {l} {
	set beforereconfigure $l
    }
    proc AfterReconfigure {l} {
	set afterreconfigure $l
    }
    proc ScrollbarSide {s} {
	if {[string compare $s left] != 0 && [string compare $s right] != 0} {
	    puts "Warning: ScrollbarSide $s must be left or right"
	} else {
	    set scrollbarside $s
	}
    }
    proc EnableExcludedWidgets {} {
	foreach i $excluded_entries {
	    catch [list $i configure -state normal]
	}
    }
    proc DisableExcludedWidgets {} {
	foreach i $excluded_entries {
	    catch [list $i configure -state disabled]
	}
    }

    common beforereconfigure
    common afterreconfigure
    common scrollbarside left

    # Entry stuff
    public entryfg
    public height 1
    public width 15
    protected textvariable
    
    public regexp_search 1 {
	global fx_config
	set fx_config(\$regexp_search\$,$attr) $regexp_search
    }
    public range_search 1 {
	global fx_config
	set fx_config(\$range_search\$,$attr) $range_search
    }
    public numeric_search 1 {
	global fx_config
	set fx_config(\$numeric_search\$,$attr) $numeric_search
    }
    public date_search 1 {
	global fx_config
	set fx_config(\$date_search\$,$attr) $date_search
    }

    # Generic stuff
    public type Entry
    public default_values {}
    public read_only
    public mandatory
    public unique

    public userconfig 1

    # Array of entries for tabbing
    public searchfor_entry {} {set common_searchfor_entry $searchfor_entry}
    common common_searchfor_entry
    common firstentry
    common instances
    common excluded_entries {}
}

