
if {![info exists fx_config(printer)]} {
    set fx_config(header) {}
    set fx_config(footer) {}
    set fx_config(print_heading) {}
    set fx_config(printer_name) {lp}
    set fx_config(dosfile_name) {report.txt}
    set fx_config(unixfile_name) {report.txt}
    # 2 == unix file, 1 == printer, 0 == dosfloppy
    set fx_config(printer) 1
}
if {![info exists fx_config(print_cmd_default)]} {
    set fx_config(print_cmd_default) "| pr | lpr -h"
}
if {![info exists fx_config(print_cmd)]} {
    set fx_config(print_cmd) "| pr | lpr -h -P"
}

itcl_class Fx_PrintDialog {
    constructor {config} {
	global fx_config fx_tmpconfig fx_perform_global_grabs fx_monochrome

	set p $toplevel.print_dialog
	if {[winfo exists $p]} {
	    focus $p
	    $this delete
	}
	if {[string compare $toplevel ""] == 0} {
	    toplevel $p
	    wm withdraw $p
	    wm transient $p .
	} else {
	    frame $p -relief groove -bd 4
	    set parent [winfo toplevel [winfo parent $p]]
	    place $p -in $parent -relx 0.5 -rely 0.5 -anchor c
	}	
	set fx_config(print_title) $title
	label $p.title -text $title -relief sunken -bd 2
	pack $p.title -side top -expand on -fill x
	label $p.m -text "Select a printer" -relief sunken -bd 2
	if {!$fx_monochrome} {
	    $p.m configure -fg red
	}
	pack $p.m -side top -expand on -fill x
	frame $p.f0 -relief sunken -bd 2
	pack $p.f0 -side top -expand on -fill x
	label $p.f0.l -width 10 -text Heading: -anchor e
	pack $p.f0.l -side left
	entry $p.f0.e -relief sunken -bd 2 -textvariable fx_config(print_heading)
	pack $p.f0.e -side left -expand on -fill x
	frame $p.f -relief sunken -bd 2
	pack $p.f -side top -expand on -fill x
	if {[info exists fx_config(printer)]} {
	    set fx_tmpconfig(printer) $fx_config(printer)
	}
	if {[info exists fx_config(printer_name)]} {
	    set fx_tmpconfig(printer_name) $fx_config(printer_name)
	}
	if {[info exists fx_config(dosfile_name)]} {
	    set fx_tmpconfig(dosfile_name) $fx_config(dosfile_name)
	}
	if {[info exists fx_config(unixfile_name)]} {
	    set fx_tmpconfig(unixfile_name) $fx_config(unixfile_name)
	}
	set fx_tmpconfig(tmp) {}
	radiobutton $p.f.l -text "Printer:" -anchor w -width 10 -variable fx_tmpconfig(printer) -value 1 \
	    -command "
		 $p.f.e configure -state normal
                 $p.f1.e configure -state disabled
                 $p.f3.e configure -state disabled
                 focus $p.f.e
            "
	pack $p.f.l -side left
	entry $p.f.e -textvariable fx_tmpconfig(printer_name)
	pack $p.f.e -side left -expand on -fill x
	frame $p.f1 -relief sunken -bd 2
	pack $p.f1 -side top -expand on -fill x
	radiobutton $p.f1.l -text "DOS (A:):" -anchor w -width 10 -variable fx_tmpconfig(printer) -value 0 \
	    -command "
                 $p.f.e configure -state disabled
		 $p.f1.e configure -state normal
                 $p.f3.e configure -state disabled
                 focus $p.f1.e
            "
	pack $p.f1.l -side left
	entry $p.f1.e -textvariable fx_tmpconfig(dosfile_name)
	pack $p.f1.e -side left -expand on -fill x
	frame $p.f3 -relief sunken -bd 2
	pack $p.f3 -side top -expand on -fill x
	radiobutton $p.f3.l -text "File:" -anchor w -width 10 -variable fx_tmpconfig(printer) -value 2 \
	    -command "
                 $p.f.e configure -state disabled
		 $p.f1.e configure -state disabled
                 $p.f3.e configure -state normal
                 focus $p.f3.e
            "
	pack $p.f3.l -side left
	entry $p.f3.e -textvariable fx_tmpconfig(unixfile_name)
	pack $p.f3.e -side left -expand on -fill x
	frame $p.f4 -relief sunken -bd 2
	pack $p.f4 -side top -expand on -fill x
	radiobutton $p.f4.l -text "Preview on screen" -anchor w \
		-width 10 -variable fx_tmpconfig(printer) -value 3 \
	    -command "
                 $p.f.e configure -state disabled
		 $p.f1.e configure -state disabled
                 $p.f3.e configure -state disabled
                 focus $p.f4.l
            "
	pack $p.f4.l -side left -expand on -fill x
	if {$fx_tmpconfig(printer) == 1} {
	    $p.f.l invoke
	} elseif {$fx_tmpconfig(printer) == 2} {
	    $p.f3.l invoke
	} elseif {$fx_tmpconfig(printer) == 0} {
	    $p.f1.l invoke
	} else {
	    $p.f4.l invoke
	}
	set ok_cmd "$this SetPrinter; set fx_config(cancel_print) 0; $p.f2.f.ok flash; $this delete; break"
	bind $p.f.e <Return> $ok_cmd
	bind $p.f1.e <Return> $ok_cmd
	bind $p.f0.e <Return> $ok_cmd
	bind $p.f3.e <Return> $ok_cmd

	frame $p.f2
	pack $p.f2 -side top -padx 5m -pady 5m -expand on -fill x -ipadx 3m -ipady 2m

	frame $p.f2.f -relief sunken -bd 1
	pack $p.f2.f -side left -padx 3m -pady 2m -in $p.f2

	set ok_cmd "$this SetPrinter; set fx_config(cancel_print) 0; $p.f2.f.ok flash; $this delete"
	button $p.f2.f.ok -text Ok -command $ok_cmd
	pack $p.f2.f.ok -padx 2m -pady 2m -in $p.f2.f -ipadx 2m -ipady 1m

	button $p.f2.cancel -text Cancel -command "$this delete; set fx_config(cancel_print) 1"
	pack $p.f2.cancel -side right -ipadx 3m -ipady 1m

	update idletasks
	if {[string compare $toplevel ""] == 0} {
	    set ht [winfo reqheight $p]
	    set wid [winfo reqwidth $p]
	    wm geometry $p \
		    "+[expr [winfo screenwidth .]/2 - $wid/2]+[expr [winfo screenheight .]/2 - $ht/2]"
	    wm deiconify $p
	} else {
	    fx_containfocus [list $p.f0.e $p.f2.cancel]
	}
	set oldgrab [grab current $p]
	set oldfocus [focus]
	catch "grab $p"
	catch "focus $p.f.e"
	tkwait window $p
	catch "$this delete"
    }
    destructor {
	catch "grab release $p"
	if {[string compare $oldgrab ""] != 0} {
	    catch "grab $oldgrab"
	}
	if {[string compare $oldfocus ""] != 0} {
	    catch "focus $oldfocus"
	}
	catch "destroy $p"
    }
    method SetPrinter {} {
	global fx_config fx_tmpconfig

	set fx_config(printer) $fx_tmpconfig(printer)
	set fx_config(printer_name) $fx_tmpconfig(printer_name)
	set fx_config(unixfile_name) $fx_tmpconfig(unixfile_name)
	set fx_config(dosfile_name) $fx_tmpconfig(dosfile_name)
    }
    method configure {config} {
    }
    public title {Printer Selection}
    public toplevel {}
    protected p
    protected oldgrab {}
    protected oldfocus {}
}

proc Fx:PrinterError {} {
    global fx_config

    fx_dialog .dialog "Printer Error" \
	    "Printer Error: Please make sure that the requested printer '$fx_config(printer_name)' exists." \
	    error 0 OK
}

proc Fx:Print {{contents ""}} {
    global fx_config
    
    update idletasks
    update
    if {$fx_config(printer) == 1} {
	if {[string length $fx_config(printer_name)] > 0} {
	    if {[catch [list open $fx_config(print_cmd)$fx_config(printer_name) w] fd] != 0} {
		Fx:PrinterError
		return
	    }
	} else {
	    if {[catch [list open $fx_config(print_cmd_default) w] fd] != 0} {
		Fx:PrinterError
		return
	    }
	}
	if {[info exists fx_config(print_heading)]} {
	    set alen [string length [lindex $contents 0]]
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	}
	puts $fd ""
	foreach i $contents {
	    puts $fd $i
	}
	if {[catch "close $fd"]} {
	    Fx:PrinterError
	    return
	}
    } elseif {$fx_config(printer) == 2} {
	if {[string length $fx_config(unixfile_name)] == 0} {
	    return
	}
	set s [split $fx_config(unixfile_name) /]
	if {[llength $s] > 1} {
	    set dir [join [lrange $s 0 [expr [llength $s] - 2]] /]
	    set file ${dir}/[lindex $s [expr [llength $s] - 1]]
	} else {
	    set file $fx_config(unixfile_name)
	}
	if {[catch [list open $file w] fd]} {
	    Fx:PrinterError
	    return
	}
	if {[info exists fx_config(print_heading)]} {
	    set alen [string length [lindex $contents 0]]
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	}
	foreach i $contents {
	    puts $fd $i
	}
	if {[catch "close $fd"]} {
	    Fx:PrinterError
	    return
	}
    } elseif {$fx_config(printer) == 0} {
	# check out the file name first
	if {[string length $fx_config(dosfile_name)] == 0} {
	    return
	}
	set tmpname [TempNam]
	if {[catch [list open $tmpname w 0400] fd]} {
	    Fx:PrinterError
	    return
	}
	if {[info exists fx_config(print_heading)]} {
	    set alen [string length [lindex $contents 0]]
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	}
	foreach i $contents {
	    puts $fd $i
	}
	if {[catch "close $fd"]} {
	    Fx:PrinterError
	    return
	}
	update idletasks
	update
	while {[catch "exec mcopy -tn $tmpname a:$fx_config(dosfile_name)"] != 0} {
	    set ans [fx_dialog .dialog "Floppy Error" \
		    "A floppy error has occurred.   Would you like to try formatting the floppy?" \
		    error 0 Yes No]
	    if {$ans == 0} {
		update idletasks; update
		fx_message .msg "Formatting..."
		update idletasks; update
		if {[catch "exec mformat a:"] != 0} {
		    .msg.msg configure -text "Format failed!"
		    update idletasks; update
		    catch "exec sleep 2"
		    destroy .msg
		    update idletasks; update
		    set ans 1
		} else {
		    .msg.msg configure -text "Format succeeded!"
		    update idletasks; update
		    catch "exec sleep 2"
		    destroy .msg
		    update idletasks; update
		}
	    }
	    if {$ans == 1} {
		set ans [fx_dialog .dialog "Floppy Error" \
			"Please make sure that an error-free formatted floppy is in drive A:" \
			error 0 OK Cancel]
		if {$ans != 0} {
		    break
		}
	    }
	}
	catch "exec rm -f $tmpname"
    } else {
	set tmpname [TempNam]
	if {[catch [list open $tmpname w 0400] fd]} {
	    Fx:PrinterError
	    return
	}
	if {[info exists fx_config(print_heading)]} {
	    set alen [string length [lindex $contents 0]]
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	}
	foreach i $contents {
	    puts $fd $i
	}
	catch "close $fd"
	if {[info exists fx_config(print_title)]} {
	    set title $fx_config(print_title)
	} else {
	    set title $fx_config(print_heading)
	}
	Fx:FileView $tmpname $title
	if {[info exists fx_config(file_viewer)] && [winfo exists $fx_config(file_viewer)]} {
	    tkwait window $fx_config(file_viewer)
	}
	catch "exec rm -f $tmpname"
    }
    update idletasks
    update
}

proc Fx:PrintFile {fn} {
    global fx_config
    
    update idletasks
    update
    if {$fx_config(printer) == 1} {
	if {[info exists fx_config(print_heading)]} {
	    set hname [TempNam]
	    set fd [open $hname w]
	    set alen 80
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	    close $fd
	}
	if {[string length $fx_config(printer_name)] > 0} {
	    if {[info exists hname]} {
		catch "eval exec cat $hname $fn $fx_config(print_cmd)$fx_config(printer_name)"
		catch "exec rm -f $hname"
	    } else {
		catch "eval exec cat $fn $fx_config(print_cmd)$fx_config(printer_name)"
	    }
	} else {
	    if {[info exists hname]} {
		catch "eval exec cat $hname $fn $fx_config(print_cmd_default)"
		catch "exec rm -f $hname"
	    } else {
		catch "eval exec cat $fn $fx_config(print_cmd_default)"
	    }
	}
    } elseif {$fx_config(printer) == 2} {
	if {[string length $fx_config(unixfile_name)] == 0} {
	    return
	}
	set s [split $fx_config(unixfile_name) /]
	if {[llength $s] > 1} {
	    set dir [join [lrange $s 0 [expr [llength $s] - 2]] /]
	    set file ${dir}/[lindex $s [expr [llength $s] - 1]]
	} else {
	    set file $fx_config(unixfile_name)
	}
	set nname [TempNam]
	if {[info exists fx_config(print_heading)]} {
	    set hname [TempNam]
	    set fd [open $hname w]
	    set alen 80
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	    close $fd
	    catch "exec cat $hname > $nname"
	    catch "exec rm -f $hname"
	}
	catch "exec cat $fn >> $nname"
	catch "exec cp $nname $file"
	catch "exec rm -f $nname"
    } elseif {$fx_config(printer) == 0} {
	# check out the file name first
	if {[string length $fx_config(dosfile_name)] == 0} {
	    return
	}
	set nname [TempNam]
	if {[info exists fx_config(print_heading)]} {
	    set hname [TempNam]
	    set fd [open $hname w]
	    set alen 80
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	    close $fd
	    catch "exec cat $hname > $nname"
	    catch "exec rm -f $hname"
	}
	catch "exec cat $fn >> $nname"
	update idletasks
	update
	while {[catch "exec mcopy -tn $nname a:$fx_config(dosfile_name)"] != 0} {
	    set ans [fx_dialog .dialog "Floppy Error" \
		    "A floppy error has occurred.   Would you like to try formatting the floppy?" \
		    error 0 Yes No]
	    if {$ans == 0} {
		update idletasks; update
		fx_message .msg "Formatting..."
		update idletasks; update
		if {[catch "exec mformat a:"] != 0} {
		    .msg.msg configure -text "Format failed!"
		    update idletasks; update
		    catch "exec sleep 2"
		    destroy .msg
		    update idletasks; update
		    set ans 1
		} else {
		    .msg.msg configure -text "Format succeeded!"
		    update idletasks; update
		    catch "exec sleep 2"
		    destroy .msg
		    update idletasks; update
		}
	    }
	    if {$ans == 1} {
		set ans [fx_dialog .dialog "Floppy Error" \
			"Please make sure that an error-free formatted floppy is in drive A:" \
			error 0 OK Cancel]
		if {$ans != 0} {
		    break
		}
	    }
	}
	catch "exec rm -f $nname"
    } else {
	if {[info exists fx_config(print_title)]} {
	    set title $fx_config(print_title)
	} else {
	    set title $fx_config(print_heading)
	}
	Fx:FileView $fn $title
	if {[info exists fx_config(file_viewer)] && [winfo exists $fx_config(file_viewer)]} {
	    tkwait window $fx_config(file_viewer)
	}
    }
    update idletasks
    update
}
