# fx_menu.tcl
#
# Generic menubar and default procedures for Qddb applications


itcl_class Fx_Menubar {
    constructor {config} {
	global fx_debug fx_config $mode_variable $status_variable
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:change_modeval
	global fx:search_statusval
	global fx_monochrome fx_wait_on_config

	::set ${mode_variable} ${fx:search_modeval}
	::set $status_variable ${fx:search_statusval}
	if {![info exists fx_config(auto_clear)]} { 
	    ::set fx_config(auto_clear) $auto_clear
	}
	if {![info exists fx_config(auto_save)]} { 
	    ::set fx_config(auto_save) $auto_save
	}
	if {![info exists fx_config(auto_save_tuple)]} {
	    ::set fx_config(auto_save_tuple) $auto_save_tuple
	}
	InitConfig 1
	set fx_wait_on_config 0
	if {$menubar} {
	    if {![winfo exists $w]} {
		frame $w
		pack $w -side top -expand on -fill x
	    }
	    menubutton $w.file -text File -underline 0 -menu $w.file.menu -padx 1m -pady 1m
	    menu $w.file.menu -postcommand "$this FilePostMenu" -tearoff $tearoffs
	    $w.file.menu add command -label "Save" \
		-underline 0 -command [list $this SaveProc]
	    $w.file.menu add command -label "Quit" \
		-underline 0 -command [list $this QuitProc]
	    if {[info exists fx_debug] && $fx_debug == 1} {
		$w.file.menu add command -label "DumpConfig" \
		    -underline 0 -command [list $this DumpConfig]
	    }
	    menubutton $w.edit -text Edit -underline 0 -menu $w.edit.menu -padx 1m -pady 1m
	    menu $w.edit.menu -postcommand [list $this EditPostMenu] -tearoff $tearoffs
	    $w.edit.menu add command -label "Search" \
		-underline 0 -command [list $this SearchProc]
	    $w.edit.menu add command -label "Expert Search" \
		    -underline 1 -command [list $this ExpertSearchProc]
	    $w.edit.menu add separator
	    $w.edit.menu add command -label "Copy" \
		    -accelerator <Alt-W> -command {Fx_Menubar :: CopySelection}
	    $w.edit.menu add command -label "Cut" \
		    -accelerator <Ctrl-W> -command {Fx_Menubar :: CutSelection}
	    $w.edit.menu add command -label "Paste" \
		    -accelerator <Ctrl-Y> -command {Fx_Menubar :: PasteCutbuffer}
	}
	set comm {+
	    global fx_thack
	    set fx_thack(%W) ""
        }
	bind Text <Control-w> $comm
	bind Text <Key-Delete> $comm
	bind Text <Control-y> {+
	    global fx_thack
	    set fx_thack(%W) ""
        }
	if {$menubar} {
	    $w.edit.menu add separator
	    $w.edit.menu add command -label "Clear" -underline 0 \
		-command [list $this ClearProc]
	    $w.edit.menu add command -label "Delete" -underline 0 \
		-command [list $this DeleteProc]
	    $w.edit.menu add command -label "Undo" -underline 0 \
		-command [list $this UndoProc]
	    menubutton $w.modes -text "Modes" -underline 0 -menu $w.modes.menu -padx 1m -pady 1m
	    menu $w.modes.menu -postcommand "$this ModesPostMenu" -tearoff $tearoffs
	    $w.modes.menu add command -label ${fx:search_modeval} -underline 0 \
		-command "$this SearchModeProc"
	    $w.modes.menu add command -label ${fx:add_modeval} -underline 0 \
		-command "$this AddModeProc"
	    $w.modes.menu add command -label ${fx:change_modeval} -underline 0 \
		-command "$this ToChangeModeProc"
	    $w.modes.menu add command -label ${fx:readonly_modeval} -underline 0 \
		-command "$this ReadOnlyModeProc"
	    menubutton $w.view -text "View" -underline 0 -menu $w.view.menu \
		-padx 1m -pady 1m
	    menu $w.view.menu -postcommand [list $this ViewPostMenu] -tearoff $tearoffs
	    $w.view.menu add command -label "Last Search Results" -underline 0 \
		-command [list $this DisplayLastSearch]
	    menubutton $w.templates -text Templates -underline 0 -menu $w.templates.menu -padx 1m -pady 1m
	    menu $w.templates.menu -postcommand [list $this TemplatesPostMenu] -tearoff $tearoffs
	    $w.templates.menu add command -label "Read Template" -underline 0 \
		-command [list $this ReadTemplateProc]
	    $w.templates.menu add command -label "Insert Last Template" -underline 0 \
		-command [list $this InsertLastTemplateProc]
	    $w.templates.menu add command -label "Write Template" -underline 0 \
		-command [list $this WriteTemplateProc]
	    menubutton $w.config -text Configure -underline 0 -menu $w.config.menu -padx 1m -pady 1m
	    menu $w.config.menu -tearoff $tearoffs
	    $w.config.menu add command -label "Save Personal Configuration" -underline 5 \
		-command [list $this SavePersonalConfig]
	    $w.config.menu add command -label "Save Global Configuration" -underline 5 \
		-command [list $this SaveGlobalConfig]
	    $w.config.menu add checkbutton -label "Auto-Save Personal Configuration" -underline 0 \
		-variable fx_config(auto_save)
	    $w.config.menu add separator
	    $w.config.menu add command -label "Search Results" -underline 0 \
		-command [list $this ConfigureSearchResults]
	    $w.config.menu add command -label "Fonts" -underline 0 \
		-command {
		    if {[Fx:ConfigureFonts] == 1} {
			eval [Fx_Menubar :: AfterReconfigure]
		    }
		}
	    $w.config.menu add command -label "Colors" -underline 0 \
		    -command {Fx:ConfigureColors}
	    $w.config.menu add separator
	    $w.config.menu add cascade -label "Soft Search Limit" -menu $w.config.menu.soft \
		    -underline 3
	    menu $w.config.menu.soft -tearoff $tearoffs
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 50 -label 50 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 100 -label 100 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 200 -label 200 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 300 -label 300 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 400 -label 400
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 500 -label 500
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) \
		    -value unlimited -label unlimited
	    $w.config.menu add cascade -label "Hard Search Limit" -menu $w.config.menu.hard \
		    -underline 3
	    menu $w.config.menu.hard -tearoff $tearoffs
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 100 -label 100 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 200 -label 200 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 300 -label 300 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 400 -label 400 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 500 -label 500 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 600 -label 600 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 700 -label 700 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 800 -label 800 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 900 -label 900 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 1000 -label 1000 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) \
		    -value unlimited -label unlimited
	    $w.config.menu add separator
	    $w.config.menu add cascade -label "Keyboard Traversal" -menu $w.config.menu.tabbing \
		    -underline 0
	    menu $w.config.menu.tabbing -tearoff $tearoffs
	    $w.config.menu.tabbing add checkbutton -variable fx_config(\$tabbing\$,scrollbars) \
		    -onvalue "" -offvalue 0 -label "Include scrollbars" -command {
		Fx_Attribute :: ResetTabbing scrollbars $fx_config(\$tabbing\$,scrollbars)
	    }
	    $w.config.menu.tabbing add checkbutton -variable fx_config(\$tabbing\$,add) \
		    -onvalue "" -offvalue 0 -label "Include Add buttons" -command {
		Fx_Attribute :: ResetTabbing add $fx_config(\$tabbing\$,add)
	    }
	    $w.config.menu.tabbing add checkbutton -variable fx_config(\$tabbing\$,view) \
		    -onvalue "" -offvalue 0 -label "Include View buttons" -command {
		Fx_Attribute :: ResetTabbing view $fx_config(\$tabbing\$,view)
	    }
	    $w.config.menu.tabbing add checkbutton -variable fx_config(\$tabbing\$,del) \
		    -onvalue "" -offvalue 0 -label "Include Del buttons" -command {
		Fx_Attribute :: ResetTabbing del $fx_config(\$tabbing\$,del)
	    }
	    $w.config.menu add separator
	    $w.config.menu add checkbutton -label "Auto-Clear" -underline 1 \
		-variable fx_config(auto_clear)
	    $w.config.menu add checkbutton -label "Auto-Save Tuples" -underline 13 \
		-variable fx_config(auto_save_tuple)
	    $w.config.menu add checkbutton -label "Force ${fx:readonly_modeval}" -underline 1 \
		-variable fx_config(force_readonly_mode)
	    $w.config.menu add checkbutton -label "Force Field Formatting" -underline 2 \
		    -variable fx_config(force_field_formatting)

	    menubutton $w.help -text Help -underline 0 -menu $w.help.menu -padx 1m -pady 1m
	    menu $w.help.menu -tearoff $tearoffs
	    $w.help.menu add command -label "About Qddb" -underline 0 -command Fx:AboutBox
	    $w.help.menu add command -label "Frequently Asked Questions" -underline 0 -command Fx:FAQBox
	    $w.help.menu add command -label "Key Bindings" -underline 0 -command Fx:KeyBindingsHelp
	    pack $w.file $w.edit $w.modes $w.view -side left
	    foreach i $auxbuttons {
		$i configure -padx 1m -pady 1m
		pack $i -in $w -side left
	    }
	    pack $w.help $w.config $w.templates -side right
	    set menu_items [concat $w $w.file $w.edit $w.modes $w.view $auxbuttons $w.templates $w.config $w.help]
	    eval "tk_menuBar $menu_items"
	    tk_bindForTraversal Entry Text .
	}
	set p [winfo p $w]
	if {[string compare $p .] == 0} {
	    set p ""
	}
	selection clear .
	if {$modebar} {
	    label $p.mode_label -relief raised -textvariable $mode_variable -justify center
	    pack $p.mode_label -side top -expand on -fill x
	}
	if {$statusbar} {
	    label $p.status_label -relief raised -textvariable $status_variable -justify center
	    pack $p.status_label -side top -expand on -fill x
	}
	if {$searchfor} {
	    frame $p.searchfor
	    pack $p.searchfor -expand on -fill x
	    set t $p.searchfor.label
	    button $t -text "Search for" -relief flat -highlightthickness 0 -takefocus 0 -justify right \
		    -padx 0 -pady 0
	    pack $t -side left
	    $t configure -activebackground [lindex [$t configure -background] 4]
	    $t configure -activeforeground [lindex [$t configure -foreground] 4]
	    bindtags $t {.}
	    entry $p.searchfor.entry -textvariable $searchfor_variable -relief sunken
	    pack $p.searchfor.entry -side right -expand on -fill x
	    focus $p.searchfor.entry
	    set searchfor_entry $p.searchfor.entry
	    set searchfor_label $t
	}
    }
    destructor {
	destroy $w
    }

    method SaveProc {} {
	global fx_config $status_variable $mode_variable $array fx:add_modeval fx:add_statusval fx_blt

	if {[info exists beforesave]} {
	    eval $beforesave
	}
	if {$fx_blt} {
	    blt_busy hold .
	    update idletasks
	}
	if {[Fx_Attribute :: TupleChanged]} {
	    if {[RunChecks]} {
		if {$fx_blt} {
		    catch "blt_busy forget ."
		}
		return
	    }
	} else {
	    ::set $status_variable "Record has not been modified; save aborted."
	    if {$fx_blt} {
		catch "blt_busy forget ."
	    }
	    return
	}
	::set $status_variable "Saving record..."
	update idletasks
	qddb_tuple write $tuple
	::set $status_variable "Record has been saved."
	update idletasks
	Fx_Attribute :: TupleChanged 0
	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    if {$fx_config(auto_clear) == 0} {
		if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		    if {$isempty == 0} {
			set added_tuple [qddb_tuple get external $tuple]
		    } else {
			catch {unset added_tuple}
		    }
		}
	    } else {
		catch {unset added_tuple}
	    }
	    AddModeProc
	    incr number_added
	    ::set $status_variable "Record saved; ${fx:add_statusval} ($number_added added)"
	}
	if {[info exists aftersave]} {
	    eval $aftersave
	}
	if {$fx_blt} {
	    catch "blt_busy forget ."
	}
    }
    method RunChecks {} {
	global fx_config $mode_variable fx:add_modeval fx:change_modeval

	set foc [focus]
	if {([string compare [set $mode_variable] ${fx:add_modeval}] == 0 || \
		[string compare [set $mode_variable] ${fx:change_modeval}] == 0) && \
		[Fx_Attribute :: TupleChanged]} {
	    if {![qddb_tuple isempty $tuple] && [Fx:CheckMandatoryFields $schema {} $array]} {
		after idle "focus $foc"
		return 1
	    }
	    if {[Fx:CurrentUniqueCheck $schema]} {
		after idle "focus $foc"
		return 1
	    }
	    if {[Fx:CurrentTypeCheck $schema]} {
		after idle "focus $foc"
		return 1
	    }
	}
	return 0
    }
    method QuitProc {} {
	global fx_config $mode_variable fx:add_modeval fx:change_modeval fx_blt

	if {[info exists beforequit]} {
	    eval $beforequit
	}
	if {$fx_blt} {
	    blt_busy hold .
	    update idletasks
	}
	if {[RunChecks]} {
	    if {$fx_blt} {
		catch "blt_busy forget ."
	    }
	    return
	}
	if {$fx_config(auto_save)} {
	    SavePersonalConfig
	}
	CheckNeedToSave
	qddb_schema close $schema
	qddb_table delete all
	if {[info exists afterquit]} {
	    eval $afterquit
	}
	eval $exitproc
    }
    method CheckNeedToSave {} {
	global $status_variable $mode_variable
	global fx:add_modeval fx:change_modeval fx_config

	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0 || \
		[string compare [set $mode_variable] ${fx:change_modeval}] == 0} {
	    if {[Fx_Attribute :: TupleChanged]} {
		if {$fx_config(auto_save_tuple) == 1} {
		    set result 0
		} else {
		    set result [fx_dialog .dialog "WARNING" \
			    "The current record has been modified.  Would you like to save it?" \
			    warning 0 Yes No]
		}
		if {$result == 0} {
		    if {[info exists beforesave]} {
			eval $beforesave
		    }		    
		    ::set $status_variable "Saving record..."
		    update idletasks
		    qddb_tuple write $tuple
		    ::set $status_variable "Record has been saved."
		    update idletasks
		    Fx_Attribute :: TupleChanged 0
		    if {[info exists aftersave]} {
			eval $aftersave
		    }
		}
	    }
	}
    }
    method SearchProc {{keylist {}} {search_attrs {}}} {
	global $searchfor_variable $array $status_variable \
		fx_config fx_blt fx:search_statusval fx_wait_on_config

	if {$fx_blt} {
	    blt_busy hold .
	}
	::set $status_variable "Searching..."
	update idletasks; update
	if {[string compare $keylist ""] == 0} {
	    if {[string length [string trim [set $searchfor_variable]]] > 0} {
		if {[catch \
			[list Fx_QddbSearchParser :: MultiSearch $schema [set $searchfor_variable]] \
			k] != 0} {
		    Fx:Dialog "Parse error" $k
		    if {$fx_blt} {
			catch "blt_busy forget ."
		    }
		    update idletasks
		    return
		}
		if {[llength $k] == 0} {
		    unset k
		}
	    }
	    set search_attrs {}
	    foreach i $attrs {
		if {"[string index $i 0]" == "\$"} {
		    continue
		}
		if {[string length [string trim [::set ${array}($i)]]] > 0} {
		    if {[catch \
			    [list Fx_QddbSearchParser :: MultiSearch $schema [::set ${array}(${i})] on ${i}] \
			    k1] != 0} {
			Fx:Dialog "Parse error" $k1
			if {[info exists k]} {
			    qddb_keylist delete $k
			}
			if {$fx_blt} {
			    catch "blt_busy forget ."
			}
			update idletasks
			return
		    }
		    lappend search_attrs $i
		    if {![info exists k]} {
			set k $k1
		    } else {
			set k [qddb_keylist op intersection $k $k1]
		    }
		}
	    }
	} else {
	    set k $keylist
	}
	set displayed 0
	if {[info exists k]} {
	    set k2 [qddb_keylist process nullop -copy on -deldup_sameentry on $k]
	    set klen [qddb_keylist length $k2]
	    qddb_keylist delete $k2
	    if {$fx_blt} {
		catch "blt_busy forget ."
	    }
	    update idletasks
	    if {[string compare $fx_config(hard_limit) unlimited] != 0 && $fx_config(hard_limit) < $klen} {
		fx_dialog .dialog "Hard Search Limit Exceeded" \
			"You have requested to view rows for a total of $klen records.   This number exceeds the current hard limit.  You may not continue." \
			error 0 Ok
		qddb_keylist delete $k
		::set $status_variable ${fx:search_statusval}
		return
	    } elseif {[string compare $fx_config(soft_limit) unlimited] != 0 && \
		    $fx_config(soft_limit) < $klen} {
		if {[fx_dialog .dialog "Soft Search Limit Exceeded" \
			"You have requested to view rows for a total of $klen records.   This number exceeds the current soft limit.   Do you wish to continue?" \
			warning 0 No Yes] == 0} {
		    qddb_keylist delete $k
		    ::set $status_variable ${fx:search_statusval}
		    return
		}
	    }
	    if {$fx_blt} {
		blt_busy hold .
	    }
	    update idletasks
	    set klen [qddb_keylist length $k]
	    if {$klen > 0} {
		if {[info exists last_search]} {
		    KillLastSearch
		}
		::set fx_wait_on_config 0
		set pa \$search\$,print
		set print_attrs {}
		set user_attrs {}
		foreach i $fx_config($pa) {
		    if {"[string index $i 0]" != "\$"} {
			lappend print_attrs $i
		    } else {
			lappend user_attrs $i
		    }
		}
		set pa \$search\$,sortby
		set sort_attrs {}
		foreach i $fx_config($pa) {
		    if {"[string index $i 0]" != "\$"} {
			lappend sort_attrs $i
		    }
		}
		update
		set asc {}
		set asc_attrs {}
		set x 0
		foreach i $fx_config(\$search\$,ascending) {
		    if {[string compare $i yes] == 0} {
			set thisasc [lindex $fx_config(\$search\$,sortby) $x]
			lappend asc $thisasc
			if {"[string index $thisasc 0]" != "\$"} {
			    lappend asc_attrs $thisasc
			}
		    }
		    incr x
		}
		::set $status_variable "Reading data..."
		update idletasks
		if {[llength $search_attrs] > 0} {
		    if {[llength $user_attrs] == 0} {
			if {[info exists fx_config(\$search\$,unsorted)] && \
				$fx_config(\$search\$,unsorted)} {
			    set last_search [qddb_rows select -format table \
				    -flush on -rowdescs on \
				    -print $print_attrs $k]
			    Fx:UserDefinedTable $last_search \$search\$ fx_config
			} else {
			    set last_search [qddb_rows select -format table \
				    -flush on -rowdescs on \
				    -ascending $asc -sortby $fx_config(\$search\$,sortby) \
				    -print $print_attrs $k]
			    Fx:UserDefinedTable $last_search \$search\$ fx_config
			}
		    } else {
			set last_search [qddb_rows select -format table \
				-flush on -rowdescs on \
				-sortby $sort_attrs \
				-ascending $asc_attrs \
				-print $print_attrs $k]
			Fx:UserDefinedTable $last_search \$search\$ fx_config
			if {![info exists fx_config(\$search\$,unsorted)] || \
				!$fx_config(\$search\$,unsorted)} {
			    qddb_table sort $last_search -ascending $asc \
				    -sortby $fx_config(\$search\$,sortby)
			}
		    }
		} else {
		    if {[llength $user_attrs] == 0} {
			if {[info exists fx_config(\$search\$,unsorted)] && \
				$fx_config(\$search\$,unsorted)} {
			    set last_search [qddb_rows select -format table \
				    -flush on -rowdescs on \
				    -print $print_attrs $k]
			    Fx:UserDefinedTable $last_search \$search\$ fx_config
			} else {
			    set last_search [qddb_rows select -format table \
				    -flush on -rowdescs on \
				    -ascending $asc -sortby $fx_config(\$search\$,sortby) \
				    -print $print_attrs $k]
			    Fx:UserDefinedTable $last_search \$search\$ fx_config
			}
		    } else {
			set last_search [qddb_rows select -format table \
				-flush on -rowdescs on \
				-sortby $sort_attrs \
				-ascending $asc_attrs \
				-print $print_attrs $k]
			Fx:UserDefinedTable $last_search \$search\$ fx_config
			if {![info exists fx_config(\$search\$,unsorted)] || \
				!$fx_config(\$search\$,unsorted)} {
			    qddb_table sort $last_search -ascending $asc \
				    -sortby $fx_config(\$search\$,sortby)
			}
		    }
		}
		set last_search_was_null 0
		qddb_keylist delete $k
		update
		if {[string length $last_search] > 0 && $search_results == 1} {
		    DisplayLastSearch 0
		    set displayed 1
		} else {
		    set last_search_was_null 1
		    ::set $status_variable "No matches found."
		}
	    } else {
		set last_search_was_null 1
		::set $status_variable "No matches found."
	    }
	} else {
	    set last_search_was_null 1
	    ::set $status_variable "No query specified."
	}
	if {$fx_blt && $displayed == 0} {
	    catch "blt_busy forget ."
	}
	if {[info exists aftersearch]} {
	    eval $aftersearch
	}
	update idletasks
    }
    method ExpertSearchProc {} {
	global fx_config $status_variable fx_blt

	if {$fx_blt} {
	    blt_busy hold .
	}
	update idletasks
	if {[string length $restrict] == 0} {
	    set res {}
	} else {
	    set res $restrict/:expert_search:
	}
	if {[info exists fx_config(current_expert_search)]} {
	    set l [Fx:ExpertSearchWindow .expert_search $schema $res $fx_config(current_expert_search)]
	} else {
	    set l [Fx:ExpertSearchWindow .expert_search $schema $res ""]
	}
	if {[lindex $l 0] == 1} {
	    ::set $status_variable "Searching..."
	    update idletasks
	    set fx_config(current_expert_search) [lindex $l 1]
	    if {[catch [list Fx:ExpertSearchParser $schema [lindex $l 1]] l] != 0} {
		fx_dialog .dialog "Expert search error" \
			"Expert search error:\n$l" error 0 Ok
		if {$fx_blt} {
		    catch "blt_busy forget ."
		}
		::set $status_variable "Expert search failed!"
		update idletasks
		return
	    }
	    update idletasks
	    SearchProc [lindex $l 1] [Fx:UniqueList [lindex $l 0]]
	} else {
	    if {$fx_blt} {
		catch "blt_busy forget ."
	    }
	}
	update idletasks
    }
    method DeleteProc {} {
	eval $beforetupledelete
	catch "qddb_tuple remove $tuple"
	if {[info exists last_search]} {
	    set maxnum [qddb_table row maxnum $last_search]
	    for {set i 1} {$i <= $maxnum} {incr i} {
		set t [lindex [qddb_table row cget $last_search $i -comment] 0]
		if {[string compare $t $tuple] == 0} {
		    qddb_table row delete $last_search $i
		    incr i -1
		    incr maxnum -1
		}
	    }
	    Fx_Attribute :: TupleChanged 0
	    if {[winfo exists .search_results]} {
		DisplayLastSearch 0 1
	    }
	}
	SearchModeProc
	if {[winfo exists .search_results]} {
	    wm withdraw .search_results
	    wm deiconify .search_results
	}
    }
    method ClearProc {} {
	global $mode_variable $searchfor_variable $array
	global fx:search_modeval fx:add_modeval

	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    catch [list qddb_tuple delete $tuple]
	    set tuple [qddb_tuple new $schema]
	    set view [qddb_view define $tuple $attr_pairs]
	    $this configure -view $view -tuple $tuple
	    Fx_Attribute :: TupleChanged 0
	} else {
	    if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
		set $searchfor_variable {}
	    }
	    foreach i [array names $array] {
		::set ${array}($i) {}
	    }
	}
    }
    method UndoProc {} {
	global fx_config $status_variable $mode_variable
	global fx:readonly_modeval fx:change_modeval fx:change_statusval fx:readonly_statusval
	catch "qddb_tuple refresh $tuple"
	Fx_Attribute :: TupleChanged 0
	if {$fx_config(force_readonly_mode) == 0 && [qddb_tuple lock $tuple]} {
	    Fx_Entry :: EnableReadOnlyWidgets 1
	    Fx_Entry :: DisableReadOnlyWidgets 0
	    ::set $mode_variable ${fx:change_modeval}
	    ::set $status_variable ${fx:change_statusval}
	    Fx_Attribute :: TupleChanged 0
	} else {
	    catch [list qddb_tuple unlock $tuple]
	    Fx_Attribute :: DisableAddDeleteButtons
	    Fx_Entry :: DisableReadOnlyWidgets 1
	    ::set $mode_variable ${fx:readonly_modeval}
	    ::set $status_variable ${fx:readonly_statusval}
	    Fx_Attribute :: TupleChanged 0
	}
    }
    # Modes menu methods
    method SearchModeProc {} {
	global $mode_variable $status_variable $array fx_config $searchfor_variable fx_blt
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:change_modeval fx:search_statusval
	if {$fx_blt} {
	    blt_busy hold .
	}
	update idletasks
	if {[RunChecks]} {
	    if {$fx_blt} {
		catch "blt_busy forget ."
	    }
	    return
	}
	if {[string compare [set $mode_variable] ${fx:readonly_modeval}] && \
		[string compare [set $mode_variable] ${fx:search_modeval}] \
		&& [Fx_Attribute :: TupleChanged]} {
	    CheckNeedToSave
	}
	Fx_Entry :: EnableReadOnlyWidgets 1
	Fx_Entry :: DisableExcludedWidgets
	Fx_Attribute :: DisableButtons
	if {[info exists beforesearchmode]} {
	    eval $beforesearchmode
	}
	catch "qddb_tuple unlock $tuple"
	# Can only get here from Add, Change, Read-only modes
	# If in Change/Read-only mode, don't delete tuple (just view).
	Fx_Attribute :: KillAllViews
	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    if {$fx_config(auto_clear) == 0} {
		if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		    if {$isempty == 0} {
			set added_tuple [qddb_tuple get external $tuple]
		    } else {
			catch {unset added_tuple}
		    }
		}
	    }
	    catch [list qddb_tuple delete $tuple]
	    set tuple {}
	    set view {}
	    $this configure -view $view -tuple $tuple
	} else {
	    catch [list qddb_view delete $view]
	}
	::set $mode_variable ${fx:search_modeval}
	::set $status_variable ${fx:search_statusval}
	# enable searchfor: box
	if {$searchfor} {
	    $searchfor_label configure -state normal
	    $searchfor_entry configure -state normal
	    after idle "focus $searchfor_entry"
	}
	bind Entry <Return> [list $this SearchProc]
	if {$fx_config(auto_clear) == 1 || ![info exists searchvar]} {
	    foreach i $textvariables {
		uplevel \#0 [list set $i {}]
	    }
	    set $searchfor_variable {}
	} else {
	    if {[info exists searchvar]} {
		foreach i $textvariables {
		    uplevel \#0 [list set $i $searchvar($i)]
		}
	    }
	}
	Fx_Attribute :: TupleChanged 0
	if {[info exists aftersearchmode]} {
	    eval $aftersearchmode
	}
	if {$fx_blt} {
	    catch "blt_busy forget ."
	}
    }
    method AddModeProc {} {
	global $mode_variable $status_variable $array fx_config
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:add_statusval
	global fx_blt

	if {$fx_blt} {
	    blt_busy hold .
	}
	if {[RunChecks]} {
	    if {$fx_blt} {
		catch "blt_busy forget ."
	    }
	    return
	}
	if {[string compare [set $mode_variable] ${fx:search_modeval}] && \
		[string compare [set $mode_variable] ${fx:readonly_modeval}] \
		&& [Fx_Attribute :: TupleChanged]} {
	    CheckNeedToSave
	}
	if {[info exists beforeaddmode]} {
	    eval $beforeaddmode
	}
	Fx_Attribute :: EnableButtons
	Fx_Entry :: EnableReadOnlyWidgets 1
	Fx_Entry :: EnableExcludedWidgets
	Fx_Entry :: DisableReadOnlyWidgets 0
	catch "qddb_tuple unlock $tuple"
	Fx_Attribute :: KillAllViews
	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    catch "qddb_tuple delete $tuple"
	}
	if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	    foreach i $textvariables {
		set searchvar($i) [set $i]
	    }
	}
	if {$searchfor} {
	    $searchfor_label configure -state disabled
	    $searchfor_entry configure -state disabled
	}
	::set $mode_variable ${fx:add_modeval}
	::set $status_variable ${fx:add_statusval}
	Fx_Entry :: InitFocus
	bind Entry <Return> { }
	catch [list qddb_view delete $view]
	if {$fx_config(auto_clear) == 1} {
	    catch [list unset added_tuple]
	}
	if {[info exists added_tuple] && $fx_config(auto_clear) == 0} {
	    set tuple [qddb_tuple put external $schema $added_tuple]
	} else {
	    set tuple [qddb_tuple new $schema]
	}
	set view [qddb_view define $tuple $attr_pairs]
	$this configure -view $view -tuple $tuple
	if {[info exists afteraddmode]} {
	    eval $afteraddmode
	}
	Fx_Attribute :: TupleChanged 0
	if {$fx_blt} {
	    catch "blt_busy forget ."
	}
    }
    method ChangeModeProc {idx {takefocus 1}} {
	global $status_variable $mode_variable fx_config fx_blt $array
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:change_modeval fx:change_statusval
	if {$fx_blt} {
	    blt_busy hold .
	}
	if {[RunChecks]} {
	    if {$fx_blt} {
		catch "blt_busy forget ."
	    }
	    return
	}
	if {[string compare [set $mode_variable] ${fx:search_modeval}] && \
		[string compare [set $mode_variable] ${fx:readonly_modeval}] \
		&& [Fx_Attribute :: TupleChanged]} {
	    CheckNeedToSave
	}
	if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0 || \
		[string compare [set $mode_variable] ${fx:readonly_modeval}] == 0} {
	    Fx_Attribute :: EnableButtons
	    Fx_Entry :: EnableReadOnlyWidgets 1
	    Fx_Entry :: EnableExcludedWidgets
	    Fx_Entry :: DisableReadOnlyWidgets 0
	}
	if {[info exists beforechangemode]} {
	    eval $beforechangemode
	}
	catch "qddb_tuple unlock $tuple"
	Fx_Attribute :: KillAllViews
	if {$fx_config(auto_clear) == 0} {
	    if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
		if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		    if {$isempty == 0} {
			set added_tuple [qddb_tuple get external $tuple]
		    } else {
			catch {unset added_tuple}
		    }
		}
		catch [list qddb_tuple delete $tuple]
	    } elseif {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
		foreach i $textvariables {
		    set searchvar($i) [set $i]
		}
	    }
	    catch [list qddb_view delete $view]
	} else {
	    catch [list qddb_view delete $view]
	}
	::set $mode_variable ${fx:change_modeval}
	::set $status_variable ${fx:change_statusval}
	if {$searchfor} {
	    $searchfor_label configure -state disabled
	    $searchfor_entry configure -state disabled
	}
	bind Entry <Return> { }
	set myrow [lindex [qddb_table row cget $last_search [expr $idx + 1] -comment] 1]
	set changemodeidx $idx
	set tuple [qddb_rows tuplename $myrow]
	set view [qddb_view define $myrow $attr_pairs]
	$this configure -view $view -tuple $tuple
	if {[info exists fx_config(force_readonly_mode)] && \
		$fx_config(force_readonly_mode) || [qddb_tuple lock $tuple] == 0} {
	    ReadOnlyModeProc
	} else {
	    if {$takefocus} {
		Fx_Entry :: InitFocus
	    }
	}
	Fx_Attribute :: TupleChanged 0
	if {[info exists afterchangemode]} {
	    eval $afterchangemode
	}
	if {$fx_blt} {
	    catch "blt_busy forget ."
	}
    }
    method ToChangeModeProc {} {
	ChangeModeProc $changemodeidx
    }
    method ReadOnlyModeProc {} {
	global $mode_variable $status_variable fx:readonly_modeval fx:readonly_statusval

	if {[info exists beforereadonlymode]} {
	    eval $beforereadonlymode
	}
	catch "qddb_tuple unlock $tuple"
	Fx_Attribute :: DisableAddDeleteButtons
	Fx_Entry :: DisableReadOnlyWidgets 1
	::set $mode_variable ${fx:readonly_modeval}
	::set $status_variable ${fx:readonly_statusval}
	if {[info exists afterreadonlymode]} {
	    eval $afterreadonlymode
	}
	after idle "focus ."
    }
    method ReadTemplateProc {} {
	global fx_config $status_variable

	if {[string length $restrict] != 0} {
	    set t [Fx:FileSelect .readtempl r $restrict/Templates]
	} else {
	    set t [Fx:FileSelect .readtempl r $restrict]
	}
	if {[llength $t] > 0} {
	    ::set fx_config(current_template) $t
	} else {
	    return
	}
	if {[catch InsertLastTemplateProc error] != 0} {
	    ::set $status_variable "Cannot read template: $error"
	} else {
	    ::set $status_variable "Template successfully read."
	}
	update idletasks
    }
    method InsertLastTemplateProc {} {
	global fx_config $status_variable $mode_variable $array fx:search_modeval

	if {[catch [list Fx:ReadFile $fx_config(current_template)] buf] != 0} {
	    ::set $status_variable "Cannot read template: $buf"
	    return
	}
	if {[catch [list qddb_tuple put readable $schema $buf] error] != 0} {
	    ::set $status_variable "$error"
	    return
	} else {
	    if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
		set v [qddb_view define $error {}]
		foreach i [qddb_schema leaves $schema] {
		    ::set ${array}($i) [qddb_instance getval $v $i]
		}
		qddb_tuple delete $error
	    } else {
		catch [list qddb_tuple delete $tuple]
		set tuple $error
		set view [qddb_view define $tuple $attr_pairs]
		$this configure -view $view -tuple $tuple
		Fx_Attribute :: TupleChanged 0
		::set $status_variable "Template successfully read."
	    }
	}
	Fx_Entry :: TupleChanged 1
	update idletasks
    }
    method WriteTemplateProc {} {
	global fx_config $status_variable $mode_variable $array fx:search_modeval

	if {[string length $restrict] != 0} {
	    set t [Fx:FileSelect .writetempl w $restrict/Templates]
	} else {
	    set t [Fx:FileSelect .writetempl w $restrict]
	}
	if {[llength $t] > 0} {
	    ::set fx_config(current_template) $t
	} else {
	    return
	}
	if {[string compare ${fx:search_modeval} [set $mode_variable]] == 0} {
	    set t [qddb_tuple new $schema]
	    set v [qddb_view define $t {}]
	    foreach i [qddb_schema leaves $schema] {
		if {[string compare [::set ${array}($i)] ""] != 0} {
		    catch "qddb_instance setval $v $i [::set ${array}($i)]"
		}
	    }
	    if {[catch [list qddb_tuple get readable $t] buf] != 0} {
		::set $status_variable $buf
		qddb_tuple delete $t
		return
	    }
	    qddb_tuple delete $t
	} else {
	    if {[catch [list qddb_tuple get readable $tuple] buf] != 0} {
		::set $status_variable $buf
		return
	    }
	}
	if {[catch [list Fx:WriteFile $fx_config(current_template) $buf] error] != 0} {
	    ::set $status_variable "Cannot write template: $error"
	} else {
	    ::set $status_variable "Template successfully written."
	}
	update idletasks
    }

    # View menu methods
    method DisplayLastSearch {{do_sort 0} {reconfig 0}} {
	global fx_config $status_variable fx_blt fx_wait_on_config

	if {![info exists last_search] || [string length last_search] == 0} {
	    return
	}
	if {$fx_blt} {
	    blt_busy hold .
	}
	update idletasks
	if {[winfo exists .search_results]} {
	    if {$reconfig} {
		set curselect [.search_results.f.l2 curselection]
		set nearesty  [.search_results.f.l2 nearest 0]
		search_results ClearRows
		search_results ClearContents
	    } else {
		catch "search_results delete"
		catch "destroy .search_results"
	    }
	}
	update idletasks
	set ls_len [qddb_table row maxnum $last_search]
	if {$ls_len == 1} {
	    ::set $status_variable "1 row found..."
	    ChangeModeProc 0
	    return
	}
	update idletasks
	::set $status_variable "Formatting..."
	update idletasks
	if {$ls_len == 0} {
	    set last_search_was_null 1
	    SearchModeProc
	    ::set $status_variable "No matches found."
	    return
	}
	# ls_len > 1
	::set $status_variable "$ls_len rows found..."
	update idletasks
	if {!$reconfig} {
	    toplevel .search_results
	    wm title .search_results "Search Results"
	    if {[info exists fx_config(geom,search_results)]} {
		wm geometry .search_results $fx_config(geom,search_results)
	    }
	    set f .search_results.f2
	    frame $f
	    pack $f -side bottom -fill x
	    button $f.select -text Select -command {search_results OnSelect}
	    pack $f.select -side left -padx 6m -pady 2m -ipadx 6m -ipady 2m
	    button $f.cancel -text Dismiss -command {
		catch "search_results delete"
		catch "destroy .search_results"
		after idle "focus [focus -lastfor .]"
	    }
	    pack $f.cancel -side left -padx 6m -pady 2m -ipadx 6m -ipady 2m
	    set px [$f.select cget -padx]
	    set py [$f.select cget -pady]
	    button $f.print -text Print -command [list $this PrintLastSearch]
	    set buttfont [$f.print cget -font]
	    checkbutton $f.pin -text "Pin" -variable fx_config(pin,search_results) \
		    -onvalue 1 -offvalue 0 -padx $px -pady $py -font $buttfont
	    pack $f.pin -side right -padx 6m -pady 2m -ipadx 6m -ipady 2m
	    pack $f.print -side right -padx 6m -pady 2m -ipadx 6m -ipady 2m
	}
	if {$fx_wait_on_config == 0} {
	    if {[info exists fx_config(\$search\$,widths)]} {
		set x [qddb_table col maxnum $last_search]
		for {set i 0} {$i < $x} {incr i} {
		    set iplus1 [expr $i + 1]
		    set tmp [lindex $fx_config(\$search\$,widths) $i]
		    if {[string length $tmp] == 0} {
			continue
		    }
		    qddb_table col configure $last_search $iplus1 -width $tmp
		    set tmp [lindex $fx_config(\$search\$,separators) $i]
		    if {[string length $tmp] == 0} {
			set tmp " "
		    }
		    qddb_table col configure $last_search $iplus1 -separator $tmp
		    set tmp [lindex $fx_config(\$search\$,alignment) $i]
		    qddb_table col configure $last_search $iplus1 -justify $tmp
		}
	    }
	    if {[info exists fx_config(\$search\$,linenumbers)]} {
		set rowtitles $fx_config(\$search\$,linenumbers)
	    } else {
		set rowtitles 0
	    }
	}
	set mytext [qddb_table getval $last_search -format rows -coltitles on -rowtitles $rowtitles]
	if {!$reconfig} {
	    Fx_SingleColumnListBox search_results -w .search_results.f \
		    -headings [lindex $mytext 0] \
		    -width 60 \
		    -exportselection off \
		    -single_select on \
		    -height 10 -onselect "$this PinnedSearchResultsProc"
	    search_results AppendRows [lrange $mytext 1 end]
	    search_results Display
	} else {
	    search_results configure \
		    -headings [lindex $mytext 0] \
		    -width 60 \
		    -single_select on \
		    -exportselection off
	    search_results AppendRows [lrange $mytext 1 end]
	    search_results Display 1
	}
	if {$reconfig} {
	    .search_results.f.l2 select clear 0 end
	    .search_results.f.l2 select set $curselect $curselect
	    .search_results.f.l2 select anchor $curselect
	    .search_results.f.l2 activate $curselect
	    .search_results.f.l2 yview $nearesty
	}
	if {$fx_blt} {
	    catch "blt_busy forget ."
	}
	if {!$reconfig} {
	    bind .search_results <Configure> {
		set fx_config(geom,search_results) [wm geometry .search_results]
	    }
	    if {[info exists fx_config(geom,search_results)]} {
		wm geometry .search_results $fx_config(geom,search_results)
	    }
	    tkwait window .search_results.f
	    Fx_Entry :: InitFocus
	}
    }
    method PinnedSearchResultsProc {i} {
	global fx_config fx_blt

	if {![info exists fx_config(pin,search_results)] || $fx_config(pin,search_results) == 0} {
	    catch "destroy .search_results"
	    catch "search_results delete"
	    update
	    $this ChangeModeProc $i
	    after idle "focus [focus -lastfor .]"
	} else {
	    if {[winfo exists .search_results]} {
		set dohold 1
	    } else {
		set dohold 0
	    }
	    if {$fx_blt && $dohold} {
		blt_busy hold .search_results
	    }
	    $this ChangeModeProc $i 0
	    if {$fx_blt && $dohold} {
		catch "blt_busy forget .search_results"
	    }	    
	}
    }
    method PrintLastSearch {} {
	global fx_config $status_variable fx_blt fx_wait_on_config

	Fx_PrintDialog $this.print_dialog
	if {$fx_config(cancel_print) == 0} {
	    if {$fx_blt} {
		blt_busy hold .
		if {[winfo exists .search_results]} {
		    blt_busy hold .search_results
		}
	    }
	    update idletasks
	    if {$fx_wait_on_config == 0} {
		if {[info exists fx_config(\$search\$,linenumbers)]} {
		    set rowtitles $fx_config(\$search\$,linenumbers)
		} else {
		    set rowtitles 0
		}
	    }
	    Fx:Print [qddb_table getval $last_search -format rows -coltitles on -rowtitles $rowtitles]
	    if {$fx_blt} {
		catch "blt_busy forget ."
		if {[winfo exists .search_results]} {
		    catch "blt_busy forget .search_results"
		}
	    }
	    if {[winfo exists .search_results]} {
		if {[catch "focus -lastfor .search_results" resultswin] == 0} {
		    after idle "catch [list focus $resultswin]"
		}
	    }
	} else {
	    ::set $status_variable "Printing cancelled."
	}
    }
    method KillLastSearch {} {
	global $mode_variable $status_variable $array fx_config \
		fx:search_modeval fx:add_modeval fx:readonly_modeval \
		fx:change_modeval fx:search_statusval fx_wait_on_config

	if {[string compare [set $mode_variable] ${fx:readonly_modeval}] && \
		[string compare [set $mode_variable] ${fx:search_modeval}] \
		&& [Fx_Attribute :: TupleChanged]} {
	    CheckNeedToSave
	}
	::set $status_variable "Killing last search..."
	::set fx_wait_on_config 0
	update idletasks
	if {[info exists last_search]} {
	    set x [qddb_table row maxnum $last_search]
	    for {set i 1} {$i <= $x} {incr i} {
		catch [list qddb_tuple delete [lindex [qddb_table row cget $last_search $i -comment] 0]]
	    }
	    qddb_table delete $last_search
	}
	catch {unset last_search}
	if {[winfo exists .search_results]} {
	    catch "search_results delete"
	    catch "destroy .search_results"
	    update
	}
    }

    # Menu posting methods
    method FilePostMenu {} {
	global $mode_variable fx:search_modeval fx:readonly_modeval

	set m [set $mode_variable]
	set fe $tearoffs
	if {[string compare $m ${fx:search_modeval}] == 0 || \
		[string compare $m ${fx:readonly_modeval}] == 0} {
	    $w.file.menu entryconfigure $fe -state disabled
	} elseif {[Fx_Entry :: TupleChanged] == 0 || [qddb_tuple isempty $tuple] || \
		      [string compare $m ${fx:readonly_modeval}] == 0} {
	    $w.file.menu entryconfigure $fe -state disabled
	} else {
	    $w.file.menu entryconfigure $fe -state normal
	}
	if {[info exists afterpost_file]} {
	    eval $afterpost_file
	}
    }
    method EditPostMenu {} {
	global $mode_variable
	global fx:search_modeval fx:add_modeval fx:change_modeval

	set fe $tearoffs
	if {[info exists cutbuffer]} {
	    $w.edit.menu entryconfigure [expr $fe + 5] -state normal
	} else {
	    $w.edit.menu entryconfigure [expr $fe + 5] -state disabled
	}
	if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	    $w.edit.menu entryconfigure [expr $fe + 0] -state normal
	    $w.edit.menu entryconfigure [expr $fe + 1] -state normal
	    $w.edit.menu entryconfigure [expr $fe + 7] -state normal
	    $w.edit.menu entryconfigure [expr $fe + 8] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 9] -state disabled
	} elseif {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    $w.edit.menu entryconfigure [expr $fe + 0] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 1] -state disabled
	    if {[qddb_tuple isempty $tuple]} {
		$w.edit.menu entryconfigure [expr $fe + 7] -state disabled
	    } else {
		$w.edit.menu entryconfigure [expr $fe + 7] -state normal
	    }
	    $w.edit.menu entryconfigure [expr $fe + 8] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 9] -state disabled
	} else {
	    $w.edit.menu entryconfigure [expr $fe + 0] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 1] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 7] -state disabled
	    if {[string compare [set $mode_variable] ${fx:change_modeval}] == 0} {
		$w.edit.menu entryconfigure [expr $fe + 8] -state normal
	    } else {
		$w.edit.menu entryconfigure [expr $fe + 8] -state disabled
	    }
	    $w.edit.menu entryconfigure [expr $fe + 9] -state normal
	}
	if {[catch "selection get" tmpsel]} {
	    $w.edit.menu entryconfigure [expr $fe + 3] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 4] -state disabled
	} else {
	    $w.edit.menu entryconfigure [expr $fe + 3] -state normal
	    $w.edit.menu entryconfigure [expr $fe + 4] -state normal
	}
	if {[catch {selection get -selection CLIPBOARD} mybuf]} {
	    $w.edit.menu entryconfigure [expr $fe + 5] -state disabled
	} else {
	    $w.edit.menu entryconfigure [expr $fe + 5] -state normal
	}
	if {[info exists afterpost_edit]} {
	    eval $afterpost_edit
	}
    }
    method ModesPostMenu {} {
	global fx_config $mode_variable
	global fx:search_modeval fx:add_modeval fx:change_modeval

	set fe $tearoffs
	set m [set $mode_variable]
	if {[string compare $m ${fx:search_modeval}] == 0} {
	    $w.modes.menu entryconfigure [expr $fe + 0] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 1] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 3] -state disabled
	} elseif {[string compare $m ${fx:add_modeval}] == 0} {
	    $w.modes.menu entryconfigure [expr $fe + 0] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 1] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 3] -state disabled
	} elseif {[string compare $m ${fx:change_modeval}] == 0} {
	    $w.modes.menu entryconfigure [expr $fe + 0] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 1] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 3] -state normal
	} else {
	    $w.modes.menu entryconfigure [expr $fe + 0] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 1] -state normal
	    if {$fx_config(force_readonly_mode)} {
		$w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	    } else {
		$w.modes.menu entryconfigure [expr $fe + 2] -state normal
	    }
	    $w.modes.menu entryconfigure [expr $fe + 3] -state disabled
	}
	if {[info exists afterpost_modes]} {
	    eval $afterpost_modes
	}
    }
    method ViewPostMenu {} {
	set fe $tearoffs
	if {![info exists last_search] || $search_results == 0} {
	    $w.view.menu entryconfigure [expr $fe + 0] -state disabled
	} else {
	    $w.view.menu entryconfigure [expr $fe + 0] -state normal
	}
	if {[info exists afterpost_view]} {
	    eval $afterpost_view
	}
    }
    method TemplatesPostMenu {} {
	global fx_config $mode_variable
	global fx:search_modeval fx:add_modeval

	set fe $tearoffs
	set m [set $mode_variable]
	if {[string compare $m ${fx:add_modeval}] == 0 || [string compare $m ${fx:search_modeval}] == 0} {
	    $w.templates.menu entryconfigure [expr $fe + 0] -state normal
	    if {[info exists fx_config(current_template)]} {
		$w.templates.menu entryconfigure [expr $fe + 1] -state normal
	    } else {
		$w.templates.menu entryconfigure [expr $fe + 1] -state disabled
	    }
	    $w.templates.menu entryconfigure [expr $fe + 2] -state normal
	} else {
	    $w.templates.menu entryconfigure [expr $fe + 0] -state disabled
	    $w.templates.menu entryconfigure [expr $fe + 1] -state disabled
	    $w.templates.menu entryconfigure [expr $fe + 2] -state normal
	}
	if {[info exists afterpost_templates]} {
	    eval $afterpost_templates
	}
    }

    # editing procedures
    proc CopySelection {} {
	if {[catch {selection get} sel] == 0} {
	    clipboard clear
	    clipboard append $sel
	}
    }
    proc CutSelection {} {
	set selown [selection own]
	if {[string compare $selown ""] != 0} {
	    if {[catch {selection get} sel] == 0} {
		set cutbuffer $sel
		clipboard clear
		clipboard append $cutbuffer
		$selown delete sel.first sel.last
	    }
	}
    }
    proc SetCutBuffer {str} {
	clipboard clear
	clipboard append $str
    }
    proc AppendCutBuffer {str} {
	clipboard append $str
    }
    proc PasteCutbuffer {} {
	set foc [focus]
	if {![catch {selection get -selection CLIPBOARD} mybuf]} {
	    catch  [list $foc insert insert $mybuf]
	}
    }
    method SearchForEntry {} {
	return $searchfor_entry
    }
    method ConfigureSearchResults {} {
	global $status_variable

	if {[Fx:ConfigureSearchResults $schema $restrict_dir] == 1} {
	    ::set $status_variable "Search Results Configuration Changed"
	}
	InitConfig 0
    }
    method SavePersonalConfig {} {
	global fx_config $status_variable

	set path [qddb_schema path $schema]
	set fn [split $path /]
	set fn [join $fn .]
	set home [glob ~]
	if {![file isdirectory $home/$config_dir]} {
	    while {[catch "exec mkdir $home/$config_dir" msg] != 0} {
		fx_dialog .dialog "ERROR" \
		    "Cannot create directory $home/$config_dir; please remedy the situation and hit OK" \
		    error 0 OK
	    }
	}
	set fd [open $home/$config_dir/$fn "w"]
	foreach i [array names fx_config] {
	    puts $fd [list set fx_config($i) $fx_config($i)]
	}
	SaveOptions $fd
	close $fd
	::set $status_variable "Personal configuration saved"
    }
    method SaveOptions {fd} {
	global fx_resources fx_font

	foreach i [array names fx_font] {
	    puts $fd [list set fx_font($i) $fx_font($i)]
	}
	foreach i $fx_resources {
	    set j [split $i .]
	    if {[string compare [lindex $j 1] font] != 0} {
		set val [option get . [lindex $j 1] [lindex $j 0]]
		if {[string compare $val ""] != 0} {
		    puts $fd "option add *$i $val"
		}
	    }
	}
    }
    method SaveGlobalConfig {} {
	global fx_config $status_variable

	set path [qddb_schema path $schema]
	set fd [open $path/$config_dir "w"]
	foreach i [array names fx_config] {
	    puts $fd [list set fx_config($i) $fx_config($i)]
	}
	SaveOptions $fd
	close $fd
	::set $status_variable "Global configuration saved"
    }
    # Configuration stuff
    method InitConfig {{load_config 1}} {
	global fx_config fx_font fx_colors

	set pa \$search\$,print
	set dpa \$search\$,dontprint
	if {![info exists fx_config($pa)]} {
	    set fx_config($pa) [lrange [qddb_schema leaves $schema] 0 4]
	    set fx_config($dpa) [lrange [qddb_schema leaves $schema] 5 end]
	}
	set headings(\$search\$) {}
	set tmp $fx_config($pa)
	set len [llength $tmp]
	for {set i 0} {$i < $len} {incr i} {
	    set attrname [lindex $tmp $i]
	    if {[catch {qddb_schema option verbosename $schema $attrname} head] != 0} {
		if {[info exists fx_config(\$search\$,user_defs)]} {
		    foreach j $fx_config(\$search\$,user_defs) {
			set username [lindex [lindex $j 1] 1]
			if {[string compare $username $attrname] == 0} {
			    set head $username
			    break
			}
		    }
		}
	    }
	    if {[llength $head] == 0} {
		lappend headings(\$search\$) $attrname
	    } else {
		lappend headings(\$search\$) $head
	    }
	}
	set aa \$search\$,alignment
	if {![info exists fx_config($aa)]} {
	    ::set fx_config($aa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($aa) left
	    }
	}
	set sa \$search\$,separators
	if {![info exists fx_config($sa)]} {
	    set fx_config($sa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($sa) ""
	    }
	}
	set wa \$search\$,widths
	if {![info exists fx_config($wa)]} {
	    set fx_config($wa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($wa) 0
	    }
	}
	set sb \$search\$,sortby
	if {![info exists fx_config($sb)]} {
	    set fx_config(\$search\$,sortby) [qddb_schema leaves $schema]
	}
	set sa \$search\$,ascending
	if {![info exists fx_config($sa)]} {
	    set fx_config($sa) {}
	    foreach i $fx_config(\$search\$,sortby) {
		lappend fx_config($sa) yes
	    }
	}
    }
    method GetLastSearch {} {
	if {[info exists last_search]} {
	    return $last_search
	} else {
	    return {}
	}
    }
    method LastSearchWasNull {} {
	return $last_search_was_null
    }
    method SetLastSearch {table} {
	global fx_config fx_blt

	if {$fx_blt} {
	    blt_busy hold .
	    if {[winfo exists .search_results]} {
		destroy .search_results
	    }
	}
	KillLastSearch
	set last_search $table
	if {$fx_blt} {
	    catch "blt_busy forget ."
	}
    }
    method configure {config} {
	foreach i $config {
	    switch $i {
		Fx_Menubar::view {
		    [lindex $instances 0] configure -setview $view
		}
		Fx_Menubar::tuple {
		    [lindex $instances 0] configure -settuple $tuple
		}
		Fx_Menubar::instances {
		    set textvariables {}
		    set attr_pairs {}
		    set attrs {}
		    foreach j $instances {
			$j configure -array $array
			lappend textvariables [$j GetTextVariable]
			lappend attr_pairs [$j GetAttrPair]
			lappend attrs [$j GetAttr]
		    }
		}
		Fx_Menubar::frames {
		    foreach j $frames {
			$j configure -array $array
		    }
		}
	    }
	}
    }
    proc AfterReconfigure {{l {}}} {
	if {[llength $l] != 0} {
	    set afterreconfigure $l
	} else {
	    if {[info exists afterreconfigure]} {
		return $afterreconfigure
	    } else {
		return { }
	    }
	}
    }
    method DumpConfig {} {
	global fx_config
	foreach i [array names fx_config] {
	    puts "fx_config(${i}): $fx_config($i)"
	}
    }
    method GetView {} {
	return $view
    }

    public w
    public auxbuttons {}
    common restrict_dir {}
    public restrict {} {set restrict_dir $restrict}
    
    protected rowtitles 0

    public schema
    public tuple {}
    protected searchvar
    protected added_tuple
    public view {}
    public instances
    public frames
    public array gv_attr
    protected attr_pairs
    protected attrs
    protected textvariables
    protected last_search
    protected last_search_was_null 1

    public beforechangemode
    public beforeaddmode
    public beforesearchmode
    public beforereadonlymode
    public afterchangemode
    public afteraddmode
    public aftersearchmode
    public afterreadonlymode
    public beforetupledelete {
	if {[fx_dialog .dialog "RECORD DELETION PENDING" \
		"Are you SURE you want to delete this record?   Click on OK to proceed, Cancel to cancel." \
		 warning 0 Cancel OK] == 0} {
	    return
	}
    }
    public beforequit
    public afterquit
    public beforesave
    public aftersave
    public aftersearch
    common afterreconfigure
    public exitproc {exit 0}

    protected changemodeidx

    # for search results and instance viewing
    protected headings

    public mode_variable {fx:mode_variable}
    public status_variable {fx:status_variable}
    public searchfor_variable {fx:searchfor_variable}

    public config_dir .fx_config
    public searchfor 1
    public statusbar 1
    public modebar 1
    public menubar 1
    public search_results 1

    protected searchfor_entry {}
    protected searchfor_label {}

    # settings
    public auto_clear 0
    public auto_save 0
    public auto_save_tuple 0
    public force_readonly_mode 0 {
	global fx_config
	set fx_config(force_readonly_mode) $force_readonly_mode
    }

    protected number_added 0

    public afterpost_file
    public afterpost_edit
    public afterpost_modes
    public afterpost_view
    public afterpost_templates
	  
    public tearoffs 0
}

