
itcl_class Fx_MultiColumnListBox {
    constructor {config} {
	frame $w
	pack $w -side $side -expand on -fill both
	BuildFormats
	scrollbar $w.vs -relief sunken -command [list $w.l2 yview] \
		-takefocus 0
	pack $w.vs -side right -fill y
	scrollbar $w.hs -relief sunken -orient horizontal -command [list $this ListboxesXview] \
		-takefocus 0
	pack $w.hs -side bottom -fill x
	set wid 0
	if {[info exists widths]} {
	    foreach i $widths {
		if {$i == 0} {
		    incr wid 5
		} else {
		    incr wid $i
		}
		incr wid 2
	    }
	} else {
	    set wid 40
	}
	foreach i $separators {
	    incr wid [string length $i]
	}
	listbox $w.l1 -width 1 -height 1 -setgrid on -xscroll [list $w.hs set] \
		-relief sunken -takefocus 0
	pack $w.l1 -side top -fill x -anchor n
	if {[info exists width] && $width < $wid} {
	    listbox $w.l2 -width ${width} -height ${height} \
		    -setgrid on -yscroll [list $w.vs set] -xscroll [list $w.hs set] \
		    -relief sunken -exportselection $exportselection
	} else {
	    listbox $w.l2 -width ${wid} -height ${height} \
		    -setgrid on -yscroll [list $w.vs set] -xscroll [list $w.hs set] \
		    -relief sunken -exportselection $exportselection
	}
	pack $w.l2 -side top -expand on -fill both -anchor n
	foreach i "$w.l1 $w.l2" {
	    bind $i <2> "$w.l2 scan mark %x %y; $w.l1 scan mark %x 0"
	    bind $i <B2-Motion> "$w.l2 scan dragto %x %y; $w.l1 scan dragto %x 0"
	}
	bind $w.l2 <Left> "$w.l1 xview scroll -1 units"
	bind $w.l2 <Control-Left> "$w.l1 xview scroll -1 pages"
	bind $w.l2 <Right> "$w.l1 xview scroll 1 units"
	bind $w.l2 <Control-Right> "$w.l1 xview scroll 1 pages"
	if {[info exists single_select] && [string compare $single_select "on"] == 0} {
	    $w.l2 configure -selectmode browse
	} else {
	    $w.l2 configure -selectmode extended
	    # keysyms that modify extended-mode listboxes
	    set keysyms {
		<space> <Shift-Down> <Shift-Up> <Down> <Up> <Control-slash> <Control-backslash>
		<Control-Home> <Shift-Control-Home> <Control-End> <Shift-Control-End>
		<Select> <Control-Shift-space> <Shift-Select>
	    }
	    foreach i $keysyms {
		bind $w.l2 $i "$this OnSelect; break"
	    }
	}
	bind $w.l2 <ButtonRelease-1> "$this OnSelect; break"
	bind $w.l2 <Return> "$this OnSelect; break"
	bind $w.l2 <Configure> "$this Reconfigure %h"
	bindtags $w.l2 [list Listbox $w.l2 . all]
    }
    destructor {
	catch [list destroy $w]
    }
    method configure {config} {
    }
    method Reconfigure {h} {
	set height [expr [$w.l2 nearest $h] - [$w.l2 nearest 0]]
    }
    method OnSelect {} {
	focus $w.l2
	if {[info exists onselect]} {
	    catch [list eval $onselect [list [$w.l2 curselection]]]
	}
    }
    method ListboxesXview {args} {
	eval "$w.l1 xview $args"
	eval "$w.l2 xview $args"
	update idletasks
    }
    method BuildFormats {{force 0}} {
	# Build the _format string
	set _format_string ""
	if {![info exists widths] || $force} {
	    CalculateWidths
	}
	for {set i 0} {$i < $numcols} {incr i} {
	    if {[info exists align]} {
		if {[string compare [lindex $align $i] "left"] == 0} {
		    set a -
		} else {
		    set a ""
		}
	    } else {
		set a -
	    }
	    if {[info exists separators]} {
		append _format_string [format {%%%s%ds%1s} $a [lindex $widths $i] [lindex $separators $i]]
	    } else {
		append _format_string [format {%%%s%ds } $a [lindex $widths $i]]
	    }
	}
    }
    method CalculateWidths {} {
	for {set j 0} {$j < $numcols} {incr j} {
	    set maxwidth($j) 0
	}
	foreach i $_contents {
	    for {set j 0} {$j < $numcols} {incr j} {
		set str [lindex $i $j]
		set a [string first "\n" $str]
		if {$a == -1} {
		    set len [string length $str]
		} else {
		    incr a -1
		    set len $a
		}
		if {$len > $maxwidth($j)} {
		    set maxwidth($j) $len
		}
	    }
	}
	set j 0
	foreach i $headings {
	    set len [string length $i]
	    if {$len > $maxwidth($j)} {
		set maxwidth($j) $len
	    }
	    incr j
	}
	set widths {}
	for {set j 0} {$j < $numcols} {incr j} {
	    lappend widths $maxwidth($j)
	}
    }

    method AppendRow {values} {
	lappend _contents $values
    }
    method AppendRows {value_list} {
	foreach i $value_list {
	    lappend _contents $i
	}
    }
    method MoveTo {where} {
	set l [$w.l2 curselection]
	if {[string compare $l ""] == 0} {
	    return
	}
	if {[llength $l] > 1} {
	    set last [expr [$w.l2 size] - 1]
	    set j 0
	    set len [$w.l2 size]
	    set spots {}
	    set increment [expr $where - [lindex $l 0]]
	    if {$increment > 0} { ;# moving down
		set l [Fx:lreverse $l]
		set increment [expr $where - [lindex $l 0]]
	    }
	    foreach i $l {
		set spot [expr [lindex $l $j] + $increment]
		if {$spot < 0 || [$w.l2 selection includes $spot]} {
		    set spot $i
		    lappend spots $spot
		    incr j
		    continue
		}
		set val [lindex $_contents $i]
		set _contents [lreplace $_contents $i $i]
		set _contents [eval linsert [list $_contents] $spot [list $val]]
		set val [lindex $_formatted_contents $i]
		set _formatted_contents [lreplace $_formatted_contents $i $i]
		set _formatted_contents [eval linsert [list $_formatted_contents] $spot [list $val]]
		$w.l2 selection clear $i
		$w.l2 selection set $spot
		lappend spots $spot
		incr j
	    }
	    Display
	    foreach i $spots {
		$w.l2 selection set $i
	    }
	    $w.l2 see [lindex $spots 0]
	    $w.l2 activate [lindex $spots 0]
	} else {
	    if {$l < 0} {
		return
	    }
	    set r [DeleteRow $l]
	    set spot $where
	    set _contents [eval linsert [list $_contents] $spot $r]
	    Format
	    eval $w.l2 insert $spot [lrange $_formatted_contents $spot $spot]
	    $w.l2 select set $spot $spot
	    $w.l2 activate $spot
	    $w.l2 see $spot
	}
    }
    method MoveUp {} {
	set l [$w.l2 curselection]
	if {[string compare $l ""] == 0} {
	    return
	}
	if {[llength $l] > 1} {
	    set last [expr [$w.l2 size] - 1]
	    set j 0
	    set len [$w.l2 size]
	    set spots {}
	    foreach i $l {
		set spot [expr [lindex $l $j] - 1]
		if {$spot < 0 || [$w.l2 selection includes $spot]} {
		    set spot $i
		    lappend spots $spot
		    incr j
		    continue
		}
		set val [lindex $_contents $i]
		set _contents [lreplace $_contents $i $i]
		set _contents [eval linsert [list $_contents] $spot [list $val]]
		set val [lindex $_formatted_contents $i]
		set _formatted_contents [lreplace $_formatted_contents $i $i]
		set _formatted_contents [eval linsert [list $_formatted_contents] $spot [list $val]]
		$w.l2 selection clear $i
		$w.l2 selection set $spot
		lappend spots $spot
		incr j
	    }
	    Display
	    foreach i $spots {
		$w.l2 selection set $i
	    }
	    $w.l2 see [lindex $spots 0]
	    $w.l2 activate [lindex $spots 0]
	} else {
	    if {$l == 0} {
		return
	    }
	    set r [DeleteRow $l]
	    set spot [expr $l - 1]
	    set _contents [eval linsert [list $_contents] $spot $r]
	    Format
	    eval $w.l2 insert $spot [lrange $_formatted_contents $spot $spot]
	    $w.l2 select set $spot $spot
	    $w.l2 activate $spot
	    $w.l2 see $spot
	}
    }
    method MoveDown {} {
	set l [$w.l2 curselection]
	if {[string compare $l ""] == 0} {
	    return
	}
	if {[llength $l] > 1} {
	    set last [expr [$w.l2 size] - 1]
	    set j 0
	    set l [Fx:lreverse $l]
	    set len [$w.l2 size]
	    set spots {}
	    foreach i $l {
		set spot [expr [lindex $l $j] + 1]
		if {$spot >= $len || [$w.l2 selection includes $spot]} {
		    set spot $i
		    lappend spots $spot
		    incr j
		    continue
		}
		set val [lindex $_contents $i]
		set _contents [lreplace $_contents $i $i]
		set _contents [eval linsert [list $_contents] $spot [list $val]]
		set val [lindex $_formatted_contents $i]
		set _formatted_contents [lreplace $_formatted_contents $i $i]
		set _formatted_contents [eval linsert [list $_formatted_contents] $spot [list $val]]
		$w.l2 selection clear $i
		$w.l2 selection set $spot
		lappend spots $spot
		incr j
	    }
	    Display
	    foreach i $spots {
		$w.l2 selection set $i
	    }
	    $w.l2 see [lindex $spots 0]
	    $w.l2 activate [lindex $spots 0]
	} else {
	    if {$l == [expr [$w.l2 size] - 1]} {
		return
	    }
	    set r [DeleteRow $l]
	    set spot [expr $l + 1]
	    set _contents [eval linsert [list $_contents] $spot $r]
	    Format
	    eval $w.l2 insert $spot [lrange $_formatted_contents $spot $spot]
	    $w.l2 select set $spot $spot
	    $w.l2 activate $spot
	    $w.l2 see $spot
	}
    }
    method DeleteRow {l} {
	set retval [lrange $_contents $l $l]
	set _contents [lreplace $_contents $l $l]
	set _formatted_contents [lreplace $_formatted_contents $l $l]
	$w.l2 delete $l
	return $retval
    }
    method DeleteRows {l} {
	set j 0
	set retval {}
	foreach i $l {
	    set k [expr [lindex $l $j] - $j]
	    lappend retval [lindex [lrange $_contents $k $k] 0]
	    set _contents [lreplace $_contents $k $k]
	    set _formatted_contents [lreplace $_formatted_contents $k $k]
	    $w.l2 delete $k
	    incr j
	}
	return $retval
    }
    method GetRow {i} {
	return [lindex $_contents $i]
    }
    method GetContents {} {
	return $_contents
    }
    method GetFormattedContents {} {
	lappend retval $_formatted_headings
	foreach i $_formatted_contents {
	    lappend retval $i
	}
	return $retval
    }
    proc SortAttrs {attrs a b} {
	set pa [lsearch -exact $attrs [lindex $a 1]]
	set pb [lsearch -exact $attrs [lindex $b 1]]
	if {$pa < $pb} {
	    return -1
	} elseif {$pa > $pb} {
	    return 1
	}
	return 0
    }
    method SortContents {attrs} {
	set _contents [lsort -command [list Fx_MultiColumnListBox :: SortAttrs $attrs] $_contents]
    }
    method FastSortAttrs {a b} {
	return [expr $attr_array([lindex $a 1]) - $attr_array([lindex $b 1])]
    }
    method FastSortContents {attrs} {
	if {![info exists attr_array]} {
	    set x 0
	    foreach i $attrs {
		set attr_array($i) $x
		incr x
	    }
	} 
	set _contents [lsort -command [list $this FastSortAttrs] $_contents]
    }
    method ReplaceRow {i r} {
	set _contents [lreplace $_contents $i $i $r]
    }
    method ReplaceAndFormatRow {i r} {
	set _contents [lreplace $_contents $i $i $r]
	$w.l2 delete $i
	FormatRow $i $r
    }
    method FormatRow {i k} {
	if {[info exists widths]} {
	    set x 0
	    foreach j $k {
		set wid [lindex $widths $x]
		set a [string first "\n" $j]
		if {$wid == 0 && $a == -1} {
		    lappend k $j
		} else {
		    incr a -1
		    if {$a < 0} {
			set a [expr $wid - 1]
		    }
		    lappend k [string range $j 0 $a]
		}
		incr x
	    }
	}
	$w.l2 insert $i [eval format [list $_format_string] $k]
    }
    method ClearRows {} {
	set _contents {}
    }
    method Format {} {
	set _formatted_contents {}
	foreach i $_contents {
	    set k {}
	    if {[info exists widths]} {
		set x 0
		foreach j $i {
		    set wid [lindex $widths $x]
		    set a [string first "\n" $j]
		    if {$wid == 0 && $a == -1} {
			lappend k $j
		    } else {
			incr a -1
			if {$a < 0} {
			    set a [expr $wid - 1]
			}
			lappend k [string range $j 0 $a]
		    }
		    incr x
		}
	    } else {
		lappend k $i
	    }
	    lappend _formatted_contents [eval format [list $_format_string] $k]
	}
	set k {}
	if {[info exists widths]} {
	    set x 0
	    foreach i $headings {
		set wid [lindex $widths $x]
		if {$wid == 0} {
		    lappend k $i
		} else {
		    lappend k [string range $i 0 [expr $wid - 1]]
		}
		incr x
	    }
	} else {
	    set k $headings
	}
	set _formatted_headings [eval format [list $_format_string] $k]
    }
    method Display {} {
	$w.l1 delete 0 end
	$w.l1 insert end $_formatted_headings
	$w.l1 yview 1
	$w.l2 delete 0 end
	foreach i $_formatted_contents {
	    $w.l2 insert end $i
	}
	if {[string compare $initselection "on"] == 0} {
	    focus $w.l2
	    $w.l2 select set 0 0
	}
    }
    method ClearContents {} {
	$w.l2 delete 0 end
    }

    public w
    public side top

    protected _contents {}
    protected _formatted_contents {}
    protected _format_string
    protected _formatted_headings {}

    protected attr_array

    public onselect
    public staticwidth on
    public settings

    public numcols
    public headings
    public align
    public separators
    public widths
    public width
    public height
    public oldfocus
    public single_select
    public initselection on
    public exportselection on
}

itcl_class Fx_SingleColumnListBox {
    constructor {config} {
	frame $w
	pack $w -side $side -expand on -fill both
	scrollbar $w.vs -relief sunken -command [list $w.l2 yview] \
		-takefocus 0
	pack $w.vs -side right -fill y
	scrollbar $w.hs -relief sunken -orient horizontal -command [list $this ListboxesXview] \
		-takefocus 0
	pack $w.hs -side bottom -fill x
	listbox $w.l1 -width 1 -height 1 -setgrid on -xscroll [list $w.hs set] \
		-relief sunken -takefocus 0
	pack $w.l1 -side top -fill x -anchor n
	listbox $w.l2 -width ${width} -height ${height} \
		-setgrid on -yscroll [list $w.vs set] -xscroll [list $w.hs set] \
		-relief sunken -exportselection $exportselection
	pack $w.l2 -side top -expand on -fill both -anchor n
	foreach i "$w.l1 $w.l2" {
	    bind $i <2> "$w.l2 scan mark %x %y; $w.l1 scan mark %x 0"
	    bind $i <B2-Motion> "$w.l2 scan dragto %x %y; $w.l1 scan dragto %x 0"
	}
	bind $w.l2 <Left> "$w.l1 xview scroll -1 units"
	bind $w.l2 <Control-Left> "$w.l1 xview scroll -1 pages"
	bind $w.l2 <Right> "$w.l1 xview scroll 1 units"
	bind $w.l2 <Control-Right> "$w.l1 xview scroll 1 pages"
	if {[info exists single_select] && [string compare $single_select "on"] == 0} {
	    $w.l2 configure -selectmode browse
	} else {
	    $w.l2 configure -selectmode extended
	    # keysyms that modify extended-mode listboxes
	    set keysyms {
		<space> <Shift-Down> <Shift-Up> <Down> <Up> <Control-slash> <Control-backslash>
		<Control-Home> <Shift-Control-Home> <Control-End> <Shift-Control-End>
		<Select> <Control-Shift-space> <Shift-Select>
	    }
	    foreach i $keysyms {
		bind $w.l2 $i "$this OnSelect; break"
	    }
	}
	bind $w.l2 <ButtonRelease-1> "$this OnSelect; break"
	bind $w.l2 <Return> "$this OnSelect; break"
	bind $w.l2 <Configure> "$this Reconfigure %h"
	bindtags $w.l2 [list Listbox $w.l2 . all]
    }
    destructor {
	catch [list destroy $w]
    }
    method configure {config} {
    }
    method Reconfigure {h} {
	set height [expr [$w.l2 nearest $h] - [$w.l2 nearest 0]]
    }
    method OnSelect {} {
	focus $w.l2
	if {[info exists onselect]} {
	    catch [list eval $onselect [list [$w.l2 curselection]]]
	}
    }
    method ListboxesXview {args} {
	eval "$w.l1 xview $args"
	eval "$w.l2 xview $args"
	update idletasks
    }
    method AppendRow {values} {
	lappend _contents $values
    }
    method AppendRows {value_list} {
	foreach i $value_list {
	    lappend _contents $i
	}
    }
    method DeleteRow {l} {
	set retval [lrange $_contents $l $l]
	set _contents [lreplace $_contents $l $l]
	$w.l2 delete $l
	return $retval
    }
    method DeleteRows {l} {
	set j 0
	set retval {}
	foreach i $l {
	    set k [expr [lindex $l $j] - $j]
	    lappend retval [lindex [lrange $_contents $k $k] 0]
	    set _contents [lreplace $_contents $k $k]
	    $w.l2 delete $k
	    incr j
	}
	return $retval
    }
    method GetRow {i} {
	return [lindex $_contents $i]
    }
    method GetContents {} {
	return $_contents
    }
    method GetFormattedContents {} {
	set retval $headings
	eval lappend retval $_contents
	return $retval
    }
    method ReplaceRow {i r} {
	set _contents [lreplace $_contents $i $i $r]
    }
    method ClearRows {} {
	set _contents {}
    }
    method Display {{norefocus 0}} {
	$w.l1 delete 0 end
	$w.l1 insert end $headings
	$w.l1 yview 1
	$w.l2 delete 0 end
	eval $w.l2 insert end $_contents
	if {[string compare $initselection "on"] == 0} {
	    if {!$norefocus} {
		focus $w.l2
	    }
	    $w.l2 select set 0 0
	    $w.l2 select anchor 0
	    $w.l2 activate 0
	    $w.l2 see 0
	}
    }
    method ClearContents {} {
	$w.l2 delete 0 end
    }

    public w
    public side top

    protected _contents {}

    public onselect

    public headings
    public width 40
    public height 10
    public oldfocus
    public single_select
    public initselection on
    public exportselection on
}
option add *Listbox.font -adobe-courier-bold-r-*-*-*-120-*-*-*-*-*-* widgetDefault

