
proc Fx:ReadFile {file} {
    catch [list open $file "r"] fd
    if {$fd >= 0} {
	set buf [read $fd]
	close $fd
	return $buf
    } else {
	error $fd
    }
}

proc Fx:WriteFile {file buf} {
    catch [list open $file "w"] fd
    if {$fd >= 0} {
	puts $fd $buf
	close $fd
	return {}
    } else {
	error $fd
    }
}

proc Fx:FileListbox {w name title} {
    frame $w.f$name -bd 2 -relief groove 
    pack $w.f$name -side left -expand on -fill both
    set x $w.f$name
    label $x.l -text $title
    pack $x.l -side top -anchor w -fill x 
    scrollbar $x.vscrollbar -command "$x.listbox yview" -relief raised -takefocus 0
    pack $x.vscrollbar -side right -fill y
    listbox $x.listbox -yscroll "$x.vscrollbar set"  \
	    -relief raised -setgrid on -selectmode browse
    pack $x.listbox -side left  -expand yes -fill both
}

proc Fx:FileCheck {w l e fbox dbox} {
    set file [$w get [$w curselection]]
    if [file isdirectory $file] {
	$fbox delete 0 end
	$dbox delete 0 end
	cd $file
	foreach i [exec ls -1a] {
	    if [file isdirectory $i] {
		$dbox insert end $i
	    } else {
		$fbox insert end $i
	    }
	}
	$w select set 0
	$e delete 0 end
	$l configure -text [pwd]
    } else {
	$e delete 0 end
	$e insert 0 $file
    }
}

proc Fx:FileSetDir {w l e fbox dbox file} {
    if [file isdirectory $file] {
	$fbox delete 0 end
	$dbox delete 0 end
	cd $file
	foreach i [exec ls -1a] {
	    if [file isdirectory $i] {
		$dbox insert end $i
	    } else {
		$fbox insert end $i
	    }
	}
	$w select set 0	    
	$e delete 0 end
	$l configure -text [pwd]
    }
}

proc Fx:RestrictedDelete {w} {
    set cur [$w curselection]
    if {[llength $cur] != 1} {return}
    catch [list exec rm -f [$w get $cur]]
    $w delete $cur
    incr cur -1
    if {$cur < 0} {
	set cur 0
    } elseif {$cur >= [$w size]} {
	set cur [expr [$w size] - 1]
    }
    $w see $cur
    $w selection anchor $cur
    $w selection set $cur
}

proc Fx:RestrictedFileName {w listbox} {
    global fx_filename

    set cur [$listbox curselection]
    if {[llength $cur] != 1} {
	set fx_filename($w) ""
    } else {
	set fx_filename($w) [$listbox get $cur]
    }
}

proc Fx:RestrictedFileSelect {w rw restrict} {
    set tmpfilevar fx_tmpfile_[string range $w 1 end]
    global fx_config fx_filename $tmpfilevar

    if {[winfo exists $w]} {
	wm withdraw $w
	wm deiconify $w
	focus $w
	return 0
    }
    if {[string compare $rw r] == 0} {
	set read_only 1
    } else {
	set read_only 0
    }
    set oldfoc [focus]
    set f $w
    toplevel $f
    wm title $f "File Selection"
    wm iconname $f Dialog
    wm protocol $f WM_DELETE_WINDOW { }
    wm transient $f [winfo toplevel [winfo parent $f]]

    if {[info exists fx_config(geom,$w)]} {
	wm geometry $w $fx_config(geom,$w)
    }
    if {![file isdirectory $restrict]} {
	fx_make_directory_hierarchy $restrict
    }
    set $tmpfilevar {}
    set dir $restrict
    set whereami [pwd]
    cd $restrict
    frame $f.but
    pack $f.but -side bottom -fill x
    set x $f.but
    if {$read_only} {
	button $x.select -text "Read" -relief raised -bd 2 -command "set $tmpfilevar s"
    } else {
	button $x.select -text "Write" -relief raised -bd 2 -command "set $tmpfilevar s"	
    }
    pack $x.select -side left -padx 5m -pady 2m -ipadx 10m -ipady 2m
    set tmp $f.listbox.ffiles.listbox
    button $x.delete -text "Delete" -relief raised -bd 2 -command \
	    "Fx:RestrictedDelete $tmp; Fx:RestrictedFileName $w $tmp"
    button $x.cancel -text "Cancel" -relief raised -bd 2 -command "set $tmpfilevar {}"
    pack $x.cancel -side right -padx 5m -pady 2m -ipadx 10m -ipady 2m
    pack $x.delete -side right -padx 5m -pady 2m -ipadx 10m -ipady 2m

    set v $f.fileboxentries
    frame $v  -bd 2 -relief groove
    pack $v -side top -fill both
    if {$read_only} {
	label $v.l -text "Read from file:"
    } else {
	label $v.l -text "Write to file:"
    }
    entry $v.v -textvariable fx_filename($w) -relief sunken
    bind $v.v <Key-slash> {bell; break} ;# slashes are illegal in file names
    if {$read_only} {
	$v.v configure -state disabled
    }
    pack $v.l -side left -anchor w
    pack $v.v -side right -fill x -expand yes
    bind $v.v <Return> "$f.but.select invoke; break"
    set f2 $f.listbox
    frame $f2
    set fbox $f.listbox.ffiles.listbox
    pack $f2 -side top -fill both -expand yes
    Fx:FileListbox $f2 files "Files:" 
    bind $f2.ffiles.listbox <Button-1> [list Fx:RestrictedFileName $w $f2.ffiles.listbox]
    bind $f2.ffiles.listbox <Up> [list Fx:RestrictedFileName $w $f2.ffiles.listbox]
    bind $f2.ffiles.listbox <Down> [list Fx:RestrictedFileName $w $f2.ffiles.listbox]
    bind $f2.ffiles.listbox <Control-n> [list Fx:RestrictedFileName $w $f2.ffiles.listbox]
    bind $f2.ffiles.listbox <Control-p> [list Fx:RestrictedFileName $w $f2.ffiles.listbox]
    bind $f2.ffiles.listbox <Return> "$f.but.select flash; $f.but.select invoke; break"
    bind $f2.ffiles.listbox <space> "$f.but.select flash; $f.but.select invoke; break"
    bindtags $f2.ffiles.listbox [list Listbox $f2.ffiles.listbox all .]

    foreach i [split [exec ls -1a] \n] {
	if {"[string index $i 0]" == "."} {continue}
	$fbox insert end $i
    }
    $f2.ffiles.listbox select anchor 0
    $f2.ffiles.listbox select set 0
    if {[llength [$f2.ffiles.listbox curselection]] > 0} {
	set fx_filename($w) [$f2.ffiles.listbox get 0]
    }

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
        - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
        - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    catch "grab $f"
    if {!$read_only} {
	focus $v.v
    } else {
	focus $fbox
    }
    tkwait variable $tmpfilevar
    if {[string length [set $tmpfilevar]] > 0} {
	set file $fx_filename($w)
	if {[string length $file] > 0} {
	    set retval $dir/$file
	} else {
	    set retval {}
	}
    } else {
	set retval {}
    }
    cd $whereami
    grab release $f
    catch "focus $oldfoc"
    set fx_config(geom,$w) [wm geometry $w]
    destroy $f
    return $retval
}


proc Fx:FileSelect {w rw {restrict ""}} {
    global fx_config fx_filename

    if {[string length $restrict] > 0} {
	return [Fx:RestrictedFileSelect $w $rw $restrict]
    }
    if {[winfo exists $w]} {
	wm withdraw $w
	wm deiconify $w
	focus $w
	return 0
    }
    if {[string compare $rw r] == 0} {
	set read_only 1
    } else {
	set read_only 0
    }
    set oldfoc [focus]
    set f $w
    toplevel $f
    wm title $f "File Selection"
    wm iconname $f Dialog
    wm protocol $f WM_DELETE_WINDOW { }
    wm transient $f [winfo toplevel [winfo parent $f]]

    if {[info exists fx_config(geom,$w)]} {
	wm geometry $w $fx_config(geom,$w)
    }
    set dir [pwd]
    set whereami [pwd]
    frame $f.but
    pack $f.but -side bottom -fill x
    set x $f.but
    button $x.select -text "Select" -relief raised -bd 2 -command {
	global fx_config
	set fx_config(tmp_file) "s"
    }
    pack $x.select -side left -padx 10m -pady 2m -ipadx 10m -ipady 2m 
    button $x.cancel -text "Cancel" -relief raised -bd 2 -command {
	global fx_config
	set fx_config(tmp_file) {}
    }
    pack $x.cancel -side right -padx 10m -pady 2m -ipadx 10m -ipady 2m

    set v $f.fileboxentries
    frame $v  -bd 2 -relief groove
    pack $v -side top -fill both
    frame $v.path 
    pack $v.path -side top -fill x -expand yes
    label $v.path.l -text "Pathname:"
    label $v.path.v -text [pwd] -relief sunken -anchor w
    pack $v.path.l -side left -anchor w
    pack $v.path.v -side right -anchor w -fill x -expand on
    frame $v.file
    pack $v.file -side top -fill x -expand yes
    if {$read_only} {
	label $v.file.l -text "Read from file:"
    } else {
	label $v.file.l -text "Write to file:"
    }
    entry $v.file.v -textvariable fx_filename($w) -relief sunken
    pack $v.file.l -side left -anchor w
    pack $v.file.v -side right -fill x -expand yes

    set f2 $f.listbox
    frame $f2
    set fbox $w.listbox.ffiles.listbox
    set dbox $w.listbox.fdirs.listbox
    pack $f2 -side top -fill both -expand yes
    Fx:FileListbox $f2 dirs "Directories:"
    bind $f2.fdirs.listbox <ButtonRelease-1> \
	    [list Fx:FileCheck $dbox $v.path.v $v.file.v $fbox $dbox]
    bind $f2.fdirs.listbox <Return> \
	    [list Fx:FileCheck $dbox $v.path.v $v.file.v $fbox $dbox]
    focus $f2.fdirs.listbox 

    Fx:FileListbox $f2 files "Files:" 
    bind $f2.ffiles.listbox <ButtonRelease-1> \
	    [list Fx:FileCheck $fbox $v.path.v $v.file.v $fbox $dbox]
    bind $f2.ffiles.listbox <Return> \
	    [list Fx:FileCheck $fbox $v.path.v $v.file.v $fbox $dbox]
    focus $f2.ffiles.listbox 

    foreach i [split [exec ls -1a] \n] {
	if [file isdirectory $i] {
	    $dbox insert end $i
	} else {
	    $fbox insert end $i
	}
    }
    $f2.fdirs.listbox select anchor 0
    $f2.fdirs.listbox select set 0
    $f2.ffiles.listbox select anchor 0
    $f2.ffiles.listbox select set 0
    bind $v.file.v <Return> {
	set fx_config(tmp_file) "s"
	break
    }

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
        - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
        - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    catch "grab $w"
    focus $v.file.v
    tkwait variable fx_config(tmp_file)
    while {[string length $fx_config(tmp_file)] > 0} {
	set dir [lindex [$w.fileboxentries.path.v configure -text] 4]
	set file [lindex [$w.fileboxentries.file.v configure -text] 4]
	set file [$w.fileboxentries.file.v get]
	if {[file isdirectory $file]} {
	    Fx:FileSetDir $fbox $v.path.v $v.file.v $fbox $dbox $file
	    tkwait variable fx_config(tmp_file)
	} elseif {[string length $file] == 0} {
	    Fx:FileSetDir $fbox $v.path.v $v.file.v $fbox $dbox $dir
	    tkwait variable fx_config(tmp_file)
	} else {
	    set retval $dir/$file
	    break
	}
    } 
    if {[string length $fx_config(tmp_file)] == 0} {
	set retval {}
    }
    grab release $w
    catch "focus $oldfoc"
    set fx_config(geom,$w) [wm geometry $w]
    destroy $f
    return $retval
}
