

itcl_class Fx_Configuration {
    constructor {config} {
	global qddb_library fx_config fx_tmpconfig fx_monochrome

	if {[winfo exists .$this]} {
	    set nodelete 1
	    $this delete
	}
	if {$fx_monochrome} {
	    set mono 1
	}
	set oldfocus [focus]
	toplevel .$this
	wm title .$this $title
	if {[info exists fx_config(geom,$this)]} {
	    wm geometry .$this $fx_config(geom,$this)
	}
	set c .$this
	if {$checkattrs && [info exists fx_config($idx,attrs)]} {
	    set attrs $fx_config($idx,attrs)
	}
	set x 0
	foreach i $attrs {
	    set attr_array($i) $x
	    incr x
	}
	set max_attrs $x
	if {[info exists fx_config($idx,user_defs)]} {
	    foreach i $fx_config($idx,user_defs) {
		set user_defs([lindex $i 0]) [lindex $i 1]
	    }
	    if {[info exists fx_config($idx,nextuserdef)]} {
		set nextuserdef $fx_config($idx,nextuserdef)
	    }
	}
	frame $c.bot -relief raised -bd 3
	pack $c.bot -side bottom -fill x
	button $c.bot.ok -text Ok -padx 5m -pady 2m \
	    -command [list $this SaveConfig]
	pack $c.bot.ok -side left -padx 10m -pady 4m 
	button $c.bot.cancel -text Cancel -padx 5m -pady 2m \
	    -command [list $this Quit]
	pack $c.bot.cancel -side left -padx 10m -pady 4m
	if {$rw} {
	    button $c.bot.read -text "Read from file" -padx 5m -pady 2m \
		    -command [list $this ReadFile]
	    button $c.bot.write -text "Write to file" -padx 5m -pady 2m \
		    -command [list $this WriteFile]
	    pack $c.bot.write -side right -padx 10m -pady 4m
	    pack $c.bot.read -side right -padx 10m -pady 4m
	}

	frame $c.top -relief raised -bd 3
	pack $c.top -side top -expand on -fill both

	frame $c.top.l
	pack $c.top.l -side left -expand on -fill both
	label $c.top.l.l -text "Sort By"
	pack $c.top.l.l -side top -fill x -anchor n
	# BEGIN HACK
	# This is a hack.   There seems to be a bug in Tk here.   Without the
	# following code, the $c.top.l.l label is never redrawn....
	destroy $c.top.l.l 
	label $c.top.l.l -text "Sort By"
	pack $c.top.l.l -side top -fill x -anchor n
	# END HACK
	set listbox(${this}_config_sortby) $c.top.l.sortby
	Fx_MultiColumnListBox ${this}_config_sortby -w $c.top.l.sortby -side top -numcols 3 \
	    -width 15 -headings {Verbosename Attribute Ascending} \
	    -align {left left left} -single_select off -separators {" " " " " "} \
	    -initselection off \
	    -height 10 -onselect [list $this SortBySelect]
	set info {}
	if {![info exists fx_config($idx,sortby)]} {
	    ::set fx_config($idx,sortby) [lrange $attrs 0 4]
	    ::set fx_config($idx,ascending) {}
	    foreach i $fx_config($idx,sortby) {
		lappend fx_config($idx,ascending) yes
	    }
	}
	if {![info exists fx_config($idx,print)]} {
	    set fx_config($idx,print) [lrange $attrs 0 4]
	}
	MergePrintAndSortLists
	set x 0
	foreach i $fx_config($idx,sortby) {
	    if {"[string index $i 0]" == "\$"} {
		set defnum [string range $i 6 end]
		set verb [lindex $user_defs($defnum) 1]
	    } else {
		set verb [qddb_schema option verbosename $schema $i]
	    }
	    if {[llength $verb] == 0} {
		set verb [split $i .] 
		set verb [lindex $verb [expr [llength $verb] - 1]]
	    }
	    lappend info [list $verb $i [lindex $fx_config($idx,ascending) $x]]
	    incr x
	}
	${this}_config_sortby AppendRows $info
	${this}_config_sortby BuildFormats 1
	${this}_config_sortby Format
	${this}_config_sortby Display
	bind $listbox(${this}_config_sortby).l2 <Button-3> [list $this MoveTo %y]

	frame $c.top.m
	pack $c.top.m -side left -expand on -fill both

	label $c.top.m.l -text "Print"
	set listbox(${this}_config_print) $c.top.m.print
	Fx_MultiColumnListBox ${this}_config_print -w $c.top.m.print -side top -numcols 5 \
	    -width 20 -headings {Verbosename Attribute Width Alignment Separator} \
	    -align {left left left left left} -single_select off -separators {" " " " " " " " " "} \
	    -initselection off \
	    -height 10 -onselect [list $this PrintSelect]
	pack forget $c.top.m.print
	set info {}
	set x 0
	foreach i $fx_config($idx,print) {
	    if {"[string index $i 0]" == "\$"} {
		set defnum [string range $i 6 end]
		set verb [lindex $user_defs($defnum) 1]
	    } else {
		set verb [qddb_schema option verbosename $schema $i]
	    }
	    if {[llength $verb] == 0} {
		set verb [split $i .] 
		set verb [lindex $verb [expr [llength $verb] - 1]]
	    }
	    lappend info [list $verb $i \
			      [lindex $fx_config($idx,widths) $x] \
			      [lindex $fx_config($idx,alignment) $x] \
			      [lindex $fx_config($idx,separators) $x]]
	    incr x
	}
	${this}_config_print AppendRows $info
	${this}_config_print BuildFormats 1
	${this}_config_print Format
	${this}_config_print Display
	bind $listbox(${this}_config_print).l2 <Button-3> [list $this MoveTo %y]

	frame $c.top.m.r
	pack $c.top.m.r -side right -fill y -anchor s
	set bf $c.top.m.r
	set up @${qddb_library}/fx/pixmaps/up.xbm
	set down @${qddb_library}/fx/pixmaps/down.xbm
	set right @${qddb_library}/fx/pixmaps/right.xbm
	set left @${qddb_library}/fx/pixmaps/left.xbm
	label $bf.top
	pack $bf.top -fill x
	button $bf.up -bitmap $up -command [list $this MoveUp]
	if {$mono == 0} {
	    $bf.up configure -fg blue
	}
	pack $bf.up -expand on -fill y -ipady 5m
	lappend sortbyconf(enable) $bf.up
	lappend printconf(enable) $bf.up
	lappend dontprintconf(disable) $bf.up
	button $bf.down -bitmap $down -command [list $this MoveDown]
	if {$mono == 0} {
	    $bf.down configure -fg blue
	}
	pack $bf.down -expand on -fill y -ipady 5m
	lappend sortbyconf(enable) $bf.down
	lappend printconf(enable) $bf.down
	lappend dontprintconf(disable) $bf.down
	button $bf.right -bitmap $right -command [list $this MoveRight]
	if {$mono == 0} {
	    $bf.right configure -fg blue
	}
	pack $bf.right -expand on -fill y -ipady 5m
	lappend sortbyconf(disable) $bf.right
	lappend printconf(enable) $bf.right
	lappend dontprintconf(disable) $bf.right
	button $bf.left -bitmap $left -command [list $this MoveLeft]
	if {$mono == 0} {
	    $bf.left configure -fg blue
	}
	pack $bf.left -expand on -fill y -ipady 5m
	lappend sortbyconf(disable) $bf.left
	lappend printconf(disable) $bf.left
	lappend dontprintconf(enable) $bf.left
	pack $c.top.m.l -side top -fill x -anchor n
	pack $c.top.m.print -side left -expand on -fill both

	frame $c.top.r
	pack $c.top.r -side left -expand on -fill both
	label $c.top.r.l -text "Don't Print"
	pack $c.top.r.l -side top -fill x -anchor n
	set listbox(${this}_config_dontprint) $c.top.r.dontprint
	Fx_MultiColumnListBox ${this}_config_dontprint -w $c.top.r.dontprint -side top -numcols 2 \
	    -width 15 -headings {Verbosename Attribute} \
	    -align {left left} -single_select off -separators {" " " "} \
	    -initselection off \
	    -height 10 -onselect [list $this DontPrintSelect]
	if {![info exists fx_config($idx,unsorted)]} {
	    ::set fx_config($idx,unsorted) 0
	}
	if {![info exists fx_config($idx,linenumbers)]} {
	    ::set fx_config($idx,linenumbers) 0
	}
	if {![info exists fx_config($idx,dontprint)]} {
	    ::set fx_config($idx,dontprint) {}
	    if {[info exists fx_config($idx,print)]} {
		foreach i $fx_config($idx,print) {
		    set use 1
		    foreach j $attrs {
			if {[string compare $i $j] == 0} {
			    set use 0
			    break
			}
		    }
		    if {$use} {
			lappend fx_config($idx,dontprint) $i
		    }
		}
	    } else {
		::set fx_config($idx,dontprint) $attrs
		::set fx_config($idx,print) {}
		::set fx_config($idx,widths) {}
		::set fx_config($idx,alignment) {}
		::set fx_config($idx,separators) {}
	    }
	} else {
	    if {[llength $attrs] != [expr [llength $fx_config($idx,dontprint)] + \
					 [llength $fx_config($idx,print)]]} {
		foreach i $attrs {
		    if {[lsearch -exact $fx_config($idx,dontprint) $i] == -1 && \
			    [lsearch -exact $fx_config($idx,print) $i] == -1} {
			lappend fx_config($idx,dontprint) $i
			lappend fx_config($idx,sortby) $i
		    }
		}
	    }
	    if {[llength $attrs] != [llength $fx_config($idx,sortby)]} {
		foreach i $attrs {
		    if {[lsearch -exact $fx_config($idx,dontprint) $i] == -1 && \
			    [lsearch -exact $fx_config($idx,print) $i] == -1} {
			lappend fx_config($idx,sortby) $i
		    }
		}
	    }
	    ::set fx_config($idx,dontprint) \
		[lsort -command [list $this SortAttrs] $fx_config($idx,dontprint)]
	}
	set info {}
	foreach i $fx_config($idx,dontprint) {
	    if {"[string index $i 0]" == "\$"} {
		set defnum [string range $i 6 end]
		set verb [lindex $user_defs($defnum) 1]
	    } else {
		set verb [qddb_schema option verbosename $schema $i]
	    }
	    if {[llength $verb] == 0} {
		set verb [split $i .] 
		set verb [lindex $verb [expr [llength $verb] - 1]]
	    }
	    lappend info [list $verb $i]
	}
	${this}_config_dontprint AppendRows $info
	${this}_config_dontprint BuildFormats 1
	${this}_config_dontprint Format
	${this}_config_dontprint Display

	frame $c.mid -relief raised -bd 3
	pack $c.mid -side top -fill x
	set d $c.mid

	# Ascending/descending
	frame $d.f1 -relief sunken -bd 2
	pack $d.f1 -side left -fill y
	button $d.f1.l -text "Sorting Order:" -anchor e -relief flat -takefocus 0 -justify right \
		-highlightthickness 0 -padx 0 -pady 0
	bindtags $d.f1.l {.}
	if {$mono == 0} {
	    $d.f1.l configure -fg blue
	}
	pack $d.f1.l -side left -anchor e
	radiobutton $d.f1.asc -text Ascending -value Ascending \
	    -variable fx_tmpconfig($idx,ascending_descending)
	radiobutton $d.f1.desc -text Descending -value Descending \
	    -variable fx_tmpconfig($idx,ascending_descending)
	pack $d.f1.asc -side left
	pack $d.f1.desc -side left
	lappend sortbyconf(enable) $d.f1.l $d.f1.asc $d.f1.desc
	lappend printconf(disable) $d.f1.l $d.f1.asc $d.f1.desc
	lappend dontprintconf(disable) $d.f1.l $d.f1.asc $d.f1.desc
	if {[info exists fx_config($idx,unsorted)]} {
	    ::set fx_tmpconfig($idx,unsorted) $fx_config($idx,unsorted)
	} else {
	    ::set fx_tmpconfig($idx,unsorted) 0
	}
	if {[info exists fx_config($idx,linenumbers)]} {
	    ::set fx_tmpconfig($idx,linenumbers) $fx_config($idx,linenumbers)
	} else {
	    ::set fx_tmpconfig($idx,linenumbers) 0
	}
	if {[info exists fx_config($idx,ignore_errors)]} {
	    ::set fx_tmpconfig($idx,ignore_errors) $fx_config($idx,ignore_errors)
	} else {
	    ::set fx_tmpconfig($idx,ignore_errors) 0
	}

	# User-defined fields
	set padx [$d.f1.asc cget -padx]
	set pady [$d.f1.asc cget -pady]
	frame $d.f2 -relief sunken -bd 2
	pack $d.f2 -side left -fill both
	button $d.f2.l -text "User-defined columns:" -anchor e -relief flat -takefocus 0 -justify right \
		-highlightthickness 0 -padx 0 -pady 0
	bindtags $d.f2.l {.}
	if {$mono == 0} {
	    $d.f2.l configure -fg blue
	}
	pack $d.f2.l -side left -anchor e
	button $d.f2.new -text New -relief raised -padx $padx -pady $pady \
		-command [list $this NewUserDef]
	button $d.f2.edit -text Edit -relief raised -padx $padx -pady $pady -state disabled \
		-command [list $this EditUserDef]
	button $d.f2.delete -text Delete -relief raised -padx $padx -pady $pady -state disabled \
		-command [list $this DeleteUserDef]
	pack $d.f2.new -side left
	pack $d.f2.edit -side left
	pack $d.f2.delete -side left
	set b_user_edit $d.f2.edit
	set b_user_delete $d.f2.delete

	frame $c.mid2 -relief raised -bd 3
	pack $c.mid2 -side top -fill x
	set d $c.mid2

	# Alignment
	frame $d.f0 -relief sunken -bd 2
	pack $d.f0 -side left -fill x
	button $d.f0.l -text "Justify:" -anchor e -relief flat -takefocus 0 -justify right \
		-highlightthickness 0 -padx 0 -pady 0
	bindtags $d.f0.l {.}
	if {$mono == 0} {
	    $d.f0.l configure -fg blue
	}
	pack $d.f0.l -side left -anchor e
	radiobutton $d.f0.left -text Left -value Left -variable fx_tmpconfig($idx,left_right)
	radiobutton $d.f0.right -text Right -value Right -variable fx_tmpconfig($idx,left_right)
	radiobutton $d.f0.center -text Center -value Center -variable fx_tmpconfig($idx,left_right)
	radiobutton $d.f0.none -text None -value None -variable fx_tmpconfig($idx,left_right)
	pack $d.f0.none -side right
	pack $d.f0.center -side right
	pack $d.f0.right -side right
	pack $d.f0.left -side right
	lappend sortbyconf(disable) $d.f0.l $d.f0.right $d.f0.left $d.f0.center $d.f0.none
	lappend printconf(enable) $d.f0.l $d.f0.right $d.f0.left $d.f0.center $d.f0.none
	lappend dontprintconf(disable) $d.f0.l $d.f0.right $d.f0.left $d.f0.center $d.f0.none

	# Width
	frame $d.f3 -relief sunken -bd 2
	pack $d.f3 -side left -fill x
	button $d.f3.l -text "Width:" -anchor e -relief flat -takefocus 0 -justify right \
		-highlightthickness 0 -padx 0 -pady 0
	bindtags $d.f3.l {.}
	if {$mono == 0} {
	    $d.f3.l configure -fg blue
	}
	pack $d.f3.l -side left -anchor e
	entry $d.f3.e -width 4 -relief sunken -bd 2 -textvariable fx_tmpconfig($idx,width)
	pack $d.f3.e -side left -anchor w
	lappend sortbyconf(disable) $d.f3.l $d.f3.e
	lappend printconf(enable) $d.f3.l $d.f3.e
	lappend dontprintconf(disable) $d.f3.l $d.f3.e

	# Separators
	frame $d.f4 -relief sunken -bd 2
	pack $d.f4 -side left -fill x
	button $d.f4.l -text "Separator:" -anchor e -relief flat -takefocus 0 -justify right \
		-highlightthickness 0 -padx 0 -pady 0
	bindtags $d.f4.l {.}
	if {$mono == 0} {
	    $d.f4.l configure -fg blue
	}
	pack $d.f4.l -side left -anchor e
	entry $d.f4.e -width 2 -relief sunken -bd 2 -textvariable fx_tmpconfig($idx,separators)
	pack $d.f4.e -side left -anchor w
	lappend sortbyconf(disable) $d.f4.l $d.f4.e
	lappend printconf(enable) $d.f4.l $d.f4.e
	lappend dontprintconf(disable) $d.f4.l $d.f4.e

	frame $c.mid3 -relief raised -bd 3
	pack $c.mid3 -side top -fill x
	set d $c.mid3

 	# Print line numbers
	frame $d.f1 -relief sunken -bd 2
	pack $d.f1 -side left -fill x
	checkbutton $d.f1.l -text "Print line numbers" -anchor e -relief raised -bd 2 \
		-variable fx_tmpconfig($idx,linenumbers)
	pack $d.f1.l -side left -anchor e

	# Ignore sorting order
	frame $d.f2 -relief sunken -bd 2
	pack $d.f2 -side left -fill x
	checkbutton $d.f2.l -text "Unsorted order" -anchor e -relief raised -bd 2 \
		-variable fx_tmpconfig($idx,unsorted)
	pack $d.f2.l -side left -anchor e

	# Ignore errors in expressions
	frame $d.f3 -relief sunken -bd 2
	pack $d.f3 -side left -fill x
	checkbutton $d.f3.l -text "Ignore calculation errors" -anchor e -relief raised -bd 2 \
		-variable fx_tmpconfig($idx,ignore_errors)
	pack $d.f3.l -side left -anchor e

	NoSelect
	bind .$this <Configure> [list $this ConfigureWindow]
	if {[info exists fx_config(geom,$this)]} {
	    wm geometry .$this $fx_config(geom,$this)
	}
    }    
    destructor {
	global fx_tmpconfig

	MergePrintAndSortLists
	if {$nodelete == 0} {
	    catch "${this}_config_sortby delete"
	    catch "${this}_config_print delete"
	    catch "${this}_config_dontprint delete"
	    if {[winfo exists .${this}_readfile]} {
		.${this}_readfile.but.cancel invoke
	    }
	    if {[winfo exists .${this}_writefile]} {
		.${this}_writefile.but.cancel invoke
	    }
	    catch "destroy .$this"
	    trace vdelete fx_tmpconfig($idx,ascending_descending) w [list $this SortByTrace]
	    trace vdelete fx_tmpconfig($idx,left_right) w [list $this PrintTrace]
	    trace vdelete fx_tmpconfig($idx,separators) w [list $this PrintTrace]
	    trace vdelete fx_tmpconfig($idx,width) w [list $this PrintTrace]
	}
	focus $oldfocus
    }
    method SetUserDef {def {index -1} {defnum -1}} {
	if {[string length $def] != 0} {
	    set thisattr [lindex $def 0]
	    set thisverb [lindex $def 1]
	    if {$index != -1} {
		set r [${this}_config_print GetRow $index]
		set r [lreplace $r 1 1 $thisattr]
		set r [lreplace $r 0 0 $thisverb]
		${this}_config_print ReplaceRow $index $r
	    } else {
		set k {}
		lappend k $thisverb
		lappend k $thisattr
		lappend k 0 left " "
		${this}_config_print AppendRow $k
	    }
	    if {$index != -1} {
		set lsortby [${this}_config_sortby GetContents]
		set nlsortby {}
		foreach j $lsortby {
		    lappend nlsortby [lindex $j 1]
		}
		set sortidx [lsearch -exact $nlsortby $thisattr]
		if {$sortidx == -1} {
		    puts "search failed for '$thisattr'"
		}
		set r [${this}_config_sortby GetRow $sortidx]
		set r [lreplace $r 1 1 $thisattr]
		set r [lreplace $r 0 0 $thisverb]
		${this}_config_sortby ReplaceRow $sortidx $r
	    } else {
		set k {}
		lappend k $thisverb
		lappend k $thisattr
		lappend k yes
		${this}_config_sortby AppendRow $k
	    }
	    ${this}_config_print CalculateWidths
	    ${this}_config_print BuildFormats
	    ${this}_config_print Format
	    ${this}_config_print Display
	    ${this}_config_sortby CalculateWidths
	    ${this}_config_sortby BuildFormats
	    ${this}_config_sortby Format
	    ${this}_config_sortby Display
	    NoSelect
	    if {$index == -1} {
		incr max_attrs
		set attr_array($thisattr) $max_attrs
		set user_defs($nextuserdef) $def
		lappend attrs $thisattr
		incr nextuserdef
	    } else {
		set user_defs($defnum) $def
	    }
	}
    }
    method NewUserDef {} {
	set fields {}
	set r [${this}_config_print GetContents]
	foreach i $r {
	    set c [lindex $i 1]
	    set v [lindex $i 0]
	    if {[string compare [string index $c 0] \$] != 0} {
		if {[catch  {qddb_schema option type $schema $c} mytype] != 0} {continue}
		switch -exact $mytype {
		    real -
		    integer { lappend fields [list $v $c] }
		}
	    } else {
		lappend fields [list $v $c]
	    }
	}
	set def [Fx:UserDefinedFields [list \$user_$nextuserdef {} {}] .$this [list [list {"" ""} $fields]]]
	SetUserDef $def
    }
    method EditUserDef {} {
	set index [$listbox(${this}_config_print).l2 curselection]
	set len [llength $index]
	if {$len == 0} {
	    return
	}
	set r [${this}_config_print GetRow $index]
	set thisattr [lindex $r 1]
	set thisverb [lindex $r 0]
	set defnum [string range $thisattr 6 end]
	set l $user_defs($defnum)
	set fields {}
	set r [${this}_config_print GetContents]
	foreach i $r {
	    set c [lindex $i 1]
	    set v [lindex $i 0]
	    if {[string compare [string index $c 0] \$] != 0} {
		if {[catch  {qddb_schema option type $schema $c} mytype] != 0} {continue}
		switch -exact $mytype {
		    real -
		    integer { lappend fields [list $v $c] }
		}
	    } else {
		lappend fields [list $v $c]
	    }
	}
	set def [Fx:UserDefinedFields $l .$this [list [list {} $fields]]]
	SetUserDef $def $index $defnum
    }
    method DeleteUserDef {} {
	set index [$listbox(${this}_config_print).l2 curselection]
	set len [llength $index]
	if {$len == 0} {
	    return
	}
	if {[fx_dialog .${this}.dialog "Deleting column" \
		"Really delete user-defined column?" warning 0 Cancel Ok] == 0} {
	    return
	}
	set lsortby [${this}_config_sortby GetContents]
	set nlsortby {}
	foreach j $lsortby {
	    lappend nlsortby [lindex $j 1]
	}
	set r [$current_listbox DeleteRow $index]
	set sortidx [lsearch -exact $nlsortby [lindex [lindex $r 0] 1]]
	if {$sortidx == -1} {
	    puts "search failed for '[lindex $r 1]'"
	}
	NoSelect
	${this}_config_sortby DeleteRow $sortidx
	set thisattr [lindex $r 1]
	set defnum [string range $thisattr 6 end]
	catch "unset user_defs($defnum)"
	catch "unset attr_array($thisattr)"
	set attridx [lsearch -exact $attrs $thisattr]
	if {$attridx != -1} {
	    set attrs [lreplace $attrs $attridx $attridx]
	}
    }
    method MergePrintAndSortLists {} {
	global fx_config

	foreach i $fx_config($idx,print) {
	    set lprint($i) {}
	}
	set x 0
	set retval1 {}
	set retval2 {}
	foreach i $fx_config($idx,sortby) {
	    if {[info exists lprint($i)]} {
		lappend retval1 $i
		lappend retval2 [lindex $fx_config($idx,ascending) $x]
	    }
	    incr x
	}
	::set fx_config($idx,sortby) $retval1
	::set fx_config($idx,ascending) $retval2	
    }
    method ConfigureWindow {} {
	global fx_config
	update idletasks
	update
	::set fx_config(geom,$this) [wm geometry .$this]
    }
    method SortAttrs {a b} {
	return [expr $attr_array($a) - $attr_array($b)]
    }
    method NoSelect {} {
	foreach i $dontprintconf(enable) {
	    $i configure -state disabled
	}
	foreach i $dontprintconf(disable) {
	    $i configure -state disabled
	}
	$b_user_edit configure -state disabled
	$b_user_delete configure -state disabled
    }
    method DontPrintSelect {i} {
	global fx_tmpconfig

	set current_listbox ${this}_config_dontprint
	foreach i $dontprintconf(enable) {
	    $i configure -state normal
	}
	foreach i $dontprintconf(disable) {
	    $i configure -state disabled
	}
	$b_user_edit configure -state disabled
	$b_user_delete configure -state disabled
	trace vdelete fx_tmpconfig($idx,left_right) w [list $this PrintTrace]
	trace vdelete fx_tmpconfig($idx,separators) w [list $this PrintTrace]
	trace vdelete fx_tmpconfig($idx,width) w [list $this PrintTrace]
	trace vdelete fx_tmpconfig($idx,ascending_descending) w [list $this SortByTrace]
    }
    method PrintSelect {i} {
	global fx_tmpconfig
	
	set current_listbox ${this}_config_print
	foreach j $printconf(enable) {
	    $j configure -state normal
	}
	foreach j $printconf(disable) {
	    $j configure -state disabled
	}
	trace vdelete fx_tmpconfig($idx,ascending_descending) w [list $this SortByTrace]
	trace vdelete fx_tmpconfig($idx,left_right) w [list $this PrintTrace]
	trace vdelete fx_tmpconfig($idx,separators) w [list $this PrintTrace]
	trace vdelete fx_tmpconfig($idx,width) w [list $this PrintTrace]
	set lasti $i
	set leni [llength $i]
	if {$leni > 1} {
	    set row [$current_listbox GetRow [lindex $i 0]]
	} else {
	    set row [$current_listbox GetRow $i]
	}
	if {$leni == 1 && "[string index [lindex $row 1] 0]" == "\$"} {
	    $b_user_edit configure -state normal
	    $b_user_delete configure -state normal
	} else {
	    $b_user_edit configure -state disabled
	    $b_user_delete configure -state disabled
	}
	::set fx_tmpconfig($idx,width) [lindex $row 2]
	set tmpjust [lindex $row 3]
	if {[string compare $tmpjust left] == 0} {
	    ::set fx_tmpconfig($idx,left_right) Left
	} elseif {[string compare $tmpjust right] == 0} {
	    ::set fx_tmpconfig($idx,left_right) Right
	} elseif {[string compare $tmpjust center] == 0} {
	    ::set fx_tmpconfig($idx,left_right) Center
	} else {
	    ::set fx_tmpconfig($idx,left_right) None
	}
	::set fx_tmpconfig($idx,separators) [lindex $row 4]
	trace variable fx_tmpconfig($idx,left_right) w [list $this PrintTrace]
	trace variable fx_tmpconfig($idx,separators) w [list $this PrintTrace]
	trace variable fx_tmpconfig($idx,width) w [list $this PrintTrace]
    }
    method PrintTrace {n1 n2 op} {
	global fx_tmpconfig

	set oldactive [$listbox(${this}_config_print).l2 index active]
	set newn [lindex [split $n2 ,] 1]
	foreach j $lasti {
	    set r [${this}_config_print GetRow $j]
	    switch $newn {
		width {
		    if {[string length $fx_tmpconfig($idx,width)] > 0} {
			set r [lreplace $r 2 2 $fx_tmpconfig($idx,width)]
		    } else {
			set r [lreplace $r 2 2 0]
		    }
		}
		left_right {
		    if {[string compare $fx_tmpconfig($idx,left_right) Left] == 0} {
			set r [lreplace $r 3 3 left]
		    } elseif {[string compare $fx_tmpconfig($idx,left_right) Right] == 0} {
			set r [lreplace $r 3 3 right]
		    } elseif {[string compare $fx_tmpconfig($idx,left_right) Center] == 0} {
			set r [lreplace $r 3 3 center]
		    } else {
			set r [lreplace $r 3 3 none]
		    }
		}
		separators {
		    set r [lreplace $r 4 4 $fx_tmpconfig($idx,separators)]
		}
	    }
	    ${this}_config_print ReplaceRow $j $r
	}
	${this}_config_print CalculateWidths
	${this}_config_print BuildFormats 1
	${this}_config_print Format
	${this}_config_print Display
	foreach i $lasti {
	    $listbox(${this}_config_print).l2 select set $i $i
	}
	$listbox(${this}_config_print).l2 activate $oldactive
    }
    method SortBySelect {i} {
	global fx_tmpconfig

	set current_listbox ${this}_config_sortby
	foreach j $sortbyconf(enable) {
	    $j configure -state normal
	}
	foreach j $sortbyconf(disable) {
	    $j configure -state disabled
	}
	$b_user_edit configure -state disabled
	$b_user_delete configure -state disabled
	if {[llength $i] > 1} {
	    set row [$current_listbox GetRow [lindex $i 0]]
	} else {
	    set row [$current_listbox GetRow $i]
	}
	trace vdelete fx_tmpconfig($idx,ascending_descending) w [list $this SortByTrace]
	if {[string compare [lindex $row 2] yes] == 0} {
	    ::set fx_tmpconfig($idx,ascending_descending) Ascending
	} else {
	    ::set fx_tmpconfig($idx,ascending_descending) Descending
	}
	trace vdelete fx_tmpconfig($idx,left_right) w [list $this PrintTrace]
	trace vdelete fx_tmpconfig($idx,separators) w [list $this PrintTrace]
	trace vdelete fx_tmpconfig($idx,width) w [list $this PrintTrace]
	set lasti $i
	trace variable fx_tmpconfig($idx,ascending_descending) w [list $this SortByTrace]
    }
    method SortByTrace {n1 n2 op} {
	global fx_tmpconfig

	set oldactive [$listbox(${this}_config_sortby).l2 index active]
	foreach j $lasti {
	    set r [${this}_config_sortby GetRow $j]
	    if {[string compare $fx_tmpconfig($idx,ascending_descending) Ascending] == 0} {
		set r [lreplace $r 2 2 yes]
	    } else {
		set r [lreplace $r 2 2 no]
	    }
	    ${this}_config_sortby ReplaceRow $j $r
	}
	${this}_config_sortby CalculateWidths
	${this}_config_sortby BuildFormats 1
	${this}_config_sortby Format
	${this}_config_sortby Display
	foreach i $lasti {
	    $listbox(${this}_config_sortby).l2 select set $i $i
	}
	    $listbox(${this}_config_sortby).l2 activate $oldactive
    }
    method MoveTo {y} {
        $current_listbox MoveTo [$listbox($current_listbox).l2 nearest $y]
	set lasti [$listbox($current_listbox).l2 curselection]
    }
    method MoveUp {} {
	$current_listbox MoveUp
	set lasti [$listbox($current_listbox).l2 curselection]
    }
    method MoveDown {} {
	$current_listbox MoveDown
	set lasti [$listbox($current_listbox).l2 curselection]
    }
    method MoveRight {} {
	if {[string compare $current_listbox ${this}_config_print] != 0} {
	    return
	}
	set l [$listbox(${this}_config_print).l2 curselection]
	set len [llength $l]
	if {$len == 0} {
	    return
	}
	set lsortby [${this}_config_sortby GetContents]
	set nlsortby {}
	foreach j $lsortby {
	    lappend nlsortby [lindex $j 1]
	}
	if {$len > 1} {
	    set r [$current_listbox DeleteRows $l]
	    foreach i $r {
		${this}_config_dontprint AppendRow [lrange [concat $i] 0 1]
		set sortidx [lsearch -exact $nlsortby [lindex [concat $i] 1]]
		if {$sortidx == -1} {
		    puts "search failed for '[lindex [concat $i] 1]'"
		}
		lappend nl $sortidx
	    }
	    set nl [lsort -integer $nl]
	    ${this}_config_sortby DeleteRows $nl
	    ${this}_config_dontprint FastSortContents $attrs
	    ${this}_config_dontprint CalculateWidths
	    ${this}_config_dontprint BuildFormats 1
	    ${this}_config_dontprint Format
	    ${this}_config_dontprint Display
	} else {
	    set r [$current_listbox DeleteRow $l]
	    set sortidx [lsearch -exact $nlsortby [lindex [lindex $r 0] 1]]
	    if {$sortidx == -1} {
		puts "search failed for '[lindex $r 1]'"
		exit 1
	    }
	    ${this}_config_sortby DeleteRow $sortidx
	    eval ${this}_config_dontprint AppendRow [lrange [concat $r] 0 1]
	    ${this}_config_dontprint FastSortContents $attrs
	    ${this}_config_dontprint CalculateWidths
	    ${this}_config_dontprint BuildFormats 1
	    ${this}_config_dontprint Format
	    ${this}_config_dontprint Display
	}
	NoSelect
    }
    method MoveLeft {} {
	if {[string compare $current_listbox ${this}_config_dontprint] != 0} {
	    return
	}
	set l [$listbox(${this}_config_dontprint).l2 curselection]
	set len [llength $l]
	if {$len == 0} {
	    return
	}
	if {$len > 1} {
	    set r [$current_listbox DeleteRows $l]
	    foreach i $r {
		set k $i
		lappend k 0 left " "
		${this}_config_print AppendRow $k
		set k $i
		lappend k yes
		${this}_config_sortby AppendRow $k
	    }
	} else {
	    set r [$current_listbox DeleteRow $l]
	    set k [lindex $r 0]
	    lappend k 0 left " "
	    ${this}_config_print AppendRow $k
	    set k [lindex $r 0]
	    lappend k yes
	    ${this}_config_sortby AppendRow $k
	}
	${this}_config_print CalculateWidths
	${this}_config_print BuildFormats
	${this}_config_print Format
	${this}_config_print Display
	${this}_config_sortby CalculateWidths
	${this}_config_sortby BuildFormats
	${this}_config_sortby Format
	${this}_config_sortby Display
	NoSelect
    }
    method ReadFile {} {
	global fx_tmpconfig fx_blt

	set f [Fx:FileSelect .${this}.readfile r $restrict]
	if {[llength $f] == 0} {return}
	if {[catch [list open $f r] fd] != 0} {
	    fx_dialog .dialog "Error reading file" \
		"$fd  Fix the problem and try again." error 0 OK
	    return
	}
	set r [read $fd]
	close $fd
	if {[llength $r] != 5 || [string compare [qddb_schema leaves $schema] [lindex $r 0]] != 0 \
		|| [string compare $this [lindex $r 1]] != 0} {
	    fx_dialog .dialog "Error reading file" \
		"This file does not appear to be a valid configuration file." error 0 OK
	    return
	}
	if {$fx_blt} {
	    blt_busy hold .$this
	}
	${this}_config_sortby ClearRows
	${this}_config_sortby ClearContents
	${this}_config_sortby AppendRows [lindex $r 2]
	${this}_config_sortby BuildFormats 1
	${this}_config_sortby Format
	${this}_config_sortby Display
	${this}_config_print ClearRows
	${this}_config_print ClearContents
	${this}_config_print AppendRows [lindex $r 3]
	${this}_config_print BuildFormats 1
	${this}_config_print Format
	${this}_config_print Display
	${this}_config_dontprint ClearRows
	${this}_config_dontprint ClearContents
	${this}_config_dontprint AppendRows [lindex $r 4]
	${this}_config_dontprint BuildFormats 1
	${this}_config_dontprint Format
	${this}_config_dontprint Display
	if {$fx_blt} {
	    catch "blt_busy forget .$this"
	}
    }
    method WriteFile {} {
	set f [Fx:FileSelect .${this}.writefile w $restrict]
	if {[llength $f] == 0} {return}
	set r1 [${this}_config_sortby GetContents]
	set r2 [${this}_config_print GetContents]
	set r3 [${this}_config_dontprint GetContents]
	if {[catch [list open $f w] fd] != 0} {
	    fx_dialog .dialog "Error writing file" \
		"$fd  Fix the problem and try again." error 0 OK
	    return
	}
	puts -nonewline $fd [list [qddb_schema leaves $schema] $this $r1 $r2 $r3]
	close $fd
    }
    method SaveConfig {} {
	global fx_config fx_dialog fx_tmpconfig

	# sortby
	# ascending
	set r [${this}_config_sortby GetContents]
	::set fx_config($idx,sortby) {}
	::set fx_config($idx,ascending) {}
	foreach i $r {
	    lappend fx_config($idx,sortby) [lindex $i 1]
	    lappend fx_config($idx,ascending) [lindex $i 2]
	}
	# print
	# widths
	# alignment
	# separators
	set r [${this}_config_print GetContents]
	::set fx_config($idx,print) {}
	::set fx_config($idx,widths) {}
	::set fx_config($idx,alignment) {}
	::set fx_config($idx,separators) {}
	foreach i $r {
	    lappend fx_config($idx,print) [lindex $i 1]
	    lappend fx_config($idx,widths) [lindex $i 2]
	    lappend fx_config($idx,alignment) [lindex $i 3]
	    lappend fx_config($idx,separators) [lindex $i 4]
	}
	set r [${this}_config_dontprint GetContents]
	::set fx_config($idx,dontprint) {}
	foreach i $r {
	    lappend fx_config($idx,dontprint) [lindex $i 1]
	}
	::set fx_config($idx,unsorted) $fx_tmpconfig($idx,unsorted)
	::set fx_config($idx,linenumbers) $fx_tmpconfig($idx,linenumbers)
	::set fx_config($idx,ignore_errors) $fx_tmpconfig($idx,ignore_errors)
	::set fx_config($idx,nextuserdef) $nextuserdef
	::set fx_config($idx,user_defs) {}
	foreach i [array names user_defs] {
	    ::lappend fx_config($idx,user_defs) [list $i $user_defs($i)]
	}
	::set fx_config($idx,attrs) $attrs
	$this delete
	::set fx_dialog($this) ok
    }
    method Quit {} {
	global fx_dialog

	$this delete
	::set fx_dialog($this) cancel
    }

    public schema
    public title "Configuration"
    public idx ""
    public checkattrs 0
    public attrs
    public attr_array
    public max_attrs
    public user_defs
    public restrict ""
    public rw 1

    protected b_user_edit
    protected b_user_delete

    protected nextuserdef 1
    protected nodelete 0
    protected sortbyconf
    protected printconf
    protected dontprintconf
    protected mono 0
    protected current_listbox
    protected listbox
    protected lasti {}
    protected oldfocus
}

itcl_class Fx_LeafConfiguration {
    constructor {config} {
	global fx_tmpconfig fx_config fx_monochrome

	if {[info exists fx_config($idx,type)]} {
	    ::set fx_tmpconfig($idx,type) $fx_config($idx,type)
	} else {
	    ::set fx_tmpconfig($idx,type) Entry
	}
	if {[info exists fx_config($idx,width)]} {
	    ::set fx_tmpconfig($idx,width) $fx_config($idx,width)
	} else {
	    ::set fx_tmpconfig($idx,width) 10
	}
	if {[info exists fx_config($idx,height)]} {
	    ::set fx_tmpconfig($idx,height) $fx_config($idx,height)
	}
	if {[info exists fx_config($idx,default_values)]} {
	    ::set fx_tmpconfig($idx,default_values) $fx_config($idx,default_values)
	}
	if {[info exists fx_config($idx,mandatory)]} {
	    ::set fx_tmpconfig($idx,mandatory) $fx_config($idx,mandatory)
	}
	if {[info exists fx_config($idx,read_only)]} {
	    ::set fx_tmpconfig($idx,read_only) $fx_config($idx,read_only)
	}
	if {[info exists fx_config($idx,unique)]} {
	    ::set fx_tmpconfig($idx,unique) $fx_config($idx,unique)
	} else {
	    ::set fx_tmpconfig($idx,unique) 0
	}
	if {[info exists fx_config($idx,ascending)]} {
	    ::set fx_tmpconfig($idx,ascending) $fx_config($idx,ascending)
	} else {
	    ::set fx_tmpconfig($idx,ascending) yes
	}
	if {[info exists fx_config($idx,unsorted)]} {
	    ::set fx_tmpconfig($idx,unsorted) $fx_config($idx,unsorted)
	} else {
	    ::set fx_tmpconfig($idx,unsorted) 0
	}
	if {[info exists fx_config($idx,linenumbers)]} {
	    ::set fx_tmpconfig($idx,linenumbers) $fx_config($idx,linenumbers)
	} else {
	    ::set fx_tmpconfig($idx,linenumbers) 0
	}
	if {[info exists fx_config(\$regexp_search\$,$idx)]} {
	    ::set fx_tmpconfig(\$regexp_search\$,$idx) $fx_config(\$regexp_search\$,$idx)
	} else {
	    ::set fx_tmpconfig(\$regexp_search\$,$idx) 0
	}
	if {[info exists fx_config(\$numeric_search\$,$idx)]} {
	    ::set fx_tmpconfig(\$numeric_search\$,$idx) $fx_config(\$numeric_search\$,$idx)
	} else {
	    ::set fx_tmpconfig(\$numeric_search\$,$idx) 0
	}
	if {[info exists fx_config(\$date_search\$,$idx)]} {
	    ::set fx_tmpconfig(\$date_search\$,$idx) $fx_config(\$date_search\$,$idx)
	} else {
	    ::set fx_tmpconfig(\$date_search\$,$idx) 0
	}
	if {[info exists fx_config(\$range_search\$,$idx)]} {
	    ::set fx_tmpconfig(\$range_search\$,$idx) $fx_config(\$range_search\$,$idx)
	} else {
	    ::set fx_tmpconfig(\$range_search\$,$idx) 0
	}
	set oldfocus [focus]
	toplevel .$this
	wm title .$this $title
	if {[info exists fx_config(geom,$this)]} {
	    set x [split $fx_config(geom,$this) +]
	    set y [lindex $x 2]
	    set x [lindex $x 1]
	    wm geometry .$this +$x+$y
	}
	set t .$this
	frame $t.f
	pack $t.f -side top -fill both -anchor n -padx 4m -pady 1m
	label $t.f.l -text Options -width 10 -anchor e
	pack $t.f.l -side left -padx 4m
	checkbutton $t.f.mandatory -text Mandatory -variable fx_tmpconfig($idx,mandatory) 
	pack $t.f.mandatory -side left -ipadx 4m -ipady 2m
	checkbutton $t.f.read_only -text "Read-only" -variable fx_tmpconfig($idx,read_only)
	pack $t.f.read_only -side left -ipadx 4m -ipady 2m
	checkbutton $t.f.unique -text Unique -variable fx_tmpconfig($idx,unique)
	pack $t.f.unique -side left -ipadx 4m -ipady 2m

	frame $t.f1
	pack $t.f1 -side top -fill both -anchor n -padx 4m -pady 1m
	label $t.f1.l -text Searching -width 10 -anchor e
	pack $t.f1.l -side left -padx 4m
	checkbutton $t.f1.regexp -text Regexp -variable fx_tmpconfig(\$regexp_search\$,$idx)
	pack $t.f1.regexp -side left -ipadx 4m -ipady 2m
	checkbutton $t.f1.numeric -text Numeric -variable fx_tmpconfig(\$numeric_search\$,$idx)
	pack $t.f1.numeric -side left -ipadx 4m -ipady 2m
	checkbutton $t.f1.date -text Date -variable fx_tmpconfig(\$date_search\$,$idx)
	pack $t.f1.date -side left -ipadx 4m -ipady 2m
	checkbutton $t.f1.range -text Ranges -variable fx_tmpconfig(\$range_search\$,$idx)
	pack $t.f1.range -side left -ipadx 4m -ipady 2m

	if {$expandable} {
	    frame $t.f5
	    pack $t.f5 -side top -fill both -anchor n -padx 4m -pady 1m
	    label $t.f5.l -text Sorting -width 10 -anchor e
	    pack $t.f5.l -side left -padx 4m
	    radiobutton $t.f5.ascending -text Ascending -variable fx_tmpconfig($idx,ascending) -value yes
	    pack $t.f5.ascending -side left -ipadx 4m -ipady 2m
	    radiobutton $t.f5.descending -text Descending -variable fx_tmpconfig($idx,ascending) -value no
	    pack $t.f5.descending -side left -ipadx 4m -ipady 2m
	    checkbutton $t.f5.unsorted -text "Unsorted order" \
		    -variable fx_tmpconfig($idx,unsorted)
	    pack $t.f5.unsorted -side left -ipadx 4m -ipady 2m

	    frame $t.f6
	    pack $t.f6 -side top -fill both -anchor n -padx 4m -pady 1m
	    label $t.f6.l -text Misc -width 10 -anchor e
	    pack $t.f6.l -side left -padx 4m
	    checkbutton $t.f6.linenumbers -text "Print line numbers" \
		    -variable fx_tmpconfig($idx,linenumbers)
	    pack $t.f6.linenumbers -side left -ipadx 4m -ipady 2m
	}

	frame $t.f2
	pack $t.f2 -side top -fill both -anchor n -padx 4m -pady 1m
	set t2 $t.f2
	label $t2.l -text Type
	pack $t2.l -side top -expand on -fill x
	frame $t2.f
	pack $t2.f -side top -fill x -anchor n -padx 4m
	radiobutton $t2.f.r -text Entry -variable fx_tmpconfig($idx,type) \
	    -value Entry -anchor e -anchor w -width 11 \
	    -command "
            $t2.f2.e configure -state disabled
            $t2.f2.e2 configure -state disabled
            $t2.f.e configure -state normal
            focus $t2.f.e
            $t2.f3.e configure -state disabled
        "
	pack $t2.f.r -side left -padx 4m -anchor w
	label $t2.f.l -text Width -anchor e -width 7
	pack $t2.f.l -side left -anchor w
	entry $t2.f.e -textvariable fx_tmpconfig($idx,width) -width 4 -relief sunken -bd 2
	pack $t2.f.e -side left 
	bind $t2.f.e <Return> {break}

	frame $t2.f2
	pack $t2.f2 -side top -fill x -anchor n -padx 4m
	radiobutton $t2.f2.r -text Text -variable fx_tmpconfig($idx,type) \
	    -value Text -anchor e -anchor w -width 11 \
	    -command "
            $t2.f2.e configure -state normal
            $t2.f2.e2 configure -state normal
            focus $t2.f2.e
            $t2.f.e configure -state disabled
            $t2.f3.e configure -state disabled
            $t2.f3.e2 configure -state disabled
            $t2.f3.e3 configure -state disabled
        "
	pack $t2.f2.r -side left -padx 4m -anchor w
	label $t2.f2.l -text Width -anchor e -width 7
	pack $t2.f2.l -side left -anchor w
	entry $t2.f2.e -textvariable fx_tmpconfig($idx,width) -width 4 -relief sunken -bd 2
	pack $t2.f2.e -side left 
	bind $t2.f2.e <Return> {break}
	label $t2.f2.l2 -text Height -anchor e
	pack $t2.f2.l2 -side left -anchor w
	entry $t2.f2.e2 -textvariable fx_tmpconfig($idx,height) -width 4 -relief sunken -bd 2
	pack $t2.f2.e2 -side left 
	bind $t2.f2.e2 <Return> {break}

	frame $t2.f3
	pack $t2.f3 -side top -fill x -anchor n -padx 4m
	radiobutton $t2.f3.r -text Radiobutton -variable fx_tmpconfig($idx,type) \
	    -value Radiobutton -anchor e -anchor w -width 11 \
	    -command "
            $t2.f2.e configure -state disabled
            $t2.f2.e2 configure -state disabled
            $t2.f.e configure -state disabled
            $t2.f3.e configure -state normal
            focus $t2.f3.e
        "
	pack $t2.f3.r -side left -padx 4m -anchor w
	label $t2.f3.l -text Width -anchor e -width 7
	pack $t2.f3.l -side left -anchor w
	entry $t2.f3.e -textvariable fx_tmpconfig($idx,width) -width 4 -relief sunken -bd 2
	pack $t2.f3.e -side left 
	bind $t2.f3.e <Return> {break}
	label $t2.f3.l2 -text Height -anchor e
	pack $t2.f3.l2 -side left -anchor w
	entry $t2.f3.e2 -textvariable fx_tmpconfig($idx,height) -width 4 -relief sunken -bd 2
	pack $t2.f3.e2 -side left 
	bind $t2.f3.e2 <Return> {break}
	label $t2.f3.l3 -text "Values" -anchor e -width 7
	pack $t2.f3.l3 -side left -anchor w
	entry $t2.f3.e3 -textvariable fx_tmpconfig($idx,default_values) -relief sunken -bd 2
	pack $t2.f3.e3 -side left -expand on -fill x
	bind $t2.f3.e3 <Return> {break}
	
	frame $t.f3
	pack $t.f3 -fill x -anchor s -padx 4m -pady 4m
	set b $t.f3
	button $b.ok -text Ok -command [list $this OkProc] -padx 15m -pady 2m
	pack $b.ok -side left -padx 20m -pady 4m
	button $b.cancel -text Cancel -command [list $this CancelProc] -padx 15m -pady 2m
	pack $b.cancel -side right -padx 20m -pady 4m
	bind .$this <Configure> [list $this ConfigureWindow]
    }
    destructor {
	destroy .${this}
	focus $oldfocus
    }
    method ConfigureWindow {} {
	global fx_config
	update idletasks
	update
	::set fx_config(geom,$this) [wm geometry .$this]
    }
    method OkProc {} {
	global fx_config fx_tmpconfig fx_dialog
	
	switch $fx_tmpconfig($idx,type) {
	    Entry {
		if {[catch "expr int($fx_tmpconfig($idx,width))"] != 0} {
		    ::set fx_tmpconfig($idx,width) 10
		    fx_dialog .dialog "Configuration error" "No width specified" error \
			0 Ok
		    return
		}
		::set fx_config($idx,width) $fx_tmpconfig($idx,width)
	    }
	    Text {
		if {[catch "expr int($fx_tmpconfig($idx,width))"] != 0} {
		    ::set fx_tmpconfig($idx,width) 10
		    fx_dialog .dialog "Configuration error" "No width specified" error \
			0 Ok
		    return
		}
		if {[catch "expr int($fx_tmpconfig($idx,height))"] != 0} {
		    ::set fx_tmpconfig($idx,height) 2
		    fx_dialog .dialog "Configuration error" "No height specified" error \
			0 Ok
		    return
		}
		::set fx_config($idx,width) $fx_tmpconfig($idx,width)
		::set fx_config($idx,height) $fx_tmpconfig($idx,height)
	    }
	    Radiobutton {
		if {[string compare [string trim $fx_tmpconfig($idx,default_values)] ""] == 0} {
		    ::set fx_tmpconfig($idx,default_values) none
		    fx_dialog .dialog "Configuration error" "No values specified" error \
			0 Ok
		    return
		}
		if {[catch "expr int($fx_tmpconfig($idx,width))"] != 0} {
		    ::set fx_tmpconfig($idx,width) 10
		    fx_dialog .dialog "Configuration error" "No width specified" error \
			0 Ok
		    return
		}
		if {[catch "expr int($fx_tmpconfig($idx,height))"] != 0} {
		    ::set fx_tmpconfig($idx,height) 2
		    fx_dialog .dialog "Configuration error" "No height specified" error \
			0 Ok
		    return
		}
		::set fx_config($idx,width) $fx_tmpconfig($idx,width)
		::set fx_config($idx,height) $fx_tmpconfig($idx,height)
		::set fx_config($idx,default_values) $fx_tmpconfig($idx,default_values)
	    }
	}
	::set fx_config($idx,mandatory) $fx_tmpconfig($idx,mandatory)
	::set fx_config($idx,read_only) $fx_tmpconfig($idx,read_only)
	if {$fx_tmpconfig($idx,unique)} {
	    ::set fx_config($idx,unique) 1
	} else {
	    catch [list ::unset fx_config($idx,unique)]
	}
	::set fx_config($idx,ascending) $fx_tmpconfig($idx,ascending)
	::set fx_config($idx,unsorted) $fx_tmpconfig($idx,unsorted)
	::set fx_config($idx,linenumbers) $fx_tmpconfig($idx,linenumbers)
	::set fx_config($idx,type) $fx_tmpconfig($idx,type)
	::set fx_dialog($this) ok
	::set fx_config(\$regexp_search\$,$idx) $fx_tmpconfig(\$regexp_search\$,$idx)
	::set fx_config(\$numeric_search\$,$idx) $fx_tmpconfig(\$numeric_search\$,$idx)
	::set fx_config(\$date_search\$,$idx) $fx_tmpconfig(\$date_search\$,$idx)
	::set fx_config(\$range_search\$,$idx) $fx_tmpconfig(\$range_search\$,$idx)
	$this delete
    }
    method CancelProc {} {
	global fx_dialog

	::set fx_dialog($this) cancel
	$this delete
    }
    public schema
    public title
    public idx
    public attr
    public expandable
    protected oldfocus
}

proc Fx:ConfigureSearchResults {schema {restrict ""} {rw 1}} {
    global fx_dialog fx_config fx_blt fx_wait_on_config
    if {[llength [info commands search_results_config]] != 0} {
	if {[info exists fx_config(geom,search_results_config)]} {
	    wm geometry .search_results_config $fx_config(geom,search_results_config)
	}
	wm withdraw .search_results_config
	wm deiconify .search_results_config
	focus .search_results_config
	return
    }
    update
    if {$fx_blt} {
	blt_busy hold .
	update idletasks
    }
    if {[string length $restrict] > 0} {    
	Fx_Configuration search_results_config -schema $schema \
		-title "Search Results Configuration" -idx {$search$} \
		-attrs [qddb_schema leaves $schema] -checkattrs 1 \
		-restrict "$restrict/:search_results:" -rw $rw
    } else {
	Fx_Configuration search_results_config -schema $schema \
		-title "Search Results Configuration" -idx {$search$} \
		-attrs [qddb_schema leaves $schema] -checkattrs 1 -rw $rw
    }
    if {$fx_blt} {
	catch "blt_busy forget ."
    }
    tkwait window .search_results_config
    if {[string compare $fx_dialog(search_results_config) cancel] == 0} {
	return 0
    } else {
	set fx_wait_on_config 1
	return 1
    }
}

proc Fx:ConfigureExpandableAttribute {schema attr {restrict ""}} {
    global fx_dialog fx_config fx_blt

    set a [string tolower $attr]
    set a [split $a .]
    set a [join $a _]
    if {[llength [info commands ${a}_config]] != 0} {
	if {[info exists fx_config(geom,${a}_config)]} {
	    wm geometry .${a}_config $fx_config(geom,${a}_config)
	}
	wm withdraw .${a}_config
	wm deiconify .${a}_config
	focus .${a}_config
	return
    }
    set verb [qddb_schema option verbosename $schema $attr]
    if {[llength $verb] == 0} {
	set verb [split $attr .]
	set verb [lindex $verb [expr [llength $verb] - 1]]
    }
    update
    if {$fx_blt} {
	blt_busy hold .
	update idletasks
    }
    if {[string length $restrict] > 0} {
	Fx_Configuration ${a}_config -schema $schema \
		-title "$verb Configuration" -idx $attr \
		-attrs [qddb_schema leaves $schema $attr] -checkattrs 1 \
		-restrict "$restrict/attr_config/$attr"
    } else {
	Fx_Configuration ${a}_config -schema $schema \
		-title "$verb Configuration" -idx $attr \
		-attrs [qddb_schema leaves $schema $attr] -checkattrs 1
    }
    if {$fx_blt} {
	catch "blt_busy forget ."
    }
    tkwait window .${a}_config
    if {[string compare $fx_dialog(${a}_config) cancel] == 0} {
	return 0
    } else {
	return 1
    }
}

proc Fx:ConfigureLeaf {schema attr {expandable 0}} {
    global fx_dialog fx_config fx_blt

    set a [string tolower $attr]
    set a [split $a .]
    set a [join $a _]
    if {[llength [info commands ${a}_leafconfig]] != 0} {
	if {[info exists fx_config(geom,${a}_leafconfig)]} {
	    wm geometry .${a}_leafconfig $fx_config(geom,${a}_leafconfig)
	}
	wm withdraw .${a}_leafconfig
	wm deiconify .${a}_leafconfig
	focus .${a}_leafconfig
	return
    }
    set verb [qddb_schema option verbosename $schema $attr]
    if {[llength $verb] == 0} {
	set verb [split $attr .]
	set verb [lindex $verb [expr [llength $verb] - 1]]
    }
    update
    if {$fx_blt} {
	blt_busy hold .
	update idletasks
    }
    Fx_LeafConfiguration ${a}_leafconfig -schema $schema \
	-title "$verb Configuration" -idx $attr -expandable $expandable
    if {$fx_blt} {
	catch "blt_busy forget ."
    }
    tkwait window .${a}_leafconfig
    if {[string compare $fx_dialog(${a}_leafconfig) cancel] == 0} {
	return 0
    } else {
	return 1
    }
}

proc Fx:ConfigureEntry {schema attr {restrict ""}} {
    set leaves [qddb_schema leaves $schema $attr]
    if {[llength $leaves] > 1} {
	# if structured: just expandable, otherwise nothing
	if {[qddb_schema option isexpandable $schema $attr]} {
	    return [Fx:ConfigureExpandableAttribute $schema $attr $restrict]
	} else {
	    return 0
	}
    } else {
	if {[qddb_schema option isexpandable $schema $attr]} {
	    return [Fx:ConfigureLeaf $schema $attr 1]
	} else {
	    return [Fx:ConfigureLeaf $schema $attr]
	}
    }
}

