
proc fx_bindnull {w} {
    foreach i [bind Entry] {
	bind $w $i {# nothing}
    }
}


proc fx_bindreal {w} {
    fx_bindnull $w
    bind $w <KeyPress> {
	if {[fx_checkreal %W %A]} {break}
    }
}

proc fx_bindint {w} {
    fx_bindnull $w
    bind $w <KeyPress> {
	if {[fx_checkint %W %A]} {break}
    }
}

proc fx_checkreal {w s} {
    if {$s == ""} {return 0}
    set ns [$w get]
    set ins [$w index insert]
    set ns "[string range $ns 0 $ins]$s[string range $ns [expr $ins + 1] end]"
    if {$ns == "-"} {return 0}
    if {[catch "expr double($ns)"] != 0} {
	bell
	return 1
    }
    return 0
}  

proc fx_checkint {w s} {
    if {$s == ""} {return 0}
    set ns [$w get]
    set ins [$w index insert]
    set ns "[string range $ns 0 $ins]$s[string range $ns [expr $ins + 1] end]"
    if {$ns == "-"} {return 0}
    if {[catch "expr int($ns)"] != 0} {
	bell
	return 1
    }
    return 0
}  

proc Fx:Bindings {} {
    bind Text <Any-KeyPress> {
	if {"%A" != "{}"} {
	    %W insert insert %A
	    set fx_thack(%W) ""
	    %W yview -pickplace insert
	}
    }
    bind Text <Control-o> {+
	set fx_thack(%W) ""
    }
    bind Text <Control-d> {+
	set fx_thack(%W) ""
    }
    bind Text <Control-h> {+
	set fx_thack(%W) ""
    }
    bind Text <BackSpace> {+
	set fx_thack(%W) ""
    }
    bind Text <Key-Delete> {+
        set fx_thack(%W) ""
    }
    bind Text <Control-w> {+
        set fx_thack(%W) ""
    }
    bind Text <Control-y> {+
        set fx_thack(%W) ""
    }
    bind Text <Control-x> {+
        set fx_thack(%W) ""
    }
    bind Text <Control-t> {+
        set fx_thack(%W) ""
    }
    bind Text <Control-k> {
	if [%W compare insert == {insert lineend}] {
	    clipboard append "\n"
	    %W delete insert
	} else {
	    clipboard append [%W get insert {insert lineend}]
	    %W delete insert {insert lineend}
	}
	set fx_thack(%W) ""
    }
    bind Text <Control-u> {
	%W delete {insert linestart} {insert lineend}
    }
    # Tk4.1 changed this, change it back!
    bind Entry <FocusIn> {
	%W icursor end
    }
    bind Entry <Control-k> {
	set t [string range [%W get] [%W index insert] [%W index end]]
	%W delete insert end
        clipboard clear
	clipboard append $t
    }
    bind Entry <Down> {focus [tk_focusNext %W]}
    bind Entry <Up> {focus [tk_focusPrev %W]}
    bind Entry <Control-n> {focus [tk_focusNext %W]}
    bind Entry <Control-p> {focus [tk_focusPrev %W]}
    bind Entry <Control-u> {%W delete 0 end}

    bind Button <Down> {focus [tk_focusNext %W]}
    bind Button <Up> {focus [tk_focusPrev %W]}
    bind Button <Control-n> {focus [tk_focusNext %W]}
    bind Button <Control-p> {focus [tk_focusPrev %W]}

    bind Radiobutton <Down> {focus [tk_focusNext %W]}
    bind Radiobutton <Up> {focus [tk_focusPrev %W]}
    bind Radiobutton <Control-n> {focus [tk_focusNext %W]}
    bind Radiobutton <Control-p> {focus [tk_focusPrev %W]}

    bind Checkbutton <Down> {focus [tk_focusNext %W]}
    bind Checkbutton <Up> {focus [tk_focusPrev %W]}
    bind Checkbutton <Control-n> {focus [tk_focusNext %W]}
    bind Checkbutton <Control-p> {focus [tk_focusPrev %W]}

    bind Scrollbar <Control-n> {focus [tk_focusNext %W]}
    bind Scrollbar <Control-p> {focus [tk_focusPrev %W]}

    bind Text <Tab> {focus [tk_focusNext %W]}
    bind Text <Shift-Tab> {focus [tk_focusPrev %W]}
    tkEntryClipboardKeysyms "Alt-w" "Control-w" "Control-y"
}
