
if {![info exists fx_config(printer)]} {
    set fx_config(header) {}
    set fx_config(footer) {}
    set fx_config(print_heading) {}
    set fx_config(printer_name) {lp}
    set fx_config(dosfile_name) {report.txt}
    set fx_config(unixfile_name) {report.txt}
    # 2 == unix file, 1 == printer, 0 == dosfloppy
    set fx_config(printer) 1
}
if {![info exists fx_config(print_cmd_default)]} {
    set fx_config(print_cmd_default) "| pr | lpr -h"
}
if {![info exists fx_config(print_cmd)]} {
    set fx_config(print_cmd) "| pr | lpr -h -P"
}

itcl_class Fx_PrintDialog {
    constructor {config} {
	global fx_config fx_tmpconfig fx_perform_global_grabs fx_monochrome
	if {[winfo exists .print_dialog]} {
	    if {[info exists fx_config(geom,print_dialog)]} {
		wm geometry .print_dialog $fx_config(geom,print_dialog)
	    }
	    wm withdraw .print_dialog
	    wm deiconify .print_dialog
	    $this delete
	}
	toplevel .print_dialog
	wm title .print_dialog $title
	set p .print_dialog
	label $p.m -text "Select a printer" -relief sunken -bd 2
	if {!$fx_monochrome} {
	    $p.m configure -fg red
	}
	pack $p.m -side top -expand on -fill x
	frame $p.f0 -relief sunken -bd 2
	pack $p.f0 -side top -expand on -fill x
	label $p.f0.l -width 10 -text Heading: -anchor e
	pack $p.f0.l -side left
	entry $p.f0.e -relief sunken -bd 2 -textvariable fx_config(print_heading)
	pack $p.f0.e -side left -expand on -fill x
	frame $p.f -relief sunken -bd 2
	pack $p.f -side top -expand on -fill x
	if {[info exists fx_config(printer)]} {
	    set fx_tmpconfig(printer) $fx_config(printer)
	}
	if {[info exists fx_config(printer_name)]} {
	    set fx_tmpconfig(printer_name) $fx_config(printer_name)
	}
	if {[info exists fx_config(dosfile_name)]} {
	    set fx_tmpconfig(dosfile_name) $fx_config(dosfile_name)
	}
	if {[info exists fx_config(unixfile_name)]} {
	    set fx_tmpconfig(unixfile_name) $fx_config(unixfile_name)
	}
	set fx_tmpconfig(tmp) {}
	radiobutton $p.f.l -text "Printer:" -anchor w -width 10 -variable fx_tmpconfig(printer) -value 1 \
	    -command "
		 $p.f.e configure -state normal
                 $p.f1.e configure -state disabled
                 $p.f3.e configure -state disabled
                 focus $p.f.e
            "
	pack $p.f.l -side left
	entry $p.f.e -textvariable fx_tmpconfig(printer_name)
	pack $p.f.e -side left -expand on -fill x
	frame $p.f1 -relief sunken -bd 2
	pack $p.f1 -side top -expand on -fill x
	radiobutton $p.f1.l -text "DOS (A:):" -anchor w -width 10 -variable fx_tmpconfig(printer) -value 0 \
	    -command "
                 $p.f.e configure -state disabled
		 $p.f1.e configure -state normal
                 $p.f3.e configure -state disabled
                 focus $p.f1.e
            "
	pack $p.f1.l -side left
	entry $p.f1.e -textvariable fx_tmpconfig(dosfile_name)
	pack $p.f1.e -side left -expand on -fill x

	frame $p.f3 -relief sunken -bd 2
	pack $p.f3 -side top -expand on -fill x
	radiobutton $p.f3.l -text "File:" -anchor w -width 10 -variable fx_tmpconfig(printer) -value 2 \
	    -command "
                 $p.f.e configure -state disabled
		 $p.f1.e configure -state disabled
                 $p.f3.e configure -state normal
                 focus $p.f3.e
            "
	pack $p.f3.l -side left
	entry $p.f3.e -textvariable fx_tmpconfig(unixfile_name)
	pack $p.f3.e -side left -expand on -fill x
	if {$fx_tmpconfig(printer) == 1} {
	    $p.f.l invoke
	} elseif {$fx_tmpconfig(printer) == 2} {
	    $p.f3.l invoke
	} else {
	    $p.f1.l invoke
	}
	set ok_cmd "$this SetPrinter; set fx_config(cancel_print) 0; $p.f2.f.ok flash; $this delete"
	bind $p.f.e <Return> $ok_cmd
	bind $p.f1.e <Return> $ok_cmd
	bind $p.f0.e <Return> $ok_cmd
	bind $p.f3.e <Return> $ok_cmd

	frame $p.f2
	pack $p.f2 -side top -padx 5m -pady 5m -expand on -fill x -ipadx 3m -ipady 2m

	frame $p.f2.f -relief sunken -bd 1
	pack $p.f2.f -side left -padx 3m -pady 2m -in $p.f2

	button $p.f2.f.ok -text Ok -command $ok_cmd
	pack $p.f2.f.ok -padx 2m -pady 2m -in $p.f2.f -ipadx 2m -ipady 1m

	button $p.f2.cancel -text Cancel -command "$this delete; set fx_config(cancel_print) 1"
	pack $p.f2.cancel -side right -ipadx 3m -ipady 1m
	wm withdraw .print_dialog
	update idletasks
	if {![info exists fx_config(geom,print_dialog)]} {
	    wm geometry .print_dialog +[expr ([winfo screenwidth .]/2)-([winfo reqwidth .print_dialog]/2)]+[expr ([winfo screenheight .]/2)-([winfo reqheight .print_dialog]/2)]
	}
	wm deiconify .print_dialog
	bind .print_dialog <Configure> [list $this ConfigureWindow]
	if {$fx_perform_global_grabs} {
	    grab -global .print_dialog
	}
	tkwait window .print_dialog
    }
    destructor {
	grab release .print_dialog
	catch {destroy .print_dialog}
    }
    method ConfigureWindow {} {
	global fx_config

	set fx_config(geom,print_dialog) [wm geometry .print_dialog]
    }
    method SetPrinter {} {
	global fx_config fx_tmpconfig

	set fx_config(printer) $fx_tmpconfig(printer)
	set fx_config(printer_name) $fx_tmpconfig(printer_name)
	set fx_config(unixfile_name) $fx_tmpconfig(unixfile_name)
	set fx_config(dosfile_name) $fx_tmpconfig(dosfile_name)
    }
    method configure {config} {
    }
    public title {Printer Selection}
}

proc Fx:Print {{contents ""}} {
    global fx_config
    
    update idletasks
    update
    if {$fx_config(printer) == 1} {
	if {[string length $fx_config(printer_name)] > 0} {
	    set fd [open "$fx_config(print_cmd)$fx_config(printer_name)" w]
	} else {
	    set fd [open "$fx_config(print_cmd_default)" w]
	}
	if {[info exists fx_config(print_heading)]} {
	    set alen [string length [lindex $contents 0]]
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	}
	puts $fd ""
	foreach i $contents {
	    puts $fd $i
	}
	close $fd
    } elseif {$fx_config(printer) == 2} {
	if {[string length $fx_config(unixfile_name)] == 0} {
	    return
	}
	set s [split $fx_config(unixfile_name) /]
	if {[llength $s] > 1} {
	    set dir [join [lrange $s 0 [expr [llength $s] - 2]] /]
	    set file ${dir}/[lindex $s [expr [llength $s] - 1]]
	} else {
	    set file $fx_config(unixfile_name)
	}
	set fd [open $file w]
	if {[info exists fx_config(print_heading)]} {
	    set alen [string length [lindex $contents 0]]
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	}
	foreach i $contents {
	    puts $fd $i
	}
	close $fd
    } else {
	# check out the file name first
	if {[string length $fx_config(dosfile_name)] == 0} {
	    return
	}
	set fd [open "/tmp/qddb_prt.[pid]" w 0400]
	if {[info exists fx_config(print_heading)]} {
	    set alen [string length [lindex $contents 0]]
	    set hlen [string length $fx_config(print_heading)]
	    set alen [expr ($alen - $hlen)/2]
	    set form [format "%%%ds" $alen]
	    set form [format $form " "]
	    puts -nonewline $fd $form
	    puts -nonewline $fd $fx_config(print_heading)
	    puts $fd $form
	}
	foreach i $contents {
	    puts $fd $i
	}
	close $fd
	update idletasks
	update
	while {[catch "exec mcopy -tn /tmp/qddb_prt.[pid] a:$fx_config(printer_name)"] != 0} {
	    set ans [fx_dialog .dialog "Floppy Error" \
			 "Please make sure that an error-free formatted floppy is in drive A:" \
			 error 0 OK Cancel]
	    if {$ans != 0} {
		break
	    }
	}
	catch "exec rm -f /tmp/qddb_prt.[pid]"
    }
    update idletasks
    update
}
