# fx_menu.tcl
#
# Generic menubar and default procedures for Qddb applications


itcl_class Fx_Menubar {
    global fx_config fx_debug

    constructor {config} {
	global fx_debug fx_config $mode_variable $status_variable tk_version
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:change_modeval
	global fx:search_statusval
	global fx_monochrome

	set $mode_variable ${fx:search_modeval}
	set $status_variable ${fx:search_statusval}
	if {![info exists fx_config(auto_clear)]} { 
	    set fx_config(auto_clear) $auto_clear
	}
	if {![info exists fx_config(auto_save)]} { 
	    set fx_config(auto_save) $auto_save
	}
	InitConfig 1
	if {$menubar} {
	    if {![winfo exists $w]} {
		frame $w
		pack $w -side top -expand on -fill x
	    }
	    menubutton $w.file -text File -underline 0 -menu $w.file.menu -padx 1m -pady 1m
	    menu $w.file.menu -postcommand "$this FilePostMenu"
	    $w.file.menu add command -label "Save" \
		-underline 0 -command [list $this SaveProc]
	    $w.file.menu add command -label "Quit" \
		-underline 0 -command [list $this QuitProc]
	    if {[info exists fx_debug] && $fx_debug == 1} {
		$w.file.menu add command -label "DumpConfig" \
		    -underline 0 -command [list $this DumpConfig]
	    }
	    menubutton $w.edit -text Edit -underline 0 -menu $w.edit.menu -padx 1m -pady 1m
	    menu $w.edit.menu -postcommand [list $this EditPostMenu]
	    $w.edit.menu add command -label "Search" \
		-underline 0 -command [list $this SearchProc]
	    $w.edit.menu add separator
	    if {$tk_version < 4.0} {
		$w.edit.menu add command -label "Copy" \
			-accelerator <Alt-W> -command {Fx_Menubar :: CopySelection}
		$w.edit.menu add command -label "Cut" \
			-accelerator <Ctrl-W> -command {Fx_Menubar :: CutSelection}
		$w.edit.menu add command -label "Paste" \
			-accelerator <Ctrl-Y> -command {Fx_Menubar :: PasteCutbuffer}
	    } else {
		$w.edit.menu add command -label "Copy" -accelerator <Alt-W>
		$w.edit.menu add command -label "Cut" -accelerator <Ctrl-W>
		$w.edit.menu add command -label "Paste" -accelerator <Ctrl-Y>
	    }
	}
	if {$tk_version < 4.0} {
	    bind Entry <Alt-w> {Fx_Menubar :: CopySelection}
	    bind Text <Alt-w> {Fx_Menubar :: CopySelection}
	    bind . <Alt-w> {Fx_Menubar :: CopySelection}
	    bind Entry <Control-w> {Fx_Menubar :: CutSelection}
	    bind Entry <Key-Delete> {Fx_Menubar :: CutSelection}
	    set comm {
		global fx_thack

		Fx_Menubar :: CutSelection
		%W yview -pickplace insert
		set fx_thack(%W) ""
	    }
	    bind Text <Control-w> $comm
	    bind Text <Key-Delete> $comm
	    bind . <Control-w> {Fx_Menubar :: CutSelection}
	    bind . <Key-Delete> {Fx_Menubar :: CutSelection}
	    bind Entry <Control-y> {
		Fx_Menubar :: PasteCutbuffer
	    }
	    bind Text <Control-y> {
		global fx_thack
		
		Fx_Menubar :: PasteCutbuffer
		%W yview -pickplace insert
		set fx_thack(%W) ""
	    }
	    bind . <Control-y> {Fx_Menubar :: PasteCutbuffer}
	} else {
	    set comm {+
		global fx_thack
		set fx_thack(%W) ""
	    }
	    bind Text <Control-w> $comm
	    bind Text <Key-Delete> $comm
	    bind Text <Control-y> {+
		global fx_thack
		set fx_thack(%W) ""
	    }
	}
	if {$menubar} {
	    $w.edit.menu add separator
	    $w.edit.menu add command -label "Clear" -underline 0 \
		-command [list $this ClearProc]
	    $w.edit.menu add command -label "Delete" -underline 0 \
		-command [list $this DeleteProc]
	    $w.edit.menu add command -label "Undo" -underline 0 \
		-command [list $this UndoProc]
	    menubutton $w.modes -text "Modes" -underline 0 -menu $w.modes.menu -padx 1m -pady 1m
	    menu $w.modes.menu -postcommand "$this ModesPostMenu"
	    $w.modes.menu add command -label ${fx:search_modeval} -underline 0 \
		-command "$this SearchModeProc"
	    $w.modes.menu add command -label ${fx:add_modeval} -underline 0 \
		-command "$this AddModeProc"
	    $w.modes.menu add command -label ${fx:change_modeval} -underline 0 \
		-command "$this ToChangeModeProc"
	    $w.modes.menu add command -label ${fx:readonly_modeval} -underline 0 \
		-command "$this ReadOnlyModeProc"
	    menubutton $w.view -text "View" -underline 0 -menu $w.view.menu \
		-padx 1m -pady 1m
	    menu $w.view.menu -postcommand [list $this ViewPostMenu]
	    $w.view.menu add command -label "Last Search Results" -underline 0 \
		-command [list $this DisplayLastSearch]
	    menubutton $w.templates -text Templates -underline 0 -menu $w.templates.menu -padx 1m -pady 1m
	    menu $w.templates.menu -postcommand [list $this TemplatesPostMenu]
	    $w.templates.menu add command -label "Read Template" -underline 0 \
		-command [list $this ReadTemplateProc]
	    $w.templates.menu add command -label "Insert Last Template" -underline 0 \
		-command [list $this InsertLastTemplateProc]
	    $w.templates.menu add command -label "Write Template" -underline 0 \
		-command [list $this WriteTemplateProc]
	    menubutton $w.config -text Configure -underline 0 -menu $w.config.menu -padx 1m -pady 1m
	    menu $w.config.menu
	    $w.config.menu add command -label "Save Personal Configuration" -underline 5 \
		-command [list $this SavePersonalConfig]
	    $w.config.menu add command -label "Save Global Configuration" -underline 5 \
		-command [list $this SaveGlobalConfig]
	    $w.config.menu add checkbutton -label "Auto-Save Personal Configuration" -underline 0 \
		-variable fx_config(auto_save)
	    $w.config.menu add separator
	    $w.config.menu add command -label "Search Results" -underline 0 \
		-command [list $this ConfigureSearchResults]
	    $w.config.menu add command -label "Fonts" -underline 0 \
		-command {
		    if {[Fx:ConfigureFonts] == 1} {
			eval [Fx_Menubar :: AfterReconfigure]
		    }
		}
	    $w.config.menu add separator
	    $w.config.menu add cascade -label "Soft Search Limit" -menu $w.config.menu.soft
	    menu $w.config.menu.soft
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 50 -label 50 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 100 -label 100 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 200 -label 200 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 300 -label 300 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 400 -label 400
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 500 -label 500
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) \
		    -value unlimited -label unlimited
	    $w.config.menu add cascade -label "Hard Search Limit" -menu $w.config.menu.hard
	    menu $w.config.menu.hard
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 100 -label 100 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 200 -label 200 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 300 -label 300 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 400 -label 400 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 500 -label 500 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 600 -label 600 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 700 -label 700 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 800 -label 800 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 900 -label 900 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 1000 -label 1000 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) \
		    -value unlimited -label unlimited
	    $w.config.menu add separator
	    $w.config.menu add checkbutton -label "Auto-Clear" -underline 1 \
		-variable fx_config(auto_clear)
	    $w.config.menu add checkbutton -label "Force ${fx:readonly_modeval}" -underline 1 \
		-variable fx_config(force_readonly_mode)
	    menubutton $w.help -text Help -underline 0 -menu $w.help.menu -padx 1m -pady 1m
	    menu $w.help.menu
	    $w.help.menu add command -label "About Qddb" -underline 0 -command Fx:AboutBox
	    $w.help.menu add command -label "Frequently Asked Questions" -underline 0 -command Fx:FAQBox
	    $w.help.menu add command -label "Key Bindings" -underline 0 -command Fx:KeyBindingsHelp
	    pack $w.file $w.edit $w.modes $w.view -side left
	    foreach i $auxbuttons {
		$i configure -padx 1m -pady 1m
		pack $i -in $w -side left
	    }
	    pack $w.help $w.config $w.templates -side right
	    set menu_items [concat $w $w.file $w.edit $w.modes $w.view $auxbuttons $w.templates $w.config $w.help]
	    eval "tk_menuBar $menu_items"
	    tk_bindForTraversal Entry Text .
	}
	set p [winfo p $w]
	if {[string compare $p .] == 0} {
	    set p ""
	}
	selection clear .
	if {$modebar} {
	    label $p.mode_label -relief raised -textvariable $mode_variable
	    if {$tk_version >= 4.0} {
		$p.mode_label configure -justify center
	    }
	    pack $p.mode_label -side top -expand on -fill x
	}
	if {$statusbar} {
	    label $p.status_label -relief raised -textvariable $status_variable
	    if {$tk_version >= 4.0} {
		$p.status_label configure -justify center
	    }
	    pack $p.status_label -side top -expand on -fill x
	}
	if {$searchfor} {
	    frame $p.searchfor
	    pack $p.searchfor -expand on -fill x
	    set t $p.searchfor.label
	    button $t -text "Search for" -relief flat
	    pack $t -side left
	    if {!$fx_monochrome} {
		$p.mode_label configure -fg red
		$p.status_label configure -fg red
		$t configure -fg purple
	    }
	    $t configure -activebackground [lindex [$t configure -background] 4]
	    $t configure -activeforeground [lindex [$t configure -foreground] 4]
	    bind $t <ButtonPress-1> {Fx:nullop}
	    bind $t <ButtonRelease-1> {Fx:nullop}
	    entry $p.searchfor.entry -textvariable $searchfor_variable -relief sunken
	    pack $p.searchfor.entry -side right -expand on -fill x
	    focus $p.searchfor.entry
	    set searchfor_entry $p.searchfor.entry
	    set searchfor_label $t
	}
    }
    destructor {
	destroy $w
    }

    method SaveProc {} {
	global fx_config $status_variable $mode_variable $array fx:add_modeval fx:add_statusval

	if {[info exists beforesave]} {
	    eval $beforesave
	}
	if {[Fx_Attribute :: TupleChanged]} {
	    if {[Fx:CheckMandatoryFields $schema {} $array]} {return}
	    if {[Fx:CurrentUniqueCheck $schema]} {return}
	    if {[Fx:CurrentTypeCheck $schema]} {return}
	} else {
	    set $status_variable "Record has not been modified; save aborted."
	    return
	}
	qddb_tuple write $tuple
	set $status_variable "Record has been saved."
	Fx_Attribute :: TupleChanged 0
	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    if {$fx_config(auto_clear) == 0} {
		if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		    if {$isempty == 0} {
			set added_tuple [qddb_tuple get external $tuple]
		    } else {
			catch {unset added_tuple}
		    }
		}
	    } else {
		catch {unset added_tuple}
	    }
	    AddModeProc
	    incr number_added
	    set $status_variable "Record saved; ${fx:add_statusval} ($number_added added)"
	    update idletasks
	}
	if {[info exists aftersave]} {
	    eval $aftersave
	}
    }
    method QuitProc {} {
	global fx_config $mode_variable
	global fx:add_modeval fx:change_modeval

	if {([string compare [set $mode_variable] ${fx:add_modeval}] == 0 ||
	     [string compare [set $mode_variable] ${fx:change_modeval}] == 0) && \
		[Fx_Attribute :: TupleChanged]} {
	    if {[Fx:CheckMandatoryFields $schema {} $array]} {return}
	    if {[Fx:CurrentUniqueCheck $schema]} {return}
	    if {[Fx:CurrentTypeCheck $schema]} {return}
	}
	if {$fx_config(auto_save)} {
	    SavePersonalConfig
	}
	CheckNeedToSave
	qddb_schema close $schema
	exit 0
    }
    method CheckNeedToSave {} {
	global $status_variable $mode_variable
	global fx:add_modeval fx:change_modeval
	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0 ||
	    [string compare [set $mode_variable] ${fx:change_modeval}] == 0} {
	    if {[Fx_Attribute :: TupleChanged]} {
		set result [fx_dialog .dialog "WARNING" \
				"The current record has been modified.  Would you like to save it?" \
				warning 0 Yes No]
		if {$result == 0} {
		    qddb_tuple write $tuple
		    set $status_variable "Record has been saved."
		    Fx_Attribute :: TupleChanged 0
		}
	    }
	}
    }
    # Edit menu methods
    method SearchProc {} {
	global $searchfor_variable $array $status_variable fx_config fx_blt fx:search_statusval

	if {$fx_blt} {
	    blt_busy hold .
	}
	set $status_variable "Searching..."
	update idletasks
	if {[string length [string trim [set $searchfor_variable]]] > 0} {
	    if {[catch \
		     [list Fx_QddbSearchParser :: MultiSearch $schema [set $searchfor_variable]] \
		     k] != 0} {
		Fx:Dialog "Parse error" $k
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    if {[llength $k] == 0} {
		unset k
	    }
	}
	set search_attrs {}
	foreach i $attrs {
	    if {[string length [string trim [set ${array}($i)]]] > 0} {
		if {[catch \
			 [list Fx_QddbSearchParser :: MultiSearch $schema [set ${array}(${i})] on ${i}] \
			 k1] != 0} {
		    Fx:Dialog "Parse error" $k1
		    if {[info exists k]} {
			qddb_keylist delete $k
		    }
		    if {$fx_blt} {
			blt_busy forget .
		    }
		    return
		}
		lappend search_attrs $i
		if {![info exists k]} {
		    set k $k1
		} else {
		    set k [qddb_keylist op intersection $k $k1]
		}
	    }
	}
	set displayed 0
	if {[info exists k]} {
	    set k2 [qddb_keylist process nullop -copy on -deldup_sameentry on $k]
	    set klen [qddb_keylist length $k2]
	    qddb_keylist delete $k2
	    if {$fx_blt} {
		blt_busy forget .
	    }
	    if {[string compare $fx_config(hard_limit) unlimited] != 0 && $fx_config(hard_limit) < $klen} {
		fx_dialog .dialog "Hard Search Limit Exceeded" \
		    "You have requested to view rows for a total of $klen records.   This number exceeds the current hard limit.  You may not continue." \
		    error 0 Ok
		qddb_keylist delete $k
		set $status_variable ${fx:search_statusval}
		return
	    } elseif {[string compare $fx_config(soft_limit) unlimited] != 0 && \
		    $fx_config(soft_limit) < $klen} {
		if {[fx_dialog .dialog "Soft Search Limit Exceeded" \
			 "You have requested to view rows for a total of $klen records.   This number exceeds the current soft limit.   Do you wish to continue?" \
			 warning 0 No Yes] == 0} {
		    qddb_keylist delete $k
		    set $status_variable ${fx:search_statusval}
		    return
		}
	    }
	    if {$fx_blt} {
		blt_busy hold .
	    }
	    update idletasks
	    update
	    set klen [qddb_keylist length $k]
	    if {$klen > 0} {
		if {[info exists last_search]} {
		    KillLastSearch
		}
		set pa \$search\$,print
		update
		set asc {}
		set x 0
		foreach i $fx_config(\$search\$,ascending) {
		    if {[string compare $i yes] == 0} {
			lappend asc [lindex $fx_config(\$search\$,sortby) $x]
		    }
		    incr x
		}
		set $status_variable "Reading data..."
		update idletasks ; update
		if {[llength $search_attrs] > 0} {
		    if {[info exists fx_config(\$search\$,unsorted)] && \
			    $fx_config(\$search\$,unsorted)} {
			set last_search [qddb_rows select -suppress off -tclelements on \
				-attrs $search_attrs \
				-print $fx_config($pa) $k]
		    } else {
			set last_search [qddb_rows select -suppress off -tclelements on \
				-attrs $search_attrs \
				-ascending $asc -sortby $fx_config(\$search\$,sortby) \
				-print $fx_config($pa) $k]
		    }
		} else {
		    if {[info exists fx_config(\$search\$,unsorted)] && \
			    $fx_config(\$search\$,unsorted)} {
			set last_search [qddb_rows select -suppress off -tclelements on \
				-print $fx_config($pa) $k]
		    } else {
			set last_search [qddb_rows select -suppress off -tclelements on \
				-ascending $asc -sortby $fx_config(\$search\$,sortby) \
				-print $fx_config($pa) $k]
		    }
		}
		set last_search_was_null 0
		qddb_keylist delete $k
		update
		if {[llength $last_search] > 0 && $search_results == 1} {
		    DisplayLastSearch 0
		    set displayed 1
		} else {
		    set $status_variable "No matches found."
		}
	    } else {
		set last_search_was_null 1
		set $status_variable "No matches found."
	    }
	} else {
	    set last_search_was_null 1
	    set $status_variable "No query specified."
	}
	if {$fx_blt && $displayed == 0} {
	    blt_busy forget .
	}
	if {[info exists aftersearch]} {
	    eval $aftersearch
	}
	update idletasks ; update
    }
    method DeleteProc {} {
	eval $beforetupledelete
	catch "qddb_tuple remove $tuple"
	if {[info exists last_search]} {
	    if {[winfo exists .search_results]} {
		catch "search_results delete"
		catch "destroy .search_results.f"
	    }
	    Fx_Attribute :: TupleChanged 0
	    KillLastSearch
	}
	SearchModeProc
    }
    method ClearProc {} {
	global $mode_variable $searchfor_variable $array
	global fx:search_modeval fx:add_modeval

	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    catch [list qddb_tuple delete $tuple]
	    set tuple [qddb_tuple new $schema]
	    set view [qddb_view define $tuple $attr_pairs]
	    $this configure -view $view -tuple $tuple
	    Fx_Attribute :: TupleChanged 0
	} else {
	    if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
		set $searchfor_variable {}
	    }
	    foreach i [array names $array] {
		set ${array}($i) {}
	    }
	}
    }
    method UndoProc {} {
	global fx_config $status_variable $mode_variable
	global fx:readonly_modeval fx:change_modeval fx:change_statusval fx:readonly_statusval
	catch "qddb_tuple refresh $tuple"
	Fx_Attribute :: TupleChanged 0
	if {$fx_config(force_readonly_mode) == 0 && [qddb_tuple lock $tuple]} {
	    Fx_Entry :: EnableReadOnlyWidgets 1
	    Fx_Entry :: DisableReadOnlyWidgets 0
	    set $mode_variable ${fx:change_modeval}
	    set $status_variable ${fx:change_statusval}
	    Fx_Attribute :: TupleChanged 0
	} else {
	    catch [list qddb_tuple unlock $tuple]
	    Fx_Attribute :: DisableAddDeleteButtons
	    Fx_Entry :: DisableReadOnlyWidgets 1
	    set $mode_variable ${fx:readonly_modeval}
	    set $status_variable ${fx:readonly_statusval}
	    Fx_Attribute :: TupleChanged 0
	}
    }
    # Modes menu methods
    method SearchModeProc {} {
	global $mode_variable $status_variable $array fx_config $searchfor_variable fx_blt
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:change_modeval fx:search_statusval
	if {$fx_blt} {
	    blt_busy hold .
	}
	update idletasks
	update
	if {[string compare [set $mode_variable] ${fx:readonly_modeval}] && 
	    [string compare [set $mode_variable] ${fx:search_modeval}] \
		&& [Fx_Attribute :: TupleChanged]} {
	    if {![qddb_tuple isempty $tuple] && [Fx:CheckMandatoryFields $schema {} $array]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    if {[Fx:CurrentUniqueCheck $schema]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    if {[Fx:CurrentTypeCheck $schema]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    CheckNeedToSave
	}
	Fx_Entry :: EnableReadOnlyWidgets 1
	Fx_Entry :: DisableExcludedWidgets
	Fx_Attribute :: DisableButtons
	if {[info exists beforesearchmode]} {
	    eval $beforesearchmode
	}
	catch "qddb_tuple unlock $tuple"
	# Can only get here from Add, Change, Read-only modes
	# If in Change/Read-only mode, don't delete tuple (just view).
	Fx_Attribute :: KillAllViews
	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    if {$fx_config(auto_clear) == 0} {
		if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		    if {$isempty == 0} {
			set added_tuple [qddb_tuple get external $tuple]
		    } else {
			catch {unset added_tuple}
		    }
		}
	    }
	    catch [list qddb_tuple delete $tuple]
	    set tuple {}
	    set view {}
	    $this configure -view $view -tuple $tuple
	} else {
	    catch [list qddb_view delete $view]
	}
	set $mode_variable ${fx:search_modeval}
	set $status_variable ${fx:search_statusval}
	# enable searchfor: box
	if {$searchfor} {
	    $searchfor_label configure -state normal
	    $searchfor_entry configure -state normal
	    focus $searchfor_entry
	}
	bind Entry <Return> [list $this SearchProc]
	if {$fx_config(auto_clear) == 1 || ![info exists searchvar]} {
	    foreach i $textvariables {
		uplevel \#0 [list set $i {}]
	    }
	    set $searchfor_variable {}
	} else {
	    if {[info exists searchvar]} {
		foreach i $textvariables {
		    uplevel \#0 [list set $i $searchvar($i)]
		}
	    }
	}
	Fx_Attribute :: TupleChanged 0
	update idletasks
	update
	if {[info exists aftersearchmode]} {
	    eval $aftersearchmode
	}
	if {$fx_blt} {
	    blt_busy forget .
	}
    }
    method AddModeProc {} {
	global $mode_variable $status_variable $array fx_config $array
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:add_statusval
	global fx_blt

	if {$fx_blt} {
	    blt_busy hold .
	}
	update idletasks
	update
	if {[string compare [set $mode_variable] ${fx:search_modeval}] && \
		[string compare [set $mode_variable] ${fx:readonly_modeval}] \
		&& [Fx_Attribute :: TupleChanged]} {
	    if {[Fx:CheckMandatoryFields $schema {} $array]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    if {[Fx:CurrentUniqueCheck $schema]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    if {[Fx:CurrentTypeCheck $schema]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    CheckNeedToSave
	}
	if {[info exists beforeaddmode]} {
	    eval $beforeaddmode
	}
	Fx_Attribute :: EnableButtons
	Fx_Entry :: EnableReadOnlyWidgets 1
	Fx_Entry :: DisableReadOnlyWidgets 0
	catch "qddb_tuple unlock $tuple"
	Fx_Attribute :: KillAllViews
	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    catch "qddb_tuple delete $tuple"
	}
	if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	    Fx_Entry :: EnableExcludedWidgets
	    foreach i $textvariables {
		set searchvar($i) [set $i]
	    }
	}
	if {$searchfor} {
	    $searchfor_label configure -state disabled
	    $searchfor_entry configure -state disabled
	}
	set $mode_variable ${fx:add_modeval}
	set $status_variable ${fx:add_statusval}
	Fx_Entry :: InitFocus
	bind Entry <Return> { }
	catch [list qddb_view delete $view]
	if {$fx_config(auto_clear) == 1} {
	    catch [list unset added_tuple]
	}
	if {[info exists added_tuple] && $fx_config(auto_clear) == 0} {
	    set tuple [qddb_tuple put external $schema $added_tuple]
	} else {
	    set tuple [qddb_tuple new $schema]
	}
	set view [qddb_view define $tuple $attr_pairs]
	$this configure -view $view -tuple $tuple
	if {[info exists afteraddmode]} {
	    eval $afteraddmode
	}
	Fx_Attribute :: TupleChanged 0
	if {$fx_blt} {
	    blt_busy forget .
	}
    }
    method ChangeModeProc {idx} {
	global $status_variable $mode_variable fx_config fx_blt $array
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:change_modeval fx:change_statusval
	if {$fx_blt} {
	    blt_busy hold .
	}
	update idletasks
	update
	if {[string compare [set $mode_variable] ${fx:search_modeval}] && \
		[string compare [set $mode_variable] ${fx:readonly_modeval}] \
		&& [Fx_Attribute :: TupleChanged]} {
	    if {[Fx:CheckMandatoryFields $schema {} $array]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    if {[Fx:CurrentUniqueCheck $schema]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    if {[Fx:CurrentTypeCheck $schema]} {
		if {$fx_blt} {
		    blt_busy forget .
		}
		return
	    }
	    CheckNeedToSave
	}
	if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0 || \
		[string compare [set $mode_variable] ${fx:readonly_modeval}] == 0} {
	    Fx_Attribute :: EnableButtons
	    Fx_Entry :: EnableReadOnlyWidgets 1
	    Fx_Entry :: DisableReadOnlyWidgets 0
	    Fx_Entry :: EnableExcludedWidgets
	}
	if {[info exists beforechangemode]} {
	    eval $beforechangemode
	}
	catch "qddb_tuple unlock $tuple"
	Fx_Attribute :: KillAllViews
	if {$fx_config(auto_clear) == 0} {
	    if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
		if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		    if {$isempty == 0} {
			set added_tuple [qddb_tuple get external $tuple]
		    } else {
			catch {unset added_tuple}
		    }
		}
		catch [list qddb_tuple delete $tuple]
	    } elseif {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
		foreach i $textvariables {
		    set searchvar($i) [set $i]
		}
	    }
	    catch [list qddb_view delete $view]
	} else {
	    catch [list qddb_view delete $view]
	}
	set $mode_variable ${fx:change_modeval}
	set $status_variable ${fx:change_statusval}
	Fx_Entry :: InitFocus
	if {$searchfor} {
	    $searchfor_label configure -state disabled
	    $searchfor_entry configure -state disabled
	}
	bind Entry <Return> { }
	set myrow [lindex $last_sorted_rows $idx]
	set changemodeidx $idx
	set tuple [qddb_rows tuplename $myrow]
	set view [qddb_view define $myrow $attr_pairs]
	$this configure -view $view -tuple $tuple
	if {[info exists fx_config(force_readonly_mode)] && \
		$fx_config(force_readonly_mode) || [qddb_tuple lock $tuple] == 0} {
	    ReadOnlyModeProc
	}
	Fx_Attribute :: TupleChanged 0
	if {[info exists afterchangemode]} {
	    eval $afterchangemode
	}
	if {$fx_blt} {
	    blt_busy forget .
	}
	update idletasks
	update
    }
    method ToChangeModeProc {} {
	ChangeModeProc $changemodeidx
    }
    method ReadOnlyModeProc {} {
	global $mode_variable $status_variable fx:readonly_modeval fx:readonly_statusval

	if {[info exists beforereadonlymode]} {
	    eval $beforereadonlymode
	}
	catch "qddb_tuple unlock $tuple"
	Fx_Attribute :: DisableAddDeleteButtons
	Fx_Entry :: DisableReadOnlyWidgets 1
	Fx_Entry :: EnableExcludedWidgets
	set $mode_variable ${fx:readonly_modeval}
	set $status_variable ${fx:readonly_statusval}
	update idletasks
	update
	if {[info exists afterreadonlymode]} {
	    eval $afterreadonlymode
	}
    }
    method ReadTemplateProc {} {
	global fx_config

	set t [Fx:FileSelect .readtempl]
	if {[llength $t] > 0} {
	    set fx_config(current_template) $t
	} else {
	    return
	}
	InsertLastTemplateProc
    }
    method InsertLastTemplateProc {} {
	global fx_config $status_variable $mode_variable $array fx:search_modeval

	if {[catch [list Fx:ReadFile $fx_config(current_template)] buf] != 0} {
	    set $status_variable "Cannot read template: $buf"
	    return
	}
	if {[catch [list qddb_tuple put readable $schema $buf] error] != 0} {
	    set $status_variable "$error"
	    return
	} else {
	    if {[string compare $mode_variable ${fx:search_modeval}] == 0} {
		set v [qddb_view define $error {}]
		foreach i [qddb_schema leaves $schema] {
		    set ${array}($i) [qddb_instance getval $v $i]
		}
		qddb_tuple delete $error
	    } else {
		catch [list qddb_tuple delete $tuple]
		set tuple $error
		set view [qddb_view define $tuple $attr_pairs]
		$this configure -view $view -tuple $tuple
		Fx_Attribute :: TupleChanged 0
		set $status_variable "Template successfully read."
	    }
	}
	Fx_Entry :: TupleChanged 1
	update idletasks
    }
    method WriteTemplateProc {} {
	global fx_config $status_variable $mode_variable $array fx:search_modeval

	set t [Fx:FileSelect .writetempl]
	if {[llength $t] > 0} {
	    set fx_config(current_template) $t
	} else {
	    return
	}
	if {[string compare ${fx:search_modeval} [set $mode_variable]] == 0} {
	    set t [qddb_tuple new $schema]
	    set v [qddb_view define $t {}]
	    foreach i [qddb_schema leaves $schema] {
		qddb_instance setval $v $i [set ${array}($i)]
	    }
	    if {[catch [list qddb_tuple get readable $t] buf] != 0} {
		set $status_variable $buf
		qddb_tuple delete $t
		return
	    }
	    qddb_tuple delete $t
	} else {
	    if {[catch [list qddb_tuple get readable $tuple] buf] != 0} {
		set $status_variable $buf
		return
	    }
	}
	if {[catch [list Fx:WriteFile $fx_config(current_template) $buf] error] != 0} {
	    set $status_variable "Cannot write template: $error"
	} else {
	    set $status_variable "Template successfully written."
	}
	update idletasks
    }

    # View menu methods
    method DisplayLastSearch {{do_sort 1}} {
	global fx_config $status_variable fx_blt

	if {[info exists last_search]} {
	    if {$fx_blt} {
		blt_busy hold .
	    }
	    if {[winfo exists .search_results]} {
		catch "search_results delete"
		catch "destroy .search_results"
		update
	    }
	    update idletasks
	    set ls_len [llength $last_search]
	    if {$ls_len == 1} {
		set $status_variable "1 row found..."
		set last_sorted_rows [lindex [lindex $last_search 0] 1]
		ChangeModeProc 0
		return
	    }
	    update idletasks ; update
	    set headings(\$search\$) {}
	    foreach i $fx_config(\$search\$,print) {
		set verb [qddb_schema option verbosename $schema $i]
		if {[llength $verb] == 0} {
		    set verb [split $i .]
		    set verb [lindex $verb [expr [llength $verb] - 1]]
		}
		lappend headings(\$search\$) $verb
	    }
	    update idletasks ; update
	    set x 0
	    foreach i $headings(\$search\$) {
		set maxwid($x) 0
		incr x
	    }
	    set srt {}
	    foreach i $last_search {
		lappend srt [lindex $i 1]
	    }
	    if {$do_sort && (![info exists fx_config(\$search\$,unsorted)] || \
		    $fx_config(\$search\$,unsorted) == 0)} {
		set asc {}
		set x 0
		foreach i $fx_config(\$search\$,ascending) {
		    if {[string compare $i yes] == 0} {
			lappend asc [lindex $fx_config(\$search\$,sortby) $x]
		    }
		    incr x
		}
		update idletasks ; update
		set srt [qddb_rows sort -ascending $asc $fx_config(\$search\$,sortby) $srt]
	    }
	    update idletasks ; update
	    set last_sorted_rows $srt
	    set res {}
	    set restart 1

	    set $status_variable "Formatting..."
	    update idletasks
	    
	    while {$restart} {
		set restart 0
		if {$do_sort == 0} {
		    set old_srt $srt
		    set srt $last_search
		}
		foreach i $srt {
		    if {$do_sort} {
			if {[catch [list qddb_rows getval $fx_config(\$search\$,print) $i] tmp] != 0} {
			    set myspot [lsearch -exact $srt $i]
			    set srt [lreplace $srt $myspot $myspot]
			    set last_sorted_rows $srt
			    set restart 1
			    break
			}
		    } else {
			set tmp [lindex $i 2]
		    }
		    lappend res $tmp
		    set x 0
		    foreach j $tmp {
			set a [string first "\n" $j]
			if {$a == -1} {
			    set slen [string length $j]
			} else {
			    incr a -1
			    set slen $a
			}
			if {$slen > $maxwid($x)} {
			    set maxwid($x) $slen
			}
			incr x
		    }
		}
	    }
	    set ls_len [llength $srt]
	    if {$ls_len == 0} {
		set last_search_was_null 1
		SearchModeProc
		set $status_variable "No matches found."
		return
	    }
	    if {$ls_len == 1} {
		set $status_variable "1 row found..."
		if {$do_sort} {
		    set last_sorted_rows $srt
		} else {
		    set last_sorted_rows $oldsrt
		}
		ChangeModeProc 0
		return
	    }
	    set $status_variable "$ls_len rows found..."
	    update idletasks
	    set x 0
	    foreach i $headings(\$search\$) {
		set slen [string length $i]
		if {$slen > $maxwid($x)} {
		    set maxwid($x) $slen
		}
		incr x
	    }
	    toplevel .search_results
	    wm title .search_results "Search Results"
	    if {[info exists fx_config(geom,search_results)]} {
		wm geometry .search_results $fx_config(geom,search_results)
	    }
	    if {[info exists fx_config(\$search\$,widths)]} {
		set widths2 {}
		for {set i 0} {$i < $x} {incr i} {
		    set tmp [lindex $fx_config(\$search\$,widths) $i]
		    if {$tmp == 0} {
			lappend widths2 $maxwid($i)
		    } else {
			lappend widths2 $tmp
		    }
		}
	    } else {
		set widths2 {}
		for {set i 0} {$i < $x} {incr i} {
		    lappend widths2 $maxwid($i)
		}
	    }
	    set f .search_results.f2
	    frame $f
	    pack $f -side bottom -fill x
	    button $f.select -text Select -command {search_results OnSelect}
	    pack $f.select -side left -padx 10m -pady 2m -ipadx 10m -ipady 2m
	    button $f.cancel -text Close -command \
		    {catch "search_results delete" ; catch "destroy .search_results"}
	    pack $f.cancel -side left -padx 10m -pady 2m -ipadx 10m -ipady 2m
	    button $f.print -text Print -command [list $this PrintLastSearch]
	    pack $f.print -side right -padx 10m -pady 2m -ipadx 10m -ipady 2m
	    checkbutton $f.pin -text Pin -variable fx_config(pin,search_results) -onvalue 1 -offvalue 0
	    pack $f.pin -side right -padx 10m -pady 2m -ipadx 10m -ipady 2m
	    Fx_MultiColumnListBox search_results -w .search_results.f -widths $widths2 \
		-headings $headings(\$search\$) -numcols [llength $headings(\$search\$)] \
		-align $fx_config(\$search\$,alignment) \
		-width 60 \
		-exportselection off \
		-separators $fx_config(\$search\$,separators) \
		-single_select on \
		-height 10 -onselect "$this PinnedSearchResultsProc"
	    search_results AppendRows $res
	    search_results Format
	    search_results Display
	    if {$fx_blt} {
		blt_busy forget .
	    }
	    bind .search_results <FocusIn> {search_results FocusSelect}
	    bind .search_results <Configure> {
		set fx_config(geom,search_results) [wm geometry .search_results]
	    }
	    if {[info exists fx_config(geom,search_results)]} {
		wm geometry .search_results $fx_config(geom,search_results)
	    }
	    tkwait window .search_results.f
	    Fx_Entry :: InitFocus
	    update idletasks
	}
    }
    method PinnedSearchResultsProc {i} {
	global fx_config

	if {![info exists fx_config(pin,search_results)] || $fx_config(pin,search_results) == 0} {
	    catch "destroy .search_results"
	    catch "search_results delete"
	    $this ChangeModeProc $i
	} else {
	    $this ChangeModeProc $i
	    search_results FocusSelect
	}
    }
    method PrintLastSearch {} {
	global fx_config $status_variable fx_blt

	Fx_PrintDialog print_dialog
	if {$fx_config(cancel_print) == 0} {
	    if {$fx_blt} {
		blt_busy hold .
		if {[winfo exists .search_results]} {
		    blt_busy hold .search_results
		}
	    }
	    update idletasks
	    update
	    Fx:Print [search_results GetFormattedContents]
	    if {$fx_blt} {
		blt_busy forget .
		if {[winfo exists .search_results]} {
		    blt_busy forget .search_results
		}
	    }
	    update idletasks
	    update
	} else {
	    set $status_variable "Printing cancelled."
	}
    }
    method KillLastSearch {} {
	global $mode_variable $status_variable $array fx_config
	global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:change_modeval fx:search_statusval

	if {[string compare [set $mode_variable] ${fx:readonly_modeval}] && 
	    [string compare [set $mode_variable] ${fx:search_modeval}] \
		&& [Fx_Attribute :: TupleChanged]} {
	    CheckNeedToSave
	}
	set $status_variable "Killing last search..."
	update idletasks
	if {[info exists last_search]} {
	    foreach i $last_search {
		catch [list qddb_tuple delete [lindex $i 0]]
	    }
	}
	catch {unset last_search}
	if {[winfo exists .search_results]} {
	    catch "search_results delete"
	    catch "destroy .search_results"
	    update
	}
    }

    # Menu posting methods
    method FilePostMenu {} {
	global $mode_variable tk_version fx:search_modeval fx:readonly_modeval

	set m [set $mode_variable]
	if {$tk_version < 4.0} {
	    set fe 0
	} else {
	    ;# Tk4
	    set fe 1
	}
	if {[string compare $m ${fx:search_modeval}] == 0 || \
		[string compare $m ${fx:readonly_modeval}] == 0} {
	    $w.file.menu entryconfigure $fe -state disabled
	} elseif {[Fx_Entry :: TupleChanged] == 0 || [qddb_tuple isempty $tuple] || \
		      [string compare $m ${fx:readonly_modeval}] == 0} {
	    $w.file.menu entryconfigure $fe -state disabled
	} else {
	    $w.file.menu entryconfigure $fe -state normal
	}
	if {[info exists afterpost_file]} {
	    eval $afterpost_file
	}
    }
    method EditPostMenu {} {
	global $mode_variable tk_version
	global fx:search_modeval fx:add_modeval fx:change_modeval

	if {$tk_version < 4.0} {
	    set fe 0
	} else {
	    set fe 1
	}	
	if {[info exists cutbuffer]} {
	    $w.edit.menu entryconfigure [expr $fe + 4] -state normal
	} else {
	    $w.edit.menu entryconfigure [expr $fe + 4] -state disabled
	}
	$w.edit.menu entryconfigure [expr $fe + 2] -state normal
	$w.edit.menu entryconfigure [expr $fe + 3] -state normal
	if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	    $w.edit.menu entryconfigure [expr $fe + 0] -state normal
	    $w.edit.menu entryconfigure [expr $fe + 6] -state normal
	    $w.edit.menu entryconfigure [expr $fe + 7] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 8] -state disabled
	} elseif {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    $w.edit.menu entryconfigure [expr $fe + 0] -state disabled
	    if {[qddb_tuple isempty $tuple]} {
		$w.edit.menu entryconfigure [expr $fe + 6] -state disabled
	    } else {
		$w.edit.menu entryconfigure [expr $fe + 6] -state normal
	    }
	    $w.edit.menu entryconfigure [expr $fe + 7] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 8] -state disabled
	} else {
	    $w.edit.menu entryconfigure [expr $fe + 0] -state disabled
	    $w.edit.menu entryconfigure [expr $fe + 6] -state disabled
	    if {[string compare [set $mode_variable] ${fx:change_modeval}] == 0} {
		$w.edit.menu entryconfigure [expr $fe + 7] -state normal
	    } else {
		$w.edit.menu entryconfigure [expr $fe + 7] -state disabled
	    }
	    $w.edit.menu entryconfigure [expr $fe + 8] -state normal
	}
	if {[info exists afterpost_edit]} {
	    eval $afterpost_edit
	}
    }
    method ModesPostMenu {} {
	global fx_config $mode_variable tk_version
	global fx:search_modeval fx:add_modeval fx:change_modeval

	if {$tk_version < 4.0} {
	    set fe 0
	} else {
	    ;# Tk4
	    set fe 1
	}
	set m [set $mode_variable]
	if {[string compare $m ${fx:search_modeval}] == 0} {
	    $w.modes.menu entryconfigure [expr $fe + 0] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 1] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 3] -state disabled
	} elseif {[string compare $m ${fx:add_modeval}] == 0} {
	    $w.modes.menu entryconfigure [expr $fe + 0] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 1] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 3] -state disabled
	} elseif {[string compare $m ${fx:change_modeval}] == 0} {
	    $w.modes.menu entryconfigure [expr $fe + 0] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 1] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	    $w.modes.menu entryconfigure [expr $fe + 3] -state normal
	} else {
	    $w.modes.menu entryconfigure [expr $fe + 0] -state normal
	    $w.modes.menu entryconfigure [expr $fe + 1] -state normal
	    if {$fx_config(force_readonly_mode)} {
		$w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	    } else {
		$w.modes.menu entryconfigure [expr $fe + 2] -state normal
	    }
	    $w.modes.menu entryconfigure [expr $fe + 3] -state disabled
	}
	if {[info exists afterpost_modes]} {
	    eval $afterpost_modes
	}
    }
    method ViewPostMenu {} {
	global tk_version

	if {$tk_version < 4.0} {
	    set fe 0
	} else {
	    ;# Tk4
	    set fe 1
	}
	if {![info exists last_search] || $search_results == 0} {
	    $w.view.menu entryconfigure [expr $fe + 0] -state disabled
	} else {
	    $w.view.menu entryconfigure [expr $fe + 0] -state normal
	}
	if {[info exists afterpost_view]} {
	    eval $afterpost_view
	}
    }
    method TemplatesPostMenu {} {
	global fx_config $mode_variable tk_version
	global fx:search_modeval fx:add_modeval

	if {$tk_version < 4.0} {
	    set fe 0
	} else {
	    ;# Tk4
	    set fe 1
	}
	set m [set $mode_variable]
	if {[string compare $m ${fx:add_modeval}] == 0 || [string compare $m ${fx:search_modeval}] == 0} {
	    $w.templates.menu entryconfigure [expr $fe + 0] -state normal
	    if {[info exists fx_config(current_template)]} {
		$w.templates.menu entryconfigure [expr $fe + 1] -state normal
	    } else {
		$w.templates.menu entryconfigure [expr $fe + 1] -state disabled
	    }
	    $w.templates.menu entryconfigure [expr $fe + 2] -state normal
	} else {
	    $w.templates.menu entryconfigure [expr $fe + 0] -state disabled
	    $w.templates.menu entryconfigure [expr $fe + 1] -state disabled
	    $w.templates.menu entryconfigure [expr $fe + 2] -state normal
	}
	if {[info exists afterpost_templates]} {
	    eval $afterpost_templates
	}
    }

    # editing procedures
    proc CopySelection {} {
	if {[catch {selection get} sel] == 0} {
	    set cutbuffer $sel
	}
    }
    proc CutSelection {} {
	set selown [selection own]
	if {[string compare $selown ""] != 0} {
	    if {[catch {selection get} sel] == 0} {
		set cutbuffer $sel
		$selown delete sel.first sel.last
	    }
	}
    }
    proc SetCutBuffer {str} {
	set cutbuffer $str
    }
    proc AppendCutBuffer {str} {
	append cutbuffer $str
    }
    proc PasteCutbuffer {} {
	if {![info exists cutbuffer]} {
	    if {[catch {selection get} sel] == 0} {
		set mybuf $sel
	    } else {
		return
	    }
	} else {
	    set mybuf $cutbuffer
	}
	set foc [focus]
	if {[string compare $foc none] != 0} {
	    $foc insert insert $mybuf
	}
    }
    method SearchForEntry {} {
	return $searchfor_entry
    }
    method ConfigureSearchResults {} {
	global fx:search_statusval fx:search_modeval $mode_variable $status_variable $array
	if {[Fx:ConfigureSearchResults $schema] == 1} {
	    if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
		foreach i $textvariables {
		    set searchvar($i) [set $i]
		}
	    }
	    SearchModeProc
	    if {[info exists last_search]} {
		KillLastSearch
	    }
	    set $status_variable ${fx:search_statusval}
	    update idletasks
	}
	InitConfig 0
    }
    method SavePersonalConfig {} {
	global fx_config $status_variable

	set path [qddb_schema path $schema]
	set fn [split $path /]
	set fn [join $fn .]
	set home [glob ~]
	if {![file isdirectory $home/$config_dir]} {
	    while {[catch "exec mkdir $home/$config_dir" msg] != 0} {
		fx_dialog .dialog "ERROR" \
		    "Cannot create directory $home/$config_dir; please remedy the situation and hit OK" \
		    error 0 OK
	    }
	}
	set fd [open $home/$config_dir/$fn "w"]
	foreach i [array names fx_config] {
	    puts $fd [list set fx_config($i) $fx_config($i)]
	}
	SaveOptions $fd
	close $fd
	set $status_variable "Personal configuration saved"
    }
    method SaveOptions {fd} {
	global fx_resources fx_font

	foreach i [array names fx_font] {
	    puts $fd [list set fx_font($i) $fx_font($i)]
	}
	foreach i $fx_resources {
	    set j [split $i .]
	    if {[string compare [lindex $j 1] font] != 0} {
		set val [option get . [lindex $j 1] [lindex $j 0]]
		if {[string compare $val ""] != 0} {
		    puts $fd "option add *$i $val"
		}
	    }
	}
    }
    method SaveGlobalConfig {} {
	global fx_config $status_variable

	set path [qddb_schema path $schema]
	set fd [open $path/$config_dir "w"]
	foreach i [array names fx_config] {
	    puts $fd [list set fx_config($i) $fx_config($i)]
	}
	SaveOptions $fd
	close $fd
	set $status_variable "Global configuration saved"
    }
    # Configuration stuff
    method InitConfig {{load_config 1}} {
	global fx_config fx_font fx_colors

	set pa \$search\$,print
	set dpa \$search\$,dontprint
	if {![info exists fx_config($pa)]} {
	    set fx_config($pa) [lrange [qddb_schema leaves $schema] 0 4]
	    set fx_config($dpa) [lrange [qddb_schema leaves $schema] 5 end]
	}
	set headings(\$search\$) {}
	set tmp $fx_config($pa)
	set len [llength $tmp]
	for {set i 0} {$i < $len} {incr i} {
	    set head [qddb_schema option verbosename $schema [lindex $tmp $i]]
	    if {[llength $head] == 0} {
		lappend headings(\$search\$) [lindex $tmp $i]
	    } else {
		lappend headings(\$search\$) $head
	    }
	}
	set aa \$search\$,alignment
	if {![info exists fx_config($aa)]} {
	    set fx_config($aa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($aa) left
	    }
	}
	set sa \$search\$,separators
	if {![info exists fx_config($sa)]} {
	    set fx_config($sa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($sa) ""
	    }
	}
	set wa \$search\$,widths
	if {![info exists fx_config($wa)]} {
	    set fx_config($wa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($wa) 0
	    }
	}
	set sb \$search\$,sortby
	if {![info exists fx_config($sb)]} {
	    set fx_config(\$search\$,sortby) [qddb_schema leaves $schema]
	}
	set sa \$search\$,ascending
	if {![info exists fx_config($sa)]} {
	    set fx_config($sa) {}
	    foreach i $fx_config(\$search\$,sortby) {
		lappend fx_config($sa) yes
	    }
	}
    }
    method GetLastSearch {} {
	if {[info exists last_search]} {
	    return $last_search
	} else {
	    return {}
	}
    }
    method LastSearchWasNull {} {
	return $last_search_was_null
    }
    method SetLastSearch {l} {
	global fx_config fx_blt

	if {$fx_blt} {
	    blt_busy hold .
	    if {[winfo exists .search_results]} {
		destroy .search_results
	    }
	}
	KillLastSearch
	set last_search $l
	set srt {}
	foreach i $last_search {
	    lappend srt [lindex $i 1]
	}
	set asc {}
	set x 0
	foreach i $fx_config(\$search\$,ascending) {
	    if {[string compare $i yes] == 0} {
		lappend asc [lindex $fx_config(\$search\$,sortby) $x]
	    }
	    incr x
	}
	set srt [qddb_rows sort -ascending $asc $fx_config(\$search\$,sortby) $srt]
	set last_sorted_rows $srt
	if {$fx_blt} {
	    blt_busy forget .
	}
    }
    method configure {config} {
	foreach i $config {
	    switch $i {
		Fx_Menubar::view {
		    [lindex $instances 0] configure -setview $view
		}
		Fx_Menubar::tuple {
		    [lindex $instances 0] configure -settuple $tuple
		}
		Fx_Menubar::instances {
		    set textvariables {}
		    set attr_pairs {}
		    set attrs {}
		    foreach j $instances {
			$j configure -array $array
			lappend textvariables [$j GetTextVariable]
			lappend attr_pairs [$j GetAttrPair]
			lappend attrs [$j GetAttr]
		    }
		}
		Fx_Menubar::frames {
		    foreach j $frames {
			$j configure -array $array
		    }
		}
	    }
	}
    }
    proc AfterReconfigure {{l {}}} {
	if {[llength $l] != 0} {
	    set afterreconfigure $l
	} else {
	    if {[info exists afterreconfigure]} {
		return $afterreconfigure
	    } else {
		return { }
	    }
	}
    }
    if {[info exists fx_debug] && $fx_debug == 1} {
	method DumpConfig {} {
	    global fx_config
	    foreach i [array names fx_config] {
		puts "fx_config(${i}): $fx_config($i)"
	    }
	}
    }

    method GetView {} {
	return $view
    }

    common cutbuffer

    public w
    public auxbuttons {}
    
    public schema
    public tuple {}
    protected searchvar
    protected added_tuple
    public view {}
    public instances
    public frames
    public array gv_attr
    protected attr_pairs
    protected attrs
    protected textvariables
    protected last_search
    protected last_search_was_null 1
    protected last_sorted_rows

    public beforechangemode
    public beforeaddmode
    public beforesearchmode
    public beforereadonlymode
    public afterchangemode
    public afteraddmode
    public aftersearchmode
    public afterreadonlymode
    public beforetupledelete {
	if {[fx_dialog .dialog "RECORD DELETION PENDING" \
		"Are you SURE you want to delete this record?   Click on OK to proceed, Cancel to cancel." \
		 warning 0 Cancel OK] == 0} {
	    return
	}
    }
    public beforesave
    public aftersave
    public aftersearch
    common afterreconfigure
    protected changemodeidx

    # for search results and instance viewing
    protected headings

    public mode_variable fx:mode_variable
    public status_variable fx:status_variable
    public searchfor_variable fx:searchfor_variable

    public config_dir .fx_config
    public searchfor 1
    public statusbar 1
    public modebar 1
    public menubar 1
    public search_results 1

    protected searchfor_entry {}
    protected searchfor_label {}

    # settings
    public auto_clear 0
    public auto_save 0
    public force_readonly_mode 0 {
	global fx_config
	set fx_config(force_readonly_mode) $force_readonly_mode
    }

    protected number_added 0

    public afterpost_file
    public afterpost_edit
    public afterpost_modes
    public afterpost_view
    public afterpost_templates
}

