
itcl_class Fx_MultiColumnListBox {
    constructor {config} {
	global tk_version

	frame $w
	pack $w -side $side -expand on -fill both
	BuildFormats
	scrollbar $w.vs -relief sunken -command [list $w.l2 yview]
	pack $w.vs -side right -fill y
	scrollbar $w.hs -relief sunken -orient horizontal -command [list $this ListboxesXview]
	pack $w.hs -side bottom -fill x
	set wid 0
	if {[info exists widths]} {
	    foreach i $widths {
		if {$i == 0} {
		    incr wid 5
		} else {
		    incr wid $i
		}
		incr wid 2
	    }
	} else {
	    set wid 40
	}
	foreach i $separators {
	    incr wid [string length $i]
	}
	if {$tk_version < 4.0} {
	    listbox $w.l1 -geometry 1x1 -setgrid on -xscroll [list $w.hs set] \
		    -relief sunken
	} else {
	    listbox $w.l1 -width 1 -height 1 -setgrid on -xscroll [list $w.hs set] \
		    -relief sunken	    
	}
	pack $w.l1 -side top -fill x -anchor n
	if {[info exists width] && $width < $wid} {
	    if {$tk_version < 4.0} {
		listbox $w.l2 -geometry ${width}x${height} \
			-setgrid on -yscroll [list $w.vs set] -xscroll [list $w.hs set] \
			-relief sunken -exportselection $exportselection
	    } else {
		listbox $w.l2 -width ${width} -height ${height} \
			-setgrid on -yscroll [list $w.vs set] -xscroll [list $w.hs set] \
			-relief sunken -exportselection $exportselection
	    }
	} else {
	    if {$tk_version < 4.0} {
		listbox $w.l2 -geometry ${wid}x${height} \
			-setgrid on -yscroll [list $w.vs set] -xscroll [list $w.hs set] \
			-relief sunken -exportselection $exportselection
	    } else {
		listbox $w.l2 -width ${wid} -height ${height} \
			-setgrid on -yscroll [list $w.vs set] -xscroll [list $w.hs set] \
			-relief sunken -exportselection $exportselection
	    }
	}
	pack $w.l2 -side top -expand on -fill both -anchor n
	foreach i "$w.l1 $w.l2" {
	    bind $i <2> "$w.l2 scan mark %x %y; $w.l1 scan mark %x 0"
	    bind $i <B2-Motion> "$w.l2 scan dragto %x %y; $w.l1 scan dragto %x 0"
	}
	bind $w.l2 <1> [list $this FocusSelect %y]
	if {[info exists single_select] && [string compare $single_select "on"] == 0} {
	    if {$tk_version < 4.0} {
		tk_listboxSingleSelect $w.l2
	    } else {
		$w.l2 configure -selectmode single
	    }
	} else {
	    if {$tk_version >= 4.0} {
		$w.l2 configure -selectmode extended
	    }
	}
	if {$tk_version < 4.0} {
	    bind $w.l2 <Up> [list $this MoveCursorUp]
	    bind $w.l2 <Down> [list $this MoveCursorDown]
	    bind $w.l2 <ButtonRelease-1> [list $this OnSelect]
	    bind $w.l2 <Return> [list $this OnSelect]
	} else {
	    bind $w.l2 <ButtonRelease-1> "$this OnSelect ; break"
	    bind $w.l2 <Return> "$this OnSelect ; break"
	}
	bind $w.l2 <Configure> [list +$this Reconfigure %h]
	bind $w.l1 <Any-Button> { }
	bind $w.l1 <Any-Motion> { }
    }
    destructor {
	catch [list destroy $w]
    }
    method configure {config} {
    }
    method FocusSelect {{y ""}} {
	global tk_version

	if {[string compare $y ""] != 0} {
	    if {$tk_version < 4.0} {
		$w.l2 select from [$w.l2 nearest $y] 
	    } else {
		$w.l2 select set [$w.l2 nearest $y] 
	    }
	}
	if {[string compare $initselection "on"] == 0} {
	    focus $w.l2
	}
    }
    method Reconfigure {h} {
	set height [expr [$w.l2 nearest $h] - [$w.l2 nearest 0]]
    }
    method MoveCursorUp {} {
	global tk_version

	set sz [$w.l2 size]
	set cur [$w.l2 curselection]
	if {[llength $cur] > 1} {
	    set cur [lindex $cur 0]
	}
	if {$cur > 0} {
	    incr cur -1
	    if {$tk_version < 4.0} {
		$w.l2 select from $cur
		$w.l2 select to $cur
	    } else {
		$w.l2 select set $cur $cur
	    }
	}
	if {$cur < [$w.l2 nearest 0]} {
	    $w.l2 yview $cur
	}
    }
    method MoveCursorDown {} {
	global tk_version

	set sz [$w.l2 size]
	set cur [$w.l2 curselection]
	if {[llength $cur] > 1} {
	    set cur [lindex $cur 0]
	}
	if {$cur < $sz} {
	    incr cur
	    if {$tk_version < 4.0} {
		$w.l2 select from $cur
		$w.l2 select to $cur
	    } else {
		$w.l2 select set $cur $cur
	    }
	}
	if {[expr $cur - [$w.l2 nearest 0]] > $height} {
	    $w.l2 yview [expr $cur - $height]
	}
    }
    method ResetCursor {} {
	set sz [$w.l2 size]
	set cur [$w.l2 curselection]
	if {[llength $cur] > 1} {
	    set cur [lindex $cur 0]
	}
	set spot [expr $cur - [$w.l2 nearest 0]]
	if {$spot > $height} {
	    $w.l2 yview [expr $cur - $height]
	} elseif {$spot < 0} {
	    $w.l2 yview $cur
	}
    }
    method OnSelect {} {
	focus $w.l2
	if {[info exists onselect]} {
	    catch [list eval $onselect [list [$w.l2 curselection]]]
	}
    }
    method ScanXview {x y} {
	$w.l1 scan dragto $x 0
	$w.l2 scan dragto $x $y
    }
    method ListboxesXview {line} {
	$w.l1 xview $line
	$w.l2 xview $line
	update idletasks
    }
    method BuildFormats {{force 0}} {
	# Build the _format string
	set _format_string ""
	if {![info exists widths] || $force} {
	    CalculateWidths
	}
	for {set i 0} {$i < $numcols} {incr i} {
	    if {[info exists align]} {
		if {[string compare [lindex $align $i] "left"] == 0} {
		    set a -
		} else {
		    set a ""
		}
	    } else {
		set a -
	    }
	    if {[info exists separators]} {
		append _format_string [format {%%%s%ds%1s} $a [lindex $widths $i] [lindex $separators $i]]
	    } else {
		append _format_string [format {%%%s%ds } $a [lindex $widths $i]]
	    }
	}
    }
    method CalculateWidths {} {
	for {set j 0} {$j < $numcols} {incr j} {
	    set maxwidth($j) 0
	}
	foreach i $_contents {
	    for {set j 0} {$j < $numcols} {incr j} {
		set str [lindex $i $j]
		set a [string first "\n" $str]
		if {$a == -1} {
		    set len [string length $str]
		} else {
		    incr a -1
		    set len $a
		}
		if {$len > $maxwidth($j)} {
		    set maxwidth($j) $len
		}
	    }
	}
	set j 0
	foreach i $headings {
	    set len [string length $i]
	    if {$len > $maxwidth($j)} {
		set maxwidth($j) $len
	    }
	    incr j
	}
	set widths {}
	for {set j 0} {$j < $numcols} {incr j} {
	    lappend widths $maxwidth($j)
	}
    }

    method AppendRow {values} {
	lappend _contents $values
    }
    method AppendRows {value_list} {
	foreach i $value_list {
	    lappend _contents $i
	}
    }
    method MoveUp {} {
	global tk_version

	set l [$w.l2 curselection]
	if {[string compare $l ""] == 0} {
	    return
	}
	if {[llength $l] > 1} {
	    set first [lindex $l 0]
	    if {$first == 0} {
		return
	    }
	    set last [lindex $l [expr [llength $l] - 1]]
	    incr last -1
	    set r [DeleteRows $l]
	    set spot [expr $first - 1]
	    set _contents [eval linsert [list $_contents] $spot $r]
	    Format
	    eval $w.l2 insert $spot [lrange $_formatted_contents $spot $last]
	    if {$tk_version < 4.0} {
		$w.l2 select from $spot
		$w.l2 select to $last
	    } else {
		$w.l2 select set $spot $last
	    }
	} else {
	    if {$l == 0} {
		return
	    }
	    set r [DeleteRow $l]
	    set spot [expr $l - 1]
	    set _contents [eval linsert [list $_contents] $spot $r]
	    Format
	    eval $w.l2 insert $spot [lrange $_formatted_contents $spot $spot]
	    if {$tk_version < 4.0} {
		$w.l2 select from $spot
		$w.l2 select to $spot
	    } else {
		$w.l2 select set $spot $spot
	    }
	}
	if {$tk_version < 4.0} {
	    ResetCursor
	}
    }
    method MoveDown {} {
	global tk_version

	set l [$w.l2 curselection]
	if {[string compare $l ""] == 0} {
	    return
	}
	if {[llength $l] > 1} {
	    set last [lindex $l [expr [llength $l] - 1]]
	    if {$last == [expr [$w.l2 size] - 1]} {
		return
	    }
	    set first [lindex $l 0]
	    incr last
	    set r [DeleteRows $l]
	    set spot [expr $first + 1]
	    set _contents [eval linsert [list $_contents] $spot $r]
	    Format
	    eval $w.l2 insert $spot [lrange $_formatted_contents $spot $last]
	    if  {$tk_version < 4.0} {
		$w.l2 select from $spot
		$w.l2 select to $last
	    } else {
		$w.l2 select set $spot $last
	    }
	} else {
	    if {$l == [expr [$w.l2 size] - 1]} {
		return
	    }
	    set r [DeleteRow $l]
	    set spot [expr $l + 1]
	    set _contents [eval linsert [list $_contents] $spot $r]
	    Format
	    eval $w.l2 insert $spot [lrange $_formatted_contents $spot $spot]
	    if {$tk_version < 4.0} {
		$w.l2 select from $spot
		$w.l2 select to $spot
	    } else {
		$w.l2 select set $spot $spot
	    }
	}
	if {$tk_version < 4.0} {
	    ResetCursor
	}
    }
    method DeleteRow {l} {
	set retval [lrange $_contents $l $l]
	set _contents [lreplace $_contents $l $l]
	set _formatted_contents [lreplace $_formatted_contents $l $l]
	$w.l2 delete $l
	return $retval
    }
    method DeleteRows {l} {
	set first [lindex $l 0]
	set last [lindex $l [expr [llength $l] - 1]]
	set retval [lrange $_contents $first $last]
	set _contents [lreplace $_contents $first $last]
	set _formatted_contents [lreplace $_formatted_contents $first $last]
	$w.l2 delete $first $last
	return $retval
    }
    method GetRow {i} {
	return [lindex $_contents $i]
    }
    method GetContents {} {
	return $_contents
    }
    method GetFormattedContents {} {
	lappend retval $_formatted_headings
	foreach i $_formatted_contents {
	    lappend retval $i
	}
	return $retval
    }

    proc SortAttrs {attrs a b} {
	set pa [lsearch -exact $attrs [lindex $a 1]]
	set pb [lsearch -exact $attrs [lindex $b 1]]
	if {$pa < $pb} {
	    return -1
	} elseif {$pa > $pb} {
	    return 1
	}
	return 0
    }
    method SortContents {attrs} {
	set _contents [lsort -command [list Fx_MultiColumnListBox :: SortAttrs $attrs] $_contents]
    }
    method ReplaceRow {i r} {
	set _contents [lreplace $_contents $i $i $r]
    }
    method ReplaceAndFormatRow {i r} {
	set _contents [lreplace $_contents $i $i $r]
	$w.l2 delete $i
	FormatRow $i $r
    }
    method FormatRow {i k} {
	if {[info exists widths]} {
	    set x 0
	    foreach j $k {
		set wid [lindex $widths $x]
		set a [string first "\n" $j]
		if {$wid == 0 && $a == -1} {
		    lappend k $j
		} else {
		    incr a -1
		    if {$a < 0} {
			set a [expr $wid - 1]
		    }
		    lappend k [string range $j 0 $a]
		}
		incr x
	    }
	}
	$w.l2 insert $i [eval format [list $_format_string] $k]
    }
    method ClearRows {} {
	set _contents {}
    }
    method Format {} {
	set _formatted_contents {}
	foreach i $_contents {
	    set k {}
	    if {[info exists widths]} {
		set x 0
		foreach j $i {
		    set wid [lindex $widths $x]
		    set a [string first "\n" $j]
		    if {$wid == 0 && $a == -1} {
			lappend k $j
		    } else {
			incr a -1
			if {$a < 0} {
			    set a [expr $wid - 1]
			}
			lappend k [string range $j 0 $a]
		    }
		    incr x
		}
	    } else {
		lappend k $i
	    }
	    lappend _formatted_contents [eval format [list $_format_string] $k]
	}
	set k {}
	if {[info exists widths]} {
	    set x 0
	    foreach i $headings {
		set wid [lindex $widths $x]
		if {$wid == 0} {
		    lappend k $i
		} else {
		    lappend k [string range $i 0 [expr $wid - 1]]
		}
		incr x
	    }
	} else {
	    set k $headings
	}
	set _formatted_headings [eval format [list $_format_string] $k]
    }
    method Display {} {
	global tk_version

	$w.l1 delete 0 end
	$w.l1 insert end $_formatted_headings
	$w.l1 yview 1
	$w.l2 delete 0 end
	foreach i $_formatted_contents {
	    $w.l2 insert end $i
	}
	if {[string compare $initselection "on"] == 0} {
	    focus $w.l2
	    if {$tk_version < 4.0} {
		$w.l2 select from 0
		$w.l2 select to 0
	    } else {
		$w.l2 select set 0 0
	    }
	}
    }
    method ClearContents {} {
	$w.l2 delete 0 end
    }

    public w
    public side top

    protected _contents {}
    protected _formatted_contents {}
    protected _format_string
    protected _formatted_headings {}

    public onselect
    public staticwidth on
    public settings

    public numcols
    public headings
    public align
    public separators
    public widths
    public width
    public height
    public oldfocus
    public single_select
    public initselection on
    public exportselection on
}
option add Tk*Listbox.font -adobe-courier-bold-r-*-*-*-120-*-*-*-*-*-* widgetDefault

