if {$tk_version < 4.0} { # TK4
    if {[string compare [tk colormodel .] monochrome] != 0} {
	set fx_monochrome 0
    } else {
	set fx_monochrome 1
    }
} else {
    if {[winfo screendepth .] >= 8} {
	set fx_monochrome 0
    } else {
	set fx_monochrome 1
    }
}
if {![info exists fx_perform_global_grabs]} {
    set fx_perform_global_grabs 0
}
set fx_font_config(families) {
    charter courier fixed helvetica lucida 
    lucidabright lucidatypewriter {new century schoolbook} 
    times utopia
}
set fx_font_config(slants) {italic oblique roman}
set fx_font_config(weights) {bold demibold medium}
set fx_font_config(sizes) {80 100 140 180 240}
set fx_font_config(sizenames) {tiny small medium large huge}

set fx_font_config(default_size) small
set fx_font_config(default_weight) bold
set fx_font_config(default_slant) roman
set fx_font_config(default_family) courier

proc Fx:LoadPersonalConfig {schema} {
    global fx_config fx_font fx_config_dir

    set path [qddb_schema path $schema]
    set fn [split $path /]
    set fn [join $fn .]
    set home [glob ~]
    if {[file isdirectory $home/$fx_config_dir]} {
	catch "source $home/$fx_config_dir/$fn"
    }
}

proc Fx:LoadGlobalConfig {schema} {
    global fx_config fx_font fx_config_dir

    set path [qddb_schema path $schema]
    catch "source $path/$fx_config_dir"
}

proc Fx:Init {schema} {
    global fx:mode_variable fx_config fx_blt fx_config_dir tk_version
    global fx:search_modeval fx:add_modeval fx:readonly_modeval fx:change_modeval
    global fx:search_statusval fx:add_statusval fx:readonly_statusval fx:change_statusval

    if {![info exists fx_config_dir]} {
	set fx_config_dir .fx_config
    }
    Fx:LoadGlobalConfig $schema
    Fx:LoadPersonalConfig $schema
    Fx:InitResources
    if {$tk_version < 4.0} {
	Fx:Bindings
    }
    Fx:Colors
    set fx:mode_variable {}
    if {![info exists fx_config(soft_limit)]} {
	set fx_config(soft_limit) 200
    }
    if {![info exists fx_config(hard_limit)]} {
	set fx_config(hard_limit) 500
    }
    if {[llength [info commands blt_busy]] > 0} {
	set fx_blt 1
    } else {
	set fx_blt 0
    }
    if {![info exists fx:search_modeval]} {
	set {fx:search_modeval} "Search Mode"
    }
    if {![info exists fx:readonly_modeval]} {
	set {fx:readonly_modeval} "Read-only Mode"
    }
    if {![info exists fx:add_modeval]} {
	set {fx:add_modeval} "Add Mode"
    }
    if {![info exists fx:change_modeval]} {
	set {fx:change_modeval} "Change Mode"
    }
    if {![info exists fx:search_statusval]} {
	set {fx:search_statusval} "Ready to search"
    }
    if {![info exists fx:readonly_statusval]} {
	set {fx:readonly_statusval} "Modifications not allowed"
    }
    if {![info exists fx:add_statusval]} {
	set {fx:add_statusval} "Ready to add new record"
    }
    if {![info exists fx:change_statusval]} {
	set {fx:change_statusval} "Ready to modify record"
    }
}

