
proc Fx:ReadFile {file} {
    catch [list open $file "r"] fd
    if {$fd >= 0} {
	set buf [read $fd]
	close $fd
	return $buf
    } else {
	error $fd
    }
}

proc Fx:WriteFile {file buf} {
    catch [list open $file "w"] fd
    if {$fd >= 0} {
	puts $fd $buf
	close $fd
	return {}
    } else {
	error $fd
    }
}

proc Fx:FileListbox {w name title} {
    frame $w.f$name -bd 2 -relief groove 
    pack $w.f$name -side left -expand on -fill both
    set x $w.f$name
    label $x.l -text $title
    pack $x.l -side top -anchor w -fill x 
    scrollbar $x.vscrollbar -command "$x.listbox yview" -relief raised
    pack $x.vscrollbar -side right -fill y
    listbox $x.listbox -yscroll "$x.vscrollbar set"  \
	    -relief raised -setgrid on
    pack $x.listbox -side left  -expand yes -fill both
    tk_listboxSingleSelect $x.listbox
}

proc Fx:FileCheck {w l e fbox dbox} {
    global tk_version

    set file [$w get [$w curselection]]
    if [file isdirectory $file] {
	$fbox delete 0 end
	$dbox delete 0 end
	cd $file
	foreach i [exec ls -1a] {
	    if [file isdirectory $i] {
		$dbox insert end $i
	    } else {
		$fbox insert end $i
	    }
	}
	if {$tk_version < 4.0} {
	    $w select from 0
	} else {
	    $w select set 0
	}
	$e delete 0 end
	$l configure -text [pwd]
    } else {
	$e delete 0 end
	$e insert 0 $file
    }
}

proc Fx:FileSetDir {w l e fbox dbox file} {
    global tk_version

    if [file isdirectory $file] {
	$fbox delete 0 end
	$dbox delete 0 end
	cd $file
	foreach i [exec ls -1a] {
	    if [file isdirectory $i] {
		$dbox insert end $i
	    } else {
		$fbox insert end $i
	    }
	}
	if {$tk_version < 4.0} {
	    $w select from 0
	} else {
	    $w select set 0	    
	}
	$e delete 0 end
	$l configure -text [pwd]
    }
}

proc Fx:FileSelect {w} {
    global fx_config tk_version

    if {[winfo exists $w]} {
	wm withdraw $w
	wm deiconify $w
	return 0
    }
    set oldfoc [focus]
    set f $w
    toplevel $f
    wm title $f "File Selection"
    if {[info exists fx_config(geom,$w)]} {
	wm geometry $w $fx_config(geom,$w)
    }
    set dir [pwd]
    set whereami [pwd]
    frame $f.but
    pack $f.but -side bottom -fill x
    set x $f.but
    button $x.select -text "Select" -relief raised -bd 2 -command {
	global fx_config
	set fx_config(tmp_file) "s"
    }
    pack $x.select -side left -padx 10m -pady 2m -ipadx 10m -ipady 2m 
    button $x.cancel -text "Cancel" -relief raised -bd 2 -command {
	global fx_config
	set fx_config(tmp_file) {}
    }
    pack $x.cancel -side right -padx 10m -pady 2m -ipadx 10m -ipady 2m

    set v $f.fileboxentries
    frame $v  -bd 2 -relief groove
    pack $v -side top -fill both
    frame $v.path 
    pack $v.path -side top -fill x -expand yes
    label $v.path.l -text "Pathname:"
    label $v.path.v -text [pwd] -relief sunken -anchor w
    pack $v.path.l -side left -anchor w
    pack $v.path.v -side right -anchor w -fill x -expand on
    frame $v.file
    pack $v.file -side top -fill x -expand yes
    label $v.file.l -text "Filename:"
    entry $v.file.v -textvariable filename -relief sunken
    pack $v.file.l -side left -anchor w
    pack $v.file.v -side right -fill x -expand yes
    set filename $dir

    set f2 $f.listbox
    frame $f2
    set fbox $w.listbox.ffiles.listbox
    set dbox $w.listbox.fdirs.listbox
    pack $f2 -side top -fill both -expand yes
    Fx:FileListbox $f2 dirs "Directories:"
    bind $f2.fdirs.listbox <ButtonRelease-1> \
	    [list Fx:FileCheck $dbox $v.path.v $v.file.v $fbox $dbox]
    focus $f2.fdirs.listbox 
    if {$tk_version < 4.0} {
	$f2.fdirs.listbox select from 0
    } else {
	$f2.fdirs.listbox select set 0
    }
    Fx:FileListbox $f2 files "Files:" 
    bind $f2.ffiles.listbox <ButtonRelease-1> \
	    [list Fx:FileCheck $fbox $v.path.v $v.file.v $fbox $dbox]
    focus $f2.ffiles.listbox 
    if {$tk_version < 4.0} {
	$f2.ffiles.listbox select from 0
    } else {
	$f2.ffiles.listbox select set 0
    }

    foreach i [exec ls -1a] {
	if [file isdirectory $i] {
	    $dbox insert end $i
	} else {
	    $fbox insert end $i
	}
    }
    bind $v.file.v <Return> [list set fx_config(tmp_file) "s"]
    focus $v.file.v
    tkwait variable fx_config(tmp_file)
    while {[string length $fx_config(tmp_file)] > 0} {
	set dir [lindex [$w.fileboxentries.path.v configure -text] 4]
	set file [lindex [$w.fileboxentries.file.v configure -text] 4]
	set file [$w.fileboxentries.file.v get]
	if {[file isdirectory $file]} {
	    Fx:FileSetDir $fbox $v.path.v $v.file.v $fbox $dbox $file
	    tkwait variable fx_config(tmp_file)
	} elseif {[string length $file] == 0} {
	    Fx:FileSetDir $fbox $v.path.v $v.file.v $fbox $dbox $dir
	    tkwait variable fx_config(tmp_file)
	} else {
	    set retval $dir/$file
	    break
	}
    } 
    if {[string length $fx_config(tmp_file)] == 0} {
	set retval {}
    }
    focus $oldfoc
    set fx_config(geom,$w) [wm geometry $w]
    destroy $f
    return $retval
}