# fx_widgets.tcl
#
# Fx Toolkit for Qddb widgets


# Fx_Attribute class
itcl::class Fx_Attribute {
    constructor {args} {
	global ::fx_config

	eval configure $args
	if {![info exists attr]} {
	    error "Fx_Attribute: you must specify -attr"
	}
	if {![info exists label]} {
	    set verbosename [qddb_schema option verbosename $schema $attr]
	    if {[string compare $verbosename ""] == 0} {
		set label [split $attr .]
		set label [lindex $label [expr [llength $label] - 1]]
	    } else {
		set label $verbosename
	    }
	}
	set isexpandable [qddb_schema option isexpandable $schema $attr]
	foreach i {label labelfg helpmsg padx pady side} {
	    if {[info exists fx_config(entry,$i,$attr)]} {
		set $i $fx_config(entry,$i,$attr)
	    }
	}
	if {![info exists fx_config($attr,ascending)]} {
	    set leaves [qddb_schema leaves $schema $attr]
	    set fx_config($attr,print) [lrange $leaves 0 4]
	    set fx_config($attr,alignment) {}
	    set fx_config($attr,widths) {}
	    set fx_config($attr,separators) {}
	    foreach i $fx_config($attr,print) {
		lappend fx_config($attr,alignment) left
		lappend fx_config($attr,widths) 0
		lappend fx_config($attr,separators) ""
	    }
	    set fx_config($attr,dontprint) [lrange $leaves 5 end]
	    set fx_config($attr,sortby) $leaves
	    set fx_config($attr,ascending) {}
	    foreach i $fx_config($attr,sortby) {
		lappend fx_config($attr,ascending) yes
	    }
	}
    }
    destructor {
	catch "destroy $w"
    }

    public proc DisableButtons {} {
	if {[info exists buttons]} {
	    foreach i $buttons {
		$i configure -state disabled
	    }
	}
    }
    public proc DisableAddDeleteButtons {} {
	if {[info exists adddeletebuttons]} {
	    foreach i $adddeletebuttons {
		$i configure -state disabled
	    }
	}
    }
    public proc EnableButtons {} {
	if {[info exists buttons]} {
	    foreach i $buttons {
		$i configure -state normal
	    }
	}
    }
    public proc ResetTabbing {type takefocus} {
	foreach i $type {
	    if {[string compare $i scrollbars] == 0} {
		foreach j $scrollbars {
		    $j configure -takefocus $takefocus
		}
	    } else {
		foreach j [set ${i}buttons] {
		    $j configure -takefocus $takefocus
		}
	    }
	}
    }
    public proc TupleChanged {{val ""} {n1 ""} {n2 ""} {op ""}} {
	if {[string length $val] == 0} {
	    return $tuple_changed
	} else {
	    set tuple_changed $val
	}
    }
    public proc KillAllViews {} {
	if {[info exists current_views]} {
	    foreach i [array names current_views] {
		catch "delete object $i"
		catch "destroy .${i}.f"
		catch "unset current_views($i)"
		catch "destroy .$i"
	    }
	    catch "unset current_views"
	}
    }

    method BuildFrame {}
    method AddInstance {{checks 1}}
    method DelInstance {}
    method BuildInst {}
    method ViewInstance {{reconfig 0}}
    method ReconfigureViewsBelow {}
    method ConfigureWindow {transattr}
    method PinnedViewProc {inst i}
    method PrintCmd {contents t}
    method SelectRow {i}
    # Generic Qddb stuff
    common schema
    common view
    common tuple
    common tuple_changed 0
    common current_views
    common restrict_dir {}

    public variable setschema {} {set schema $setschema}
    public variable setview {} {set view $setview}
    public variable settuple {} {set tuple $settuple}
    public variable attr
    public variable copy_instances
    protected variable rowtbl
    protected variable isexpandable
    protected variable verbosename
    public variable restrict {} {set restrict_dir $restrict}

    # On-events
    public variable beforedelete
    public variable beforeadd
    public variable beforechange
    public variable afterdelete
    public variable afteradd
    public variable afterchange
    public variable addtoend 1

    # Label stuff
    public variable label
    public variable labelfg
    public variable helpmsg "No help available for this field"

    public variable array gv_attr

    # Button stuff
    common b_add Add
    common b_view View
    common b_del Del
    public variable showbutton_add 1
    public variable showbutton_del 1
    public variable showbutton_view 1
    public variable button_add $b_add {set b_add $button_add}
    public variable button_view $b_view {set b_view $button_view}
    public variable button_del $b_del {set b_del $button_del}
    common buttons
    common adddeletebuttons
    common addbuttons {}
    common viewbuttons {}
    common delbuttons {}
    common scrollbars {}

    # Frame stuff
    public variable w
    public variable padx 0m
    public variable pady 0m
    public variable side left
    public variable anchor w
    public variable relief flat
    public variable bd 2
    public variable focus none
}

itcl::body Fx_Attribute::BuildFrame {} {
    global ::fx_monochrome ::fx_config

    frame $w -relief $relief -bd $bd
    pack $w -expand on -fill both -padx $padx -pady $pady
    frame $w.f_0
    pack $w.f_0 -side $side -anchor $anchor
    if {$fx_monochrome} {
	set monomode 1
    } else {
	set monomode 0
    }
    label $w.f_0.l -text $label -anchor e
    if {$monomode == 0 && [info exists labelfg]} {
	$w.f_0.l configure -fg $labelfg
    }
    pack $w.f_0.l -side left -anchor ne
    if {[string compare [qddb_schema option isexpandable $schema $attr] yes] == 0} {
	if {$showbutton_add} {
	    if {[string compare [string index $b_add 0] @] == 0} {
		set what bitmap
	    } else {
		set what text
	    }
	    button $w.f_0.b_add -$what $b_add -relief raised -bd 2 -padx 0m -pady 0m \
		    -command [list $this AddInstance] -takefocus $fx_config(\$tabbing\$,add)
	    if {$monomode == 0 && [info exists labelfg]} {
		$w.f_0.b_add configure -fg $labelfg
	    }
	    pack $w.f_0.b_add -side left -anchor ne
	    lappend buttons $w.f_0.b_add
	    lappend adddeletebuttons $w.f_0.b_add
	    lappend addbuttons $w.f_0.b_add
	}
	if {$showbutton_view} {
	    if {[string compare [string index $b_view 0] @] == 0} {
		set what bitmap
	    } else {
		set what text
	    }
	    button $w.f_0.b_view -$what $b_view -relief raised -bd 2 -padx 0m -pady 0m \
		    -command [list $this ViewInstance] -takefocus $fx_config(\$tabbing\$,view)
	    if {$monomode == 0 && [info exists labelfg]} {
		$w.f_0.b_view configure -fg $labelfg
	    }
	    pack $w.f_0.b_view -side left -anchor ne
	    lappend buttons $w.f_0.b_view
	    lappend viewbuttons $w.f_0.b_view
	}
	if {$showbutton_del} {
	    if {[string compare [string index $b_del 0] @] == 0} {
		set what bitmap
	    } else {
		set what text
	    }
	    button $w.f_0.b_del -$what $b_del -relief raised -bd 2 -padx 0m -pady 0m \
		    -command [list $this DelInstance] -takefocus $fx_config(\$tabbing\$,del)
	    if {$monomode == 0 && [info exists labelfg]} {
		$w.f_0.b_del configure -fg $labelfg
	    }
	    pack $w.f_0.b_del -side left -anchor ne
	    lappend buttons $w.f_0.b_del
	    lappend adddeletebuttons $w.f_0.b_del
	    lappend delbuttons $w.f_0.b_del
	}
    }
}


# Fx_Frame class
itcl::class Fx_Frame {
    inherit Fx_Attribute

    constructor {args} {
	eval configure $args
    } {
	lappend instances $this
	BuildFrame
	bind $w.f_0.l <Control-Button-3> [list $this Reconfigure]
    }
    destructor {
    }
    method Reconfigure {}
    public proc GetInstances {} {
	return $instances
    }
    common instances {}
}

itcl::body Fx_Frame::Reconfigure {} {
    Fx:BusyExec . [list Fx:ConfigureEntry $schema $attr $restrict_dir]
}

# Fx_Entry class
itcl::class Fx_Entry {
    inherit Fx_Attribute

    constructor {args} {
	eval Fx_Attribute::constructor $args
    } {
	global ::fx_config

	eval configure $args
	lappend instances $this
	foreach i {entryfg height width default_values type read_only mandatory unique} {
	    if {[info exists fx_config($attr,$i)]} {
		set $i $fx_config($attr,$i)
	    } else {
		if {[info exists $i]} {
		    set fx_config($attr,$i) [set $i]
		}
	    }
	}
	if {[info exists array]} {
	    global ::$array

	    set textvariable ${array}(${attr})
	    set $textvariable ""
	    uplevel \#0 [list trace variable $textvariable w [list ::Fx_Attribute::TupleChanged 1]]
	}
	foreach i {regexp_search range_search numeric_search date_search} {
	    if {![info exists fx_config(\$$i\$,$attr)]} {
		if {[set $i] == 1} {
		    set $i 1
		} else {
		    set $i 0
		}
	    } else {
		set $i $fx_config(\$$i\$,$attr)
	    }
	    set fx_config(\$$i\$,$attr) [set $i]
	}
	BuildFrame
	BuildEntry
	bind $w.f_0.l <Control-Button-3> [list $this Reconfigure]
	if {![info exists firstentry]} {
	    set firstentry $this
	}
	if {[qddb_schema option exclude $schema $attr]} {
	    lappend excluded_entries $w.e
	}
    }
    destructor {
	if {[info exists textvariable]} {
	    global ::$array ::fx_thack

	    uplevel \#0 [list trace vdelete $textvariable w {::Fx_Attribute::TupleChanged 1}]
	    uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
	    uplevel \#0 [list trace vdelete fx_thack($w.e) w [list $this RefreshTextVar]]
	}
    }

    method FormatField {}
    method ResetEntry {}
    method BuildEntry {}
    method ReFocus {}
    method RefreshText {{n1 ""} {n2 ""} {op ""}}
    method RefreshTextVar {{n1 ""} {n2 ""} {op ""}}
    method Reconfigure {}
    method GetAttr {}
    method GetAttrPair {}
    method GetTextVariable {}
    method DisableReadOnly {all}
    method EnableReadOnly {all}
    method GetEntry {}

    public proc GetInstances {} {
	return $instances
    }
    public proc InitFocus {} {
	set foc [$firstentry GetEntry]
	set intfoc($foc) ""
	while {![tkFocusOK $foc]} {
	    set foc [tk_focusNext $foc]
	    if {[info exists intfoc($foc)]} {
		after idle "focus ."
		return
	    } else {
		set intfoc($foc) ""
	    }
	}
	after idle "focus $foc"
    }
    public proc BeforeReconfigure {l} {
	set beforereconfigure $l
    }
    public proc AfterReconfigure {l} {
	set afterreconfigure $l
    }
    public proc ScrollbarSide {s} {
	if {[string compare $s left] != 0 && [string compare $s right] != 0} {
	    puts "Warning: ScrollbarSide $s must be left or right"
	} else {
	    set scrollbarside $s
	}
    }
    public proc EnableExcludedWidgets {} {
	foreach i $excluded_entries {
	    catch [list $i configure -state normal]
	}
    }
    public proc DisableExcludedWidgets {} {
	foreach i $excluded_entries {
	    catch [list $i configure -state disabled]
	}
    }
    public proc EnableReadOnlyWidgets {{all 0}} {
	foreach i $instances {
	    $i EnableReadOnly $all
	}
    }
    public proc DisableReadOnlyWidgets {{all 0}} {
	foreach i $instances {
	    $i DisableReadOnly $all
	}
    }

    common beforereconfigure
    common afterreconfigure
    common scrollbarside left

    public variable array gv_attr {
	if {[info exists textvariable]} {
	    global ::$textvariable
	}
	if {[string compare $type Entry] == 0} {
	    if {[info exists textvariable] && [info exists $textvariable]} {
		uplevel \#0 [list trace vdelete $textvariable w {::Fx_Attribute::TupleChanged 1}]
	    }
	    set textvariable ${array}($attr)
	    catch "$w.e configure -textvariable $textvariable"
	    uplevel \#0 [list trace variable $textvariable w {::Fx_Attribute::TupleChanged 1}]
	} elseif {[string compare $type Radiobutton] == 0} {
	    set x 0
	    if {[info exists textvariable] && [info exists $textvariable]} {
		uplevel \#0 [list trace vdelete $textvariable w {::Fx_Attribute::TupleChanged 1}]
	    }
	    set textvariable ${array}($attr)
	    while {[catch "$w.e.t.r$x configure -variable $textvariable"] == 0} {
		incr x
	    }
	    uplevel \#0 [list trace variable $textvariable w {::Fx_Attribute::TupleChanged 1}]
	} else {
	    if {[info exists textvariable] && [info exists $textvariable]} {
		uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
	    }
	    set textvariable ${array}($attr)
	    uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
	    set $textvariable {}
	    uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
	}
    }

    # Entry stuff
    public variable entryfg
    public variable height 1
    public variable width 15 {
	global ::fx_config
	switch $type {
	    Entry {
		if {[winfo exists $w.e]} {
		    $w.e configure -width $width
		}
		if {[info exists attr]} {
		    set fx_config($attr,width) $width
		}
	    }
	    Text {
		if {[winfo exists $w.e]} {
		    $w.e configure -width $width
		}
		if {[info exists attr]} {
		    set fx_config($attr,width) $width
		}
	    }
	    Radiobutton {
		if {[winfo exists $w.e]} {
		    $w.e.t configure -width $width
		}
		if {[info exists attr]} {
		    set fx_config($attr,width) $width
		}
	    }
	}
    }
    protected variable textvariable
    
    public variable regexp_search 1 {
	global fx_config
	set fx_config(\$regexp_search\$,$attr) $regexp_search
    }
    public variable range_search 1 {
	global fx_config
	set fx_config(\$range_search\$,$attr) $range_search
    }
    public variable numeric_search 1 {
	global fx_config
	set fx_config(\$numeric_search\$,$attr) $numeric_search
    }
    public variable date_search 1 {
	global fx_config
	set fx_config(\$date_search\$,$attr) $date_search
    }

    # Generic stuff
    public variable type Entry
    public variable default_values {}
    public variable read_only 0 ResetEntry
    public variable mandatory
    public variable unique

    public variable userconfig 1

    # Array of entries for tabbing
    public variable searchfor_entry {} {set common_searchfor_entry $searchfor_entry}
    common common_searchfor_entry
    common firstentry
    common instances
    common excluded_entries {}
}

itcl::body Fx_Entry::ResetEntry {} {
    global ::fx:mode_variable ::fx:search_modeval

    if {[winfo exists $w] && [winfo exists $w.e]} {
	switch $type {
	    Radiobutton {
		if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
			[info exists read_only] && $read_only == 1} {
		    set x 0
		    while {[catch "$w.e.t.r$x configure -state disabled"] == 0} {
			incr x
		    }
		} else {
		    set x 0
		    while {[catch "$w.e.t.r$x configure -state normal"] == 0} {
			incr x
		    }
		}
	    }
	    Entry {
		if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
			[info exists read_only] && $read_only == 1} {
		    $w.e configure -state disabled
		} else {
		    $w.e configure -state normal
		}
	    }
	    Text {
		if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
			[info exists read_only] && $read_only == 1} {
		    $w.e configure -state disabled
		} else {
		    $w.e configure -state normal
		}
	    }
	}
    }
}

itcl::body Fx_Entry::BuildEntry {} {
    global ::$array ::fx_thack ::fx_config ::fx_monochrome \
	    ::fx:mode_variable ::fx:search_modeval

    if {[info exists beforereconfigure]} {
	eval $beforereconfigure
    }
    foreach i {height width default_values type read_only mandatory unique} {
	if {[info exists fx_config($attr,$i)]} {
	    set $i $fx_config($attr,$i)
	}
    }
    if {[winfo exists $w.e]} {
	destroy $w.e
	if {[winfo exists $w.s]} {
	    destroy $w.s
	}
	if {[info exists textvariable]} {
	    uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
	    uplevel \#0 [list trace vdelete fx_thack($w.e) w [list $this RefreshTextVar]]
	}
    }
    switch $type {
	Entry {
	    entry $w.e -relief sunken -bd 2 -width $width 
	    if {[info exists entryfg]} {
		$w.e configure -fg $entryfg
	    }
	    if {[info exists textvariable]} {
		$w.e configure -textvariable $textvariable 
	    }
	    pack $w.e -side right -expand on -fill x -anchor nw
	    if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
		    [info exists read_only] && $read_only == 1} {
		$w.e configure -state disabled
	    }
	    if {[info exists mandatory] && $mandatory == 1 && \
		    $fx_monochrome == 0} {
		$w.e configure -bg $fx_config(mandatory_field_bg)
	    }
	    bind $w.e <FocusIn> "$this ReFocus"
	    bind $w.e <FocusOut> [list +$this FormatField]
	    bind $w.e <Return> [list $this FormatField]
	    set sr [lsearch -exact $scrollbars $w.s]
	    if {$sr != -1} {
		lreplace $scrollbars $sr $sr
	    }
	    set sr [lsearch -exact $scrollbars $w.e.s]
	    if {$sr != -1} {
		lreplace $scrollbars $sr $sr
	    }
	}
	Text {
	    scrollbar $w.s -relief sunken -command [list $w.e yview] \
		    -takefocus $fx_config(\$tabbing\$,scrollbars)
	    pack $w.s -side $scrollbarside -fill y
	    lappend scrollbars $w.s
	    text $w.e -relief sunken -bd 2 -height $height -width $width \
		    -yscroll [list $w.s set]
	    if {[info exists entryfg]} {
		$w.e configure -fg $entryfg
	    }
	    if {[info exists textvariable]} {
		$w.e insert 0.0 [set $textvariable]
		uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
		uplevel \#0 [list trace variable fx_thack($w.e) w [list $this RefreshTextVar]]
	    }
	    pack $w.e -side right -expand on -fill both
	    if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
		    [info exists read_only] && $read_only == 1} {
		$w.e configure -state disabled
	    }
	    if {[info exists mandatory] && $mandatory == 1 && \
		    $fx_monochrome == 0} {
		$w.e configure -bg $fx_config(mandatory_field_bg)
	    }
	    set sr [lsearch -exact $scrollbars $w.e.s]
	    if {$sr != -1} {
		lreplace $scrollbars $sr $sr
	    }
	}
	Radiobutton {
	    if {![info exists default_values]} {
		entry $w.e -relief sunken -bd 2 -width $width 
		if {[info exists entryfg]} {
		    $w.e configure -fg $entryfg
		}
		if {[info exists textvariable]} {
		    $w.e configure -textvariable $textvariable 
		}
		break
	    }
	    frame $w.e -relief sunken -bd 0 -highlightthickness 0 -takefocus 0
	    if {$height > 1} {
		scrollbar $w.e.s -relief sunken -command [list $w.e.t yview] \
			-takefocus $fx_config(\$tabbing\$,scrollbars)
		pack $w.e.s -side $scrollbarside -fill y
		lappend scrollbars $w.e.s
		text $w.e.t -relief sunken -bd 2 -height $height -width $width -state disabled \
			-yscroll [list $w.e.s set] -highlightthickness 0 -takefocus 0
	    } else {
		frame $w.e.t -relief sunken -bd 2 -highlightthickness 0 -takefocus 0
	    }
	    set x 0
	    set row 0
	    foreach i $default_values {
		radiobutton $w.e.t.r$x -value $i -text $i -relief flat \
			-variable $textvariable -padx 0m -pady 0m
		if {[info exists entryfg]} {
		    $w.e.t.r$x configure -fg $entryfg
		}
		pack $w.e.t.r$x -side left -expand on -fill x
		bind $w.e.t.r$x <Button-3> {%W deselect; break}
		bind $w.e.t.r$x <Shift-space> {%W deselect; break}
		bind $w.e.t.r$x <Shift-Return> {%W deselect; break}
		if {[info exists mandatory] && $mandatory == 1 && \
			$fx_monochrome == 0} {
		    $w.e.t.r$x configure -bg $fx_config(mandatory_field_bg)
		}
		if {$height > 1} {
		    $w.e.t window create {end - 1 chars} -window $w.e.t.r$x
		}
		incr x
	    }
	    pack $w.e.t -side top -expand on -fill both
	    pack $w.e -side right -expand on -fill both
	    if {$height == 1} {
		set sr [lsearch -exact $scrollbars $w.s]
		if {$sr != -1} {
		    lreplace $scrollbars $sr $sr
		}
	    }
	}
    }
    set focus $w.e
    if {[info exists afterreconfigure]} {
	eval $afterreconfigure
    }
}
itcl::body Fx_Entry::Reconfigure {} {
    global ::fx_config

    if {$userconfig && [Fx:BusyExec . [list Fx:ConfigureEntry $schema $attr $restrict_dir]] == 1} {
	BuildEntry
    }
}
itcl::body Fx_Entry::GetEntry {} {
    return $w.e
}
itcl::body Fx_Entry::GetTextVariable {} {
    return $textvariable
}
itcl::body Fx_Entry::GetAttr {} {
    return $attr
}
itcl::body Fx_Entry::GetAttrPair {} {
    return [list $attr $textvariable]
}
itcl::body Fx_Entry::EnableReadOnly {all} {
    if {$all || ([info exists read_only] && $read_only == 1)} {
	if {[string compare $type Radiobutton] == 0} {
	    set x 0
	    foreach i $default_values {
		$w.e.t.r$x configure -state normal
		incr x
	    }
	} else {
	    $w.e configure -state normal
	}
    }
}
itcl::body Fx_Entry::DisableReadOnly {all} {
    if {$all || ([info exists read_only] && $read_only == 1)} {
	if {[string compare $type Radiobutton] == 0} {
	    set x 0
	    foreach i $default_values {
		$w.e.t.r$x configure -state disabled
		incr x
	    }
	} else {
	    $w.e configure -state disabled
	}
    }
}
itcl::body Fx_Entry::RefreshText {{n1 ""} {n2 ""} {op ""}} {
    global ::$array

    $w.e configure -state normal
    if {[string compare $op u] == 0} {
	$w.e delete 0.0 end
    } else {
	set i [$w.e index insert]
	$w.e delete 0.0 end
	set var [uplevel \#0 [list set $textvariable]]
	$w.e insert 0.0 $var
	$w.e mark set insert $i
	$w.e yview -pickplace insert
    }
    if {[info exists read_only] && $read_only == 1} {
	$w.e configure -state disabled
    }
}

if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_widgets.tcl"
}
