itcl::body Fx_Attribute::BuildInst {} {
    set namelist [split $attr "."]
    set len [llength $namelist]
    incr len -1
    set buildinst ""
    for {set i 0} {$i < $len} {incr i} {
	if {$i == 0} {
	    set attribute [lindex $namelist 0]
	} else {
	    set attribute [join [lrange $namelist 0 $i] "."]
	}
	set cur [qddb_instance current $view $attribute]
	if {[string compare $buildinst ""] != 0} {
	    set buildinst [join [list $buildinst $cur] "."]
	} else {
	    set buildinst $cur
	}
    }
    return [join [list $attr $buildinst] ","]
}
itcl::body Fx_Attribute::AddInstance {{checks 1}} {
    global ::$array

    if {$checks && [Fx:CheckMandatoryFields $schema $attr $array]} {
	return
    }
    if {$checks && [Fx:CurrentTypeCheck $schema] || [Fx:CurrentUniqueCheck $schema]} {
	return
    }
    if {[info exists beforeadd]} {
	eval $beforeadd
    }
    if {[info exists copy_instances]} {
	set leaves [qddb_schema leaves $schema $attr]
	if {[llength $leaves] > 1} {
	    set leaves $copy_instances
	} elseif {$copy_instances == 0} {
	    set leaves {}
	}
	foreach i $leaves {
	    set leaftmp($i) [set ${array}($i)]
	}
    }
    if {$addtoend} {
	set newinst [qddb_instance new $view $attr]
	qddb_instance switch $view $attr $newinst
    } else {
	set newinst [qddb_instance new $view $attr]
	qddb_instance move $view $attr $newinst 1
	qddb_instance switch $view $attr 1
    }
    if {[info exists copy_instances]} {
	foreach i $leaves {
	    uplevel \#0 [list set ${array}($i) $leaftmp($i)]
	}
    }
    if {$checks} {
	after idle [list catch [list focus $focus]]
    }
    if {[info exists afteradd]} {
	eval $afteradd
    }
    set transattr [split $attr .]
    set transattr [string tolower [join $transattr _]]
    if {[winfo exists .view_$transattr]} {
	ViewInstance 1
    }
    ReconfigureViewsBelow
    TupleChanged 1
}
itcl::body Fx_Attribute::DelInstance {} {
    global ::$array

    if {[fx_dialog .dialog "Deleting Instance" "Are you sure you want to delete?" \
	    warning 0 Cancel Ok] == 0} {
	return
    }
    if {[info exists beforedelete]} {
	eval $beforedelete
    }
    set curnum [qddb_instance current $view $attr]
    if {[qddb_instance isempty $view $attr $curnum] == 0 || [qddb_instance maxnum $view $attr] > 1} {
	qddb_instance remove $view $attr $curnum
	if {[info exists afterdelete]} {
	    eval $afterdelete
	}
	set transattr [split $attr .]
	set transattr [string tolower [join $transattr _]]
	if {[winfo exists .view_$transattr]} {
	    ViewInstance 1
	}
	ReconfigureViewsBelow
	TupleChanged 1
    }
    after idle [list catch [list focus $focus]]
}
itcl::body Fx_Attribute::ViewInstance {{reconfig 0}} {
    global ::fx_config ::fx_blt

    if {[Fx:CheckMandatoryFields $schema $attr $array]} {
	return
    }
    if {[Fx:CurrentTypeCheck $schema] || [Fx:CurrentUniqueCheck $schema]} {
	return
    }
    set transattr [split $attr .]
    set transattr [string tolower [join $transattr _]]
    if {!$reconfig} {
	if {[winfo exists .view_$transattr]} {
	    ReconfigureViewsBelow
	    wm withdraw .view_$transattr
	    wm deiconify .view_$transattr
	    set reconfig 1
	} else {
	    set verbosename [qddb_schema option verbosename $schema $attr]
	    if {[string compare $verbosename ""] == 0} {
		set verbosename [split $attr .]
		set verbosename [lindex $verbosename [expr [llength $verbosename] - 1]]
	    }
	}
	if {!$reconfig && $fx_blt} {
	    blt::busy hold .
	    update; update idletasks
	}
    } else {
	if {![winfo exists .view_$transattr]} {
	    return
	}
    }
    set print_attrs {}
    set user_attrs {}
    foreach i $fx_config($attr,print) {
	if {"[string index $i 0]" != "\$"} {
	    lappend print_attrs $i
	} else {
	    lappend user_attrs $i
	}
    }
    set asc {}
    set x 0
    foreach i $fx_config($attr,ascending) {
	if {[string compare $i yes] == 0} {
	    lappend asc [lindex $fx_config($attr,sortby) $x] 
	}
	incr x
    }
    if {[info exists rowtbl] && [string length $rowtbl] > 0} {
	set maxnum [qddb_table row maxnum $rowtbl]
	for {set i 1} {$i <= $maxnum} {incr i} {
	    catch "qddb_rows delete [qddb_table row cget $rowtbl $i -comment]"
	}
	catch "qddb_table delete $rowtbl"
    }
    if {[info exists fx_config($attr,unsorted)] && $fx_config($attr,unsorted)} {
	set rowtbl [qddb_rows all -format table \
		-instance [BuildInst] \
		-attrs $print_attrs \
		-print $print_attrs \
		-rowdescs on \
		$tuple]
	if {[llength $user_attrs] > 0} {
	    Fx:UserDefinedTable $rowtbl $attr fx_config
	}
    } else {
	if {[llength $user_attrs] == 0} {
	    set rowtbl [qddb_rows all -format table \
		    -sortby $fx_config($attr,sortby) \
		    -ascending $asc \
		    -instance [BuildInst] \
		    -attrs $print_attrs \
		    -print $print_attrs \
		    -rowdescs on \
		    $tuple]
	} else {
	    set rowtbl [qddb_rows all -format table \
		    -instance [BuildInst] \
		    -attrs $print_attrs \
		    -print $print_attrs \
		    -rowdescs on \
		    $tuple]
	    Fx:UserDefinedTable $rowtbl $attr fx_config
	    qddb_table sort $rowtbl -ascending $asc \
		    -sortby $fx_config($attr,sortby)
	}
    }
    if {[info exists fx_config($attr,widths)]} {
	set x [qddb_table col maxnum $rowtbl]
	set y [qddb_table row maxnum $rowtbl]
	for {set i 0} {$i < $x} {incr i} {
	    set iplus1 [expr $i + 1]
	    set tmp_width [lindex $fx_config($attr,widths) $i]
	    if {[string length $tmp_width] == 0} {
		continue
	    }
	    set tmp_sep [lindex $fx_config($attr,separators) $i]
	    if {[string length $tmp_sep] == 0} {
		set tmp_sep " "
	    }
	    set tmp_align [lindex $fx_config($attr,alignment) $i]
	    if {[string compare [string index [qddb_table col cget \
		    $rowtbl $iplus1 -name] 0] \$] != 0} {
		# configure normal columns so they don't lose their default format
		qddb_table col configure $rowtbl $iplus1 \
			-width $tmp_width -separator $tmp_sep -justify $tmp_align
	    } else {
		# user-defined columns do not have a default format
		for {set j 1} {$j <= $y} {incr j} {
		    qddb_table cell configure $rowtbl $j $iplus1 \
			    -width $tmp_width -separator $tmp_sep -justify $tmp_align
		}
	    }
	}
    }
    if {[info exists fx_config($attr,linenumbers)]} {
	set rowtitles $fx_config($attr,linenumbers)
    } else {
	set rowtitles 0
    }
    set mytext [qddb_table getval $rowtbl -format rows -coltitles on -rowtitles $rowtitles]
    if {$reconfig} {
	set curselect [.view_$transattr.f.l2 curselection]
	set nearesty  [.view_$transattr.f.l2 nearest 0]
	view_$transattr ClearRows
	view_$transattr ClearContents
	view_$transattr configure -headings [lindex $mytext 0]
    } else {
	toplevel .view_$transattr
	wm title .view_$transattr "Viewing: $verbosename"
	wm protocol .view_$transattr WM_DELETE_WINDOW [list catch "destroy .view_$transattr; \
		delete object Fx_Attribute::view_$transattr"]
	if {[info exists fx_config(geom,view_$transattr)]} {
	    wm geometry .view_$transattr $fx_config(geom,view_$transattr)
	}
	set f .view_$transattr.f2
	frame $f
	pack $f -side bottom -fill x
	button $f.select -text Select -command [list Fx_Attribute::view_$transattr OnSelect]
	pack $f.select -side left -padx 6m -pady 2m -ipadx 6m -ipady 2m
	button $f.cancel -text Dismiss \
		-command [list catch "destroy .view_$transattr; \
		delete object Fx_Attribute::view_$transattr"]
	pack $f.cancel -side left -padx 6m -pady 2m -ipadx 6m -ipady 2m
	set px [$f.select cget -padx]
	set py [$f.select cget -pady]
	button $f.print -text Print -command [list $this PrintCmd $mytext .view_$transattr]
	set buttfont [$f.print cget -font]
	checkbutton $f.pin -text "Pin" -variable fx_config(pin,view_$transattr) \
		-onvalue 1 -offvalue 0 -padx $px -pady $py -font $buttfont
	pack $f.pin -side right -padx 6m -pady 2m -ipadx 6m -ipady 2m
	pack $f.print -side right -padx 6m -pady 2m -ipadx 6m -ipady 2m
	Fx_SingleColumnListBox view_$transattr -w .view_$transattr.f \
		-headings [lindex $mytext 0] \
		-width 60 \
		-single_select on \
		-exportselection off \
		-height 10 \
		-onselect [list $this PinnedViewProc view_$transattr]
	set current_views([info which view_$transattr]) $this
    }
    view_$transattr AppendRows [lrange $mytext 1 end]
    if {$reconfig} {
	view_$transattr Display 1
	.view_$transattr.f.l2 select clear 0 end
	.view_$transattr.f.l2 select set $curselect $curselect
	.view_$transattr.f.l2 select anchor $curselect
	.view_$transattr.f.l2 activate $curselect
	.view_$transattr.f.l2 yview $nearesty
	.view_$transattr.f2.print configure -command [list $this PrintCmd $mytext .view_$transattr]
    } else {
	bind .view_$transattr <Configure> [list $this ConfigureWindow $transattr]
	if {[info exists fx_config(geom,view_$transattr)]} {
	    wm geometry .view_$transattr $fx_config(geom,view_$transattr)
	}
	view_$transattr Display 0
    }
    if {!$reconfig && $fx_blt} {
	catch "blt::busy forget ."
    }
    update idletasks
    if {!$reconfig} {
	tkwait window .view_$transattr.f
	catch "destroy .view_$transattr"
	catch "unset current_views([info which view_$transattr])"
    }
}

itcl::body Fx_Attribute::ReconfigureViewsBelow {} {
    if {[info exists current_views]} {
	set transattr [split $attr .]
	set transattr [string tolower [join $transattr _]]
	foreach i [array names current_views] {
	    if {[string match *view_${transattr}_* ${i}] == 1} {
		set myinst $current_views($i)
		$myinst ViewInstance 1
	    }
	}
	update idletasks
    }
}
itcl::body Fx_Attribute::ConfigureWindow {transattr} {
    global ::fx_config
    set fx_config(geom,view_$transattr) [wm geometry .view_$transattr]
}
itcl::body Fx_Attribute::PinnedViewProc {inst i} {
    global ::fx_config

    if {![info exists fx_config(pin,$inst)] || $fx_config(pin,$inst) == 0} {
	catch "delete object $inst"
	catch "destroy .$inst"
	$this SelectRow $i
	after idle [list focus -force [focus -lastfor .]]
    } else {
	$this SelectRow $i
    }
}
itcl::body Fx_Attribute::PrintCmd {contents t} {
    global ::fx_config ::fx:status_variable ::fx_blt

    Fx_PrintDialog ${this}_print_dialog
    if {$fx_config(cancel_print) == 0} {
	if {$fx_blt} {
	    blt::busy hold .
	    if {[winfo exists ${t}]} {
		blt::busy hold $t
	    }
	}
	update idletasks
	Fx:Print $contents
	if {$fx_blt} {
	    catch "blt::busy forget ."
	    if {[winfo exists $t]} {
		catch "blt::busy forget $t"
	    }
	}
	if {[winfo exists $t]} {
	    if {[catch "focus -lastfor $t" resultswin] == 0} {
		after idle [list catch [list focus -force $resultswin]]
	    }
	}
	update idletasks
    } else {
	::set fx:status_variable "Printing cancelled."
    }
}
itcl::body Fx_Attribute::SelectRow {i} {
    set oldchanged [TupleChanged]
    if {[info exists beforechange]} {
	eval $beforechange
    }
    qddb_view set $view [qddb_table row cget $rowtbl [expr $i + 1] -comment]
    if {[info exists afterchange]} {
	eval $afterchange
    }
    TupleChanged $oldchanged
    ReconfigureViewsBelow
}

itcl::body Fx_Entry::FormatField {} {
    global ::fx:mode_variable ::fx:change_modeval ::fx:add_modeval \
	    ::$array ::fx_config

    if {([string compare ${fx:mode_variable} ${fx:change_modeval}] != 0 && \
	    [string compare ${fx:mode_variable} ${fx:add_modeval}] != 0) || \
	    $fx_config(force_field_formatting) == 0} {
	return
    }
    if {[string compare $type Entry] == 0} {
	switch [qddb_schema option type $schema $attr] {
	    real {
		set oldval [$w.e get]
		if {[catch [list expr double($oldval)] newval] != 0} {
		    return
		}
		set newval [format [qddb_schema option format $schema $attr] $newval]
		if {[string compare $oldval $newval] != 0} {
		    uplevel \#0 [list set ${array}($attr) $newval]
		}
	    }
	    integer {
		set oldval [$w.e get]
		if {[catch [list expr int($oldval)] newval] != 0} {
		    return
		}
		set newval [format [qddb_schema option format $schema $attr] $newval]
		if {[string compare $oldval $newval] != 0} {
		    uplevel \#0 [list set ${array}($attr) $newval]
		}
	    }
	    date {
		set oldval [$w.e get]
		set fmt [qddb_schema option format $schema $attr]
		if {[catch [list qddb_util formatdate $fmt $oldval] newval] == 0} {
		    if {[string compare $oldval $newval] != 0} {
			uplevel \#0 [list set ${array}($attr) $newval]
		    }
		}
	    }
	}
    }
}
itcl::body Fx_Entry::ReFocus {} {
    global ::fx:current_focus ::$array

    if {[info exists fx:current_focus]} {
	if {[string compare [lindex ${fx:current_focus} 1] $w.e] != 0} {
	    if {![Fx:CurrentTypeCheck $schema] && ![Fx:CurrentUniqueCheck $schema]} {
		::set fx:current_focus [list $attr $w.e]
	    } else {
		after idle [list focus [lindex [::set fx:current_focus] 1]]
		::set fx:current_focus [list $attr $w.e]
	    }
	}
    } else {
	::set fx:current_focus [list $attr $w.e]
    }
}
itcl::body Fx_Entry::RefreshTextVar {{n1 ""} {n2 ""} {op ""}} {
    uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
    set tuple_changed 1
    uplevel \#0 [list set $textvariable [$w.e get 0.0 end]]
    uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
}

if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_widgets-p.tcl"
}
