proc Fx:Reconfigure {} {
    update
    update idletasks
    wm minsize . [winfo reqwidth .] [winfo reqheight .]
    wm maxsize . [winfo reqwidth .] [winfo reqheight .]
    wm geometry . [winfo reqwidth .]x[winfo reqheight .]    
    wm deiconify .
}

proc Fx:UniqueList {l} {
    if {[llength $l] == 0} {return {}}
    foreach i $l {
	if {[string length $i] > 0} {
	    set arr($i) {}
	}
    }
    foreach i [array names arr] {
	lappend retval $i
    }
    return $retval
}

proc TempNam {} {
    global fx_tmpfilenum

    if {![info exists fx_tmpfilenum]} {
	set fx_tmpfilenum 0
    } else {
	incr fx_tmpfilenum
    }
    if {[file isdirectory /var/tmp]} {
	set dir /var/tmp
    } elseif {[file isdirectory /usr/tmp]} {
	set dir /usr/tmp
    } elseif {[file isdirectory /tmp]} {
	set dir /tmp
    } else {
	set dir [glob ~]
    }
    return "${dir}/tmpfile.[pid].$fx_tmpfilenum"
}

proc Fx:BusyExec {w l} {
    global fx_blt fx_config

    if {$fx_blt} {
	foreach i $w {
	    catch "blt::busy hold $i"
	}
    }
    set result [eval $l]
    if {$fx_blt} {
	foreach i $w {
	    catch "blt::busy forget $i"
	}
    }
    return $result
}

proc Fx:DisabledExec {w l} {
    global fx_blt fx_config

    foreach i $w {
	catch "$i configure -state disabled"
    }
    set result [eval $l]
    foreach i $w {
	catch "$i configure -state normal"
    }
    return $result
}

proc Fx:lintersect {l1 l2} {
    foreach i $l1 {
	set left($i) {}
    }
    foreach i $l2 {
	set right($i) {}
    }
    set result {}
    foreach i [array names left] {
	if {[info exists right($i)]} {
	    lappend result $i
	}
    }
    return $result
}

proc Fx:lreverse {l} {
    set len [llength $l]
    set res {}
    for {set i [expr $len - 1]} {$i >= 0} {incr i -1} {
	lappend res [lindex $l $i]
    }
    return $res
}

proc Fx:nullop {} {}

proc Fx:Dialog {t s {w ""}} {
    if {[string compare $w ""] == 0} {
	set w .fx_dialog
    }
    fx_dialog $w $t $s error 0 Ok
}

proc Fx:CheckMandatoryFields {schema attr array} {
    global fx_config $array

    if {[llength $attr] == 0} {
	foreach i [qddb_schema leaves $schema] {
	    if {[info exists fx_config($i,mandatory)] && \
		    $fx_config($i,mandatory) == 1 && \
		    [string compare [string trim [set ${array}($i)]] ""] == 0} {
		fx_dialog .dialog "Mandatory field empty!" \
			 "You must fill in all mandatory fields ($i) or clear the record" error 0 Ok
		return 1
	    }
	}
    } else {
	foreach i [qddb_schema leaves $schema $attr] {
	    if {[info exists fx_config($i,mandatory)] && \
		    $fx_config($i,mandatory) == 1 && \
		    [string compare [string trim [set ${array}($i)]] ""] == 0} {
		fx_dialog .dialog "Mandatory field empty!" \
			 "You must fill in all mandatory fields or clear the record" error 0 Ok
		return 1
	    }	
	}
    }
    return 0
}

proc Fx:UniqueError {} {
    fx_dialog .dialog "Uniqueness error" "This field must contain a unique value.  Please re-enter." error 0 OK
}

proc Fx:CurrentUniqueCheck {schema} {
    global fx:current_focus

    if {[info exists fx:current_focus]} {
	return [Fx:UniqueCheck $schema [lindex ${fx:current_focus} 0] [lindex ${fx:current_focus} 1]]
    }
    return 0
}

proc Fx:UniqueCheck {schema attr entry} {
    global fx:mode_variable fx_config
    global fx:search_modeval fx:add_modeval fx:change_modeval
    if {![info exists fx_config($attr,unique)] || $fx_config($attr,unique) == 0} {
	return 0
    }
    set val [$entry get]
    if {[string compare ${fx:mode_variable} ${fx:search_modeval}] == 0 || [string compare $val ""] == 0} {
	return 0
    }
    switch -exact [winfo class $entry] {
	Entry { }
	default {return 0}
    }
    set stuff [$entry get]
    if {[string compare $stuff ""] == 0} {return 0}
    set k [qddb_search $schema -prunebyattr $attr word [$entry get]]
    set k [qddb_keylist process nullop -deldup_sameentry on $k]
    set x 0
    foreach i [qddb_keylist get $k] {
	set t [qddb_tuple read $schema $i]
	if {[llength $t] > 0} {
	    incr x
	    catch [list qddb_tuple delete $t]
	}
    }
    if {[string compare ${fx:add_modeval} ${fx:mode_variable}] == 0} {
	if {$x > 0} {
	    Fx:UniqueError
	    focus $entry
	    return 1
	}
    } elseif {[string compare ${fx:change_modeval} ${fx:mode_variable}] == 0} {
	if {$x > 1} {
	    Fx:UniqueError
	    focus $entry
	    return 1
	}
    }
    return 0
}

proc Fx:TypeError {type val} {
    fx_dialog .dialog "Type error" "Invalid $type: $val  Please re-enter." error 0 OK
}

proc Fx:CurrentTypeCheck {schema} {
    global fx:current_focus

    if {[info exists fx:current_focus]} {
	return [Fx:TypeCheck $schema [lindex ${fx:current_focus} 0] [lindex ${fx:current_focus} 1]]
    }
    return 0
}

proc Fx:TypeCheck {schema attr entry} {
    global fx:mode_variable
    global fx:search_modeval
    if {[string compare ${fx:mode_variable} ${fx:search_modeval}] == 0} {
	return 0
    }
    set type [qddb_schema option type $schema $attr]
    switch -exact [winfo class $entry] {
	Entry {set val [$entry get]}
	default {return 0}
    }
    set err 0
    if {[string compare $val ""] == 0} {
	return 0
    }
    switch -exact $type {
	integer {
	    if {[catch "expr int($val)"] == 0} {
		return 0
	    } else {
		set err 1
	    }
	}
	real {
	    if {[catch "expr double($val)"] == 0} {
		return 0
	    } else {
		set err 1
	    }
	}
    }
    if {$err != 0} {
	Fx:TypeError $type [$entry get]
	focus $entry
	return 1
    } elseif {[string compare $type "date"] == 0} {
	if {![qddb_util isdate [$entry get]]} {
	    Fx:TypeError $type [$entry get]
	    focus $entry
	    return 1
	}
    }
    return 0
}

proc Fx:AboutBox {} {
    global qddb_library qddb_version fx_config

    if {[winfo exists .aboutBox]} {
	wm withdraw .aboutBox
	wm deiconify .aboutBox
	focus .aboutBox
	update idletasks
        return
    }
    toplevel .aboutBox
    wm title .aboutBox "About Qddb"
    if {[info exists fx_config(geom,\$AboutBox\$)]} {
	set x [split $fx_config(geom,\$AboutBox\$) +]
	set y [lindex $x 2]
	set x [lindex $x 1]
	wm geometry .aboutBox +$x+$y
    }
    set x .aboutBox.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command {
	global fx_config
	set fx_config(geom,\$AboutBox\$) [wm geometry .aboutBox]
	destroy .aboutBox
    }
    pack $x.ok -fill x

    if {[winfo depth .] < 8} {
	label .aboutBox.qddb -bitmap @$qddb_library/fx/pixmaps/qddb2.xbm
    } else {
	image create photo qddb_color2 -file $qddb_library/fx/pixmaps/qddb_color2.gif
	label .aboutBox.qddb -image qddb_color2
    }
    pack .aboutBox.qddb -side top

    message .aboutBox.version -justify center -aspect 400 \
        -text "Quick and Dirty DataBase\nVersion ${qddb_version}\n"
    pack .aboutBox.version -side top

    message .aboutBox.copyright -justify center -aspect 500 \
	-text "Copyright(c) 1993-1997\nHerrin Software Development, Inc.\nAll rights reserved.\n" 
    pack .aboutBox.copyright -side top

    message .aboutBox.license -justify left -aspect 250 \
	-text "Qddb is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License Version 2 as published by the Free Software Foundation.  Qddb is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.  You should have received a copy of the GNU General Public License along with Qddb; see the file LICENSE.  If not, write to:\n\n    Herrin Software Development, Inc.\n    R&D Division\n    41 South Highland Ave.\n    Prestonsburg, KY  41653"
    pack .aboutBox.license -side top
    message .aboutBox.subscription -justify left -aspect 1000 \
	-text "See: http://www.hsdi.com/qddb for the latest release, support, and subscription information."
    pack .aboutBox.subscription -side top
}

proc Fx:FAQBox {} {
    global qddb_library fx_config qddb_version

    if {[winfo exists .faqBox]} {
	wm withdraw .faqBox
	wm deiconify .faqBox
	focus .faqBox
	update idletasks
        return
    }
    toplevel .faqBox
    wm title .faqBox "Qddb Frequently Asked Questions"
    set x .faqBox.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "
	set [list fx_config(geom,\$faqBox\$)] \[wm geometry .faqBox\]
        destroy .faqBox
    "
    pack $x.ok -fill x

    if {[winfo depth .] < 8} {
	label .faqBox.qddb -bitmap @$qddb_library/fx/pixmaps/qddb2.xbm
    } else {
	image create photo qddb_color2 -file $qddb_library/fx/pixmaps/qddb_color2.gif
	label .faqBox.qddb -image qddb_color2
    }
    pack .faqBox.qddb -side top

    message .faqBox.faq -justify center -aspect 400 \
	-text "Frequently Asked Questions"
    pack .faqBox.faq -side top

    message .faqBox.version -justify center -aspect 400 \
        -text "Quick and Dirty DataBase\nVersion ${qddb_version}\n"
    pack .faqBox.version -side top

    message .faqBox.copyright -justify center -aspect 500 \
	-text "Copyright(c) 1993-1997\nHerrin Software Development, Inc.\nAll rights reserved.\n" 
    pack .faqBox.copyright -side top

    set fd [open $qddb_library/FAQ "r"]
    set FAQ [read $fd]
    close $fd
    set x .faqBox.f
    frame $x
    pack $x -side top -expand on -fill both
    scrollbar $x.s -orient vertical -relief sunken -command [list $x.c yview]
    pack $x.s -side right -fill y
    text $x.c -relief sunken -bd 2 -yscroll [list $x.s set] -wrap word -setgrid on
    pack $x.c -side left -expand on -fill both
    $x.c insert 0.0 $FAQ
    $x.c configure -state disabled
    if {[info exists fx_config(geom,\$faqBox\$)]} {
	wm geometry .faqBox $fx_config(geom,\$faqBox\$)
    } else {
	wm geometry .faqBox +70+0
    }
}

proc Fx:KeyBindingsHelp {} {
    global qddb_library fx_config qddb_version fx_monochrome

    if {[winfo exists .keybindBox]} {
	wm withdraw .keybindBox
	wm deiconify .keybindBox
	focus .keybindBox
	update idletasks
        return
    }
    toplevel .keybindBox
    wm title .keybindBox "Fx Key Bindings"
    set x .keybindBox.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "
	set [list fx_config(geom,\$keybindBox\$)] \[wm geometry .keybindBox\]
        destroy .keybindBox
    "
    pack $x.ok -fill x

    message .keybindBox.title -justify center -aspect 600 -text \
	"Qddb Fx Toolkit Key Bindings"
    pack .keybindBox.title -side top

    set f .keybindBox.f
    frame $f
    pack $f -side top -expand on -fill both
    set f1 {
	{ "<Tab>" "Move cursor to next field" }
	{ "<Shift-Tab>" "Move cursor to last field" }
	{ "<Control-a>" "Go to beginning of line" }
	{ "<Control-e>" "Go to end of line" }
	{ "<Control-b>" "Move back one char" }
	{ "<Control-d>" "Delete next char" }
	{ "<Control-e>" "Move forward one char" }
    }
    label $f.l0 -text "Generic Key Bindings" -relief raised
    pack $f.l0 -side top -expand on -fill x
    frame $f.f1 -bd 1 -relief sunken
    pack $f.f1 -side left -expand on -fill both
    set x 0
    foreach i $f1 {
	frame $f.f1.f$x -bd 1
	pack $f.f1.f$x -side top -expand on -fill x
	label $f.f1.f$x.l1 -text [lindex $i 0] -anchor e -width 12 -bd 1 -relief sunken
	label $f.f1.f$x.l2 -text [lindex $i 1] -anchor w -bd 1 -relief sunken
	pack $f.f1.f$x.l1 -side left
	pack $f.f1.f$x.l2 -side left -expand on -fill x
	incr x
    }
    set f2 {
	{ "<Control-h>" "Back one char, delete char" }
	{ "<Control-k>" "Kill to end of line" }
	{ "<Control-u>" "Kill to beginning of line" }
	{ "<Control-w>" "Cut selected text into buffer" }
        { "<Alt-w>"     "Copy selected text into buffer" }
	{ "<Control-y>" "Paste buffer contents at cursor position" }
	{ "<Button-3>" "Paste selection at mouse position" }
    }
    frame $f.f2 -bd 1 -relief sunken
    pack $f.f2 -side right -expand on -fill both
    set x 0
    foreach i $f2 {
	frame $f.f2.f$x -bd 1
	pack $f.f2.f$x -side top -expand on -fill x
	label $f.f2.f$x.l1 -text [lindex $i 0] -anchor e -width 12 -bd 1 -relief sunken
	label $f.f2.f$x.l2 -text [lindex $i 1] -anchor w -bd 1 -relief sunken
	pack $f.f2.f$x.l1 -side left
	pack $f.f2.f$x.l2 -side left -expand on -fill x
	incr x
    }
    set entryonly {
	{ "<Down>" "Move cursor to next field" }
	{ "<Up>" "Move cursor to last field" }
	{ "<Control-n>" "Move cursor to next field" }
	{ "<Control-p>" "Move cursor to last field" }
	{ "<Return>" "In Search Mode, search" }
	{ "" "" }
    }
    set x [llength $f1]
    label $f.f1.l0 -text "Entry-specific Bindings" -relief raised
    pack $f.f1.l0 -side top -expand on -fill x
    foreach i $entryonly {
	frame $f.f1.f$x -bd 1
	pack $f.f1.f$x -side top -expand on -fill x
	label $f.f1.f$x.l1 -text [lindex $i 0] -anchor e -width 12 -bd 1 -relief sunken
	label $f.f1.f$x.l2 -text [lindex $i 1] -anchor w -bd 1 -relief sunken
	pack $f.f1.f$x.l1 -side left
	pack $f.f1.f$x.l2 -side left -expand on -fill x
	incr x
    }
    set textonly {
	{ "<Down>" "Move cursor to next line" }
	{ "<Up>" "Move cursor to last line" }
	{ "<Control-n>" "Move cursor to next line" }
	{ "<Control-o>" "Open current line" }
	{ "<Control-p>" "Move cursor to last line" }
	{ "<Return>" "Move cursor to next line" }
    }
    set x [llength $f2]
    label $f.f2.l0 -text "Text-specific Bindings" -relief raised
    pack $f.f2.l0 -side top -expand on -fill x
    foreach i $textonly {
	frame $f.f2.f$x -bd 1
	pack $f.f2.f$x -side top -expand on -fill x
	label $f.f2.f$x.l1 -text [lindex $i 0] -anchor e -width 12 -bd 1 -relief sunken
	label $f.f2.f$x.l2 -text [lindex $i 1] -anchor w -bd 1 -relief sunken
	pack $f.f2.f$x.l1 -side left
	pack $f.f2.f$x.l2 -side left -expand on -fill x
	incr x
    }
    if {[info exists fx_config(geom,\$keybindBox\$)]} {
	wm geometry .keybindBox $fx_config(geom,\$keybindBox\$)
    } else {
	wm geometry .keybindBox +70+0
    }
}

proc fx_make_directory_hierarchy {dir} {
    if {"$dir" != ""} {
	set l [split $dir /]
	set mydir {}
	foreach i $l {
	    append mydir "/$i"
	    if {![file isdirectory $mydir]} {
		if {[file exists $mydir]} {
		    error "Attempt to make directory '$mydir' failed"
		}
		if {[catch "exec mkdir $mydir" errmsg] != 0} {
		    error $errmsg
		}
	    }
	}
    }
}

proc fx_message {w text} {
    frame $w -relief groove -bd 4
    set parent [winfo toplevel [winfo parent $w]]
    place $w -in $parent -relx 0.5 -rely 0.5 -anchor c
    label $w.msg -wraplength 3i -justify center -text $text \
	    -font -Adobe-Times-Medium-R-Normal--*-180-*-*-*-*-*-*
    pack $w.msg -side left -padx 3m -pady 3m
    update idletasks
    focus $w
}

proc fx_containfocus {buttons} {
    bind [lindex $buttons 0] <Tab> "eval focus \[tk_focusNext %W\]"
    bind [lindex $buttons 0] <Shift-Tab> "focus [lindex $buttons end]; break"
    bind [lindex $buttons end] <Tab> "focus [lindex $buttons 0]; break"
    bind [lindex $buttons end] <Shift-Tab> "eval focus \[tk_focusPrev %W\]"
}

# dialog.tcl --
#
# This file defines the procedure tk_dialog, which creates a dialog
# box containing a bitmap, a message, and one or more buttons.
#
# @(#) dialog.tcl 1.16 95/07/28 09:35:57
#
# Copyright (c) 1992-1993 The Regents of the University of California.
# Copyright (c) 1994-1995 Sun Microsystems, Inc.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

#
# tk_dialog:
#
# This procedure displays a dialog box, waits for a button in the dialog
# to be invoked, then returns the index of the selected button.
#
# Arguments:
# w -		Window to use for dialog top-level.
# title -	Title to display in dialog's decorative frame.
# text -	Message to display in dialog.
# bitmap -	Bitmap to display in dialog (empty string means none).
# default -	Index of button that is to display the default ring
#		(-1 means none).
# args -	One or more strings to display in buttons across the
#		bottom of the dialog box.

proc fx_dialog {w title text bitmap default args} {
    global fxPriv fx_blt

    catch {destroy $w}
    frame $w -class Dialog -relief groove -bd 4
    set parent [winfo toplevel [winfo parent $w]]
    destroy $w
    update idletasks
    if {$fx_blt} {
	if {[llength [blt::busy isbusy .]] > 0} {
	    set blt_donthold 1
	} else {
	    set blt_donthold 0
	    blt::busy hold $parent
	}
    }
    frame $w -class Dialog -relief groove -bd 4
    place $w -in $parent -relx 0.5 -rely 0.5 -anchor c
    frame $w.top -relief raised -bd 1
    pack $w.top -side top -fill both
    frame $w.bot -relief raised -bd 1
    pack $w.bot -side bottom -fill both
    label $w.msg -wraplength 3i -justify left -text $text \
	    -font -Adobe-Times-Medium-R-Normal--*-180-*-*-*-*-*-*
    pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 3m -pady 3m
    if {$bitmap != ""} {
	label $w.bitmap -bitmap $bitmap
	pack $w.bitmap -in $w.top -side left -padx 3m -pady 3m
    }
    set i 0
    foreach but $args {
	button $w.button$i -text $but -command "set fxPriv(button) $i"
	if {$i == $default} {
	    frame $w.default -relief sunken -bd 1
	    raise $w.button$i $w.default
	    pack $w.default -in $w.bot -side left -expand 1 -padx 3m -pady 2m
	    pack $w.button$i -in $w.default -padx 2m -pady 2m
	} else {
	    pack $w.button$i -in $w.bot -side left -expand 1 \
		    -padx 3m -pady 2m
	}
	lappend contain_focus $w.button$i
	incr i
    }
    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    catch "grab $w"
    raise $parent
    if {$default >= 0} {
	after idle "focus $w.button$default"
    } else {
	after idle "focus $w"
    }
    fx_containfocus $contain_focus
    tkwait variable fxPriv(button)
    after idle "catch [list focus $oldFocus]"
    catch "destroy $w"
    if {$fx_blt} {
	if {$blt_donthold == 0} {
	    catch "blt::busy forget $parent"
	}
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    catch "grab -global $oldGrab"
	} else {
	    catch "grab $oldGrab"
	}
    }
    return $fxPriv(button)
}

proc Fx:FileViewPrint {fn title toplevel} {
    global        fx_config fx:status_variable

    Fx_PrintDialog print_dialog$toplevel -toplevel $toplevel -title "Print $title"
    if {$fx_config(cancel_print) == 0} {
	catch "Fx:PrintFile $fn"
    } else {
	set fx:status_variable "Printing cancelled..."
    }
    catch "destroy $toplevel"
}

proc Fx:FileView {fn title} {
    global fx_fileviewer_instance fx_config

    if {![info exists fx_fileviewer_instance]} {
	set fx_fileviewer_instance 0
    } else {
	incr fx_fileviewer_instance
    }
    set viewer .fx_fileviewer${fx_fileviewer_instance}
    toplevel $viewer
    wm withdraw $viewer
    wm title $viewer "File viewer: [string trim $title]"
    set b $viewer.b
    frame $b
    pack $b -side bottom -fill x
    button $b.print -text Print -command [list after idle [list Fx:FileViewPrint $fn [string trim $title] $viewer]]
    pack $b.print -side left -padx 10m -pady 5m
    button $b.close -text Close -command "Fx:SaveGeometry $viewer .fx_fileviewer; destroy $viewer"
    pack $b.close -side right -padx 10m -pady 5m

    set f $viewer.f
    frame $f
    pack $f -side top -expand on -fill both
    scrollbar $f.s -takefocus 0 -command [list $f.t yview]
    pack $f.s -side right -fill y
    scrollbar $f.s2 -takefocus 0 -orient horizontal -command [list $f.t xview]
    pack $f.s2 -side bottom -fill x
    set font [option get . font Listbox]
    if {[string length $font] == 0} {
	set font "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-*-*"
    }
    text $f.t -width 80 -wrap none -font $font -yscroll [list $f.s set] -xscroll [list $f.s2 set]
    pack $f.t -side left -expand on -fill both
    bind $viewer <Configure> {
	if {[string compare [winfo toplevel %W] %W] == 0} {
	    Fx:SaveGeometry %W .fx_fileviewer
	}
    }
    focus $f.t
    set fd [open $fn r]
    $f.t insert 0.0 [read $fd]
    close $fd
    $f.t configure -state disabled
    set fx_config(file_viewer) $viewer
    Fx:SetGeometry $viewer .fx_fileviewer
    update idletasks
    wm deiconify $viewer
    tkwait visibility $viewer
}

proc Fx:centerline {s width} {
    set len [string length $s]
    set pad [expr ($width - $len)/2]
    set mypad ""
    for {set i 0} {$i < $pad} {incr i} {
	append mypad " "
    }
    return "$mypad$s"
}

proc Fx:Text_InsertAliasSelection {tbox x y} {
    if {[catch "selection get" sel] != 0} {
	return
    }
    set sel [lindex $sel end]
    $tbox insert @${x},${y} "<$sel>"
}

proc Fx:SaveGeometry {w {idx ""}} {
    global fx_config
    update; update idletasks
    if {[string length $idx] == 0} {
	set idx $w
    }
    set fx_config(geom,$idx) [wm geometry $w]
}

proc Fx:SavePosition {w {idx ""}} {
    global fx_config
    update; update idletasks
    if {[string length $idx] == 0} {
	set idx $w
    }
    set geom [split [wm geometry $w] +]
    set fx_config(geom,$idx) +[lindex $geom 1]+[lindex $geom 2]
}

proc Fx:SetGeometry {w {idx ""}} {
    global fx_config
    if {[string length $idx] == 0} {
	set idx $w
    }
    if {[info exists fx_config(geom,$idx)]} {
	if {[llength $fx_config(geom,$idx)] > 1} { ;# backward compatibility
	    set l $fx_config(geom,$w)
	    wm geometry $w [lindex $l 3]x[lindex $l 2]+[lindex $l 0]+[lindex $l 1]
	} else {
	    wm geometry $w $fx_config(geom,$idx)
	}
	update idletasks
    }
}

proc Fx:ViewAttributesAndAliases {s {with_aliases 1} {restrict {}}} {
    global fx_alias_info fx_config

    set f .fx_view_aliases
    if {[winfo exists $f]} {
	destroy $f
	delete object fx_aliases_listbox
	update idletasks; update
    }
    toplevel $f -cursor arrow
    wm withdraw $f
    wm title $f "View Attributes and Aliases"
    frame $f.ft -takefocus 0 -highlightthickness 0
    pack $f.ft -side top -expand on -fill both
    set x $f.ft
    if {$with_aliases} {
	Fx_MultiColumnListBox fx_aliases_listbox -w $x.f -side top -numcols 3 \
		-width 40 -headings {Verbosename Attribute Alias} \
		-align {left left left} -single_select on -separators {" " " " " "} \
		-initselection on \
		-height 10
    } else {
	Fx_MultiColumnListBox fx_aliases_listbox -w $x.f -side top -numcols 2 \
		-width 30 -headings {Verbosename Attribute} \
		-align {left left} -single_select on -separators {" " " "} \
		-initselection on \
		-height 10
    }
    catch "unset fx_alias_info"
    set attrs [qddb_schema leaves $s]
    foreach i $attrs {
	if {[llength $restrict] > 0 && [lsearch -exact $restrict $i] == -1} {
	    continue
	}
	set verb [qddb_schema option verbosename $s $i]
	if {[string length $verb] == 0} {
	    set verb [split $i .]
	    set verb [lindex $verb [expr [llength $verb] - 1]]
	}
	if {$with_aliases} {
	    set alias [qddb_schema option alias $s $i]
	    if {[string length $alias] == 0} {
		set alias " "
	    }
	    lappend fx_alias_info [list $verb $i $alias]
	} else {
	    lappend fx_alias_info [list $verb $i]
	}
    }
    fx_aliases_listbox AppendRows $fx_alias_info
    fx_aliases_listbox BuildFormats 1
    fx_aliases_listbox Format
    fx_aliases_listbox Display    
    frame $f.bot
    pack $f.bot -side bottom -fill x
    button $f.bot.close -text Close -command "
        Fx:SaveGeometry $f
        destroy $f
        delete object fx_aliases_listbox
    "
    pack $f.bot.close -side left -padx 5m -pady 2m
    Fx:SetGeometry $f
    wm deiconify $f
}


proc Fx:DisplaySelectProc {w} {
    global fx_display_attribute_listbox_retval
    set fx_display_attribute_listbox_retval 1
}

proc Fx:DisplayAttributes {w b s varname {index ""} {extra {}} {grabStatus local}} {
    global fx_display_attrs fx_display_attribute_listbox_retval \
	    fx_display_leaves fx_display_info fxPriv $varname

    set oldGrab [grab current $w]
    set oldFocus [focus]
    set parent [winfo toplevel $b]
    set f $parent.attr
    toplevel $f -cursor arrow
    wm transient $f $parent
    wm overrideredirect $f 1
    wm withdraw $f

    frame $f.ft -takefocus 0 -highlightthickness 0
    pack $f.ft -side top -expand on -fill both
    set x $f.ft
    Fx_MultiColumnListBox fx_display_attribute_listbox -w $x.f -side top -numcols 2 \
	    -width 25 -headings {Verbosename Attribute} \
	    -align {left left} -single_select on -separators {" " " "} \
	    -initselection on \
	    -height 5 -onselect Fx:DisplaySelectProc
    frame $f.b -takefocus 0 -highlightthickness 0 -relief groove -bd 3
    pack $f.b -side bottom -expand on -fill x
    button $f.b.select -text Select -command {set fx_display_attribute_listbox_retval 1}
    pack $f.b.select -side left -padx 4m -pady 2m
    button $f.b.cancel -text Cancel -command {set fx_display_attribute_listbox_retval 0}
    pack $f.b.cancel -side right -padx 4m -pady 2m
    set fx_display_info {}
    if {[llength $extra] > 0} {
	lappend fx_display_info $extra 
    }
    set fx_display_attrs [qddb_schema leaves $s]
    foreach i $fx_display_attrs {
	set verb [qddb_schema option verbosename $s $i]
	if {[llength $verb] == 0} {
	    set verb [split $i .]
	    set verb [lindex $verb [expr [llength $verb] - 1]]
	}
	lappend fx_display_info [list $verb $i]
    }
    if {[llength $extra] > 0} {
	eval lappend display_attrs [lindex $extra 1] $fx_display_attrs
	set fx_display_attrs $display_attrs
    }
    fx_display_attribute_listbox AppendRows $fx_display_info
    fx_display_attribute_listbox BuildFormats 1
    fx_display_attribute_listbox Format
    fx_display_attribute_listbox Display    
    set rootx [winfo rootx $b]
    set rooty [expr [winfo rooty $b]+[winfo height $b]]
    set screenheight [winfo screenheight $b]
    set screenwidth [winfo screenwidth $b]
    update idletasks
    set reqheight [winfo reqheight $f]
    set reqwidth [winfo reqwidth $f]
    if {[expr $rooty + $reqheight] > $screenheight} {
	set rooty [expr $rooty + $screenheight - $rooty - $reqheight]
    }
    if {[expr $rootx + $reqwidth] > $screenwidth} {
	set rootx [expr $rootx + $screenwidth - $rootx - $reqwidth]
    }
    wm geometry $f "+$rootx+$rooty"
    bind $f <Escape> "global fx_display_attribute_listbox_retval; \
	    set fx_display_attribute_listbox_retval 0"
    bind $x.f.l2 <Escape> "global fx_display_attribute_listbox_retval; \
	    set fx_display_attribute_listbox_retval 0"
    bind $f <Enter> [list set fxPriv(popup_listbox) ""]
    bind $f <Leave> [list set fxPriv(popup_listbox) $f]
    set fxPriv(popup_listbox) $f
    bind $f <ButtonPress> {
	if {[info exists fxPriv(popup_listbox)]} {
	    if {[string compare $fxPriv(popup_listbox) ""] != 0} {
		set fx_display_attribute_listbox_retval 0
	    }
	}
    }
    wm deiconify $f
    tkwait visibility $f
    catch "grab -global $f"
    focus $x.f.l2
    tkwait variable fx_display_attribute_listbox_retval
    if {$fx_display_attribute_listbox_retval} {
	if {[string length $index] == 0} {
	    set $varname [lindex $fx_display_attrs [$x.f.l2 curselection]]
	} else {
	    set ${varname}($index) [lindex $fx_display_attrs [$x.f.l2 curselection]]
	}
    }
    delete object fx_display_attribute_listbox
    destroy $f
    update idletasks
    if {[info exists grabStatus] && [string compare $grabStatus global] == 0} {
	catch "grab -global $oldGrab"
	catch "focus -force $oldGrab"
    } else {
	catch "grab $oldGrab"
	catch "focus $oldFocus"
    }
    update idletasks
    catch "unset fxPriv(popup_listbox)"
}

proc Fx:FixedSizeWindowBinding {w} {
    set W [winfo toplevel $w]
    wm minsize $W [winfo reqwidth $W] [winfo reqheight $W]
    wm maxsize $W [winfo reqwidth $W] [winfo reqheight $W]
}

if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_util.tcl"
}
