#
# User-defined fields

proc Fx:UserDefinedSelection {box i} {
    global fx_userdef_current

    set fx_userdef_current [lindex [lindex [$box GetContents] $i] 1]
}

proc Fx:UserDefinedViewTable {tables} {
    global fx_config fx_userdef_tbl_vals fx_userdef_tbl_titles fx_userdef_current

    if {[winfo exists .userdef.tbl]} {
	wm withdraw .userdef.tbl
	wm deiconify .userdef.tbl
	return
    }
    catch "unset fx_userdef_tbl_vals"
    catch "unset fx_userdef_tbl_titles"
    catch "unset fx_userdef_current"
    catch "delete object userdef_attrs"
    catch "delete object userdef_tables"
    set mytables {}
    foreach i $tables {
	set tinfo [lindex $i 0]
	set tbl_name [lindex $tinfo 0]
	set tbl_title [lindex $tinfo 1]
	if {[llength [lindex $i 1]] > 0} {
	    if {[string length $tbl_name] > 0} {
		set fx_userdef_tbl_vals($tbl_name) [lindex $i 1]
		set fx_userdef_tbl_titles($tbl_name) $tbl_title
		lappend mytables $tbl_name
	    } else {
		set fx_userdef_tbl_vals(\$this_table\$) [lindex $i 1]
		set fx_userdef_tbl_titles(\$this_table\$) $tinfo
		lappend mytables \$this_table\$
	    }
	}
    }
    if {![info exists fx_userdef_tbl_titles]} {
	fx_dialog .userdef.dialog "Warning" \
		"There are no tables or numeric fields currently available." \
		warning 0 Ok
	return
    }
    set u .userdef.tbl
    toplevel $u
    wm withdraw $u
    wm title $u "Available tables and fields"
    if {[info exists fx_config(geom,\$user_def_tbl\$)]} {
	wm geometry $u $fx_config(geom,\$user_def_tbl\$)
    }
    set fx_config(isup,\$user_def_tbl\$) {}
    set f $u.f_tbl
    frame $f
    pack $f -side top -expand on -fill both
    frame $f.left
    pack $f.left -side left -expand on -fill both
    label $f.left.l -text "Available tables"
    pack $f.left.l -side top -fill x
    Fx_MultiColumnListBox userdef_tables -w $f.left.box -side top -numcols 2 \
	    -width 30 -headings {Title Table} \
	    -align {left left} -single_select off -separators {" " " "} \
	    -initselection off \
	    -height 3 -onselect [list Fx:UserDefinedSelection userdef_tables]

    set table_idx [lindex $mytables 0]

    if {!([llength $mytables] == 1 && [string compare $table_idx \$this_table\$] == 0)} {
	userdef_tables AppendRows [list $fx_userdef_tbl_titles($table_idx)]
    }
    userdef_tables CalculateWidths
    userdef_tables BuildFormats
    userdef_tables Format
    userdef_tables Display

    frame $f.right
    pack $f.right -side right -expand on -fill both
    label $f.right.l -text "Available attributes"
    pack $f.right.l -side top -fill x
    Fx_MultiColumnListBox userdef_attrs -w $f.right.box -side top -numcols 2 \
	    -width 30 -headings {Verbosename Attribute} \
	    -align {left left} -single_select off -separators {" " " "} \
	    -initselection off \
	    -height 3 \
	    -onselect [list Fx:UserDefinedSelection userdef_attrs]

    userdef_attrs AppendRows $fx_userdef_tbl_vals($table_idx)
    userdef_attrs CalculateWidths
    userdef_attrs BuildFormats
    userdef_attrs Format
    userdef_attrs Display
    
    set f $u.f_but
    frame $f
    pack $f -side top -fill x
    button $f.dismiss -text Dismiss -command {
	unset fx_config(isup,\$user_def_tbl\$)
	destroy .userdef.tbl
    }
    pack $f.dismiss -side left -padx 5m -pady 2m

    button $f.select -text Select -command {
	if {[info exists fx_userdef_current]} {
	    .userdef.f_text.t insert insert $fx_userdef_current
	}
    }
    pack $f.select -side right -padx 5m -pady 2m

    wm deiconify $u
    update
    update idletasks
    bind $u <Configure> {
	update idletasks
	update
	set fx_config(geom,\$user_def_tbl\$) [wm geometry .userdef.tbl]
    }
}

proc Fx:UserDefinedTable {table idx configvar} {
    global $configvar

    if {[info exists ${configvar}($idx,user_defs)]} {
	foreach i [set ${configvar}($idx,user_defs)] {
	    set defvalue [lindex $i 1]
	    set defname [lindex $defvalue 0]
	    set user_deftitles($defname) [lindex $defvalue 1]
	    set user_defvals($defname) [lindex $defvalue 2]
	    set user_defprec($defname) [lindex $defvalue 3]
	}
    }
    set column 1
    set maxrow [qddb_table row maxnum $table]
    set ignore_errors 0
    foreach i [set ${configvar}($idx,print)] {
	if {"[string index $i 0]" == "\$"} {
	    set lastcol [qddb_table col maxnum $table]
	    if {$lastcol < $column} {
		qddb_table col insert $table
	    } else {
		qddb_table col insert $table -before $column
	    }
	    set cmd [list qddb_table col configure $table $column \
		    -name $i -title $user_deftitles($i) -calc $user_defvals($i)]
	    set defprec($column) $user_defprec($i)
	    if {[catch {eval $cmd} ret] != 0 && !$ignore_errors} {
		if {[info exists ${configvar}($idx,ignore_errors)] && \
			[set ${configvar}($idx,ignore_errors)] == 0} {
		    if {[fx_dialog .dialog "Error in calculated field" \
			    "Error in calculated column ($column): $ret" \
			    error 0 Ok "Ignore further errors"] == 1} {
			set ignore_errors 1
		    }
		}
	    }
	} else {
	    set defprec($column) 0
	}
	incr column
    }
    # configure the width/separators/justify fields
    if {[info exists ${configvar}($idx,widths)]} {
	set x [qddb_table col maxnum $table]
	for {set i 0} {$i < $x} {incr i} {
	    set iplus1 [expr $i + 1]
	    set tmp_width [lindex [set ${configvar}($idx,widths)] $i]
	    if {[string length $tmp_width] == 0} {
		continue
	    }
	    set tmp_sep [lindex [set ${configvar}($idx,separators)] $i]
	    if {[string length $tmp_sep] == 0} {
		set tmp_sep " "
	    }
	    set tmp_align [lindex [set ${configvar}($idx,alignment)] $i]
	    qddb_table col configure $table $iplus1 \
		    -width $tmp_width -separator $tmp_sep -justify $tmp_align \
		    -precision $defprec($iplus1)
	}
    }
}

proc Fx:CheckExpression {{display 1}} {
    if {[qddb_table expr_ok [.userdef.f_text.t get 0.0 end]]} {
	if {$display} {
	    fx_dialog .userdef.dialog "Check results" "The current expression is valid." info 0 Ok
	}
	return 1
    } else {
	if {$display} {
	    fx_dialog .userdef.dialog "Check results" "The current expression is invalid." error 0 Ok
	}
	return 0
    }
}


# Fx:BuildCalculator
proc Fx:BuildCalculator {f t} {
    set col1 {1 4 7 0 :}
    set col2 {2 5 8 ( ,}
    set col3 {3 6 9 ) .}
    set col4 {+ - * / %}
    for {set i 1} {$i <= 4} {incr i} {
	frame $f.f$i -bd 0
	pack $f.f$i -side left -expand on -fill x
	set bnum 1
	foreach j [set col$i] {
	    button $f.f$i.b$bnum -text $j -command [list $t insert insert $j] \
		    -width 2 -bd 1 -padx 0 -pady 0 -takefocus 0
	    pack $f.f$i.b$bnum -side top -fill x
	    if {[string length $j] == 0} {
		$f.f$i.b$bnum configure -state disabled
	    }
	    incr bnum
	}
    }
}

proc Fx:BuildRangeFunctions {f t} {
    set col1 {@sum @prod @count}
    set col2 {@stddev @avg @min}
    set col3 {@max "" ""}
    for {set i 1} {$i <= 3} {incr i} {
	frame $f.f$i -bd 0
	pack $f.f$i -side left -expand on -fill x
	set bnum 1
	foreach j [set col$i] {
	    button $f.f$i.b$bnum -text $j -command [list $t insert insert "$j\("] \
		    -width 7 -bd 1 -padx 0 -pady 0 -takefocus 0
	    pack $f.f$i.b$bnum -side top -fill x
	    if {[string length $j] == 0} {
		$f.f$i.b$bnum configure -state disabled
	    }
	    incr bnum
	}
    }
}

proc Fx:BuildRanges {f t} {
    set col1 {@range}
    set col2 {@row}
    set col3 {@col}
    set col4 {@cell}
    for {set i 1} {$i <= 4} {incr i} {
	frame $f.f$i -bd 0
	pack $f.f$i -side left -expand on -fill x
	set bnum 1
	foreach j [set col$i] {
	    button $f.f$i.b$bnum -text $j -command [list $t insert insert "$j\("] \
		    -width 7 -bd 1 -padx 0 -pady 0 -takefocus 0
	    pack $f.f$i.b$bnum -side top -fill x
	    if {[string length $j] == 0} {
		$f.f$i.b$bnum configure -state disabled
	    }
	    incr bnum
	}
    }
}

proc Fx:BuildNumericFunctions {f t} {
    set col1 {@cellval @sqrt @exp @ln}
    set col2 {@log @floor @ceil @rnd}
    set col3 {@round @abs @pow @degrees}
    set col4 {@radians @sin @cos @tan}
    set col5 {@asin @acos @atan @atan2}
    set col6 {@hypot @if "" ""}
    for {set i 1} {$i <= 6} {incr i} {
	frame $f.f$i -bd 0
	pack $f.f$i -side left -expand on -fill x
	set bnum 1
	foreach j [set col$i] {
	    button $f.f$i.b$bnum -text $j -command [list $t insert insert "$j\("] \
		    -width 9 -bd 1 -padx 0 -pady 0 -takefocus 0
	    pack $f.f$i.b$bnum -side top -fill x
	    if {[string length $j] == 0} {
		$f.f$i.b$bnum configure -state disabled
	    }
	    incr bnum
	}
    }
}

proc Fx:BuildLogicalOperators {f t} {
    set col1 {< <= =}
    set col2 {> >= !=}
    set col3 {! & |}
    for {set i 1} {$i <= 3} {incr i} {
	frame $f.f$i -bd 0
	pack $f.f$i -side left -expand on -fill x
	set bnum 1
	foreach j [set col$i] {
	    button $f.f$i.b$bnum -text $j -command [list $t insert insert "$j"] \
		    -width 3 -bd 1 -padx 0 -pady 0 -takefocus 0
	    pack $f.f$i.b$bnum -side top -fill x
	    if {[string length $j] == 0} {
		$f.f$i.b$bnum configure -state disabled
	    }
	    incr bnum
	}
    }
}

proc Fx:BuildConstants {f t {context 1}} {
    set consts {}
    if {$context} {
	lappend consts @thisrow
	lappend consts @thiscol
    }
    lappend consts @maxrow
    lappend consts @maxcol
    frame $f.f0 -bd 0
    pack $f.f0 -side left -expand on -fill x
    set bnum 1
    foreach j [set consts] {
	button $f.f0.b$bnum -text $j -command [list $t insert insert "$j"] \
		-width 9 -bd 1 -padx 0 -pady 0 -takefocus 0
	pack $f.f0.b$bnum -side left -expand on -fill x
	incr bnum
    }
}

# Fx:UserDefinedFields - define a new field on a set of tables
proc Fx:UserDefinedFields {olddefs hold tables} {
    global fx_blt fx_userdef fx_config

    if {$fx_blt} {
	foreach i $hold {
	    blt::busy hold $i
	}
    }
    catch {unset fx_userdef}
    set u .userdef
    toplevel $u
    wm withdraw $u
    wm title $u "Define new field" 
    if {[info exists fx_config(geom,\$user_def\$)]} {
	wm geometry $u $fx_config(geom,\$user_def\$)
    }
    set name [lindex $olddefs 0]
    set verb [lindex $olddefs 1]
    set value  [lindex $olddefs 2]
    set precision [lindex $olddefs 3]

    frame $u.f0 -relief sunken -bd 2
    pack $u.f0 -side top -fill x
    label $u.f0.l -relief flat -bd 2 -text "Field name:" -anchor e -width 13
    pack $u.f0.l -side left
    entry $u.f0.e -relief sunken -bd 2
    $u.f0.e insert 0 $name
    $u.f0.e configure -state disabled
    pack $u.f0.e -side left -expand on -fill x
    frame $u.f1 -relief sunken -bd 2
    pack $u.f1 -side top -fill x
    label $u.f1.l -relief flat -bd 2 -text "Field title:" -anchor e -width 13
    pack $u.f1.l -side left
    entry $u.f1.e -relief sunken -bd 2 -textvariable fx_userdef(title)
    pack $u.f1.e -side left -expand on -fill x
    $u.f1.e insert 0 $verb

    set f $u.f2
    frame $f -relief sunken -bd 2
    pack $f -side top
    frame $f.calc -relief flat -bd 2
    pack $f.calc -side left -fill x
    frame $f.opt -relief flat -bd 2
    pack $f.opt -side right
    label $f.calc.l1 -text "Numeric Operators" -relief raised -bd 1
    pack $f.calc.l1 -side top -fill x
    frame $f.calc.f1 -relief sunken -bd 2
    pack $f.calc.f1 -side top -fill x
    Fx:BuildCalculator $f.calc.f1 $u.f_text.t
    label $f.calc.l2 -text "Logical Operators" -relief raised -bd 1
    pack $f.calc.l2 -side top -fill x
    frame $f.calc.f2 -relief sunken -bd 2
    pack $f.calc.f2 -side top -fill x
    Fx:BuildLogicalOperators $f.calc.f2 $u.f_text.t
    frame $f.calc.f3 -relief sunken -bd 2
    pack $f.calc.f3 -side top -fill x
    label $f.calc.f3.l -text "Precision:" -anchor e
    pack $f.calc.f3.l -side left
    entry $f.calc.f3.e -width 5
    pack $f.calc.f3.e -side left
    if {[string length $precision] == 0} {
	$f.calc.f3.e insert 0 2
    } else {
	$f.calc.f3.e insert 0 $precision
    }
    set f $f.opt
    label $f.l0 -text "Range Functions"
    pack $f.l0 -side top -fill x
    frame $f.f0
    pack $f.f0 -side top -fill x
    Fx:BuildRangeFunctions $f.f0 $u.f_text.t

    label $f.l1 -text "Ranges"
    pack $f.l1 -side top -fill x
    frame $f.f1
    pack $f.f1 -side top -fill x
    Fx:BuildRanges $f.f1 $u.f_text.t

    label $f.l2 -text "Numeric Functions"
    pack $f.l2 -side top -fill x
    frame $f.f2
    pack $f.f2 -side top -fill x
    Fx:BuildNumericFunctions $f.f2 $u.f_text.t

    label $f.l3 -text "Constants"
    pack $f.l3 -side top -fill x
    frame $f.f3
    pack $f.f3 -side top -fill x
    Fx:BuildConstants $f.f3 $u.f_text.t

    set f $u.f_text
    frame $f
    pack $f -side top -expand on -fill both
    text $f.t -yscroll "$f.s set" -relief sunken -bd 2 -width 1 -height 1
    pack $f.t -side left -expand on -fill both
    scrollbar $f.s -command "$f.t yview" -relief sunken
    pack $f.s -side right -fill y
    $f.t insert 0.0 $value

    set f $u.f_last
    frame $f
    pack $f -side top -fill x
    button $f.ok -text Ok -command {
	if {[Fx:CheckExpression 0] == 1} {
	    set title [.userdef.f1.e get]
	    if {[string length [string trim $title]] == 0} {
		set title [.userdef.f0.e get]
	    }
	    set fx_userdef(result) [list [.userdef.f0.e get] \
		    $title [.userdef.f_text.t get 0.0 end] \
		    [.userdef.f2.calc.f3.e get]]
	    destroy .userdef
	} else {
	    fx_dialog .userdef.dialog "Check results" \
		    "The current expression is invalid!  You must enter a valid expression or cancel." \
		    error 0 Ok
	}
    }
    pack $f.ok -side left -padx 5m -pady 2m
    button $f.check -text "Check expression" -command Fx:CheckExpression
    pack $f.check -side left -padx 5m -pady 2m
    button $f.cancel -text Cancel -command {
	set fx_userdef(result) {}
	destroy .userdef
    }
    pack $f.cancel -side right -padx 5m -pady 2m
    button $f.view -text "View tables/attributes" -command [list Fx:UserDefinedViewTable $tables]
    pack $f.view -side right -padx 5m -pady 2m
    wm deiconify .userdef
    update
    update idletasks
    bind $u <Configure> {
	update idletasks
	update
	set fx_config(geom,\$user_def\$) [wm geometry .userdef]
    }
    if {[info exists fx_config(isup,\$user_def_tbl\$)]} {
	Fx:UserDefinedViewTable $tables
	if {[winfo exists .userdef]} {
	    focus .userdef
	}
    }
    tkwait window .userdef

    catch "delete object userdef_attrs"
    catch "delete object userdef_tables"

    if {$fx_blt} {
	foreach i $hold {
	    catch "blt::busy forget $i"
	}
    }
    return $fx_userdef(result)
}

