
itcl_class Fx_QddbSearchParser {
    proc IsANumber {n} {
	return [expr [catch [list expr double($n)]] == 0]
    }
    proc IsADate {dt} {
	return [qddb_util isdate $dt]
    }
    proc IsAWord {w} {
	set w [string trim $w]
	set res [regexp -nocase {[a-z0-9]*\.?} $w nw]
	if {[string compare $w $nw] == 0} {
	    return 1
	}
	return 0
    }
    proc IsARange {r} {
	set r [split $r "-"]
	set len [llength $r]
	if {$len == 2} {
	    return 1
	} elseif {$len > 2 && $len < 5} {
	    foreach i $r {
		if {[llength $i] != 0 && [catch [list expr double($i)]] != 0} {
		    return 0
		}
	    }
	    return 1
	}
	return 0
    }
    proc Singlett {schema s pruneby} {
	global fx_config fx_excludewords

	if {([string compare $pruneby any] == 0 || ([info exists fx_config(\$range_search\$,$pruneby)] && \
		 $fx_config(\$range_search\$,$pruneby) == 1)) && [IsARange $s]} {
	    set r [split $s "-"]
	    set r1 [lindex $r 0]
	    if {[llength $r1] == 0} {
		set r1 -[lindex $r 1]
		set spot 2
	    } else {
		set spot 1
	    }
	    set r2 [lindex $r $spot]
	    if {[llength $r2] == 0} {
		set r2 -[lindex $r [expr $spot + 1]]
	    }
	    if {[string compare $pruneby any] != 0 && \
		    [info exists fx_config(\$date_search\$,$pruneby)] && \
		    $fx_config(\$date_search\$,$pruneby) == 1 && \
		    [string compare [qddb_schema option type $schema $pruneby] date] == 0 && \
		    [IsADate $r1] && [IsADate $r2]} {
		set validrange 1
		set rangetype dr
		set r1 "$r1 12:00AM"
		set r2 "$r2 11:59PM"
	    } elseif {[IsANumber $r1] && [IsANumber $r2] && \
			  ([string compare $pruneby any] == 0 || \
			       ([info exists fx_config(\$numeric_search\$,$pruneby)] && \
				    $fx_config(\$numeric_search\$,$pruneby) == 1))} {
		set validrange 1
		set rangetype nr
	    } elseif {[IsAWord $r1] && [IsAWord $r2]} {
		set validrange 1
		set rangetype wr
	    } else {
		set validrange 0
	    }
	    if {$validrange} {
		if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby \
					    $rangetype $r1 - $r2]} ret_error]} {
		    error $ret_error
		} else {
		    return $retval
		}
	    } elseif {[string compare $pruneby any] == 0 || \
			   ([info exists fx_config(\$regexp_search\$,$pruneby)] && \
				$fx_config(\$regexp_search\$,$pruneby) == 1)} {
		if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby r $s]} ret_error]} {
		    error $ret_error
		} else {
		    return $retval
		}
	    } else {
		if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby w $s]} ret_error]} {
		    error $ret_error
		} else {
		    return $retval
		}
	    }
	} elseif {[string compare $pruneby any] != 0 && \
		      [string compare [qddb_schema option type $schema $pruneby] date] == 0 && \
		      [info exists fx_config(\$date_search\$,$pruneby)] && \
		      $fx_config(\$date_search\$,$pruneby) == 1 && \
		      [IsADate $s] == 1} {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby dr \
					"$s 12:00AM" - "$s 11:59PM"]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	} elseif {[IsANumber $s] == 1 && \
		      ([info exists fx_config(\$numeric_search\$,$pruneby)] && \
		       $fx_config(\$numeric_search\$,$pruneby) == 1)} {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby n $s]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	} elseif {[IsAWord $s] == 1} {
	    if {[info exists fx_excludewords([string tolower $s])]} {
		error "The word '$s' is excluded from indexing and will produce no matches"
	    }
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby w $s]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	} elseif {[string compare $pruneby any] == 0 || \
		      ([info exists fx_config(\$regexp_search\$,$pruneby)] && \
			   $fx_config(\$regexp_search\$,$pruneby) == 1)} {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby r $s]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	} else {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby w $s]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	}
    }
    proc Intersection {schema s1 s2 exact pruneby} {
	set k1 [MultiSearch $schema $s1 $exact $pruneby]
	if {[llength $k1] > 1} {
	    return $k1
	}
	set k2 [MultiSearch $schema $s2 $exact $pruneby]
	if {[llength $k2] > 1} {
	    return $k2
	}
	return [qddb_keylist op intersection -exact $exact $k1 $k2]
    }
    proc Union {schema s1 s2 exact pruneby} {
	set k1 [MultiSearch $schema $s1 $exact $pruneby]
	if {[llength $k1] > 1} {
	    return $k1
	}
	set k2 [MultiSearch $schema $s2 $exact $pruneby]
	if {[llength $k2] > 1} {
	    return $k2
	}
	return [qddb_keylist op union -exact $exact $k1 $k2]
    }
    proc Exclusion {schema s1 s2 exact pruneby} {
	set k1 [MultiSearch $schema $s1 $exact $pruneby]
	if {[llength $k1] > 1} {
	    return $k1
	}
	set k2 [MultiSearch $schema $s2 $exact $pruneby]
	if {[llength $k2] > 1} {
	    return $k2
	}
	return [qddb_keylist op exclusion -exact $exact $k1 $k2]
    }
    proc BinaryOp {schema s1 op s2 exact pruneby} {
	switch -exact $op {
	    " " {return [Intersection $schema $s1 $s2 $exact $pruneby]}
	    "," {return [Union $schema $s1 $s2 $exact $pruneby]}
	    "!" {return [Exclusion $schema $s1 $s2 $exact $pruneby]}
	    default {return [Intersection $schema $s1 $s2 $exact $pruneby]}
	}
    }
    proc MultiSearch {schema s {exact off} {pruneby any}} {
	set len [llength $s]
	if {$len == 0} {
	    return {}
	}
	if {$len == 3 && [string match {[!,]} [string trim [lindex $s 1]]]} {
	    set result [BinaryOp $schema [lindex $s 0] [lindex $s 1] [lindex $s 2] $exact $pruneby]
	} elseif {$len == 2} {
	    set result [BinaryOp $schema [lindex $s 0] " " [lindex $s 1] $exact $pruneby]
	} else {
	    set result [Singlett $schema [lindex $s 0] $pruneby]
	    if {[llength $result] > 1} {
		return $result
	    }
	    for {set i 1} {$i < $len} {incr i} {
		if {[catch {
		    switch -exact [lindex $s $i] {
			"," {
			    incr i
			    set nresult [MultiSearch $schema [lindex $s $i] $exact $pruneby]
			    if {[llength $nresult] > 1} {
				return $nresult
			    }
			    set result [qddb_keylist op union -exact $exact $result $nresult]
			}
			"!" {
			    incr i
			    set nresult [MultiSearch $schema [lindex $s $i] $exact $pruneby]
			    if {[llength $nresult] > 1} {
				return $nresult
			    }
			    set result [qddb_keylist op exclusion -exact $exact $result $nresult]
			}
			default {
			    set nresult [MultiSearch $schema [lindex $s $i] $exact $pruneby]
			    if {[llength $nresult] > 1} {
				return $nresult
			    }
			    set result [qddb_keylist op intersection -exact $exact $result $nresult]
			}
		    }
		} ret_error]} {
		    error "Bad query, respecify."
		}
	    }
	}
	return $result
    }
}
if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_search.tcl"
}
