
proc Fx:InitResources {} {
    global fx_font fx_classes fx_font_config

    if {![info exists fx_font]} {
	foreach i $fx_classes {
	    set fx_font($i) -*-$fx_font_config(default_family)-$fx_font_config(default_weight)-[string index $fx_font_config(default_slant) 0]-*-*-*-[lindex $fx_font_config(sizes) [lsearch -exact $fx_font_config(sizenames) $fx_font_config(default_size)]]-*-*-*-*-*-*
	    option add "*$i.font" $fx_font($i)
	}
	set fx_font(Listbox) -*-courier-bold-r-*-*-*-140-*-*-*-*-*-*
	option add *Listbox.Font -*-courier-bold-r-*-*-*-140-*-*-*-*-*-*
    } else {
	foreach i [array names fx_font] {
	    if {[info exists fx_font($i)]} {
		option add "*$i.font" $fx_font($i)
	    }
	}
    }
}

set fx_resources {
    Button.activeForeground
    Button.activeBackground
    Button.background
    Button.foreground
    Button.disabledForeground
    Button.font
    Canvas.background
    Canvas.foreground
    Canvas.selectBackground
    Canvas.selectForeground
    Checkbutton.activeBackground
    Checkbutton.activeForeground
    Checkbutton.background
    Checkbutton.foreground
    Checkbutton.disabledForeground
    Checkbutton.font
    Entry.background
    Entry.foreground
    Entry.font
    Entry.selectBackground
    Entry.selectForeground
    Frame.background
    Label.background
    Label.foreground
    Label.font
    Listbox.background
    Listbox.foreground
    Listbox.font
    Listbox.selectBackground
    Listbox.selectForeground
    Menu.activeBackground
    Menu.activeForeground
    Menu.background
    Menu.foreground
    Menu.font
    Menu.disabledForeground
    Menubutton.activeBackground
    Menubutton.activeForeground
    Menubutton.background
    Menubutton.foreground
    Menubutton.disabledForeground
    Menubutton.font
    Message.background
    Message.foreground
    Message.font
    Radiobutton.activeBackground
    Radiobutton.activeForeground
    Radiobutton.background
    Radiobutton.foreground
    Radiobutton.disabledForeground
    Radiobutton.font
    Scale.activeForeground
    Scale.background
    Scale.foreground
    Scale.font
    Scrollbar.activeForeground
    Scrollbar.background
    Scrollbar.foreground
    Scrollbar.Width
    Text.background
    Text.foreground
    Text.font
    Text.selectBackground
    Text.selectForeground
}

set fx_classes {
    Button
    Canvas
    Checkbutton
    Entry
    Frame
    Label
    Listbox
    Menu
    Menubutton
    Message
    Radiobutton
    Scale
    Scrollbar
    Text
}
if {[string compare [info commands tktable] tktable] == 0} {
    lappend fx_classes TkTable
    lappend fx_resources TkTable.background TkTable.foreground TkTable.font
}
if {[string compare [info commands tix] tix] == 0} {
    lappend fx_resources TixNoteBookFrame.background TixNoteBookFrame.inactiveBackground \
	    TixNoteBookFrame.backPageColor TixNoteBookFrame.font
    lappend fx_classes TixNoteBookFrame
    tix config -scheme TK -fontset TK
    tix resetoptions TK TK
}
set fx_classes [lsort $fx_classes]
if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_resources.tcl"
}
