# fx_report.tcl
#
# Report generator routines


proc Fx:Report_RunExpertSearchWindow {schema} {
    global fx_report
 
    if {[info exists fx_report(expert_search,$fx_report(current_search))]} {
	set fx_report(expert_search) $fx_report(expert_search,$fx_report(current_search))
    } elseif {![info exists fx_report(expert_search)]} {
	set fx_report(expert_search) ""
    }
    if {[info exists fx_report(expert_search_title,$fx_report(current_search))]} {
	set fx_report(expert_search_title) $fx_report(expert_search_title,$fx_report(current_search))
    } elseif {![info exists fx_report(expert_search_title)]} {
	set fx_report(expert_search_title) ""
    }
    if {[catch [list Fx:ExpertSearchWindow .fx_report_expert $schema "" \
	    $fx_report(expert_search) 0 1 $fx_report(expert_search_title)] l] != 0} {
	Fx:Dialog "Error" $l .fx_reportgen.dialog
	return 0
    }
    if {[lindex $l 0] == 1} {
	set fx_report(expert_search) [lindex $l 1]
	set fx_report(expert_search_title) [lindex $l 2]
	set fx_report(expert_search,$fx_report(current_search)) \
		$fx_report(expert_search)
	set fx_report(expert_search_title,$fx_report(current_search)) \
		$fx_report(expert_search_title)
	return 1
    } else {
	return 0
    }
}

proc Fx:Report_RunConfigureSearchResults {schema} {
    global fx_rconfig fx_report fx_blt

    Fx:BusyExec .fx_reportgen [list Fx:ConfigureSearchResults \
	    $schema "" 0 fx_rconfig fx_report_column_defs "Column definitions"]
}

proc Fx:Report_SearchProc {keylist} {
    global fx_rconfig

    set k $keylist
    set klen [qddb_keylist length $k]
    if {$klen > 0} {
	set pa \$search\$,print
	set print_attrs {}
	set user_attrs {}
	foreach i $fx_rconfig($pa) {
	    if {"[string index $i 0]" != "\$"} {
		lappend print_attrs $i
	    } else {
		lappend user_attrs $i
	    }
	}
	set pa \$search\$,sortby
	set sort_attrs {}
	foreach i $fx_rconfig($pa) {
	    if {"[string index $i 0]" != "\$"} {
		lappend sort_attrs $i
	    }
	}
	set asc {}
	set asc_attrs {}
	set x 0
	foreach i $fx_rconfig(\$search\$,ascending) {
	    if {[string compare $i yes] == 0} {
		set thisasc [lindex $fx_rconfig(\$search\$,sortby) $x]
		lappend asc $thisasc
		if {"[string index $thisasc 0]" != "\$"} {
		    lappend asc_attrs $thisasc
		}
	    }
	    incr x
	}
	update idletasks; update
	if {[llength $user_attrs] == 0} {
	    if {[info exists fx_rconfig(\$search\$,unsorted)] && \
		    $fx_rconfig(\$search\$,unsorted)} {
		set last_search [qddb_rows select -format table \
			-flush on -rowdescs off \
			-print $print_attrs $k]
		if {[string length $last_search] > 0} {
		    Fx:UserDefinedTable $last_search \$search\$ fx_rconfig
		}
	    } else {
		set last_search [qddb_rows select -format table \
			-flush on -rowdescs off \
			-ascending $asc -sortby $fx_rconfig(\$search\$,sortby) \
			-print $print_attrs $k]
		if {[string length $last_search] > 0} {
		    Fx:UserDefinedTable $last_search \$search\$ fx_rconfig
		}
	    }
	} else {
	    if {[info exists fx_rconfig(\$search\$,unsorted)] && \
		    $fx_rconfig(\$search\$,unsorted)} {
		set last_search [qddb_rows select -format table \
			-flush on -rowdescs off \
			-print $print_attrs $k]
		if {[string length $last_search] > 0} {
		    Fx:UserDefinedTable $last_search \$search\$ fx_rconfig
		}
	    } else {
		set last_search [qddb_rows select -format table \
			-flush on -rowdescs off \
			-sortby $sort_attrs \
			-ascending $asc_attrs \
			-print $print_attrs $k]
		if {[string length $last_search] > 0} {
		    Fx:UserDefinedTable $last_search \$search\$ fx_rconfig
		    if {![info exists fx_rconfig(\$search\$,unsorted)] || \
			    !$fx_rconfig(\$search\$,unsorted)} {
			qddb_table sort $last_search -ascending $asc \
				-sortby $fx_rconfig(\$search\$,sortby)
		    }
		}
	    }
	}
	qddb_keylist delete $k
    }
    if {[info exists last_search]} {
	return $last_search
    } else {
	return ""
    }
}

proc Fx:ConfigReportTypes {schema f} {
    global fx_config fx_rconfig fx_report fx_emailsetup fx_blt

    if {[info exists fx_rconfig(\$search\$,print)] \
	    && [info exists fx_config(\$reports\$,\$return_address\$)]} {
	set retaddr 1
    } else {
	set retaddr 0
    }
    if {[info exists fx_rconfig(\$search\$,print)] \
	    && [info exists fx_config(\$reports\$,\$destination_address\$)]} {
	set destaddr 1
    } else {
	set destaddr 0
    }
    if {[info exists fx_emailsetup(attribute)] && \
	    [string length $fx_emailsetup(attribute)] > 0} {
	if {[info exists fx_rconfig(\$search\$,print)] && \
		[lsearch -exact $fx_rconfig(\$search\$,print) $fx_emailsetup(attribute)] == -1} {
	    set emailaddr 0
	} else {
	    set emailaddr 1
	}
    } else {
	set emailaddr 0
    }
    if {$fx_blt} {
	if {[info exists fx_rconfig(\$search\$,print)]} {
	    set graphics 0
	    foreach i $fx_rconfig(\$search\$,print) {
		if {[string compare [string index $i 0] \$] == 0} {
		    set graphics 1
		    break
		}
		if {[catch "qddb_schema option type $schema $i" type] != 0} {
		    continue
		}
		if {[string compare $type integer] == 0 || [string compare $type real] == 0} {
		    set graphics 1
		    break
		}
	    }
	}
	if {!$graphics} {
	    set fx_report(print_graph) 0
	    set fx_report(print_barchart) 0
	    $f.pr.f1.graph configure -state disabled
	    $f.setup.graph configure -state disabled
	    $f.pr.f1.barchart configure -state disabled
	    $f.setup.barchart configure -state disabled
	} else {
	    $f.pr.f1.graph configure -state normal
	    $f.setup.graph configure -state normal
	    $f.pr.f1.barchart configure -state normal
	    $f.setup.barchart configure -state normal
	}
    }
    if {!$retaddr || !$destaddr} {
	set fx_report(print_postcards) 0
	set fx_report(print_letters) 0
	$f.pr.f0.postcards configure -state disabled
	$f.pr.f0.letters configure -state disabled
	$f.setup.postcards configure -state disabled
	$f.setup.letters configure -state disabled
    } else {
	$f.pr.f0.postcards configure -state normal
	$f.pr.f0.letters configure -state normal
	$f.setup.postcards configure -state normal
	$f.setup.letters configure -state normal
    }
    if {!$emailaddr} {
	set fx_report(print_email) 0
	$f.pr.f0.email configure -state disabled
	$f.setup.email configure -state disabled
    } else {
	$f.pr.f0.email configure -state normal
	$f.setup.email configure -state normal
    }
}
proc Fx:Report_ReadFromFile {schema f restrict} {
    global fx_rconfig fx_report fx_config fx_reportlisting

    foreach i {letter postcard email graph barchart} {
	global fx_${i}setup
    }
    set dir $restrict/:report_generator:
    set file [Fx:RestrictedFileSelect .readsetup r $dir]
    if {[string length $file] == 0} {
	return
    }
    if {[info exists fx_rconfig]} {
	unset fx_rconfig
    }
    if {[info exists fx_report]} {
	unset fx_report
	set fx_report(print_listing) 1
	set fx_report(current_search) 1
	set fx_report(next_search) 2
	set fx_report(expert_search) {}
	set fx_report(expert_search_title) {}
	set fx_report(title) {}
    }
    if {[info exists fx_reportlisting]} {
	unset fx_reportlisting
    }
    set fx_report(expert_search) ""
    uplevel \#0 [list source $file]
    if {![info exists fx_report(expert_search,$fx_report(current_search))]} {
	set fx_report(expert_search,$fx_report(current_search)) $fx_report(expert_search)
	set fx_report(expert_search_title,$fx_report(current_search)) $fx_report(expert_search_title)
    }
    Fx:ConfigReportTypes $schema $f
}

proc Fx:Report_WriteToFile {schema f restrict} {
    global fx_rconfig fx_report

    if {[string length $fx_report(expert_search)] == 0 || ![info exists fx_rconfig]} {
	Fx:Dialog "No report specified" \
		"You must specify search criteria and results format" .fx_reportgen.dialog
	return
    }
    set dir $restrict/:report_generator:
    set file [Fx:RestrictedFileSelect .readsetup w $dir]
    if {[string length $file] == 0} {
	return
    }
    set fd [open $file w]
    foreach i [array names fx_rconfig] {
	puts $fd [list set fx_rconfig($i) $fx_rconfig($i)]
    }
    foreach i [array names fx_report] {
	puts $fd [list set fx_report($i) $fx_report($i)]
    }
    foreach i {letter postcard email graph barchart} {
	global fx_${i}setup
	if {[info exists fx_${i}setup]} {
	    foreach j [array names fx_${i}setup] {
		puts $fd [list set fx_${i}setup($j) [set fx_${i}setup($j)]]
	    }
	}
    }
    close $fd
}

proc Fx:Report_Clear {f} {
    global fx_rconfig fx_report fx_reportlisting fx_blt \
	    fx_graph_setup fx_barchart_setup

    foreach i {letter postcard email} {
	global fx_${i}setup
	catch "unset fx_${i}setup(value)"
    }
    if {$fx_blt} {
	foreach i {graph barchart} {
	    global fx_${i}setup
	    catch "unset fx_${i}setup"
	}
    }
    catch {unset fx_rconfig}
    catch {unset fx_report}
    catch {unset fx_reportlisting}
    catch {unset fx_graph_setup}
    catch {unset fx_barchart_setup}
    if {[winfo exists $f]} {
	$f.pr.f0.postcards configure -state disabled
	$f.pr.f0.letters configure -state disabled
	$f.pr.f0.email configure -state disabled
	$f.pr.f1.graph configure -state disabled
	$f.pr.f1.barchart configure -state disabled
	$f.setup.postcards configure -state disabled
	$f.setup.letters configure -state disabled
	$f.setup.graph configure -state disabled
	$f.setup.barchart configure -state disabled
    }
    set fx_report(print_listing) 1
    set fx_report(current_search) 1
    set fx_report(next_search) 2
    set fx_report(expert_search,1) {}
    set fx_report(expert_search_title,1) {}
    set fx_report(expert_search) {}
    set fx_report(expert_search_title) {}
    set fx_report(title) {}
}

proc Fx:Report_DisplaySelectProc {w} {
    global fx_display_searches_listbox_retval
    set fx_display_searches_listbox_retval 1
}

proc Fx:Report_DisplaySearches {w b} {
    global fx_display_searches_listbox_retval \
	    fx_display_info fxPriv fx_report

    set oldGrab [grab current $w]
    set oldFocus [focus]
    set parent [winfo toplevel $b]
    set f $parent.attr
    toplevel $f -cursor arrow
    wm transient $f $parent
    wm overrideredirect $f 1
    wm withdraw $f
    frame $f.ft -takefocus 0 -highlightthickness 0
    pack $f.ft -side top -expand on -fill both
    set x $f.ft
    Fx_MultiColumnListBox fx_display_searches_listbox -w $x.f -side top -numcols 2 \
	    -width 25 -headings {# "Search Title"} \
	    -align {left left} -single_select on -separators {" " " "} \
	    -initselection on \
	    -height 5 -onselect Fx:Report_DisplaySelectProc
    frame $f.b -takefocus 0 -highlightthickness 0 -relief groove -bd 3
    pack $f.b -side bottom -expand on -fill x
    button $f.b.select -text Select -command {set fx_display_searches_listbox_retval 1}
    pack $f.b.select -side left -padx 4m -pady 2m
    button $f.b.cancel -text Cancel -command {set fx_display_searches_listbox_retval 0}
    pack $f.b.cancel -side right -padx 4m -pady 2m
    set fx_display_info {}
    set lst [array get fx_report expert_search_title,*]
    set max [llength $lst]
    for {set i 0} {$i < $max} {incr i 2} {
	set num [lindex [split [lindex $lst $i] ,] 1]
	set val($num) [lindex $lst [expr $i + 1]]
    }
    foreach i [lsort -integer [array names val]] {
	lappend fx_display_info [list $i $val($i)]
    }
    fx_display_searches_listbox AppendRows $fx_display_info
    fx_display_searches_listbox BuildFormats 1
    fx_display_searches_listbox Format
    fx_display_searches_listbox Display    
    set rootx [winfo rootx $b]
    set rooty [expr [winfo rooty $b]+[winfo height $b]]
    set screenheight [winfo screenheight $b]
    set screenwidth [winfo screenwidth $b]
    update idletasks
    set reqheight [winfo reqheight $f]
    set reqwidth [winfo reqwidth $f]
    if {[expr $rooty + $reqheight] > $screenheight} {
	set rooty [expr $rooty + $screenheight - $rooty - $reqheight]
    }
    if {[expr $rootx + $reqwidth] > $screenwidth} {
	set rootx [expr $rootx + $screenwidth - $rootx - $reqwidth]
    }
    wm geometry $f "+$rootx+$rooty"
    bind $f <Escape> "global fx_display_searches_listbox_retval; \
	    set fx_display_searches_listbox_retval 0"
    bind $x.f.l2 <Escape> "global fx_display_searches_listbox_retval; \
	    set fx_display_searches_listbox_retval 0"
    bind $f <Enter> [list set fxPriv(popup_listbox) ""]
    bind $f <Leave> [list set fxPriv(popup_listbox) $f]
    set fxPriv(popup_listbox) $f
    bind $f <ButtonPress> {
	if {[info exists fxPriv(popup_listbox)]} {
	    if {[string compare $fxPriv(popup_listbox) ""] != 0} {
		set fx_display_searches_listbox_retval 0
	    }
	}
    }
    wm deiconify $f
    tkwait visibility $f
    catch "grab -global $f"
    focus $x.f.l2
    tkwait variable fx_display_searches_listbox_retval
    if {$fx_display_searches_listbox_retval} {
	set var [lindex $fx_display_info [$x.f.l2 curselection]]
	set idx [lindex $var 0]
	set fx_report(expert_search) $fx_report(expert_search,$idx)
	set fx_report(current_search) $idx
	set fx_report(expert_search_title) $fx_report(expert_search_title,$idx)
    }
    delete object fx_display_searches_listbox
    catch "focus $oldFocus"
    catch "grab release $f"
    catch "grab $oldGrab"
    destroy $f
    update idletasks
    update
    catch "unset fxPriv(popup_listbox)"
}

proc Fx:Report_NewSearch {schema} {
    global fx_report

    set fx_report(expert_search,$fx_report(next_search)) ""
    set fx_report(expert_search_title,$fx_report(next_search)) ""
    set fx_report(expert_search) ""
    set fx_report(expert_search_title) ""
    set fx_report(current_search) $fx_report(next_search)
    incr fx_report(next_search)
    if {[Fx:BusyExec .fx_reportgen [list Fx:Report_RunExpertSearchWindow $schema]] == 0} {
	incr fx_report(next_search) -1
	catch "unset fx_report(expert_search,$fx_report(next_search))"
	catch "unset fx_report(expert_search_title,$fx_report(next_search))"
	set last [expr $fx_report(next_search) - 1]
	set fx_report(expert_search) $fx_report(expert_search,$last)
	set fx_report(expert_search_title) $fx_report(expert_search_title,$last)
	set fx_report(current_search) $last
    }
}

proc Fx:Report_DelSearch {} {
    global fx_report

    set current $fx_report(current_search)
    set next $fx_report(next_search)
    set lst [array get fx_report expert_search_title,*]
    catch "unset fx_report(expert_search_title)"
    catch "unset fx_report(expert_search)"
    if {$current == 1 && $next == 2} {
	set fx_report(expert_search,1) ""
	set fx_report(expert_search_title,1) ""
	set fx_report(expert_search) ""
	set fx_report(expert_search_title) ""
	return
    }
    set max [llength $lst]
    for {set i 0} {$i < $max} {incr i 2} {
	set num [lindex [split [lindex $lst $i] ,] 1]
	set val($num) [lindex $lst [expr $i + 1]]
    }
    foreach i [lsort -integer [array names val]] {
	if {$i == $current} {
	    catch "unset fx_report(expert_search,$i)"
	    catch "unset fx_report(expert_search_title,$i)"
	} elseif {$i > $current} {
	    set newval [expr $i - 1]
	    set fx_report(expert_search,$newval) $fx_report(expert_search,$i)
	    set fx_report(expert_search_title,$newval) $fx_report(expert_search_title,$i)
	}
    }
    catch "unset fx_report(expert_search,$i)"
    catch "unset fx_report(expert_search_title,$i)"
    while {$current > 0} {
	if {[info exists fx_report(expert_search,$current)]} {
	    break
	}
	incr current -1
    }
    if {$current <= 0} {
	if {![info exists fx_report(expert_search,1)]} {
	    set fx_report(expert_search,1) ""
	    set fx_report(expert_search_title,1) ""
	}
	set fx_report(expert_search) $fx_report(expert_search,1)
	set fx_report(expert_search_title) $fx_report(expert_search_title,1)
	set fx_report(current_search) 1
	set current 1
    }
    set fx_report(expert_search) $fx_report(expert_search,$current)
    set fx_report(expert_search_title) $fx_report(expert_search_title,$current)
    set fx_report(current_search) $current
    for {} {$i > 0} {incr i -1} {
	if {[info exists fx_report(expert_search,$i)]} {
	    break
	}
    }
    incr i
    set fx_report(next_search) $i
}

proc Fx:Report_Generator {schema restrict {title ""}} {
    global fx_rconfig fx_report fx_reportlisting qddb_library fx_blt

    set f .fx_reportgen
    if {[winfo exists $f]} {
	raise $f
	focus $f
	return
    }
    Fx:Report_Clear $f
    toplevel $f
    wm withdraw $f
    if {[string length $title] == 0} {
	wm title $f "Reports"
    } else {
	wm title $f $title
    }
    frame $f.f
    pack $f.f -side top -expand on -fill both
    frame $f.t -relief groove -bd 2
    pack $f.t -side top -expand on -fill x
    label $f.t.l -text "Report Title"
    pack $f.t.l -side top -expand on -fill x
    entry $f.t.e -textvariable fx_report(title)
    pack $f.t.e -side top -expand on -fill x
    focus $f.t.e

    frame $f.c -relief groove -bd 2
    pack $f.c -side top -expand on -fill x
    set f0 $f.c.f
    frame $f0
    pack $f0 -side top -expand on -fill x -padx 10m -pady 2m
    label $f0.l0 -text "Search criteria:"
    pack $f0.l0 -side left
    button $f0.b -bitmap @$qddb_library/fx/pixmaps/down.xbm -padx 0m -pady 0m \
	    -command [list Fx:Report_DisplaySearches $f $f0.b]
    pack $f0.b -side left
    button $f0.search -padx 0m -pady 0m -text "Edit" -command \
	    [list Fx:BusyExec $f [list Fx:Report_RunExpertSearchWindow $schema]]
    pack $f0.search -side left
    button $f0.new -padx 0m -pady 0m -text New -command \
	    [list Fx:BusyExec $f [list Fx:Report_NewSearch $schema]]
    pack $f0.new -side left
    button $f0.del -padx 0m -pady 0m -text Del -command Fx:Report_DelSearch
    pack $f0.del -side left
    label $f0.l -textvariable fx_report(current_search) -width 3
    pack $f0.l -side left
    entry $f0.e -textvariable fx_report(expert_search_title) -width 20 -state disabled
    pack $f0.e -side left -expand on -fill x
    set f1 $f.c.f1
    frame $f1
    pack $f1 -side top -expand on -fill x -padx 10m -pady 2m
    button $f1.format -text "Results format" -padx 10m \
	    -command [list after idle \
	    "Fx:Report_RunConfigureSearchResults $schema; Fx:ConfigReportTypes $schema $f"]
    pack $f1.format -side top -padx 5m -pady 2m

    frame $f.lo -relief groove -bd 2
    pack $f.lo -side top -expand on -fill x
    label $f.lo.l -text "Listing options (summary of numeric columns)"
    pack $f.lo.l -side top -expand on -fill x
    checkbutton $f.lo.sum -variable fx_reportlisting(sum) -text "Sum"
    pack $f.lo.sum -side left -expand on -fill x
    checkbutton $f.lo.avg -variable fx_reportlisting(avg) -text "Average"
    pack $f.lo.avg -side left -expand on -fill x
    checkbutton $f.lo.stddev -variable fx_reportlisting(stddev) -text "Std. Dev."
    pack $f.lo.stddev -side left -expand on -fill x
    checkbutton $f.lo.min -variable fx_reportlisting(min) -text "Min"
    pack $f.lo.min -side left -expand on -fill x
    checkbutton $f.lo.max -variable fx_reportlisting(max) -text "Max"
    pack $f.lo.max -side left -expand on -fill x

    frame $f.pr -relief groove -bd 2
    pack $f.pr -side top -expand on -fill x
    label $f.pr.l -text "Printing options"
    pack $f.pr.l -side top -expand on -fill x
    frame $f.pr.f0 -relief flat -bd 0
    pack $f.pr.f0 -side top -expand on -fill x
    checkbutton $f.pr.f0.listing -variable fx_report(print_listing) -text "Listing"
    pack $f.pr.f0.listing -side left -expand on -fill x
    checkbutton $f.pr.f0.postcards -variable fx_report(print_postcards) -text "Postcards"
    pack $f.pr.f0.postcards -side left -expand on -fill x
    checkbutton $f.pr.f0.letters -variable fx_report(print_letters) -text "Letters"
    pack $f.pr.f0.letters -side left -expand on -fill x
    checkbutton $f.pr.f0.email -variable fx_report(send_email) -text "E-mail"
    pack $f.pr.f0.email -side left -expand on -fill x
    if {$fx_blt} {
	frame $f.pr.f1 -relief flat -bd 0
	pack $f.pr.f1 -side top -expand on -fill x
	checkbutton $f.pr.f1.graph -variable fx_report(print_graph) -text "Graph"
	pack $f.pr.f1.graph -side left -expand on -fill x
	checkbutton $f.pr.f1.barchart -variable fx_report(print_barchart) -text "Barchart"
	pack $f.pr.f1.barchart -side left -expand on -fill x
	$f.pr.f1.graph configure -state disabled
	$f.pr.f1.barchart configure -state disabled
    }
    $f.pr.f0.postcards configure -state disabled
    $f.pr.f0.letters configure -state disabled
    $f.pr.f0.email configure -state disabled
    set fx_report(print_listing) 1

    frame $f.setup -relief groove -bd 2
    pack $f.setup -side top -expand on -fill x
    set se $f.setup
    label $se.l -text "Setup"
    pack $se.l -side top -expand on -fill x
    button $se.letters -text "Letters" \
	    -command [list Fx:BusyExec .fx_reportgen [list Fx:MessageInput $schema Letter $restrict 0]] \
	    -padx 1m -pady 0m
    pack $se.letters -side left -expand on -pady 2m
    button $se.postcards -text "Postcards" \
	    -command [list Fx:BusyExec .fx_reportgen [list Fx:MessageInput $schema PostCard $restrict 0]] \
	    -padx 1m -pady 0m
    pack $se.postcards -side left -expand on -pady 2m
    button $se.email -text "E-mail" \
	    -command [list Fx:BusyExec .fx_reportgen [list Fx:MessageInput $schema Email $restrict 0]] \
	    -padx 1m -pady 0m
    pack $se.email -side left -expand on -pady 2m
    if {$fx_blt} {
	button $se.graph -text "Graph" \
		-command [list Fx:BusyExec .fx_reportgen [list Fx:Graph_Setup $schema]] \
		-padx 1m -pady 0m
	pack $se.graph -side left -expand on -pady 2m
	button $se.barchart -text "Barchart" \
		-command [list Fx:BusyExec .fx_reportgen [list Fx:Barchart_Setup $schema]] \
		-padx 1m -pady 0m
	pack $se.barchart -side left -expand on -pady 2m
	$se.graph configure -state disabled
	$se.barchart configure -state disabled
    }
    $se.letters configure -state disabled
    $se.postcards configure -state disabled
    $se.email configure -state disabled

    frame $f.b
    pack $f.b -side bottom -expand on -fill x
    button $f.b.run -text "Run report" -command [list Fx:BusyExec .fx_reportgen \
	    [list Fx:Report_Run $schema $restrict]]
    set padx 5m
    set pady 4m
    pack $f.b.run -side left -padx $padx -pady $pady
    button $f.b.dismiss -text "Dismiss" -command [list destroy $f]
    pack $f.b.dismiss -side left -padx $padx -pady $pady
    button $f.b.clear -text "Clear" -command [list Fx:Report_Clear $f]
    button $f.b.read -text "Read from file" -command [list Fx:Report_ReadFromFile $schema $f $restrict]
    button $f.b.write -text "Write to file" -command [list Fx:Report_WriteToFile $schema $f $restrict]
    pack $f.b.write -side right -padx $padx -pady $pady
    pack $f.b.read -side right -padx $padx -pady $pady
    pack $f.b.clear -side right -padx $padx -pady $pady
    update idletasks
    wm minsize $f [winfo reqwidth $f] [winfo reqheight $f]
    wm maxsize $f [winfo reqwidth $f] [winfo reqheight $f]
    Fx:SetGeometry $f
    update idletasks
    wm deiconify $f
    fx_bindposition $f
    tkwait window $f
}

proc Fx:Report_BuildTable {schema num} {
    global fx_config fx_rconfig fx_report fx_blt fx_reportlisting

    if {[catch [list Fx:ExpertSearchParser $schema $fx_report(expert_search,$num)] l] != 0} {
	Fx:Dialog "Error" $l .fx_reportgen.dialog
	error $l
    }
    set k [lindex $l 1]
    if {[string length $k] == 0} {return ""}
    set tbl [Fx:Report_SearchProc $k]
    catch "qddb_keylist delete $k"
    return $tbl
}

proc Fx:Report_Run {schema restrict} {
    global fx_config fx_rconfig fx_report fx_blt fx_reportlisting

    if {[string length $fx_report(expert_search)] == 0 || \
	    ![info exists fx_rconfig]} {
	Fx:Dialog "No report specified" \
		"You must specify at least search criteria and results format" .fx_reportgen.dialog
	return
    }
    if {[llength $fx_rconfig(\$search\$,print)] == 0} {
	Fx:Dialog "No report specified" \
		"You must specify at least one column to print" .fx_reportgen.dialog
	return
    }
    set tables {}
    foreach i [array names fx_report expert_search,*] {
	set num [lindex [split $i ,] 1]
	if {[catch [list Fx:Report_BuildTable $schema $num] tbl] != 0} {
	    foreach j $tables {
		catch [list qddb_table delete $j]
	    }
	    return
	}
	if {[string length $tbl] == 0} {
	    continue
	} else {
	    lappend tables $tbl
	}
	set maxnum [qddb_table row maxnum $tbl]
	set listingoptions 0
	foreach i [lsort -ascii [array names fx_reportlisting]] {
	    if {$fx_reportlisting($i) == 1} {
		set listingoptions 1
		break
	    }
	}
	if {$listingoptions} {
	    set tbl2 [qddb_table define 0 1]
	    set maxcol [qddb_table col maxnum $tbl]
	    set x 2
	    for {set i 1} {$i <= $maxcol} {incr i} {
		switch -exact [qddb_table col cget $tbl $i -type] {
		    integer -
		    real - 
		    calc {
			set colname [qddb_table col cget $tbl $i -name]
			set coltitle [qddb_table col cget $tbl $i -title]
			set arr($x) $colname
			qddb_table col insert $tbl2
			qddb_table col configure $tbl2 $x -type calc -name $colname -title $coltitle \
				-precision 2 -justify right
			incr x
		    }
		}
	    }
	    set y 1
	    qddb_table col configure $tbl2 1 -title " " -justify right
	    foreach i [lsort -ascii [array names fx_reportlisting]] {
		qddb_table row insert $tbl2
		if {$fx_reportlisting($i) == 1} {
		    switch -exact $i {
			sum {
			    qddb_table cell setval $tbl2 $y 1 SUM
			}
			avg {
			    qddb_table cell setval $tbl2 $y 1 AVERAGE
			}
			stddev {
			    qddb_table cell setval $tbl2 $y 1 "STD. DEV."
			}
			min {
			    qddb_table cell setval $tbl2 $y 1 MIN
			}
			max {
			    qddb_table cell setval $tbl2 $y 1 MAX
			}
		    }
		    for {set j 2} {$j < $x} {incr j} {
			qddb_table cell configure $tbl2 $y $j \
				-calc "@${i}(@range($tbl,1,$arr($j):@maxrow,$arr($j)))"
		    }
		    incr y
		}
	    }
	    if {[info exists tbl2]} {
		if {[qddb_table col maxnum $tbl2] > 1} {
		    set txt2 [qddb_table getval $tbl2 -format text -coltitles on]
		} else {
		    set txt2 "No numeric fields, summary omitted."
		}
		catch "qddb_table delete $tbl2"
	    }
	}
	if {$fx_report(print_listing) == 1} {
	    set txt [qddb_table getval $tbl -format text -coltitles on \
		    -rowtitles $fx_rconfig(\$search\$,linenumbers)]
	    if {![info exists file_name]} {
		set file_name [TempNam]
		set fd [open $file_name w]
		if {[string length $fx_report(title)] > 0} {
		    puts $fd "\n\n[Fx:centerline $fx_report(title) 72]\n\n"
		}
	    }	 
	    if {[string length $fx_report(expert_search_title,$num)] > 0} {
		puts $fd "\n\n[Fx:centerline $fx_report(expert_search_title,$num) 72]\n"
	    }
	    puts $fd $txt
	    if {[info exists txt2]} {
		puts $fd "\n"
		puts $fd [Fx:centerline "Summary" 72]
		puts $fd "\n"
		puts $fd $txt2
	    }
	}
    }
    if {![info exists tables] || [llength $tables] == 0} {
	Fx:Dialog "No matches found" \
		"Nothing matches search criteria and format!" .fx_reportgen.dialog
	return
    }
    if {$fx_report(print_listing) == 1} {
	close $fd
	Fx_PrintDialog report_print_dialog -toplevel "" -title "$fx_report(title)"
	if {$fx_config(cancel_print) == 0} {
	    catch "Fx:PrintFile $file_name"
	    update idletasks
	    update
	}	
	catch "exec rm -f $file_name"
    }
    if {$fx_report(print_postcards) == 1} {
	Fx:PostCard_Print $schema $tables $restrict
    }
    if {$fx_report(print_letters) == 1} {
	Fx:Letter_Print $schema $tables $restrict
    }
    if {$fx_report(send_email) == 1} {
	Fx:Email_Send $schema $tables $restrict
    }
    if {$fx_blt} {
	if {$fx_report(print_graph) == 1} {
	    Fx:Graph_Print $schema $tables
	}
	if {$fx_report(print_barchart) == 1} {
	    Fx:Barchart_Print $schema $tables
	}
    }
    foreach tbl $tables {
	catch "qddb_table delete $tbl"
    }
}

