# fx_output.tcl
#
# Report output routines for postcards, letters, and e-mail

# Address setup

proc Fx:ReturnAddress_Setup {} {
    global fx_setup_config fx_config

    set r .returnaddr_setup
    if {[winfo exists $r]} {
	raise $r
	focus $r
	return
    }
    toplevel $r
    wm withdraw $r
    wm title $r "Return Address Setup"
    set f $r.f
    frame $f
    pack $f -side top -expand on -fill both
    label $f.l0 -text "Return address (as you want it to appear)" -anchor w
    pack $f.l0 -side top -expand on -fill x
    scrollbar $f.s -command [list $f.t yview] -takefocus 0
    pack $f.s -side right -fill y
    text $f.t -width 50 -height 7 -yscroll [list $f.s set]
    pack $f.t -side left -expand on -fill both
    set tbox $f.t
    if {[info exists fx_config(\$reports\$,\$return_address\$)]} {
	$tbox insert 0.0 $fx_config(\$reports\$,\$return_address\$)
    }
    set f $r.bot
    frame $f
    pack $f -side bottom -fill x
    button $f.ok -text Ok -command [list set fx_setup_config 1]
    pack $f.ok -side left -padx 5m -pady 2m
    button $f.cancel -text Cancel -command [list set fx_setup_config 0]
    pack $f.cancel -side right -padx 5m -pady 2m
    update idletasks
    wm minsize $r [winfo reqwidth $r] [winfo reqheight $r]
    wm maxsize $r [winfo reqwidth $r] [winfo reqheight $r]
    Fx:SetGeometry $r
    wm deiconify $r
    wm protocol $r WM_DELETE_WINDOW {set fx_setup_config 0}
    tkwait variable fx_setup_config
    Fx:SavePosition $r
    if {$fx_setup_config} {
	set fx_config(\$reports\$,\$return_address\$) [$tbox get 0.0 end]
    }
    destroy $r
}

proc Fx:DestinationAddress_Setup {s} {
    global fx_setup_config fx_config

    set r .destaddr_setup
    if {[winfo exists $r]} {
	raise $r
	focus $r
	return
    }
    toplevel $r
    wm withdraw $r
    wm title $r "Destination Address Setup"
    set f $r.f
    frame $f
    pack $f -side top -expand on -fill both
    label $f.l0 -text "Destination address (as you want it to appear)"
    pack $f.l0 -side top -expand on -fill x
    label $f.l1 -height 9 -text {You may use full attribute names or aliases enclosed in
"<>" to denote attribute values.   Each value must exist
in the search results to produce a letter or postcard.
Values enclosed in "<>" that are not aliases or attribute
names will appear verbatim in the return address.   For
easy attribute selection, view the attributes and aliases,
then use the middle mouse button to insert the selection
into the text box below.} -anchor w -justify left
    pack $f.l1 -side top -expand on -fill x
    label $f.l2 -height 7 -text {Example:

<title> <first> <last>, <suffix>
<street>
<city>, <state> <zip>
<country>} -anchor w -justify left
    pack $f.l2 -side top -expand on -fill x

    scrollbar $f.s -command [list $f.t yview] -takefocus 0
    pack $f.s -side right -fill y
    text $f.t -width 50 -height 7 -yscroll [list $f.s set]
    pack $f.t -side left -expand on -fill both
    set tbox $f.t
    bind $f.t <ButtonRelease-2> "Fx:Text_InsertAliasSelection $tbox %x %y; break"
    if {[info exists fx_config(\$reports\$,\$destination_address\$)]} {
	$tbox insert 0.0 $fx_config(\$reports\$,\$destination_address\$)
    }
    set f $r.bot0
    frame $f
    pack $f -side top -expand off -fill none
    button $f.view -text "View attributes and aliases" -command [list Fx:ViewAttributesAndAliases $s]
    pack $f.view -side left -padx 5m -pady 2m
    set f $r.bot
    frame $f
    pack $f -side bottom -fill x
    button $f.ok -text Ok -command [list set fx_setup_config 1]
    pack $f.ok -side left -padx 5m -pady 2m
    button $f.cancel -text Cancel -command [list set fx_setup_config 0]
    pack $f.cancel -side right -padx 5m -pady 2m
    update idletasks
    wm minsize $r [winfo reqwidth $r] [winfo reqheight $r]
    wm maxsize $r [winfo reqwidth $r] [winfo reqheight $r]
    Fx:SetGeometry $r
    wm deiconify $r
    wm protocol $r WM_DELETE_WINDOW {set fx_setup_config 0}
    tkwait variable fx_setup_config
    Fx:SavePosition $r
    if {$fx_setup_config} {
	set fx_config(\$reports\$,\$destination_address\$) [$tbox get 0.0 end]
    }
    destroy $r
}

# Postcard routines
proc Fx:PostCard_Setup {schema} {
    global fx_setup_config fx_postcardsetup \
	    fx_tmp_postcard_size \
	    fx_tmp_postcard_spacing \
	    fx_tmp_postcard_sep_column \
	    fx_tmp_postcard_width \
	    fx_tmp_postcard_return_tab \
	    fx_tmp_postcard_return_begin \
	    fx_tmp_postcard_max_toprint \
	    fx_tmp_postcard_freeform \
	    fx_tmp_postcard_separator

    set p .postcard_setup
    if {[winfo exists $p]} {
	raise $p
	focus $p
	return
    }
    set fx_tmp_postcard_size $fx_postcardsetup(size)
    set fx_tmp_postcard_spacing $fx_postcardsetup(spacing)
    set fx_tmp_postcard_sep_column $fx_postcardsetup(sep_column)
    set fx_tmp_postcard_width $fx_postcardsetup(width)
    set fx_tmp_postcard_return_tab $fx_postcardsetup(return_tab)
    set fx_tmp_postcard_return_begin $fx_postcardsetup(return_begin)
    set fx_tmp_postcard_freeform $fx_postcardsetup(freeform)
    set fx_tmp_postcard_max_toprint $fx_postcardsetup(max_toprint)
    set fx_tmp_postcard_separator $fx_postcardsetup(separator)
    toplevel $p
    wm withdraw $p
    wm title $p "Postcard Setup"
    frame $p.f
    pack $p.f -side top
    set f $p.f
    frame $f.f0 -relief groove -bd 2
    pack $f.f0 -side left -expand on -fill both
    set ff $f.f0
    set wid 35
    frame $ff.f0
    pack $ff.f0 -side top -expand on -fill x
    label $ff.f0.l -text "Total number of lines:" -width $wid -justify right -anchor e
    pack $ff.f0.l -side left -expand off -fill none
    entry $ff.f0.e -textvariable fx_tmp_postcard_size -width 4
    pack $ff.f0.e -side right -expand off -fill x
    fx_bindint $ff.f0.e
    fx_bindnotnull $ff.f0.e fx_tmp_postcard_size
    frame $ff.f1
    pack $ff.f1 -side top -expand on -fill x
    label $ff.f1.l -text "Blank lines at bottom of card:" -width $wid -justify right -anchor e
    pack $ff.f1.l -side left -expand off -fill none
    entry $ff.f1.e -textvariable fx_tmp_postcard_spacing -width 4
    pack $ff.f1.e -side right -expand off -fill x
    fx_bindint $ff.f1.e
    fx_bindnotnull $ff.f1.e fx_tmp_postcard_spacing
    frame $ff.f2
    pack $ff.f2 -side top -expand on -fill x
    label $ff.f2.l -text "Destination address begins at line:" -width $wid -justify right -anchor e
    pack $ff.f2.l -side left -expand off -fill none
    entry $ff.f2.e -textvariable fx_tmp_postcard_return_begin -width 4
    pack $ff.f2.e -side right -expand off -fill x
    fx_bindint $ff.f2.e
    fx_bindnotnull $ff.f2.e fx_tmp_postcard_return_begin
    frame $ff.f3
    pack $ff.f3 -side top -expand on -fill x
    label $ff.f3.l -text "Separator:" -width $wid -justify right -anchor e
    pack $ff.f3.l -side left -expand off -fill none
    entry $ff.f3.e -textvariable fx_tmp_postcard_separator -width 4
    pack $ff.f3.e -side right -expand off -fill x
    fx_bindnotnull $ff.f3.e fx_tmp_postcard_separator

    set wid 32
    frame $f.f1 -relief groove -bd 2
    pack $f.f1 -side right -expand on -fill both
    set ff $f.f1
    frame $ff.f0
    pack $ff.f0 -side top -expand on -fill x
    label $ff.f0.l -text "Total characters per line:" -width $wid -justify right -anchor e
    pack $ff.f0.l -side left -expand off -fill none
    entry $ff.f0.e -textvariable fx_tmp_postcard_width -width 4
    pack $ff.f0.e -side right -expand off -fill x
    fx_bindint $ff.f0.e
    fx_bindnotnull $ff.f0.e fx_tmp_postcard_width
    frame $ff.f1
    pack $ff.f1 -side top -expand on -fill x
    label $ff.f1.l -text "Separator begins at column:" -width $wid -justify right -anchor e
    pack $ff.f1.l -side left -expand off -fill none
    entry $ff.f1.e -textvariable fx_tmp_postcard_sep_column -width 4
    pack $ff.f1.e -side right -expand off -fill x
    fx_bindint $ff.f1.e
    fx_bindnotnull $ff.f1.e fx_tmp_postcard_sep_column
    frame $ff.f2
    pack $ff.f2 -side top -expand on -fill x
    label $ff.f2.l -text "Number of spaces from separator:\n(for destination address)" \
	    -width $wid -justify right -anchor e
    pack $ff.f2.l -side left -expand off -fill none
    entry $ff.f2.e -textvariable fx_tmp_postcard_return_tab -width 4
    pack $ff.f2.e -side right -expand off -fill x
    fx_bindint $ff.f2.e
    fx_bindnotnull $ff.f2.e fx_tmp_postcard_return_tab
    frame $ff.f3
    pack $ff.f3 -side top -expand on -fill x
    label $ff.f3.l -text "Free-form postcard:" -width $wid -justify right -anchor e
    pack $ff.f3.l -side left -expand off -fill none
    checkbutton $ff.f3.e -variable fx_tmp_postcard_freeform
    pack $ff.f3.e -side right -expand on -fill x

    set ff .postcard_setup.f3
    frame $ff -relief groove -bd 2
    pack $ff -side top -expand on -fill x
    label $ff.l -text "Number of postcards to print when testing:" -justify right
    pack $ff.l -side left -expand off -fill none
    entry $ff.e -textvariable fx_tmp_postcard_max_toprint -width 4
    pack $ff.e -side right -expand off -fill none
    fx_bindint $ff.e
    fx_bindnotnull $ff.e fx_tmp_postcard_max_toprint

    set ff .postcard_setup.f2
    frame $ff -relief groove -bd 2
    pack $ff -side bottom -expand on -fill x
    button $ff.ok -text "Ok" -command {set fx_setup_config 1}
    pack $ff.ok -side left -padx 8m -pady 2m
    button $ff.cancel -text "Cancel" -command {set fx_setup_config 0}
    pack $ff.cancel -side right -padx 8m -pady 2m

    update idletasks
    wm minsize $p [winfo reqwidth $p] [winfo reqheight $p]
    wm maxsize $p [winfo reqwidth $p] [winfo reqheight $p]
    Fx:SetGeometry $p
    wm deiconify $p
    set oldGrab [grab current $p]
    catch "grab $p"
    wm protocol .postcard_setup WM_DELETE_WINDOW {set fx_setup_config 0}
    tkwait variable fx_setup_config
    set wait 0
    while {$fx_setup_config == 1} {
	foreach i {size spacing sep_column width return_tab \
		max_toprint return_begin freeform} {
	    if {[catch "expr int([set fx_tmp_postcard_$i])"] != 0} {
		set wait 1
		bell
		break
	    }
	}
	if {[string length $fx_tmp_postcard_separator] == 0} {
	    set wait 1
	    bell
	}
	if {$wait} {
	    tkwait variable fx_setup_config
	    set wait 0
	} else {
	    foreach i {size spacing sep_column width return_tab \
		    max_toprint return_begin freeform separator} {
		set fx_postcardsetup($i) [set fx_tmp_postcard_$i]
	    }
	    break
	}
    }
    Fx:SavePosition $p
    destroy .postcard_setup
    catch "grab $oldGrab"
}

proc Fx:PostCard_splitMsg {message len} {
    set m [split $message "\n"]
    foreach msg $m {
	if {[string length [string trim $msg]] == 0} {
	    lappend retval { }
	    continue
	}
	set nlen 0
	set str {}
	foreach i $msg {
	    if {$nlen + [string length $i] + 1 >= $len} {
		lappend retval [string trim $str]
		set str "$i "
		set nlen [string length $str]
	    } else {
		append str "$i "
		incr nlen [string length $i]
		incr nlen
	    }
	}
	lappend retval [string trim $str]
    }
    return $retval
}

proc Fx:PostCard_Format {fd retaddr destaddr message} {
    global fx_postcardsetup

    update; update idletasks
    set start_retaddr 3;# return address must be above line 7
    set wid $fx_postcardsetup(sep_column)
    set card_bot [expr $fx_postcardsetup(size) - $fx_postcardsetup(spacing)]
    set wid1 [expr $wid - 1]
    set ret_width \
	    [expr $fx_postcardsetup(width) - \
	    $fx_postcardsetup(return_tab) - $fx_postcardsetup(sep_column)]
    set right_width [expr $fx_postcardsetup(width) - $fx_postcardsetup(sep_column)]
    set start_msg 3

    set retaddr [split $retaddr \n]
    set destaddr [split $destaddr \n]

    set message [Fx:PostCard_splitMsg $message $wid]

    set card_return_end [expr $fx_postcardsetup(return_begin) + [llength $destaddr]]
    set end_retaddr [expr $start_retaddr + [llength $retaddr]]

    set msg_spot 0
    for {set i 0} {$i < $fx_postcardsetup(size)} {incr i} {
	if {$i < $start_msg || $i > $card_bot} {
	    set lines($i) [format "%${wid}s%s" " " $fx_postcardsetup(separator)]
	} elseif {$i == $card_bot} {
	    set lines($i) [format "%${wid}s%s" " " $fx_postcardsetup(separator)]
	} else {
	    set lines($i) [format "%-${wid}s%s" [lindex $message $msg_spot] $fx_postcardsetup(separator)]
	    incr msg_spot
	}
    }
    for {set i 0} {$i < $fx_postcardsetup(size)} {incr i} {
	if {$i >= $start_retaddr && $i <= $end_retaddr} {
	    set spot [expr $i - $start_retaddr]
	    append lines($i) [format " %-${right_width}s" [lindex $retaddr $spot]]
	} elseif {$i >= $fx_postcardsetup(return_begin) && $i <= $card_return_end} {
	    set spot [expr $i - $fx_postcardsetup(return_begin)]
	    append lines($i) \
		    [format "%$fx_postcardsetup(return_tab)s%-${right_width}s" \
		    " " [lindex $destaddr $spot]]
	}
	puts $fd $lines($i)
    }    
}

proc Fx:PostCard_Print {schema tables restrict} {
    global fx_postcardsetup fx_config fx_translate

    update; update idletasks
    catch "unset fx_translate"
    set leaves [qddb_schema leaves $schema]
    foreach i $leaves {
	set a [qddb_schema option alias $schema $i]
	if {[string length $a] > 0} {
	    set fx_translate($a) $i
	}
	set fx_translate($i) $i
    }
    set destaddr_form $fx_config(\$reports\$,\$destination_address\$)
    set retaddr $fx_config(\$reports\$,\$return_address\$)
    set postcard [Fx:MessageInput $schema PostCard $restrict]
    set fx_postcardsetup(value) $postcard
    if {[string length $postcard] == 0} {
	return
    }
    set test [lindex $postcard 0]
    if {[string compare $test test] == 0} {
	set testing 1
    } else {
	set testing 0
    }
    set postcard [lindex $postcard 1]
    # Free form or standard postcard
    set fn [TempNam]
    set fd [open $fn w]
    if {$fx_postcardsetup(freeform)} {
	foreach tbl $tables {
	    set maxrows [qddb_table row maxnum $tbl]
	    for {set i 1} {$i <= $maxrows} {incr i} {
		if {$testing && $i > $fx_postcardsetup(max_toprint)} {
		    break
		}
		puts -nonewline $fd [Fx:TranslateOutput $tbl $i $postcard]
		puts $fd "\f"
	    }
	}
    } else {
	foreach tbl $tables {
	    set maxrows [qddb_table row maxnum $tbl]
	    for {set i 1} {$i <= $maxrows} {incr i} {
		if {$testing && $i > $fx_postcardsetup(max_toprint)} {
		    break
		}
		set destaddr [Fx:TranslateOutput $tbl $i $destaddr_form]
		set formatted [Fx:TranslateOutput $tbl $i $postcard]
		Fx:PostCard_Format $fd $retaddr $destaddr $formatted
	    }
	}
    }
    close $fd
    Fx_PrintDialog fx_postcard_print_dialog -toplevel "" -title "Print postcards"
    if {$fx_config(cancel_print) == 0} {
	update idletasks
	update
	if {[info exists fx_config(print_cmd)]} {
	    set print_cmd $fx_config(print_cmd)
	}
	if {[info exists fx_config(default_print_cmd)]} {
	    set default_print_cmd $fx_config(default_print_cmd)
	}
	set fx_config(print_cmd) "| lpr -h -P"
	set fx_config(default_print_cmd) "| lpr -h"
	catch "unset fx_config(print_heading)"
	catch "Fx:PrintFile $fn"
	if {[info exists print_cmd]} {
	    set fx_config(print_cmd) $print_cmd
	}
	if {[info exists default_print_cmd]} {
	    set fx_config(default_print_cmd) $default_print_cmd
	}
    }
    catch [list exec rm -f $fn]
}


# Letter routines
proc Fx:Letter_Setup {schema} {
    global fx_setup_config fx_lettersetup \
	    fx_tmp_letter_size \
	    fx_tmp_letter_spacing \
	    fx_tmp_letter_width \
	    fx_tmp_letter_return_tab \
	    fx_tmp_letter_return_begin \
	    fx_tmp_letter_clinic_begin \
	    fx_tmp_letter_max_toprint \
	    fx_tmp_letter_start_msg \
	    fx_tmp_letter_freeform

    set fx_tmp_letter_size $fx_lettersetup(size)
    set fx_tmp_letter_spacing $fx_lettersetup(spacing)
    set fx_tmp_letter_width $fx_lettersetup(width)
    set fx_tmp_letter_return_tab $fx_lettersetup(return_tab)
    set fx_tmp_letter_return_begin $fx_lettersetup(return_begin)
    set fx_tmp_letter_max_toprint $fx_lettersetup(max_toprint)
    set fx_tmp_letter_start_msg $fx_lettersetup(start_msg)
    set fx_tmp_letter_freeform $fx_lettersetup(freeform)
    set l .letter_setup
    if {[winfo exists $l]} {
	raise $l
	focus $l
	return
    }
    toplevel $l
    wm withdraw $l
    wm title $l "Letter Setup"
    frame $l.f
    pack $l.f -side top
    set f $l.f
    frame $f.f0 -relief groove -bd 2
    pack $f.f0 -side left -expand on -fill both
    set ff $f.f0
    frame $ff.f0
    pack $ff.f0 -side top -expand on -fill x
    label $ff.f0.l -text "Total number of lines:" -width 30 -justify right -anchor e
    pack $ff.f0.l -side left -expand off -fill none
    entry $ff.f0.e -textvariable fx_tmp_letter_size -width 4
    pack $ff.f0.e -side right -expand off -fill x
    fx_bindint $ff.f0.e
    fx_bindnotnull $ff.f0.e fx_tmp_letter_size
    frame $ff.f1
    pack $ff.f1 -side top -expand on -fill x
    label $ff.f1.l -text "Blank lines at bottom of letter:" -width 30 -justify right -anchor e
    pack $ff.f1.l -side left -expand off -fill none
    entry $ff.f1.e -textvariable fx_tmp_letter_spacing -width 4
    pack $ff.f1.e -side right -expand off -fill x
    fx_bindint $ff.f1.e
    fx_bindnotnull $ff.f1.e fx_tmp_letter_spacing
    frame $ff.f2
    pack $ff.f2 -side top -expand on -fill x
    label $ff.f2.l -text "Address begins at line:" -width 30 -justify right -anchor e
    pack $ff.f2.l -side left -expand off -fill none
    entry $ff.f2.e -textvariable fx_tmp_letter_return_begin -width 4
    pack $ff.f2.e -side right -expand off -fill x
    fx_bindint $ff.f2.e
    fx_bindnotnull $ff.f2.e fx_tmp_letter_return_begin

    frame $f.f1 -relief groove -bd 2
    pack $f.f1 -side right -expand on -fill both
    set ff $f.f1
    frame $ff.f0
    pack $ff.f0 -side top -expand on -fill x
    label $ff.f0.l -text "Total characters per line:" -width 28 -justify right -anchor e
    pack $ff.f0.l -side left -expand off -fill none
    entry $ff.f0.e -textvariable fx_tmp_letter_width -width 4
    pack $ff.f0.e -side right -expand off -fill x
    fx_bindint $ff.f0.e
    fx_bindnotnull $ff.f0.e fx_tmp_letter_width
    frame $ff.f1
    pack $ff.f1 -side top -expand on -fill x
    label $ff.f1.l -text "Start letter at line:" -width 28 -justify right -anchor e
    pack $ff.f1.l -side left -expand off -fill none
    entry $ff.f1.e -textvariable fx_tmp_letter_start_msg -width 4
    pack $ff.f1.e -side right -expand off -fill x
    fx_bindint $ff.f1.e
    fx_bindnotnull $ff.f1.e fx_tmp_letter_start_msg
    frame $ff.f2
    pack $ff.f2 -side top -expand on -fill x
    label $ff.f2.l -text "Free-form letter:" -width 28 -justify right -anchor e
    pack $ff.f2.l -side left -expand off -fill none
    checkbutton $ff.f2.e -variable fx_tmp_letter_freeform
    pack $ff.f2.e -side right -expand on -fill x

    set ff .letter_setup.f3
    frame $ff -relief groove -bd 2
    pack $ff -side top -expand on -fill x
    label $ff.l -text "Number of letters to print when testing:" -justify right
    pack $ff.l -side left -expand off -fill none
    entry $ff.e -textvariable fx_tmp_letter_max_toprint -width 4
    pack $ff.e -side right -expand off -fill none
    fx_bindint $ff.e
    fx_bindnotnull $ff.e fx_tmp_letter_max_toprint

    set ff .letter_setup.f2
    frame $ff -relief groove -bd 2
    pack $ff -side bottom -expand on -fill x
    button $ff.ok -text "Ok" -command {set fx_setup_config 1}
    pack $ff.ok -side left -padx 8m -pady 2m
    button $ff.cancel -text "Cancel" -command {set fx_setup_config 0}
    pack $ff.cancel -side right -padx 8m -pady 2m
    update idletasks
    wm minsize $l [winfo reqwidth $l] [winfo reqheight $l]
    wm maxsize $l [winfo reqwidth $l] [winfo reqheight $l]
    Fx:SetGeometry $l
    wm deiconify $l
    tkwait visibility $l
    set oldGrab [grab current $l]
    catch "grab $l"
    focus $l
    wm protocol .letter_setup WM_DELETE_WINDOW {set fx_setup_config 0}
    tkwait variable fx_setup_config
    Fx:SavePosition $l
    set wait 0
    while {$fx_setup_config == 1} {
	foreach i {size spacing width return_tab \
		max_toprint return_begin start_msg freeform} {
	    if {[catch "expr int([set fx_tmp_letter_$i])"] != 0} {
		set wait 1
		bell
		break
	    }
	}
	if {$wait} {
	    tkwait variable fx_setup_config
	    set wait 0
	} else {
	    foreach i {size spacing width return_tab \
		    max_toprint return_begin start_msg freeform} {
		set fx_lettersetup($i) [set fx_tmp_letter_$i]
	    }
	    break
	}
    }
    destroy .letter_setup
    catch "grab $oldGrab"
}

proc Fx:TranslateOutput {tbl rownum output} {
    global fx_translate

    set maxcol [qddb_table col maxnum $tbl]
    for {set i 1} {$i <= $maxcol} {incr i} {
	set col([qddb_table col cget $tbl $i -name]) \
		[qddb_table cell getval $tbl $rownum $i]
    }
    foreach i [array names fx_translate] {
	if {[info exists col($i)]} {
	    regsub -all "<$i>" $output $col($i) output
	} elseif {[info exists col($fx_translate($i))]} {
	    regsub -all "<$i>" $output $col($fx_translate($i)) output
	}
    }
    return $output
}

proc Fx:Output_ReadSetup {schema w type restrict} {
    set setupvar fx_[string tolower $type]setup
    global $setupvar fx_config fx_rconfig \
	    fx_email_subjectline

    set fn [Fx:FileSelect .fx_output_readfile r $restrict/:[string tolower $type]_setup:]
    catch [list source $fn]
    if {[info exists msg]} {
	$w delete 0.0 end
	$w insert 0.0 $msg
    }
}

proc Fx:Output_WriteSetup {schema w type restrict} {
    set setupvar fx_[string tolower $type]setup
    global $setupvar fx_config fx_rconfig

    set fn [Fx:FileSelect .fx_output_writefile w $restrict/:[string tolower $type]_setup:]
    if {[string length $fn] == 0 || [catch [list open $fn w] fd] != 0} {
	return
    }
    foreach i [array names fx_rconfig] {
	puts $fd [list set fx_rconfig($i) $fx_rconfig($i)]
    }
    foreach i [array names $setupvar] {
	puts $fd [list set ${setupvar}($i) [set ${setupvar}($i)]]
    }
    set msg [$w get 0.0 end]
    puts $fd [list set msg $msg]
    if {[string compare $type Email] == 0} {
	global fx_email_subjectline
	puts $fd [list set fx_email_subjectline $fx_email_subjectline]
    }
    close $fd
}

proc Fx:MessageInput {schema type restrict {test 1}} {
    set var fx_[string tolower $type]setup
    global fx_translate fx_buttoncmd fx_rconfig $var

    set p .fx_msginput
    if {[winfo exists $p]} {
	raise $p
	focus $p
	return ""
    }
    toplevel $p
    set tt [string tolower $type]
    set tt "[string toupper [string range $tt 0 0]][string range $tt 1 end]"
    wm title $p "$tt Message"
    wm withdraw $p
    if {[string compare $type Email] == 0} {
	global fx_email_subjectline
	frame $p.f0
	pack $p.f0 -side top -fill x
	label $p.f0.l -text "Subject:"
	pack $p.f0.l -side left
	entry $p.f0.e -textvariable fx_email_subjectline
	pack $p.f0.e -side left -expand on -fill x
	if {[info exists ${var}(value)]} {
	    set fx_email_subjectline [lindex [set ${var}(value)] 2]
	}
    }
    frame $p.f
    pack $p.f -side top -expand on -fill both
    scrollbar $p.f.s -command [list $p.f.t yview]
    pack $p.f.s -side right -fill y
    set font [option get . font Listbox]
    if {[string length $font] == 0} {
        set font "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-*-*"
    }
    text $p.f.t -width 30 -height 10 -wrap none -yscroll [list $p.f.s set] -font $font
    pack $p.f.t -side top -expand on -fill both
    set tbox $p.f.t
    bind $p.f.t <ButtonRelease-2> "Fx:Text_InsertAliasSelection $tbox %x %y; break"
    if {[info exists ${var}(value)]} {
	$p.f.t insert 0.0 [lindex [set ${var}(value)] 1]
    }
    frame $p.f1
    pack $p.f1 -side top -fill x
    button $p.f1.b -text "View attributes and aliases" \
	    -command [list Fx:ViewAttributesAndAliases $schema 1 $fx_rconfig(\$search\$,print)]
    pack $p.f1.b -side top
    frame $p.f4 -bd 2
    pack $p.f4 -side top -fill x
    button $p.f4.ok -text Ok -command {set fx_buttoncmd ok}
    pack $p.f4.ok -side left -padx 4m -pady 2m
    if {$test} {
	button $p.f4.test -text Test -command {set fx_buttoncmd test}
	pack $p.f4.test -side left -padx 4m -pady 2m
    }
    button $p.f4.read -text "Read from file" -command \
	    [list Fx:BusyExec $p [list Fx:Output_ReadSetup $schema $p.f.t $type $restrict]]
    pack $p.f4.read -side left -padx 4m -pady 2m
    button $p.f4.write -text "Write to file" -command \
	    [list Fx:BusyExec $p [list Fx:Output_WriteSetup $schema $p.f.t $type $restrict]]
    pack $p.f4.write -side left -padx 4m -pady 2m
    button $p.f4.setup -text "Setup" -command [list Fx:BusyExec $p [list Fx:${type}_Setup $schema]]
    pack $p.f4.setup -side left -padx 4m -pady 2m
    button $p.f4.cancel -text Cancel -command {set fx_buttoncmd cancel}
    pack $p.f4.cancel -side right -padx 4m -pady 2m
    set fx_buttoncmd {}
    update idletasks
    set minx [winfo reqwidth $p]
    set miny [winfo reqheight $p]
    wm minsize $p $minx $miny
    Fx:SetGeometry $p
    update; update idletasks
    wm deiconify $p
    tkwait visibility $p
    fx_bindgeom $p
    focus $tbox
    tkwait variable fx_buttoncmd
    if {[string compare $fx_buttoncmd cancel] == 0} {
	Fx:SaveGeometry $p
	destroy $p
	update
	return ""
    } else {
	set msg [$p.f.t get 0.0 end]
	if {[string compare $type Email] == 0} {
	    set msg2 [$p.f0.e get]
	}
	Fx:SaveGeometry $p
	destroy $p
	update
	if {[string compare $type Email] == 0} {
	    set ${var}(value) [list $fx_buttoncmd $msg $msg2]
	    return [set ${var}(value)]
	} else {
	    set ${var}(value) [list $fx_buttoncmd $msg]
	    return [set ${var}(value)]
	}
    }
}

proc Fx:Letter_Format {fd retaddr destaddr letter} {
    global fx_lettersetup fx_config

    update; update idletasks
    set maxlen 0
    set l [split $retaddr \n]
    foreach i $l {
	set len [string length $i]
	if {$len > $maxlen} {
	    set maxlen $len
	}
    }
    set blanklen [expr $fx_lettersetup(width) - $maxlen - 1]
    puts $fd "\n\n"
    set line 3
    foreach i $l {
	puts $fd [format "%${blanklen}s%s" " " $i]
	incr line
    }
    for {} {$line < $fx_lettersetup(return_begin)} {incr line} {
	puts $fd ""
    }
    set l [split $destaddr \n]
    foreach i $l {
	puts $fd [format "%[set fx_lettersetup(return_tab)]s%s" " " $i]
	incr line
    }
    for {} {$line < $fx_lettersetup(start_msg)} {incr line} {
	puts $fd ""
    }
    set l [split $letter \n]
    foreach i $l {
	puts $fd $i
	if {$line >= $fx_lettersetup(size)} {
	    puts $fd "\f\n\n"
	    set line 3
	} else {
	    incr line
	}
    }
}

proc Fx:Letter_Print {schema tables restrict} {
    global fx_lettersetup fx_config fx_translate

    update; update idletasks
    catch "unset fx_translate"
    set leaves [qddb_schema leaves $schema]
    foreach i $leaves {
	set a [qddb_schema option alias $schema $i]
	if {[string length $a] > 0} {
	    set fx_translate($a) $i
	}
	set fx_translate($i) $i
    }
    set destaddr_form $fx_config(\$reports\$,\$destination_address\$)
    set retaddr $fx_config(\$reports\$,\$return_address\$)
    set letter [Fx:MessageInput $schema Letter $restrict]
    if {[string length $letter] == 0} {
	return
    }
    set test [lindex $letter 0]
    if {[string compare $test test] == 0} {
	set testing 1
    } else {
	set testing 0
    }
    set letter [lindex $letter 1]
    # Free form or standard letters
    set fn [TempNam]
    set fd [open $fn w]
    if {$fx_lettersetup(freeform)} {
	foreach tbl $tables {
	    set maxrows [qddb_table row maxnum $tbl]
	    for {set i 1} {$i <= $maxrows} {incr i} {
		if {$testing && $i > $fx_lettersetup(max_toprint)} {
		    break
		}
		puts -nonewline $fd [Fx:TranslateOutput $tbl $i $letter]
		puts $fd "\f"
	    }
	}
    } else {
	foreach tbl $tables {
	    set maxrows [qddb_table row maxnum $tbl]
	    for {set i 1} {$i <= $maxrows} {incr i} {
		if {$testing && $i > $fx_lettersetup(max_toprint)} {
		    break
		}
		set destaddr [Fx:TranslateOutput $tbl $i $destaddr_form]
		set formatted [Fx:TranslateOutput $tbl $i $letter]
		Fx:Letter_Format $fd $retaddr $destaddr $formatted
		puts $fd "\f"
	    }
	}
    }
    close $fd
    Fx_PrintDialog fx_letters_print_dialog -toplevel "" -title "Print letters"
    if {$fx_config(cancel_print) == 0} {
	update idletasks
	update
	if {[info exists fx_config(print_cmd)]} {
	    set print_cmd $fx_config(print_cmd)
	}
	if {[info exists fx_config(default_print_cmd)]} {
	    set default_print_cmd $fx_config(default_print_cmd)
	}
	set fx_config(print_cmd) "| lpr -h -P"
	set fx_config(default_print_cmd) "| lpr -h"
	catch "unset fx_config(print_heading)"
	catch "Fx:PrintFile $fn"
	if {[info exists print_cmd]} {
	    set fx_config(print_cmd) $print_cmd
	}
	if {[info exists default_print_cmd]} {
	    set fx_config(default_print_cmd) $default_print_cmd
	}
    }
    catch [list exec rm -f $fn]
}


# E-mail routines
proc Fx:Email_Setup {schema} {
    global fx_setup_config qddb_library fx_emailsetup \
	    fx_tmp_email_attribute \
	    fx_tmp_email_program \
	    fx_tmp_email_subject

    set e .email_setup
    if {[winfo exists $e]} {
	raise $e
	focus $e
	return
    }
    set fx_tmp_email_attribute $fx_emailsetup(attribute)
    set fx_tmp_email_program $fx_emailsetup(program)
    set fx_tmp_email_subject $fx_emailsetup(subject)
    toplevel $e
    wm withdraw $e
    wm title $e "E-mail Setup"
    frame $e.f
    pack $e.f -side top
    set f $e.f
    set wid 28
    frame $f.f0
    pack $f.f0 -side top -expand on -fill x
    label $f.f0.l -text "E-mail address attribute:" -width $wid -justify right -anchor e
    pack $f.f0.l -side left -expand off -fill none
    entry $f.f0.e -textvariable fx_tmp_email_attribute -width 40 -state disabled
    pack $f.f0.e -side right -expand off -fill x
    fx_bindnotnull $f.f0.e fx_tmp_email_attribute
    button $f.f0.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
	    -command [list Fx:DisplayAttributes $e $f.f0.b $schema fx_tmp_email_attribute]
    pack $f.f0.b -side left
    frame $f.f1
    pack $f.f1 -side top -expand on -fill x
    label $f.f1.l -text "E-mail program:" -width $wid -justify right -anchor e
    pack $f.f1.l -side left -expand off -fill none
    entry $f.f1.e -textvariable fx_tmp_email_program -width 40
    pack $f.f1.e -side right -expand off -fill x
    fx_bindnotnull $f.f1.e fx_tmp_email_program
    frame $f.f2
    pack $f.f2 -side top -expand on -fill x
    label $f.f2.l -text "E-mail subject option:" -width $wid -justify right -anchor e
    pack $f.f2.l -side left -expand off -fill none
    entry $f.f2.e -textvariable fx_tmp_email_subject -width 40
    pack $f.f2.e -side right -expand off -fill x
    fx_bindnotnull $f.f2.e fx_tmp_email_subject

    set ff .email_setup.f1
    frame $ff -relief groove -bd 2
    pack $ff -side bottom -expand on -fill x
    button $ff.ok -text "Ok" -command {set fx_setup_config 1}
    pack $ff.ok -side left -padx 8m -pady 2m
    button $ff.cancel -text "Cancel" -command {set fx_setup_config 0}
    pack $ff.cancel -side right -padx 8m -pady 2m
    update idletasks
    wm minsize $e [winfo reqwidth $e] [winfo reqheight $e]
    wm maxsize $e [winfo reqwidth $e] [winfo reqheight $e]
    Fx:SetGeometry $e
    wm deiconify $e
    set oldGrab [grab current $e]
    catch "grab $e"
    wm protocol .email_setup WM_DELETE_WINDOW {set fx_setup_config 0}
    tkwait variable fx_setup_config
    Fx:SavePosition $e
    set wait 0
    while {$fx_setup_config == 1} {
	foreach i {attribute program subject} {
	    if {[string length [set fx_tmp_email_$i]] == 0} {
		set wait 1
		bell
		break
	    }
	}
	if {$wait} {
	    tkwait variable fx_setup_config
	    set wait 0
	} else {
	    foreach i {attribute program subject} {
		set fx_emailsetup($i) [set fx_tmp_email_$i]
	    }
	    break
	}
    }
    destroy .email_setup
    catch "grab $oldGrab"
}

proc Fx:Email_Send {schema tables restrict} {
    global fx_emailsetup fx_email_subjectline fx_config fx_translate

    update; update idletasks
    catch "unset fx_email_subjectline"
    catch "unset fx_translate"
    set leaves [qddb_schema leaves $schema]
    foreach i $leaves {
	set a [qddb_schema option alias $schema $i]
	if {[string length $a] > 0} {
	    set fx_translate($a) $i
	}
	set fx_translate($i) $i
    }
    set letter [Fx:MessageInput $schema Email $restrict]
    if {[string length $letter] == 0} {
	return
    }
    set msg [lindex $letter 1]
    set subject [lindex $letter 2]
    foreach tbl $tables {
	set maxrows [qddb_table row maxnum $tbl]
	for {set i 1} {$i <= $maxrows} {incr i} {
	    set email_msg [Fx:TranslateOutput $tbl $i $msg]
	    set email_subj [Fx:TranslateOutput $tbl $i $subject]
	    set email_recipient [qddb_table cell getval $tbl $i $fx_emailsetup(attribute)]
	    if {[string length [string trim $email_recipient]] == 0} {
		continue
	    }
	    set fd [open \
		    [list |$fx_emailsetup(program) $fx_emailsetup(subject) "$email_subj" $email_recipient] w]
	    puts $fd "$email_msg"
	    close $fd
	}
    }    
}


