# fx_menu.tcl
#
# Generic menubar and default procedures for Qddb applications

itcl::class Fx_Menubar {
    constructor {args} {
	eval configure $args
    } {
	global ::fx_debug ::fx_config ::$mode_variable ::$status_variable \
		::fx:search_modeval ::fx:add_modeval ::fx:readonly_modeval \
		::fx:change_modeval ::fx:search_statusval ::fx_monochrome ::fx_wait_on_config

	wm protocol . WM_DELETE_WINDOW [list $this QuitProc]
	::set ${mode_variable} ${fx:search_modeval}
	::set $status_variable ${fx:search_statusval}
	if {![info exists fx_config(auto_clear)]} { 
	    ::set fx_config(auto_clear) $auto_clear
	}
	if {![info exists fx_config(auto_save)]} { 
	    ::set fx_config(auto_save) $auto_save
	}
	if {![info exists fx_config(auto_save_tuple)]} {
	    ::set fx_config(auto_save_tuple) $auto_save_tuple
	}
	InitConfig 1
	::set fx_wait_on_config 0
	if {$menubar} {
	    if {![winfo exists $w]} {
		frame $w
		pack $w -side top -expand on -fill x
	    }
	    menubutton $w.file -text File -underline 0 -menu $w.file.menu -padx 1m -pady 1m
	    menu $w.file.menu -postcommand "$this FilePostMenu" -tearoff $tearoffs
	    $w.file.menu add command -label "Save" \
		-underline 0 -command [list $this SaveProc]
	    $w.file.menu add command -label "Quit" \
		-underline 0 -command [list $this QuitProc]
	    if {[info exists fx_debug] && $fx_debug == 1} {
		$w.file.menu add command -label "DumpConfig" \
		    -underline 0 -command [list $this DumpConfig]
	    }
	    menubutton $w.edit -text Edit -underline 0 -menu $w.edit.menu -padx 1m -pady 1m
	    menu $w.edit.menu -postcommand [list $this EditPostMenu] -tearoff $tearoffs
	    $w.edit.menu add command -label "Search" \
		-underline 0 -command [list $this SearchProc]
	    $w.edit.menu add command -label "Expert Search" \
		    -underline 1 -command [list Fx:BusyExec . [list $this ExpertSearchProc]]
	    $w.edit.menu add separator
	    $w.edit.menu add command -label "Reports" \
		    -underline 0 -command [list $this ReportProc]
	    $w.edit.menu add separator
	    $w.edit.menu add command -label "Copy" \
		    -accelerator <Alt-W> -command {Fx_Menubar::CopySelection}
	    $w.edit.menu add command -label "Cut" \
		    -accelerator <Ctrl-W> -command {Fx_Menubar::CutSelection}
	    $w.edit.menu add command -label "Paste" \
		    -accelerator <Ctrl-Y> -command {Fx_Menubar::PasteCutbuffer}
	}
	if {$menubar} {
	    $w.edit.menu add separator
	    $w.edit.menu add command -label "Clear" -underline 0 \
		-command [list $this ClearProc]
	    $w.edit.menu add command -label "Delete" -underline 0 \
		-command [list $this DeleteProc]
	    $w.edit.menu add command -label "Undo" -underline 0 \
		-command [list $this UndoProc]
	    menubutton $w.modes -text "Modes" -underline 0 -menu $w.modes.menu -padx 1m -pady 1m
	    menu $w.modes.menu -postcommand "$this ModesPostMenu" -tearoff $tearoffs
	    $w.modes.menu add command -label ${fx:search_modeval} -underline 0 \
		-command "$this SearchModeProc"
	    $w.modes.menu add command -label ${fx:add_modeval} -underline 0 \
		-command "$this AddModeProc"
	    $w.modes.menu add command -label ${fx:change_modeval} -underline 0 \
		-command "$this ToChangeModeProc"
	    $w.modes.menu add command -label ${fx:readonly_modeval} -underline 0 \
		-command "$this ReadOnlyModeProc"
	    menubutton $w.view -text "View" -underline 0 -menu $w.view.menu \
		-padx 1m -pady 1m
	    menu $w.view.menu -postcommand [list $this ViewPostMenu] -tearoff $tearoffs
	    $w.view.menu add command -label "Last Search Results" -underline 0 \
		-command [list $this DisplayLastSearch]
	    menubutton $w.templates -text Templates -underline 0 -menu $w.templates.menu -padx 1m -pady 1m
	    menu $w.templates.menu -postcommand [list $this TemplatesPostMenu] -tearoff $tearoffs
	    $w.templates.menu add command -label "Read Template" -underline 0 \
		-command [list Fx:BusyExec . [list $this ReadTemplateProc]]
	    $w.templates.menu add command -label "Insert Last Template" -underline 0 \
		-command [list Fx:BusyExec . [list $this InsertLastTemplateProc]]
	    $w.templates.menu add command -label "Write Template" -underline 0 \
		-command [list Fx:BusyExec . [list $this WriteTemplateProc]]
	    menubutton $w.config -text Configure -underline 0 -menu $w.config.menu -padx 1m -pady 1m
	    menu $w.config.menu -tearoff $tearoffs -postcommand [list $this ConfigPostMenu]
	    $w.config.menu add command -label "Save Personal Configuration" -underline 5 \
		-command [list $this SavePersonalConfig]
	    $w.config.menu add command -label "Save Global Configuration" -underline 5 \
		-command [list $this SaveGlobalConfig]
	    $w.config.menu add checkbutton -label "Auto-Save Personal Configuration" -underline 0 \
		-variable fx_config(auto_save)
	    $w.config.menu add separator
	    $w.config.menu add command -label "Search Results" -underline 0 \
		-command [list Fx:BusyExec . [list $this ConfigureSearchResults]]
	    $w.config.menu add cascade -label "Report Format Defaults" -underline 10 \
		-menu $w.config.menu.reports
	    menu $w.config.menu.reports  -tearoff $tearoffs
	    $w.config.menu.reports add command -label "Letter format" -underline 0 \
		-command [list Fx:BusyExec . [list Fx:Letter_Setup $schema]]
	    $w.config.menu.reports add command -label "Postcard format" -underline 0 \
		-command [list Fx:BusyExec . [list Fx:PostCard_Setup $schema]]
	    $w.config.menu.reports add command -label "E-mail format" -underline 0 \
		-command [list Fx:BusyExec . [list Fx:Email_Setup $schema]]
	    $w.config.menu.reports add command -label "Return address" -underline 0 \
		-command [list Fx:BusyExec . Fx:ReturnAddress_Setup]
	    $w.config.menu.reports add command -label "Destination address" -underline 0 \
		-command [list Fx:BusyExec . [list Fx:DestinationAddress_Setup $schema]]
	    $w.config.menu add command -label "Fonts" -underline 0 \
		-command {
		    if {[Fx:BusyExec . Fx:ConfigureFonts] == 1} {
			eval [Fx_Menubar::AfterReconfigure]
		    }
		}
	    $w.config.menu add command -label "Colors" -underline 0 \
		    -command {Fx:BusyExec . Fx:ConfigureColors}
	    $w.config.menu add separator
	    $w.config.menu add cascade -label "Soft Search Limit" -menu $w.config.menu.soft \
		    -underline 3
	    menu $w.config.menu.soft -tearoff $tearoffs
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 50 -label 50 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 100 -label 100 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 200 -label 200 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 300 -label 300 
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 400 -label 400
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) -value 500 -label 500
	    $w.config.menu.soft add radiobutton -variable fx_config(soft_limit) \
		    -value unlimited -label unlimited
	    $w.config.menu add cascade -label "Hard Search Limit" -menu $w.config.menu.hard \
		    -underline 3
	    menu $w.config.menu.hard -tearoff $tearoffs
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 100 -label 100 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 200 -label 200 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 300 -label 300 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 400 -label 400 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 500 -label 500 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 600 -label 600 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 700 -label 700 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 800 -label 800 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 900 -label 900 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) -value 1000 -label 1000 
	    $w.config.menu.hard add radiobutton -variable fx_config(hard_limit) \
		    -value unlimited -label unlimited
	    $w.config.menu add separator
	    $w.config.menu add cascade -label "Keyboard Traversal" -menu $w.config.menu.tabbing \
		    -underline 0
	    menu $w.config.menu.tabbing -tearoff $tearoffs
	    $w.config.menu.tabbing add checkbutton -variable fx_config(\$tabbing\$,scrollbars) \
		    -onvalue "" -offvalue 0 -label "Include scrollbars" -command {
		Fx_Attribute::ResetTabbing scrollbars $fx_config(\$tabbing\$,scrollbars)
	    }
	    $w.config.menu.tabbing add checkbutton -variable fx_config(\$tabbing\$,add) \
		    -onvalue "" -offvalue 0 -label "Include Add buttons" -command {
		Fx_Attribute::ResetTabbing add $fx_config(\$tabbing\$,add)
	    }
	    $w.config.menu.tabbing add checkbutton -variable fx_config(\$tabbing\$,view) \
		    -onvalue "" -offvalue 0 -label "Include View buttons" -command {
		Fx_Attribute::ResetTabbing view $fx_config(\$tabbing\$,view)
	    }
	    $w.config.menu.tabbing add checkbutton -variable fx_config(\$tabbing\$,del) \
		    -onvalue "" -offvalue 0 -label "Include Del buttons" -command {
		Fx_Attribute::ResetTabbing del $fx_config(\$tabbing\$,del)
	    }
	    $w.config.menu add separator
	    $w.config.menu add cascade -label "Date style" -menu $w.config.menu.datestyle \
		    -underline 7
	    menu $w.config.menu.datestyle -tearoff $tearoffs
	    $w.config.menu.datestyle add radiobutton -variable fx_config(datestyle) \
		    -value "us" -label "US format" -command "
	        $this SearchModeProc
	        $this KillLastSearch
	        set $status_variable [list ${fx:search_statusval}]
		qddb_util datestyle us
		qddb_schema datestyle [$this cget -schema] us
	    "
	    $w.config.menu.datestyle add radiobutton -variable fx_config(datestyle) \
		    -value "european" -label "European format" -command "
	        $this SearchModeProc
	        $this KillLastSearch
	        set $status_variable [list ${fx:search_statusval}]
		qddb_util datestyle european
		qddb_schema datestyle [$this cget -schema] european
	    "
	    $w.config.menu add separator
	    $w.config.menu add checkbutton -label "Auto-Clear" -underline 1 \
		-variable fx_config(auto_clear)
	    $w.config.menu add checkbutton -label "Auto-Save Tuples" -underline 13 \
		-variable fx_config(auto_save_tuple)
	    $w.config.menu add checkbutton -label "Force ${fx:readonly_modeval}" -underline 1 \
		-variable fx_config(force_readonly_mode)
	    $w.config.menu add checkbutton -label "Force Field Formatting" -underline 2 \
		    -variable fx_config(force_field_formatting)

	    menubutton $w.help -text Help -underline 0 -menu $w.help.menu -padx 1m -pady 1m
	    menu $w.help.menu -tearoff $tearoffs
	    $w.help.menu add command -label "About Qddb" -underline 0 -command Fx:AboutBox
	    $w.help.menu add command -label "Frequently Asked Questions" -underline 0 -command Fx:FAQBox
	    $w.help.menu add command -label "Key Bindings" -underline 0 -command Fx:KeyBindingsHelp
	    pack $w.file $w.edit $w.modes $w.view -side left
	    foreach i $auxbuttons {
		$i configure -padx 1m -pady 1m
		pack $i -in $w -side left
	    }
	    pack $w.help $w.config $w.templates -side right
	    set menu_items [concat $w $w.file $w.edit $w.modes $w.view $auxbuttons $w.templates $w.config $w.help]
	    eval "tk_menuBar $menu_items"
	    tk_bindForTraversal Entry Text .
	}
	set p [winfo p $w]
	if {[string compare $p .] == 0} {
	    set p ""
	}
	if {$modebar} {
	    label $p.mode_label -relief raised -textvariable $mode_variable -justify center
	    pack $p.mode_label -side top -expand on -fill x
	}
	if {$statusbar} {
	    label $p.status_label -relief raised -textvariable $status_variable -justify center
	    pack $p.status_label -side top -expand on -fill x
	}
	if {$searchfor} {
	    frame $p.searchfor
	    pack $p.searchfor -expand on -fill x
	    set t $p.searchfor.label
	    button $t -text "Search for" -relief flat -highlightthickness 0 -takefocus 0 -justify right \
		    -padx 0 -pady 0
	    pack $t -side left
	    $t configure -activebackground [lindex [$t configure -background] 4]
	    $t configure -activeforeground [lindex [$t configure -foreground] 4]
	    bindtags $t {.}
	    entry $p.searchfor.entry -textvariable $searchfor_variable -relief sunken
	    pack $p.searchfor.entry -side right -expand on -fill x
	    focus $p.searchfor.entry
	    set searchfor_entry $p.searchfor.entry
	    set searchfor_label $t
	}
    }
    destructor {
	destroy $w
    }

    method SaveProc {}
    method RunChecks {}
    method QuitProc {}
    method CheckNeedToSave {}
    method SearchProc {{keylist {}} {search_attrs {}}}
    method ExpertSearchProc {}
    method DeleteProc {}
    method ClearProc {}
    method UndoProc {}
    method SearchModeProc {}
    method AddModeProc {}
    method ChangeModeProc {idx {takefocus 1}}
    method ToChangeModeProc {}
    method ReadOnlyModeProc {}
    method ReadTemplateProc {}
    method InsertLastTemplateProc {}
    method WriteTemplateProc {}
    method DisplayLastSearch {{do_sort 0} {reconfig 0} {release_hold 1}}
    method PinnedSearchResultsProc {i}
    method PrintLastSearch {}
    method KillLastSearch {}
    method FilePostMenu {}
    method EditPostMenu {}
    method ModesPostMenu {}
    method ViewPostMenu {}
    method TemplatesPostMenu {}
    method ConfigPostMenu {}
    method SearchForEntry {}
    method ConfigureSearchResults {}
    method SavePersonalConfig {}
    method SaveOptions {fd}
    method SaveGlobalConfig {}
    method InitConfig {{load_config 1}}
    method GetLastSearch {}
    method LastSearchWasNull {}
    method SetLastSearch {l}
    method DumpConfig {}
    method GetView {}
    method ReportProc {}
    # editing procedures
    public proc CopySelection {} {
	global ::tk_version

	set selown [selection own]
	if {[string compare $selown ""] == 0} {
	    return
	}
	if {$tk_version < 4.2} {
	    if {[catch {selection get} sel] == 0} {
		clipboard clear
		clipboard append $sel
	    }
	} else {
	    event generate $selown <<Copy>>
	}
    }
    public proc CutSelection {} {
	global ::tk_version

	set selown [selection own]
	if {[string compare $selown ""] == 0} {
	    return
	}
	if {$tk_version < 4.2} {
	    if {[catch {selection get} sel] == 0} {
		set cutbuffer $sel
		clipboard clear
		clipboard append $cutbuffer
		$selown delete sel.first sel.last
	    }
	} else {
	    event generate $selown <<Cut>>
	}
    }
    public proc SetCutBuffer {str} {
	clipboard clear
	clipboard append $str
    }
    public proc AppendCutBuffer {str} {
	clipboard append $str
    }
    public proc PasteCutbuffer {} {
	global ::tk_version

	set foc [focus]
	if {$tk_version < 4.2} {
	    if {![catch {selection get -selection CLIPBOARD} mybuf]} {
		catch  "$foc insert insert $mybuf"
	    }
	} else {
	    event generate $foc <<Paste>>
	}
    }
    public proc BeforeReconfigure {{l {}}} {
	if {[llength $l] != 0} {
	    set beforereconfigure $l
	} else {
	    if {[info exists beforereconfigure]} {
		return $beforereconfigure
	    } else {
		return { }
	    }
	}
    }
    public proc AfterReconfigure {{l {}}} {
	if {[llength $l] != 0} {
	    set afterreconfigure $l
	} else {
	    if {[info exists afterreconfigure]} {
		return $afterreconfigure
	    } else {
		return { }
	    }
	}
    }

    public variable w
    public variable auxbuttons {}
    common restrict_dir {}
    public variable restrict {} {set restrict_dir $restrict}
    
    public variable schema
    public variable tuple {} {
	[lindex $instances 0] configure -settuple $tuple
    }
    protected variable searchvar
    protected variable added_tuple
    public variable view {} {
	[lindex $instances 0] configure -setview $view
    }
    public variable instances {} {
	set textvariables {}
	set attr_pairs {}
	set attrs {}
	foreach j $instances {
	    $j configure -array $array
	    lappend textvariables [$j GetTextVariable]
	    lappend attr_pairs [$j GetAttrPair]
	    lappend attrs [$j GetAttr]
	}
    }
    public variable frames {} {
	foreach j $frames {
	    $j configure -array $array
	}
    }
    public variable array gv_attr
    protected variable attr_pairs
    protected variable attrs
    protected variable textvariables
    protected variable last_search
    protected variable last_search_was_null 1
    protected variable excludewords

    protected variable rowtitles 0

    public variable beforechangemode
    public variable beforeaddmode
    public variable beforesearchmode
    public variable beforereadonlymode
    public variable afterchangemode
    public variable afteraddmode
    public variable aftersearchmode
    public variable afterreadonlymode
    public variable beforetupledelete {
	if {[fx_dialog .dialog "RECORD DELETION PENDING" \
		"Are you SURE you want to delete this record?   Click on OK to proceed, Cancel to cancel." \
		 warning 0 Cancel OK] == 0} {
	    return
	}
    }
    public variable beforequit
    public variable afterquit
    public variable beforesave
    public variable aftersave
    public variable aftersearch
    public variable afterreadtemplate
    public variable afterwritetemplate
    public variable beforereadtemplate
    public variable beforewritetemplate
    common beforereconfigure
    common afterreconfigure
    public variable exitproc {exit 0}

    protected variable changemodeidx

    # for search results and instance viewing
    protected variable headings

    public variable mode_variable {fx:mode_variable}
    public variable status_variable {fx:status_variable}
    public variable searchfor_variable {fx:searchfor_variable}

    public variable config_dir .fx_config
    public variable searchfor 1
    public variable statusbar 1
    public variable modebar 1
    public variable menubar 1
    public variable search_results 1

    protected variable searchfor_entry {}
    protected variable searchfor_label {}

    # settings
    public variable auto_clear 0
    public variable auto_save 0
    public variable auto_save_tuple 0
    public variable force_readonly_mode 0 {
	global fx_config
	set fx_config(force_readonly_mode) $force_readonly_mode
    }

    protected variable number_added 0

    public variable afterpost_file
    public variable afterpost_edit
    public variable afterpost_modes
    public variable afterpost_view
    public variable afterpost_templates
    public variable afterpost_configure
    public variable afterpost_help
	  
    public variable tearoffs 0
}

itcl::body Fx_Menubar::InitConfig {{load_config 1}} {
	global ::fx_config ::fx_font ::fx_colors

	set pa \$search\$,print
	set dpa \$search\$,dontprint
	if {![info exists fx_config($pa)]} {
	    set fx_config($pa) [lrange [qddb_schema leaves $schema] 0 4]
	    set fx_config($dpa) [lrange [qddb_schema leaves $schema] 5 end]
	}
	set headings(\$search\$) {}
	set tmp $fx_config($pa)
	set len [llength $tmp]
	for {set i 0} {$i < $len} {incr i} {
	    set attrname [lindex $tmp $i]
	    if {[catch {qddb_schema option verbosename $schema $attrname} head] != 0} {
		if {[info exists fx_config(\$search\$,user_defs)]} {
		    foreach j $fx_config(\$search\$,user_defs) {
			set username [lindex [lindex $j 1] 1]
			if {[string compare $username $attrname] == 0} {
			    set head $username
			    break
			}
		    }
		}
	    }
	    if {[llength $head] == 0} {
		lappend headings(\$search\$) $attrname
	    } else {
		lappend headings(\$search\$) $head
	    }
	}
	set aa \$search\$,alignment
	if {![info exists fx_config($aa)]} {
	    ::set fx_config($aa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($aa) left
	    }
	}
	set sa \$search\$,separators
	if {![info exists fx_config($sa)]} {
	    set fx_config($sa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($sa) ""
	    }
	}
	set wa \$search\$,widths
	if {![info exists fx_config($wa)]} {
	    set fx_config($wa) {}
	    foreach i $headings(\$search\$) {
		lappend fx_config($wa) 0
	    }
	}
	set sb \$search\$,sortby
	if {![info exists fx_config($sb)]} {
	    set fx_config(\$search\$,sortby) $fx_config(\$search\$,print)
	}
	set sa \$search\$,ascending
	if {![info exists fx_config($sa)]} {
	    set fx_config($sa) {}
	    foreach i $fx_config(\$search\$,sortby) {
		lappend fx_config($sa) yes
	    }
	}
}

itcl::body Fx_Menubar::SearchForEntry {} {
	return $searchfor_entry
}

itcl::body Fx_Menubar::SearchModeProc {} {
    global ::$mode_variable ::$status_variable ::$array \
	    ::fx_config ::$searchfor_variable ::fx_blt \
	    ::fx:search_modeval ::fx:add_modeval ::fx:readonly_modeval \
	    ::fx:change_modeval ::fx:search_statusval

    if {$fx_blt} {
	blt::busy hold .
    }
    update idletasks; update
    if {[RunChecks]} {
	if {$fx_blt} {
	    catch "blt::busy forget ."
	}
	return
    }
    if {[string compare [set $mode_variable] ${fx:readonly_modeval}] && \
	    [string compare [set $mode_variable] ${fx:search_modeval}] \
	    && [Fx_Attribute::TupleChanged]} {
	CheckNeedToSave
    }
    Fx_Entry::EnableReadOnlyWidgets 1
    Fx_Entry::DisableExcludedWidgets
    Fx_Attribute::DisableButtons
    if {[info exists beforesearchmode]} {
	eval $beforesearchmode
    }
    catch "qddb_tuple unlock $tuple"
    # Can only get here from Add, Change, Read-only modes
    # If in Change/Read-only mode, don't delete tuple (just view).
    Fx_Attribute::KillAllViews
    if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	if {$fx_config(auto_clear) == 0} {
	    if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		if {$isempty == 0} {
		    set added_tuple [qddb_tuple get external $tuple]
		} else {
		    catch {unset added_tuple}
		}
	    }
	}
	catch [list qddb_tuple delete $tuple]
	set tuple {}
	set view {}
	$this configure -view $view -tuple $tuple
    } else {
	catch [list qddb_view delete $view]
    }
    ::set $mode_variable ${fx:search_modeval}
    ::set $status_variable ${fx:search_statusval}
    # enable searchfor: box
    if {$searchfor} {
	$searchfor_label configure -state normal
	$searchfor_entry configure -state normal
    }
    bind Entry <Return> [list $this SearchProc]
    if {$fx_config(auto_clear) == 1 || ![info exists searchvar]} {
	foreach i $textvariables {
	    uplevel \#0 [list set $i {}]
	}
	set $searchfor_variable {}
    } else {
	if {[info exists searchvar]} {
	    foreach i $textvariables {
		uplevel \#0 [list set $i $searchvar($i)]
	    }
	}
    }
    Fx_Attribute::TupleChanged 0
    if {[info exists aftersearchmode]} {
	eval $aftersearchmode
    }
    after idle "focus $searchfor_entry"
    if {$fx_blt} {
	catch "blt::busy forget ."
    }
}
if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_menu.tcl"
}
