
itcl::body Fx_Menubar::SaveProc {} {
    global ::fx_config ::$status_variable ::$mode_variable ::$array ::fx:add_modeval ::fx:add_statusval
    global ::fx_blt

    if {[info exists beforesave]} {
	eval $beforesave
    }
    if {$fx_blt} {
	blt::busy hold .
	update idletasks; update
    }
    if {[Fx_Attribute::TupleChanged]} {
	if {[RunChecks]} {
	    if {$fx_blt} {
		catch "blt::busy forget ."
	    }
	    return
	}
    } else {
	::set $status_variable "Record has not been modified; save aborted."
	if {$fx_blt} {
	    catch "blt::busy forget ."
	}
	return
    }
    ::set $status_variable "Saving record..."
    update idletasks
    qddb_tuple write $tuple
    ::set $status_variable "Record has been saved."
    Fx_Attribute::TupleChanged 0
    if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	if {$fx_config(auto_clear) == 0} {
	    if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		if {$isempty == 0} {
		    set added_tuple [qddb_tuple get external $tuple]
		} else {
		    catch {unset added_tuple}
		}
	    }
	} else {
	    catch {unset added_tuple}
	}
	AddModeProc
	incr number_added
	::set $status_variable "Record saved; ${fx:add_statusval} ($number_added added)"
    }
    if {[info exists aftersave]} {
	eval $aftersave
    }
    if {$fx_blt} {
	catch "blt::busy forget ."
    }
}
itcl::body Fx_Menubar::RunChecks {} {
    global ::fx_config ::$mode_variable ::fx:add_modeval ::fx:change_modeval

    set foc [focus]
    if {([string compare [set $mode_variable] ${fx:add_modeval}] == 0 || \
	    [string compare [set $mode_variable] ${fx:change_modeval}] == 0) && \
	    [Fx_Attribute::TupleChanged]} {
	if {[Fx:CheckMandatoryFields $schema {} $array]} {
	    after idle "focus $foc"
	    return 1
	}
	if {[Fx:CurrentUniqueCheck $schema]} {
	    after idle "focus $foc"
	    return 1
	}
	if {[Fx:CurrentTypeCheck $schema]} {
	    after idle "focus $foc"
	    return 1
	}
    }
    return 0
}
itcl::body Fx_Menubar::QuitProc {} {
    global ::fx_config ::$mode_variable ::fx:add_modeval ::fx:change_modeval ::fx_blt

    if {[info exists beforequit]} {
	eval $beforequit
    }
    if {$fx_blt} {
	blt::busy hold .
	update idletasks; update
    }
    if {[RunChecks]} {
	if {$fx_blt} {
	    catch "blt::busy forget ."
	}
	return
    }
    if {$fx_config(auto_save)} {
	SavePersonalConfig
    }
    CheckNeedToSave
#    qddb_schema close $schema
#    qddb_table delete all
    if {[info exists afterquit]} {
	eval $afterquit
    }
    eval $exitproc
}
itcl::body Fx_Menubar::CheckNeedToSave {} {
    global ::$status_variable ::$mode_variable \
	    ::fx:add_modeval ::fx:change_modeval ::fx_config

    if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0 || \
	    [string compare [set $mode_variable] ${fx:change_modeval}] == 0} {
	if {[Fx_Attribute::TupleChanged]} {
	    if {$fx_config(auto_save_tuple) == 1} {
		set result 0
	    } else {
		set result [fx_dialog .dialog "WARNING" \
			"The current record has been modified.  Would you like to save it?" \
			warning 0 Yes No]
	    }
	    if {$result == 0} {
		if {[info exists beforesave]} {
		    eval $beforesave
		}		    
		::set $status_variable "Saving record..."
		update idletasks; update
		qddb_tuple write $tuple
		::set $status_variable "Record has been saved."
		update idletasks
		Fx_Attribute::TupleChanged 0
		if {[info exists aftersave]} {
		    eval $aftersave
		}
	    }
	}
    }
}
itcl::body Fx_Menubar::SearchProc {{keylist {}} {search_attrs {}}} {
    global ::$searchfor_variable ::$array ::$status_variable \
	    ::fx_config ::fx_blt ::fx:search_statusval ::fx_wait_on_config ::fx_excludewords

    if {$fx_blt} {
	blt::busy hold .
    }
    if {![info exists excludewords]} {
	set excludewords [qddb_schema excludewords $schema]
	foreach i $excludewords {
	    set fx_excludewords($i) ""
	}
    }
    ::set $status_variable "Searching..."
    update idletasks; update
    if {[string compare $keylist ""] == 0} {
	if {[string length [string trim [set $searchfor_variable]]] > 0} {
	    if {[catch \
		    [list Fx_QddbSearchParser::MultiSearch $schema [set $searchfor_variable]] \
		    k] != 0} {
		Fx:Dialog "Parse error" $k
		if {$fx_blt} {
		    catch "blt::busy forget ."
		}
		update idletasks
		set $status_variable ${fx:search_statusval}
		after idle "focus $searchfor_entry"
		return
	    }
	    if {[llength $k] == 0} {
		unset k
	    }
	}
	set search_attrs {}
	foreach i $attrs {
	    if {"[string index $i 0]" == "\$"} {
		continue
	    }
	    if {[string length [string trim [::set ${array}($i)]]] > 0} {
		if {[catch \
			[list Fx_QddbSearchParser::MultiSearch $schema [::set ${array}(${i})] on ${i}] \
			k1] != 0} {
		    Fx:Dialog "Parse error" $k1
		    if {[info exists k]} {
			qddb_keylist delete $k
		    }
		    if {$fx_blt} {
			catch "blt::busy forget ."
		    }
		    update idletasks
		    set $status_variable ${fx:search_statusval}
		    after idle "focus $searchfor_entry"
		    return
		}
		lappend search_attrs $i
		if {![info exists k]} {
		    set k $k1
		} else {
		    set k [qddb_keylist op intersection $k $k1]
		}
	    }
	}
    } else {
	set k $keylist
    }
    if {[info exists k]} {
	set k2 [qddb_keylist process nullop -copy on -deldup_sameentry on $k]
	set klen [qddb_keylist length $k2]
	qddb_keylist delete $k2
	if {[string compare $fx_config(hard_limit) unlimited] != 0 && $fx_config(hard_limit) < $klen} {
	    if {$fx_blt} {
		catch "blt::busy forget ."
	    }
	    update idletasks
	    fx_dialog .dialog "Hard Search Limit Exceeded" \
		    "You have requested to view rows for a total of $klen records.   This number exceeds the current hard limit.  You may not continue." \
		    error 0 Ok
	    qddb_keylist delete $k
	    ::set $status_variable ${fx:search_statusval}
	    return
	} elseif {[string compare $fx_config(soft_limit) unlimited] != 0 && \
		$fx_config(soft_limit) < $klen} {
	    if {$fx_blt} {
		catch "blt::busy forget ."
	    }
	    update idletasks
	    if {[fx_dialog .dialog "Soft Search Limit Exceeded" \
		    "You have requested to view rows for a total of $klen records.   This number exceeds the current soft limit.   Do you wish to continue?" \
		    warning 0 No Yes] == 0} {
		qddb_keylist delete $k
		::set $status_variable ${fx:search_statusval}
		return
	    }
	    if {$fx_blt} {
		blt::busy hold .
	    }
	}
	update idletasks
	set klen [qddb_keylist length $k]
	if {$klen > 0} {
	    if {[info exists last_search]} {
		KillLastSearch
	    }
	    ::set fx_wait_on_config 0
	    set pa \$search\$,print
	    set print_attrs {}
	    set user_attrs {}
	    foreach i $fx_config($pa) {
		if {"[string index $i 0]" != "\$"} {
		    lappend print_attrs $i
		} else {
		    lappend user_attrs $i
		}
	    }
	    set pa \$search\$,sortby
	    set sort_attrs {}
	    foreach i $fx_config($pa) {
		if {"[string index $i 0]" != "\$"} {
		    lappend sort_attrs $i
		}
	    }
	    set asc {}
	    set asc_attrs {}
	    set x 0
	    foreach i $fx_config(\$search\$,ascending) {
		if {[string compare $i yes] == 0} {
		    set thisasc [lindex $fx_config(\$search\$,sortby) $x]
		    lappend asc $thisasc
		    if {"[string index $thisasc 0]" != "\$"} {
			lappend asc_attrs $thisasc
		    }
		}
		incr x
	    }
	    ::set $status_variable "Reading data..."
	    update idletasks; update
	    if {[llength $search_attrs] > 0} {
		if {[llength $user_attrs] == 0} {
		    if {[info exists fx_config(\$search\$,unsorted)] && \
			    $fx_config(\$search\$,unsorted)} {
			set last_search [qddb_rows select -format table \
				-flush on -rowdescs on \
				-print $print_attrs $k]
			if {[string length $last_search] > 0} {
			    Fx:UserDefinedTable $last_search \$search\$ fx_config
			}
		    } else {
			set last_search [qddb_rows select -format table \
				-flush on -rowdescs on \
				-ascending $asc -sortby $fx_config(\$search\$,sortby) \
				-print $print_attrs $k]
			if {[string length $last_search] > 0} {
			    Fx:UserDefinedTable $last_search \$search\$ fx_config
			}
		    }
		} else {
		    set last_search [qddb_rows select -format table \
			    -flush on -rowdescs on \
			    -sortby $sort_attrs \
			    -ascending $asc_attrs \
			    -print $print_attrs $k]
		    if {[string length $last_search] > 0} {
			Fx:UserDefinedTable $last_search \$search\$ fx_config
			if {![info exists fx_config(\$search\$,unsorted)] || \
				!$fx_config(\$search\$,unsorted)} {
			    qddb_table sort $last_search -ascending $asc \
				    -sortby $fx_config(\$search\$,sortby)
			}
		    }
		}
	    } else {
		if {[llength $user_attrs] == 0} {
		    if {[info exists fx_config(\$search\$,unsorted)] && \
			    $fx_config(\$search\$,unsorted)} {
			set last_search [qddb_rows select -format table \
				-flush on -rowdescs on \
				-print $print_attrs $k]
			if {[string length $last_search] > 0} {
			    Fx:UserDefinedTable $last_search \$search\$ fx_config
			}
		    } else {
			set last_search [qddb_rows select -format table \
				-flush on -rowdescs on \
				-ascending $asc -sortby $fx_config(\$search\$,sortby) \
				-print $print_attrs $k]
			if {[string length $last_search] > 0} {
			    Fx:UserDefinedTable $last_search \$search\$ fx_config
			}
		    }
		} else {
		    set last_search [qddb_rows select -format table \
			    -flush on -rowdescs on \
			    -sortby $sort_attrs \
			    -ascending $asc_attrs \
			    -print $print_attrs $k]
		    if {[string length $last_search] > 0} {
			Fx:UserDefinedTable $last_search \$search\$ fx_config
			if {![info exists fx_config(\$search\$,unsorted)] || \
				!$fx_config(\$search\$,unsorted)} {
			    qddb_table sort $last_search -ascending $asc \
				    -sortby $fx_config(\$search\$,sortby)
			}
		    }
		}
	    }
	    set last_search_was_null 0
	    qddb_keylist delete $k
	    if {[string length $last_search] > 0 && $search_results == 1} {
		DisplayLastSearch 0 0 0
		update idletasks
	    } else {
		set last_search_was_null 1
		::set $status_variable "No matches found."
	    }
	} else {
	    set last_search_was_null 1
	    ::set $status_variable "No matches found."
	}
    } else {
	set last_search_was_null 1
	::set $status_variable "No query specified."
    }
    if {[info exists aftersearch]} {
	eval $aftersearch
    }
    if {$fx_blt} {
	catch {blt::busy forget .}
    }
}
itcl::body Fx_Menubar::ExpertSearchProc {} {
    global ::fx_config ::$status_variable ::fx_excludewords

    update idletasks
    if {[string length $restrict] == 0} {
	set res {}
    } else {
	set res $restrict/:expert_search:
    }
    if {![info exists excludewords]} {
	set excludewords [qddb_schema excludewords $schema]
	foreach i $excludewords {
	    set fx_excludewords($i) ""
	}
    }
    if {[info exists fx_config(current_expert_search)]} {
	set l [Fx:ExpertSearchWindow .expert_search $schema $res $fx_config(current_expert_search)]
    } else {
	set l [Fx:ExpertSearchWindow .expert_search $schema $res ""]
    }
    if {[lindex $l 0] == 1} {
	::set $status_variable "Searching..."
	update idletasks
	set fx_config(current_expert_search) [lindex $l 1]
	if {[catch [list Fx:ExpertSearchParser $schema [lindex $l 1]] l] != 0} {
	    fx_dialog .dialog "Expert search error" \
		    "Expert search error:\n$l" error 0 Ok
	    ::set $status_variable "Expert search failed!"
	    update idletasks
	    return
	}
	update idletasks
	SearchProc [lindex $l 1] [Fx:UniqueList [lindex $l 0]]
    }
}
itcl::body Fx_Menubar::DeleteProc {} {
    eval $beforetupledelete
    catch "qddb_tuple remove $tuple"
    if {[info exists last_search] && [string length $last_search] > 0} {
	set maxnum [qddb_table row maxnum $last_search]
	for {set i 1} {$i <= $maxnum} {incr i} {
	    set t [lindex [qddb_table row cget $last_search $i -comment] 0]
	    if {[string compare $t $tuple] == 0} {
		qddb_table row delete $last_search $i
		incr i -1
		incr maxnum -1
	    }
	}
	Fx_Attribute::TupleChanged 0
	if {[winfo exists .search_results]} {
	    DisplayLastSearch 0 1
	}
    }
    SearchModeProc
    if {[winfo exists .search_results]} {
	wm withdraw .search_results
	wm deiconify .search_results
    }
}
itcl::body Fx_Menubar::ClearProc {} {
    global ::$mode_variable ::$searchfor_variable ::$array \
	    ::fx:search_modeval ::fx:add_modeval
    
    if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	catch [list qddb_tuple delete $tuple]
	set tuple [qddb_tuple new $schema]
	set view [qddb_view define $tuple $attr_pairs]
	$this configure -view $view -tuple $tuple
	Fx_Attribute::TupleChanged 0
    } else {
	if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	    set $searchfor_variable {}
	}
	foreach i [array names $array] {
	    ::set ${array}($i) {}
	}
    }
}
itcl::body Fx_Menubar::UndoProc {} {
    global ::fx_config ::$status_variable ::$mode_variable \
	    ::fx:readonly_modeval ::fx:change_modeval \
	    ::fx:change_statusval ::fx:readonly_statusval

    catch "qddb_tuple refresh $tuple"
    Fx_Attribute::TupleChanged 0
    if {$fx_config(force_readonly_mode) == 0 && [qddb_tuple lock $tuple]} {
	Fx_Entry::EnableReadOnlyWidgets 1
	Fx_Entry::DisableReadOnlyWidgets 0
	::set $mode_variable ${fx:change_modeval}
	::set $status_variable ${fx:change_statusval}
	Fx_Attribute::TupleChanged 0
    } else {
	catch [list qddb_tuple unlock $tuple]
	Fx_Attribute::DisableAddDeleteButtons
	Fx_Entry::DisableReadOnlyWidgets 1
	::set $mode_variable ${fx:readonly_modeval}
	::set $status_variable ${fx:readonly_statusval}
	Fx_Attribute::TupleChanged 0
    }
}
# Modes menu methods
itcl::body Fx_Menubar::AddModeProc {} {
    global ::$mode_variable ::$status_variable ::$array ::fx_config \
	    ::fx:search_modeval ::fx:add_modeval ::fx:readonly_modeval \
	    ::fx:add_statusval ::fx_blt
    
    update; update idletasks
    if {$fx_blt} {
	blt::busy hold .
    }
    update idletasks
    if {[RunChecks]} {
	if {$fx_blt} {
	    catch "blt::busy forget ."
	}
	return
    }
    if {[string compare [set $mode_variable] ${fx:search_modeval}] && \
	    [string compare [set $mode_variable] ${fx:readonly_modeval}] \
	    && [Fx_Attribute::TupleChanged]} {
	CheckNeedToSave
    }
    if {[info exists beforeaddmode]} {
	eval $beforeaddmode
    }
    Fx_Attribute::EnableButtons
    Fx_Entry::EnableReadOnlyWidgets 1
    Fx_Entry::EnableExcludedWidgets
    Fx_Entry::DisableReadOnlyWidgets 0
    catch "qddb_tuple unlock $tuple"
    Fx_Attribute::KillAllViews
    if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	catch "qddb_tuple delete $tuple"
    }
    if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	foreach i $textvariables {
	    set searchvar($i) [set $i]
	}
    }
    ::set $mode_variable ${fx:add_modeval}
    ::set $status_variable ${fx:add_statusval}
    if {$searchfor} {
	$searchfor_label configure -state disabled
	$searchfor_entry configure -state disabled
    }
    bind Entry <Return> { }
    catch [list qddb_view delete $view]
    if {$fx_config(auto_clear) == 1} {
	catch [list unset added_tuple]
    }
    if {[info exists added_tuple] && $fx_config(auto_clear) == 0} {
	set tuple [qddb_tuple put external $schema $added_tuple]
    } else {
	set tuple [qddb_tuple new $schema]
    }
    set view [qddb_view define $tuple $attr_pairs]
    $this configure -view $view -tuple $tuple
    if {[info exists afteraddmode]} {
	eval $afteraddmode
    }
    Fx_Entry::InitFocus
    Fx_Attribute::TupleChanged 0
    if {$fx_blt} {
	catch "blt::busy forget ."
    }
}
itcl::body Fx_Menubar::ChangeModeProc {idx {takefocus 1}} {
    global ::$status_variable ::$mode_variable ::fx_config ::fx_blt ::$array \
	    ::fx:search_modeval ::fx:add_modeval ::fx:readonly_modeval \
	    ::fx:change_modeval ::fx:change_statusval

    if {$fx_blt} {
	blt::busy hold .
    }
    update idletasks
    if {[RunChecks]} {
	if {$fx_blt} {
	    catch "blt::busy forget ."
	}
	return
    }
    if {[string compare [set $mode_variable] ${fx:search_modeval}] && \
	    [string compare [set $mode_variable] ${fx:readonly_modeval}] \
	    && [Fx_Attribute::TupleChanged]} {
	CheckNeedToSave
    }
    if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0 || \
	    [string compare [set $mode_variable] ${fx:readonly_modeval}] == 0} {
	Fx_Attribute::EnableButtons
	Fx_Entry::EnableReadOnlyWidgets 1
	Fx_Entry::EnableExcludedWidgets
	Fx_Entry::DisableReadOnlyWidgets 0
    }
    if {[info exists beforechangemode]} {
	eval $beforechangemode
    }
    catch "qddb_tuple unlock $tuple"
    Fx_Attribute::KillAllViews
    if {$fx_config(auto_clear) == 0} {
	if {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	    if {[catch [list qddb_tuple isempty $tuple] isempty] == 0} {
		if {$isempty == 0} {
		    set added_tuple [qddb_tuple get external $tuple]
		} else {
		    catch {unset added_tuple}
		}
	    }
	    catch [list qddb_tuple delete $tuple]
	} elseif {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	    foreach i $textvariables {
		set searchvar($i) [set $i]
	    }
	}
	catch [list qddb_view delete $view]
    } else {
	catch [list qddb_view delete $view]
    }
    ::set $mode_variable ${fx:change_modeval}
    ::set $status_variable ${fx:change_statusval}
    bind Entry <Return> { }
    set myrow [lindex [qddb_table row cget $last_search [expr $idx + 1] -comment] 1]
    set changemodeidx $idx
    set tuple [qddb_rows tuplename $myrow]
    set view [qddb_view define $myrow $attr_pairs]
    $this configure -view $view -tuple $tuple
    if {[info exists fx_config(force_readonly_mode)] && $fx_config(force_readonly_mode)} {
	ReadOnlyModeProc
	set readonly 1
    } elseif {[qddb_tuple lock $tuple] == 0} {
	ReadOnlyModeProc
	set readonly 1
    } else {
	set readonly 0
    }
    if {$searchfor} {
	$searchfor_label configure -state disabled
	$searchfor_entry configure -state disabled
    }
    Fx_Attribute::TupleChanged 0
    if {[info exists afterchangemode]} {
	eval $afterchangemode
    }
    if {!$readonly} {
	if {$takefocus} {
	    Fx_Entry::InitFocus
	}
    }
    if {$fx_blt} {
	catch "blt::busy forget ."
    }
}
itcl::body Fx_Menubar::ToChangeModeProc {} {
    ChangeModeProc $changemodeidx
}
itcl::body Fx_Menubar::ReadOnlyModeProc {} {
    global ::$mode_variable ::$status_variable ::fx:readonly_modeval ::fx:readonly_statusval
    
    if {[info exists beforereadonlymode]} {
	eval $beforereadonlymode
    }
    catch "qddb_tuple unlock $tuple"
    Fx_Attribute::DisableAddDeleteButtons
    Fx_Entry::DisableReadOnlyWidgets 1
    ::set $mode_variable ${fx:readonly_modeval}
    ::set $status_variable ${fx:readonly_statusval}
    update idletasks
    if {[info exists afterreadonlymode]} {
	eval $afterreadonlymode
    }
    after idle "focus ."
}
itcl::body Fx_Menubar::ReadTemplateProc {} {
    global ::fx_config ::$status_variable

    if {[string length $restrict] != 0} {
	set t [Fx:FileSelect .readtempl r $restrict/Templates]
    } else {
	set t [Fx:FileSelect .readtempl r $restrict]
    }
    if {[llength $t] > 0} {
	::set fx_config(current_template) $t
    } else {
	return
    }
    if {[catch InsertLastTemplateProc err] != 0} {
	::set $status_variable "Cannot read template: $err"
    } else {
	::set $status_variable "Template successfully read."
    }
}
itcl::body Fx_Menubar::InsertLastTemplateProc {} {
    global ::fx_config ::$status_variable ::$mode_variable ::$array ::fx:search_modeval

    if {[catch [list Fx:ReadFile $fx_config(current_template)] buf] != 0} {
	::set $status_variable "Cannot read template: $buf"
	return
    }
    if {[catch [list qddb_tuple put readable $schema $buf] err] != 0} {
	::set $status_variable "$err"
	return
    } else {
	if {[info exists beforereadtemplate]} {
	    eval $beforereadtemplate
	}
	if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	    set v [qddb_view define $err {}]
	    foreach i [qddb_schema leaves $schema] {
		::set ${array}($i) [qddb_instance getval $v $i]
	    }
	    qddb_tuple delete $err
	} else {
	    catch [list qddb_tuple delete $tuple]
	    set tuple $err
	    set view [qddb_view define $tuple $attr_pairs]
	    $this configure -view $view -tuple $tuple
	    Fx_Attribute::TupleChanged 0
	    ::set $status_variable "Template successfully read."
	}
	if {[info exists afterreadtemplate]} {
	    eval $afterreadtemplate
	}
    }
    ::Fx_Attribute::TupleChanged 1
}
itcl::body Fx_Menubar::WriteTemplateProc {} {
    global ::fx_config ::$status_variable ::$mode_variable ::$array \
	    ::fx:search_modeval

    if {[string length $restrict] != 0} {
	set t [Fx:FileSelect .writetempl w $restrict/Templates]
    } else {
	set t [Fx:FileSelect .writetempl w $restrict]
    }
    if {[llength $t] > 0} {
	::set fx_config(current_template) $t
    } else {
	return
    }
    if {[info exists beforewritetemplate]} {
	eval $beforewritetemplate
    }
    if {[string compare ${fx:search_modeval} [set $mode_variable]] == 0} {
	set t [qddb_tuple new $schema]
	set v [qddb_view define $t {}]
	foreach i [qddb_schema leaves $schema] {
	    if {[string compare [::set ${array}($i)] ""] != 0} {
		catch "qddb_instance setval $v $i [::set ${array}($i)]"
	    }
	}
	if {[catch [list qddb_tuple get readable $t] buf] != 0} {
	    ::set $status_variable $buf
	    qddb_tuple delete $t
	    return
	}
	qddb_tuple delete $t
    } else {
	if {[catch [list qddb_tuple get readable $tuple] buf] != 0} {
	    ::set $status_variable $buf
	    return
	}
    }
    if {[info exists afterwritetemplate]} {
	eval $afterwritetemplate
    }
    if {[catch [list Fx:WriteFile $fx_config(current_template) $buf] err] != 0} {
	::set $status_variable "Cannot write template: $err"
    } else {
	::set $status_variable "Template successfully written."
    }
}

# View menu methods
itcl::body Fx_Menubar::DisplayLastSearch {{do_sort 0} {reconfig 0} {do_hold 1}} {
    global ::fx_config ::$status_variable ::fx_blt ::fx_wait_on_config ::qddb_library

    if {![info exists last_search] || [string length $last_search] == 0} {
	return
    }
    update; update idletasks
    if {$fx_blt && $do_hold} {
	blt::busy hold .
    }
    update idletasks
    if {[winfo exists .search_results]} {
	if {$reconfig} {
	    set curselect [.search_results.f.l2 curselection]
	    set nearesty  [.search_results.f.l2 nearest 0]
	    search_results ClearRows
	    search_results ClearContents
	} else {
	    catch "delete object search_results"
	    catch "destroy .search_results"	    
	}
    }
    set ls_len [qddb_table row maxnum $last_search]
    if {$ls_len == 1} {
	::set $status_variable "1 row found..."
	ChangeModeProc 0
	return
    }
    ::set $status_variable "Formatting..."
    update idletasks
    if {$ls_len == 0} {
	set last_search_was_null 1
	SearchModeProc
	::set $status_variable "No matches found."
	return
    }
    # ls_len > 1
    ::set $status_variable "$ls_len rows found..."
    update idletasks
    if {!$reconfig} {
	toplevel .search_results
	wm title .search_results "Search Results"
	wm protocol .search_results WM_DELETE_WINDOW [list catch "destroy .search_results; \
		delete object Fx_Menubar::search_results"]
	if {[info exists fx_config(geom,search_results)]} {
	    wm geometry .search_results $fx_config(geom,search_results)
	}
	set f .search_results.f2
	frame $f
	pack $f -side bottom -fill x
	button $f.select -text Select -command {Fx_Menubar::search_results OnSelect}
	pack $f.select -side left -padx 6m -pady 2m -ipadx 6m -ipady 2m
	button $f.cancel -text Dismiss -command {
	    catch "delete object Fx_Menubar::search_results"
	    catch "destroy .search_results"
	}
	pack $f.cancel -side left -padx 6m -pady 2m -ipadx 6m -ipady 2m
	set px [$f.select cget -padx]
	set py [$f.select cget -pady]
	button $f.print -text Print -command [list $this PrintLastSearch]
	set buttfont [$f.print cget -font]
	checkbutton $f.pin -text "Pin" -variable fx_config(pin,search_results) \
		-onvalue 1 -offvalue 0 -padx $px -pady $py -font $buttfont
	pack $f.pin -side right -padx 6m -pady 2m -ipadx 6m -ipady 2m
	pack $f.print -side right -padx 6m -pady 2m -ipadx 6m -ipady 2m
    }
    if {$fx_wait_on_config == 0} {
	if {[info exists fx_config(\$search\$,linenumbers)]} {
	    set rowtitles $fx_config(\$search\$,linenumbers)
	} else {
	    set rowtitles 0
	}
    }
    set mytext [qddb_table getval $last_search -format rows -coltitles on -rowtitles $rowtitles]
    if {!$reconfig} {
	Fx_SingleColumnListBox search_results -w .search_results.f \
		-headings [lindex $mytext 0] \
		-width 60 \
		-exportselection off \
		-single_select on \
		-height 10 -onselect "$this PinnedSearchResultsProc"
	search_results AppendRows [lrange $mytext 1 end]
	search_results Display
    } else {
	search_results configure \
		-headings [lindex $mytext 0] \
		-width 60 \
		-single_select on \
		-exportselection off
	search_results AppendRows [lrange $mytext 1 end]
	search_results Display 1
    }
    if {$reconfig} {
	.search_results.f.l2 select clear 0 end
	.search_results.f.l2 select set $curselect $curselect
	.search_results.f.l2 select anchor $curselect
	.search_results.f.l2 activate $curselect
	.search_results.f.l2 yview $nearesty
    }
    if {$fx_blt && $do_hold} {
	catch "blt::busy forget ."
    }
    if {!$reconfig} {
	bind .search_results <Configure> {
	    set fx_config(geom,search_results) [wm geometry .search_results]
	}
	if {[info exists fx_config(geom,search_results)]} {
	    wm geometry .search_results $fx_config(geom,search_results)
	}
    }
}
itcl::body Fx_Menubar::PinnedSearchResultsProc {i} {
    global ::fx_config ::fx_blt
    
    if {![info exists fx_config(pin,search_results)] || $fx_config(pin,search_results) == 0} {
	catch "destroy .search_results"
	catch "delete object search_results"
	$this ChangeModeProc $i
    } else {
	if {[winfo exists .search_results]} {
	    set dohold 1
	} else {
	    set dohold 0
	}
	if {$fx_blt && $dohold} {
	    blt::busy hold .search_results
	}
	$this ChangeModeProc $i 0
	if {$fx_blt && $dohold} {
	    catch "blt::busy forget .search_results"
	}
    }
}
itcl::body Fx_Menubar::PrintLastSearch {} {
    global ::fx_config ::$status_variable ::fx_blt ::fx_wait_on_config

    Fx_PrintDialog $this.print_dialog
    if {$fx_config(cancel_print) == 0} {
	if {$fx_blt} {
	    blt::busy hold .
	    if {[winfo exists .search_results]} {
		blt::busy hold .search_results
	    }
	}
	update idletasks
	if {$fx_wait_on_config == 0} {
	    if {[info exists fx_config(\$search\$,linenumbers)]} {
		set rowtitles $fx_config(\$search\$,linenumbers)
	    } else {
		set rowtitles 0
	    }
	}
	Fx:Print [qddb_table getval $last_search -format rows -coltitles on -rowtitles $rowtitles]
	if {$fx_blt} {
	    catch "blt::busy forget ."
	    if {[winfo exists .search_results]} {
		catch "blt::busy forget .search_results"
	    }
	}
	if {[winfo exists .search_results]} {
	    if {[catch "focus -lastfor .search_results" resultswin] == 0} {
		after idle "catch [list focus $resultswin]"
	    }
	}
    } else {
	::set $status_variable "Printing cancelled."
    }
}
itcl::body Fx_Menubar::KillLastSearch {} {
    global ::$mode_variable ::$status_variable ::$array ::fx_config \
	    ::fx:search_modeval ::fx:add_modeval ::fx:readonly_modeval \
	    ::fx:change_modeval ::fx:search_statusval ::fx_wait_on_config

    if {[string compare [set $mode_variable] ${fx:readonly_modeval}] && \
	    [string compare [set $mode_variable] ${fx:search_modeval}] \
	    && [Fx_Attribute::TupleChanged]} {
	CheckNeedToSave
    }
    ::set $status_variable "Killing last search..."
    ::set fx_wait_on_config 0
    update idletasks
    if {[info exists last_search] && [string length $last_search] > 0} {
	set maxnum [qddb_table row maxnum $last_search]
	for {set i 1} {$i <= $maxnum} {incr i} {
	    catch [list qddb_tuple delete [lindex [qddb_table row cget $last_search $i -comment] 0]]
	}
	qddb_table delete $last_search
    }
    catch {unset last_search}
    if {[winfo exists .search_results]} {
	catch "delete object search_results"
	catch "destroy .search_results"
    }
}

# Menu posting methods
itcl::body Fx_Menubar::FilePostMenu {} {
    global ::$mode_variable ::fx:search_modeval ::fx:readonly_modeval

    set m [set $mode_variable]
    set fe $tearoffs
    if {[string compare $m ${fx:search_modeval}] == 0 || \
	    [string compare $m ${fx:readonly_modeval}] == 0} {
	$w.file.menu entryconfigure $fe -state disabled
    } elseif {[Fx_Attribute::TupleChanged] == 0 || [qddb_tuple isempty $tuple] || \
	    [string compare $m ${fx:readonly_modeval}] == 0} {
	$w.file.menu entryconfigure $fe -state disabled
    } else {
	$w.file.menu entryconfigure $fe -state normal
    }
    if {[info exists afterpost_file]} {
	eval $afterpost_file
    }
}
itcl::body Fx_Menubar::EditPostMenu {} {
    global ::$mode_variable ::fx:search_modeval ::fx:add_modeval ::fx:change_modeval

    set fe $tearoffs
    set menu(search) $fe
    set menu(expert_search) [expr $fe + 1]
    set menu(reports) [expr $fe + 3]
    set menu(copy) [expr $fe + 5]
    set menu(cut) [expr $fe + 6]
    set menu(paste) [expr $fe + 7]
    set menu(clear) [expr $fe + 9]
    set menu(delete) [expr $fe + 10]
    set menu(undo) [expr $fe + 11]

    if {[info exists cutbuffer]} {
	$w.edit.menu entryconfigure $menu(paste) -state normal
    } else {
	$w.edit.menu entryconfigure $menu(paste) -state disabled
    }
    if {[string compare [set $mode_variable] ${fx:search_modeval}] == 0} {
	$w.edit.menu entryconfigure $menu(search) -state normal
	$w.edit.menu entryconfigure $menu(expert_search) -state normal
	$w.edit.menu entryconfigure $menu(reports) -state normal
	$w.edit.menu entryconfigure $menu(clear) -state normal
	$w.edit.menu entryconfigure $menu(delete) -state disabled
	$w.edit.menu entryconfigure $menu(undo) -state disabled
    } elseif {[string compare [set $mode_variable] ${fx:add_modeval}] == 0} {
	$w.edit.menu entryconfigure $menu(search) -state disabled
	$w.edit.menu entryconfigure $menu(expert_search) -state disabled
	$w.edit.menu entryconfigure $menu(reports) -state disabled
	if {[qddb_tuple isempty $tuple]} {
	    $w.edit.menu entryconfigure $menu(clear) -state disabled
	} else {
	    $w.edit.menu entryconfigure $menu(clear) -state normal
	}
	$w.edit.menu entryconfigure $menu(delete) -state disabled
	$w.edit.menu entryconfigure $menu(undo) -state disabled
    } else {
	$w.edit.menu entryconfigure $menu(search) -state disabled
	$w.edit.menu entryconfigure $menu(expert_search) -state disabled
	$w.edit.menu entryconfigure $menu(reports) -state disabled
	$w.edit.menu entryconfigure $menu(clear) -state disabled
	if {[string compare [set $mode_variable] ${fx:change_modeval}] == 0} {
	    $w.edit.menu entryconfigure $menu(delete) -state normal
	} else {
	    $w.edit.menu entryconfigure $menu(delete) -state disabled
	}
	$w.edit.menu entryconfigure $menu(undo) -state normal
    }
    if {[catch "selection get" tmpsel]} {
	$w.edit.menu entryconfigure $menu(copy) -state disabled
	$w.edit.menu entryconfigure $menu(cut) -state disabled
    } else {
	$w.edit.menu entryconfigure $menu(copy) -state normal
	$w.edit.menu entryconfigure $menu(cut) -state normal
    }
    if {[catch {selection get -selection CLIPBOARD} mybuf]} {
	$w.edit.menu entryconfigure $menu(paste) -state disabled
    } else {
	$w.edit.menu entryconfigure $menu(paste) -state normal
    }
    if {[info exists afterpost_edit]} {
	eval $afterpost_edit
    }
}
itcl::body Fx_Menubar::ModesPostMenu {} {
    global ::fx_config ::$mode_variable ::fx:search_modeval \
	    ::fx:add_modeval ::fx:change_modeval

    set fe $tearoffs
    set m [set $mode_variable]
    if {[string compare $m ${fx:search_modeval}] == 0} {
	$w.modes.menu entryconfigure [expr $fe + 0] -state disabled
	$w.modes.menu entryconfigure [expr $fe + 1] -state normal
	$w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	$w.modes.menu entryconfigure [expr $fe + 3] -state disabled
    } elseif {[string compare $m ${fx:add_modeval}] == 0} {
	$w.modes.menu entryconfigure [expr $fe + 0] -state normal
	$w.modes.menu entryconfigure [expr $fe + 1] -state disabled
	$w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	$w.modes.menu entryconfigure [expr $fe + 3] -state disabled
    } elseif {[string compare $m ${fx:change_modeval}] == 0} {
	$w.modes.menu entryconfigure [expr $fe + 0] -state normal
	$w.modes.menu entryconfigure [expr $fe + 1] -state normal
	$w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	$w.modes.menu entryconfigure [expr $fe + 3] -state normal
    } else {
	$w.modes.menu entryconfigure [expr $fe + 0] -state normal
	$w.modes.menu entryconfigure [expr $fe + 1] -state normal
	if {$fx_config(force_readonly_mode)} {
	    $w.modes.menu entryconfigure [expr $fe + 2] -state disabled
	} else {
	    $w.modes.menu entryconfigure [expr $fe + 2] -state normal
	}
	$w.modes.menu entryconfigure [expr $fe + 3] -state disabled
    }
    if {[info exists afterpost_modes]} {
	eval $afterpost_modes
    }
}
itcl::body Fx_Menubar::ViewPostMenu {} {
    set fe $tearoffs
    if {![info exists last_search] || $search_results == 0} {
	$w.view.menu entryconfigure [expr $fe + 0] -state disabled
    } else {
	$w.view.menu entryconfigure [expr $fe + 0] -state normal
    }
    if {[info exists afterpost_view]} {
	eval $afterpost_view
    }
}
itcl::body Fx_Menubar::TemplatesPostMenu {} {
    global ::fx_config ::$mode_variable ::fx:search_modeval ::fx:add_modeval

    set fe $tearoffs
    set m [set $mode_variable]
    if {[string compare $m ${fx:add_modeval}] == 0 || [string compare $m ${fx:search_modeval}] == 0} {
	$w.templates.menu entryconfigure [expr $fe + 0] -state normal
	if {[info exists fx_config(current_template)]} {
	    $w.templates.menu entryconfigure [expr $fe + 1] -state normal
	} else {
	    $w.templates.menu entryconfigure [expr $fe + 1] -state disabled
	}
	$w.templates.menu entryconfigure [expr $fe + 2] -state normal
    } else {
	$w.templates.menu entryconfigure [expr $fe + 0] -state disabled
	$w.templates.menu entryconfigure [expr $fe + 1] -state disabled
	$w.templates.menu entryconfigure [expr $fe + 2] -state normal
    }
    if {[info exists afterpost_templates]} {
	eval $afterpost_templates
    }
}
itcl::body Fx_Menubar::ConfigPostMenu {} {
    global ::fx_config ::$mode_variable ::fx:search_modeval ::fx:add_modeval

    set fe $tearoffs
    set m [set $mode_variable]
    if {[string compare $m ${fx:search_modeval}] == 0} {
	$w.config.menu entryconfigure [expr $fe + 14] -state normal
    } else {
	$w.config.menu entryconfigure [expr $fe + 14] -state disabled
    }
    if {[info exists afterpost_templates]} {
	eval $afterpost_configure
    }
}
itcl::body Fx_Menubar::ConfigureSearchResults {} {
    global ::$status_variable

    if {[Fx:BusyExec . [list Fx:ConfigureSearchResults $schema $restrict_dir]] == 1} {
	set $status_variable "Search Results Configuration Changed"
    }
    InitConfig 0
}
itcl::body Fx_Menubar::SavePersonalConfig {} {
    global ::fx_config ::$status_variable \
	    ::fx_lettersetup ::fx_postcardsetup ::fx_emailsetup

    set path [qddb_schema path $schema]
    set fn [split $path /]
    set fn [join $fn .]
    set home [glob ~]
    if {![file isdirectory $home/$config_dir]} {
	while {[catch "exec mkdir $home/$config_dir" msg] != 0} {
	    fx_dialog .dialog "ERROR" \
		    "Cannot create directory $home/$config_dir; please remedy the situation and hit OK" \
		    error 0 OK
	}
    }
    set fd [open $home/$config_dir/$fn "w"]
    foreach i [array names fx_config] {
	puts $fd [list set fx_config($i) $fx_config($i)]
    }
    foreach i [array names fx_lettersetup] {
	puts $fd [list set fx_lettersetup($i) $fx_lettersetup($i)]
    }
    foreach i [array names fx_postcardsetup] {
	puts $fd [list set fx_postcardsetup($i) $fx_postcardsetup($i)]
    }
    foreach i [array names fx_emailsetup] {
	puts $fd [list set fx_emailsetup($i) $fx_emailsetup($i)]
    }
    SaveOptions $fd
    close $fd
    ::set $status_variable "Personal configuration saved"
}
itcl::body Fx_Menubar::SaveOptions {fd} {
    global ::fx_resources ::fx_font

    foreach i [array names fx_font] {
	puts $fd [list set fx_font($i) $fx_font($i)]
    }
    foreach i $fx_resources {
	set j [split $i .]
	if {[string compare [lindex $j 1] font] != 0} {
	    set val [option get . [lindex $j 1] [lindex $j 0]]
	    if {[string compare $val ""] != 0} {
		puts $fd "option add *$i $val"
	    }
	}
    }
}
itcl::body Fx_Menubar::SaveGlobalConfig {} {
    global ::fx_config ::$status_variable \
	    ::fx_lettersetup ::fx_postcardsetup ::fx_emailsetup

    set path [qddb_schema path $schema]
    set fd [open $path/$config_dir "w"]
    foreach i [array names fx_config] {
	puts $fd [list set fx_config($i) $fx_config($i)]
    }
    foreach i [array names fx_lettersetup] {
	puts $fd [list set fx_lettersetup($i) $fx_lettersetup($i)]
    }
    foreach i [array names fx_postcardsetup] {
	puts $fd [list set fx_postcardsetup($i) $fx_postcardsetup($i)]
    }
    foreach i [array names fx_emailsetup] {
	puts $fd [list set fx_emailsetup($i) $fx_emailsetup($i)]
    }
    SaveOptions $fd
    close $fd
    ::set $status_variable "Global configuration saved"
}
itcl::body Fx_Menubar::GetLastSearch {} {
    if {[info exists last_search]} {
	return $last_search
    } else {
	return {}
    }
}
itcl::body Fx_Menubar::LastSearchWasNull {} {
    return $last_search_was_null
}
itcl::body Fx_Menubar::SetLastSearch {table} {
    global ::fx_config ::fx_blt

    if {$fx_blt} {
	blt::busy hold .
	if {[winfo exists .search_results]} {
	    destroy .search_results
	}
    }
    update idletasks
    KillLastSearch
    set last_search $table
    if {$fx_blt} {
	catch "blt::busy forget ."
    }
}
itcl::body Fx_Menubar::DumpConfig {} {
    global ::fx_config
    foreach i [array names fx_config] {
	puts "fx_config(${i}): $fx_config($i)"
    }
}
itcl::body Fx_Menubar::GetView {} {
    return $view
}
itcl::body Fx_Menubar::ReportProc {} {
    global ::fx_excludewords

    if {![info exists excludewords]} {
	set excludewords [qddb_schema excludewords $schema]
	foreach i $excludewords {
	    set fx_excludewords($i) ""
	}
    }
    if {[string length $restrict] == 0} {
	set res [glob ~]/.fx_applications/[join [split [qddb_schema path $schema] /] .]
    } else {
	set res $restrict
    }
    after idle [list Fx:BusyExec . [list Fx:Report_Generator $schema $res]]
}
if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_menu-p.tcl"
}

