
# set fx_debug to 1 if you want debugging
#set fx_debug 1

if {[winfo screendepth .] >= 8} {
    set fx_monochrome 0
} else {
    set fx_monochrome 1
}
if {![info exists fx_perform_global_grabs]} {
    set fx_perform_global_grabs 0
}
set fx_font_config(families) {
    charter courier fixed helvetica lucida 
    lucidabright lucidatypewriter {new century schoolbook} 
    times utopia
}
set fx_font_config(slants) {italic oblique roman}
set fx_font_config(weights) {bold demibold medium}
set fx_font_config(sizes) {80 100 140 180 240}
set fx_font_config(sizenames) {tiny small medium large huge}

set fx_font_config(default_size) small
set fx_font_config(default_weight) bold
set fx_font_config(default_slant) roman
set fx_font_config(default_family) courier

proc Fx:LoadPersonalConfig {schema} {
    global fx_config fx_font fx_config_dir \
	    fx_lettersetup fx_postcardsetup fx_emailsetup

    set path [qddb_schema path $schema]
    set fn [split $path /]
    set fn [join $fn .]
    set home [glob ~]
    if {[file isdirectory $home/$fx_config_dir]} {
	catch "source $home/$fx_config_dir/$fn"
    }
}

proc Fx:LoadGlobalConfig {schema} {
    global fx_config fx_font fx_config_dir \
	    fx_lettersetup fx_postcardsetup fx_emailsetup

    set path [qddb_schema path $schema]
    catch "source $path/$fx_config_dir"
}

proc Fx:Init {{schema {}}} {
    global fx:mode_variable fx_config fx_blt fx_config_dir \
	    fx_lettersetup fx_postcardsetup fx_emailsetup \
	    fx:search_modeval fx:add_modeval fx:readonly_modeval \
	    fx:change_modeval fx:search_statusval fx:add_statusval \
	    fx:readonly_statusval fx:change_statusval blt_versions

    if {![info exists fx_config_dir]} {
	set fx_config_dir .fx_config
    }
    option clear
    if {[string length $schema] > 0} {
	Fx:LoadGlobalConfig $schema
	Fx:LoadPersonalConfig $schema
    }
    Fx:InitResources
    Fx:Bindings
    Fx:ColorInit
    set fx:mode_variable {}
    if {![info exists fx_config(soft_limit)]} {
	set fx_config(soft_limit) 200
    }
    if {![info exists fx_config(hard_limit)]} {
	set fx_config(hard_limit) 500
    }
    if {[info exists blt_versions]} {
	set fx_blt 1
    } else {
	set fx_blt 0
    }
    if {![info exists fx:search_modeval]} {
	set fx:search_modeval "Search Mode"
    }
    if {![info exists fx:readonly_modeval]} {
	set fx:readonly_modeval "Read-only Mode"
    }
    if {![info exists fx:add_modeval]} {
	set fx:add_modeval "Add Mode"
    }
    if {![info exists fx:change_modeval]} {
	set fx:change_modeval "Change Mode"
    }
    if {![info exists fx:search_statusval]} {
	set fx:search_statusval "Ready to search"
    }
    if {![info exists fx:readonly_statusval]} {
	set fx:readonly_statusval "Modifications not allowed"
    }
    if {![info exists fx:add_statusval]} {
	set fx:add_statusval "Ready to add new record"
    }
    if {![info exists fx:change_statusval]} {
	set fx:change_statusval "Ready to modify record"
    }
    if {![info exists fx_config(\$tabbing\$,del)]} {
	set fx_config(\$tabbing\$,del) 0
	set fx_config(\$tabbing\$,add) 0
	set fx_config(\$tabbing\$,view) 0
	set fx_config(\$tabbing\$,scrollbars) 0
    }
    if {![info exists fx_lettersetup]} {
	set fx_lettersetup(size) 66
	set fx_lettersetup(spacing) 5
	set fx_lettersetup(width) 72
	set fx_lettersetup(return_tab) 8
	set fx_lettersetup(return_begin) 15
	set fx_lettersetup(max_toprint) 3
	set fx_lettersetup(start_msg) 24
	set fx_lettersetup(freeform) 0
    }
    if {![info exists fx_postcardsetup]} {
	set fx_postcardsetup(size) 25
	set fx_postcardsetup(spacing) 2
	set fx_postcardsetup(sep_column) 21
	set fx_postcardsetup(width) 57
	set fx_postcardsetup(return_tab) 8
	set fx_postcardsetup(return_begin) 15
	set fx_postcardsetup(max_toprint) 3
	set fx_postcardsetup(separator) "|"
	set fx_postcardsetup(freeform) 0
    }
    if {![info exists fx_emailsetup]} {
	set fx_emailsetup(attribute) ""
	set fx_emailsetup(program) "mail"
	set fx_emailsetup(subject) "-s"
    }
    if {![info exists fx_config(datestyle)]} {
	set fx_config(datestyle) [qddb_util datestyle]
    } else {
	qddb_util datestyle $fx_config(datestyle)
    }
}

if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_init.tcl"
}
