# Generic graphics routines

proc Fx:Graph_InitDashes {} {
    global fx_graph_dashes

    set fx_graph_dashes(solid) ""
    set fx_graph_dashes(dash1) [list 8 8]
    set fx_graph_dashes(dash2) [list 4 4]
    set fx_graph_dashes(dash3) [list 2 2]
    set fx_graph_dashes(dash4) [list 8 4 2 4]
    set fx_graph_dashes(dash5) [list 8 4]
    set fx_graph_dashes(dash6) [list 4 2]
    set fx_graph_dashes(dash7) [list 8 2 4 2]
    set fx_graph_dashes(dash8) [list 8 2 2 4]
    set fx_graph_dashes(dash9) [list 8 6]
}

proc Fx:DisplayNumericSelectProc {sel} {
    global fx_display_numeric_search_listbox_retval

    set fx_display_numeric_search_listbox_retval 1
}

proc Fx:CheckNumericSearch {s varname {index ""}} {
    global fx_display_leaves fxPriv fx_rconfig $varname

    if {![info exists fx_rconfig(\$search\$,print)]} {
	return {}
    }
    set display_attrs {}
    set fx_display_attrs $fx_rconfig(\$search\$,print)
    if {[info exists fx_rconfig(\$search\$,user_defs)]} {
	foreach i [set fx_rconfig(\$search\$,user_defs)] {
	    set def [lindex $i 1]
	    set user_defs([lindex $def 0]) [lindex $def 1]
	}
    }
    foreach i $fx_display_attrs {
	if {[string compare $i [set ${varname}($index)]] == 0} {
	    if {[info exists user_defs($i)]} {
		set verb $user_defs($i)
		set type real
	    } else {
		if {[catch "qddb_schema option type $s $i" type] != 0} {
		    continue
		}
		set verb [qddb_schema option verbosename $s $i]
		if {[llength $verb] == 0} {
		    set verb [split $i .]
		    set verb [lindex $verb [expr [llength $verb] - 1]]
		}
	    }
	    return [list $verb $i $type 1]
	}
	if {[info exists fx_display_info]} {continue}
	if {[info exists user_defs($i)]} {
	    set verb $user_defs($i)
	    set type real
	} else {
	    if {[catch "qddb_schema option type $s $i" type] != 0} {
		continue
	    }
	    if {[string compare $index x] != 0} {
		if {[string compare $type integer] != 0 && \
			[string compare $type real] != 0} {
		    continue
		}
	    }
	    set verb [qddb_schema option verbosename $s $i]
	    if {[llength $verb] == 0} {
		set verb [split $i .]
		set verb [lindex $verb [expr [llength $verb] - 1]]
	    }
	}
	set fx_display_info [list $verb $i $type 0]
    }
    return $fx_display_info
}

proc Fx:DisplayNumericSearch {w b s varname {index ""} {varname2 ""} {index2 ""} {func ""}} {
    global fx_display_numeric_search_listbox_retval \
	    fx_display_leaves fxPriv fx_rconfig $varname

    if {![info exists fx_rconfig(\$search\$,print)]} {
	return
    }
    set fx_display_info {}
    set display_attrs {}
    set fx_display_attrs $fx_rconfig(\$search\$,print)
    if {[info exists fx_rconfig(\$search\$,user_defs)]} {
	foreach i [set fx_rconfig(\$search\$,user_defs)] {
	    set def [lindex $i 1]
	    set user_defs([lindex $def 0]) [lindex $def 1]
	}
    }
    foreach i $fx_display_attrs {
	if {[info exists user_defs($i)]} {
	    set verb $user_defs($i)
	} else {
	    if {[catch "qddb_schema option type $s $i" type] != 0} {
		continue
	    }
	    if {[string compare $index x] != 0} {
		if {[string compare $type integer] != 0 && \
			[string compare $type real] != 0} {
		    continue
		}
	    }
	    set verb [qddb_schema option verbosename $s $i]
	    set type [qddb_schema option type $s $i]
	    if {[llength $verb] == 0} {
		set verb [split $i .]
		set verb [lindex $verb [expr [llength $verb] - 1]]
	    }
	}
	set attr_types($i) $type
	lappend fx_display_info [list $verb $i]
	lappend display_attrs $i
    }
    if {[llength $fx_display_info] == 0} {
	fx_dialog .fx_reportgen.dialog \
		"No numeric fields specified" "You must specify numeric fields before graphing!" \
		error 0 Ok
	return
    }
    set oldGrab [grab current $w]
    set oldFocus [focus]
    set parent [winfo toplevel $b]
    set f $parent.numsearch
    toplevel $f -cursor arrow
    wm transient $f $parent
    wm overrideredirect $f 1
    wm withdraw $f

    frame $f.ft -takefocus 0 -highlightthickness 0
    pack $f.ft -side top -expand on -fill both
    set x $f.ft
    Fx_MultiColumnListBox fx_display_numeric_search_listbox -w $x.f -side top -numcols 2 \
	    -width 25 -headings {Verbosename Attribute} \
	    -align {left left} -single_select on -separators {" " " "} \
	    -initselection on \
	    -height 5 -onselect Fx:DisplayNumericSelectProc
    frame $f.b -takefocus 0 -highlightthickness 0 -relief groove -bd 3
    pack $f.b -side bottom -expand on -fill x
    button $f.b.select -text Select -command {set fx_display_numeric_search_listbox_retval 1}
    pack $f.b.select -side left -padx 4m -pady 2m
    button $f.b.cancel -text Cancel -command {set fx_display_numeric_search_listbox_retval 0}
    pack $f.b.cancel -side right -padx 4m -pady 2m
    fx_display_numeric_search_listbox AppendRows $fx_display_info
    fx_display_numeric_search_listbox BuildFormats 1
    fx_display_numeric_search_listbox Format
    fx_display_numeric_search_listbox Display    
    set rootx [winfo rootx $b]
    set rooty [expr [winfo rooty $b]+[winfo height $b]]
    set screenheight [winfo screenheight $b]
    set screenwidth [winfo screenwidth $b]
    update idletasks
    set reqheight [winfo reqheight $f]
    set reqwidth [winfo reqwidth $f]
    if {[expr $rooty + $reqheight] > $screenheight} {
	set rooty [expr $rooty + $screenheight - $rooty - $reqheight]
    }
    if {[expr $rootx + $reqwidth] > $screenwidth} {
	set rootx [expr $rootx + $screenwidth - $rootx - $reqwidth]
    }
    wm geometry $f "+$rootx+$rooty"
    bind $f <Escape> "global fx_display_numeric_search_listbox_retval; \
	    set fx_display_numeric_search_listbox_retval 0"
    bind $x.f.l2 <Escape> "global fx_display_numeric_search_listbox_retval; \
	    set fx_display_numeric_search_listbox_retval 0"
    bind $f <Enter> [list set fxPriv(popup_listbox) ""]
    bind $f <Leave> [list set fxPriv(popup_listbox) $f]
    set fxPriv(popup_listbox) $f
    bind $f <ButtonPress> {
	if {[info exists fxPriv(popup_listbox)]} {
	    if {[string compare $fxPriv(popup_listbox) ""] != 0} {
		set fx_display_numeric_search_listbox_retval 0
	    }
	}
    }
    wm deiconify $f
    tkwait visibility $f
    catch "grab -global $f"
    focus $x.f.l2
    tkwait variable fx_display_numeric_search_listbox_retval
    if {$fx_display_numeric_search_listbox_retval} {
	set sel [$x.f.l2 curselection]
	if {[string length $index] == 0} {
	    set $varname [lindex $display_attrs $sel]
	} else {
	    set ${varname}($index) [lindex $display_attrs $sel]
	}
	if {[string length $varname2] > 0} {
	    global $varname2
	    if {[string length $index2] == 0} {
		set $varname2 [lindex [lindex $fx_display_info $sel] 0]
	    } else {
		set ${varname2}($index2) [lindex [lindex $fx_display_info $sel] 0]
	    }
	}
	if {[string length $func] > 0} {
	    $func $attr_types([lindex $display_attrs $sel])
	}
    }
    delete object fx_display_numeric_search_listbox
    destroy $f
    update idletasks
    if {[info exists grabStatus] && [string compare $grabStatus global] == 0} {
	catch "grab -global $oldGrab"
	catch "focus -force $oldGrab"
    } else {
	catch "grab $oldGrab"
	catch "focus $oldFocus"
    }
    update idletasks
    catch "unset fxPriv(popup_listbox)"
}


proc Fx:Graph_SetColor {top w var idx} {
    global fx_colorconfig $var

    if {[info exists ${var}($idx)]} {
	Fx:BusyExec .fx_graphsetup [list Fx:SelectColor $top [set ${var}($idx)]]
    } else {
	Fx:BusyExec .fx_graphsetup [list Fx:SelectColor $top]
    }
    if {[info exists fx_colorconfig(current)]} {
	set ${var}($idx) $fx_colorconfig(current)
	$w configure -bg \#$fx_colorconfig(current)
    }
}

proc Fx:Graph_ClearAxis {axis {l ""} {force 0}} {
    global fx_tmp_graphsetup

    if {$force || ![info exists fx_tmp_graphsetup(${axis})]} {
	set fx_tmp_graphsetup(${axis}) ""
    }
    if {$force || ![info exists fx_tmp_graphsetup(${axis}_color)]} {
	set fx_tmp_graphsetup(${axis}_color) 000000
    }
    if {$force || ![info exists fx_tmp_graphsetup(${axis}_label)]} {
	set fx_tmp_graphsetup(${axis}_label) ""
    }
    if {[string length $l] > 0 && [winfo exists $l]} {
	$l configure -bg \#$fx_tmp_graphsetup(${axis}_color)
    }
    if {$force || ![info exists fx_tmp_graphsetup(${axis},linewidth)]} {
	set fx_tmp_graphsetup(${axis},linewidth) 1
    }
    if {$force || ![info exists fx_tmp_graphsetup(${axis},showticks)]} {
	set fx_tmp_graphsetup(${axis},showticks) 1
    }
    if {$force || ![info exists fx_tmp_graphsetup(${axis},subdivisions)]} {
	set fx_tmp_graphsetup(${axis},subdivisions) 2
    }
    if {$force || ![info exists fx_tmp_graphsetup(${axis},ticklength)]} {
	set fx_tmp_graphsetup(${axis},ticklength) 0.1i
    }
    if {$force || ![info exists fx_tmp_graphsetup(${axis},stepsize)]} {
	set fx_tmp_graphsetup(${axis},stepsize) 0
    }
}

proc Fx:Graph_TypeFunc {type} {
    global fx_tmp_graphsetup fx_graph_typefunc ;# range format datestuff

    set range [lindex $fx_graph_typefunc 0]
    set format [lindex $fx_graph_typefunc 1]
    set datestuff [lindex $fx_graph_typefunc 2]
    set fx_tmp_graphsetup(daterange_type) "User-defined"
    $range configure -state normal
    $format configure -state normal
    $range delete 0 end
    $format delete 0 end
    if {[string compare $type date] == 0} {
	pack $datestuff -side left -expand off -fill x
    } else {
	set fx_tmp_graphsetup(daterange_type) "User-defined"
	pack forget $datestuff
    }
}

proc Fx:Graph_BuildAxis {top f schema axis} {
    global fx_rconfig fx_report fx_graphsetup fx_tmp_graphsetup qddb_library \
	    fx_graph_typefunc fx_graph_frame

    Fx:Graph_ClearAxis $axis ""
    label $f.l -text "[string toupper ${axis}]-axis Configuration"
    pack $f.l -side top -expand on -fill x -pady 3m
    set fx $f.f0
    frame $fx
    pack $fx -side top -expand on -fill x -padx 2m
    label $fx.l0 -text "Attribute:"
    pack $fx.l0 -side left
    set valid_list [Fx:CheckNumericSearch $schema fx_tmp_graphsetup $axis]
    if {[llength $valid_list] == 0} {
	fx_dialog $f.dialog \
		"No fields specified" "You must specify fields before graphing!" \
		error 0 Ok	
	return
    }
    set found [lindex $valid_list 3]
    if {$found} {
	set fx_tmp_graphsetup(${axis}_type) [lindex $valid_list 2]
    } else {
	set fx_tmp_graphsetup(${axis}_label) [lindex $valid_list 0]
	set fx_tmp_graphsetup($axis) [lindex $valid_list 1]
    }
    if {[string compare $axis x] == 0} {
	button $fx.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:DisplayNumericSearch $top $fx.b $schema fx_tmp_graphsetup $axis \
		fx_tmp_graphsetup ${axis}_label Fx:Graph_TypeFunc]
    } else {
	button $fx.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:DisplayNumericSearch $top $fx.b $schema fx_tmp_graphsetup $axis \
		fx_tmp_graphsetup ${axis}_label]
    }
    pack $fx.b -side left
    entry $fx.e -textvariable fx_tmp_graphsetup($axis) -width 30 -state disabled
    pack $fx.e -side left
    checkbutton $fx.descending -text "Descending" \
	    -variable fx_tmp_graphsetup(${axis},descending)
    pack $fx.descending -side left -padx 5m
    button $fx.color -text "Color" -padx 0m -pady 0m -command \
	    [list after idle "Fx:Graph_SetColor $top $fx.l3 fx_tmp_graphsetup ${axis}_color"]
    pack $fx.color -side left
    label $fx.l3 -width 3 -relief groove
    pack $fx.l3 -side left
    set f1 $f.f1
    frame $f1
    pack $f1 -side top -expand on -fill x -padx 2m
    label $f1.l2 -text "Label:" -anchor e
    pack $f1.l2 -side left
    entry $f1.e2 -textvariable fx_tmp_graphsetup(${axis}_label) -width 20
    pack $f1.e2 -side left
    button $f1.b -text "Title font" -command [list Fx:BusyExec $top \
	    [list Fx:FontButton $f1.b fx_tmp_graphsetup ${axis},titlefont]]
    pack $f1.b -side left
    if {![info exists fx_tmp_graphsetup(${axis},titlefont)]} {
	set fx_tmp_graphsetup(${axis},titlefont) "-*-courier-bold-r-*-*-*-100-*-*-*-*-*-*"
    }
    catch [list $f1.b configure -font $fx_tmp_graphsetup(${axis},titlefont)]
    button $f1.b1 -text "Tick font" -command [list Fx:BusyExec $top \
	    [list Fx:FontButton $f1.b1 fx_tmp_graphsetup ${axis},tickfont]]
    pack $f1.b1 -side left
    if {![info exists fx_tmp_graphsetup(${axis},tickfont)]} {
	set fx_tmp_graphsetup(${axis},tickfont) "-*-courier-bold-r-*-*-*-100-*-*-*-*-*-*"
    }
    catch [list $f1.b1 configure -font $fx_tmp_graphsetup(${axis},tickfont)]
    pack $f1.b1 -side left
    if {[string compare $axis x] == 0} {
	checkbutton $f1.check -text "Range analysis" -variable fx_tmp_graphsetup(range_analysis)
	pack $f1.check -side left
	set f4 $f.f4
	set fx_graph_frame $f4
	frame $f4
	pack $f4 -side top -expand on -fill x -padx 2m
	label $f4.lrange -text "Range:"
	pack $f4.lrange -side left
	entry $f4.range -textvariable fx_tmp_graphsetup(range) -width 10
	pack $f4.range -side left
	label $f4.lformat -text "Format:"
	pack $f4.lformat -side left
	entry $f4.format -textvariable fx_tmp_graphsetup(format) -width 10
	pack $f4.format -side left
	if {![info exists fx_tmp_graphsetup(function)]} {
	    set fx_tmp_graphsetup(function) sum
	}
	label $f4.l -width 7 -textvariable fx_tmp_graphsetup(function) -relief raised -bd 2
	pack $f4.l -side left
	bind $f4.l <Button-1> [list eval tk_popup $f4.l_menu \
		{[expr [winfo rootx %W]]} {[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $f4.l_menu -tearoff 0
	foreach j {sum avg stddev min max count prod} {
	    $f4.l_menu add command -label $j -command "set fx_tmp_graphsetup(function) $j"
	}
	if {![info exists fx_tmp_graphsetup(daterange_type)]} {
	    set fx_tmp_graphsetup(daterange_type) "User-defined"
	}
	if {[string compare $fx_tmp_graphsetup(daterange_type) "User-defined"] != 0} {
	    $f4.range configure -state disabled
	    $f4.format configure -state disabled
	}
	set fx_graph_typefunc [list $f4.range $f4.format $f4.l1]
	label $f4.l1 -textvariable fx_tmp_graphsetup(daterange_type) \
		-relief raised -bd 2 -width 26
	pack $f4.l1 -side left -expand off -fill x
	if {[info exists fx_tmp_graphsetup(${axis}_type)]} {
	    if {[string compare $fx_tmp_graphsetup(${axis}_type) date] != 0} {
		pack forget $f4.l1
	    }
	}
	bind $f4.l1 <Button-1> [list eval tk_popup $f4.l1_menu \
		{[expr [winfo rootx %W]]} {[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $f4.l1_menu -tearoff 0
	set ranges {
	    {"User-defined" "" ""}
	    {"Full date" %y/%m/%d %x}
	    {"Year" %Y %Y}
	    {"Month of year (3-letter)" %m %b}
	    {"Month of year (full name)" %m %B}
	    {"Week of year" %W %W}
	    {"Day of year" %j %j}
	    {"Day of month" %d %d}
	    {"Day of week (3-letter)" %w %a}
	    {"Day of week (full name)" %w %A}
	    {"Hour of day" %H %H}
	    {"Hour/minute of day" %H:%M %H:%M}
	}
	foreach i $ranges {
	    $f4.l1_menu add command -label [lindex $i 0] -command "
	        set fx_tmp_graphsetup(daterange_type) [list [string range [lindex $i 0] 0 24]]
	        set fx_tmp_graphsetup(range) [lindex $i 1]
	        set fx_tmp_graphsetup(format) [lindex $i 2]
   	        if {[string length [lindex $i 1]] == 0} {
		    $f4.range configure -state normal
		    $f4.format configure -state normal
		    after idle [list focus $f4.range]
		} else {
		    if {\[string compare \[focus\] $f4.range\] == 0 || \
			    \[string compare \[focus\] $f4.format\] == 0} {
			after idle [list focus $f]
		    }
		    $f4.range configure -state disabled
		    $f4.format configure -state disabled
		}
	    "
	}
    }

    set f2 $f.f2
    frame $f2
    pack $f2 -side top -expand on -fill x -padx 2m
    label $f2.l -text "Tick width:" 
    pack $f2.l -side left
    entry $f2.e -textvariable fx_tmp_graphsetup(${axis},linewidth) -width 2
    pack $f2.e -side left
    fx_bindint $f2.e

    label $f2.l2 -text "Rotate label:"
    pack $f2.l2 -side left
    entry $f2.e2 -textvariable fx_tmp_graphsetup(${axis},rotate) -width 3
    pack $f2.e2 -side left
    fx_bindreal $f2.e2
    checkbutton $f2.ls -text "Log scale" \
	    -variable fx_tmp_graphsetup(${axis},logscale)
    pack $f2.ls -side left -padx 1m
    checkbutton $f2.lf -text "Loose fit" \
	    -variable fx_tmp_graphsetup(${axis},loosefit)
    pack $f2.lf -side left -padx 1m
    checkbutton $f2.st -text "Show ticks" \
	    -variable fx_tmp_graphsetup(${axis},showticks)
    pack $f2.st -side left -padx 1m
    set f3 $f.f3
    frame $f3
    pack $f3 -side top -expand on -fill x -padx 2m
    label $f3.l -text "Tick subdivisions:"
    pack $f3.l -side left
    entry $f3.e -textvariable fx_tmp_graphsetup(${axis},subdivisions) -width 3
    pack $f3.e -side left
    fx_bindint $f3.e
    label $f3.l2 -text "Major tick length:"
    pack $f3.l2 -side left -padx 1m
    entry $f3.e2 -textvariable fx_tmp_graphsetup(${axis},ticklength) -width 5
    pack $f3.e2 -side left
    fx_bindpixels $f3.e2
    label $f3.l4 -text "Step size:"
    pack $f3.l4 -side left -padx 1m
    entry $f3.e3 -textvariable fx_tmp_graphsetup(${axis},stepsize) -width 5
    pack $f3.e3 -side left
    fx_bindpixels $f3.e3
    set fx_tmp_graphsetup($axis,colorlabel) $fx.l3
    Fx:Graph_ClearAxis $axis $fx.l3
}

proc Fx:Graph_ColorTrace {w color {name1 ""} {name2 ""} {op ""}} {
    global $name1

    if {![winfo exists .fx_graphsetup]} {
	return
    }
    if {[string compare $op u] == 0} {
	set ${name1}($name2) $color
	trace variable ${name1}($name2) wu [list Fx:Graph_ColorTrace $w $color]
    }
    catch "$w configure -bg \#[set ${name1}($name2)]"
}

proc Fx:Graph_BuildLine {top w i num} {
    global fx_rconfig fx_report fx_tmp_graphsetup

    set f $w.f$num
    frame $f
    pack $f -side top -expand on -fill x
    label $f.l -width 3 -text "$num" -anchor e
    pack $f.l -side left
    label $f.l0 -text "Legend:"
    pack $f.l0 -side left
    entry $f.e -width 10 -textvariable fx_tmp_graphsetup($i)
    pack $f.e -side left
    button $f.col -text "Color" -padx 0m -pady 0m -command \
	    [list after idle "Fx:Graph_SetColor $top $f.l1 fx_tmp_graphsetup $i,color"]
    pack $f.col -side left
    label $f.l1 -width 3 -relief groove -bd 2 -bg \#$fx_tmp_graphsetup($i,color)
    pack $f.l1 -side left
    trace variable fx_tmp_graphsetup($i,color) wu [list Fx:Graph_ColorTrace $f.l1 000000]
    label $f.l2 -text "Width:"
    pack $f.l2 -side left
    entry $f.e2 -width 2 -textvariable fx_tmp_graphsetup($i,linewidth)
    pack $f.e2 -side left
    fx_bindpixels $f.e2
    label $f.l3 -text "Symbol:"
    pack $f.l3 -side left
    label $f.l4 -width 9 -textvariable fx_tmp_graphsetup($i,symbol) -relief raised -bd 2
    pack $f.l4 -side left
    bind $f.l4 <Button-1> [list eval tk_popup $f.l4_menu \
	    {[expr [winfo rootx %W]]} {[expr [winfo rooty %W] + [winfo height %W]]}]
    menu $f.l4_menu -tearoff 0
    foreach j {none circle cross diamond plus scross splus square triangle} {
	$f.l4_menu add command -label $j -command "set fx_tmp_graphsetup($i,symbol) $j"
    }
    label $f.l5 -text "Style:"
    pack $f.l5 -side left
    label $f.l6 -width 6 -textvariable fx_tmp_graphsetup($i,style) -relief raised -bd 2
    pack $f.l6 -side left
    bind $f.l6 <Button-1> [list eval tk_popup $f.l6_menu \
	    {[expr [winfo rootx %W]]} {[expr [winfo rooty %W] + [winfo height %W]]}]
    menu $f.l6_menu -tearoff 0
    foreach j {solid dash1 dash2 dash3 dash4 dash5 dash6 dash7 dash8 dash9} {
	$f.l6_menu add command -label $j -command "set fx_tmp_graphsetup($i,style) $j"
    }
    checkbutton $f.show -text Show -variable fx_tmp_graphsetup($i,mapped)
    pack $f.show -side left
}

proc Fx:Graph_BuildLines {top w} {
    global fx_rconfig fx_report fx_tmp_graphsetup

    set nums {}
    foreach i [lsort -ascii [array names fx_report expert_search_title,*]] {
	set found 0
	foreach j [array names fx_tmp_graphsetup expert_search_title,*] {
	    if {[string compare $i $j] == 0} {
		set found 1
		break
	    }
	}
	set num [lindex [split $i ,] 1]
	lappend nums $num
	if {!$found} {
	    set fx_tmp_graphsetup($i) ""
	    set fx_tmp_graphsetup(search${num}) $fx_report($i)
	    set fx_tmp_graphsetup(search${num},color) 000000
	    set fx_tmp_graphsetup(search${num},linewidth) 1
	    set fx_tmp_graphsetup(search${num},symbol) none
	    set fx_tmp_graphsetup(search${num},style) solid
	    set fx_tmp_graphsetup(search${num},mapped) 1
	}
    }
    foreach i [lsort -integer $nums] {
	Fx:Graph_BuildLine $top $w search$i $i
    }
}

proc Fx:Graph_InitSetup {} {
    global fx_tmp_graphsetup

    if {![info exists fx_tmp_graphsetup(width)]} {
	set fx_tmp_graphsetup(width) 5i
    }
    if {![info exists fx_tmp_graphsetup(height)]} {
	set fx_tmp_graphsetup(height) 4i
    }
    if {![info exists fx_tmp_graphsetup(title)]} {
	global fx_report
	if {[info exists fx_report(title)]} {
	    set fx_tmp_graphsetup(title) $fx_report(title)
	}
    }
    if {![info exists fx_tmp_graphsetup(background)]} {
	set fx_tmp_graphsetup(background) EEEEEE
    }
    if {[winfo exists .fx_graphsetup.f0.gen.l3]} {
	.fx_graphsetup.f0.gen.l3 configure -bg \#$fx_tmp_graphsetup(background)
    }
    if {![info exists fx_tmp_graphsetup(plotbackground)]} {
	set fx_tmp_graphsetup(plotbackground) EEEEEE
    }
    if {[winfo exists .fx_graphsetup.f0.gen.pll]} {
	.fx_graphsetup.f0.gen.pll configure -bg \#$fx_tmp_graphsetup(plotbackground)
    }
}

proc Fx:Graph_ClearSetup {schema} {
    global fx_rconfig fx_report fx_tmp_graphsetup fx_graph_frame

    set xcol $fx_tmp_graphsetup(x,colorlabel)
    set ycol $fx_tmp_graphsetup(y,colorlabel)
    catch {unset fx_tmp_graphsetup}
    Fx:Graph_ClearAxis x $xcol 1
    Fx:Graph_ClearAxis y $ycol 1
    set fx_tmp_graphsetup(x,colorlabel) $xcol
    set fx_tmp_graphsetup(y,colorlabel) $ycol
    Fx:Graph_InitSetup
    foreach i [array names fx_report expert_search_title,*] {
	set num [lindex [split $i ,] 1]
	set fx_tmp_graphsetup($i) ""
	set fx_tmp_graphsetup(search${num}) $fx_report($i)
	set fx_tmp_graphsetup(search${num},color) 000000
	set fx_tmp_graphsetup(search${num},linewidth) 1
	set fx_tmp_graphsetup(search${num},symbol) none
	set fx_tmp_graphsetup(search${num},style) solid
	set fx_tmp_graphsetup(search${num},mapped) 1
    }
    set fx_tmp_graphsetup(range) ""
    set fx_tmp_graphsetup(format) ""
    set fx_tmp_graphsetup(daterange_type) "User-defined"
    $fx_graph_frame.range configure -state normal
    $fx_graph_frame.format configure -state normal
    set valid_list [Fx:CheckNumericSearch $schema fx_tmp_graphsetup x]
    set found [lindex $valid_list 3]
    if {$found} {
	set fx_tmp_graphsetup(x_type) [lindex $valid_list 2]
    } else {
	set fx_tmp_graphsetup(x_label) [lindex $valid_list 0]
	set fx_tmp_graphsetup(x) [lindex $valid_list 1]
    }
    set valid_list [Fx:CheckNumericSearch $schema fx_tmp_graphsetup y]
    set found [lindex $valid_list 3]
    if {$found} {
	set fx_tmp_graphsetup(y_type) [lindex $valid_list 2]
    } else {
	set fx_tmp_graphsetup(y_label) [lindex $valid_list 0]
	set fx_tmp_graphsetup(y) [lindex $valid_list 1]
    }
}

proc Fx:Graph_Setup {schema {apply {}}} {
    global fx_rconfig fx_report fx_graph_setup_config \
	    fx_graphsetup fx_tmp_graphsetup qddb_library

    set g .fx_graphsetup
    if {[winfo exists $g]} {
	raise $g
	focus $g
	return
    }
    catch {unset fx_tmp_graphsetup}
    if {[info exists fx_graphsetup]} {
	foreach i [array names fx_graphsetup] {
	    set fx_tmp_graphsetup($i) $fx_graphsetup($i)
	}
    } else {
	Fx:Graph_InitSetup
    }
    toplevel $g
    wm withdraw $g
    wm title $g "Graph Setup"

    set f $g.f0
    frame $f -relief groove -bd 2
    pack $f -side top -expand on -fill x
    set f0 $f.title
    frame $f0 -relief groove -bd 2
    pack $f0 -side top -expand on -fill x
    label $f0.l -text "Graph title:"
    pack $f0.l -side left
    entry $f0.e -textvariable fx_tmp_graphsetup(title)
    pack $f0.e -side left -expand on -fill x
    button $f0.b -text "Font" -command [list Fx:BusyExec $g \
	    [list Fx:FontButton $f0.b fx_tmp_graphsetup font]]
    pack $f0.b -side left
    if {![info exists fx_tmp_graphsetup(font)]} {
	set fx_tmp_graphsetup(font) "-*-courier-bold-r-*-*-*-100-*-*-*-*-*-*"
    }
    catch [list $f0.b configure -font $fx_tmp_graphsetup(font)]

    set f0 $f.gen
    frame $f0 -relief groove -bd 2
    pack $f0 -side top -expand on -fill x
    button $f0.bg -text "Background" -padx 0m -pady 0m -command \
	    [list after idle "Fx:Graph_SetColor $g $f0.l3 fx_tmp_graphsetup background"]
    pack $f0.bg -side left
    label $f0.l3 -width 3 -relief groove
    pack $f0.l3 -side left
    button $f0.pl -text "Plot background" -padx 0m -pady 0m -command \
	    [list after idle "Fx:Graph_SetColor $g $f0.pll fx_tmp_graphsetup plotbackground"]
    pack $f0.pl -side left
    label $f0.pll -width 3 -relief groove
    pack $f0.pll -side left
    label $f0.lw -text "Width:"
    pack $f0.lw -side left
    entry $f0.ew -textvariable fx_tmp_graphsetup(width) -width 4
    pack $f0.ew -side left
    fx_bindpixels $f0.ew
    label $f0.lh -text "Height:"
    pack $f0.lh -side left
    entry $f0.eh -textvariable fx_tmp_graphsetup(height) -width 4
    pack $f0.eh -side left
    fx_bindpixels $f0.eh

    frame $f.x -relief groove -bd 2
    pack $f.x -side top -expand on -fill x
    Fx:Graph_BuildAxis $g $f.x $schema x

    frame $f.y -relief groove -bd 2
    pack $f.y -side top -expand on -fill x
    Fx:Graph_BuildAxis $g $f.y $schema y

    set f1 $f.lines
    frame $f1 -relief groove -bd 2
    pack $f1 -side top -expand on -fill x
    Fx:Graph_BuildLines $g $f1

    set ff $g.f1
    frame $ff -relief groove -bd 2
    pack $ff -side bottom -expand on -fill x
    button $ff.ok -text "Ok" -command {set fx_graph_setup_config 1}
    pack $ff.ok -side left -padx 8m -pady 2m
    if {[string length $apply] > 0} {
	button $ff.apply -text "Apply" -command [list eval $apply]
	pack $ff.apply -side left -padx 8m -pady 2m
    }
    button $ff.clear -text "Clear" -command [list Fx:Graph_ClearSetup $schema]
    pack $ff.clear -side left -padx 8m -pady 2m
    button $ff.cancel -text "Cancel" -command {set fx_graph_setup_config 0}
    pack $ff.cancel -side right -padx 8m -pady 2m
    update idletasks
    wm minsize $g [winfo reqwidth $g] [winfo reqheight $g]
    wm maxsize $g [winfo reqwidth $g] [winfo reqheight $g]
    Fx:SetGeometry $g
    Fx:Graph_InitSetup
    wm protocol .fx_graphsetup WM_DELETE_WINDOW {set fx_graph_setup_config 0}
    update idletasks
    bind $g <Configure> {Fx:FixedSizeWindowBinding %W}
    wm deiconify $g
    tkwait variable fx_graph_setup_config
    Fx:SavePosition $g
    set wait 0
    destroy .fx_graphsetup
    if {$fx_graph_setup_config == 1} {
	# save graph setup
	foreach i [array names fx_tmp_graphsetup] {
	    if {"$i" == "grid" || "$i" == "crosshairs" || "$i" == "zoom"} {continue}
	    set fx_graphsetup($i) $fx_tmp_graphsetup($i)
	}
	return 1
    } else {
	return 0
    }
}

proc Fx:Graph_ConfigureGraph {g} {
    global fx_graphsetup

    foreach i {plotbackground background} {
	if {[info exists fx_graphsetup($i)]} {
	    catch [list $g configure -$i \#$fx_graphsetup($i)]
	}
    }
    foreach i {height width title font invertxy} {
	if {[info exists fx_graphsetup($i)]} {
	    catch [list $g configure -$i $fx_graphsetup($i)]
	}
    }
}

proc Fx:Graph_ConfigureAxis {g axis} {
    global fx_graphsetup

    foreach i {linewidth showticks subdivisions ticklength descending logscale rotate tickfont titlefont} {
	if {[info exists fx_graphsetup(${axis},$i)]} {
	    catch [list $g ${axis}axis configure -$i $fx_graphsetup(${axis},$i)]
	}
    }
    if {[info exists fx_graphsetup(${axis},loosefit)]} {
	catch [list $g ${axis}axis configure -loose $fx_graphsetup(${axis},loosefit)]
    }
    if {[info exists fx_graphsetup(${axis},stepsize)] && \
	    [string length $fx_graphsetup(${axis},stepsize)] > 0} {
	catch [list $g ${axis}axis configure -stepsize $fx_graphsetup(${axis},stepsize)]
    }
    if {[info exists fx_graphsetup(${axis}_color)]} {
	catch [list $g ${axis}axis configure -color \#$fx_graphsetup(${axis}_color)]
    }
    if {[info exists fx_graphsetup(${axis}_label)]} {
	catch [list $g ${axis}axis configure -title $fx_graphsetup(${axis}_label)]
    }
}

proc Fx:Graph_ConfigureElement {g tbl xdata ydata num} {
    global fx_graphsetup fx_report fx_graph_dashes

    if {![info exists fx_graphsetup(search$num)]} {
	return
    }
    if {[string length $xdata] == 0} {
	if {[catch [list qddb_table col getval $tbl $fx_graphsetup(x)] xdata] != 0} {
	    return
	}
    }
    if {[string length $ydata] == 0} {
	if {[catch [list qddb_table col getval $tbl $fx_graphsetup(y)] ydata] != 0} {
	    return
	}
    }
    if {![info exists fx_graph_dashes]} {
	Fx:Graph_InitDashes
    }
    if {![$g element exists search$num]} {
	$g element create search$num
    }
    $g element configure search$num -label $fx_graphsetup(search$num) \
		-color \#$fx_graphsetup(search${num},color) \
		-activecolor \#$fx_graphsetup(search${num},color) \
		-symbol $fx_graphsetup(search${num},symbol) \
		-mapped $fx_graphsetup(search${num},mapped) \
		-xdata $xdata -ydata $ydata -dashes $fx_graph_dashes($fx_graphsetup(search${num},style))
    if {[string length $fx_graphsetup(search${num},linewidth)] == 0} {
	set fx_graphsetup(search${num},linewidth) 1
    }
    catch [list $g element configure search$num -linewidth $fx_graphsetup(search${num},linewidth)]
    catch [list $g element configure -activelinewidth [expr $fx_graphsetup(search${num},linewidth) * 2]]
}


proc Fx:Graph_TranslateAxisString {b str} {
    global fx_graph_trans

    if {[info exists fx_graph_trans($str)]} {
	return $fx_graph_trans($str)
    } else {
	return ""
    }
}

proc Fx:Graph_PostApply {graph tables} {
    global fx_graphsetup fx_graph_trans

    catch "unset fx_graph_trans"

    Fx:Graph_ConfigureGraph $graph
    Fx:Graph_ConfigureAxis $graph x
    Fx:Graph_ConfigureAxis $graph y

    set x_type [qddb_table col cget [lindex $tables 0] $fx_graphsetup(x) -type]
    if {$fx_graphsetup(range_analysis) || [string compare $x_type string] == 0 || \
	    [string compare $x_type date] == 0} {
	if {[string compare $x_type date] == 0} {
	    if {!$fx_graphsetup(range_analysis) || \
		    [string length [string trim $fx_graphsetup(range)]] == 0 || \
		    [string length [string trim $fx_graphsetup(format)]] == 0} {
		set fx_graphsetup(range) "%y/%m/%d"
		set fx_graphsetup(format) "%x"
		set fx_graphsetup(function) sum
		set fx_graphsetup(range_analysis) 1
	    }
	}
	if {!$fx_graphsetup(range_analysis) && [string compare $x_type string] == 0} {
	    set fx_graphsetup(range) ""
	    set fx_graphsetup(format) ""
	    set fx_graphsetup(function) sum
	    set fx_graphsetup(range_analysis) 1
	}
	set tables2 {}
	foreach i $tables {
	    lappend tables2 [qddb_table summary $i $fx_graphsetup(x) $fx_graphsetup(y) \
		    $fx_graphsetup(range) $fx_graphsetup(format) $fx_graphsetup(function)]
	}
	set x_sort 1
	set x_fmt 2
	foreach i $tables2 {
	    if {[catch [list qddb_table col getval $i $x_sort] xdata] != 0} {
		return
	    }
	    if {[catch [list qddb_table col getval $i $x_fmt] xfmtdata] != 0} {
		return
	    }
	    set len [llength $xdata]
	    for {set j 0} {$j < $len} {incr j} {
		set sort2fmt([lindex $xdata $j]) [lindex $xfmtdata $j]
		set fmt2sort([lindex $xfmtdata $j]) [lindex $xdata $j]
	    }
	}
	if {[string compare $x_type date] == 0 || [string compare $x_type string] == 0} {
	    set sort_type ascii
	} else {
	    set sort_type real
	}
	set j 1
	foreach i [lsort -$sort_type [array names sort2fmt]] {
	    set fx_graph_trans($j) $sort2fmt($i) ;# num -> fmt (global)
	    set sort2num($i) $j
	    incr j
	}
	foreach i [array names fx_graph_trans] {
	    set fmt2num($fx_graph_trans($i)) $i ;# fmt -> num
	}
	$graph xaxis configure -command Fx:Graph_TranslateAxisString
	set num 1
	foreach i $tables2 {
	    set x 2
	    set y 3
	    if {[catch [list qddb_table col getval $i $x] xdata] != 0} {
		catch "qddb_table delete $i"
		continue
	    }
	    set nxdata {}
	    foreach j $xdata {
		if {[info exists fmt2num($j)]} {
		    lappend nxdata $fmt2num($j)
		} else {
		    set sort $fmt2sort($j) ;# fmt -> sort
		    lappend nxdata $sort2num($sort)
		}
	    }
	    if {[catch [list qddb_table col getval $i $y] ydata] != 0} {
		catch "qddb_table delete $i"
		continue
	    }
	    Fx:Graph_ConfigureElement $graph $i $nxdata $ydata $num
	    incr num
	    catch "qddb_table delete $i"
	}
    } else {
	$graph xaxis configure -command ""
	set num 1
	foreach i $tables {
	    Fx:Graph_ConfigureElement $graph $i {} {} $num
	    incr num
	}
    }
}

proc Fx:Graph_Apply {graph tables} {
    global fx_graphsetup fx_tmp_graphsetup fx_range

    foreach i [array names fx_tmp_graphsetup] {
	if {"$i" == "grid" || "$i" == "crosshairs" || "$i" == "zoom"} {continue}
	set fx_graphsetup($i) $fx_tmp_graphsetup($i)
    }
    Fx:Graph_PostApply $graph $tables
}

proc Fx:Graph_Reconfigure {schema top graph tables} {
    if {[Fx:DisabledExec $top \
	    [list Fx:Graph_Setup $schema [list Fx:Graph_Apply $graph $tables]]] == 1} {
	Fx:Graph_Apply $graph $tables
    }
}

proc Fx:Graph_Postscript {graph} {
    global fx_postscript fx_graph_postscript_config

    set top .fx_graph_postscript
    toplevel $top
    wm title $top "Printing options"
    wm withdraw $top
    set f0 $top.f
    frame $f0 -relief groove -bd 2
    pack $f0 -side top -expand on -fill x
    set f00 $f0.f0
    frame $f00
    pack $f00 -side left -padx 8m
    label $f00.l -text Orientation:
    pack $f00.l -side left
    radiobutton $f00.port -variable fx_postscript(landscape) -value 0 -text Portrait
    pack $f00.port -side left
    radiobutton $f00.land -variable fx_postscript(landscape) -value 1 -text Landscape
    pack $f00.land -side left
    checkbutton $f0.maxpect -variable fx_postscript(maxpect) -text "Expand to full page"
    pack $f0.maxpect -side left -padx 8m

    set f1 $top.f1
    frame $f1 -relief groove -bd 2
    pack $f1 -side top -expand on -fill x
    checkbutton $f1.center -variable fx_postscript(center) -text "Center graph on page"
    pack $f1.center -side left -padx 8m
    checkbutton $f1.decor -variable fx_postscript(decorations) -text "Backgrounds/Borders"
    pack $f1.decor -side left -padx 8m

    set f2 $top.f2
    frame $f2 -relief groove -bd 2
    pack $f2 -side top -expand on -fill x
    set f00 $f2.f1
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -text "Colors:"
    pack $f00.l -side left
    radiobutton $f00.color -variable fx_postscript(colormode) -value color -text "Full color"
    pack $f00.color -side left
    radiobutton $f00.gray -variable fx_postscript(colormode) -value gray -text "Gray scale"
    pack $f00.gray -side left
    radiobutton $f00.mono -variable fx_postscript(colormode) -value mono -text "Black/white"
    pack $f00.mono -side left

    set lwid 20
    set f3 $top.f3
    frame $f3 -relief groove -bd 2
    pack $f3 -side top -expand on -fill x
    set f00 $f3.f1
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Page width:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(paperwidth) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e
    set f00 $f3.f2
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Page height:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(paperheight) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e

    set f4 $top.f4
    frame $f4 -relief groove -bd 2
    pack $f4 -side top -expand on -fill x
    set f00 $f4.f1
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Graph width:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(width) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e
    set f00 $f4.f2
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Graph height:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(height) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e

    set f5 $top.f5
    frame $f5 -relief groove -bd 2
    pack $f5 -side top -expand on -fill x
    set f00 $f5.f1
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Left/right border:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(padx) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e
    set f00 $f5.f2
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Top/bottom border:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(pady) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e
    
    set b $top.bot
    frame $b
    pack $b -side bottom -expand on -fill x
    button $b.print -text Print -command {set fx_graph_postscript_config 1}
    pack $b.print -side left -padx 8m -pady 2m
    button $b.close -text Cancel -command {set fx_graph_postscript_config 0}
    pack $b.close -side right -padx 8m -pady 2m
    Fx:SetGeometry $top
    update idletasks
    fx_bindgeom $top
    wm deiconify $top
    foreach i {center colormode decorations landscape \
	    maxpect padx pady paperheight paperwidth} {
	set fx_postscript($i) [lindex [$graph postscript configure -$i] 3]
    }
    set fx_postscript(width) 0
    set fx_postscript(height) 0
    tkwait variable fx_graph_postscript_config
    Fx:SavePosition $top
    if {$fx_graph_postscript_config == 1} {
	global fx_config

	set fn [TempNam]
	foreach i [array names fx_postscript] {
	    catch "$graph postscript configure -$i $fx_postscript($i)"
	}
	$graph postscript output $fn
	Fx_PrintDialog graph_print_dialog -toplevel ""
	if {[info exists fx_config(print_cmd)]} {
	    set print_cmd $fx_config(print_cmd)
	}
	if {[info exists fx_config(default_print_cmd)]} {
	    set default_print_cmd $fx_config(default_print_cmd)
	}
	set fx_config(print_cmd) "| lpr -h -P"
	set fx_config(default_print_cmd) "| lpr -h"
	catch "unset fx_config(print_heading)"
	catch "Fx:PrintFile $fn"
	if {[info exists print_cmd]} {
	    set fx_config(print_cmd) $print_cmd
	}
	if {[info exists default_print_cmd]} {
	    set fx_config(default_print_cmd) $default_print_cmd
	}
	catch "exec rm -f $fn"
    }
    destroy .fx_graph_postscript
}

proc Fx:Graph_Print {schema tables} {
    global fx_rconfig fx_report fx_graph_print_config fx_graphsetup fx_range

    if {[Fx:Graph_Setup $schema] == 0} {
	return
    }
    set top .fx_graphprint
    toplevel $top
    wm title $top "Graph"
    wm withdraw $top
    set f $top.f
    set b $top.bot
    frame $b -relief groove -bd 2

    button $b.print -text Print -command \
	    [list Fx:BusyExec [list $top .fx_graphsetup] [list Fx:Graph_Postscript $f.graph]]
    pack $b.print -side left -padx 8m -pady 2m
    button $b.setup -text Setup -command \
	    [list Fx:Graph_Reconfigure $schema [list $b.setup $b.close] $f.graph $tables]
    button $b.close -text Dismiss -command {set fx_graph_print_config 0}
    pack $b.close -side right -padx 8m -pady 2m
    pack $b.setup -side right -padx 8m -pady 2m

    set m $top.mid
    frame $m -relief groove -bd 2
    checkbutton $m.grid -text Grid -variable fx_graphsetup(grid) -command {
	.fx_graphprint.f.graph grid configure -mapped $fx_graphsetup(grid)
    }
    pack $m.grid -side left -padx 8m
    checkbutton $m.hairs -text Crosshairs -variable fx_graphsetup(crosshairs) -command {
	.fx_graphprint.f.graph crosshairs configure -mapped $fx_graphsetup(crosshairs)
    }
    pack $m.hairs -side left -padx 8m
    checkbutton $m.zoom -text Zooming -variable fx_graphsetup(zoom) -command {
	.fx_graphprint.f.graph crosshairs configure -mapped $fx_graphsetup(zoom)
	if {!$fx_graphsetup(zoom)} {
	    Fx:BltResetAllZoom .fx_graphprint.f.graph
	}
    }
    pack $m.zoom -side left -padx 8m
    checkbutton $m.invert -text "Invert X/Y" -variable fx_graphsetup(invertxy) -command {
	.fx_graphprint.f.graph configure -invertxy $fx_graphsetup(invertxy)
    }
    pack $m.invert -side left -padx 8m

    frame $f
    pack $b -side bottom -fill x
    pack $m -side bottom -fill x
    update idletasks
    wm minsize $top [winfo reqwidth $top] [winfo reqheight $top]
    pack $f -side top -expand on -fill both

    blt::graph $f.graph
    $f.graph crosshairs configure -linewidth 1
    $f.graph legend configure -activebackground gray80 -activeforeground black -activerelief raised
    Fx:Blt_Crosshairs $f.graph fx_graphsetup crosshairs
    Fx:Blt_ZoomStack $f.graph fx_graphsetup zoom
    Fx:Blt_BindRaiseElements $f.graph
    Fx:Blt_ActiveLegend $f.graph
    pack $f.graph -side top -expand on -fill both

    Fx:Graph_PostApply $f.graph $tables
    $f.graph grid configure -mapped $fx_graphsetup(grid)

    Fx:SetGeometry $top
    update idletasks
    fx_bindgeom $top
    wm protocol .fx_graphprint WM_DELETE_WINDOW Fx:Graph_Quit
    wm deiconify $top
    tkwait variable fx_graph_print_config
    Fx:SavePosition $top
    catch "destroy .fx_graphprint"
}

proc Fx:Graph_Quit {} {
    global fx_graph_print_config fx_graph_setup_config

    set fx_graph_setup_config 0
    update
    set fx_graph_print_config 0
}
