
set fx_font_config(charter,slant) {italic roman}
set fx_font_config(charter,weight) {bold medium}
set fx_font_config(charter,size) {tiny small medium large huge}
set fx_font_config(courier,slant) {italic oblique roman}
set fx_font_config(courier,weight) {bold medium}
set fx_font_config(courier,size) {tiny small medium large huge}
set fx_font_config(fixed,slant) {roman}
set fx_font_config(fixed,weight) {bold medium}
set fx_font_config(fixed,size) {tiny small medium}
set fx_font_config(helvetica,slant) {oblique roman}
set fx_font_config(helvetica,weight) {bold medium}
set fx_font_config(helvetica,size) {tiny small medium large huge}
set fx_font_config(lucida,slant) {italic roman}
set fx_font_config(lucida,weight) {bold medium}
set fx_font_config(lucida,size) {tiny small medium large huge}
set {fx_font_config(lucidabright,slant)} {italic roman}
set {fx_font_config(lucidabright,weight)} {demibold medium}
set {fx_font_config(lucidabright,size)} {tiny small medium large huge}
set {fx_font_config(lucidatypewriter,slant)} {roman}
set {fx_font_config(lucidatypewriter,weight)} {bold medium}
set {fx_font_config(lucidatypewriter,size)} {tiny small medium large huge}
set {fx_font_config(new century schoolbook,slant)} {italic roman}
set {fx_font_config(new century schoolbook,weight)} {bold medium}
set {fx_font_config(new century schoolbook,size)} {tiny small medium large huge}
set fx_font_config(times,slant) {italic roman}
set fx_font_config(times,weight) {bold medium}
set fx_font_config(times,size) {tiny small medium large huge}
set fx_font_config(utopia,slant) {italic roman}
set fx_font_config(utopia,weight) {bold medium}
set fx_font_config(utopia,size) {tiny small medium large huge}
set fx_font_config(Listbox,avail_families) {courier fixed}

proc Fx:ChangeAllFonts {{w .}} {
    set class [winfo class $w]
    set font [option get $w font $class]
    if {[string compare $class Menu] == 0} {
	catch [list $w configure -font $font]
	set last [$w index last]
	if {[string compare $last none] == 0} {
	    return
	}
	for {set i 0} {$i <= $last} {incr i} {
	    catch [list $w entryconfigure $i -font $font]
	    if {[catch "$w entrycget $i -menu" menu] == 0} {
		Fx:ChangeAllFonts $menu
	    }
	}
	return
    }
    foreach i [winfo children $w] {
	set font [option get $i font $class]
	catch [list $i configure -font $font]
	Fx:ChangeAllFonts $i
    }
}

proc Fx:ConfigureFontLine {w val} {
    global fx_font_config

    set strings {}
    foreach i [array names fx_font_config] {
	if {[string match "$val,*" $i]} {
	    lappend strings $i
	}
    }
    foreach i $strings {
	switch -glob $i {
	    *,slant {
		$w.slant_menu entryconfigure 0 -state disabled
		$w.slant_menu entryconfigure 1 -state disabled
		$w.slant_menu entryconfigure 2 -state disabled
		foreach j $fx_font_config($i) {
		    $w.slant_menu entryconfigure $j -state normal
		}
		set val [$w.slant cget -text]
		if {[string compare [$w.slant_menu entrycget $val -state] disabled] == 0} {
		    foreach j $fx_font_config($i) {
			if {[string compare [$w.slant_menu entrycget $j -state] normal] == 0} {
			    $w.slant configure -text $j
			    break
			}
		    }
		}
	    }
	    *,weight {
		$w.weight_menu entryconfigure 0 -state disabled
		$w.weight_menu entryconfigure 1 -state disabled
		$w.weight_menu entryconfigure 2 -state disabled
		foreach j $fx_font_config($i) {
		    $w.weight_menu entryconfigure $j -state normal
		}
		set val [$w.weight cget -text]
		if {[string compare [$w.weight_menu entrycget $val -state] disabled] == 0} {
		    foreach j $fx_font_config($i) {
			if {[string compare [$w.weight_menu entrycget $j -state] normal] == 0} {
			    $w.weight configure -text $j
			    break
			}
		    }
		}
	    }
	    *,size {
		$w.size_menu entryconfigure 0 -state disabled
		$w.size_menu entryconfigure 1 -state disabled
		$w.size_menu entryconfigure 2 -state disabled
		$w.size_menu entryconfigure 3 -state disabled
		$w.size_menu entryconfigure 4 -state disabled
		foreach j $fx_font_config($i) {
		    $w.size_menu entryconfigure $j -state normal
		}
		set val [$w.size cget -text]
		if {[string compare [$w.size_menu entrycget $val -state] disabled] == 0} {
		    foreach j $fx_font_config($i) {
			if {[string compare [$w.size_menu entrycget $j -state] normal] == 0} {
			    $w.size configure -text $j
			    break
			}
		    }
		}
	    }
	}
    }
}

proc Fx:BuildFont {w} {
    global fx_font_config
    set family [$w.family cget -text]
    set slant [$w.slant cget -text]
    set weight [$w.weight cget -text]
    set size [$w.size cget -text]
    set tmpfont [format "-*-%s-%s-%s-*-*-*-%s-*-*-*-*-*-*" \
	    $family $weight [string index $slant 0] \
	    [lindex $fx_font_config(sizes) [lsearch $fx_font_config(sizenames) $size]]]
    return $tmpfont
}

proc Fx:SetFontDefaults {} {
    global fx_font_frames

    foreach i [array names fx_font_frames] {
	set w $fx_font_frames($i)
	$w.family configure -text courier
	$w.slant configure -text roman
	$w.weight configure -text medium
	$w.size configure -text medium
    }
}

proc Fx:ParseFont {font} {
    global fx_font_config

    set s [split $font -]
    set family [lindex $s 2]
    set weight [lindex $s 3]
    set slant [lindex $s 4]
    set size [lindex $s 8]
    if {![llength $family] || ![llength $weight] || ![llength $slant] || ![llength $size]} {
	return {}
    }
    foreach i $fx_font_config(slants) {
	if {[string compare [string index $i 0] $slant] == 0} {
	    set slant $i
	    break
	}
    }
    foreach i $fx_font_config(sizes) {
	if {[string compare $i $size] == 0} {
	    set size [lindex $fx_font_config(sizenames) [lsearch $fx_font_config(sizes) $size]]
	    break
	}
    }
    return [list $family $weight $slant $size]
}

proc Fx:OverrideFontDefaults {} {
    global fx_font fx_classes fx_font_frames

    if {![info exists fx_font]} {return}
    foreach i [array names fx_font] {
	if {[info exists fx_font_frames($i)]} {
	    set l [Fx:ParseFont $fx_font($i)]
	    if {[llength $l] == 0} {continue}
	    set w $fx_font_frames($i)
	    $w.family configure -text [lindex $l 0]
	    $w.slant configure -text [lindex $l 2]
	    $w.weight configure -text [lindex $l 1]
	    $w.size configure -text [lindex $l 3]
	    Fx:ConfigureFontsSet family $w [lindex $l 0]
	}
    }
}

proc Fx:SetAllFonts {w} {
    global fx_font_frames
    set family [$w.family cget -text]
    set weight [$w.weight cget -text]
    set slant [$w.slant cget -text]
    set size [$w.size cget -text]
    foreach i [array names fx_font_frames] {
	if {[string compare bot $i] != 0 && [string compare Listbox $i] != 0} {
	    $fx_font_frames($i).family configure -text $family
	    $fx_font_frames($i).weight configure -text $weight
	    $fx_font_frames($i).slant configure -text $slant
	    $fx_font_frames($i).size configure -text $size
	}
    }
}

proc Fx:ConfigureFontsSet {type w val} {
    $w.$type configure -text $val
    switch $type {
	family {
	    Fx:ConfigureFontLine $w $val
	}
    }
}

proc Fx:ConfigureFonts {} {
    global fx_resources fx_tmpfont fx_font fx_classes fx_tmpfont_radiobutton fx_config fx_font_config
    global fx_fontfocus fx_font_frames

    if {[winfo exists .config_fonts]} {
	if {[info exists fx_config(geom,config_fonts)]} {
	    wm geometry .config_fonts $fx_config(geom,config_fonts)
	}
	wm withdraw .config_fonts
	wm deiconify .config_fonts
	focus .config_fonts
	return
    }
    catch "unset fx_tmpfont"
    catch "unset fx_fontfocus"
    catch "unset fx_font_frames"
    toplevel .config_fonts
    wm title .config_fonts "Font Configuration"
    if {[info exists fx_config(geom,config_fonts)]} {
	set l [split $fx_config(geom,config_fonts) +]
	wm geometry .config_fonts +[lindex $l 1]+[lindex $l 2]
    }
    set cf .config_fonts
    wm protocol .config_fonts WM_DELETE_WINDOW [list Fx:CancelFontConfig $cf]
    frame $cf.f4
    pack $cf.f4 -side bottom -expand on -fill both -pady 2m
    button $cf.f4.ok -text Ok -command [list Fx:SaveFontConfig $cf]
    pack $cf.f4.ok -side left -padx 10m -pady 4m -ipadx 10m -ipady 2m
    button $cf.f4.cancel -text Cancel -command [list Fx:CancelFontConfig $cf ]
    pack $cf.f4.cancel -side right -padx 10m -pady 4m -ipadx 10m -ipady 2m
    frame $cf.f -highlightthickness 2 -bd 4
    pack $cf.f -side top -expand on -fill both -ipadx 8m
    frame $cf.f.top -bd 2 -relief groove
    pack $cf.f.top -side top -expand on -fill x
    label $cf.f.top.widget -width 20 -text Widget -anchor e
    pack $cf.f.top.widget -side left -fill none
    label $cf.f.top.family -width 25 -text Family -anchor e
    pack $cf.f.top.family -side left -fill none
    label $cf.f.top.slant -width 15 -text Slant -anchor e
    pack $cf.f.top.slant -side left -fill none
    label $cf.f.top.weight -width 15 -text Weight -anchor e
    pack $cf.f.top.weight -side left -fill none
    label $cf.f.top.size -width 15 -text Size -anchor e
    pack $cf.f.top.size -side left -fill none
    set x 0
    foreach i [concat $fx_classes bot] {
	frame $cf.f.f$x
	pack $cf.f.f$x -side top -expand on -fill x
	set fx_font_frames($i) $cf.f.f$x
	if {[string compare $i bot] == 0} {
	    button $cf.f.f$x.b -text "Set all fonts to default" -command [list Fx:SetAllFonts $cf.f.f$x]
	    pack $cf.f.f$x.b -side top -fill x -ipady 2m
	    label $cf.f.f$x.l -text "Default font" -width 20 -anchor e
	    pack $cf.f.f$x.l -side left -fill none
	} else {
	    label $cf.f.f$x.l -text $i -width 20 -anchor e
	    pack $cf.f.f$x.l -side left -fill none
	}
	label $cf.f.f$x.family -width 25 -text family -anchor e
	pack $cf.f.f$x.family -side left -fill none
	bind $cf.f.f$x.family <Button-1> [list eval tk_popup $cf.f.f$x.family_menu \
		{[expr [winfo rootx %W] + ([winfo width %W] / 2)]} \
		{[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $cf.f.f$x.family_menu -tearoff 0
	if {[string compare $i Listbox] == 0} {
	    foreach i $fx_font_config(Listbox,avail_families) {
		$cf.f.f$x.family_menu add command -label $i -command \
			[list Fx:ConfigureFontsSet family $cf.f.f$x $i]
	    }
	} else {
	    foreach i $fx_font_config(families) {
		$cf.f.f$x.family_menu add command -label $i -command \
			[list Fx:ConfigureFontsSet family $cf.f.f$x $i]
	    }
	}
	label $cf.f.f$x.slant -width 15 -text slant -anchor e
	pack $cf.f.f$x.slant -side left -fill none
	bind $cf.f.f$x.slant <Button-1> [list eval tk_popup $cf.f.f$x.slant_menu \
		{[expr [winfo rootx %W] + ([winfo width %W] / 2)]} \
		{[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $cf.f.f$x.slant_menu -tearoff 0
	foreach i $fx_font_config(slants) {
	    $cf.f.f$x.slant_menu add command -label $i -command \
		    [list Fx:ConfigureFontsSet slant $cf.f.f$x $i]
	}
	label $cf.f.f$x.weight -width 15 -text weight -anchor e
	pack $cf.f.f$x.weight -side left -fill none
	bind $cf.f.f$x.weight <Button-1> [list eval tk_popup $cf.f.f$x.weight_menu \
		{[expr [winfo rootx %W] + ([winfo width %W] / 2)]} \
		{[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $cf.f.f$x.weight_menu -tearoff 0
	foreach i $fx_font_config(weights) {
	    $cf.f.f$x.weight_menu add command -label $i -command \
		    [list Fx:ConfigureFontsSet weight $cf.f.f$x $i]
	}
	label $cf.f.f$x.size -width 15 -text size -anchor e
	pack $cf.f.f$x.size -side left -fill none
	bind $cf.f.f$x.size <Button-1> [list eval tk_popup $cf.f.f$x.size_menu \
		{[expr [winfo rootx %W] + ([winfo width %W] / 2)]} \
		{[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $cf.f.f$x.size_menu -tearoff 0
	foreach i $fx_font_config(sizenames) {
	    $cf.f.f$x.size_menu add command -label $i -command \
		    [list Fx:ConfigureFontsSet size $cf.f.f$x $i]
	}
	incr x
    }
    bind $cf <Configure> Fx:ConfigFontWindow
    Fx:SetFontDefaults
    Fx:OverrideFontDefaults
    tkwait window $cf
    if {[info exists fx_tmpfont(cancelled)]} {
	set retval 0
    } else {
	set retval 1
    }
    catch "unset fx_tmpfont"
    return $retval
}

proc Fx:CancelFontConfig {w} {
    global fx_tmpfont
    set fx_tmpfont(cancelled) 1
    destroy $w
}

proc Fx:ConfigFontWindow {} {
    global fx_config

    update idletasks
    set fx_config(geom,config_fonts) [wm geometry .config_fonts]
}

proc Fx:SaveFontConfig {w} {
    global fx_font fx_classes fx_font_frames

    foreach i $fx_classes {
	if {[info exists fx_font_frames($i)]} {
	    set font [Fx:BuildFont $fx_font_frames($i)]
	    option add "*$i.font" $font
	    set fx_font($i) $font
	}
    }
    destroy $w
    update idletasks
    set reconf [Fx_Menubar::BeforeReconfigure]
    if {[llength $reconf] > 0} {
	eval $reconf
    }
    Fx:ChangeAllFonts
}

proc Fx:ChooseFont {init var idx} {
    global fx_font_config fx_buttonvar $var fx_config

    set top .fx_choosefont
    toplevel $top
    wm title $top "Font Selection"
    wm withdraw $top
    set f $top.f
    frame $f
    pack $f -side top -expand on -fill both
    frame $f.f0
    pack $f.f0 -side left
    set f0 $f.f0
    label $f0.family -width 12 -text Family: -anchor e
    pack $f0.family -side top
    label $f0.slant -width 12 -text Slant: -anchor e
    pack $f0.slant -side top
    label $f0.size -width 12 -text Size: -anchor e
    pack $f0.size -side top
    label $f0.weight -width 12 -text Weight: -anchor e
    pack $f0.weight -side top

    set tmp(family) families
    set tmp(slant) slants
    set tmp(size) sizenames
    set tmp(weight) weights

    set fontlist [Fx:ParseFont $init]
    frame $f.f1
    pack $f.f1 -side right
    set f1 $f.f1
    set x 0
    foreach i {family weight slant size} {
	label $f1.$i -width 25 -text [lindex $fontlist $x] -relief raised -bd 2
	pack $f1.$i -side top
	incr x
	bind $f1.$i <Button-1> [list eval tk_popup $f1.${i}_menu \
		{[winfo rootx %W]} \
		{[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $f1.${i}_menu -tearoff 0
	foreach j $fx_font_config($tmp($i)) {
	    $f1.${i}_menu add command -label $j -command \
		    [list Fx:ConfigureFontsSet $i $f1 $j]
	}
    }
    set f2 $top.f2
    frame $f2 -relief groove -bd 2
    pack $f2 -side top -fill x
    button $f2.ok -text Ok -command [list set fx_buttonvar($top) 1]
    pack $f2.ok -side left -padx 8m -pady 2m
    button $f2.cancel -text Cancel -command [list set fx_buttonvar($top) 0]
    pack $f2.cancel -side right -padx 8m -pady 2m
    Fx:SetGeometry $top
    update idletasks; update
    wm protocol $top WM_DELETE_WINDOW [list set fx_buttonvar($top) 0]
    wm deiconify $top
    tkwait variable fx_buttonvar($top)
    Fx:SavePosition $top
    set ${var}($idx) [Fx:BuildFont $f1]
    destroy $top
    return
}

proc Fx:FontButton {button var idx} {
    global $var

    if {[info exists ${var}($idx)]} {
	Fx:ChooseFont [set ${var}($idx)] $var $idx
    } else {
	Fx:ChooseFont "-*-courier-bold-r-*-*-*-100-*-*-*-*-*-*" $var $idx
    }
    catch [list $button configure -font [set ${var}($idx)]]
}

if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_fonts.tcl"
}
