
# Fx expert search dialog

# Some of this is a bit nasty.   We use the widget hierarchy to
# hold most of the search layout.

proc Fx:ExpertDisplayOptions {w b s dispall} {
    global fx_expert_leaves fx_blt fxPriv qddb_library

    set parent [winfo toplevel $w]
    set f $parent.opt
    toplevel $f -cursor arrow
    wm transient $f $parent
    wm overrideredirect $f 1
    wm withdraw $f
    if {([winfo exists $w.l] && [string compare [$w.l cget -text] ""] != 0) || !$dispall} {
	frame $f.f0 -relief groove -bd 3
	pack $f.f0 -side top -expand on -fill x
	label $f.f0.l_logic -text Logic -anchor e -width 12
	pack $f.f0.l_logic -side left -expand off -fill none
	radiobutton $f.f0.r_and -text And -value And -variable fx_expert_leaves($w,logic)
	pack $f.f0.r_and -side left -expand on -fill x
	radiobutton $f.f0.r_or -text Or -value Or -variable fx_expert_leaves($w,logic)
	pack $f.f0.r_or -side left -expand on -fill x
	radiobutton $f.f0.r_not -text Not -value Not -variable fx_expert_leaves($w,logic)
	pack $f.f0.r_not -side left -expand on -fill x
	radiobutton $f.f0.r_sand -text "S-and" -value S-and -variable fx_expert_leaves($w,logic)
	pack $f.f0.r_sand -side left -expand on -fill x
	radiobutton $f.f0.r_snot -text "S-not" -value S-not -variable fx_expert_leaves($w,logic)
	pack $f.f0.r_snot -side left -expand on -fill x
    }
    if {$dispall} {
	frame $f.f1 -relief groove -bd 3
	pack $f.f1 -side top -expand on -fill x
	label $f.f1.l_type -text "Search type" -anchor e -width 12
	pack $f.f1.l_type -side left -expand off -fill none -anchor nw

	frame $f.f1.f0
	pack $f.f1.f0 -side top -expand on -fill x
	radiobutton $f.f1.f0.r_any -text Parse -value p -variable fx_expert_leaves($w,type)
	pack $f.f1.f0.r_any -side left

	frame $f.f1.f1
	pack $f.f1.f1 -side top -expand on -fill x
	radiobutton $f.f1.f1.r_w -text Word -value w -variable fx_expert_leaves($w,type)
	pack $f.f1.f1.r_w -side left
	radiobutton $f.f1.f1.r_wr -text "Word range" -value wr -variable fx_expert_leaves($w,type)
	pack $f.f1.f1.r_wr -side left

	frame $f.f1.f2
	pack $f.f1.f2 -side top -expand on -fill x
	radiobutton $f.f1.f2.r_n -text Number -value n -variable fx_expert_leaves($w,type)
	pack $f.f1.f2.r_n -side left
	radiobutton $f.f1.f2.r_nr -text "Numeric range" -value nr -variable fx_expert_leaves($w,type)
	pack $f.f1.f2.r_nr -side left

	frame $f.f1.f3
	pack $f.f1.f3 -side top -expand on -fill x
	radiobutton $f.f1.f3.r_d -text Date -value d -variable fx_expert_leaves($w,type)
	pack $f.f1.f3.r_d -side left
	radiobutton $f.f1.f3.r_dr -text "Date range" -value dr -variable fx_expert_leaves($w,type)
	pack $f.f1.f3.r_dr -side left

	frame $f.f1.f4
	pack $f.f1.f4 -side top -expand on -fill x
	radiobutton $f.f1.f4.r_r -text "Regular expression" -value r -variable fx_expert_leaves($w,type)
	pack $f.f1.f4.r_r -side left

	frame $f.f2 -relief groove -bd 3
	pack $f.f2 -side top -expand on -fill x
	label $f.f2.l -text Attribute -anchor e -width 12
	pack $f.f2.l -side left
	button $f.f2.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:DisplayAttributes $w $f.f2.b \
		$s fx_expert_leaves $w,attr {"Any Attribute" *Any*} global]
	pack $f.f2.b -side left
	label $f.f2.attr -textvariable fx_expert_leaves($w,attr) \
		-anchor e
	pack $f.f2.attr -side left -expand on -fill x
    }
    frame $f.bot -relief groove -bd 3
    pack $f.bot -expand on -fill x
    button $f.bot.b -text Dismiss -command [list destroy $f]
    pack $f.bot.b -side left -expand on -fill x -padx 4m -pady 2m
    button $f.bot.del -text Delete -command "destroy $f; Fx:ExpertDeleteNode $w $s"
    pack $f.bot.del -side left -expand on -fill x -padx 4m -pady 2m
    if {$dispall} {
	button $f.bot.b1 -text "Expand node" -command "destroy $f; Fx:ExpertExpandNode $w $s"
	pack $f.bot.b1 -side left -expand on -fill x -padx 4m -pady 2m
    }
    set top [winfo toplevel $w]
    set rootx [winfo rootx $b]
    set rooty [expr [winfo rooty $b]+[winfo height $b]]
    set screenheight [winfo screenheight $b]
    set screenwidth [winfo screenwidth $b]
    update idletasks
    set reqheight [winfo reqheight $f]
    set reqwidth [winfo reqwidth $f]
    if {[expr $rooty + $reqheight] > $screenheight} {
	set rooty [expr $rooty + $screenheight - $rooty - $reqheight]
    }
    if {[expr $rootx + $reqwidth] > $screenwidth} {
	set rootx [expr $rootx + $screenwidth - $rootx - $reqwidth]
    }
    wm geometry $f "+$rootx+$rooty"
    bind $f <Escape> [list destroy $f]
    bind $f <Enter> [list set fxPriv(popup) ""]
    bind $f <Leave> [list set fxPriv(popup) $f]
    set fxPriv(popup) $f
    bind $f <ButtonPress> {
	if {[info exists fxPriv(popup)]} {
	    if {[string compare $fxPriv(popup) ""] != 0} {
		catch "destroy $fxPriv(popup)"
	    }
	}
    }
    wm deiconify $f
    tkwait visibility $f
    set oldGrab [grab current $f]
    set oldFocus [focus]
    catch "grab -global $f"
    focus $f
    tkwait window $f
    catch "grab $oldGrab"
    catch "focus $oldFocus"
    catch "unset fxPriv(popup)"
    if {[winfo exists $b]} {
	set e [winfo parent $b].e1
	if {[winfo exists $e]} {
	    switch $fx_expert_leaves($w,type) {
		dr {$e config -state normal}
		nr {$e config -state normal}
		wr {$e config -state normal}
		r {$e delete 0 end; $e config -state disabled}
		w {$e delete 0 end; $e config -state disabled}
		n {$e delete 0 end; $e config -state disabled}
		d {$e delete 0 end; $e config -state disabled}
		p {$e delete 0 end; $e config -state disabled}
	    }
	}
    }
}

# node format: <logic> <search type> <attr> <value> <second value>
proc Fx:ExpertBuildChild {w s level node before type} {
    global fx_expert_levels fx_expert_leaves qddb_library fx_expert_tmp

    if {![info exists fx_expert_levels($w)]} {
	set fx_expert_levels($w) 0
    } else {
	incr fx_expert_levels($w)
    }
    set x $fx_expert_levels($w)
    set f $w.f$x
    set skiplogic 0
    if {$type == 1} {
	frame $w.fl -relief flat
	pack $w.fl -side top -expand on -fill x
	label $w.fl.l -width 7 -relief groove -bd 2 -takefocus 0 -highlightthickness 0 \
		-textvariable fx_expert_leaves($w.fl,logic) -anchor c
	pack $w.fl.l -side left -anchor w -fill y
	set fx_expert_leaves($w.fl,logic) And
	button $w.fl.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:ExpertDisplayOptions $w.fl $w.fl.b $s 0]
	pack $w.fl.b -side left -anchor w -fill y
	frame $f
	label $f.l -width 7 -relief groove -bd 2 -takefocus 0 -highlightthickness 0
	pack $f.l -side left -fill y
	frame $f.f -relief groove -bd 2 -takefocus 0 -highlightthickness 0
	pack $f.f -side left -expand on -fill both
	button $f.f.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:ExpertDisplayOptions $f $f.f.b $s 1]
	pack $f.f.b -side left -fill y
    } else {
	frame $f
    }
    if {[string compare $before ""] == 0} {
	pack $f -side top -anchor e -ipadx 4m
    } else {
	set cmd [$before cget -command]
	destroy $before
	pack $f -side top -anchor e -ipadx 4m
	button $before -text "Append node" -command $cmd
	pack $before -side bottom -anchor e
    }
    if {$type == 0} {
	label $f.l -width 7 -relief groove -bd 2 -takefocus 0 -highlightthickness 0 \
		-textvariable fx_expert_leaves($f,logic) -anchor c
	pack $f.l -side left -fill y
	frame $f.f -relief groove -bd 2 -takefocus 0 -highlightthickness 0
	pack $f.f -side left -expand on -fill both
	button $f.f.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:ExpertDisplayOptions $f $f.f.b $s 1]
	pack $f.f.b -side left -fill y
    } elseif {$type == 2} {
	set skiplogic 1
	label $f.l -width 7 -relief groove -bd 2 -takefocus 0 -highlightthickness 0
	pack $f.l -side left -fill y
	frame $f.f -relief groove -bd 2 -takefocus 0 -highlightthickness 0
	pack $f.f -side top -expand on -fill both
	button $f.f.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:ExpertDisplayOptions $f $f.f.b $s 1]
	pack $f.f.b -side left -fill y
    }
    entry $f.f.e0 -width 20 -relief sunken -bd 2
    pack $f.f.e0 -side left
    bind $f.f.e0 <Return> {break}
    bind $f.f.e0 <FocusIn> {
	set p [winfo parent [winfo parent %W]]
	set type $fx_expert_leaves($p,type)
	switch $type {
	    d {set type "Date"}
	    dr {set type "Date range"}
	    n {set type "Number"}
	    nr {set type "Numeric range"}
	    w {set type "Word"}
	    wr {set type "Word range"}
	    r {set type "Regular expression"}
	    p {set type "Parse"}
	}
        set fx_expert_tmp(search) $type
	set fx_expert_tmp(attr) $fx_expert_leaves($p,attr)
    }
    bind $f.f.e0 <FocusOut> {
        set fx_expert_tmp(search) ""
	set fx_expert_tmp(attr) ""
    }
    label $f.f.l -text "-" -relief flat -bd 0
    pack $f.f.l -side left -fill y
    entry $f.f.e1 -width 20 -relief sunken -bd 2
    pack $f.f.e1 -side left
    bind $f.f.e1 <Return> {break}
    bind $f.f.e1 <FocusIn>  [bind $f.f.e0 <FocusIn>]
    bind $f.f.e1 <FocusOut> [bind $f.f.e0 <FocusOut>]
    bind $f.f.b <FocusIn> [bind $f.f.e0 <FocusIn>]
    bind $f.f.b <FocusOut> [bind $f.f.e0 <FocusOut>]
    if {[string compare $node ""] != 0} {
	if {$skiplogic == 0} {
	    set fx_expert_leaves($f,logic) [lindex $node 0]
	} else {
	    set fx_expert_leaves($f,logic) {}
	}
	set type [lindex $node 1]
	set fx_expert_leaves($f,type) $type
	set fx_expert_leaves($f,attr) [lindex $node 2]
	$f.f.e0 insert 0 [lindex $node 3]
	if {[string length $type] == 1} {
	    $f.f.e1 config -state disabled
	} else {
	    $f.f.e1 insert 0 [lindex $node 4]
	}
    } else {
	if {$skiplogic == 0} {
	    set fx_expert_leaves($f,logic) And
	} else {
	    set fx_expert_leaves($f,logic) {}
	}
	set fx_expert_leaves($f,type) p
	set fx_expert_leaves($f,attr) {*Any*}
	$f.f.e1 config -state disabled
    }
    return $f
}

# intermediate node: i
# terminal node: t
# start node: nothing
proc Fx:ExpertBuildAllChildren {w s nodes} {
    global fx_expert_levels fx_expert_leaves qddb_library

    set fx_expert_levels($w) 0
    set xx 0
    foreach i $nodes {
	if {[string compare [lindex $i 0] t] != 0} {
	    if {[string compare [lindex $i 0] c] == 0} {continue}
	    if {[string compare [lindex $i 0] i] == 0} {
		set logic [lindex $i 1]
	    } else {
		catch "unset logic"
	    }
	    incr fx_expert_levels($w)
	    set x $fx_expert_levels($w)
	    frame $w.f$x -relief groove -bd 4
	    pack $w.f$x -side top -expand on -ipadx 4m -anchor e

	    set fx_expert_levels($w.f$x) 0
	    if {[info exists logic]} {
		set f $w.f$x
		frame $f.fl -relief flat -bd 0 
		pack $f.fl -side top -expand on -fill x
		label $f.fl.l -width 7 -relief groove -bd 2 -takefocus 0 -highlightthickness 0 \
			-textvariable fx_expert_leaves($f.fl,logic) -anchor c
		pack $f.fl.l -side left -fill y
		set fx_expert_leaves($f.fl,logic) $logic
		button $f.fl.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
			-command [list Fx:ExpertDisplayOptions $f.fl $f.fl.b $s 0]
		pack $f.fl.b -side left -anchor w -fill y
		Fx:ExpertBuildAllChildren $w.f$x $s [lrange $i 2 end]
	    } else {
		Fx:ExpertBuildAllChildren $w.f$x $s $i
	    }
	} else {
	    if {[llength [lindex $i 1]] == 0} {
		Fx:ExpertBuildChild $w $s 0 [lrange $i 1 end] "" 2
	    } else {
		if {$xx >= 2} {
		    Fx:ExpertBuildChild $w $s 0 [lrange $i 1 end] "" 0
		} else {
		    Fx:ExpertBuildChild $w $s 0 [lrange $i 1 end] "" 0
		}
	    }
	    incr xx
	}
    }
    button $w.bottom -text "Append node" -command [list Fx:ExpertAppendNode $w $s $w.bottom]
    pack $w.bottom -side bottom -anchor e
}

proc Fx:ExpertExpandNode {w s} {
    global fx_expert_levels fx_expert_leaves

    set p [winfo parent $w]
    if {[info exists fx_expert_levels($w)]} {
	unset fx_expert_levels($w)
    }
    if {[info exists fx_expert_leaves($w,logic)]} {
	set oldlogic $fx_expert_leaves($w,logic)
    } else {
	set oldlogic And
    }
    if {[info exists fx_expert_leaves($w,attr)]} {
	set oldattr $fx_expert_leaves($w,attr)
    } else {
	set oldattr "*Any*"
    }
    if {[info exists fx_expert_leaves($w,type)]} {
	set oldtype $fx_expert_leaves($w,type)
    } else {
	set oldtype p
    }
    if {[info exists fx_expert_leaves($w,attr)]} {
	catch "unset fx_expert_leaves($w,attr)"
	catch "unset fx_expert_leaves($w,logic)"
	catch "unset fx_expert_leaves($w,type)"
    }
    if {[winfo exists $w.l] && [string compare [$w.l cget -text] ""] == 0} {
	set head_node 1
    } else {
	set head_node 0
    }
    if {[winfo exists $w.f.e0]} {
	set e0val [$w.f.e0 get]
	set e1val [$w.f.e1 get]
    } else {
	set e0val ""
	set e1val ""
    }
    foreach i [winfo children $w] {
	catch "destroy $i"
    }
    set f $w
    $f configure -relief groove -bd 4
    pack $f -ipadx 4m
    if {$head_node} {
	set localf [Fx:ExpertBuildChild $f $s 0 "" "" 2]
	set fx_expert_leaves($localf,attr) $oldattr
	set fx_expert_leaves($localf,type) $oldtype
    } else {
	set localf [Fx:ExpertBuildChild $f $s 0 "" "" 1]
	set fx_expert_leaves($f.fl,logic) $oldlogic
	set fx_expert_leaves($localf,attr) $oldattr
	set fx_expert_leaves($localf,type) $oldtype
    }
    $localf.f.e0 delete 0 end
    $localf.f.e0 insert 0 $e0val
    if {[string length $oldtype] > 1} {
	$localf.f.e1 config -state normal
	$localf.f.e1 delete 0 end
	$localf.f.e1 insert 0 $e1val
    }
    focus $localf.f.e0
    Fx:ExpertBuildChild $f $s 0 "" "" 0
    button $f.bottom -text "Append node" -command [list Fx:ExpertAppendNode $f $s $f.bottom]
    pack $f.bottom -side bottom -anchor e
}

proc Fx:ExpertDestroyParents {w} {
    set parent [winfo parent $w]
    destroy $w
    if {[string compare [winfo class $parent] Canvas] == 0} {
	return
    }
    set num_children 0
    foreach i [winfo children $parent] {
	if {[string compare [winfo class $i] Frame] == 0} {
	    if {[string compare $parent.fl $i]} {
		set frame_child $i
		incr num_children	    
	    }
	}
    }
    if {$num_children == 1} {
	set child $frame_child
	if {[winfo exists $child.fl.l]} {
	    destroy $child.fl
	} elseif {[winfo exists $child.l]} {
	    set var [$child.l cget -textvariable]
	    set $var ""
	}
    } elseif {$num_children == 0} {
	Fx:ExpertDestroyParents $parent
    }
}

proc Fx:ExpertCheckFrames {w} {
    global fx_expert_leaves

    foreach i [winfo children $w] {
	if {[string compare [winfo class $i] Frame] == 0} {
	    if {[winfo exists $i.l]} {
		set var [$i.l cget -textvariable]
		set $var ""
	    } elseif {[winfo exists $i.fl.l]} {
		destroy $i.fl
		Fx:ExpertCheckFrames $i
	    } else {
		Fx:ExpertCheckFrames $i
	    }
	    break
	}
    }
}

proc Fx:ExpertDeleteNode {w s} {
    global fx_expert_leaves fx_expert_topframe

    set parent [winfo parent $w]
    # head node
    if {[winfo exists $w.f.e0]} {
	if {[string compare [$w.l cget -text] ""] == 0} {
	    set nextw [tk_focusNext $w.f.e1]
	    if {[string compare [winfo class $nextw] Button] == 0} {
		if {[string compare [$nextw cget -text] "Append node"] == 0} {
		    set nextw [tk_focusNext $nextw]
		}
	    }
	    set nextp1 [winfo parent $nextw]
	    set nextp2 [winfo parent $nextp1]  
	    set nextp3 [winfo parent $nextp2]
	    if {[string compare $nextp3 $parent] == 0} {
		set nextp [winfo parent [winfo parent $nextw]]
		if {[winfo exists $nextp.l]} {
		    set var [$nextp.l cget -textvariable]
		    set $var ""
		} elseif {[winfo exists $nextp.fl.l]} {
		    destroy $nextp.fl
		}
	    } else {
		Fx:ExpertDestroyParents $parent
		if {[winfo exists $fx_expert_topframe]} {
		    Fx:ExpertCheckFrames $fx_expert_topframe
		}
	    }
	}
    } else {
	Fx:ExpertDestroyParents $parent
    }
    catch "destroy $w"
    catch "unset fx_expert_leaves($w,attr)"
    catch "unset fx_expert_leaves($w,type)"
    catch "unset fx_expert_leaves($w,logic)"
    set num_children 0
    if {[winfo exists $fx_expert_topframe]} {
	foreach i [winfo children $fx_expert_topframe] {
	    if {[string compare [winfo class $i] Frame] == 0} {
		set frame_child $i
		incr num_children
	    }
	}
	if {$num_children == 0} {
	    Fx:ExpertSearchFrame $fx_expert_topframe $s {}
	} elseif {$num_children == 1} {
	    set child $frame_child
	    if {[winfo exists $child.fl.l]} {
		destroy $child.fl
	    } elseif {[winfo exists $child.l]} {
		set var [$child.l cget -textvariable]
		set $var ""
	    }
	} else {
	    Fx:ExpertCheckFrames $fx_expert_topframe
	}
    } else {
	Fx:ExpertSearchFrame $fx_expert_topframe $s {}
	set c [winfo parent $fx_expert_topframe]
        $c create window 0 0 -window $c.f -anchor nw
        bind $c.f <Configure> [list Fx:ExpertReconfigureCanvas %W $c $c.f]
    }
}

proc Fx:ExpertAppendNode {w s before} {
    set f [Fx:ExpertBuildChild $w $s 0 "" $before 0]
    focus $f.f.e0
}

proc Fx:ExpertTraverseWidgets {w} {
    global fx_expert_leaves

    set retval {}
    set lab $w.fl.l
    if {[winfo exists $lab]} {
	# intermediate node
	lappend retval i $fx_expert_leaves([winfo parent $lab],logic)
    }
    foreach i [winfo children $w] {
	if {[string compare $i $w.fl] == 0} {continue}
	if {[string compare [winfo class $i] Frame] == 0} {
	    if {[winfo exists $i.f.e1]} {
		if {[winfo exists $i.l] && [string compare [$i.l cget -text] ""] == 0} {
		    lappend retval [list t {} $fx_expert_leaves($i,type) $fx_expert_leaves($i,attr) \
			    [$i.f.e0 get] [$i.f.e1 get]]		    
		} else {
		    lappend retval [list t $fx_expert_leaves($i,logic) \
			    $fx_expert_leaves($i,type) $fx_expert_leaves($i,attr) \
			    [$i.f.e0 get] [$i.f.e1 get]]
		}
	    } else {
		lappend retval [Fx:ExpertTraverseWidgets $i]
	    }
	}
    }
    return $retval
}

proc Fx:ExpertSearchFrame {w s {nodes ""}} {
    global fx_expert_leaves fx_expert_levels fx_expert_topframe

    catch "unset fx_expert_leaves"
    catch "unset fx_expert_levels"
    if {[winfo exists $w]} {
	destroy $w
    }
    set fx_expert_topframe $w
    frame $w
    if {[string compare $nodes ""] != 0} {
	Fx:ExpertBuildAllChildren $w $s $nodes
    } else {
	Fx:ExpertBuildChild $w $s 0 "" "" 2
	button $w.bottom -text "Append node" -command [list Fx:ExpertAppendNode $w $s $w.bottom]
	pack $w.bottom -side bottom -anchor e
    }
    update idletasks
    update
}

proc Fx:ExpertReconfigureCanvas {w c f} {
    if {[string compare $w $f] == 0} {
	$c configure -scrollregion [list 0 0 [winfo reqwidth $f] [winfo reqheight $f]] \
		-width [winfo reqwidth $f]
    }
}

proc Fx:ExpertSearchWindow {w s {restrict ""} {nodes ""} {allbuttons 1} {title 0} {titleval ""}} {
    global fx_expert_leaves fx_expert_levels fx_expert_ret fx_expert_tmp \
	    fx_config fx_expert_comments fx_expert_title

    catch "unset fx_expert_leaves"
    catch "unset fx_expert_levels"
    catch "unset fx_expert_ret"
    catch "unset fx_expert_tmp"
    set fx_expert_title ""
    toplevel $w
    wm title $w "Expert Search"
    wm withdraw $w
    if {$title} {
	frame $w.title
	pack $w.title -side top -expand on -fill x
	set t $w.title
	label $t.l -text "Title" -anchor e
	pack $t.l -side left
	entry $t.e -textvariable fx_expert_title -width 40
	pack $t.e -side left -expand on -fill x
	set fx_expert_title $titleval
    }
    frame $w.top -relief flat -bd 0 -takefocus 0 -highlightthickness 0
    pack $w.top -side top -fill x -padx 3m -pady 3m
    frame $w.top.top
    pack $w.top.top -side top -fill x
    label $w.top.top.searchlabel -text "Current search type" -anchor e -width 20
    entry $w.top.top.search -textvariable fx_expert_tmp(search) -width 20 \
	    -relief groove -bd 2 -state disabled
    frame $w.top.bot
    pack $w.top.bot -side top -fill x
    label $w.top.bot.attrlabel -text "Current attribute" -anchor e -width 20
    entry $w.top.bot.attr -textvariable fx_expert_tmp(attr) -width 20 \
	    -relief groove -bd 2 -state disabled
    pack $w.top.top.searchlabel -side left
    pack $w.top.top.search -side left
    pack $w.top.bot.attrlabel -side left
    pack $w.top.bot.attr -side left -expand on -fill x
    set lastnode [lindex $nodes end]
    frame $w.f -takefocus 0 -highlightthickness 0 -relief groove -bd 4
    pack $w.f -side top -expand on -fill both
    scrollbar $w.f.s -orient vertical -takefocus 1 -relief sunken \
	    -command [list $w.f.c yview]
    pack $w.f.s -side right -fill y
    canvas $w.f.c -takefocus 0 -highlightthickness 0 -bd 0 -yscrollcommand [list $w.f.s set]
    pack $w.f.c -side left -expand on -fill both
    if {[string compare [lindex $lastnode 0] c] == 0} {
	Fx:ExpertSearchFrame $w.f.c.f $s [lindex $nodes 0]
    } else {
	Fx:ExpertSearchFrame $w.f.c.f $s $nodes
    }
    $w.f.c create window 0 0 -window $w.f.c.f -anchor nw
    bind $w.f.c.f <Configure> [list Fx:ExpertReconfigureCanvas %W $w.f.c $w.f.c.f]
    update idletasks
    set reqheight [winfo reqheight $w.f.c.f]
    set reqwidth [winfo reqwidth $w.f.c.f]
    $w.f.c configure -width $reqwidth -scrollregion \
	    [list 0 0 $reqwidth $reqheight]
    frame $w.bc -relief groove -bd 4
    label $w.bc.l -text Comments -anchor w
    pack $w.bc.l -side top -fill x
    scrollbar $w.bc.s -orient vertical -command [list $w.bc.t yview] -takefocus 0 -highlightthickness 0
    text $w.bc.t -wrap word -width 1 -height 3 -yscroll [list $w.bc.s set]
    pack $w.bc.s -side right -fill y
    pack $w.bc.t -side left -expand on -fill both
    set fx_expert_comments $w.bc.t
    if {[string compare [lindex $lastnode 0] c] == 0} {
	$w.bc.t insert 0.0 [lindex $lastnode 1]
    }
    frame $w.b -relief groove -bd 4
    pack $w.b -side bottom -fill x
    pack $w.bc -side bottom -fill x
    set b $w.b
    if {$allbuttons} {
	button $b.search -text Search -padx 4m -pady 2m -command "set fx_expert_ret 1"
    } else {
	button $b.search -text Ok -padx 4m -pady 2m -command "set fx_expert_ret 1"
    }
    button $b.cancel -text Dismiss -padx 4m -pady 2m -command "set fx_expert_ret 0"
    button $b.clear -text Clear -padx 4m -pady 2m -command "
        Fx:ExpertSearchFrame $w.f.c.f $s {}
        $w.bc.t delete 0.0 end
        $w.f.c create window 0 0 -window $w.f.c.f -anchor nw
        bind $w.f.c.f <Configure> \{Fx:ExpertReconfigureCanvas %W $w.f.c $w.f.c.f\}
	update idletasks
	focus \[tk_focusNext $w.f.s\]
    "
    pack $b.search $b.cancel $b.clear -side left -padx 2m -pady 2m
    if {$allbuttons} {
	button $b.write -text "Write to file" -padx 4m -pady 2m \
		-command [list Fx:ExpertWriteFile $w.f.c.f $s $restrict]
	button $b.read -text "Read from file" -padx 4m -pady 2m \
		-command "
        Fx:ExpertReadFile $w.f.c.f $s [list $restrict]
        $w.f.c create window 0 0 -window $w.f.c.f -anchor nw
        bind $w.f.c.f <Configure> \{Fx:ExpertReconfigureCanvas %W $w.f.c $w.f.c.f\}
	update idletasks
	focus \[tk_focusNext $w.f.s\]
	"
	pack $b.read $b.write -side right -padx 2m -pady 2m
    }
    Fx:SetGeometry $w
    update idletasks
    fx_bindposition $w
    wm protocol $w WM_DELETE_WINDOW [list set fx_expert_ret 0]
    wm deiconify $w
    tkwait visibility $w
    update idletasks
    update
    if {!$title} {
	focus [tk_focusNext $w.f.s]
    } else {
	focus $t.e
    }
    tkwait variable fx_expert_ret
    set retval [list $fx_expert_ret [list [Fx:ExpertTraverseWidgets $w.f.c.f] \
	    [list c [$w.bc.t get 0.0 end]]] $fx_expert_title]
    destroy $w
    update idletasks; update
    return $retval
}

proc Fx:ExpertWriteFile {w s restrict} {
    global fx_expert_comments

    set fn [Fx:FileSelect .fx_expert_writefile w $restrict]
    if {[string length $fn] == 0} {
	return
    }
    set val [list [Fx:ExpertTraverseWidgets $w] [list c [$fx_expert_comments get 0.0 end]]]
    set fd [open $fn w]
    puts $fd $val
    close $fd
}

proc Fx:ExpertReadFile {w s restrict} {
    global fx_expert_comments

    set fn [Fx:FileSelect .fx_expert_readfile r $restrict]
    if {[string length $fn] == 0} {
	return
    }
    set fd [open $fn r]
    set val [read -nonewline $fd]
    close $fd
    set comments [lindex $val end]
    if {[string compare [lindex $comments 0] c] == 0} {
	Fx:ExpertSearchFrame $w $s [lindex $val 0]
	$fx_expert_comments delete 0.0 end
	$fx_expert_comments insert 0.0 [lindex $comments 1]
    } else {
	Fx:ExpertSearchFrame $w $s $val
	$fx_expert_comments delete 0.0 end
    }
}

proc Fx:ExpertSearchParseNode {s node} {
    global fx_excludewords

    update idletasks; update
    set opt [lindex $node 2]
    set attr [lindex $node 3]
    set lhs [lindex $node 4]
    set rhs [lindex $node 5]
    if {[string compare $attr "*Any*"] == 0} {
	set anynode 1
    } else {
	set anynode 0
    }
    if {[string compare [lindex $node 2] p] == 0} {
	if {$anynode} {
	    if {[catch [list Fx_QddbSearchParser :: MultiSearch \
		    $s $lhs off] err] != 0} {
		error $err
	    }
	    return $err
	} else {
	    if {[catch [list Fx_QddbSearchParser :: MultiSearch \
		    $s $lhs on $attr] err] != 0} {
		error $err
	    }
	    return $err
	}
    } else {
	switch $opt {
	    nr -
	    wr {
		set llen [string length $lhs]
		set rlen [string length $rhs]
		if {[string compare $opt nr] == 0} {
		    if {$llen > 0 && [catch "expr double($lhs)" err] != 0} {
			error "Invalid number: $lhs"
		    }
		    if {$rlen > 0 && [catch "expr double($rhs)" err] != 0} {
			error "Invalid number: $rhs"
		    }
		}
		if {$anynode} {
		    if {$llen > 0 && $rlen > 0} {
			return [qddb_search $s $opt $lhs - $rhs]
		    } elseif {$llen > 0 && $rlen == 0} {
			return [qddb_search $s $opt $lhs -]
		    } elseif {$llen == 0 && $rlen > 0} {
			return [qddb_search $s $opt - $rhs]
		    } else {
			return [qddb_search $s $opt -]
		    }
		} else {
		    if {$llen > 0 && $rlen > 0} {
			return [qddb_search $s -prunebyattr $attr $opt $lhs - $rhs]
		    } elseif {$llen > 0 && $rlen == 0} {
			return [qddb_search $s -prunebyattr $attr $opt $lhs -]
		    } elseif {$llen == 0 && $rlen > 0} {
			return [qddb_search $s -prunebyattr $attr $opt - $rhs]
		    } else {
			return [qddb_search $s -prunebyattr $attr $opt -]
		    }
		}
	    }
	    r -
	    w -
	    n {
		if {[string compare $opt n] == 0} {
		    if {[catch "expr double($lhs)" err] != 0} {
			error "Invalid number: $lhs"
		    }
		}
		if {[info exists fx_excludewords([string tolower $lhs])]} {
		    error "The word '$lhs' is excluded from indexing and will produce no matches"
		}
		if {$anynode} {
		    return [qddb_search $s $opt $lhs]
		} else {
		    return [qddb_search $s -prunebyattr $attr $opt $lhs]
		}
	    }
	    d -
	    dr {
		if {[string compare $opt d] == 0} {
		    set rhs $lhs
		}
		set llen [string length $lhs]
		if {$llen > 0} {
		    if {[qddb_util isdate "$lhs 12:00AM"]} {
			set lhs "$lhs 12:00AM"
		    } elseif {![qddb_util isdate $lhs]} {
			error "Invalid date: $lhs"
		    }
		}
		set rlen [string length $rhs]
		if {$rlen > 0} {
		    if {[qddb_util isdate "$rhs 11:59PM"]} {
			set rhs "$rhs 11:59PM"
		    } elseif {![qddb_util isdate $rhs]} {
			error "Invalid date: $rhs"
		    }
		}
		if {$anynode} {
		    if {$llen > 0 && $rlen > 0} {
			return [qddb_search $s dr $lhs - $rhs]
		    } elseif {$llen > 0 && $rlen == 0} {
			return [qddb_search $s dr $lhs -]
		    } elseif {$llen == 0 && $rlen > 0} {
			return [qddb_search $s dr - $rhs]
		    } else {
			return [qddb_search $s dr -]
		    }
		} else {
		    if {$llen > 0 && $rlen > 0} {
			return [qddb_search $s -prunebyattr $attr dr $lhs - $rhs]
		    } elseif {$llen > 0 && $rlen == 0} {
			return [qddb_search $s -prunebyattr $attr dr $lhs -]
		    } elseif {$llen == 0 && $rlen > 0} {
			return [qddb_search $s -prunebyattr $attr dr - $rhs]
		    } else {
			return [qddb_search $s -prunebyattr $attr dr -]
		    }
		}
	    }
	    default {
		error "Internal Qddb error: no such search type '$opt'"
	    }
	}
    }
}

proc Fx:ExpertSearchParser {s nodes} {
    set search_attrs {}
    foreach i $nodes {
	update idletasks; update
	if {[string compare [lindex $i 0] t] != 0} {
	    if {[string compare [lindex $i 0] c] == 0} {continue}
	    if {[string compare [lindex $i 0] i] == 0} {
		set logic [lindex $i 1]
	    } else {
		catch "unset logic"
	    }
	    if {[info exists logic] && [info exists k]} {
		set l [Fx:ExpertSearchParser $s [lrange $i 2 end]]
		set attr [lindex $l 0]
		set k1 [lindex $l 1]
		if {[string length $k1] == 0} {
		    catch "unset k1"
		    catch "unset attr"
		    catch "unset logic"
		    continue
		}
	    } else {
		set l [Fx:ExpertSearchParser $s $i]
		set attr [lindex $l 0]
		set k [lindex $l 1]
		if {[string length $k] == 0} {
		    catch "unset k"
		    catch "unset attr"
		    catch "unset logic"
		    continue
		}
	    }
	} else {
	    set logic [lindex $i 1]
	    if {[llength $logic] == 0 || ![info exists k]} {
		set k [Fx:ExpertSearchParseNode $s $i]
		if {[string length $k] == 0} {
		    catch "unset k"
		    catch "unset attr"
		    catch "unset logic"
		    continue
		}
		set attr [lindex $i 3]
		unset logic
		if {[string compare $attr "*Any*"] == 0} {
		    unset attr
		}
	    } else {
		set k1 [Fx:ExpertSearchParseNode $s $i]
		if {[string length $k1] == 0} {
		    catch "unset k1"
		    catch "unset attr"
		    catch "unset logic"
		    continue
		}
		set attr [lindex $i 3]
		if {[string compare $attr "*Any*"] == 0} {
		    unset attr
		}
	    }
	}
	if {[info exists logic]} {
	    if {![info exists k]} {
		continue
	    }
	    switch $logic {
		And {
		    set k [qddb_keylist op intersection -exact off $k $k1]
		    if {[info exists attr]} {
			eval lappend search_attrs $attr
		    }
		}
		Or {
		    set k [qddb_keylist op union -exact off $k $k1]
		    if {[info exists attr]} {
			set search_attrs [Fx:lintersect $search_attrs $attr]
		    }
		}
		Not {
		    set k [qddb_keylist op exclusion -exact off $k $k1]
		}
		S-and {
		    set k [qddb_keylist op intersection -exact on $k $k1]
		    if {[info exists attr]} {
			eval lappend search_attrs $attr
		    }
		}
		S-not {
		    set k [qddb_keylist op exclusion -exact on $k $k1]
		}
		default {
		    error "Internal Qddb Error: bad logic type '$logic'"
		}
	    }
	} else {
	    if {[info exists attr]} {
		eval lappend search_attrs $attr
	    }
	}
	catch "unset attr"
    }
    if {![info exists k]} {
	return {}
    }
    return [list $search_attrs $k]
}

if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_expert.tcl"
}
