set fx_colornames {
red tangerine orange goldenrod yellow chartreuse green aquamarine cyan azure blue thistle purple plum magenta maroon grey0 grey1 grey2 grey3 grey4 grey5 grey6 grey7 grey8 grey9 grey10 grey11 grey12 grey13 grey14 grey15 grey16 grey17 grey18 grey19 grey20 grey21 grey22 grey23 grey24 grey25 grey26 grey27 grey28 grey29 grey30 grey31 grey32 grey33 grey34 grey35 grey36 grey37 grey38 grey39 grey40 grey41 grey42 grey43 grey44 grey45 grey46 grey47 grey48 grey49 grey50 grey51 grey52 grey53 grey54 grey55 grey56 grey57 grey58 grey59 grey60 grey61 grey62 grey63 grey64 grey65 grey66 grey67 grey68 grey69 grey70 grey71 grey72 grey73 grey74 grey75 grey76 grey77 grey78 grey79 grey80 grey81 grey82 grey83 grey84 grey85 grey86 grey87 grey88 grey89 grey90 grey91 grey92 grey93 grey94 grey95 grey96 grey97 grey98 grey99 grey100 grey gray0 black white snow FloralWhite OldLace linen AntiqueWhite PapayaWhip BlanchedAlmond bisque PeachPuff NavajoWhite moccasin cornsilk ivory LemonChiffon seashell honeydew MintCream AliceBlue LavenderBlush MistyRose WhiteSmoke gainsboro DarkSlateGrey DimGrey SlateGrey LightSlateGrey LightGrey MidnightBlue navy NavyBlue CornflowerBlue DarkSlateBlue SlateBlue MediumSlateBlue LightSlateBlue MediumBlue DodgerBlue DeepSkyBlue SkyBlue LightSkyBlue SteelBlue LightSteelBlue LightBlue PowderBlue PaleTurquoise DarkTurquoise MediumTurquoise turquoise LightCyan CadetBlue MediumAquamarine DarkGreen DarkOliveGreen SeaGreen MediumSeaGreen PaleGreen SpringGreen MediumSpringGreen GreenYellow LimeGreen YellowGreen ForestGreen MediumForestGreen OliveDrab DarkKhaki khaki LightGoldenrodYellow LightYellow gold MediumGoldenrod RosyBrown IndianRed SaddleBrown sienna peru burlywood wheat SandyBrown tan chocolate firebrick brown DarkSalmon salmon LightSalmon DarkOrange coral tomato OrangeRed DeepPink pink LightPink PaleVioletRed MediumVioletRed VioletRed violet orchid MediumOrchid DarkOrchid DarkViolet BlueViolet MediumPurple snow1 snow2 snow3 snow4 seashell1 seashell2 seashell3 seashell4 AntiqueWhite1 AntiqueWhite2 AntiqueWhite3 AntiqueWhite4 bisque1 bisque2 bisque3 bisque4 PeachPuff1 PeachPuff2 PeachPuff3 PeachPuff4 NavajoWhite1 NavajoWhite2 NavajoWhite3 NavajoWhite4 LemonChiffon1 LemonChiffon2 LemonChiffon3 LemonChiffon4 cornsilk1 cornsilk2 cornsilk3 cornsilk4 ivory1 ivory2 ivory3 ivory4 honeydew1 honeydew2 honeydew3 honeydew4 LavenderBlush1 LavenderBlush2 LavenderBlush3 LavenderBlush4 MistyRose1 MistyRose2 MistyRose3 MistyRose4 azure1 azure2 azure3 azure4 SlateBlue1 SlateBlue2 SlateBlue3 SlateBlue4 blue1 blue2 blue3 blue4 DodgerBlue1 DodgerBlue2 DodgerBlue3 DodgerBlue4 SteelBlue1 SteelBlue2 SteelBlue3 SteelBlue4 DeepSkyBlue1 DeepSkyBlue2 DeepSkyBlue3 DeepSkyBlue4 SkyBlue1 SkyBlue2 SkyBlue3 SkyBlue4 LightSkyBlue1 LightSkyBlue2 LightSkyBlue3 LightSkyBlue4 LightSteelBlue1 LightSteelBlue2 LightSteelBlue3 LightSteelBlue4 LightBlue1 LightBlue2 LightBlue3 LightBlue4 LightCyan1 LightCyan2 LightCyan3 LightCyan4 PaleTurquoise1 PaleTurquoise2 PaleTurquoise3 PaleTurquoise4 CadetBlue1 CadetBlue2 CadetBlue3 CadetBlue4 turquoise1 turquoise2 turquoise3 turquoise4 cyan1 cyan2 cyan3 cyan4 aquamarine1 aquamarine2 aquamarine3 aquamarine4 SeaGreen1 SeaGreen2 SeaGreen3 SeaGreen4 PaleGreen1 PaleGreen2 PaleGreen3 PaleGreen4 SpringGreen1 SpringGreen2 SpringGreen3 SpringGreen4 green1 green2 green3 green4 chartreuse1 chartreuse2 chartreuse3 chartreuse4 OliveDrab1 OliveDrab2 OliveDrab3 OliveDrab4 DarkOliveGreen1 DarkOliveGreen2 DarkOliveGreen3 DarkOliveGreen4 khaki1 khaki2 khaki3 khaki4 LightYellow1 LightYellow2 LightYellow3 LightYellow4 yellow1 yellow2 yellow3 yellow4 gold1 gold2 gold3 gold4 goldenrod1 goldenrod2 goldenrod3 goldenrod4 RosyBrown1 RosyBrown2 RosyBrown3 RosyBrown4 IndianRed1 IndianRed2 IndianRed3 IndianRed4 sienna1 sienna2 sienna3 sienna4 burlywood1 burlywood2 burlywood3 burlywood4 wheat1 wheat2 wheat3 wheat4 tan1 tan2 tan3 tan4 chocolate1 chocolate2 chocolate3 chocolate4 firebrick1 firebrick2 firebrick3 firebrick4 brown1 brown2 brown3 brown4 salmon1 salmon2 salmon3 salmon4 LightSalmon1 LightSalmon2 LightSalmon3 LightSalmon4 orange1 orange2 orange3 orange4 DarkOrange1 DarkOrange2 DarkOrange3 DarkOrange4 coral1 coral2 coral3 coral4 tomato1 tomato2 tomato3 tomato4 OrangeRed1 OrangeRed2 OrangeRed3 OrangeRed4 red1 red2 red3 red4 DeepPink1 DeepPink2 DeepPink3 DeepPink4 pink1 pink2 pink3 pink4 LightPink1 LightPink2 LightPink3 LightPink4 PaleVioletRed1 PaleVioletRed2 PaleVioletRed3 PaleVioletRed4 maroon1 maroon2 maroon3 maroon4 VioletRed1 VioletRed2 VioletRed3 VioletRed4 magenta1 magenta2 magenta3 magenta4 orchid1 orchid2 orchid3 orchid4 plum1 plum2 plum3 plum4 MediumOrchid1 MediumOrchid2 MediumOrchid3 MediumOrchid4 DarkOrchid1 DarkOrchid2 DarkOrchid3 DarkOrchid4 purple1 purple2 purple3 purple4 MediumPurple1 MediumPurple2 MediumPurple3 MediumPurple4 thistle1 thistle2 thistle3 thistle4 GhostWhite lavender RoyalBlue DarkSeaGreen LightSeaGreen LawnGreen PaleGoldenrod LightGoldenrod DarkGoldenrod beige LightCoral HotPink RoyalBlue1 RoyalBlue2 RoyalBlue3 RoyalBlue4 DarkSeaGreen1 DarkSeaGreen2 DarkSeaGreen3 DarkSeaGreen4 LightGoldenrod1 LightGoldenrod2 LightGoldenrod3 LightGoldenrod4 DarkGoldenrod1 DarkGoldenrod2 DarkGoldenrod3 DarkGoldenrod4 HotPink1 HotPink2 HotPink3 HotPink4 DarkGrey DarkBlue DarkCyan DarkMagenta DarkRed LightGreen 
}

proc Fx:ColorInit {} {
    global fx_config

    if {![info exists fx_config(mandatory_field_bg)]} {
	set fx_config(mandatory_field_bg) grey87
    }
    if {![info exists fx_config(\$palette\$)]} {
	set fx_config(\$palette\$) e9e9e9
	set fx_config(\$color\$,red) 233
	set fx_config(\$color\$,green) 233
	set fx_config(\$color\$,blue) 233
	tk_setPalette \#$fx_config(\$palette\$)
    } else {
	tk_setPalette \#$fx_config(\$palette\$)
    }
}

proc Fx:ConfigureColors {} {
    global fx_config fx_colornames

    set c .color_config
    if {[winfo exists $c]} {
	raise $c
	focus $c
	return
    }
    toplevel $c
    wm title $c "Color Configuration"
    wm iconname $c "Colors"
    wm withdraw $c

    set fx_config(\$oldpalette\$) $fx_config(\$palette\$)
    set fx_config(\$color\$,oldred) $fx_config(\$color\$,red)
    set fx_config(\$color\$,oldgreen) $fx_config(\$color\$,green)
    set fx_config(\$color\$,oldblue) $fx_config(\$color\$,blue)

    frame $c.top -relief groove -bd 4
    pack $c.top -side top -fill x
    set c $c.top

    frame $c.scales -relief groove -bd 4
    pack $c.scales -side left -expand on -fill both
    label $c.scales.l -width 40 -height 2 -bg \#$fx_config(\$palette\$)
    pack $c.scales.l -side top -fill x
    set interval 50
    scale $c.scales.red -from 0 -to 255 -showvalue 1 -tickinterval $interval -label Red -orient horiz \
	    -variable fx_config(\$color\$,red) -command [list Fx:ColorCommand $c.scales.l]
    pack $c.scales.red -side top -expand on -fill x
    scale $c.scales.green -from 0 -to 255 -showvalue 1 -tickinterval $interval -label Green -orient horiz \
	    -variable fx_config(\$color\$,green) -command [list Fx:ColorCommand $c.scales.l]
    pack $c.scales.green -side top -expand on -fill x
    scale $c.scales.blue -from 0 -to 255 -showvalue 1 -tickinterval $interval -label Blue -orient horiz \
	    -variable fx_config(\$color\$,blue) -command [list Fx:ColorCommand $c.scales.l]
    pack $c.scales.blue -side top -expand on -fill x

    frame $c.list -relief groove -bd 4
    pack $c.list -side left -expand on -fill both

    label $c.list.l -relief ridge -bd 4 -text "Symbolic Color Names"
    pack $c.list.l -side top -fill x
    scrollbar $c.list.s -relief sunken -command [list $c.list.lb yview] -takefocus 0
    pack $c.list.s -side right -fill y
    listbox $c.list.lb -relief sunken -width 20 -yscroll [list $c.list.s set]
    pack $c.list.lb -side left -expand on -fill both
    eval $c.list.lb insert 0 $fx_colornames
    $c.list.lb activate 0
    bind $c.list.lb <ButtonRelease-1> "Fx:SetColor $c.list.lb $c.scales.l"
    bind $c.list.lb <Return> "Fx:SetColor $c.list.lb $c.scales.l"
    bindtags $c.list.lb [list Listbox $c.list.lb . all]    

    set c .color_config

    frame $c.bot -relief groove -bd 4
    pack $c.bot -side bottom -fill x -ipady 2m -ipadx 4m
    button $c.bot.ok -text Ok -command {
	catch {destroy .color_config}
	update idletasks
	update
	if {[string compare $fx_config(\$palette\$) $fx_config(\$oldpalette\$)] != 0} {
	    Fx:BusyExec . [list tk_setPalette \#$fx_config(\$palette\$)]
	}
    }
    button $c.bot.cancel -text Cancel -command {
	if {[string compare $fx_config(\$palette\$) $fx_config(\$oldpalette\$)] != 0} {
	    set fx_config(\$palette\$) $fx_config(\$oldpalette\$)
	    set fx_config(\$color\$,red) $fx_config(\$color\$,oldred)
	    set fx_config(\$color\$,green) $fx_config(\$color\$,oldgreen)
	    set fx_config(\$color\$,blue) $fx_config(\$color\$,oldblue)
	    catch {destroy .color_config}
	    update idletasks
	    update
	    Fx:BusyExec . [list tk_setPalette \#$fx_config(\$palette\$)]
	} else {
	    catch {destroy .color_config}
	}
    }
    button $c.bot.apply -text Apply -command {
	Fx:BusyExec {. .color_config} [list tk_setPalette \#$fx_config(\$palette\$)]
    }
    button $c.bot.revert -text Revert -command {
	set fx_config(\$palette\$) $fx_config(\$oldpalette\$)
	set fx_config(\$color\$,red) $fx_config(\$color\$,oldred)
	set fx_config(\$color\$,green) $fx_config(\$color\$,oldgreen)
	set fx_config(\$color\$,blue) $fx_config(\$color\$,oldblue)	
	Fx:BusyExec {. .color_config} [list tk_setPalette \#$fx_config(\$palette\$)]
    }
    pack $c.bot.ok -side left -padx 4m -pady 2m
    pack $c.bot.cancel -side left -padx 4m -pady 2m
    pack $c.bot.revert -side right -padx 4m -pady 2m
    pack $c.bot.apply -side right -padx 4m -pady 2m
    Fx:SetGeometry $c
    update idletasks
    wm minsize $c [winfo reqwidth $c] [winfo reqheight $c]
    wm maxsize $c [winfo reqwidth $c] [winfo reqheight $c]
    fx_bindposition $c
    wm deiconify $c
    tkwait window .color_config
}

proc Fx:ColorCommand {l num} {
    global fx_config

    set fx_config(\$palette\$) [format "%02x%02x%02x" $fx_config(\$color\$,red) \
	    $fx_config(\$color\$,green) $fx_config(\$color\$,blue)]
    $l configure -bg \#$fx_config(\$palette\$)
}

proc Fx:SetColor {w l} {
    global fx_config
    set color [$w get [$w curselection]]
    if [catch "winfo rgb . $color" rgb] {
	fx_dialog .color_config.dialog "Bad Color" "Color ($color) is not available on your system." \
		error 0 Ok
	return
    }
    set fx_config(\$color\$,red) [expr [lindex $rgb 0] >> 8]
    set fx_config(\$color\$,green) [expr [lindex $rgb 1] >> 8]
    set fx_config(\$color\$,blue) [expr [lindex $rgb 2] >> 8]
    set fx_config(\$palette\$) [format "%02x%02x%02x" $fx_config(\$color\$,red) \
	    $fx_config(\$color\$,green) $fx_config(\$color\$,blue)]
    $l configure -bg \#$fx_config(\$palette\$)    
}

proc Fx:color_midrange {num} {
    if [expr 0x$num > 0x44 && 0x$num < 0xaa] {
	return 1
    } else {
	return 0
    }
}

proc Fx:reverse_color {color} {
    set red [format "%02x" [expr 0xff - 0x[string range $color 0 1]]]
    set green [format "%02x" [expr 0xff - 0x[string range $color 2 3]]]
    set blue [format "%02x" [expr 0xff - 0x[string range $color 4 5]]]
    if {[Fx:color_midrange $red] && [Fx:color_midrange $green] && [Fx:color_midrange $blue]} {
	return 000000
    }
    return $red$green$blue
}

proc Fx:SelectSetColor {w l} {
    global fx_colorconfig

    set color [$w get [$w curselection]]
    if [catch "winfo rgb . $color" rgb] {
	fx_dialog .color_select.dialog "Bad Color" "Color ($color) is not available on your system." \
		error 0 Ok
	return
    }
    set fx_colorconfig(\$color\$,red) [expr [lindex $rgb 0] >> 8]
    set fx_colorconfig(\$color\$,green) [expr [lindex $rgb 1] >> 8]
    set fx_colorconfig(\$color\$,blue) [expr [lindex $rgb 2] >> 8]
    set fx_colorconfig(current) [format "%02x%02x%02x" $fx_colorconfig(\$color\$,red) \
	    $fx_colorconfig(\$color\$,green) $fx_colorconfig(\$color\$,blue)]
    set fx_colorconfig(current_name) $color
    $l configure -bg \#$fx_colorconfig(current)
}

proc Fx:SelectColorCommand {l num} {
    global fx_colorconfig

    set fx_colorconfig(current) [format "%02x%02x%02x" $fx_colorconfig(\$color\$,red) \
	    $fx_colorconfig(\$color\$,green) $fx_colorconfig(\$color\$,blue)]
    $l configure -bg \#$fx_colorconfig(current)
    catch "unset fx_colorconfig(current_name)"
}

proc Fx:SelectColor {w {default black}} {
    global fx_colornames fx_colorconfig

    set c .color_select
    if {[winfo exists $c]} {
	raise $c
	focus $c
	return
    }
    toplevel $c
    wm title $c "Color Selection"
    wm iconname $c "Colors"
    wm withdraw $c
    if {[catch "winfo rgb . $default" rgb] != 0} {
	if [catch "winfo rgb . \#$default" rgb] {
	    fx_dialog $c.dialog "Bad Color" "Color ($default) is not available on your system." \
		    error 0 Ok
	    return
	}
    }
    set fx_colorconfig(\$color\$,red) [expr [lindex $rgb 0] >> 8]
    set fx_colorconfig(\$color\$,green) [expr [lindex $rgb 1] >> 8]
    set fx_colorconfig(\$color\$,blue) [expr [lindex $rgb 2] >> 8]
    set fx_colorconfig(current) [format "%02x%02x%02x" $fx_colorconfig(\$color\$,red) \
	    $fx_colorconfig(\$color\$,green) $fx_colorconfig(\$color\$,blue)]
    set fx_colorconfig(current_name) $default
    frame $c.top -relief groove -bd 4
    pack $c.top -side top -fill x
    set c $c.top

    frame $c.scales -relief groove -bd 4
    pack $c.scales -side left -expand on -fill both
    label $c.scales.l -width 40 -height 2 -bg \#$fx_colorconfig(current)
    pack $c.scales.l -side top -fill x
    set interval 50
    scale $c.scales.red -from 0 -to 255 -showvalue 1 -tickinterval $interval -label Red -orient horiz \
	    -variable fx_colorconfig(\$color\$,red) -command [list Fx:SelectColorCommand $c.scales.l]
    pack $c.scales.red -side top -expand on -fill x
    scale $c.scales.green -from 0 -to 255 -showvalue 1 -tickinterval $interval -label Green -orient horiz \
	    -variable fx_colorconfig(\$color\$,green) -command [list Fx:SelectColorCommand $c.scales.l]
    pack $c.scales.green -side top -expand on -fill x
    scale $c.scales.blue -from 0 -to 255 -showvalue 1 -tickinterval $interval -label Blue -orient horiz \
	    -variable fx_colorconfig(\$color\$,blue) -command [list Fx:SelectColorCommand $c.scales.l]
    pack $c.scales.blue -side top -expand on -fill x

    frame $c.list -relief groove -bd 4
    pack $c.list -side left -expand on -fill both

    label $c.list.l -relief ridge -bd 4 -text "Symbolic Color Names"
    pack $c.list.l -side top -fill x
    scrollbar $c.list.s -relief sunken -command [list $c.list.lb yview] -takefocus 0
    pack $c.list.s -side right -fill y
    listbox $c.list.lb -relief sunken -width 20 -yscroll [list $c.list.s set]
    pack $c.list.lb -side left -expand on -fill both
    eval $c.list.lb insert 0 $fx_colornames
    $c.list.lb activate 0

    bind $c.list.lb <ButtonRelease-1> "Fx:SelectSetColor $c.list.lb $c.scales.l"
    bind $c.list.lb <Return> "Fx:SelectSetColor $c.list.lb $c.scales.l"
    bindtags $c.list.lb [list Listbox $c.list.lb . all]    

    set c .color_select

    frame $c.bot -relief groove -bd 4
    pack $c.bot -side bottom -fill x -ipady 2m -ipadx 4m
    button $c.bot.ok -text Ok -command {
	catch {destroy .color_select}
    }
    button $c.bot.cancel -text Cancel -command {
	catch {destroy .color_select}
	catch {unset fx_colorconfig}
    }
    pack $c.bot.ok -side left -padx 4m -pady 2m
    pack $c.bot.cancel -side left -padx 4m -pady 2m
    Fx:SetGeometry $c
    wm deiconify $c
    update idletasks
    fx_bindposition $c
    wm minsize $c [winfo reqwidth $c] [winfo reqheight $c]
    wm maxsize $c [winfo reqwidth $c] [winfo reqheight $c]
    tkwait window .color_select
}


if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_colors.tcl"
}
