
# The contents of this file largely come from the BLT 2.1
# distribution.    Modified for Qddb.

proc Fx:Blt_ActiveLegend {graph} {
    global fx_bltActiveEntry

    set fx_bltActiveEntry($graph) "-1"
    bind fx_bltActiveLegend <Motion>  {
	Fx:BltActivateLegend %W %x %y
    }    
    Fx:BltAddBindTag $graph fx_bltActiveLegend 
}

proc Fx:Blt_CrosshairSet {graph var idx} {
    global $var

    if {[set ${var}($idx)]} {
	Fx:BltAddBindTag $graph fx_bltCrosshairs
	$graph crosshairs on
    } else {
	$graph crosshairs off
    }
}

proc Fx:Blt_Crosshairs {graph var idx} {
    bind fx_bltCrosshairs <Any-Motion>   {
	%W crosshairs configure -position @%x,%y 
    }
    $graph crosshairs configure -color red
    bind $graph <Enter> [list Fx:Blt_CrosshairSet $graph $var $idx]
    bind $graph <Leave> [format {
	Fx:BltRemoveBindTag %s fx_bltCrosshairs
	%s crosshairs off
    } $graph $graph]
}

proc Fx:Blt_ZoomStack {graph var idx} {
    global fx_bltZoom

    set fx_bltZoom($graph,A,x) {}
    set fx_bltZoom($graph,A,y) {}
    set fx_bltZoom($graph,B,x) {}
    set fx_bltZoom($graph,B,y) {}
    set fx_bltZoom($graph,stack) {}
    set fx_bltZoom($graph,corner) A

    bind $graph <ButtonPress-1> [list Fx:BltSetZoomPoint %W %x %y $var $idx]
    bind $graph <ButtonPress-3> [list Fx:BltResetZoom %W]
}

proc Fx:Blt_ClosestPoint {graph} {
    bind fx_bltClosestPoint <Control-ButtonPress-1>  {
	Fx:BltFindElement %W %x %y
	break
    }
    Fx:BltAddBindTag $graph fx_bltClosestPoint 
}

proc Fx:Blt_RaiseElement {graph x y where} {
    if {![$graph element closest $x $y info -interpolate 1]} {
	bell
	return
    }
    set show [$graph element show]
    set idx [lsearch -exact $show $info(name)]
    set show [lreplace $show $idx $idx]
    set show [linsert $show $where $info(name)]
    $graph element show $show
}

proc Fx:Blt_BindRaiseElements {graph} {
    bind fx_bltRaiseElement <Control-ButtonPress-3> {
	Fx:Blt_RaiseElement %W %x %y 0
	break
    }
    bind fx_bltRaiseElement <Control-ButtonPress-1> {
	Fx:Blt_RaiseElement %W %x %y end
	break
    }
    Fx:BltAddBindTag $graph fx_bltRaiseElement
}

proc Fx:BltAddBindTag {graph name} {
    set oldtags [bindtags $graph]
    if {[lsearch $oldtags $name] < 0} {
	bindtags $graph [concat $name $oldtags]
    }
}

proc Fx:BltRemoveBindTag {graph name} {
    set tagList {}
    foreach tag [bindtags $graph] {
	if {$tag != $name} {
	    lappend tagList $tag
	}
    }
    bindtags $graph $tagList
}

proc Fx:BltActivateLegend {graph x y} {
    global fx_bltActiveEntry

    set old $fx_bltActiveEntry($graph)
    set new [$graph legend get @$x,$y]
    if {$old != $new} {
	if {$old != "-1"} {
	    $graph legend deactivate $old
	    $graph element deactivate $old
	}
	if {$new != ""} {
	    $graph legend activate $new
	    $graph element activate $new
	}
    }
    set fx_bltActiveEntry($graph) $new
}

proc Fx:BltFindElement {graph x y} {
    if {![$graph element closest $x $y info -interpolate 1]} {
	bell
	return
    }
    # --------------------------------------------------------------
    # find(name)		- element Id
    # find(index)		- index of closest point
    # find(x) find(y)		- coordinates of closest point
    #				  or closest point on line segment.
    # find(dist)		- distance from sample coordinate
    # --------------------------------------------------------------
    set markerName "fx_bltClosest_$info(name)"
    $graph marker delete $markerName
    $graph marker create text -coords {$info(x) $info(y)} \
	-name $markerName \
	-text "$info(name): [format "%.2f" $info(dist)]\nindex $info(index)" \
	-font *lucida*-r-*-10-* \
	-anchor center -justify left \
	-yoffset 0 -bg {}
    Fx:BltFlashPoint $graph $info(name) $info(index) 10
}

proc Fx:BltFlashPoint {graph name index count} {
    if {$count & 1} {
        $graph element deactivate $name 
    } else {
        $graph element activate $name $index
    }
    incr count -1
    if {$count > 0} {
	after 200 Fx:BltFlashPoint $graph $name $index $count
	update
    } else {
	$graph marker delete "fx_bltClosest_*"
    }
}

proc Fx:BltGetCoords {graph x y index} {
    global fx_bltZoom

    set coords [$graph invtransform $x $y]
    set x [lindex $coords 0]
    set y [lindex $coords 1]
    scan [$graph xaxis limits] "%s %s" xmin xmax
    scan [$graph yaxis limits] "%s %s" ymin ymax
    if {$x > $xmax} {
	set x $xmax 
    } elseif {$x < $xmin} {
	set x $xmin 
    }
    if {$y > $ymax} {
	set y $ymax 
    } elseif {$y < $ymin} {
	set y $ymin 
    }
    set fx_bltZoom($graph,$index,x) $x
    set fx_bltZoom($graph,$index,y) $y
}

proc Fx:BltMarkPoint {graph index} {
    global fx_bltZoom

    set x $fx_bltZoom($graph,$index,x)
    set y $fx_bltZoom($graph,$index,y)
    set marker "fx_bltZoom_text_$index"
    set text [format "x=%.4g\ny=%.4g" $x $y] 

    if {[$graph marker exists $marker]} {
     	$graph marker configure $marker -coords { $x $y } -text $text 
    } else {
    	$graph marker create text -coords { $x $y } -name $marker \
   	    -font *lucida*-r-*-10-* \
	    -text $text -anchor center -bg {} -justify left
    }
}

proc Fx:BltPopZoom {graph {do_cmd 1}} {
    global fx_bltZoom

    set zoomStack $fx_bltZoom($graph,stack)
    if {[llength $zoomStack] > 0} {
	set cmd [lindex $zoomStack 0]
	set fx_bltZoom($graph,stack) [lrange $zoomStack 1 end]
	eval $cmd
	if {$do_cmd} {
	    Fx:BltZoomTitleLast $graph
	    blt::busy hold $graph
	    update
	    set cmd [format {
		if {$fx_bltZoom(%s,corner) == "A"} {
		    %s marker delete "fx_bltZoom_title"
		}
	    } $graph $graph]
	    after 2000 $cmd
	    blt::busy release $graph
	}
    } else {
	$graph marker delete "fx_bltZoom_title"
    }
}

# Push the old axis limits on the stack and set the new ones

proc Fx:BltPushZoom { graph } {
    global fx_bltZoom

    $graph marker delete "fx_bltZoom_*" 
    set x1 $fx_bltZoom($graph,A,x)
    set y1 $fx_bltZoom($graph,A,y)
    set x2 $fx_bltZoom($graph,B,x)
    set y2 $fx_bltZoom($graph,B,y)

    if {($x1 == $x2) && ($y1 == $y2)} {
	# No delta, revert to start
	return
    }

    set cmd [format {
	%s xaxis configure -min "%s" -max "%s"
	%s yaxis configure -min "%s" -max "%s"
    } $graph [$graph xaxis cget -min] [$graph xaxis cget -max] \
		 $graph [$graph yaxis cget -min] [$graph yaxis cget -max] ]

    if {$x1 > $x2} {
	$graph xaxis configure -min $x2 -max $x1 
    } elseif {$x1 < $x2} {
	$graph xaxis configure -min $x1 -max $x2
    } 
    if {$y1 > $y2} {
	$graph yaxis configure -min $y2 -max $y1
    } elseif {$y1 < $y2} {
	$graph yaxis configure -min $y1 -max $y2
    } 
    set fx_bltZoom($graph,stack) [linsert $fx_bltZoom($graph,stack) 0 $cmd]

    blt::busy hold $graph
    update
    blt::busy release $graph
}

proc Fx:BltResetAllZoom {graph} {
    global fx_bltZoom

    set fx_bltZoom($graph,stack) [lrange $fx_bltZoom($graph,stack) end end]
    Fx:BltPopZoom $graph 0
}

proc Fx:BltResetZoom {graph} {
    global fx_bltZoom

    $graph marker delete "fx_bltZoom_*" 
    if {$fx_bltZoom($graph,corner) == "A"} {
	# Reset the whole axis
	Fx:BltPopZoom $graph
    } else {
	set fx_bltZoom($graph,corner) A
	bind $graph <Motion> { }
    }
}

proc Fx:BltZoomTitleNext {graph} {
    global fx_bltZoom

    set level [expr [llength $fx_bltZoom($graph,stack)] + 1]
    set title "Zoom #$level"
    $graph marker create text -name "fx_bltZoom_title" -text $title \
	    -coords {-Inf Inf} -anchor nw -bg {} 
}

proc Fx:BltZoomTitleLast {graph} {
    global fx_bltZoom

    set level [llength $fx_bltZoom($graph,stack)]
    if {$level > 0} {
	set title "Zoom #$level"
     	$graph marker create text -name "fx_bltZoom_title" -text $title \
		-coords {-Inf Inf} -anchor nw -bg {} 
    }
}

proc Fx:BltSetZoomPoint {graph x y var idx} {
    global fx_bltZoom $var

    if {![set ${var}($idx)]} {return}
    Fx:BltGetCoords $graph $x $y $fx_bltZoom($graph,corner)
    if {$fx_bltZoom($graph,corner) == "A"} {
	# First corner selected, start watching motion events
	Fx:BltZoomTitleNext $graph 
	bind $graph <Any-Motion> { 
	    Fx:BltGetCoords %W %x %y B
	    Fx:BltBox %W
	}
	set fx_bltZoom($graph,corner) B
    } else {
	bind $graph <Any-Motion> { }
	Fx:BltPushZoom $graph 
	set fx_bltZoom($graph,corner) A
    }
}

proc Fx:BltBox {graph} {
    global fx_bltZoom

    if {$fx_bltZoom($graph,A,x) > $fx_bltZoom($graph,B,x)} { 
	set x1 $fx_bltZoom($graph,B,x)
	set x2 $fx_bltZoom($graph,A,x) 
	set y1 $fx_bltZoom($graph,B,y)
	set y2 $fx_bltZoom($graph,A,y) 
    } else {
	set x1 $fx_bltZoom($graph,A,x)
	set x2 $fx_bltZoom($graph,B,x) 
	set y1 $fx_bltZoom($graph,A,y)
	set y2 $fx_bltZoom($graph,B,y) 
    }
    set coords {
	$x1 $y1 $x1 $y2 $x1 $y1 $x2 $y1 $x2 $y1 $x2 $y2 $x1 $y2 $x2 $y2 
    }
    if {[$graph marker exists "fx_bltZoom_outline"]} {
	$graph marker configure "fx_bltZoom_outline" -coords $coords
    } else {
	$graph marker create line -coords $coords -name "fx_bltZoom_outline" \
	    -dashes {4 2}
    }
    $graph marker before "fx_bltZoom_outline"
}


