
proc fx_bindposition {w} {
    bind $w <Configure> {
	if {[string compare [winfo toplevel %W] %W] == 0} {
	    Fx:SavePosition %W
	}
    }
}

proc fx_bindgeom {w} {
    bind $w <Configure> {
	if {[string compare [winfo toplevel %W] %W] == 0} {
	    Fx:SaveGeometry %W
	}
    }
}

proc fx_bindnull {w} {
    foreach i [bind Entry] {
	bind $w $i {# nothing}
    }
}


proc fx_bindnotnull {w var} {
    bind $w <FocusOut> "
        if \"\[string length \[set $var\]\] == 0\" \"focus $w; bell\"
    "
}

proc fx_bindpixels {w} {
    fx_bindnull $w
    bind $w <KeyPress> {
	if {[fx_checkpixels %W %A]} {break}
    }
}

proc fx_bindreal {w} {
    fx_bindnull $w
    bind $w <KeyPress> {
	if {[fx_checkreal %W %A]} {break}
    }
}

proc fx_bindrealrange {w from to} {
    fx_bindnull $w
    set tmp "fx_checkrealrange %W %A $from $to"
    set tmp "\[$tmp\]"
    bind $w <KeyPress> "if $tmp {break}"
}

proc fx_bindint {w} {
    fx_bindnull $w
    bind $w <KeyPress> {
	if {[fx_checkint %W %A]} {break}
    }
}

proc fx_bindintrange {w from to} {
    fx_bindnull $w
    set tmp "fx_checkintrange %W %A $from $to"
    set tmp "\[$tmp\]"
    bind $w <KeyPress> "if $tmp {break}"
}

proc fx_checkpixels {w s} {
    if {$s == ""} {return 0}
    set ns [$w get]
    set ins [$w index insert]
    set ns "[string range $ns 0 $ins]$s[string range $ns [expr $ins + 1] end]"
    if {[catch "winfo fpixels $w $ns"] != 0} {
	bell
	return 1
    }
    return 0
}  

proc fx_checkreal {w s} {
    if {$s == ""} {return 0}
    set ns [$w get]
    set ins [$w index insert]
    set ns "[string range $ns 0 $ins]$s[string range $ns [expr $ins + 1] end]"
    if {$ns == "-"} {return 0}
    if {[catch "expr double($ns)"] != 0} {
	bell
	return 1
    }
    return 0
}  

proc fx_checkrealrange {w s from to} {
    if {$s == ""} {return 0}
    set ns [$w get]
    set ins [$w index insert]
    set ns "[string range $ns 0 $ins]$s[string range $ns [expr $ins + 1] end]"
    if {$ns == "-"} {return 0}
    if {[catch "expr double($ns)"] != 0} {
	bell; return 1
    }
    if {$ns < $from || $ns > $to} {
	bell; return 1
    }
    return 0
}  

proc fx_checkint {w s} {
    if {$s == ""} {return 0}
    set ns [$w get]
    set ins [$w index insert]
    set ns "[string range $ns 0 $ins]$s[string range $ns [expr $ins + 1] end]"
    if {$ns == "-"} {return 0}
    if {[catch "expr int($ns)"] != 0} {
	bell
	return 1
    }
    return 0
}  

proc fx_checkintrange {w s from to} {
    if {$s == ""} {return 0}
    set ns [$w get]
    set ins [$w index insert]
    set ns "[string range $ns 0 $ins]$s[string range $ns [expr $ins + 1] end]"
    if {$ns == "-"} {return 0}
    if {[catch "expr int($ns)"] != 0} {
	bell
	return 1
    }
    if {$ns < $from || $ns > $to} {
	bell; return 1
    }
    return 0
}  

proc fxEntryShowCursor {w p} {
    set insert [$w index $p]
    set left [$w index @0]
    if {$left > $insert} {
	$w xview $insert
	return
    }
    set x [winfo width $w]
    set right [$w index @$x]
    incr right -1
    if {$right < $insert} {
	while {$right < $insert} {
	    incr left
	    incr right
	}                                                                         
	$w xview $left
    }
}

proc fxEntrySetCursor {w p} {
    $w icursor $p
    $w selection clear
    fxEntryShowCursor $w $p
}

proc fx_textCut w {
    set q [winfo command $w]
    if {[selection own -displayof $w] == "$w"} {
	clipboard clear -displayof $w
	catch {
	    clipboard append -displayof $w [selection get -displayof $w]
	    $q delete sel.first sel.last
	}
    }
}

proc fx_textPaste w {
    set q [winfo command $w]
    catch {
	$q insert insert [selection get -displayof $w -selection CLIPBOARD]
    }
}

set fx_khack 0

proc Fx:Bindings {} {
    global tk_version

    bind Text <Any-KeyPress> {+
	if {"%A" != "{}"} {
	    set fx_thack(%W) ""
	}
	set fx_khack 0
    }
    bind Text <Control-o> {+
	set fx_thack(%W) ""
	set fx_khack 0
    }
    bind Text <Control-d> {+
	set fx_thack(%W) ""
	set fx_khack 0
    }
    bind Text <Control-h> {+
	set fx_thack(%W) ""
	set fx_khack 0
    }
    bind Text <BackSpace> {+
	set fx_thack(%W) ""
	set fx_khack 0
    }
    bind Text <Key-Delete> {+
        set fx_thack(%W) ""
	set fx_khack 0
    }
    bind Text <Control-x> {+
        set fx_thack(%W) ""
	set fx_khack 0
    }
    bind Text <Control-t> {+
        set fx_thack(%W) ""
	set fx_khack 0
    }
    bind Text <Control-k> {
	if [%W compare insert == {insert lineend}] {
	    clipboard append "\n"
	    %W delete insert
	} elseif [%W compare insert == {insert linestart}] {
	    if {$fx_khack == 0} {
		clipboard clear
	    }
	    clipboard append [%W get insert {insert lineend}]
	    %W delete insert {insert lineend}
	} else {
	    clipboard clear
	    clipboard append [%W get insert {insert lineend}]
	    %W delete insert {insert lineend}
	}
	set fx_thack(%W) ""
	set fx_khack 1
    }
    bind Text <Control-u> {
	%W delete {insert linestart} {insert lineend}
	clipboard clear
	clipboard append [%W get insert {insert lineend}]
	set fx_khack 0
    }
    bind Text <ButtonRelease-2> {+
	set fx_thack(%W) ""
	set fx_khack 0
    }
    if {$tk_version >= 4.2} {
	bind Text <<Cut>> {+
            set fx_thack(%W) ""
 	    set fx_khack 0
        }
	bind Text <<Paste>> {+
            set fx_thack(%W) ""
	    set fx_khack 0
        }
	event add <<Cut>> <Control-Key-w>
	event add <<Copy>> <Alt-Key-w> 
	event add <<Paste>> <Control-Key-y>
    }

    # Tk4.1 changed this, change it back!
    bind Entry <FocusIn> {
	%W icursor end
    }
    bind Entry <Control-e> {
	fxEntrySetCursor %W end
    }
    bind Entry <End> [bind Entry <Control-e>]
    bind Entry <Control-f> {
	fxEntrySetCursor %W [expr [%q index insert] + 1]
    }
    bind Entry <Right> [bind Entry <Control-f>]
    bind Entry <Control-k> {
	set t [string range [%W get] [%W index insert] [%W index end]]
	%W delete insert end
        clipboard clear
	clipboard append $t
    }
    bind Entry <Down> {focus [tk_focusNext %W]}
    bind Entry <Up> {focus [tk_focusPrev %W]}
    bind Entry <Control-n> {focus [tk_focusNext %W]}
    bind Entry <Control-p> {focus [tk_focusPrev %W]}
    bind Entry <Control-u> {%W delete 0 end}

    bind Button <Down> {focus [tk_focusNext %W]}
    bind Button <Up> {focus [tk_focusPrev %W]}
    bind Button <Control-n> {focus [tk_focusNext %W]}
    bind Button <Control-p> {focus [tk_focusPrev %W]}
    bind Button <Return> [bind Button <space>]

    bind Radiobutton <Down> {focus [tk_focusNext %W]}
    bind Radiobutton <Up> {focus [tk_focusPrev %W]}
    bind Radiobutton <Control-n> {focus [tk_focusNext %W]}
    bind Radiobutton <Control-p> {focus [tk_focusPrev %W]}

    bind Checkbutton <Down> {focus [tk_focusNext %W]}
    bind Checkbutton <Up> {focus [tk_focusPrev %W]}
    bind Checkbutton <Control-n> {focus [tk_focusNext %W]}
    bind Checkbutton <Control-p> {focus [tk_focusPrev %W]}

    bind Scrollbar <Control-n> {focus [tk_focusNext %W]}
    bind Scrollbar <Control-p> {focus [tk_focusPrev %W]}

    bind Text <Tab> {focus [tk_focusNext %W]}
    bind Text <Shift-Tab> {focus [tk_focusPrev %W]}
}
if {[info exists fx_debug] && $fx_debug == 1} {
    puts "auto-loaded fx_bind.tcl"
}
