
# Generic barchart routines

if {$fx_blt} {
    blt::bitmap define fx_solid {{4 4} {ff ff ff ff}}
    blt::bitmap define fx_stipple1 {{4 4} {01 02 04 08}}
    blt::bitmap define fx_stipple2 {{4 4} {08 04 02 01}}
    blt::bitmap define fx_stipple3 {{2 2} {01 02}}
    blt::bitmap define fx_stipple4 {{4 4} {0f 00 00 00}}
    blt::bitmap define fx_stipple5 {{4 4} {01 01 01 01}}
    blt::bitmap define fx_stipple6 {{2 2} {01 00}}
    blt::bitmap define fx_stipple7 {{4 4} {0f 01 01 01}}
    blt::bitmap define fx_stipple8 {{8 8} {ff 00 ff 00 ff 00 ff 00}}
    blt::bitmap define fx_stipple9 {{4 4} {03 03 0c 0c}}
    blt::bitmap define fx_stipple_active {{4 4} {00 ff 00 ff}}
}

proc Fx:Barchart_SetColor {top w var idx} {
    global fx_colorconfig $var

    if {[info exists ${var}($idx)]} {
	Fx:BusyExec .fx_barchartsetup [list Fx:SelectColor $top [set ${var}($idx)]]
    } else {
	Fx:BusyExec .fx_barchartsetup [list Fx:SelectColor $top]
    }
    if {[info exists fx_colorconfig(current)]} {
	set ${var}($idx) $fx_colorconfig(current)
	$w configure -bg \#$fx_colorconfig(current)
    }
}

proc Fx:Barchart_ClearAxis {axis {l ""} {force 0}} {
    global fx_tmp_barchartsetup

    if {$force || ![info exists fx_tmp_barchartsetup(${axis})]} {
	set fx_tmp_barchartsetup(${axis}) ""
    }
    if {$force || ![info exists fx_tmp_barchartsetup(${axis}_color)]} {
	set fx_tmp_barchartsetup(${axis}_color) 000000
    }
    if {$force || ![info exists fx_tmp_barchartsetup(${axis}_label)]} {
	set fx_tmp_barchartsetup(${axis}_label) ""
    }
    if {[string length $l] > 0 && [winfo exists $l]} {
	$l configure -bg \#$fx_tmp_barchartsetup(${axis}_color)
    }
    if {$force || ![info exists fx_tmp_barchartsetup(${axis},linewidth)]} {
	set fx_tmp_barchartsetup(${axis},linewidth) 1
    }
    if {$force || ![info exists fx_tmp_barchartsetup(${axis},showticks)]} {
	set fx_tmp_barchartsetup(${axis},showticks) 1
    }
    if {$force || ![info exists fx_tmp_barchartsetup(${axis},subdivisions)]} {
	set fx_tmp_barchartsetup(${axis},subdivisions) 2
    }
    if {$force || ![info exists fx_tmp_barchartsetup(${axis},ticklength)]} {
	set fx_tmp_barchartsetup(${axis},ticklength) 0.1i
    }
    if {$force || ![info exists fx_tmp_barchartsetup(${axis},stepsize)]} {
	set fx_tmp_barchartsetup(${axis},stepsize) 0
    }
}

proc Fx:Barchart_TypeFunc {type} {
    global fx_tmp_barchartsetup fx_barchart_typefunc ;# range format datestuff

    set range [lindex $fx_barchart_typefunc 0]
    set format [lindex $fx_barchart_typefunc 1]
    set datestuff [lindex $fx_barchart_typefunc 2]
    set fx_tmp_barchartsetup(daterange_type) "User-defined"
    $range configure -state normal
    $format configure -state normal
    $range delete 0 end
    $format delete 0 end
    if {[string compare $type date] == 0} {
	pack $datestuff -side left -expand off -fill x
    } else {
	set fx_tmp_barchartsetup(daterange_type) "User-defined"
	pack forget $datestuff
    }
}

proc Fx:Barchart_BuildAxis {top f schema axis} {
    global fx_rconfig fx_report fx_barchartsetup fx_tmp_barchartsetup qddb_library \
	    fx_barchart_typefunc fx_barchart_frame

    Fx:Barchart_ClearAxis $axis ""
    label $f.l -text "[string toupper ${axis}]-axis Configuration"
    pack $f.l -side top -expand on -fill x -pady 3m
    set fx $f.f0
    frame $fx
    pack $fx -side top -expand on -fill x -padx 2m
    label $fx.l0 -text "Attribute:"
    pack $fx.l0 -side left
    set valid_list [Fx:CheckNumericSearch $schema fx_tmp_barchartsetup $axis]
    if {[llength $valid_list] == 0} {
	fx_dialog $f.dialog \
		"No fields specified" "You must specify fields before barcharting!" \
		error 0 Ok	
	return
    }
    set found [lindex $valid_list 3]
    if {$found} {
	set fx_tmp_barchartsetup(${axis}_type) [lindex $valid_list 2]
    } else {
	set fx_tmp_barchartsetup(${axis}_label) [lindex $valid_list 0]
	set fx_tmp_barchartsetup($axis) [lindex $valid_list 1]
    }
    if {[string compare $axis x] == 0} {
	button $fx.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:DisplayNumericSearch $top $fx.b $schema fx_tmp_barchartsetup $axis \
		fx_tmp_barchartsetup ${axis}_label Fx:Barchart_TypeFunc]
    } else {
	button $fx.b -bitmap @$qddb_library/fx/pixmaps/down.xbm \
		-command [list Fx:DisplayNumericSearch $top $fx.b $schema fx_tmp_barchartsetup $axis \
		fx_tmp_barchartsetup ${axis}_label]
    }
    pack $fx.b -side left
    entry $fx.e -textvariable fx_tmp_barchartsetup($axis) -width 30 -state disabled
    pack $fx.e -side left
    checkbutton $fx.descending -text "Descending" \
	    -variable fx_tmp_barchartsetup(${axis},descending)
    pack $fx.descending -side left -padx 5m
    button $fx.color -text "Color" -padx 0m -pady 0m -command \
	    [list after idle "Fx:Barchart_SetColor $top $fx.l3 fx_tmp_barchartsetup ${axis}_color"]
    pack $fx.color -side left
    label $fx.l3 -width 3 -relief groove
    pack $fx.l3 -side left
    set f1 $f.f1
    frame $f1
    pack $f1 -side top -expand on -fill x -padx 2m
    label $f1.l2 -text "Title:" -anchor e
    pack $f1.l2 -side left
    entry $f1.e2 -textvariable fx_tmp_barchartsetup(${axis}_label) -width 20
    pack $f1.e2 -side left
    button $f1.b -text "Title font" -command [list Fx:BusyExec $top \
	    [list Fx:FontButton $f1.b fx_tmp_barchartsetup ${axis},titlefont]]
    pack $f1.b -side left
    if {![info exists fx_tmp_barchartsetup(${axis},titlefont)]} {
	set fx_tmp_barchartsetup(${axis},titlefont) "-*-courier-bold-r-*-*-*-100-*-*-*-*-*-*"
    }
    catch [list $f1.b configure -font $fx_tmp_barchartsetup(${axis},titlefont)]
    button $f1.b1 -text "Tick font" -command [list Fx:BusyExec $top \
	    [list Fx:FontButton $f1.b1 fx_tmp_barchartsetup ${axis},tickfont]]
    pack $f1.b1 -side left
    if {![info exists fx_tmp_barchartsetup(${axis},tickfont)]} {
	set fx_tmp_barchartsetup(${axis},tickfont) "-*-courier-bold-r-*-*-*-100-*-*-*-*-*-*"
    }
    catch [list $f1.b1 configure -font $fx_tmp_barchartsetup(${axis},tickfont)]
    pack $f1.b1 -side left
    if {[string compare $axis x] == 0} {
	checkbutton $f1.check -text "Range analysis" -variable fx_tmp_barchartsetup(range_analysis)
	pack $f1.check -side left
	set f4 $f.f4
	set fx_barchart_frame $f4
	frame $f4
	pack $f4 -side top -expand on -fill x -padx 2m
	label $f4.lrange -text "Range:"
	pack $f4.lrange -side left
	entry $f4.range -textvariable fx_tmp_barchartsetup(range) -width 10
	pack $f4.range -side left
	label $f4.lformat -text "Format:"
	pack $f4.lformat -side left
	entry $f4.format -textvariable fx_tmp_barchartsetup(format) -width 10
	pack $f4.format -side left
	if {![info exists fx_tmp_barchartsetup(function)]} {
	    set fx_tmp_barchartsetup(function) sum
	}
	label $f4.l -width 7 -textvariable fx_tmp_barchartsetup(function) -relief raised -bd 2
	pack $f4.l -side left
	bind $f4.l <Button-1> [list eval tk_popup $f4.l_menu \
		{[expr [winfo rootx %W]]} {[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $f4.l_menu -tearoff 0
	foreach j {sum avg stddev min max count prod} {
	    $f4.l_menu add command -label $j -command "set fx_tmp_barchartsetup(function) $j"
	}
	if {![info exists fx_tmp_barchartsetup(daterange_type)]} {
	    set fx_tmp_barchartsetup(daterange_type) "User-defined"
	}
	if {[string compare $fx_tmp_barchartsetup(daterange_type) "User-defined"] != 0} {
	    $f4.range configure -state disabled
	    $f4.format configure -state disabled
	}
	set fx_barchart_typefunc [list $f4.range $f4.format $f4.l1]
	label $f4.l1 -textvariable fx_tmp_barchartsetup(daterange_type) \
		-relief raised -bd 2 -width 26
	pack $f4.l1 -side left -expand off -fill x
	if {[info exists fx_tmp_barchartsetup(${axis}_type)]} {
	    if {[string compare $fx_tmp_barchartsetup(${axis}_type) date] != 0} {
		pack forget $f4.l1
	    }
	}
	bind $f4.l1 <Button-1> [list eval tk_popup $f4.l1_menu \
		{[expr [winfo rootx %W]]} {[expr [winfo rooty %W] + [winfo height %W]]}]
	menu $f4.l1_menu -tearoff 0
	set ranges {
	    {"User-defined" "" ""}
	    {"Full date" %y/%m/%d %x}
	    {"Year" %Y %Y}
	    {"Month of year (3-letter)" %m %b}
	    {"Month of year (full name)" %m %B}
	    {"Week of year" %W %W}
	    {"Day of year" %j %j}
	    {"Day of month" %d %d}
	    {"Day of week (3-letter)" %w %a}
	    {"Day of week (full name)" %w %A}
	    {"Hour of day" %H %H}
	    {"Hour/minute of day" %H:%M %H:%M}
	}
	foreach i $ranges {
	    $f4.l1_menu add command -label [lindex $i 0] -command "
	        set fx_tmp_barchartsetup(daterange_type) [list [string range [lindex $i 0] 0 24]]
	        set fx_tmp_barchartsetup(range) [lindex $i 1]
	        set fx_tmp_barchartsetup(format) [lindex $i 2]
   	        if {[string length [lindex $i 1]] == 0} {
		    $f4.range configure -state normal
		    $f4.format configure -state normal
		    after idle [list focus $f4.range]
		} else {
		    if {\[string compare \[focus\] $f4.range\] == 0 || \
			    \[string compare \[focus\] $f4.format\] == 0} {
			after idle [list focus $f]
		    }
		    $f4.range configure -state disabled
		    $f4.format configure -state disabled
		}
	    "
	}
    }

    set f2 $f.f2
    frame $f2
    pack $f2 -side top -expand on -fill x -padx 2m
    label $f2.l -text "Tick width:"
    pack $f2.l -side left
    entry $f2.e -textvariable fx_tmp_barchartsetup(${axis},linewidth) -width 2
    pack $f2.e -side left
    fx_bindint $f2.e

    label $f2.l2 -text "Rotate label:" 
    pack $f2.l2 -side left
    entry $f2.e2 -textvariable fx_tmp_barchartsetup(${axis},rotate) -width 3
    pack $f2.e2 -side left
    fx_bindreal $f2.e2
    checkbutton $f2.ls -text "Log scale" \
	    -variable fx_tmp_barchartsetup(${axis},logscale)
    pack $f2.ls -side left -padx 1m
    checkbutton $f2.lf -text "Loose fit" \
	    -variable fx_tmp_barchartsetup(${axis},loosefit)
    pack $f2.lf -side left -padx 1m
    checkbutton $f2.st -text "Show ticks" \
	    -variable fx_tmp_barchartsetup(${axis},showticks)
    pack $f2.st -side left -padx 1m
    set f3 $f.f3
    frame $f3
    pack $f3 -side top -expand on -fill x -padx 2m
    label $f3.l -text "Tick subdivisions:"
    pack $f3.l -side left
    entry $f3.e -textvariable fx_tmp_barchartsetup(${axis},subdivisions) -width 3
    pack $f3.e -side left
    fx_bindint $f3.e
    label $f3.l2 -text "Major tick length:"
    pack $f3.l2 -side left -padx 1m
    entry $f3.e2 -textvariable fx_tmp_barchartsetup(${axis},ticklength) -width 5
    pack $f3.e2 -side left
    fx_bindpixels $f3.e2
    label $f3.l4 -text "Step size:"
    pack $f3.l4 -side left -padx 1m
    entry $f3.e3 -textvariable fx_tmp_barchartsetup(${axis},stepsize) -width 5
    pack $f3.e3 -side left
    fx_bindpixels $f3.e3
    set fx_tmp_barchartsetup($axis,colorlabel) $fx.l3
    Fx:Barchart_ClearAxis $axis $fx.l3
}

proc Fx:Barchart_ColorTrace {w color {name1 ""} {name2 ""} {op ""}} {
    global $name1

    if {![winfo exists .fx_barchartsetup]} {
	return
    }
    if {[string compare $op u] == 0} {
	set ${name1}($name2) $color
	trace variable ${name1}($name2) wu [list Fx:Barchart_ColorTrace $w $color]
    }
    catch "$w configure -bg \#[set ${name1}($name2)]"
}

proc Fx:Barchart_BuildLine {top w i num} {
    global fx_rconfig fx_report fx_tmp_barchartsetup

    set f $w.f$num
    frame $f
    pack $f -side top -expand on -fill x
    label $f.l -width 3 -text "$num" -anchor e
    pack $f.l -side left
    label $f.l0 -text "Legend:"
    pack $f.l0 -side left
    entry $f.e -width 10 -textvariable fx_tmp_barchartsetup($i)
    pack $f.e -side left
    button $f.fore -text "Color" -padx 0m -pady 0m -command \
	    [list after idle "Fx:Barchart_SetColor $top $f.l1 fx_tmp_barchartsetup $i,foreground"]
    pack $f.fore -side left
    if {![info exists fx_tmp_barchartsetup($i,foreground)]} {
	set fx_tmp_barchartsetup($i,foreground) 000000
    }
    label $f.l1 -width 3 -relief groove -bd 2 -bg \#$fx_tmp_barchartsetup($i,foreground)
    pack $f.l1 -side left
    trace variable fx_tmp_barchartsetup($i,foreground) wu [list Fx:Barchart_ColorTrace $f.l1 000000]
    label $f.l3 -text "Width:"
    pack $f.l3 -side left
    entry $f.e2 -width 2 -textvariable fx_tmp_barchartsetup($i,barwidth)
    pack $f.e2 -side left
    fx_bindpixels $f.e2
    label $f.l5 -text "Stipple:"
    pack $f.l5 -side left
    if {![info exists fx_tmp_barchartsetup($i,stipple)]} {
	set fx_tmp_barchartsetup($i,stipple) solid
    }
    label $f.l6 -width 9 -textvariable fx_tmp_barchartsetup($i,stipple) -relief raised -bd 2
    pack $f.l6 -side left
    bind $f.l6 <Button-1> [list eval tk_popup $f.l6_menu \
	    {[expr [winfo rootx %W]]} {[expr [winfo rooty %W] + [winfo height %W]]}]
    menu $f.l6_menu -tearoff 0
    foreach j {solid stipple1 stipple2 stipple3 stipple4 stipple5 stipple6 stipple7 stipple8 stipple9} {
	$f.l6_menu add command -label $j -command "set fx_tmp_barchartsetup($i,stipple) $j"
    }
    checkbutton $f.show -text "Show" -variable fx_tmp_barchartsetup($i,mapped)
    pack $f.show -side left
}

proc Fx:Barchart_BuildLines {top w} {
    global fx_rconfig fx_report fx_tmp_barchartsetup

    set nums {}
    foreach i [lsort -ascii [array names fx_report expert_search_title,*]] {
	set found 0
	foreach j [array names fx_tmp_barchartsetup expert_search_title,*] {
	    if {[string compare $i $j] == 0} {
		set found 1
		break
	    }
	}
	set num [lindex [split $i ,] 1]
	lappend nums $num
	if {!$found} {
	    set fx_tmp_barchartsetup($i) ""
	    set fx_tmp_barchartsetup(search${num}) $fx_report($i)
	    set fx_tmp_barchartsetup(search${num},foreground) 000000
	    set fx_tmp_barchartsetup(search${num},barwidth) 1
	    set fx_tmp_barchartsetup(search${num},stipple) solid
	    set fx_tmp_barchartsetup(search${num},mapped) 1
	}
    }
    foreach i [lsort -integer $nums] {
	Fx:Barchart_BuildLine $top $w search$i $i
    }
}

proc Fx:Barchart_InitSetup {} {
    global fx_tmp_barchartsetup

    if {![info exists fx_tmp_barchartsetup(width)]} {
	set fx_tmp_barchartsetup(width) 5i
    }
    if {![info exists fx_tmp_barchartsetup(height)]} {
	set fx_tmp_barchartsetup(height) 4i
    }
    if {![info exists fx_tmp_barchartsetup(barmode)]} {
	set fx_tmp_barchartsetup(barmode) aligned
    }
    if {![info exists fx_tmp_barchartsetup(barrelief)]} {
	set fx_tmp_barchartsetup(barrelief) raised
    }
    if {![info exists fx_tmp_barchartsetup(title)]} {
	global fx_report
	if {[info exists fx_report(title)]} {
	    set fx_tmp_barchartsetup(title) $fx_report(title)
	}
    }
    if {![info exists fx_tmp_barchartsetup(background)]} {
	set fx_tmp_barchartsetup(background) EEEEEE
    }
    if {[winfo exists .fx_barchartsetup.f0.gen.l3]} {
	.fx_barchartsetup.f0.gen.l3 configure -bg \#$fx_tmp_barchartsetup(background)
    }
    if {![info exists fx_tmp_barchartsetup(plotbackground)]} {
	set fx_tmp_barchartsetup(plotbackground) EEEEEE
    }
    if {[winfo exists .fx_barchartsetup.f0.gen.pll]} {
	.fx_barchartsetup.f0.gen.pll configure -bg \#$fx_tmp_barchartsetup(plotbackground)
    }
}

proc Fx:Barchart_ClearSetup {schema} {
    global fx_rconfig fx_report fx_tmp_barchartsetup fx_barchart_frame

    set xcol $fx_tmp_barchartsetup(x,colorlabel)
    set ycol $fx_tmp_barchartsetup(y,colorlabel)
    catch {unset fx_tmp_barchartsetup}
    Fx:Barchart_ClearAxis x $xcol 1
    Fx:Barchart_ClearAxis y $ycol 1
    set fx_tmp_barchartsetup(x,colorlabel) $xcol
    set fx_tmp_barchartsetup(y,colorlabel) $ycol
    Fx:Barchart_InitSetup
    foreach i [array names fx_report expert_search_title,*] {
	set num [lindex [split $i ,] 1]
	set fx_tmp_barchartsetup($i) ""
	set fx_tmp_barchartsetup(search${num}) $fx_report($i)
	set fx_tmp_barchartsetup(search${num},foreground) 000000
	set fx_tmp_barchartsetup(search${num},barwidth) 1
	set fx_tmp_barchartsetup(search${num},stipple) solid
	set fx_tmp_barchartsetup(search${num},mapped) 1
    }
    set fx_tmp_barchartsetup(range) ""
    set fx_tmp_barchartsetup(format) ""
    set fx_tmp_barchartsetup(daterange_type) "User-defined"
    $fx_barchart_frame.range configure -state normal
    $fx_barchart_frame.format configure -state normal
    set valid_list [Fx:CheckNumericSearch $schema fx_tmp_barchartsetup x]
    set found [lindex $valid_list 3]
    if {$found} {
	set fx_tmp_barchartsetup(x_type) [lindex $valid_list 2]
    } else {
	set fx_tmp_barchartsetup(x_label) [lindex $valid_list 0]
	set fx_tmp_barchartsetup(x) [lindex $valid_list 1]
    }
    set valid_list [Fx:CheckNumericSearch $schema fx_tmp_barchartsetup y]
    set found [lindex $valid_list 3]
    if {$found} {
	set fx_tmp_barchartsetup(y_type) [lindex $valid_list 2]
    } else {
	set fx_tmp_barchartsetup(y_label) [lindex $valid_list 0]
	set fx_tmp_barchartsetup(y) [lindex $valid_list 1]
    }
}

proc Fx:Barchart_Setup {schema {apply {}}} {
    global fx_rconfig fx_report fx_barchart_setup_config \
	    fx_barchartsetup fx_tmp_barchartsetup qddb_library

    set g .fx_barchartsetup
    if {[winfo exists $g]} {
	raise $g
	focus $g
	return
    }
    catch {unset fx_tmp_barchartsetup}
    if {[info exists fx_barchartsetup]} {
	foreach i [array names fx_barchartsetup] {
	    set fx_tmp_barchartsetup($i) $fx_barchartsetup($i)
	}
    } else {
	Fx:Barchart_InitSetup
    }
    toplevel $g
    wm withdraw $g
    wm title $g "Barchart Setup"

    set f $g.f0
    frame $f -relief groove -bd 2
    pack $f -side top -expand on -fill x
    set f0 $f.title
    frame $f0 -relief groove -bd 2
    pack $f0 -side top -expand on -fill x
    label $f0.l -text "Barchart title:"
    pack $f0.l -side left
    entry $f0.e -textvariable fx_tmp_barchartsetup(title)
    pack $f0.e -side left -expand on -fill x
    button $f0.b -text "Font" -command [list Fx:BusyExec $g \
	    [list Fx:FontButton $f0.b fx_tmp_barchartsetup font]]
    pack $f0.b -side left
    if {![info exists fx_tmp_barchartsetup(font)]} {
	set fx_tmp_barchartsetup(font) "-*-courier-bold-r-*-*-*-100-*-*-*-*-*-*"
    }
    catch [list $f0.b configure -font $fx_tmp_barchartsetup(font)]
    set f0 $f.gen
    frame $f0 -relief groove -bd 2
    pack $f0 -side top -expand on -fill x
    button $f0.bg -text "Background" -padx 0m -pady 0m -command \
	    [list after idle "Fx:Barchart_SetColor $g $f0.l3 fx_tmp_barchartsetup background"]
    pack $f0.bg -side left
    label $f0.l3 -width 3 -relief groove
    pack $f0.l3 -side left
    button $f0.pl -text "Plot background" -padx 0m -pady 0m -command \
	    [list after idle "Fx:Barchart_SetColor $g $f0.pll fx_tmp_barchartsetup plotbackground"]
    pack $f0.pl -side left
    label $f0.pll -width 3 -relief groove
    pack $f0.pll -side left
    label $f0.lw -text "Width:"
    pack $f0.lw -side left
    entry $f0.ew -textvariable fx_tmp_barchartsetup(width) -width 4
    pack $f0.ew -side left
    fx_bindpixels $f0.ew
    label $f0.lh -text "Height:"
    pack $f0.lh -side left
    entry $f0.eh -textvariable fx_tmp_barchartsetup(height) -width 4
    pack $f0.eh -side left
    fx_bindpixels $f0.eh

    set f0 $f.gen2
    frame $f0 -relief groove -bd 2
    pack $f0 -side top -expand on -fill x

    label $f0.l -text "Bar alignment:"
    pack $f0.l -side left
    radiobutton $f0.normal -text Normal -value normal -variable fx_tmp_barchartsetup(barmode)
    pack $f0.normal -side left
    radiobutton $f0.aligned -text Aligned -value aligned -variable fx_tmp_barchartsetup(barmode)
    pack $f0.aligned -side left
    radiobutton $f0.stacked -text Stacked -value stacked -variable fx_tmp_barchartsetup(barmode)
    pack $f0.stacked -side left

    set f0 $f.gen3
    frame $f0 -relief groove -bd 2
    pack $f0 -side top -expand on -fill x

    label $f0.l2 -text "Bar relief:"
    pack $f0.l2 -side left
    radiobutton $f0.raised -text Raised -value raised -variable fx_tmp_barchartsetup(barrelief)
    pack $f0.raised -side left
    radiobutton $f0.flat -text Flat -value flat -variable fx_tmp_barchartsetup(barrelief)
    pack $f0.flat -side left
    radiobutton $f0.sunken -text Sunken -value sunken -variable fx_tmp_barchartsetup(barrelief)
    pack $f0.sunken -side left

    frame $f.x -relief groove -bd 2
    pack $f.x -side top -expand on -fill x
    Fx:Barchart_BuildAxis $g $f.x $schema x

    frame $f.y -relief groove -bd 2
    pack $f.y -side top -expand on -fill x
    Fx:Barchart_BuildAxis $g $f.y $schema y

    set f1 $f.lines
    frame $f1 -relief groove -bd 2
    pack $f1 -side top -expand on -fill x
    Fx:Barchart_BuildLines $g $f1

    set ff $g.f1
    frame $ff -relief groove -bd 2
    pack $ff -side bottom -expand on -fill x
    button $ff.ok -text "Ok" -command {set fx_barchart_setup_config 1}
    pack $ff.ok -side left -padx 8m -pady 2m
    if {[string length $apply] > 0} {
	button $ff.apply -text "Apply" -command [list eval $apply]
	pack $ff.apply -side left -padx 8m -pady 2m
    }
    button $ff.clear -text "Clear" -command [list Fx:Barchart_ClearSetup $schema]
    pack $ff.clear -side left -padx 8m -pady 2m
    button $ff.cancel -text "Cancel" -command {set fx_barchart_setup_config 0}
    pack $ff.cancel -side right -padx 8m -pady 2m
    update idletasks
    wm minsize $g [winfo reqwidth $g] [winfo reqheight $g]
    wm maxsize $g [winfo reqwidth $g] [winfo reqheight $g]
    Fx:SetGeometry $g
    Fx:Barchart_InitSetup
    wm protocol .fx_barchartsetup WM_DELETE_WINDOW {set fx_barchart_setup_config 0}
    update idletasks
    bind $g <Configure> {Fx:FixedSizeWindowBinding %W}
    wm deiconify $g
    tkwait variable fx_barchart_setup_config
    Fx:SavePosition $g
    set wait 0
    destroy .fx_barchartsetup
    if {$fx_barchart_setup_config == 1} {
	# save barchart setup
	foreach i [array names fx_tmp_barchartsetup] {
	    if {"$i" == "grid" || "$i" == "crosshairs" || "$i" == "zoom"} {continue}
	    set fx_barchartsetup($i) $fx_tmp_barchartsetup($i)
	}
	return 1
    } else {
	return 0
    }

}

proc Fx:Barchart_ConfigureBarchart {g} {
    global fx_barchartsetup

    foreach i {plotbackground background} {
	if {[info exists fx_barchartsetup($i)]} {
	    catch [list $g configure -$i \#$fx_barchartsetup($i)]
	}
    }
    foreach i {height width title barmode font invertxy} {
	if {[info exists fx_barchartsetup($i)]} {
	    catch [list $g configure -$i $fx_barchartsetup($i)]
	}
    }
}

proc Fx:Barchart_ConfigureAxis {g axis} {
    global fx_barchartsetup

    foreach i {linewidth showticks subdivisions ticklength descending logscale rotate tickfont titlefont} {
	if {[info exists fx_barchartsetup(${axis},$i)]} {
	    catch [list $g ${axis}axis configure -$i $fx_barchartsetup(${axis},$i)]
	}
    }
    if {[info exists fx_barchartsetup(${axis},loosefit)]} {
	catch [list $g ${axis}axis configure -loose $fx_barchartsetup(${axis},loosefit)]
    }
    if {[info exists fx_barchartsetup(${axis},stepsize)] && \
	    [string length $fx_barchartsetup(${axis},stepsize)] > 0} {
	catch [list $g ${axis}axis configure -stepsize $fx_barchartsetup(${axis},stepsize)]
    }
    if {[info exists fx_barchartsetup(${axis}_color)]} {
	catch [list $g ${axis}axis configure -color \#$fx_barchartsetup(${axis}_color)]
    }
    if {[info exists fx_barchartsetup(${axis}_label)]} {
	catch [list $g ${axis}axis configure -title $fx_barchartsetup(${axis}_label)]
    }
}

proc Fx:Barchart_ConfigureElement {g tbl xdata ydata num} {
    global fx_barchartsetup fx_report

    if {![info exists fx_barchartsetup(search$num)]} {
	return
    }
    set skipdel 0
    if {[string length $xdata] == 0} {
	if {[catch [list qddb_table col getval $tbl $fx_barchartsetup(x)] xdata] != 0} {
	    return
	}
    }
    if {[string length $ydata] == 0} {
	if {[catch [list qddb_table col getval $tbl $fx_barchartsetup(y)] ydata] != 0} {
	    return
	}
    }
    if {![$g element exists search$num]} {
	$g element create search$num
    }
    $g element configure search$num -label $fx_barchartsetup(search$num) \
	    -fg \#$fx_barchartsetup(search${num},foreground) \
	    -activeforeground \#$fx_barchartsetup(search${num},foreground) \
	    -activestipple fx_stipple_active \
	    -stipple fx_$fx_barchartsetup(search${num},stipple) \
	    -xdata $xdata -ydata $ydata \
	    -relief $fx_barchartsetup(barrelief) \
	    -mapped $fx_barchartsetup(search${num},mapped)
    if {[string length $fx_barchartsetup(search${num},barwidth)] == 0} {
	set fx_barchartsetup(search${num},barwidth) 1
    }
    catch [list $g element configure search$num -barwidth $fx_barchartsetup(search${num},barwidth)]
    if {[string compare $fx_barchartsetup(search${num},stipple) solid] == 0} {
	$g element configure search$num -bg \#$fx_barchartsetup(search${num},foreground)
    } else {
	$g element configure search$num -bg \#FFFFFF
    }
}

proc Fx:Barchart_TranslateAxisString {b str} {
    global fx_barchart_trans

    if {[info exists fx_barchart_trans($str)]} {
	return $fx_barchart_trans($str)
    } else {
	return ""
    }
}

proc Fx:Barchart_PostApply {barchart tables} {
    global fx_barchartsetup fx_barchart_trans

    catch "unset fx_barchart_trans"

    Fx:Barchart_ConfigureBarchart $barchart
    Fx:Barchart_ConfigureAxis $barchart x
    Fx:Barchart_ConfigureAxis $barchart y

    set x_type [qddb_table col cget [lindex $tables 0] $fx_barchartsetup(x) -type]
    if {$fx_barchartsetup(range_analysis) || [string compare $x_type string] == 0 || \
	    [string compare $x_type date] == 0} {
	if {[string compare $x_type date] == 0} {
	    if {!$fx_barchartsetup(range_analysis) || \
		    [string length [string trim $fx_barchartsetup(range)]] == 0 || \
		    [string length [string trim $fx_barchartsetup(format)]] == 0} {
		set fx_barchartsetup(range) "%y/%m/%d"
		set fx_barchartsetup(format) "%x"
		set fx_barchartsetup(function) sum
		set fx_barchartsetup(range_analysis) 1
	    }
	}
	if {!$fx_barchartsetup(range_analysis) && [string compare $x_type string] == 0} {
	    set fx_barchartsetup(range) ""
	    set fx_barchartsetup(format) ""
	    set fx_barchartsetup(function) sum
	    set fx_barchartsetup(range_analysis) 1
	}
	set tables2 {}
	foreach i $tables {
	    lappend tables2 [qddb_table summary $i $fx_barchartsetup(x) $fx_barchartsetup(y) \
		    $fx_barchartsetup(range) $fx_barchartsetup(format) $fx_barchartsetup(function)]
	}
	set x_sort 1
	set x_fmt 2
	foreach i $tables2 {
	    if {[catch [list qddb_table col getval $i $x_sort] xdata] != 0} {
		return
	    }
	    if {[catch [list qddb_table col getval $i $x_fmt] xfmtdata] != 0} {
		return
	    }
	    set len [llength $xdata]
	    for {set j 0} {$j < $len} {incr j} {
		set sort2fmt([lindex $xdata $j]) [lindex $xfmtdata $j]
		set fmt2sort([lindex $xfmtdata $j]) [lindex $xdata $j]
	    }
	}
	if {[string compare $x_type date] == 0 || [string compare $x_type string] == 0} {
	    set sort_type ascii
	} else {
	    set sort_type real
	}
	set j 1
	foreach i [lsort -$sort_type [array names sort2fmt]] {
	    set fx_barchart_trans($j) $sort2fmt($i) ;# num -> fmt (global)
	    set sort2num($i) $j
	    incr j
	}
	foreach i [array names fx_barchart_trans] {
	    set fmt2num($fx_barchart_trans($i)) $i ;# fmt -> num
	}
	$barchart xaxis configure -command Fx:Barchart_TranslateAxisString
	set num 1
	foreach i $tables2 {
	    set x 2
	    set y 3
	    if {[catch [list qddb_table col getval $i $x] xdata] != 0} {
		catch "qddb_table delete $i"
		continue
	    }
	    set nxdata {}
	    foreach j $xdata {
		if {[info exists fmt2num($j)]} {
		    lappend nxdata $fmt2num($j)
		} else {
		    set sort $fmt2sort($j) ;# fmt -> sort
		    lappend nxdata $sort2num($sort)
		}
	    }
	    if {[catch [list qddb_table col getval $i $y] ydata] != 0} {
		catch "qddb_table delete $i"
		continue
	    }
	    Fx:Barchart_ConfigureElement $barchart $i $nxdata $ydata $num
	    incr num
	    catch "qddb_table delete $i"
	}
    } else {
	$barchart xaxis configure -command ""
	set num 1
	foreach i $tables {
	    Fx:Barchart_ConfigureElement $barchart $i {} {} $num
	    incr num
	}
    }
}

proc Fx:Barchart_Apply {barchart tables} {
    global fx_barchartsetup fx_tmp_barchartsetup fx_range

    foreach i [array names fx_tmp_barchartsetup] {
	if {"$i" == "grid" || "$i" == "crosshairs" || "$i" == "zoom"} {continue}
	set fx_barchartsetup($i) $fx_tmp_barchartsetup($i)
    }
    Fx:Barchart_PostApply $barchart $tables
}

proc Fx:Barchart_Reconfigure {schema top barchart tables} {

    if {[Fx:DisabledExec $top \
	    [list Fx:Barchart_Setup $schema [list Fx:Barchart_Apply $barchart $tables]]] == 1} {
	Fx:Barchart_Apply $barchart $tables
    }
}

proc Fx:Barchart_Postscript {barchart} {
    global fx_postscript fx_barchart_postscript_config

    set top .fx_barchart_postscript
    toplevel $top
    wm title $top "Printing options"
    wm withdraw $top
    set f0 $top.f
    frame $f0 -relief groove -bd 2
    pack $f0 -side top -expand on -fill x
    set f00 $f0.f0
    frame $f00
    pack $f00 -side left -padx 8m
    label $f00.l -text Orientation:
    pack $f00.l -side left
    radiobutton $f00.port -variable fx_postscript(landscape) -value 0 -text Portrait
    pack $f00.port -side left
    radiobutton $f00.land -variable fx_postscript(landscape) -value 1 -text Landscape
    pack $f00.land -side left
    checkbutton $f0.maxpect -variable fx_postscript(maxpect) -text "Expand to full page"
    pack $f0.maxpect -side left -padx 8m

    set f1 $top.f1
    frame $f1 -relief groove -bd 2
    pack $f1 -side top -expand on -fill x
    checkbutton $f1.center -variable fx_postscript(center) -text "Center barchart on page"
    pack $f1.center -side left -padx 8m
    checkbutton $f1.decor -variable fx_postscript(decorations) -text "Backgrounds/Borders"
    pack $f1.decor -side left -padx 8m

    set f2 $top.f2
    frame $f2 -relief groove -bd 2
    pack $f2 -side top -expand on -fill x
    set f00 $f2.f1
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -text "Colors:"
    pack $f00.l -side left
    radiobutton $f00.color -variable fx_postscript(colormode) -value color -text "Full color"
    pack $f00.color -side left
    radiobutton $f00.gray -variable fx_postscript(colormode) -value gray -text "Gray scale"
    pack $f00.gray -side left
    radiobutton $f00.mono -variable fx_postscript(colormode) -value mono -text "Black/white"
    pack $f00.mono -side left

    set lwid 20
    set f3 $top.f3
    frame $f3 -relief groove -bd 2
    pack $f3 -side top -expand on -fill x
    set f00 $f3.f1
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Page width:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(paperwidth) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e
    set f00 $f3.f2
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Page height:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(paperheight) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e

    set f4 $top.f4
    frame $f4 -relief groove -bd 2
    pack $f4 -side top -expand on -fill x
    set f00 $f4.f1
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Barchart width:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(width) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e
    set f00 $f4.f2
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Barchart height:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(height) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e

    set f5 $top.f5
    frame $f5 -relief groove -bd 2
    pack $f5 -side top -expand on -fill x
    set f00 $f5.f1
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Left/right border:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(padx) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e
    set f00 $f5.f2
    frame $f00
    pack $f00 -side left -expand on -fill x -padx 8m
    label $f00.l -width $lwid -text "Top/bottom border:" -anchor e
    pack $f00.l -side left
    entry $f00.e -textvariable fx_postscript(pady) -width 5
    pack $f00.e -side left
    fx_bindpixels $f00.e
    
    set b $top.bot
    frame $b
    pack $b -side bottom -expand on -fill x
    button $b.print -text Print -command {set fx_barchart_postscript_config 1}
    pack $b.print -side left -padx 8m -pady 2m
    button $b.close -text Cancel -command {set fx_barchart_postscript_config 0}
    pack $b.close -side right -padx 8m -pady 2m
    Fx:SetGeometry $top
    update idletasks
    fx_bindgeom $top
    wm deiconify $top
    foreach i {center colormode decorations landscape \
	    maxpect padx pady paperheight paperwidth} {
	set fx_postscript($i) [lindex [$barchart postscript configure -$i] 3]
    }
    set fx_postscript(width) 0
    set fx_postscript(height) 0
    tkwait variable fx_barchart_postscript_config
    Fx:SavePosition $top
    if {$fx_barchart_postscript_config == 1} {
	global fx_config

	set fn [TempNam]
	foreach i [array names fx_postscript] {
	    catch "$barchart postscript configure -$i $fx_postscript($i)"
	}
	$barchart postscript output $fn
	Fx_PrintDialog barchart_print_dialog -toplevel ""
	if {[info exists fx_config(print_cmd)]} {
	    set print_cmd $fx_config(print_cmd)
	}
	if {[info exists fx_config(default_print_cmd)]} {
	    set default_print_cmd $fx_config(default_print_cmd)
	}
	set fx_config(print_cmd) "| lpr -h -P"
	set fx_config(default_print_cmd) "| lpr -h"
	catch "unset fx_config(print_heading)"
	catch "Fx:PrintFile $fn"
	if {[info exists print_cmd]} {
	    set fx_config(print_cmd) $print_cmd
	}
	if {[info exists default_print_cmd]} {
	    set fx_config(default_print_cmd) $default_print_cmd
	}
	catch "exec rm -f $fn"
    }
    destroy .fx_barchart_postscript
}

proc Fx:Barchart_Print {schema tables} {
    global fx_rconfig fx_report fx_barchart_print_config fx_barchartsetup fx_range

    if {[Fx:Barchart_Setup $schema] == 0} {
	return
    }
    set top .fx_barchartprint
    toplevel $top
    wm title $top "Barchart"
    wm withdraw $top
    set f $top.f
    set m $top.mid
    frame $m -relief groove -bd 2
    checkbutton $m.grid -text Grid -variable fx_barchartsetup(grid) -command {
	.fx_barchartprint.f.barchart grid configure -mapped $fx_barchartsetup(grid)
    }
    pack $m.grid -side left -padx 8m
    checkbutton $m.hairs -text Crosshairs -variable fx_barchartsetup(crosshairs) -command {
	.fx_barchartprint.f.barchart crosshairs configure -mapped $fx_barchartsetup(crosshairs)
    }
    pack $m.hairs -side left -padx 8m
    checkbutton $m.zoom -text Zooming -variable fx_barchartsetup(zoom) -command {
	.fx_barchartprint.f.barchart crosshairs configure -mapped $fx_barchartsetup(zoom)
	if {!$fx_barchartsetup(zoom)} {
	    Fx:BltResetAllZoom .fx_barchartprint.f.barchart
	}
    }
    pack $m.zoom -side left -padx 8m
    checkbutton $m.invert -text "Invert X/Y" -variable fx_barchartsetup(invertxy) -command {
	.fx_barchartprint.f.barchart configure -invertxy $fx_barchartsetup(invertxy)
    }
    pack $m.invert -side left -padx 8m
    set b $top.bot
    frame $b

    button $b.print -text Print -command \
	    [list Fx:BusyExec [list $top .fx_barchartsetup] [list Fx:Barchart_Postscript $f.barchart]]
    pack $b.print -side left -padx 8m -pady 2m
    button $b.setup -text Setup -command \
	    [list Fx:Barchart_Reconfigure $schema [list $b.setup $b.close] $f.barchart $tables]
    button $b.close -text Dismiss -command {set fx_barchart_print_config 0}
    pack $b.close -side right -padx 8m -pady 2m
    pack $b.setup -side right -padx 8m -pady 2m

    frame $f
    pack $b -side bottom -fill x
    pack $m -side bottom -fill x
    update idletasks
    wm minsize $top [winfo reqwidth $top] [winfo reqheight $top]
    pack $f -side top -expand on -fill both

    blt::barchart $f.barchart
    $f.barchart crosshairs configure -linewidth 1
    $f.barchart legend configure -activebackground gray80 -activeforeground black -activerelief raised
    Fx:Blt_Crosshairs $f.barchart fx_barchartsetup crosshairs
    Fx:Blt_ZoomStack $f.barchart fx_barchartsetup zoom
    Fx:Blt_BindRaiseElements $f.barchart
    Fx:Blt_ActiveLegend $f.barchart
    pack $f.barchart -side top -expand on -fill both

    Fx:Barchart_PostApply $f.barchart $tables
    $f.barchart grid configure -mapped $fx_barchartsetup(grid)

    Fx:SetGeometry $top
    update idletasks
    fx_bindgeom $top
    wm protocol .fx_barchartprint WM_DELETE_WINDOW Fx:Barchart_Quit
    wm deiconify $top
    tkwait variable fx_barchart_print_config
    Fx:SavePosition $top
    destroy .fx_barchartprint
}

proc Fx:Barchart_Quit {} {
    global fx_barchart_print_config fx_barchart_setup_config

    set fx_barchart_setup_config 0
    update
    set fx_barchart_print_config 0
}
