
/* tclInit.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "tcl.h"
#include "Qddb.h"
#include "tclQddb.h"

int TclQddb_Init(interp)
    Tcl_Interp 			*interp;
{
    char 			*libDir, buf[BUFSIZ];

    libDir = Tcl_GetVar2(interp, "env", "QDDB_LIBRARY", TCL_GLOBAL_ONLY);
    if (libDir == NULL) {
	libDir = QDDB_LIBRARY;
    }
    Tcl_SetVar2(interp, "qddb_library", (char *)NULL, libDir, TCL_GLOBAL_ONLY);
    sprintf(buf, "%s", QDDB_VERSION);
    Tcl_SetVar2(interp, "qddb_version", (char *)NULL, buf, TCL_GLOBAL_ONLY);
    sprintf(buf, "%d", QDDB_PATCHLEVEL);
    Tcl_SetVar2(interp, "qddb_patchlevel", (char *)NULL, buf, TCL_GLOBAL_ONLY);
    Qddb_using_TCL = True;
    Qddb_Init();
    Tcl_CreateCommand(interp, "qddb_instance", TclQddb_Instance,
		      (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
    Tcl_CreateCommand(interp, "qddb_keylist",  TclQddb_KeyList, 
		      (ClientData)interp, (Tcl_CmdDeleteProc *)TclQddb_DeleteKeyListProc);
    Tcl_CreateCommand(interp, "qddb_rows",     TclQddb_RowsProc, 
		      (ClientData)interp, (Tcl_CmdDeleteProc *)TclQddb_DeleteRowProc);
    Tcl_CreateCommand(interp, "qddb_schema",   TclQddb_SchemaProc,  
		      (ClientData)interp, (Tcl_CmdDeleteProc *)TclQddb_DeleteSchemaProc);
    Tcl_CreateCommand(interp, "qddb_search",   TclQddb_Search,  
		      (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
    Tcl_CreateCommand(interp, "qddb_table",    TclQddb_TableProc,
		      (ClientData)interp, (Tcl_CmdDeleteProc *)TclQddb_DeleteTableProc);
    Tcl_CreateCommand(interp, "qddb_tuple",    TclQddb_TupleProc,   
		      (ClientData)interp, (Tcl_CmdDeleteProc *)TclQddb_DeleteTupleProc);
    Tcl_CreateCommand(interp, "qddb_util",     TclQddb_UtilProc,
		      (ClientData)interp, (Tcl_CmdDeleteProc *)NULL);
    Tcl_CreateCommand(interp, "qddb_view",     TclQddb_ViewProc,
		      (ClientData)interp, (Tcl_CmdDeleteProc *)TclQddb_DeleteViewProc);
    return TCL_OK;
}

