#
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb.
#
# Qddb is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#

proc Hx:ParseError {} {
        puts -nonewline \
"Content-type: text/html

<html>
<head><title>Search Parse Error</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>Your search is improperly formatted.   Please try again</h2>
</body>
</html>
"
}

proc Hx:NoMatches {} {
    puts -nonewline \
"Content-type: text/html

<html>
<head><title>No matches found</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>Thanks for searching our Qddb database!   No matches found.</h2>
</body>
</html>
"
}

proc Hx:NoSearch {} {
    puts -nonewline \
"Content-type: text/html

<html>
<head><title>No search specified</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>Thanks for searching our Qddb database, <br>
but you must first specify a search!</h2>
</body>
</html>
"
}

proc Hx:GenericListing {s tbl} {
    set maxrow [qddb_table row maxnum $tbl]
    set maxcol [qddb_table col maxnum $tbl]
    for {set i 1} {$i <= $maxcol} {incr i} {
	set verb($i) [qddb_table col cget $tbl $i -title]
    }
    for {set i 1} {$i <= $maxrow} {incr i} {
	append retval "<form>"
	for {set j 1} {$j <= $maxcol} {incr j} {
	    append retval "<b>$verb($j):</b> [qddb_table cell getval $tbl $i $j]<br>"
	}
	append retval "</form><br>"
    }
    return $retval
}

proc Hx:GenericSearchEngine {
    schema_name 
    webmaster
    hostname
    mypath
    dbdir
    {rowincr 10}
    {maxrows 100}
    {title ""}
    {opening ""}
    {message ""}
    {signature ""}
    {procs ""}} {
    global env

    if {[llength $procs] == 0} {
	set entryproc Hx:GenericEntryForm
	set listingproc Hx:GenericListing
	set tableproc Hx:FormatTable
	set columnproc Hx:ColumnSpecs
	set sortproc Hx:SortSpecs
    } else {
	set entryproc [lindex $procs 0]
	set listingproc [lindex $procs 1]
	set tableproc [lindex $procs 2]
	set columnproc [lindex $procs 3]
	set sortproc [lindex $procs 4]
    }
    if {[string length $title] == 0} {
	set title "Qddb Search Engine"
    }
    if {[string length $opening] == 0} {
	set opening "Welcome to the Qddb search engine"
    }
    if {[string length $message] == 0} {
	set message "Please enter any search criteria you like using the standard
<a href=http://www.hsdi.com/qddb>Qddb</a> syntax.    \".*\" in any field will bring up all the
people who have filled in that field.
If you don't know Qddb's simple search syntax, you can read
about it in the <a href=http://www.hsdi.com/qddb/manual/node15.html>Guide to Qddb</a>."
    }
    set env(QDDBDIRS) $dbdir
    set s [qddb_schema open $schema_name]
    Hx:Init $s
    if {[string compare $env(REQUEST_METHOD) GET] == 0} {
	puts -nonewline "Content-type: text/html

<html>
<head><title>$title</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>$opening</h2>
<p>
$message
<p>
<br>
$signature
<hr size=3 width=95% align=center NOSHADE>

<form method=POST ACTION=${mypath}?$env(QUERY_STRING)>
<pre>
[$entryproc $s]
<br>
[$columnproc $s hx-columns {} {} 5]
<br>
[$sortproc $s hx-sort {} {} 3]
<br>
What format would you like? <input type=radio name=\$format\$ value=Table> Table <input checked type=radio name=\$format\$ value=Listing> Listing
<br>
<input type=submit value=\"Search\"> <input type=reset value=\"Clear\">

</pre></form></body></html>"
    } elseif {[string compare $env(REQUEST_METHOD) POST] == 0} {
	if {[string length $env(QUERY_STRING)] != 0} {
	    regsub -all "\{\}" $env(QUERY_STRING) " " env(QUERY_STRING)
	    set l $env(QUERY_STRING)
	    set firstrow [lindex $l 0]
	    set lastrow [lindex $l 1]
	    set search [lindex [lrange $l 2 end] 0] ;# strip off a list level
	} else {
	    set firstrow 1
	    set lastrow [expr $firstrow + $rowincr - 1]
	}
	set nfirstrow [expr $firstrow + $rowincr]
	set nlastrow [expr $lastrow + $rowincr]
	set pfirstrow [expr $firstrow - $rowincr]
	set plastrow [expr $lastrow - $rowincr]
	set env(QUERY_STRING) {}
	lappend env(QUERY_STRING) $nfirstrow $nlastrow
	if {[info exists search]} {
	    lappend env(QUERY_STRING) $search
	    set l1 $search
	} else {
	    set l1 [Hx:GetPostedData]
	    set search $l1
	    lappend env(QUERY_STRING) $l1
	}
	regsub -all {[      ]+} $env(QUERY_STRING) "\{\}" env(QUERY_STRING)
	set format Table
	foreach i $l1 {
	    set attr [lindex $i 0]
	    if {[string compare $attr \$format\$] == 0} {
		set format [lindex $i 1]
	    }
	}
	if {[catch [list Hx:Search $s $l1] k] != 0} {
	    Hx:ParseError
	    exit 0
	}
	if {[string length $k] == 0} {
	    Hx:NoSearch
	    exit 0
	}
	foreach i $l1 {
	    if {[string compare [lindex $i 0] hx-columns] == 0} {
		lappend columns [lindex $i 1]
	    }
	    if {[string compare [string range [lindex $i 0] 0 6] hx-sort] == 0} {
		set sortattrs([string range [lindex $i 0] 8 end]) [lindex $i 1]
	    }
	}
	if {![info exists columns]} {
	    set columns [qddb_schema leaves $s]
	}
	set sortby {}
	foreach i [lsort -integer -increasing [array names sortattrs]] {
	    lappend sortby $sortattrs($i)
	}
	set k [qddb_keylist range $k 0 $maxrows]
	if {[string length $k] == 0} {
	    Hx:NoMatches
	    exit 0
	}
	set tbl [qddb_rows select -format table -rowdescs off \
		-flush on -print $columns -sortby $sortby -ascending $sortby $k]
	if {[string length $tbl] == 0} {
	    Hx:NoMatches
	    exit 0
	}
	# Put hrefs in place for e-mail addrs and home pages
	set maxrow [qddb_table row maxnum $tbl]
	Hx:PruneTable $tbl $firstrow $lastrow
	if {$lastrow >= $maxrow} {
	    set env(QUERY_STRING) "" ;# kill the next page button
	}
	if {[string compare $format Listing] == 0} {
	    puts "Content-type: text/html

<html>
<head><title>Search results ($schema_name)</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>Thanks for searching our <a href=http://www.hsdi.com/qddb>Qddb</a> database!   <br>
Here are the results of your search.</h2>
<br>
[$listingproc $s $tbl]
"
	} else {
	    puts "Content-type: text/html

<html>
<head><title>Search results ($schema_name)</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>Thanks for searching our <a href=http://www.hsdi.com/qddb>Qddb</a> database!   <br>
Here are the results of your search.</h2>
<br>
<table border>
[$tableproc $tbl]
</table>
<br>
"
	}
	if {[string length $env(QUERY_STRING)] == 0 && $pfirstrow >= 1} {
	    set env(QUERY_STRING) [list $pfirstrow $plastrow $search]
	    regsub -all {[  ]+} $env(QUERY_STRING) "\{\}" env(QUERY_STRING)
	    puts "
<form method=POST ACTION=${mypath}?$env(QUERY_STRING)>
<input type=submit value=\"Previous page\">
</form>
<br>
<a href=http://${hostname}${mypath}>Back to search form</a>
</body></html>"
        } elseif {$pfirstrow >= 1} {
	    set prev [list $pfirstrow $plastrow $search]
	    regsub -all {[  ]+} $prev "\{\}" prev
	    puts "
<form method=POST ACTION=${mypath}?${prev}>
<input type=submit value=\"Previous page\">
</form><nobr>
<form method=POST ACTION=${mypath}?$env(QUERY_STRING)>
<input type=submit value=\"Next page\">
</form>
<br>
<a href=http://${hostname}${mypath}>Back to search form</a>
</body></html>"
        } elseif {[string length $env(QUERY_STRING)] > 0} {
	    puts "
<form method=POST ACTION=${mypath}?$env(QUERY_STRING)>
<input type=submit value=\"Next page\">
</form>
<br>
<a href=http://${hostname}${mypath}>Back to search form</a>
</body></html>"
        } else {
	    puts "
<br>
<a href=http://${hostname}${mypath}>Back to search form</a>
</body></html>"
        }
    }
}

proc Hx:GenericSubmissionForm {
    schema_name 
    webmaster
    hostname
    mypath
    dbdir
    {title ""}
    {opening ""}
    {message ""}
    {signature ""}
    {procs ""}} {
    global env

    if {[llength $procs] == 0} {
	set entryproc Hx:GenericEntryForm
	set checkproc ""
    } else {
	set entryproc [lindex $procs 0]
	set checkproc [lindex $procs 1]
    }
    if {[string length $title] == 0} {
	set title "Qddb Database Submission Form"
    }
    if {[string length $opening] == 0} {
	set opening "Welcome to the Qddb database submission form!"
    }
    if {[string length $message] == 0} {
	set message "Please fill in all fields with relevant data, and submit when you are finished.<br>"
    }
    set env(QDDBDIRS) $dbdir
    set s [qddb_schema open $schema_name]
    Hx:Init $s
    if {[string compare $env(REQUEST_METHOD) GET] == 0} {
	puts -nonewline \
"Content-type: text/html

<html>
<head><title>$title</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>$opening</h2>
<p>
$message
<p>
<br>
$signature
<hr size=3 width=95% align=center NOSHADE>

<form method=POST ACTION=${mypath}?$env(QUERY_STRING)>
<pre>
[$entryproc $s]
<br>
<input type=submit value=\"Submit!\"> <input type=reset value=\"Clear\">

</pre>
</form>

</body>
</html>
"
    } elseif {[string compare $env(REQUEST_METHOD) POST] == 0} {
	set l1 [Hx:GetPostedData]
	set t [qddb_tuple new $s]
	set v [qddb_view define $t {}]
	foreach i $l1 {
	    set attr [lindex $i 0]
	    set attrval [lindex $i 1]
	    if {[string length [string trim $attrval]] == 0} {
		continue
	    }
	    set vals($attr) $attrval
	    qddb_instance setval $v $attr $attrval
	}
	if {[string length $checkproc] != 0} {
	    $checkproc $t
	}
	qddb_tuple write $t
	puts "Content-type: text/html

<html>
<head><title>$title</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>Your submission has been successfully entered!</h2>
</body>
</html>
"
    }
}
