#
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb.
#
# Qddb is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#

proc Hx:FormatTable {tbl {rowtitles 1} {coltitles 1}} {
    set retval ""
    set l [qddb_table getval $tbl -format list -rowtitles $rowtitles -coltitles $coltitles]
    if {$coltitles} {
	set heading [lindex $l 0]
	append retval "<tr>"
	foreach i $heading {
	    append retval "<th>$i</th>"
	}
	append retval "</tr>"
	set l [lrange $l 1 end]
    }
    foreach i $l {
	append retval "<tr>"
	if {$rowtitles} {
	    set tmp [lindex $i 0]
	    append retval "<th>$tmp</th>"
	    set i [lrange $i 1 end]
	}
	foreach j $i {
	    if {[string length [string trim $j]] == 0} {
		set j "---"
	    }
	    append retval "<td>$j</td>"
	    
	}
	append retval "</tr>"
    }
    return $retval
}

proc Hx:PruneTable {tbl first last} {
    set max [qddb_table row maxnum $tbl]
    for {set i $max} {$i > $last} {incr i -1} {
	qddb_table row delete $tbl $i
    }
    for {set i 1} {$i < $first} {incr i} {
	qddb_table row delete $tbl 1
    }
    for {set i 1} {$i <= $last} {incr i} {
	if {[catch "qddb_table row configure $tbl $i -title [expr $i + $first - 1]"] != 0} {
	    break
	}
    }
}

