#
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb.
#
# Qddb is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#
proc Hx:Search {s l} {
    foreach i [qddb_schema leaves $s] {
	set attr_array($i) ""
    }
    foreach i $l {
	set attr [lindex $i 0]
	set attrval [lindex $i 1]
	if {[string length [string trim $attrval]] == 0} {
	    continue
	}
	if {![info exists attr_array($attr)] && [string compare $attr \$search\$] != 0} {
	    continue
	}
	set vals($attr) [concat $attrval]
	lappend attrnames $attr
    }
    foreach i $attrnames {
	if {[info exists k]} {
	    if {[string compare $i \$search\$] == 0} {
		set k1 [Hx:MultiSearch $s $vals($i)]
		set k [qddb_keylist op intersection $k $k1]
	    } else {
		set k1 [Hx:MultiSearch $s $vals($i) on $i]
		set k [qddb_keylist op intersection $k $k1]
	    }
	} else {
	    if {[string compare $i \$search\$] == 0} {
		set k [Hx:MultiSearch $s $vals($i)]
	    } else {
		set k [Hx:MultiSearch $s $vals($i) on $i]
	    }
	}
    }
    if {![info exists k]} {
	return ""
    } else {
	return $k
    }
}
proc Hx:IsANumber {n} {
	return [expr [catch [list expr double($n)]] == 0]
}
proc Hx:IsADate {dt} {
	return [qddb_util isdate $dt]
}
proc Hx:IsAWord {w} {
	set w [string trim $w]
	set res [regexp -nocase {[a-z0-9]*\.?} $w nw]
	if {[string compare $w $nw] == 0} {
	    return 1
	}
	return 0
}
proc Hx:IsARange {r} {
	set r [split $r "-"]
	set len [llength $r]
	if {$len == 2} {
	    return 1
	} elseif {$len > 2 && $len < 5} {
	    foreach i $r {
		if {[llength $i] != 0 && [catch [list expr double($i)]] != 0} {
		    return 0
		}
	    }
	    return 1
	}
	return 0
}
proc Hx:Singlett {schema s pruneby} {
	global hx_config

	if {([string compare $pruneby any] == 0 || ([info exists hx_config(\$range_search\$,$pruneby)] && \
		 $hx_config(\$range_search\$,$pruneby) == 1)) && [Hx:IsARange $s]} {
	    set r [split $s "-"]
	    set r1 [lindex $r 0]
	    if {[llength $r1] == 0} {
		set r1 -[lindex $r 1]
		set spot 2
	    } else {
		set spot 1
	    }
	    set r2 [lindex $r $spot]
	    if {[llength $r2] == 0} {
		set r2 -[lindex $r [expr $spot + 1]]
	    }
	    if {[string compare $pruneby any] != 0 && \
		    [info exists hx_config(\$date_search\$,$pruneby)] && \
		    $hx_config(\$date_search\$,$pruneby) == 1 && \
		    [string compare [qddb_schema option type $schema $pruneby] date] == 0 && \
		    [Hx:IsADate $r1] && [Hx:IsADate $r2]} {
		set validrange 1
		set rangetype dr
		set r1 "$r1 12:00AM"
		set r2 "$r2 11:59PM"
	    } elseif {[Hx:IsANumber $r1] && [Hx:IsANumber $r2] && \
			  ([string compare $pruneby any] == 0 || \
			       ([info exists hx_config(\$numeric_search\$,$pruneby)] && \
				    $hx_config(\$numeric_search\$,$pruneby) == 1))} {
		set validrange 1
		set rangetype nr
	    } elseif {[Hx:IsAWord $r1] && [Hx:IsAWord $r2]} {
		set validrange 1
		set rangetype wr
	    } else {
		set validrange 0
	    }
	    if {$validrange} {
		if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby \
					    $rangetype $r1 - $r2]} ret_error]} {
		    error $ret_error
		} else {
		    return $retval
		}
	    } elseif {[string compare $pruneby any] == 0 || \
			   ([info exists hx_config(\$regexp_search\$,$pruneby)] && \
				$hx_config(\$regexp_search\$,$pruneby) == 1)} {
		if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby r $s]} ret_error]} {
		    error $ret_error
		} else {
		    return $retval
		}
	    } else {
		if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby w $s]} ret_error]} {
		    error $ret_error
		} else {
		    return $retval
		}
	    }
	} elseif {[string compare $pruneby any] != 0 && \
		      [string compare [qddb_schema option type $schema $pruneby] date] == 0 && \
		      [info exists hx_config(\$date_search\$,$pruneby)] && \
		      $hx_config(\$date_search\$,$pruneby) == 1 && \
		      [Hx:IsADate $s] == 1} {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby dr \
					"$s 12:00AM" - "$s 11:59PM"]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	} elseif {[Hx:IsANumber $s] == 1 && \
		      ([info exists hx_config(\$numeric_search\$,$pruneby)] && \
		       $hx_config(\$numeric_search\$,$pruneby) == 1)} {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby n $s]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	} elseif {[Hx:IsAWord $s] == 1} {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby w $s]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	} elseif {[string compare $pruneby any] == 0 || \
		      ([info exists hx_config(\$regexp_search\$,$pruneby)] && \
			   $hx_config(\$regexp_search\$,$pruneby) == 1)} {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby r $s]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	} else {
	    if {[catch {set retval [qddb_search $schema -prunebyattr $pruneby w $s]} ret_error]} {
		error $ret_error
	    } else {
		return $retval
	    }
	}
}
proc Hx:Intersection {schema s1 s2 exact pruneby} {
	set k1 [Hx:MultiSearch $schema $s1 $exact $pruneby]
	if {[llength $k1] > 1} {
	    return $k1
	}
	set k2 [Hx:MultiSearch $schema $s2 $exact $pruneby]
	if {[llength $k2] > 1} {
	    return $k2
	}
	return [qddb_keylist op intersection -exact $exact $k1 $k2]
}
proc Hx:Union {schema s1 s2 exact pruneby} {
	set k1 [Hx:MultiSearch $schema $s1 $exact $pruneby]
	if {[llength $k1] > 1} {
	    return $k1
	}
	set k2 [Hx:MultiSearch $schema $s2 $exact $pruneby]
	if {[llength $k2] > 1} {
	    return $k2
	}
	return [qddb_keylist op union -exact $exact $k1 $k2]
}
proc Hx:Exclusion {schema s1 s2 exact pruneby} {
	set k1 [Hx:MultiSearch $schema $s1 $exact $pruneby]
	if {[llength $k1] > 1} {
	    return $k1
	}
	set k2 [Hx:MultiSearch $schema $s2 $exact $pruneby]
	if {[llength $k2] > 1} {
	    return $k2
	}
	return [qddb_keylist op exclusion -exact $exact $k1 $k2]
}
proc Hx:BinaryOp {schema s1 op s2 exact pruneby} {
	switch -exact $op {
	    " " {return [Hx:Intersection $schema $s1 $s2 $exact $pruneby]}
	    "," {return [Hx:Union $schema $s1 $s2 $exact $pruneby]}
	    "!" {return [Hx:Exclusion $schema $s1 $s2 $exact $pruneby]}
	    default {return [Hx:Intersection $schema $s1 $s2 $exact $pruneby]}
	}
}
proc Hx:MultiSearch {schema s {exact off} {pruneby any}} {
	set len [llength $s]
	if {$len == 0} {
	    return {}
	}
	if {$len == 3 && [string match {[!,]} [string trim [lindex $s 1]]]} {
	    set result [Hx:BinaryOp $schema [lindex $s 0] [lindex $s 1] [lindex $s 2] $exact $pruneby]
	} elseif {$len == 2} {
	    set result [Hx:BinaryOp $schema [lindex $s 0] " " [lindex $s 1] $exact $pruneby]
	} else {
	    set result [Hx:Singlett $schema [lindex $s 0] $pruneby]
	    if {[llength $result] > 1} {
		return $result
	    }
	    for {set i 1} {$i < $len} {incr i} {
		if {[catch {
		    switch -exact [lindex $s $i] {
			"," {
			    incr i
			    set nresult [Hx:MultiSearch $schema [lindex $s $i] $exact $pruneby]
			    if {[llength $nresult] > 1} {
				return $nresult
			    }
			    set result [qddb_keylist op union -exact $exact $result $nresult]
			}
			"!" {
			    incr i
			    set nresult [Hx:MultiSearch $schema [lindex $s $i] $exact $pruneby]
			    if {[llength $nresult] > 1} {
				return $nresult
			    }
			    set result [qddb_keylist op exclusion -exact $exact $result $nresult]
			}
			default {
			    set nresult [Hx:MultiSearch $schema [lindex $s $i] $exact $pruneby]
			    if {[llength $nresult] > 1} {
				return $nresult
			    }
			    set result [qddb_keylist op intersection -exact $exact $result $nresult]
			}
		    }
		} ret_error]} {
		    error "Bad query, respecify."
		}
	    }
	}
	return $result
}

