#
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb.
#
# Qddb is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#

proc Hx:Init {s} {
    global hx_config
    uplevel \#0 {
	if {![info exists env(REQUEST_METHOD)]} {
	    exit 0
	}
	if {![info exists env(QUERY_STRING)]} {
	    set env(QUERY_STRING) ""
	}
	if {![info exists env(REMOTE_IDENT)]} {
	    set env(REMOTE_IDENT) ""
	}
	if {![info exists env(REMOTE_HOST)]} {
	    set env(REMOTE_HOST) ""
	}
    }
    foreach i [qddb_schema leaves $s] {
	set hx_config(\$range_search\$,$i) 1
	set hx_config(\$regexp_search\$,$i) 1
	set hx_config(\$numeric_search\$,$i) 1
	if {[string compare [qddb_schema option type $s $i] date] == 0} {
	    set hx_config(\$date_search\$,$i) 1
	}
    }
}