#
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb.
#
# Qddb is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#

proc Hx:GenericEntryForm {s {default_width 40}} {
    set leaves [qddb_schema leaves $s]
    set max 0
    foreach i $leaves {
	set width [string length [qddb_schema option verbosename $s $i]]
	if {$width > $max} {
	    set max $width
	}
    }
    foreach i $leaves {
	lappend l [list $i $max text $default_width]
	append l "\n"
    }
    return [Hx:DefinedEntryForm $s $l]
}

proc Hx:DefinedEntryForm {s format} {
    set f [split $format \n]
    foreach i [qddb_schema leaves $s] {
	set verb($i) [qddb_schema option verbosename $s $i]
    }
    # format - list of lists, each list is the format of a line
    # {attr labelwidth type=radio|checkbox|text|textarea entrywidth ?entryheight? ?values?}
    # empty lists are blanks or <br>
    set retval ""
    foreach i $f { # lines
	if {[llength $i] == 0} {
	    append retval "\n"
	    continue
	}
	foreach j $i { # entries on a line
	    set attr [lindex $j 0]
	    if {[string compare $attr <html>] == 0} {
		append retval "[lrange $j 1 end]"
		continue
	    }
	    set lwid [lindex $j 1]
	    set type [lindex $j 2]
	    set ewid [lindex $j 3]
	    set eheight [lindex $j 4]
	    set values [lindex $j 5]
	    switch -exact $type {
		text {
		    append retval [format "%${lwid}s:" $verb($attr)]
		    append retval "<input type=text size=$ewid name=$attr>"
		}
		radio {
		    append retval " <input type=radio name=$attr value=\"$values\"> $values"
		}
		checkbox {
		    append retval " <input type=checkbox name=$attr value=\"$values\"> $values"
		}
		select-single {
		    append retval " <select name=$attr size=$eheight>\n"
		    foreach k $values {
			append retval "<option>$k\n"
		    }
		    append retval "</select>\n"
		}
		select-multiple {
		    append retval " <select name=$attr size=$eheight multiple>\n"
		    foreach k $values {
			append retval "<option>$k\n"
		    }
		    append retval "</select>\n"
		}
		textarea {
		    append retval [format "%${lwid}s:" $verb($attr)]
		    append retval \
			    "<br><textarea name=$attr rows=$eheight cols=$ewid value=\"$values\"></textarea>"
		}
		label {
		    append retval [format "%${lwid}s:" $verb($attr)]
		}
	    }
	}
	append retval \n
    }
    return $retval
}


proc Hx:ColumnSpecs {s name {exclude {}} {notchecked {}} {numcolumns 4}} {
    set leaves [qddb_schema leaves $s]
    foreach i $exclude {
	set where [lsearch -exact $leaves $i]
	if {$where != -1} {
	    set leaves [lreplace $leaves $where $where]
	}
    }
    foreach i $leaves {
	set verb($i) [qddb_schema option verbosename $s $i]
    }
    foreach i $notchecked {
	set dontcheck($i) ""
    }
    set retval "<h3>Which fields would you like to see?</h3><br><table>"
    set x 0
    set open 0
    foreach i $leaves {
	if {[expr $x % $numcolumns] == 0} {
	    append retval "<tr>"
	    set open 1
	}
	if {[info exists dontcheck($i)]} {
	    append retval "<td><input type=checkbox name=$name value=$i> $verb($i)</td>"
	} else {
	    append retval "<td><input type=checkbox checked name=$name value=$i> $verb($i)</td>"
	}
	incr x
	if {[expr $x % $numcolumns] == 0} {
	    append retval "</tr>"
	    set open 0
	}
    }
    if {$open} {
	append retval "</tr>"
    }
    append retval "</table>"
    return $retval
}


proc Hx:SortSpecs {s name {exclude {}} {notchecked {}} {numcolumns 4}} {
    set leaves [qddb_schema leaves $s]
    foreach i $exclude {
	set where [lsearch -exact $leaves $i]
	if {$where != -1} {
	    set leaves [lreplace $leaves $where $where]
	}
    }
    foreach i $leaves {
	set verb($i) [qddb_schema option verbosename $s $i]
    }
    foreach i $notchecked {
	set dontcheck($i) ""
    }
    set retval "<h3>How would you like the entries sorted?</h3><br><table><font>"
    set len [llength $leaves]
    for {set i 0} {$i < $numcolumns} {incr i} {
	append retval "<tr>"
	append retval "<td><select name=$name-$i>"
	set options ""
	set boxchecked 0
	for {set j 0} {$j < $len} {incr j} {
	    set leaf [lindex $leaves $j]
	    if {!$boxchecked && ![info exists dontcheck($leaf)] && ![info exists checked($leaf)]} {
		append options \
			"<option selected value=$leaf> $verb($leaf)\n"
		set checked($leaf) 1
		set boxchecked 1
	    } else {
		append options \
			"<option value=$leaf> $verb($leaf)\n"
	    }
	}
	append retval $options
	append retval "</select></td>"
	append retval "</tr>"
    }
    append retval "</font></table>"
    return $retval
}

proc Hx:DefinedListing {s tbl format} {
    set f [split $format \n]
    foreach i [qddb_schema leaves $s] {
	if {[catch "qddb_table col cget $tbl $i -title" title] == 0} {
	    set verb($i) $title
	}
    }
    # format - list of lists, each list is the format of a line
    # {attr type=text|textarea|label|<html> entrywidth}
    # empty lists are blanks or <br>
    set retval ""
    set max [qddb_table row maxnum $tbl]
    for {set i 1} {$i <= $max} {incr i} {
	append retval "<form>"
	foreach j $f { # lines
	    if {[llength $j] == 0} {
		append retval "\n"
		continue
	    }
	    set gotsome 0
	    foreach k $j { # entries on a line
		set attr [lindex $k 0]
		if {[string compare $attr <html>] == 0} {
		    append retval "[lrange $k 1 end]"
		    continue
		}
		if {![info exists verb($attr)]} {
		    continue
		}
		set val [qddb_table cell getval $tbl $i $attr]
		set val [string trim $val]
		set type [lindex $k 1]
		set ewid [lindex $k 2]
		switch -exact $type {
		    text {
			append retval "$val "
			set gotsome 1
		    }
		    textarea {
			regsub -all "\n" $val "<br>" val
			append retval "$val "
			set gotsome 1
		    }
		    label {
			append retval [format "<b>%${ewid}s</b>: " $verb($attr)]
			set gotsome 1
		    }
		}
	    }
	    if {$gotsome} {
		append retval "<br>"
	    }
	}
	append retval "</form><br>"
    }
    return $retval
}
