
/* tclQddb.h
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */
#if !defined(_TCLQDDB_H_)
#define _TCLQDDB_H_

typedef struct {
    char		*schema_name;
    int			fd;
    KeyList		keylist;
    DataTree		**datatree;
} TclQddb_Tuple;

typedef struct tclqddb_rows {
    char		*attr_name, *instance;
    struct tclqddb_rows *next;
} TclQddb_Rows;

typedef struct tclqddb_rowheader {
    char		*schema_name;
    char		*tuple_name;
    TclQddb_Rows	*row;
} TclQddb_RowHeader;

typedef struct tclqddb_keylistheader {
    char		*schema_name;
    Qddb_AttrHead       attributes;
    KeyList		*keylist;
} TclQddb_KeyListHeader;

typedef struct {
    char		*schema_name;
    char		*tuple_name;
    int			num_attrs;
    /* view is an array of pointers to datatree elements.
     * view[i] is the view corresponding to the i'th node
     * in the schema.   Leaf nodes point directly into
     * the DataTree, intermediate nodes have a copy
     * of the DataTree node.
     */
    DataTree		**view;		
    /* tclvars[i] holds the name of the TCL variable linked
     * to view[i] (leaves only).
     */
    char		**tclvars;
    /* curinst[i] holds the current instance for the schema
     * entry indexed by i.
     */
    int			*curinst;
} TclQddb_View;

int TclQddb_Init 	_ANSI_ARGS_((Tcl_Interp *));

/* Main entry points */
int TclQddb_SchemaProc 	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
int TclQddb_Search   	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
int TclQddb_KeyList  	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
int TclQddb_RowsProc  	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
int TclQddb_TableProc 	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
int TclQddb_TupleProc 	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
int TclQddb_Instance 	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
int TclQddb_ViewProc   	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
int TclQddb_UtilProc   	_ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));

/* Internal cross-referencing routines */
Schema 		*TclQddb_GetSchema 	_ANSI_ARGS_((char *));
void 		TclQddb_DeleteSchemaProc _ANSI_ARGS_((ClientData));

int 		TclQddb_NewKeyList	_ANSI_ARGS_((Tcl_Interp *, char *, KeyList *, int, int));
int 		TclQddb_GetKeyList 	_ANSI_ARGS_((Tcl_Interp *, char *, TclQddb_KeyListHeader **));
int		TclQddb_DeleteKeyList	_ANSI_ARGS_((Tcl_Interp *, char *, int));
void 		TclQddb_DeleteKeyListProc _ANSI_ARGS_((ClientData));

TclQddb_RowHeader *TclQddb_GetRows	_ANSI_ARGS_((Tcl_Interp *, char *));
int 		TclQddb_SetRow		_ANSI_ARGS_((Tcl_Interp *, TclQddb_RowHeader *));
int		TclQddb_DeleteRows	_ANSI_ARGS_((Tcl_Interp *, char *));
void 		TclQddb_DeleteRowProc 	_ANSI_ARGS_((ClientData));

void 		TclQddb_DeleteTableProc _ANSI_ARGS_((ClientData));

char		*TclQddb_NewTuple	_ANSI_ARGS_((Tcl_Interp *, char *, DataTree **, KeyList *));
TclQddb_Tuple 	*TclQddb_GetTuple	_ANSI_ARGS_((Tcl_Interp *, char *));
int		TclQddb_DeleteTuple	_ANSI_ARGS_((Tcl_Interp *, char *));
void 		TclQddb_DeleteTupleProc _ANSI_ARGS_((ClientData));
int 		TclQddb_FlushTuple	_ANSI_ARGS_((Tcl_Interp *, char *));

TclQddb_View	*TclQddb_GetView 		_ANSI_ARGS_((Tcl_Interp *, char *));
int TclQddb_SetInstance 			_ANSI_ARGS_((Tcl_Interp *, Schema *, \
							     TclQddb_Tuple *, TclQddb_View *, \
							     char *, size_t));
int		TclQddb_ViewLockTuple  		_ANSI_ARGS_((Tcl_Interp *, char *));
int		TclQddb_ViewUnlockTuple  	_ANSI_ARGS_((Tcl_Interp *, char *));
int		TclQddb_DeleteView		_ANSI_ARGS_((Tcl_Interp *, char *));
void 		TclQddb_DeleteViewProc 		_ANSI_ARGS_((ClientData));

void TclQddb_SortRowsSameTuple 			_ANSI_ARGS_((Tcl_Interp *, TclQddb_Tuple *, \
							     TclQddb_Rows **, int, \
							     char **, int, char **));
int TclQddb_SortRows 				_ANSI_ARGS_((Tcl_Interp *, int, char **, int, \
							     char **, int, char **));
int TclQddb_SortSelectRows 			_ANSI_ARGS_((Tcl_Interp *, int, char **, char **, \
							     int, char **, int, char **));
int TclQddb_SortQueryRows 			_ANSI_ARGS_((Tcl_Interp *, Schema *, int, char **, \
							     int, char **, int, char **));

DataTree *TclQddb_DataTreeLookupNode 		_ANSI_ARGS_((Tcl_Interp *, TclQddb_Tuple *, char *, char *));

char *TclQddb_NewTable 				_ANSI_ARGS_((Tcl_Interp *, Qddb_Table *));
int TclQddb_TableSetHeaderInfo 			_ANSI_ARGS_((Tcl_Interp *, Qddb_TableHeaderInfo **, \
							     char *, char *, int));
int TclQddb_TableConfigureType 			_ANSI_ARGS_((Tcl_Interp *, Qddb_TableNode *, int, char *));
int TclQddb_TableConfigureColType 		_ANSI_ARGS_((Tcl_Interp *, Qddb_TableNode *, int, char *));
int TclQddb_TableSort 				_ANSI_ARGS_((Tcl_Interp *, Qddb_Table *, char *, char *, \
							     char **, int, char **, int));
Qddb_Table *TclQddb_GetTable 			_ANSI_ARGS_((Tcl_Interp *, char *));
Qddb_Table *TclQddb_GetTableByName		_ANSI_ARGS_((Tcl_Interp *, char *));
char *TclQddb_GetCellValue 			_ANSI_ARGS_((Qddb_TableNode *, int, \
							     Qddb_TableHeaderFormat *));
int TclQddb_TableDelete 			_ANSI_ARGS_((Tcl_Interp *, char *));
char **TclQddb_GetFormattedTable 		_ANSI_ARGS_((Tcl_Interp *, Qddb_Table *, char *, int, int));

void		TclQddb_FreeArgs		_ANSI_ARGS_((int, char **));
int		TclQddb_FindAttribute   	_ANSI_ARGS_((DataTree **, char *));
char		**TclQddb_SplitAttributeName 	_ANSI_ARGS_((char *));
char		*TclQddb_ConcatAttributeName 	_ANSI_ARGS_((char **, int));
char		**TclQddb_ParseAttr		_ANSI_ARGS_((char *));
int		TclQddb_CountAttrs		_ANSI_ARGS_((char *));
char 		*TclQddb_TreeDataToString	_ANSI_ARGS_((DataTree *));
char		*TclQddb_StringRef		_ANSI_ARGS_((TclQddb_Tuple *, TclQddb_Rows *));
DataTree 	*TclQddb_DataTreeRef		_ANSI_ARGS_((TclQddb_Tuple *, TclQddb_Rows *));
int		TclQddb_LinkVar			_ANSI_ARGS_((Tcl_Interp *, char *, char *, int, \
							     char *, DataTree *));
void		TclQddb_UnlinkVar		_ANSI_ARGS_((Tcl_Interp *, char *));
void 		TclQddb_NullOutNode		_ANSI_ARGS_((DataTree *, int));
Boolean 	TclQddb_IsEmptyDataTree		_ANSI_ARGS_((DataTree **));
DataTree 	*TclQddb_StringToTreeData	_ANSI_ARGS_((SchemaTreeNode *, char *));
int 		TclQddb_TableExprInterp 	_ANSI_ARGS_((Tcl_Interp *, Qddb_TableCalc *, \
							     Qddb_Table *, size_t, size_t, \
							     Qddb_TableDependencies **, double *));
#endif
