
/* Qddb_Tree.h
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */



#define QDDB_DATATREE_PROC_NEWINSTANCE 	0x01
#define QDDB_DATATREE_PROC_ADDNODE	0x02
#define QDDB_DATATREE_PROC_SETSEQ	0x03
#define QDDB_DATATREE_PROC_GETDATA	0x04
#define QDDB_DATATREE_PROC_SETMARK	0x05
#define QDDB_DATATREE_PROC_SETATTR	0x06

typedef struct datatree {
    enum {
	DATATREE_STRING,		/* leaf node, string   */
	DATATREE_INT,			/* leaf node, int      */
	DATATREE_REAL,			/* leaf node, real     */
	DATATREE_DATE,			/* leaf node, date     */
	DATATREE_NOVAL,			/* leaf node, no value */
	DATATREE_END,			/* END marker (arrays) */
	DATATREE_CHILDREN		/* intermediate node   */
    }			datatree_type;
    SchemaTreeNode	*datatree_schema;
    int			datatree_sequence_number;
    short		marked;		/* marked from incore */
    short		modified;	/* modified from Tcl script */
    union {
	char		*d_string;      /* datatree_string */
	int		d_int;		/* datatree_int */
	char		*d_date;	/* datatree_date */
	double		d_real;		/* datatree_real */
	struct datatree	**d_children;	/* Array of DataTree pointers */
    } un;
} DataTree;

#define datatree_string 	un.d_string
#define datatree_int    	un.d_int
#define datatree_real   	un.d_real
#define datatree_date		un.d_date
#define datatree_children 	un.d_children

void *Qddb_DataTreeProcess _ANSI_ARGS_((Schema *, DataTree **, void *, int, int));

