
/* Qddb_Table.h - defines and typedefs for Qddb tables
 *
 * Copyright (C) 1996 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */


typedef struct {
    char			*string; /* date, string */
    int				integer;
    double			real;
} Qddb_TableData;

#define QDDB_TABLE_TYPE_DEFAULT		0x00
#define QDDB_TABLE_TYPE_STRING		0x01
#define QDDB_TABLE_TYPE_DATE		0x02
#define QDDB_TABLE_TYPE_INTEGER 	0x04
#define QDDB_TABLE_TYPE_REAL		0x08
#define QDDB_TABLE_TYPE_CALC		0x10
#define QDDB_TABLE_TYPE_NULL		0x20
#define QDDB_TABLE_TYPE_USESTRING(x)	(x <= 0x02)
#define QDDB_TABLE_TYPE_USEREAL(x)	(x <= 0x10 && x >= 0x08)

#define QDDB_TABLE_ORDER_ROW		0
#define QDDB_TABLE_ORDER_COL		1


typedef struct qddb_tablecell {
    char			*row, *col;
} Qddb_TableCell;

typedef struct qddb_tablerange {
    Qddb_TableCell		from;
    Qddb_TableCell		to;
} Qddb_TableRange;

typedef struct qddb_tabledep {
    char			*table;
    Qddb_TableCell		cell;
    Qddb_TableRange		depends;
    struct qddb_tabledep 	*next;
} Qddb_TableDependencies;

typedef struct {
    int				op;
    char			*table;
    char			*strval;
    double			numval;
} Qddb_TableCalc;

typedef struct {
    int				type;		/* type of field */
    int				marked;		/* marked/unmarked during traversal */
    Qddb_TableData		data;
    Qddb_TableCalc		*compiled;	/* precompiled 'calc' field */
    char			*calc;		/* uncompiled 'calc' field */
    Qddb_TableDependencies	*refs;		/* what cells do I depend on */
} Qddb_TableDatatype;

#define QDDB_TABLE_JUSTIFY_DEFAULT	0
#define QDDB_TABLE_JUSTIFY_LEFT		1
#define QDDB_TABLE_JUSTIFY_RIGHT	2
#define QDDB_TABLE_JUSTIFY_CENTER	3
#define QDDB_TABLE_JUSTIFY_NONE		4

typedef struct {
    int				precision;
    int				justify;
    int				width;
    char			*format;
    char			*separator;
} Qddb_TableHeaderFormat;

typedef struct {
    char			*title;
    char			*name;
    char			*comment;
    char			*variable;
    Qddb_TableHeaderFormat	*print;
} Qddb_TableHeaderInfo;

typedef struct {
    Qddb_TableHeaderInfo	*info;
    Qddb_TableDatatype		data;
} Qddb_TableNode;

typedef struct {
    char			*title;
    char			*name;
    char			*comment;
    char			*variable;
    int				type;
    char			*calc;
} Qddb_TableAttrs;

typedef struct {
    size_t			row, column;
    Qddb_TableAttrs		*attrs;
} Qddb_TableSetAttr;

typedef struct {
    size_t			row, column;
    Qddb_TableNode		*data;
} Qddb_TableSetValue;

typedef struct {
    Qddb_TableDependencies	*refs;		/* external references to this table */
    Qddb_TableHeaderInfo	*info;		/* header info for table */
    Qddb_TableNode		**table;	/* table cells */
    int				order;		/* evaluation order */
    int				autoeval;	/* autoeval (on/off) */
    size_t			rows, columns;	/* number of rows/columns in table */
} Qddb_Table;

typedef struct {
    size_t			row, column;
} Qddb_TableRowCol;

typedef struct {
    char			*row, *column;
} Qddb_TableRowColNames;

typedef struct {
    size_t			from, to;
} Qddb_TableFromTo;

typedef struct {
    size_t			row, column;
    int				config_opt;
    char			*value;
} Qddb_TableConfigure;

/* Sorting */
typedef struct {
    char			*column_name;
    Boolean			ascending;
} Qddb_TableOpSortNode;
typedef struct {
    Qddb_TableOpSortNode	*sortby;
    char			*startrow, *endrow;
    size_t			number;
} Qddb_TableOpSort;

/* Join */
typedef struct {
    char			**joinby; /* column names */
} Qddb_TableOpJoin;

/* operations */
#define QDDB_TABLE_OP_DEFINE		1
#define QDDB_TABLE_OP_COPY		2
#define QDDB_TABLE_OP_COPYROW		3
#define QDDB_TABLE_OP_COPYCOL		4
#define QDDB_TABLE_OP_COPYCELL		5
#define QDDB_TABLE_OP_REMOVE		6
#define QDDB_TABLE_OP_REMOVEROW		7
#define QDDB_TABLE_OP_REMOVECOL		8
#define QDDB_TABLE_OP_INSERTROW		9
#define QDDB_TABLE_OP_INSERTCOL		10
#define QDDB_TABLE_OP_GETROWATTRS	11
#define QDDB_TABLE_OP_GETCOLATTRS	12
#define QDDB_TABLE_OP_GETCELLATTRS	13
#define QDDB_TABLE_OP_SETROWATTRS	14
#define QDDB_TABLE_OP_SETCOLATTRS	15
#define QDDB_TABLE_OP_SETCELLATTRS	16
#define QDDB_TABLE_OP_CONFIGURE		17
#define QDDB_TABLE_OP_CONFIGUREROW	18
#define QDDB_TABLE_OP_CONFIGURECOL	19
#define QDDB_TABLE_OP_CONFIGURECELL	20
#define QDDB_TABLE_OP_SORT		21
#define QDDB_TABLE_OP_CLEAR		22
#define QDDB_TABLE_OP_CLEARROW		23
#define QDDB_TABLE_OP_CLEARCOL		24
#define QDDB_TABLE_OP_CLEARCELL		25
#define QDDB_TABLE_OP_JOIN		26
#define QDDB_TABLE_OP_FINDROW		27
#define QDDB_TABLE_OP_FINDCOL		28
#define QDDB_TABLE_OP_FINDCELL		29
#define QDDB_TABLE_OP_APPEND		30
#define QDDB_TABLE_OP_SUMMARY           31

#define QDDB_TABLE_ATTR_NAME		0x01
#define QDDB_TABLE_ATTR_COMMENT		0x02
#define QDDB_TABLE_ATTR_TITLE		0x04
#define QDDB_TABLE_ATTR_VARIABLE	0x08
#define QDDB_TABLE_ATTR_VALUE		0x10
#define QDDB_TABLE_ATTR_CALC		0x20
#define QDDB_TABLE_ATTR_TYPE		0x40

/* getval options 
 */
#define QDDB_TABLE_GETVAL_STRINGS	0x0001
#define QDDB_TABLE_GETVAL_TEX		0x0002
#define QDDB_TABLE_GETVAL_HTML		0x0004
#define QDDB_TABLE_GETVAL_SGML		0x0008
#define QDDB_TABLE_GETVAL_RAW		0x0010
#define QDDB_TABLE_GETVAL_ASCII		0x0020
#define QDDB_TABLE_GETVAL_ROWHEADERS	0x0040
#define QDDB_TABLE_GETVAL_COLHEADERS	0x0080

#define QDDB_TABLE_FMT_CENTERED		0x0001
#define QDDB_TABLE_FMT_LEFTJUSTIFY	0x0002
#define QDDB_TABLE_FMT_RIGHTJUSTIFY	0x0004
#define QDDB_TABLE_FMT_WORDWRAP		0x0008

/* calculated fields
 */

#define QDDB_TABLE_CALC_OP_START 300
#define QDDB_TABLE_CALC_OP_LPAREN 300
#define QDDB_TABLE_CALC_OP_RPAREN 301
#define QDDB_TABLE_CALC_OP_COMMA 302
#define QDDB_TABLE_CALC_OP_COLON 303
#define QDDB_TABLE_CALC_OP_ATSIGN 304
#define QDDB_TABLE_CALC_OP_MOD 305
#define QDDB_TABLE_CALC_OP_PLUS 306
#define QDDB_TABLE_CALC_OP_MINUS 307
#define QDDB_TABLE_CALC_OP_MULT 308
#define QDDB_TABLE_CALC_OP_DIV 309
#define QDDB_TABLE_CALC_OP_NEGATE 310
#define QDDB_TABLE_CALC_OP_SUM 311
#define QDDB_TABLE_CALC_OP_AVG 312
#define QDDB_TABLE_CALC_OP_MIN 313
#define QDDB_TABLE_CALC_OP_MAX 314
#define QDDB_TABLE_CALC_OP_COUNT 315 
#define QDDB_TABLE_CALC_OP_STDDEV 316
#define QDDB_TABLE_CALC_OP_SQRT 317 
#define QDDB_TABLE_CALC_OP_EXP 318 
#define QDDB_TABLE_CALC_OP_LN 319 
#define QDDB_TABLE_CALC_OP_LOG 320 
#define QDDB_TABLE_CALC_OP_FLOOR 321 
#define QDDB_TABLE_CALC_OP_CEIL 322 
#define QDDB_TABLE_CALC_OP_RND 323 
#define QDDB_TABLE_CALC_OP_ROUND 324 
#define QDDB_TABLE_CALC_OP_POWER 325 
#define QDDB_TABLE_CALC_OP_PI 326
#define QDDB_TABLE_CALC_OP_ABS 327 
#define QDDB_TABLE_CALC_OP_HYPOT 328
#define QDDB_TABLE_CALC_OP_DEGREES 329 
#define QDDB_TABLE_CALC_OP_RADIANS 330
#define QDDB_TABLE_CALC_OP_SIN 331 
#define QDDB_TABLE_CALC_OP_COS 332 
#define QDDB_TABLE_CALC_OP_TAN 333
#define QDDB_TABLE_CALC_OP_ASIN 334 
#define QDDB_TABLE_CALC_OP_ACOS 335 
#define QDDB_TABLE_CALC_OP_ATAN 336 
#define QDDB_TABLE_CALC_OP_ATAN2 337
#define QDDB_TABLE_CALC_OP_THISROW 338 
#define QDDB_TABLE_CALC_OP_THISCOL 339 
#define QDDB_TABLE_CALC_OP_CELLVAL 340
#define QDDB_TABLE_CALC_OP_STRING 341
#define QDDB_TABLE_CALC_OP_CSTRING 342
#define QDDB_TABLE_CALC_OP_SVALUE 343 
#define QDDB_TABLE_CALC_OP_NVALUE 344
#define QDDB_TABLE_CALC_OP_RANGE 345 
#define QDDB_TABLE_CALC_OP_CELL 346 
#define QDDB_TABLE_CALC_OP_ROW 347 
#define QDDB_TABLE_CALC_OP_COL 348
#define QDDB_TABLE_CALC_OP_NUMBER 349
#define QDDB_TABLE_CALC_OP_LOGICAL_NOT 350
#define QDDB_TABLE_CALC_OP_EQ 351 
#define QDDB_TABLE_CALC_OP_LT 352 
#define QDDB_TABLE_CALC_OP_GT 353 
#define QDDB_TABLE_CALC_OP_LE 354 
#define QDDB_TABLE_CALC_OP_GE 355 
#define QDDB_TABLE_CALC_OP_NE 356
#define QDDB_TABLE_CALC_OP_LOGICAL_AND 357 
#define QDDB_TABLE_CALC_OP_LOGICAL_OR 358
#define QDDB_TABLE_CALC_OP_IF 359
#define QDDB_TABLE_CALC_OP_MAXROW 360
#define QDDB_TABLE_CALC_OP_MAXCOL 361
#define QDDB_TABLE_CALC_OP_PROD 362

void *Qddb_TableOp _ANSI_ARGS_((Qddb_Table *, int, void *));
Qddb_TableCalc *Qddb_GetTableParserResults _ANSI_ARGS_((void));
Qddb_TableCalc *Qddb_TableCalcParse _ANSI_ARGS_((char *));
void Qddb_ResetTableParser _ANSI_ARGS_((void));
void Qddb_ResetTableLex _ANSI_ARGS_((void));
int TableParse _ANSI_ARGS_((void));

