
/* qddb/Headers/Qddb_Search.h
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#if !defined(_QDDB_SEARCH_H_)
#define _QDDB_SEARCH_H_

#define CHUNK_SIZE	(size_t)(32*1024)
#define CHUNK_NOTFOUND  -1
#define CHUNK_UNDERFLOW	-2
#define CHUNK_OVERFLOW	-3

typedef struct {
    enum {
	REGEXP_V8, 
	NUMERIC, ALPHA, NUMERICRANGE, ALPHARANGE, ALPHAPARSE, ALPHANOPARSE
    } 			Type;
    regexp		*Reg;			/* Internal use */
    char		*Alpha; 		/* used for Regexp and String searching */
    char		*UpperStr, *LowerStr;
    double		Number;
    double		UpperNum, LowerNum;
    Boolean		UpperExists, LowerExists;
} Qddb_SearchArg;

typedef struct {
    Boolean		UpperExists, LowerExists;
    double		Upper, Lower;
} NumericRange;
    
typedef struct {
    Boolean		UpperExists, LowerExists;
    char		*Upper, *Lower;
} StringRange;

typedef struct {
    Boolean		used;
    off_t		start;
    size_t		length;
} ChunkBounds;

KeyList *Qddb_Search _ANSI_ARGS_((Schema *, Qddb_SearchArg *, size_t *, int));

KeyList *Qddb_ParseKey _ANSI_ARGS_((Schema *, char *, size_t *, Boolean, int));
KeyList *Qddb_ParseKey2 _ANSI_ARGS_((Schema *, char *, char **));
char    *Qddb_ConvertAttributeNumberToName _ANSI_ARGS_((Schema *, int));
int	Qddb_ConvertAttributeNameToNumber _ANSI_ARGS_((Schema *, char *));
int 	Qddb_HashValue _ANSI_ARGS_((Schema *, char *)); /* from Lib/LibQddb/Hash.c */
#endif
